//=============================================================================
// Bartlett Window 
//=============================================================================
#ifndef _FPU_FFT_BARTLETT_H_
#define _FPU_FFT_BARTLETT_H_

#define BARTLETT32 {\
0.00000000, 0.06451613, 0.12903226, 0.19354839, 0.25806452, \
0.32258065, 0.38709677, 0.45161290, 0.51612903, 0.58064516, \
0.64516129, 0.70967742, 0.77419355, 0.83870968, 0.90322581, \
0.96774194, } 

#define BARTLETT64 {\
0.00000000, 0.03174603, 0.06349206, 0.09523810, 0.12698413, \
0.15873016, 0.19047619, 0.22222222, 0.25396825, 0.28571429, \
0.31746032, 0.34920635, 0.38095238, 0.41269841, 0.44444444, \
0.47619048, 0.50793651, 0.53968254, 0.57142857, 0.60317460, \
0.63492063, 0.66666667, 0.69841270, 0.73015873, 0.76190476, \
0.79365079, 0.82539683, 0.85714286, 0.88888889, 0.92063492, \
0.95238095, 0.98412698, } 

#define BARTLETT128 {\
0.00000000, 0.01574803, 0.03149606, 0.04724409, 0.06299213, \
0.07874016, 0.09448819, 0.11023622, 0.12598425, 0.14173228, \
0.15748031, 0.17322835, 0.18897638, 0.20472441, 0.22047244, \
0.23622047, 0.25196850, 0.26771654, 0.28346457, 0.29921260, \
0.31496063, 0.33070866, 0.34645669, 0.36220472, 0.37795276, \
0.39370079, 0.40944882, 0.42519685, 0.44094488, 0.45669291, \
0.47244094, 0.48818898, 0.50393701, 0.51968504, 0.53543307, \
0.55118110, 0.56692913, 0.58267717, 0.59842520, 0.61417323, \
0.62992126, 0.64566929, 0.66141732, 0.67716535, 0.69291339, \
0.70866142, 0.72440945, 0.74015748, 0.75590551, 0.77165354, \
0.78740157, 0.80314961, 0.81889764, 0.83464567, 0.85039370, \
0.86614173, 0.88188976, 0.89763780, 0.91338583, 0.92913386, \
0.94488189, 0.96062992, 0.97637795, 0.99212598, } 

#define BARTLETT256 {\
0.00000000, 0.00784314, 0.01568627, 0.02352941, 0.03137255, \
0.03921569, 0.04705882, 0.05490196, 0.06274510, 0.07058824, \
0.07843137, 0.08627451, 0.09411765, 0.10196078, 0.10980392, \
0.11764706, 0.12549020, 0.13333333, 0.14117647, 0.14901961, \
0.15686275, 0.16470588, 0.17254902, 0.18039216, 0.18823529, \
0.19607843, 0.20392157, 0.21176471, 0.21960784, 0.22745098, \
0.23529412, 0.24313725, 0.25098039, 0.25882353, 0.26666667, \
0.27450980, 0.28235294, 0.29019608, 0.29803922, 0.30588235, \
0.31372549, 0.32156863, 0.32941176, 0.33725490, 0.34509804, \
0.35294118, 0.36078431, 0.36862745, 0.37647059, 0.38431373, \
0.39215686, 0.40000000, 0.40784314, 0.41568627, 0.42352941, \
0.43137255, 0.43921569, 0.44705882, 0.45490196, 0.46274510, \
0.47058824, 0.47843137, 0.48627451, 0.49411765, 0.50196078, \
0.50980392, 0.51764706, 0.52549020, 0.53333333, 0.54117647, \
0.54901961, 0.55686275, 0.56470588, 0.57254902, 0.58039216, \
0.58823529, 0.59607843, 0.60392157, 0.61176471, 0.61960784, \
0.62745098, 0.63529412, 0.64313725, 0.65098039, 0.65882353, \
0.66666667, 0.67450980, 0.68235294, 0.69019608, 0.69803922, \
0.70588235, 0.71372549, 0.72156863, 0.72941176, 0.73725490, \
0.74509804, 0.75294118, 0.76078431, 0.76862745, 0.77647059, \
0.78431373, 0.79215686, 0.80000000, 0.80784314, 0.81568627, \
0.82352941, 0.83137255, 0.83921569, 0.84705882, 0.85490196, \
0.86274510, 0.87058824, 0.87843137, 0.88627451, 0.89411765, \
0.90196078, 0.90980392, 0.91764706, 0.92549020, 0.93333333, \
0.94117647, 0.94901961, 0.95686275, 0.96470588, 0.97254902, \
0.98039216, 0.98823529, 0.99607843, } 

#define BARTLETT512 {\
0.00000000, 0.00391389, 0.00782779, 0.01174168, 0.01565558, \
0.01956947, 0.02348337, 0.02739726, 0.03131115, 0.03522505, \
0.03913894, 0.04305284, 0.04696673, 0.05088063, 0.05479452, \
0.05870841, 0.06262231, 0.06653620, 0.07045010, 0.07436399, \
0.07827789, 0.08219178, 0.08610568, 0.09001957, 0.09393346, \
0.09784736, 0.10176125, 0.10567515, 0.10958904, 0.11350294, \
0.11741683, 0.12133072, 0.12524462, 0.12915851, 0.13307241, \
0.13698630, 0.14090020, 0.14481409, 0.14872798, 0.15264188, \
0.15655577, 0.16046967, 0.16438356, 0.16829746, 0.17221135, \
0.17612524, 0.18003914, 0.18395303, 0.18786693, 0.19178082, \
0.19569472, 0.19960861, 0.20352250, 0.20743640, 0.21135029, \
0.21526419, 0.21917808, 0.22309198, 0.22700587, 0.23091977, \
0.23483366, 0.23874755, 0.24266145, 0.24657534, 0.25048924, \
0.25440313, 0.25831703, 0.26223092, 0.26614481, 0.27005871, \
0.27397260, 0.27788650, 0.28180039, 0.28571429, 0.28962818, \
0.29354207, 0.29745597, 0.30136986, 0.30528376, 0.30919765, \
0.31311155, 0.31702544, 0.32093933, 0.32485323, 0.32876712, \
0.33268102, 0.33659491, 0.34050881, 0.34442270, 0.34833659, \
0.35225049, 0.35616438, 0.36007828, 0.36399217, 0.36790607, \
0.37181996, 0.37573386, 0.37964775, 0.38356164, 0.38747554, \
0.39138943, 0.39530333, 0.39921722, 0.40313112, 0.40704501, \
0.41095890, 0.41487280, 0.41878669, 0.42270059, 0.42661448, \
0.43052838, 0.43444227, 0.43835616, 0.44227006, 0.44618395, \
0.45009785, 0.45401174, 0.45792564, 0.46183953, 0.46575342, \
0.46966732, 0.47358121, 0.47749511, 0.48140900, 0.48532290, \
0.48923679, 0.49315068, 0.49706458, 0.50097847, 0.50489237, \
0.50880626, 0.51272016, 0.51663405, 0.52054795, 0.52446184, \
0.52837573, 0.53228963, 0.53620352, 0.54011742, 0.54403131, \
0.54794521, 0.55185910, 0.55577299, 0.55968689, 0.56360078, \
0.56751468, 0.57142857, 0.57534247, 0.57925636, 0.58317025, \
0.58708415, 0.59099804, 0.59491194, 0.59882583, 0.60273973, \
0.60665362, 0.61056751, 0.61448141, 0.61839530, 0.62230920, \
0.62622309, 0.63013699, 0.63405088, 0.63796477, 0.64187867, \
0.64579256, 0.64970646, 0.65362035, 0.65753425, 0.66144814, \
0.66536204, 0.66927593, 0.67318982, 0.67710372, 0.68101761, \
0.68493151, 0.68884540, 0.69275930, 0.69667319, 0.70058708, \
0.70450098, 0.70841487, 0.71232877, 0.71624266, 0.72015656, \
0.72407045, 0.72798434, 0.73189824, 0.73581213, 0.73972603, \
0.74363992, 0.74755382, 0.75146771, 0.75538160, 0.75929550, \
0.76320939, 0.76712329, 0.77103718, 0.77495108, 0.77886497, \
0.78277886, 0.78669276, 0.79060665, 0.79452055, 0.79843444, \
0.80234834, 0.80626223, 0.81017613, 0.81409002, 0.81800391, \
0.82191781, 0.82583170, 0.82974560, 0.83365949, 0.83757339, \
0.84148728, 0.84540117, 0.84931507, 0.85322896, 0.85714286, \
0.86105675, 0.86497065, 0.86888454, 0.87279843, 0.87671233, \
0.88062622, 0.88454012, 0.88845401, 0.89236791, 0.89628180, \
0.90019569, 0.90410959, 0.90802348, 0.91193738, 0.91585127, \
0.91976517, 0.92367906, 0.92759295, 0.93150685, 0.93542074, \
0.93933464, 0.94324853, 0.94716243, 0.95107632, 0.95499022, \
0.95890411, 0.96281800, 0.96673190, 0.97064579, 0.97455969, \
0.97847358, 0.98238748, 0.98630137, 0.99021526, 0.99412916, \
0.99804305, } 

#define BARTLETT1024 {\
0.00000000, 0.00195503, 0.00391007, 0.00586510, 0.00782014, \
0.00977517, 0.01173021, 0.01368524, 0.01564027, 0.01759531, \
0.01955034, 0.02150538, 0.02346041, 0.02541544, 0.02737048, \
0.02932551, 0.03128055, 0.03323558, 0.03519062, 0.03714565, \
0.03910068, 0.04105572, 0.04301075, 0.04496579, 0.04692082, \
0.04887586, 0.05083089, 0.05278592, 0.05474096, 0.05669599, \
0.05865103, 0.06060606, 0.06256109, 0.06451613, 0.06647116, \
0.06842620, 0.07038123, 0.07233627, 0.07429130, 0.07624633, \
0.07820137, 0.08015640, 0.08211144, 0.08406647, 0.08602151, \
0.08797654, 0.08993157, 0.09188661, 0.09384164, 0.09579668, \
0.09775171, 0.09970674, 0.10166178, 0.10361681, 0.10557185, \
0.10752688, 0.10948192, 0.11143695, 0.11339198, 0.11534702, \
0.11730205, 0.11925709, 0.12121212, 0.12316716, 0.12512219, \
0.12707722, 0.12903226, 0.13098729, 0.13294233, 0.13489736, \
0.13685239, 0.13880743, 0.14076246, 0.14271750, 0.14467253, \
0.14662757, 0.14858260, 0.15053763, 0.15249267, 0.15444770, \
0.15640274, 0.15835777, 0.16031281, 0.16226784, 0.16422287, \
0.16617791, 0.16813294, 0.17008798, 0.17204301, 0.17399804, \
0.17595308, 0.17790811, 0.17986315, 0.18181818, 0.18377322, \
0.18572825, 0.18768328, 0.18963832, 0.19159335, 0.19354839, \
0.19550342, 0.19745846, 0.19941349, 0.20136852, 0.20332356, \
0.20527859, 0.20723363, 0.20918866, 0.21114370, 0.21309873, \
0.21505376, 0.21700880, 0.21896383, 0.22091887, 0.22287390, \
0.22482893, 0.22678397, 0.22873900, 0.23069404, 0.23264907, \
0.23460411, 0.23655914, 0.23851417, 0.24046921, 0.24242424, \
0.24437928, 0.24633431, 0.24828935, 0.25024438, 0.25219941, \
0.25415445, 0.25610948, 0.25806452, 0.26001955, 0.26197458, \
0.26392962, 0.26588465, 0.26783969, 0.26979472, 0.27174976, \
0.27370479, 0.27565982, 0.27761486, 0.27956989, 0.28152493, \
0.28347996, 0.28543500, 0.28739003, 0.28934506, 0.29130010, \
0.29325513, 0.29521017, 0.29716520, 0.29912023, 0.30107527, \
0.30303030, 0.30498534, 0.30694037, 0.30889541, 0.31085044, \
0.31280547, 0.31476051, 0.31671554, 0.31867058, 0.32062561, \
0.32258065, 0.32453568, 0.32649071, 0.32844575, 0.33040078, \
0.33235582, 0.33431085, 0.33626588, 0.33822092, 0.34017595, \
0.34213099, 0.34408602, 0.34604106, 0.34799609, 0.34995112, \
0.35190616, 0.35386119, 0.35581623, 0.35777126, 0.35972630, \
0.36168133, 0.36363636, 0.36559140, 0.36754643, 0.36950147, \
0.37145650, 0.37341153, 0.37536657, 0.37732160, 0.37927664, \
0.38123167, 0.38318671, 0.38514174, 0.38709677, 0.38905181, \
0.39100684, 0.39296188, 0.39491691, 0.39687195, 0.39882698, \
0.40078201, 0.40273705, 0.40469208, 0.40664712, 0.40860215, \
0.41055718, 0.41251222, 0.41446725, 0.41642229, 0.41837732, \
0.42033236, 0.42228739, 0.42424242, 0.42619746, 0.42815249, \
0.43010753, 0.43206256, 0.43401760, 0.43597263, 0.43792766, \
0.43988270, 0.44183773, 0.44379277, 0.44574780, 0.44770283, \
0.44965787, 0.45161290, 0.45356794, 0.45552297, 0.45747801, \
0.45943304, 0.46138807, 0.46334311, 0.46529814, 0.46725318, \
0.46920821, 0.47116325, 0.47311828, 0.47507331, 0.47702835, \
0.47898338, 0.48093842, 0.48289345, 0.48484848, 0.48680352, \
0.48875855, 0.49071359, 0.49266862, 0.49462366, 0.49657869, \
0.49853372, 0.50048876, 0.50244379, 0.50439883, 0.50635386, \
0.50830890, 0.51026393, 0.51221896, 0.51417400, 0.51612903, \
0.51808407, 0.52003910, 0.52199413, 0.52394917, 0.52590420, \
0.52785924, 0.52981427, 0.53176931, 0.53372434, 0.53567937, \
0.53763441, 0.53958944, 0.54154448, 0.54349951, 0.54545455, \
0.54740958, 0.54936461, 0.55131965, 0.55327468, 0.55522972, \
0.55718475, 0.55913978, 0.56109482, 0.56304985, 0.56500489, \
0.56695992, 0.56891496, 0.57086999, 0.57282502, 0.57478006, \
0.57673509, 0.57869013, 0.58064516, 0.58260020, 0.58455523, \
0.58651026, 0.58846530, 0.59042033, 0.59237537, 0.59433040, \
0.59628543, 0.59824047, 0.60019550, 0.60215054, 0.60410557, \
0.60606061, 0.60801564, 0.60997067, 0.61192571, 0.61388074, \
0.61583578, 0.61779081, 0.61974585, 0.62170088, 0.62365591, \
0.62561095, 0.62756598, 0.62952102, 0.63147605, 0.63343109, \
0.63538612, 0.63734115, 0.63929619, 0.64125122, 0.64320626, \
0.64516129, 0.64711632, 0.64907136, 0.65102639, 0.65298143, \
0.65493646, 0.65689150, 0.65884653, 0.66080156, 0.66275660, \
0.66471163, 0.66666667, 0.66862170, 0.67057674, 0.67253177, \
0.67448680, 0.67644184, 0.67839687, 0.68035191, 0.68230694, \
0.68426197, 0.68621701, 0.68817204, 0.69012708, 0.69208211, \
0.69403715, 0.69599218, 0.69794721, 0.69990225, 0.70185728, \
0.70381232, 0.70576735, 0.70772239, 0.70967742, 0.71163245, \
0.71358749, 0.71554252, 0.71749756, 0.71945259, 0.72140762, \
0.72336266, 0.72531769, 0.72727273, 0.72922776, 0.73118280, \
0.73313783, 0.73509286, 0.73704790, 0.73900293, 0.74095797, \
0.74291300, 0.74486804, 0.74682307, 0.74877810, 0.75073314, \
0.75268817, 0.75464321, 0.75659824, 0.75855327, 0.76050831, \
0.76246334, 0.76441838, 0.76637341, 0.76832845, 0.77028348, \
0.77223851, 0.77419355, 0.77614858, 0.77810362, 0.78005865, \
0.78201369, 0.78396872, 0.78592375, 0.78787879, 0.78983382, \
0.79178886, 0.79374389, 0.79569892, 0.79765396, 0.79960899, \
0.80156403, 0.80351906, 0.80547410, 0.80742913, 0.80938416, \
0.81133920, 0.81329423, 0.81524927, 0.81720430, 0.81915934, \
0.82111437, 0.82306940, 0.82502444, 0.82697947, 0.82893451, \
0.83088954, 0.83284457, 0.83479961, 0.83675464, 0.83870968, \
0.84066471, 0.84261975, 0.84457478, 0.84652981, 0.84848485, \
0.85043988, 0.85239492, 0.85434995, 0.85630499, 0.85826002, \
0.86021505, 0.86217009, 0.86412512, 0.86608016, 0.86803519, \
0.86999022, 0.87194526, 0.87390029, 0.87585533, 0.87781036, \
0.87976540, 0.88172043, 0.88367546, 0.88563050, 0.88758553, \
0.88954057, 0.89149560, 0.89345064, 0.89540567, 0.89736070, \
0.89931574, 0.90127077, 0.90322581, 0.90518084, 0.90713587, \
0.90909091, 0.91104594, 0.91300098, 0.91495601, 0.91691105, \
0.91886608, 0.92082111, 0.92277615, 0.92473118, 0.92668622, \
0.92864125, 0.93059629, 0.93255132, 0.93450635, 0.93646139, \
0.93841642, 0.94037146, 0.94232649, 0.94428152, 0.94623656, \
0.94819159, 0.95014663, 0.95210166, 0.95405670, 0.95601173, \
0.95796676, 0.95992180, 0.96187683, 0.96383187, 0.96578690, \
0.96774194, 0.96969697, 0.97165200, 0.97360704, 0.97556207, \
0.97751711, 0.97947214, 0.98142717, 0.98338221, 0.98533724, \
0.98729228, 0.98924731, 0.99120235, 0.99315738, 0.99511241, \
0.99706745, 0.99902248, } 

#define BARTLETT2048 {\
0.00000000, 0.00097704, 0.00195408, 0.00293112, 0.00390816, \
0.00488520, 0.00586224, 0.00683928, 0.00781632, 0.00879336, \
0.00977040, 0.01074744, 0.01172447, 0.01270151, 0.01367855, \
0.01465559, 0.01563263, 0.01660967, 0.01758671, 0.01856375, \
0.01954079, 0.02051783, 0.02149487, 0.02247191, 0.02344895, \
0.02442599, 0.02540303, 0.02638007, 0.02735711, 0.02833415, \
0.02931119, 0.03028823, 0.03126527, 0.03224231, 0.03321935, \
0.03419638, 0.03517342, 0.03615046, 0.03712750, 0.03810454, \
0.03908158, 0.04005862, 0.04103566, 0.04201270, 0.04298974, \
0.04396678, 0.04494382, 0.04592086, 0.04689790, 0.04787494, \
0.04885198, 0.04982902, 0.05080606, 0.05178310, 0.05276014, \
0.05373718, 0.05471422, 0.05569126, 0.05666830, 0.05764533, \
0.05862237, 0.05959941, 0.06057645, 0.06155349, 0.06253053, \
0.06350757, 0.06448461, 0.06546165, 0.06643869, 0.06741573, \
0.06839277, 0.06936981, 0.07034685, 0.07132389, 0.07230093, \
0.07327797, 0.07425501, 0.07523205, 0.07620909, 0.07718613, \
0.07816317, 0.07914021, 0.08011724, 0.08109428, 0.08207132, \
0.08304836, 0.08402540, 0.08500244, 0.08597948, 0.08695652, \
0.08793356, 0.08891060, 0.08988764, 0.09086468, 0.09184172, \
0.09281876, 0.09379580, 0.09477284, 0.09574988, 0.09672692, \
0.09770396, 0.09868100, 0.09965804, 0.10063508, 0.10161212, \
0.10258915, 0.10356619, 0.10454323, 0.10552027, 0.10649731, \
0.10747435, 0.10845139, 0.10942843, 0.11040547, 0.11138251, \
0.11235955, 0.11333659, 0.11431363, 0.11529067, 0.11626771, \
0.11724475, 0.11822179, 0.11919883, 0.12017587, 0.12115291, \
0.12212995, 0.12310699, 0.12408403, 0.12506106, 0.12603810, \
0.12701514, 0.12799218, 0.12896922, 0.12994626, 0.13092330, \
0.13190034, 0.13287738, 0.13385442, 0.13483146, 0.13580850, \
0.13678554, 0.13776258, 0.13873962, 0.13971666, 0.14069370, \
0.14167074, 0.14264778, 0.14362482, 0.14460186, 0.14557890, \
0.14655594, 0.14753298, 0.14851001, 0.14948705, 0.15046409, \
0.15144113, 0.15241817, 0.15339521, 0.15437225, 0.15534929, \
0.15632633, 0.15730337, 0.15828041, 0.15925745, 0.16023449, \
0.16121153, 0.16218857, 0.16316561, 0.16414265, 0.16511969, \
0.16609673, 0.16707377, 0.16805081, 0.16902785, 0.17000489, \
0.17098192, 0.17195896, 0.17293600, 0.17391304, 0.17489008, \
0.17586712, 0.17684416, 0.17782120, 0.17879824, 0.17977528, \
0.18075232, 0.18172936, 0.18270640, 0.18368344, 0.18466048, \
0.18563752, 0.18661456, 0.18759160, 0.18856864, 0.18954568, \
0.19052272, 0.19149976, 0.19247680, 0.19345383, 0.19443087, \
0.19540791, 0.19638495, 0.19736199, 0.19833903, 0.19931607, \
0.20029311, 0.20127015, 0.20224719, 0.20322423, 0.20420127, \
0.20517831, 0.20615535, 0.20713239, 0.20810943, 0.20908647, \
0.21006351, 0.21104055, 0.21201759, 0.21299463, 0.21397167, \
0.21494871, 0.21592574, 0.21690278, 0.21787982, 0.21885686, \
0.21983390, 0.22081094, 0.22178798, 0.22276502, 0.22374206, \
0.22471910, 0.22569614, 0.22667318, 0.22765022, 0.22862726, \
0.22960430, 0.23058134, 0.23155838, 0.23253542, 0.23351246, \
0.23448950, 0.23546654, 0.23644358, 0.23742062, 0.23839766, \
0.23937469, 0.24035173, 0.24132877, 0.24230581, 0.24328285, \
0.24425989, 0.24523693, 0.24621397, 0.24719101, 0.24816805, \
0.24914509, 0.25012213, 0.25109917, 0.25207621, 0.25305325, \
0.25403029, 0.25500733, 0.25598437, 0.25696141, 0.25793845, \
0.25891549, 0.25989253, 0.26086957, 0.26184660, 0.26282364, \
0.26380068, 0.26477772, 0.26575476, 0.26673180, 0.26770884, \
0.26868588, 0.26966292, 0.27063996, 0.27161700, 0.27259404, \
0.27357108, 0.27454812, 0.27552516, 0.27650220, 0.27747924, \
0.27845628, 0.27943332, 0.28041036, 0.28138740, 0.28236444, \
0.28334148, 0.28431851, 0.28529555, 0.28627259, 0.28724963, \
0.28822667, 0.28920371, 0.29018075, 0.29115779, 0.29213483, \
0.29311187, 0.29408891, 0.29506595, 0.29604299, 0.29702003, \
0.29799707, 0.29897411, 0.29995115, 0.30092819, 0.30190523, \
0.30288227, 0.30385931, 0.30483635, 0.30581339, 0.30679043, \
0.30776746, 0.30874450, 0.30972154, 0.31069858, 0.31167562, \
0.31265266, 0.31362970, 0.31460674, 0.31558378, 0.31656082, \
0.31753786, 0.31851490, 0.31949194, 0.32046898, 0.32144602, \
0.32242306, 0.32340010, 0.32437714, 0.32535418, 0.32633122, \
0.32730826, 0.32828530, 0.32926234, 0.33023937, 0.33121641, \
0.33219345, 0.33317049, 0.33414753, 0.33512457, 0.33610161, \
0.33707865, 0.33805569, 0.33903273, 0.34000977, 0.34098681, \
0.34196385, 0.34294089, 0.34391793, 0.34489497, 0.34587201, \
0.34684905, 0.34782609, 0.34880313, 0.34978017, 0.35075721, \
0.35173425, 0.35271128, 0.35368832, 0.35466536, 0.35564240, \
0.35661944, 0.35759648, 0.35857352, 0.35955056, 0.36052760, \
0.36150464, 0.36248168, 0.36345872, 0.36443576, 0.36541280, \
0.36638984, 0.36736688, 0.36834392, 0.36932096, 0.37029800, \
0.37127504, 0.37225208, 0.37322912, 0.37420616, 0.37518319, \
0.37616023, 0.37713727, 0.37811431, 0.37909135, 0.38006839, \
0.38104543, 0.38202247, 0.38299951, 0.38397655, 0.38495359, \
0.38593063, 0.38690767, 0.38788471, 0.38886175, 0.38983879, \
0.39081583, 0.39179287, 0.39276991, 0.39374695, 0.39472399, \
0.39570103, 0.39667807, 0.39765511, 0.39863214, 0.39960918, \
0.40058622, 0.40156326, 0.40254030, 0.40351734, 0.40449438, \
0.40547142, 0.40644846, 0.40742550, 0.40840254, 0.40937958, \
0.41035662, 0.41133366, 0.41231070, 0.41328774, 0.41426478, \
0.41524182, 0.41621886, 0.41719590, 0.41817294, 0.41914998, \
0.42012702, 0.42110405, 0.42208109, 0.42305813, 0.42403517, \
0.42501221, 0.42598925, 0.42696629, 0.42794333, 0.42892037, \
0.42989741, 0.43087445, 0.43185149, 0.43282853, 0.43380557, \
0.43478261, 0.43575965, 0.43673669, 0.43771373, 0.43869077, \
0.43966781, 0.44064485, 0.44162189, 0.44259893, 0.44357596, \
0.44455300, 0.44553004, 0.44650708, 0.44748412, 0.44846116, \
0.44943820, 0.45041524, 0.45139228, 0.45236932, 0.45334636, \
0.45432340, 0.45530044, 0.45627748, 0.45725452, 0.45823156, \
0.45920860, 0.46018564, 0.46116268, 0.46213972, 0.46311676, \
0.46409380, 0.46507084, 0.46604787, 0.46702491, 0.46800195, \
0.46897899, 0.46995603, 0.47093307, 0.47191011, 0.47288715, \
0.47386419, 0.47484123, 0.47581827, 0.47679531, 0.47777235, \
0.47874939, 0.47972643, 0.48070347, 0.48168051, 0.48265755, \
0.48363459, 0.48461163, 0.48558867, 0.48656571, 0.48754275, \
0.48851979, 0.48949682, 0.49047386, 0.49145090, 0.49242794, \
0.49340498, 0.49438202, 0.49535906, 0.49633610, 0.49731314, \
0.49829018, 0.49926722, 0.50024426, 0.50122130, 0.50219834, \
0.50317538, 0.50415242, 0.50512946, 0.50610650, 0.50708354, \
0.50806058, 0.50903762, 0.51001466, 0.51099170, 0.51196873, \
0.51294577, 0.51392281, 0.51489985, 0.51587689, 0.51685393, \
0.51783097, 0.51880801, 0.51978505, 0.52076209, 0.52173913, \
0.52271617, 0.52369321, 0.52467025, 0.52564729, 0.52662433, \
0.52760137, 0.52857841, 0.52955545, 0.53053249, 0.53150953, \
0.53248657, 0.53346361, 0.53444064, 0.53541768, 0.53639472, \
0.53737176, 0.53834880, 0.53932584, 0.54030288, 0.54127992, \
0.54225696, 0.54323400, 0.54421104, 0.54518808, 0.54616512, \
0.54714216, 0.54811920, 0.54909624, 0.55007328, 0.55105032, \
0.55202736, 0.55300440, 0.55398144, 0.55495848, 0.55593552, \
0.55691255, 0.55788959, 0.55886663, 0.55984367, 0.56082071, \
0.56179775, 0.56277479, 0.56375183, 0.56472887, 0.56570591, \
0.56668295, 0.56765999, 0.56863703, 0.56961407, 0.57059111, \
0.57156815, 0.57254519, 0.57352223, 0.57449927, 0.57547631, \
0.57645335, 0.57743039, 0.57840743, 0.57938447, 0.58036150, \
0.58133854, 0.58231558, 0.58329262, 0.58426966, 0.58524670, \
0.58622374, 0.58720078, 0.58817782, 0.58915486, 0.59013190, \
0.59110894, 0.59208598, 0.59306302, 0.59404006, 0.59501710, \
0.59599414, 0.59697118, 0.59794822, 0.59892526, 0.59990230, \
0.60087934, 0.60185638, 0.60283341, 0.60381045, 0.60478749, \
0.60576453, 0.60674157, 0.60771861, 0.60869565, 0.60967269, \
0.61064973, 0.61162677, 0.61260381, 0.61358085, 0.61455789, \
0.61553493, 0.61651197, 0.61748901, 0.61846605, 0.61944309, \
0.62042013, 0.62139717, 0.62237421, 0.62335125, 0.62432829, \
0.62530532, 0.62628236, 0.62725940, 0.62823644, 0.62921348, \
0.63019052, 0.63116756, 0.63214460, 0.63312164, 0.63409868, \
0.63507572, 0.63605276, 0.63702980, 0.63800684, 0.63898388, \
0.63996092, 0.64093796, 0.64191500, 0.64289204, 0.64386908, \
0.64484612, 0.64582316, 0.64680020, 0.64777723, 0.64875427, \
0.64973131, 0.65070835, 0.65168539, 0.65266243, 0.65363947, \
0.65461651, 0.65559355, 0.65657059, 0.65754763, 0.65852467, \
0.65950171, 0.66047875, 0.66145579, 0.66243283, 0.66340987, \
0.66438691, 0.66536395, 0.66634099, 0.66731803, 0.66829507, \
0.66927211, 0.67024915, 0.67122618, 0.67220322, 0.67318026, \
0.67415730, 0.67513434, 0.67611138, 0.67708842, 0.67806546, \
0.67904250, 0.68001954, 0.68099658, 0.68197362, 0.68295066, \
0.68392770, 0.68490474, 0.68588178, 0.68685882, 0.68783586, \
0.68881290, 0.68978994, 0.69076698, 0.69174402, 0.69272106, \
0.69369809, 0.69467513, 0.69565217, 0.69662921, 0.69760625, \
0.69858329, 0.69956033, 0.70053737, 0.70151441, 0.70249145, \
0.70346849, 0.70444553, 0.70542257, 0.70639961, 0.70737665, \
0.70835369, 0.70933073, 0.71030777, 0.71128481, 0.71226185, \
0.71323889, 0.71421593, 0.71519297, 0.71617000, 0.71714704, \
0.71812408, 0.71910112, 0.72007816, 0.72105520, 0.72203224, \
0.72300928, 0.72398632, 0.72496336, 0.72594040, 0.72691744, \
0.72789448, 0.72887152, 0.72984856, 0.73082560, 0.73180264, \
0.73277968, 0.73375672, 0.73473376, 0.73571080, 0.73668784, \
0.73766488, 0.73864191, 0.73961895, 0.74059599, 0.74157303, \
0.74255007, 0.74352711, 0.74450415, 0.74548119, 0.74645823, \
0.74743527, 0.74841231, 0.74938935, 0.75036639, 0.75134343, \
0.75232047, 0.75329751, 0.75427455, 0.75525159, 0.75622863, \
0.75720567, 0.75818271, 0.75915975, 0.76013679, 0.76111383, \
0.76209086, 0.76306790, 0.76404494, 0.76502198, 0.76599902, \
0.76697606, 0.76795310, 0.76893014, 0.76990718, 0.77088422, \
0.77186126, 0.77283830, 0.77381534, 0.77479238, 0.77576942, \
0.77674646, 0.77772350, 0.77870054, 0.77967758, 0.78065462, \
0.78163166, 0.78260870, 0.78358574, 0.78456277, 0.78553981, \
0.78651685, 0.78749389, 0.78847093, 0.78944797, 0.79042501, \
0.79140205, 0.79237909, 0.79335613, 0.79433317, 0.79531021, \
0.79628725, 0.79726429, 0.79824133, 0.79921837, 0.80019541, \
0.80117245, 0.80214949, 0.80312653, 0.80410357, 0.80508061, \
0.80605765, 0.80703468, 0.80801172, 0.80898876, 0.80996580, \
0.81094284, 0.81191988, 0.81289692, 0.81387396, 0.81485100, \
0.81582804, 0.81680508, 0.81778212, 0.81875916, 0.81973620, \
0.82071324, 0.82169028, 0.82266732, 0.82364436, 0.82462140, \
0.82559844, 0.82657548, 0.82755252, 0.82852956, 0.82950660, \
0.83048363, 0.83146067, 0.83243771, 0.83341475, 0.83439179, \
0.83536883, 0.83634587, 0.83732291, 0.83829995, 0.83927699, \
0.84025403, 0.84123107, 0.84220811, 0.84318515, 0.84416219, \
0.84513923, 0.84611627, 0.84709331, 0.84807035, 0.84904739, \
0.85002443, 0.85100147, 0.85197851, 0.85295554, 0.85393258, \
0.85490962, 0.85588666, 0.85686370, 0.85784074, 0.85881778, \
0.85979482, 0.86077186, 0.86174890, 0.86272594, 0.86370298, \
0.86468002, 0.86565706, 0.86663410, 0.86761114, 0.86858818, \
0.86956522, 0.87054226, 0.87151930, 0.87249634, 0.87347338, \
0.87445042, 0.87542745, 0.87640449, 0.87738153, 0.87835857, \
0.87933561, 0.88031265, 0.88128969, 0.88226673, 0.88324377, \
0.88422081, 0.88519785, 0.88617489, 0.88715193, 0.88812897, \
0.88910601, 0.89008305, 0.89106009, 0.89203713, 0.89301417, \
0.89399121, 0.89496825, 0.89594529, 0.89692233, 0.89789936, \
0.89887640, 0.89985344, 0.90083048, 0.90180752, 0.90278456, \
0.90376160, 0.90473864, 0.90571568, 0.90669272, 0.90766976, \
0.90864680, 0.90962384, 0.91060088, 0.91157792, 0.91255496, \
0.91353200, 0.91450904, 0.91548608, 0.91646312, 0.91744016, \
0.91841720, 0.91939424, 0.92037128, 0.92134831, 0.92232535, \
0.92330239, 0.92427943, 0.92525647, 0.92623351, 0.92721055, \
0.92818759, 0.92916463, 0.93014167, 0.93111871, 0.93209575, \
0.93307279, 0.93404983, 0.93502687, 0.93600391, 0.93698095, \
0.93795799, 0.93893503, 0.93991207, 0.94088911, 0.94186615, \
0.94284319, 0.94382022, 0.94479726, 0.94577430, 0.94675134, \
0.94772838, 0.94870542, 0.94968246, 0.95065950, 0.95163654, \
0.95261358, 0.95359062, 0.95456766, 0.95554470, 0.95652174, \
0.95749878, 0.95847582, 0.95945286, 0.96042990, 0.96140694, \
0.96238398, 0.96336102, 0.96433806, 0.96531510, 0.96629213, \
0.96726917, 0.96824621, 0.96922325, 0.97020029, 0.97117733, \
0.97215437, 0.97313141, 0.97410845, 0.97508549, 0.97606253, \
0.97703957, 0.97801661, 0.97899365, 0.97997069, 0.98094773, \
0.98192477, 0.98290181, 0.98387885, 0.98485589, 0.98583293, \
0.98680997, 0.98778701, 0.98876404, 0.98974108, 0.99071812, \
0.99169516, 0.99267220, 0.99364924, 0.99462628, 0.99560332, \
0.99658036, 0.99755740, 0.99853444, 0.99951148, } 

#define BARTLETT4096 {\
0.00000000, 0.00048840, 0.00097680, 0.00146520, 0.00195360, \
0.00244200, 0.00293040, 0.00341880, 0.00390720, 0.00439560, \
0.00488400, 0.00537241, 0.00586081, 0.00634921, 0.00683761, \
0.00732601, 0.00781441, 0.00830281, 0.00879121, 0.00927961, \
0.00976801, 0.01025641, 0.01074481, 0.01123321, 0.01172161, \
0.01221001, 0.01269841, 0.01318681, 0.01367521, 0.01416361, \
0.01465201, 0.01514042, 0.01562882, 0.01611722, 0.01660562, \
0.01709402, 0.01758242, 0.01807082, 0.01855922, 0.01904762, \
0.01953602, 0.02002442, 0.02051282, 0.02100122, 0.02148962, \
0.02197802, 0.02246642, 0.02295482, 0.02344322, 0.02393162, \
0.02442002, 0.02490842, 0.02539683, 0.02588523, 0.02637363, \
0.02686203, 0.02735043, 0.02783883, 0.02832723, 0.02881563, \
0.02930403, 0.02979243, 0.03028083, 0.03076923, 0.03125763, \
0.03174603, 0.03223443, 0.03272283, 0.03321123, 0.03369963, \
0.03418803, 0.03467643, 0.03516484, 0.03565324, 0.03614164, \
0.03663004, 0.03711844, 0.03760684, 0.03809524, 0.03858364, \
0.03907204, 0.03956044, 0.04004884, 0.04053724, 0.04102564, \
0.04151404, 0.04200244, 0.04249084, 0.04297924, 0.04346764, \
0.04395604, 0.04444444, 0.04493284, 0.04542125, 0.04590965, \
0.04639805, 0.04688645, 0.04737485, 0.04786325, 0.04835165, \
0.04884005, 0.04932845, 0.04981685, 0.05030525, 0.05079365, \
0.05128205, 0.05177045, 0.05225885, 0.05274725, 0.05323565, \
0.05372405, 0.05421245, 0.05470085, 0.05518926, 0.05567766, \
0.05616606, 0.05665446, 0.05714286, 0.05763126, 0.05811966, \
0.05860806, 0.05909646, 0.05958486, 0.06007326, 0.06056166, \
0.06105006, 0.06153846, 0.06202686, 0.06251526, 0.06300366, \
0.06349206, 0.06398046, 0.06446886, 0.06495726, 0.06544567, \
0.06593407, 0.06642247, 0.06691087, 0.06739927, 0.06788767, \
0.06837607, 0.06886447, 0.06935287, 0.06984127, 0.07032967, \
0.07081807, 0.07130647, 0.07179487, 0.07228327, 0.07277167, \
0.07326007, 0.07374847, 0.07423687, 0.07472527, 0.07521368, \
0.07570208, 0.07619048, 0.07667888, 0.07716728, 0.07765568, \
0.07814408, 0.07863248, 0.07912088, 0.07960928, 0.08009768, \
0.08058608, 0.08107448, 0.08156288, 0.08205128, 0.08253968, \
0.08302808, 0.08351648, 0.08400488, 0.08449328, 0.08498168, \
0.08547009, 0.08595849, 0.08644689, 0.08693529, 0.08742369, \
0.08791209, 0.08840049, 0.08888889, 0.08937729, 0.08986569, \
0.09035409, 0.09084249, 0.09133089, 0.09181929, 0.09230769, \
0.09279609, 0.09328449, 0.09377289, 0.09426129, 0.09474969, \
0.09523810, 0.09572650, 0.09621490, 0.09670330, 0.09719170, \
0.09768010, 0.09816850, 0.09865690, 0.09914530, 0.09963370, \
0.10012210, 0.10061050, 0.10109890, 0.10158730, 0.10207570, \
0.10256410, 0.10305250, 0.10354090, 0.10402930, 0.10451770, \
0.10500611, 0.10549451, 0.10598291, 0.10647131, 0.10695971, \
0.10744811, 0.10793651, 0.10842491, 0.10891331, 0.10940171, \
0.10989011, 0.11037851, 0.11086691, 0.11135531, 0.11184371, \
0.11233211, 0.11282051, 0.11330891, 0.11379731, 0.11428571, \
0.11477411, 0.11526252, 0.11575092, 0.11623932, 0.11672772, \
0.11721612, 0.11770452, 0.11819292, 0.11868132, 0.11916972, \
0.11965812, 0.12014652, 0.12063492, 0.12112332, 0.12161172, \
0.12210012, 0.12258852, 0.12307692, 0.12356532, 0.12405372, \
0.12454212, 0.12503053, 0.12551893, 0.12600733, 0.12649573, \
0.12698413, 0.12747253, 0.12796093, 0.12844933, 0.12893773, \
0.12942613, 0.12991453, 0.13040293, 0.13089133, 0.13137973, \
0.13186813, 0.13235653, 0.13284493, 0.13333333, 0.13382173, \
0.13431013, 0.13479853, 0.13528694, 0.13577534, 0.13626374, \
0.13675214, 0.13724054, 0.13772894, 0.13821734, 0.13870574, \
0.13919414, 0.13968254, 0.14017094, 0.14065934, 0.14114774, \
0.14163614, 0.14212454, 0.14261294, 0.14310134, 0.14358974, \
0.14407814, 0.14456654, 0.14505495, 0.14554335, 0.14603175, \
0.14652015, 0.14700855, 0.14749695, 0.14798535, 0.14847375, \
0.14896215, 0.14945055, 0.14993895, 0.15042735, 0.15091575, \
0.15140415, 0.15189255, 0.15238095, 0.15286935, 0.15335775, \
0.15384615, 0.15433455, 0.15482295, 0.15531136, 0.15579976, \
0.15628816, 0.15677656, 0.15726496, 0.15775336, 0.15824176, \
0.15873016, 0.15921856, 0.15970696, 0.16019536, 0.16068376, \
0.16117216, 0.16166056, 0.16214896, 0.16263736, 0.16312576, \
0.16361416, 0.16410256, 0.16459096, 0.16507937, 0.16556777, \
0.16605617, 0.16654457, 0.16703297, 0.16752137, 0.16800977, \
0.16849817, 0.16898657, 0.16947497, 0.16996337, 0.17045177, \
0.17094017, 0.17142857, 0.17191697, 0.17240537, 0.17289377, \
0.17338217, 0.17387057, 0.17435897, 0.17484737, 0.17533578, \
0.17582418, 0.17631258, 0.17680098, 0.17728938, 0.17777778, \
0.17826618, 0.17875458, 0.17924298, 0.17973138, 0.18021978, \
0.18070818, 0.18119658, 0.18168498, 0.18217338, 0.18266178, \
0.18315018, 0.18363858, 0.18412698, 0.18461538, 0.18510379, \
0.18559219, 0.18608059, 0.18656899, 0.18705739, 0.18754579, \
0.18803419, 0.18852259, 0.18901099, 0.18949939, 0.18998779, \
0.19047619, 0.19096459, 0.19145299, 0.19194139, 0.19242979, \
0.19291819, 0.19340659, 0.19389499, 0.19438339, 0.19487179, \
0.19536020, 0.19584860, 0.19633700, 0.19682540, 0.19731380, \
0.19780220, 0.19829060, 0.19877900, 0.19926740, 0.19975580, \
0.20024420, 0.20073260, 0.20122100, 0.20170940, 0.20219780, \
0.20268620, 0.20317460, 0.20366300, 0.20415140, 0.20463980, \
0.20512821, 0.20561661, 0.20610501, 0.20659341, 0.20708181, \
0.20757021, 0.20805861, 0.20854701, 0.20903541, 0.20952381, \
0.21001221, 0.21050061, 0.21098901, 0.21147741, 0.21196581, \
0.21245421, 0.21294261, 0.21343101, 0.21391941, 0.21440781, \
0.21489621, 0.21538462, 0.21587302, 0.21636142, 0.21684982, \
0.21733822, 0.21782662, 0.21831502, 0.21880342, 0.21929182, \
0.21978022, 0.22026862, 0.22075702, 0.22124542, 0.22173382, \
0.22222222, 0.22271062, 0.22319902, 0.22368742, 0.22417582, \
0.22466422, 0.22515263, 0.22564103, 0.22612943, 0.22661783, \
0.22710623, 0.22759463, 0.22808303, 0.22857143, 0.22905983, \
0.22954823, 0.23003663, 0.23052503, 0.23101343, 0.23150183, \
0.23199023, 0.23247863, 0.23296703, 0.23345543, 0.23394383, \
0.23443223, 0.23492063, 0.23540904, 0.23589744, 0.23638584, \
0.23687424, 0.23736264, 0.23785104, 0.23833944, 0.23882784, \
0.23931624, 0.23980464, 0.24029304, 0.24078144, 0.24126984, \
0.24175824, 0.24224664, 0.24273504, 0.24322344, 0.24371184, \
0.24420024, 0.24468864, 0.24517705, 0.24566545, 0.24615385, \
0.24664225, 0.24713065, 0.24761905, 0.24810745, 0.24859585, \
0.24908425, 0.24957265, 0.25006105, 0.25054945, 0.25103785, \
0.25152625, 0.25201465, 0.25250305, 0.25299145, 0.25347985, \
0.25396825, 0.25445665, 0.25494505, 0.25543346, 0.25592186, \
0.25641026, 0.25689866, 0.25738706, 0.25787546, 0.25836386, \
0.25885226, 0.25934066, 0.25982906, 0.26031746, 0.26080586, \
0.26129426, 0.26178266, 0.26227106, 0.26275946, 0.26324786, \
0.26373626, 0.26422466, 0.26471306, 0.26520147, 0.26568987, \
0.26617827, 0.26666667, 0.26715507, 0.26764347, 0.26813187, \
0.26862027, 0.26910867, 0.26959707, 0.27008547, 0.27057387, \
0.27106227, 0.27155067, 0.27203907, 0.27252747, 0.27301587, \
0.27350427, 0.27399267, 0.27448107, 0.27496947, 0.27545788, \
0.27594628, 0.27643468, 0.27692308, 0.27741148, 0.27789988, \
0.27838828, 0.27887668, 0.27936508, 0.27985348, 0.28034188, \
0.28083028, 0.28131868, 0.28180708, 0.28229548, 0.28278388, \
0.28327228, 0.28376068, 0.28424908, 0.28473748, 0.28522589, \
0.28571429, 0.28620269, 0.28669109, 0.28717949, 0.28766789, \
0.28815629, 0.28864469, 0.28913309, 0.28962149, 0.29010989, \
0.29059829, 0.29108669, 0.29157509, 0.29206349, 0.29255189, \
0.29304029, 0.29352869, 0.29401709, 0.29450549, 0.29499389, \
0.29548230, 0.29597070, 0.29645910, 0.29694750, 0.29743590, \
0.29792430, 0.29841270, 0.29890110, 0.29938950, 0.29987790, \
0.30036630, 0.30085470, 0.30134310, 0.30183150, 0.30231990, \
0.30280830, 0.30329670, 0.30378510, 0.30427350, 0.30476190, \
0.30525031, 0.30573871, 0.30622711, 0.30671551, 0.30720391, \
0.30769231, 0.30818071, 0.30866911, 0.30915751, 0.30964591, \
0.31013431, 0.31062271, 0.31111111, 0.31159951, 0.31208791, \
0.31257631, 0.31306471, 0.31355311, 0.31404151, 0.31452991, \
0.31501832, 0.31550672, 0.31599512, 0.31648352, 0.31697192, \
0.31746032, 0.31794872, 0.31843712, 0.31892552, 0.31941392, \
0.31990232, 0.32039072, 0.32087912, 0.32136752, 0.32185592, \
0.32234432, 0.32283272, 0.32332112, 0.32380952, 0.32429792, \
0.32478632, 0.32527473, 0.32576313, 0.32625153, 0.32673993, \
0.32722833, 0.32771673, 0.32820513, 0.32869353, 0.32918193, \
0.32967033, 0.33015873, 0.33064713, 0.33113553, 0.33162393, \
0.33211233, 0.33260073, 0.33308913, 0.33357753, 0.33406593, \
0.33455433, 0.33504274, 0.33553114, 0.33601954, 0.33650794, \
0.33699634, 0.33748474, 0.33797314, 0.33846154, 0.33894994, \
0.33943834, 0.33992674, 0.34041514, 0.34090354, 0.34139194, \
0.34188034, 0.34236874, 0.34285714, 0.34334554, 0.34383394, \
0.34432234, 0.34481074, 0.34529915, 0.34578755, 0.34627595, \
0.34676435, 0.34725275, 0.34774115, 0.34822955, 0.34871795, \
0.34920635, 0.34969475, 0.35018315, 0.35067155, 0.35115995, \
0.35164835, 0.35213675, 0.35262515, 0.35311355, 0.35360195, \
0.35409035, 0.35457875, 0.35506716, 0.35555556, 0.35604396, \
0.35653236, 0.35702076, 0.35750916, 0.35799756, 0.35848596, \
0.35897436, 0.35946276, 0.35995116, 0.36043956, 0.36092796, \
0.36141636, 0.36190476, 0.36239316, 0.36288156, 0.36336996, \
0.36385836, 0.36434676, 0.36483516, 0.36532357, 0.36581197, \
0.36630037, 0.36678877, 0.36727717, 0.36776557, 0.36825397, \
0.36874237, 0.36923077, 0.36971917, 0.37020757, 0.37069597, \
0.37118437, 0.37167277, 0.37216117, 0.37264957, 0.37313797, \
0.37362637, 0.37411477, 0.37460317, 0.37509158, 0.37557998, \
0.37606838, 0.37655678, 0.37704518, 0.37753358, 0.37802198, \
0.37851038, 0.37899878, 0.37948718, 0.37997558, 0.38046398, \
0.38095238, 0.38144078, 0.38192918, 0.38241758, 0.38290598, \
0.38339438, 0.38388278, 0.38437118, 0.38485958, 0.38534799, \
0.38583639, 0.38632479, 0.38681319, 0.38730159, 0.38778999, \
0.38827839, 0.38876679, 0.38925519, 0.38974359, 0.39023199, \
0.39072039, 0.39120879, 0.39169719, 0.39218559, 0.39267399, \
0.39316239, 0.39365079, 0.39413919, 0.39462759, 0.39511600, \
0.39560440, 0.39609280, 0.39658120, 0.39706960, 0.39755800, \
0.39804640, 0.39853480, 0.39902320, 0.39951160, 0.40000000, \
0.40048840, 0.40097680, 0.40146520, 0.40195360, 0.40244200, \
0.40293040, 0.40341880, 0.40390720, 0.40439560, 0.40488400, \
0.40537241, 0.40586081, 0.40634921, 0.40683761, 0.40732601, \
0.40781441, 0.40830281, 0.40879121, 0.40927961, 0.40976801, \
0.41025641, 0.41074481, 0.41123321, 0.41172161, 0.41221001, \
0.41269841, 0.41318681, 0.41367521, 0.41416361, 0.41465201, \
0.41514042, 0.41562882, 0.41611722, 0.41660562, 0.41709402, \
0.41758242, 0.41807082, 0.41855922, 0.41904762, 0.41953602, \
0.42002442, 0.42051282, 0.42100122, 0.42148962, 0.42197802, \
0.42246642, 0.42295482, 0.42344322, 0.42393162, 0.42442002, \
0.42490842, 0.42539683, 0.42588523, 0.42637363, 0.42686203, \
0.42735043, 0.42783883, 0.42832723, 0.42881563, 0.42930403, \
0.42979243, 0.43028083, 0.43076923, 0.43125763, 0.43174603, \
0.43223443, 0.43272283, 0.43321123, 0.43369963, 0.43418803, \
0.43467643, 0.43516484, 0.43565324, 0.43614164, 0.43663004, \
0.43711844, 0.43760684, 0.43809524, 0.43858364, 0.43907204, \
0.43956044, 0.44004884, 0.44053724, 0.44102564, 0.44151404, \
0.44200244, 0.44249084, 0.44297924, 0.44346764, 0.44395604, \
0.44444444, 0.44493284, 0.44542125, 0.44590965, 0.44639805, \
0.44688645, 0.44737485, 0.44786325, 0.44835165, 0.44884005, \
0.44932845, 0.44981685, 0.45030525, 0.45079365, 0.45128205, \
0.45177045, 0.45225885, 0.45274725, 0.45323565, 0.45372405, \
0.45421245, 0.45470085, 0.45518926, 0.45567766, 0.45616606, \
0.45665446, 0.45714286, 0.45763126, 0.45811966, 0.45860806, \
0.45909646, 0.45958486, 0.46007326, 0.46056166, 0.46105006, \
0.46153846, 0.46202686, 0.46251526, 0.46300366, 0.46349206, \
0.46398046, 0.46446886, 0.46495726, 0.46544567, 0.46593407, \
0.46642247, 0.46691087, 0.46739927, 0.46788767, 0.46837607, \
0.46886447, 0.46935287, 0.46984127, 0.47032967, 0.47081807, \
0.47130647, 0.47179487, 0.47228327, 0.47277167, 0.47326007, \
0.47374847, 0.47423687, 0.47472527, 0.47521368, 0.47570208, \
0.47619048, 0.47667888, 0.47716728, 0.47765568, 0.47814408, \
0.47863248, 0.47912088, 0.47960928, 0.48009768, 0.48058608, \
0.48107448, 0.48156288, 0.48205128, 0.48253968, 0.48302808, \
0.48351648, 0.48400488, 0.48449328, 0.48498168, 0.48547009, \
0.48595849, 0.48644689, 0.48693529, 0.48742369, 0.48791209, \
0.48840049, 0.48888889, 0.48937729, 0.48986569, 0.49035409, \
0.49084249, 0.49133089, 0.49181929, 0.49230769, 0.49279609, \
0.49328449, 0.49377289, 0.49426129, 0.49474969, 0.49523810, \
0.49572650, 0.49621490, 0.49670330, 0.49719170, 0.49768010, \
0.49816850, 0.49865690, 0.49914530, 0.49963370, 0.50012210, \
0.50061050, 0.50109890, 0.50158730, 0.50207570, 0.50256410, \
0.50305250, 0.50354090, 0.50402930, 0.50451770, 0.50500611, \
0.50549451, 0.50598291, 0.50647131, 0.50695971, 0.50744811, \
0.50793651, 0.50842491, 0.50891331, 0.50940171, 0.50989011, \
0.51037851, 0.51086691, 0.51135531, 0.51184371, 0.51233211, \
0.51282051, 0.51330891, 0.51379731, 0.51428571, 0.51477411, \
0.51526252, 0.51575092, 0.51623932, 0.51672772, 0.51721612, \
0.51770452, 0.51819292, 0.51868132, 0.51916972, 0.51965812, \
0.52014652, 0.52063492, 0.52112332, 0.52161172, 0.52210012, \
0.52258852, 0.52307692, 0.52356532, 0.52405372, 0.52454212, \
0.52503053, 0.52551893, 0.52600733, 0.52649573, 0.52698413, \
0.52747253, 0.52796093, 0.52844933, 0.52893773, 0.52942613, \
0.52991453, 0.53040293, 0.53089133, 0.53137973, 0.53186813, \
0.53235653, 0.53284493, 0.53333333, 0.53382173, 0.53431013, \
0.53479853, 0.53528694, 0.53577534, 0.53626374, 0.53675214, \
0.53724054, 0.53772894, 0.53821734, 0.53870574, 0.53919414, \
0.53968254, 0.54017094, 0.54065934, 0.54114774, 0.54163614, \
0.54212454, 0.54261294, 0.54310134, 0.54358974, 0.54407814, \
0.54456654, 0.54505495, 0.54554335, 0.54603175, 0.54652015, \
0.54700855, 0.54749695, 0.54798535, 0.54847375, 0.54896215, \
0.54945055, 0.54993895, 0.55042735, 0.55091575, 0.55140415, \
0.55189255, 0.55238095, 0.55286935, 0.55335775, 0.55384615, \
0.55433455, 0.55482295, 0.55531136, 0.55579976, 0.55628816, \
0.55677656, 0.55726496, 0.55775336, 0.55824176, 0.55873016, \
0.55921856, 0.55970696, 0.56019536, 0.56068376, 0.56117216, \
0.56166056, 0.56214896, 0.56263736, 0.56312576, 0.56361416, \
0.56410256, 0.56459096, 0.56507937, 0.56556777, 0.56605617, \
0.56654457, 0.56703297, 0.56752137, 0.56800977, 0.56849817, \
0.56898657, 0.56947497, 0.56996337, 0.57045177, 0.57094017, \
0.57142857, 0.57191697, 0.57240537, 0.57289377, 0.57338217, \
0.57387057, 0.57435897, 0.57484737, 0.57533578, 0.57582418, \
0.57631258, 0.57680098, 0.57728938, 0.57777778, 0.57826618, \
0.57875458, 0.57924298, 0.57973138, 0.58021978, 0.58070818, \
0.58119658, 0.58168498, 0.58217338, 0.58266178, 0.58315018, \
0.58363858, 0.58412698, 0.58461538, 0.58510379, 0.58559219, \
0.58608059, 0.58656899, 0.58705739, 0.58754579, 0.58803419, \
0.58852259, 0.58901099, 0.58949939, 0.58998779, 0.59047619, \
0.59096459, 0.59145299, 0.59194139, 0.59242979, 0.59291819, \
0.59340659, 0.59389499, 0.59438339, 0.59487179, 0.59536020, \
0.59584860, 0.59633700, 0.59682540, 0.59731380, 0.59780220, \
0.59829060, 0.59877900, 0.59926740, 0.59975580, 0.60024420, \
0.60073260, 0.60122100, 0.60170940, 0.60219780, 0.60268620, \
0.60317460, 0.60366300, 0.60415140, 0.60463980, 0.60512821, \
0.60561661, 0.60610501, 0.60659341, 0.60708181, 0.60757021, \
0.60805861, 0.60854701, 0.60903541, 0.60952381, 0.61001221, \
0.61050061, 0.61098901, 0.61147741, 0.61196581, 0.61245421, \
0.61294261, 0.61343101, 0.61391941, 0.61440781, 0.61489621, \
0.61538462, 0.61587302, 0.61636142, 0.61684982, 0.61733822, \
0.61782662, 0.61831502, 0.61880342, 0.61929182, 0.61978022, \
0.62026862, 0.62075702, 0.62124542, 0.62173382, 0.62222222, \
0.62271062, 0.62319902, 0.62368742, 0.62417582, 0.62466422, \
0.62515263, 0.62564103, 0.62612943, 0.62661783, 0.62710623, \
0.62759463, 0.62808303, 0.62857143, 0.62905983, 0.62954823, \
0.63003663, 0.63052503, 0.63101343, 0.63150183, 0.63199023, \
0.63247863, 0.63296703, 0.63345543, 0.63394383, 0.63443223, \
0.63492063, 0.63540904, 0.63589744, 0.63638584, 0.63687424, \
0.63736264, 0.63785104, 0.63833944, 0.63882784, 0.63931624, \
0.63980464, 0.64029304, 0.64078144, 0.64126984, 0.64175824, \
0.64224664, 0.64273504, 0.64322344, 0.64371184, 0.64420024, \
0.64468864, 0.64517705, 0.64566545, 0.64615385, 0.64664225, \
0.64713065, 0.64761905, 0.64810745, 0.64859585, 0.64908425, \
0.64957265, 0.65006105, 0.65054945, 0.65103785, 0.65152625, \
0.65201465, 0.65250305, 0.65299145, 0.65347985, 0.65396825, \
0.65445665, 0.65494505, 0.65543346, 0.65592186, 0.65641026, \
0.65689866, 0.65738706, 0.65787546, 0.65836386, 0.65885226, \
0.65934066, 0.65982906, 0.66031746, 0.66080586, 0.66129426, \
0.66178266, 0.66227106, 0.66275946, 0.66324786, 0.66373626, \
0.66422466, 0.66471306, 0.66520147, 0.66568987, 0.66617827, \
0.66666667, 0.66715507, 0.66764347, 0.66813187, 0.66862027, \
0.66910867, 0.66959707, 0.67008547, 0.67057387, 0.67106227, \
0.67155067, 0.67203907, 0.67252747, 0.67301587, 0.67350427, \
0.67399267, 0.67448107, 0.67496947, 0.67545788, 0.67594628, \
0.67643468, 0.67692308, 0.67741148, 0.67789988, 0.67838828, \
0.67887668, 0.67936508, 0.67985348, 0.68034188, 0.68083028, \
0.68131868, 0.68180708, 0.68229548, 0.68278388, 0.68327228, \
0.68376068, 0.68424908, 0.68473748, 0.68522589, 0.68571429, \
0.68620269, 0.68669109, 0.68717949, 0.68766789, 0.68815629, \
0.68864469, 0.68913309, 0.68962149, 0.69010989, 0.69059829, \
0.69108669, 0.69157509, 0.69206349, 0.69255189, 0.69304029, \
0.69352869, 0.69401709, 0.69450549, 0.69499389, 0.69548230, \
0.69597070, 0.69645910, 0.69694750, 0.69743590, 0.69792430, \
0.69841270, 0.69890110, 0.69938950, 0.69987790, 0.70036630, \
0.70085470, 0.70134310, 0.70183150, 0.70231990, 0.70280830, \
0.70329670, 0.70378510, 0.70427350, 0.70476190, 0.70525031, \
0.70573871, 0.70622711, 0.70671551, 0.70720391, 0.70769231, \
0.70818071, 0.70866911, 0.70915751, 0.70964591, 0.71013431, \
0.71062271, 0.71111111, 0.71159951, 0.71208791, 0.71257631, \
0.71306471, 0.71355311, 0.71404151, 0.71452991, 0.71501832, \
0.71550672, 0.71599512, 0.71648352, 0.71697192, 0.71746032, \
0.71794872, 0.71843712, 0.71892552, 0.71941392, 0.71990232, \
0.72039072, 0.72087912, 0.72136752, 0.72185592, 0.72234432, \
0.72283272, 0.72332112, 0.72380952, 0.72429792, 0.72478632, \
0.72527473, 0.72576313, 0.72625153, 0.72673993, 0.72722833, \
0.72771673, 0.72820513, 0.72869353, 0.72918193, 0.72967033, \
0.73015873, 0.73064713, 0.73113553, 0.73162393, 0.73211233, \
0.73260073, 0.73308913, 0.73357753, 0.73406593, 0.73455433, \
0.73504274, 0.73553114, 0.73601954, 0.73650794, 0.73699634, \
0.73748474, 0.73797314, 0.73846154, 0.73894994, 0.73943834, \
0.73992674, 0.74041514, 0.74090354, 0.74139194, 0.74188034, \
0.74236874, 0.74285714, 0.74334554, 0.74383394, 0.74432234, \
0.74481074, 0.74529915, 0.74578755, 0.74627595, 0.74676435, \
0.74725275, 0.74774115, 0.74822955, 0.74871795, 0.74920635, \
0.74969475, 0.75018315, 0.75067155, 0.75115995, 0.75164835, \
0.75213675, 0.75262515, 0.75311355, 0.75360195, 0.75409035, \
0.75457875, 0.75506716, 0.75555556, 0.75604396, 0.75653236, \
0.75702076, 0.75750916, 0.75799756, 0.75848596, 0.75897436, \
0.75946276, 0.75995116, 0.76043956, 0.76092796, 0.76141636, \
0.76190476, 0.76239316, 0.76288156, 0.76336996, 0.76385836, \
0.76434676, 0.76483516, 0.76532357, 0.76581197, 0.76630037, \
0.76678877, 0.76727717, 0.76776557, 0.76825397, 0.76874237, \
0.76923077, 0.76971917, 0.77020757, 0.77069597, 0.77118437, \
0.77167277, 0.77216117, 0.77264957, 0.77313797, 0.77362637, \
0.77411477, 0.77460317, 0.77509158, 0.77557998, 0.77606838, \
0.77655678, 0.77704518, 0.77753358, 0.77802198, 0.77851038, \
0.77899878, 0.77948718, 0.77997558, 0.78046398, 0.78095238, \
0.78144078, 0.78192918, 0.78241758, 0.78290598, 0.78339438, \
0.78388278, 0.78437118, 0.78485958, 0.78534799, 0.78583639, \
0.78632479, 0.78681319, 0.78730159, 0.78778999, 0.78827839, \
0.78876679, 0.78925519, 0.78974359, 0.79023199, 0.79072039, \
0.79120879, 0.79169719, 0.79218559, 0.79267399, 0.79316239, \
0.79365079, 0.79413919, 0.79462759, 0.79511600, 0.79560440, \
0.79609280, 0.79658120, 0.79706960, 0.79755800, 0.79804640, \
0.79853480, 0.79902320, 0.79951160, 0.80000000, 0.80048840, \
0.80097680, 0.80146520, 0.80195360, 0.80244200, 0.80293040, \
0.80341880, 0.80390720, 0.80439560, 0.80488400, 0.80537241, \
0.80586081, 0.80634921, 0.80683761, 0.80732601, 0.80781441, \
0.80830281, 0.80879121, 0.80927961, 0.80976801, 0.81025641, \
0.81074481, 0.81123321, 0.81172161, 0.81221001, 0.81269841, \
0.81318681, 0.81367521, 0.81416361, 0.81465201, 0.81514042, \
0.81562882, 0.81611722, 0.81660562, 0.81709402, 0.81758242, \
0.81807082, 0.81855922, 0.81904762, 0.81953602, 0.82002442, \
0.82051282, 0.82100122, 0.82148962, 0.82197802, 0.82246642, \
0.82295482, 0.82344322, 0.82393162, 0.82442002, 0.82490842, \
0.82539683, 0.82588523, 0.82637363, 0.82686203, 0.82735043, \
0.82783883, 0.82832723, 0.82881563, 0.82930403, 0.82979243, \
0.83028083, 0.83076923, 0.83125763, 0.83174603, 0.83223443, \
0.83272283, 0.83321123, 0.83369963, 0.83418803, 0.83467643, \
0.83516484, 0.83565324, 0.83614164, 0.83663004, 0.83711844, \
0.83760684, 0.83809524, 0.83858364, 0.83907204, 0.83956044, \
0.84004884, 0.84053724, 0.84102564, 0.84151404, 0.84200244, \
0.84249084, 0.84297924, 0.84346764, 0.84395604, 0.84444444, \
0.84493284, 0.84542125, 0.84590965, 0.84639805, 0.84688645, \
0.84737485, 0.84786325, 0.84835165, 0.84884005, 0.84932845, \
0.84981685, 0.85030525, 0.85079365, 0.85128205, 0.85177045, \
0.85225885, 0.85274725, 0.85323565, 0.85372405, 0.85421245, \
0.85470085, 0.85518926, 0.85567766, 0.85616606, 0.85665446, \
0.85714286, 0.85763126, 0.85811966, 0.85860806, 0.85909646, \
0.85958486, 0.86007326, 0.86056166, 0.86105006, 0.86153846, \
0.86202686, 0.86251526, 0.86300366, 0.86349206, 0.86398046, \
0.86446886, 0.86495726, 0.86544567, 0.86593407, 0.86642247, \
0.86691087, 0.86739927, 0.86788767, 0.86837607, 0.86886447, \
0.86935287, 0.86984127, 0.87032967, 0.87081807, 0.87130647, \
0.87179487, 0.87228327, 0.87277167, 0.87326007, 0.87374847, \
0.87423687, 0.87472527, 0.87521368, 0.87570208, 0.87619048, \
0.87667888, 0.87716728, 0.87765568, 0.87814408, 0.87863248, \
0.87912088, 0.87960928, 0.88009768, 0.88058608, 0.88107448, \
0.88156288, 0.88205128, 0.88253968, 0.88302808, 0.88351648, \
0.88400488, 0.88449328, 0.88498168, 0.88547009, 0.88595849, \
0.88644689, 0.88693529, 0.88742369, 0.88791209, 0.88840049, \
0.88888889, 0.88937729, 0.88986569, 0.89035409, 0.89084249, \
0.89133089, 0.89181929, 0.89230769, 0.89279609, 0.89328449, \
0.89377289, 0.89426129, 0.89474969, 0.89523810, 0.89572650, \
0.89621490, 0.89670330, 0.89719170, 0.89768010, 0.89816850, \
0.89865690, 0.89914530, 0.89963370, 0.90012210, 0.90061050, \
0.90109890, 0.90158730, 0.90207570, 0.90256410, 0.90305250, \
0.90354090, 0.90402930, 0.90451770, 0.90500611, 0.90549451, \
0.90598291, 0.90647131, 0.90695971, 0.90744811, 0.90793651, \
0.90842491, 0.90891331, 0.90940171, 0.90989011, 0.91037851, \
0.91086691, 0.91135531, 0.91184371, 0.91233211, 0.91282051, \
0.91330891, 0.91379731, 0.91428571, 0.91477411, 0.91526252, \
0.91575092, 0.91623932, 0.91672772, 0.91721612, 0.91770452, \
0.91819292, 0.91868132, 0.91916972, 0.91965812, 0.92014652, \
0.92063492, 0.92112332, 0.92161172, 0.92210012, 0.92258852, \
0.92307692, 0.92356532, 0.92405372, 0.92454212, 0.92503053, \
0.92551893, 0.92600733, 0.92649573, 0.92698413, 0.92747253, \
0.92796093, 0.92844933, 0.92893773, 0.92942613, 0.92991453, \
0.93040293, 0.93089133, 0.93137973, 0.93186813, 0.93235653, \
0.93284493, 0.93333333, 0.93382173, 0.93431013, 0.93479853, \
0.93528694, 0.93577534, 0.93626374, 0.93675214, 0.93724054, \
0.93772894, 0.93821734, 0.93870574, 0.93919414, 0.93968254, \
0.94017094, 0.94065934, 0.94114774, 0.94163614, 0.94212454, \
0.94261294, 0.94310134, 0.94358974, 0.94407814, 0.94456654, \
0.94505495, 0.94554335, 0.94603175, 0.94652015, 0.94700855, \
0.94749695, 0.94798535, 0.94847375, 0.94896215, 0.94945055, \
0.94993895, 0.95042735, 0.95091575, 0.95140415, 0.95189255, \
0.95238095, 0.95286935, 0.95335775, 0.95384615, 0.95433455, \
0.95482295, 0.95531136, 0.95579976, 0.95628816, 0.95677656, \
0.95726496, 0.95775336, 0.95824176, 0.95873016, 0.95921856, \
0.95970696, 0.96019536, 0.96068376, 0.96117216, 0.96166056, \
0.96214896, 0.96263736, 0.96312576, 0.96361416, 0.96410256, \
0.96459096, 0.96507937, 0.96556777, 0.96605617, 0.96654457, \
0.96703297, 0.96752137, 0.96800977, 0.96849817, 0.96898657, \
0.96947497, 0.96996337, 0.97045177, 0.97094017, 0.97142857, \
0.97191697, 0.97240537, 0.97289377, 0.97338217, 0.97387057, \
0.97435897, 0.97484737, 0.97533578, 0.97582418, 0.97631258, \
0.97680098, 0.97728938, 0.97777778, 0.97826618, 0.97875458, \
0.97924298, 0.97973138, 0.98021978, 0.98070818, 0.98119658, \
0.98168498, 0.98217338, 0.98266178, 0.98315018, 0.98363858, \
0.98412698, 0.98461538, 0.98510379, 0.98559219, 0.98608059, \
0.98656899, 0.98705739, 0.98754579, 0.98803419, 0.98852259, \
0.98901099, 0.98949939, 0.98998779, 0.99047619, 0.99096459, \
0.99145299, 0.99194139, 0.99242979, 0.99291819, 0.99340659, \
0.99389499, 0.99438339, 0.99487179, 0.99536020, 0.99584860, \
0.99633700, 0.99682540, 0.99731380, 0.99780220, 0.99829060, \
0.99877900, 0.99926740, 0.99975580, } 


 #endif // _FPU_FFT_BARTLETT_H_
//=============================================================================
// End of File
//=============================================================================
