//=============================================================================
// Blackman Window 
//=============================================================================
#ifndef _FPU_FFT_BLACKMAN_H_
#define _FPU_FFT_BLACKMAN_H_

#define BLACKMAN32 {\
0.00000000, 0.00375165, 0.01563845, 0.03740270, 0.07146461, \
0.12028646, 0.18564672, 0.26795497, 0.36573504, 0.47537854, \
0.59122860, 0.70600079, 0.81149328, 0.89949043, 0.96273070, \
0.99579706, } 

#define BLACKMAN64 {\
0.00000000, 0.00089841, 0.00363185, 0.00831270, 0.01512084, \
0.02429291, 0.03610789, 0.05086963, 0.06888714, 0.09045342, \
0.11582390, 0.14519518, 0.17868534, 0.21631650, 0.25800050, \
0.30352849, 0.35256479, 0.40464567, 0.45918296, 0.51547272, \
0.57270868, 0.63000000, 0.68639290, 0.74089542, 0.79250434, \
0.84023349, 0.88314229, 0.92036362, 0.95112987, 0.97479637, \
0.99086124, 0.99898092, } 

#define BLACKMAN128 {\
0.00000000, 0.00022048, 0.00088427, 0.00199831, 0.00357410, \
0.00562748, 0.00817842, 0.01125074, 0.01487172, 0.01907174, \
0.02388376, 0.02934291, 0.03548583, 0.04235018, 0.04997401, \
0.05839511, 0.06765036, 0.07777513, 0.08880258, 0.10076300, \
0.11368324, 0.12758601, 0.14248936, 0.15840611, 0.17534333, \
0.19330184, 0.21227586, 0.23225262, 0.25321203, 0.27512651, \
0.29796076, 0.32167173, 0.34620856, 0.37151262, 0.39751770, \
0.42415015, 0.45132921, 0.47896731, 0.50697053, 0.53523907, \
0.56366781, 0.59214691, 0.62056245, 0.64879721, 0.67673135, \
0.70424322, 0.73121023, 0.75750960, 0.78301930, 0.80761885, \
0.83119025, 0.85361875, 0.87479376, 0.89460963, 0.91296646, \
0.92977080, 0.94493641, 0.95838489, 0.97004626, 0.97985951, \
0.98777306, 0.99374518, 0.99774428, 0.99974914, } 

#define BLACKMAN256 {\
0.00000000, 0.00005465, 0.00021876, 0.00049274, 0.00087732, \
0.00137350, 0.00198255, 0.00270602, 0.00354574, 0.00450379, \
0.00558251, 0.00678447, 0.00811251, 0.00956967, 0.01115921, \
0.01288460, 0.01474949, 0.01675772, 0.01891328, 0.02122032, \
0.02368310, 0.02630602, 0.02909357, 0.03205031, 0.03518087, \
0.03848993, 0.04198218, 0.04566235, 0.04953511, 0.05360512, \
0.05787701, 0.06235530, 0.06704443, 0.07194874, 0.07707242, \
0.08241952, 0.08799390, 0.09379926, 0.09983905, 0.10611652, \
0.11263464, 0.11939615, 0.12640348, 0.13365875, 0.14116378, \
0.14892005, 0.15692868, 0.16519042, 0.17370566, 0.18247438, \
0.19149615, 0.20077014, 0.21029508, 0.22006925, 0.23009051, \
0.24035624, 0.25086337, 0.26160836, 0.27258719, 0.28379539, \
0.29522797, 0.30687950, 0.31874404, 0.33081518, 0.34308604, \
0.35554926, 0.36819701, 0.38102098, 0.39401242, 0.40716214, \
0.42046047, 0.43389734, 0.44746225, 0.46114428, 0.47493214, \
0.48881412, 0.50277819, 0.51681193, 0.53090260, 0.54503715, \
0.55920222, 0.57338420, 0.58756919, 0.60174307, 0.61589152, \
0.63000000, 0.64405383, 0.65803817, 0.67193807, 0.68573848, \
0.69942428, 0.71298031, 0.72639138, 0.73964233, 0.75271802, \
0.76560337, 0.77828339, 0.79074321, 0.80296808, 0.81494345, \
0.82665493, 0.83808837, 0.84922986, 0.86006574, 0.87058268, \
0.88076764, 0.89060793, 0.90009125, 0.90920565, 0.91793963, \
0.92628210, 0.93422243, 0.94175046, 0.94885654, 0.95553151, \
0.96176675, 0.96755419, 0.97288632, 0.97775618, 0.98215744, \
0.98608433, 0.98953172, 0.99249508, 0.99497053, 0.99695481, \
0.99844531, 0.99944006, 0.99993777, } 

#define BLACKMAN512 {\
0.00000000, 0.00001361, 0.00005444, 0.00012252, 0.00021790, \
0.00034064, 0.00049081, 0.00066852, 0.00087388, 0.00110702, \
0.00136810, 0.00165728, 0.00197474, 0.00232068, 0.00269533, \
0.00309892, 0.00353169, 0.00399392, 0.00448588, 0.00500788, \
0.00556022, 0.00614324, 0.00675728, 0.00740270, 0.00807986, \
0.00878915, 0.00953097, 0.01030574, 0.01111387, 0.01195580, \
0.01283198, 0.01374287, 0.01468895, 0.01567068, 0.01668856, \
0.01774310, 0.01883480, 0.01996418, 0.02113178, 0.02233811, \
0.02358373, 0.02486918, 0.02619502, 0.02756180, 0.02897010, \
0.03042049, 0.03191352, 0.03344979, 0.03502988, 0.03665436, \
0.03832381, 0.04003883, 0.04180000, 0.04360790, 0.04546312, \
0.04736624, 0.04931783, 0.05131849, 0.05336879, 0.05546928, \
0.05762056, 0.05982316, 0.06207766, 0.06438459, 0.06674452, \
0.06915795, 0.07162544, 0.07414749, 0.07672462, 0.07935731, \
0.08204607, 0.08479137, 0.08759367, 0.09045342, 0.09337108, \
0.09634705, 0.09938177, 0.10247561, 0.10562897, 0.10884221, \
0.11211567, 0.11544970, 0.11884460, 0.12230068, 0.12581821, \
0.12939744, 0.13303863, 0.13674198, 0.14050769, 0.14433595, \
0.14822689, 0.15218067, 0.15619739, 0.16027713, 0.16441995, \
0.16862591, 0.17289501, 0.17722724, 0.18162257, 0.18608093, \
0.19060225, 0.19518641, 0.19983326, 0.20454265, 0.20931439, \
0.21414824, 0.21904397, 0.22400129, 0.22901991, 0.23409949, \
0.23923966, 0.24444005, 0.24970023, 0.25501975, 0.26039813, \
0.26583487, 0.27132944, 0.27688125, 0.28248973, 0.28815425, \
0.29387414, 0.29964873, 0.30547730, 0.31135910, 0.31729336, \
0.32327928, 0.32931602, 0.33540272, 0.34153849, 0.34772241, \
0.35395351, 0.36023083, 0.36655335, 0.37292004, 0.37932983, \
0.38578162, 0.39227429, 0.39880669, 0.40537764, 0.41198594, \
0.41863036, 0.42530963, 0.43202247, 0.43876758, 0.44554360, \
0.45234919, 0.45918296, 0.46604349, 0.47292935, 0.47983909, \
0.48677122, 0.49372424, 0.50069663, 0.50768683, 0.51469329, \
0.52171442, 0.52874860, 0.53579422, 0.54284963, 0.54991316, \
0.55698313, 0.56405785, 0.57113561, 0.57821468, 0.58529330, \
0.59236974, 0.59944220, 0.60650892, 0.61356810, 0.62061792, \
0.62765658, 0.63468224, 0.64169306, 0.64868721, 0.65566283, \
0.66261805, 0.66955102, 0.67645986, 0.68334270, 0.69019766, \
0.69702285, 0.70381639, 0.71057639, 0.71730097, 0.72398824, \
0.73063632, 0.73724331, 0.74380735, 0.75032655, 0.75679903, \
0.76322294, 0.76959641, 0.77591758, 0.78218461, 0.78839565, \
0.79454888, 0.80064248, 0.80667463, 0.81264354, 0.81854742, \
0.82438450, 0.83015302, 0.83585125, 0.84147744, 0.84702990, \
0.85250692, 0.85790684, 0.86322799, 0.86846873, 0.87362745, \
0.87870256, 0.88369247, 0.88859564, 0.89341053, 0.89813565, \
0.90276951, 0.90731065, 0.91175764, 0.91610909, 0.92036362, \
0.92451987, 0.92857654, 0.93253233, 0.93638598, 0.94013626, \
0.94378197, 0.94732195, 0.95075505, 0.95408019, 0.95729628, \
0.96040229, 0.96339722, 0.96628010, 0.96905000, 0.97170602, \
0.97424730, 0.97667302, 0.97898239, 0.98117466, 0.98324911, \
0.98520506, 0.98704189, 0.98875898, 0.99035579, 0.99183179, \
0.99318649, 0.99441945, 0.99553027, 0.99651858, 0.99738407, \
0.99812644, 0.99874545, 0.99924091, 0.99961265, 0.99986054, \
0.99998450, } 

#define BLACKMAN1024 {\
0.00000000, 0.00000340, 0.00001358, 0.00003056, 0.00005433, \
0.00008491, 0.00012228, 0.00016647, 0.00021747, 0.00027531, \
0.00033997, 0.00041148, 0.00048985, 0.00057509, 0.00066721, \
0.00076623, 0.00087217, 0.00098503, 0.00110485, 0.00123164, \
0.00136541, 0.00150620, 0.00165402, 0.00180889, 0.00197085, \
0.00213991, 0.00231611, 0.00249946, 0.00269001, 0.00288778, \
0.00309279, 0.00330509, 0.00352470, 0.00375165, 0.00398599, \
0.00422775, 0.00447697, 0.00473367, 0.00499791, 0.00526972, \
0.00554913, 0.00583620, 0.00613097, 0.00643347, 0.00674375, \
0.00706186, 0.00738784, 0.00772174, 0.00806360, 0.00841349, \
0.00877143, 0.00913749, 0.00951171, 0.00989415, 0.01028486, \
0.01068389, 0.01109130, 0.01150714, 0.01193146, 0.01236433, \
0.01280580, 0.01325592, 0.01371476, 0.01418237, 0.01465881, \
0.01514415, 0.01563845, 0.01614176, 0.01665415, 0.01717568, \
0.01770641, 0.01824641, 0.01879575, 0.01935448, 0.01992267, \
0.02050040, 0.02108771, 0.02168469, 0.02229140, 0.02290791, \
0.02353428, 0.02417058, 0.02481689, 0.02547326, 0.02613978, \
0.02681651, 0.02750352, 0.02820089, 0.02890867, 0.02962695, \
0.03035579, 0.03109527, 0.03184546, 0.03260643, 0.03337826, \
0.03416101, 0.03495475, 0.03575957, 0.03657553, 0.03740270, \
0.03824116, 0.03909099, 0.03995224, 0.04082501, 0.04170936, \
0.04260535, 0.04351308, 0.04443260, 0.04536400, 0.04630733, \
0.04726269, 0.04823013, 0.04920974, 0.05020158, 0.05120572, \
0.05222224, 0.05325120, 0.05429269, 0.05534677, 0.05641350, \
0.05749297, 0.05858524, 0.05969037, 0.06080845, 0.06193953, \
0.06308369, 0.06424100, 0.06541152, 0.06659531, 0.06779245, \
0.06900301, 0.07022704, 0.07146461, 0.07271578, 0.07398063, \
0.07525921, 0.07655159, 0.07785783, 0.07917798, 0.08051212, \
0.08186029, 0.08322257, 0.08459900, 0.08598964, 0.08739456, \
0.08881381, 0.09024744, 0.09169551, 0.09315807, 0.09463518, \
0.09612688, 0.09763324, 0.09915429, 0.10069008, 0.10224067, \
0.10380611, 0.10538643, 0.10698169, 0.10859193, 0.11021718, \
0.11185750, 0.11351293, 0.11518350, 0.11686925, 0.11857023, \
0.12028646, 0.12201799, 0.12376484, 0.12552706, 0.12730466, \
0.12909769, 0.13090617, 0.13273014, 0.13456960, 0.13642461, \
0.13829516, 0.14018130, 0.14208304, 0.14400040, 0.14593340, \
0.14788206, 0.14984640, 0.15182642, 0.15382214, 0.15583358, \
0.15786074, 0.15990363, 0.16196227, 0.16403665, 0.16612678, \
0.16823267, 0.17035431, 0.17249170, 0.17464485, 0.17681375, \
0.17899839, 0.18119878, 0.18341489, 0.18564672, 0.18789427, \
0.19015751, 0.19243643, 0.19473102, 0.19704126, 0.19936713, \
0.20170861, 0.20406567, 0.20643829, 0.20882644, 0.21123010, \
0.21364924, 0.21608383, 0.21853382, 0.22099919, 0.22347991, \
0.22597592, 0.22848720, 0.23101370, 0.23355537, 0.23611217, \
0.23868406, 0.24127098, 0.24387289, 0.24648972, 0.24912143, \
0.25176796, 0.25442925, 0.25710525, 0.25979588, 0.26250109, \
0.26522081, 0.26795497, 0.27070351, 0.27346635, 0.27624341, \
0.27903464, 0.28183994, 0.28465924, 0.28749247, 0.29033953, \
0.29320034, 0.29607482, 0.29896288, 0.30186444, 0.30477939, \
0.30770764, 0.31064911, 0.31360369, 0.31657129, 0.31955180, \
0.32254512, 0.32555115, 0.32856978, 0.33160090, 0.33464441, \
0.33770018, 0.34076812, 0.34384809, 0.34694000, 0.35004370, \
0.35315910, 0.35628605, 0.35942444, 0.36257415, 0.36573504, \
0.36890698, 0.37208985, 0.37528350, 0.37848781, 0.38170264, \
0.38492784, 0.38816328, 0.39140882, 0.39466431, 0.39792961, \
0.40120456, 0.40448903, 0.40778286, 0.41108589, 0.41439798, \
0.41771897, 0.42104869, 0.42438700, 0.42773373, 0.43108872, \
0.43445181, 0.43782282, 0.44120160, 0.44458797, 0.44798177, \
0.45138282, 0.45479095, 0.45820599, 0.46162775, 0.46505607, \
0.46849076, 0.47193164, 0.47537854, 0.47883126, 0.48228962, \
0.48575343, 0.48922252, 0.49269668, 0.49617574, 0.49965949, \
0.50314774, 0.50664031, 0.51013699, 0.51363758, 0.51714190, \
0.52064973, 0.52416089, 0.52767516, 0.53119235, 0.53471225, \
0.53823466, 0.54175936, 0.54528616, 0.54881484, 0.55234519, \
0.55587701, 0.55941008, 0.56294419, 0.56647912, 0.57001466, \
0.57355060, 0.57708671, 0.58062279, 0.58415861, 0.58769395, \
0.59122860, 0.59476232, 0.59829491, 0.60182614, 0.60535578, \
0.60888362, 0.61240941, 0.61593296, 0.61945401, 0.62297236, \
0.62648776, 0.63000000, 0.63350884, 0.63701406, 0.64051543, \
0.64401271, 0.64750568, 0.65099410, 0.65447775, 0.65795638, \
0.66142978, 0.66489770, 0.66835992, 0.67181620, 0.67526630, \
0.67871000, 0.68214705, 0.68557723, 0.68900030, 0.69241603, \
0.69582418, 0.69922451, 0.70261679, 0.70600079, 0.70937627, \
0.71274299, 0.71610073, 0.71944923, 0.72278828, 0.72611764, \
0.72943706, 0.73274632, 0.73604518, 0.73933341, 0.74261076, \
0.74587702, 0.74913194, 0.75237529, 0.75560684, 0.75882635, \
0.76203360, 0.76522835, 0.76841036, 0.77157942, 0.77473528, \
0.77787771, 0.78100650, 0.78412140, 0.78722219, 0.79030864, \
0.79338053, 0.79643762, 0.79947969, 0.80250652, 0.80551787, \
0.80851354, 0.81149328, 0.81445689, 0.81740414, 0.82033480, \
0.82324867, 0.82614551, 0.82902511, 0.83188726, 0.83473174, \
0.83755833, 0.84036681, 0.84315699, 0.84592863, 0.84868154, \
0.85141550, 0.85413031, 0.85682575, 0.85950162, 0.86215771, \
0.86479382, 0.86740976, 0.87000530, 0.87258027, 0.87513445, \
0.87766765, 0.88017967, 0.88267032, 0.88513941, 0.88758674, \
0.89001212, 0.89241537, 0.89479629, 0.89715471, 0.89949043, \
0.90180327, 0.90409306, 0.90635961, 0.90860274, 0.91082228, \
0.91301805, 0.91518988, 0.91733761, 0.91946105, 0.92156004, \
0.92363442, 0.92568402, 0.92770867, 0.92970823, 0.93168252, \
0.93363140, 0.93555471, 0.93745228, 0.93932398, 0.94116966, \
0.94298916, 0.94478234, 0.94654906, 0.94828917, 0.95000254, \
0.95168903, 0.95334851, 0.95498083, 0.95658588, 0.95816351, \
0.95971361, 0.96123605, 0.96273070, 0.96419745, 0.96563618, \
0.96704677, 0.96842911, 0.96978308, 0.97110858, 0.97240549, \
0.97367373, 0.97491317, 0.97612372, 0.97730529, 0.97845777, \
0.97958108, 0.98067512, 0.98173980, 0.98277504, 0.98378076, \
0.98475686, 0.98570328, 0.98661992, 0.98750673, 0.98836363, \
0.98919055, 0.98998741, 0.99075416, 0.99149074, 0.99219707, \
0.99287312, 0.99351881, 0.99413410, 0.99471893, 0.99527327, \
0.99579706, 0.99629026, 0.99675283, 0.99718473, 0.99758593, \
0.99795640, 0.99829610, 0.99860501, 0.99888310, 0.99913034, \
0.99934673, 0.99953223, 0.99968685, 0.99981055, 0.99990334, \
0.99996520, 0.99999613, } 

#define BLACKMAN2048 {\
0.00000000, 0.00000085, 0.00000339, 0.00000763, 0.00001357, \
0.00002120, 0.00003053, 0.00004156, 0.00005428, 0.00006870, \
0.00008482, 0.00010264, 0.00012216, 0.00014338, 0.00016631, \
0.00019093, 0.00021726, 0.00024530, 0.00027504, 0.00030648, \
0.00033964, 0.00037450, 0.00041108, 0.00044937, 0.00048937, \
0.00053109, 0.00057453, 0.00061968, 0.00066656, 0.00071516, \
0.00076548, 0.00081753, 0.00087131, 0.00092682, 0.00098407, \
0.00104305, 0.00110377, 0.00116623, 0.00123043, 0.00129638, \
0.00136407, 0.00143352, 0.00150472, 0.00157768, 0.00165239, \
0.00172887, 0.00180711, 0.00188713, 0.00196891, 0.00205247, \
0.00213780, 0.00222492, 0.00231382, 0.00240452, 0.00249700, \
0.00259128, 0.00268736, 0.00278524, 0.00288492, 0.00298642, \
0.00308973, 0.00319486, 0.00330182, 0.00341060, 0.00352121, \
0.00363365, 0.00374794, 0.00386407, 0.00398204, 0.00410187, \
0.00422356, 0.00434711, 0.00447252, 0.00459980, 0.00472897, \
0.00486001, 0.00499293, 0.00512775, 0.00526447, 0.00540308, \
0.00554360, 0.00568603, 0.00583038, 0.00597665, 0.00612484, \
0.00627497, 0.00642703, 0.00658104, 0.00673700, 0.00689491, \
0.00705478, 0.00721662, 0.00738043, 0.00754621, 0.00771398, \
0.00788374, 0.00805550, 0.00822925, 0.00840502, 0.00858279, \
0.00876259, 0.00894441, 0.00912827, 0.00931417, 0.00950211, \
0.00969210, 0.00988415, 0.01007826, 0.01027445, 0.01047271, \
0.01067306, 0.01087550, 0.01108004, 0.01128669, 0.01149545, \
0.01170632, 0.01191932, 0.01213446, 0.01235173, 0.01257116, \
0.01279273, 0.01301647, 0.01324238, 0.01347046, 0.01370073, \
0.01393319, 0.01416785, 0.01440471, 0.01464378, 0.01488508, \
0.01512860, 0.01537437, 0.01562237, 0.01587263, 0.01612514, \
0.01637992, 0.01663698, 0.01689632, 0.01715795, 0.01742188, \
0.01768811, 0.01795666, 0.01822753, 0.01850073, 0.01877627, \
0.01905415, 0.01933439, 0.01961699, 0.01990197, 0.02018932, \
0.02047906, 0.02077120, 0.02106574, 0.02136269, 0.02166206, \
0.02196387, 0.02226811, 0.02257479, 0.02288393, 0.02319554, \
0.02350961, 0.02382617, 0.02414521, 0.02446676, 0.02479080, \
0.02511737, 0.02544645, 0.02577807, 0.02611223, 0.02644894, \
0.02678821, 0.02713004, 0.02747445, 0.02782145, 0.02817103, \
0.02852323, 0.02887803, 0.02923545, 0.02959550, 0.02995819, \
0.03032353, 0.03069152, 0.03106217, 0.03143550, 0.03181152, \
0.03219022, 0.03257163, 0.03295574, 0.03334258, 0.03373214, \
0.03412444, 0.03451948, 0.03491728, 0.03531784, 0.03572118, \
0.03612730, 0.03653621, 0.03694792, 0.03736244, 0.03777977, \
0.03819994, 0.03862294, 0.03904879, 0.03947749, 0.03990906, \
0.04034350, 0.04078082, 0.04122103, 0.04166414, 0.04211017, \
0.04255911, 0.04301098, 0.04346578, 0.04392354, 0.04438424, \
0.04484791, 0.04531456, 0.04578418, 0.04625680, 0.04673242, \
0.04721104, 0.04769269, 0.04817736, 0.04866507, 0.04915582, \
0.04964963, 0.05014650, 0.05064645, 0.05114947, 0.05165559, \
0.05216480, 0.05267712, 0.05319256, 0.05371113, 0.05423282, \
0.05475767, 0.05528566, 0.05581682, 0.05635114, 0.05688865, \
0.05742934, 0.05797322, 0.05852031, 0.05907062, 0.05962415, \
0.06018090, 0.06074090, 0.06130414, 0.06187065, 0.06244041, \
0.06301345, 0.06358977, 0.06416938, 0.06475229, 0.06533851, \
0.06592804, 0.06652090, 0.06711709, 0.06771662, 0.06831949, \
0.06892573, 0.06953533, 0.07014830, 0.07076465, 0.07138439, \
0.07200753, 0.07263408, 0.07326404, 0.07389741, 0.07453422, \
0.07517447, 0.07581816, 0.07646530, 0.07711590, 0.07776997, \
0.07842752, 0.07908854, 0.07975306, 0.08042108, 0.08109260, \
0.08176764, 0.08244619, 0.08312828, 0.08381390, 0.08450306, \
0.08519577, 0.08589203, 0.08659186, 0.08729526, 0.08800224, \
0.08871281, 0.08942696, 0.09014471, 0.09086607, 0.09159104, \
0.09231963, 0.09305184, 0.09378769, 0.09452717, 0.09527030, \
0.09601708, 0.09676752, 0.09752162, 0.09827939, 0.09904083, \
0.09980596, 0.10057478, 0.10134729, 0.10212350, 0.10290342, \
0.10368705, 0.10447440, 0.10526547, 0.10606027, 0.10685881, \
0.10766108, 0.10846710, 0.10927687, 0.11009040, 0.11090769, \
0.11172875, 0.11255357, 0.11338218, 0.11421457, 0.11505074, \
0.11589070, 0.11673446, 0.11758202, 0.11843339, 0.11928857, \
0.12014756, 0.12101037, 0.12187700, 0.12274746, 0.12362175, \
0.12449988, 0.12538185, 0.12626766, 0.12715732, 0.12805083, \
0.12894820, 0.12984942, 0.13075451, 0.13166346, 0.13257628, \
0.13349297, 0.13441354, 0.13533799, 0.13626632, 0.13719854, \
0.13813464, 0.13907463, 0.14001852, 0.14096630, 0.14191799, \
0.14287357, 0.14383306, 0.14479645, 0.14576375, 0.14673496, \
0.14771008, 0.14868912, 0.14967207, 0.15065895, 0.15164974, \
0.15264445, 0.15364309, 0.15464565, 0.15565213, 0.15666255, \
0.15767689, 0.15869516, 0.15971736, 0.16074349, 0.16177355, \
0.16280755, 0.16384548, 0.16488734, 0.16593314, 0.16698287, \
0.16803654, 0.16909414, 0.17015568, 0.17122115, 0.17229055, \
0.17336390, 0.17444117, 0.17552238, 0.17660752, 0.17769660, \
0.17878960, 0.17988654, 0.18098741, 0.18209221, 0.18320093, \
0.18431358, 0.18543016, 0.18655066, 0.18767508, 0.18880343, \
0.18993569, 0.19107187, 0.19221197, 0.19335597, 0.19450389, \
0.19565572, 0.19681146, 0.19797110, 0.19913464, 0.20030208, \
0.20147341, 0.20264864, 0.20382776, 0.20501076, 0.20619765, \
0.20738842, 0.20858307, 0.20978159, 0.21098398, 0.21219024, \
0.21340035, 0.21461433, 0.21583216, 0.21705384, 0.21827937, \
0.21950874, 0.22074194, 0.22197898, 0.22321985, 0.22446454, \
0.22571304, 0.22696536, 0.22822149, 0.22948142, 0.23074515, \
0.23201266, 0.23328397, 0.23455905, 0.23583791, 0.23712054, \
0.23840693, 0.23969707, 0.24099097, 0.24228861, 0.24358998, \
0.24489509, 0.24620392, 0.24751647, 0.24883272, 0.25015268, \
0.25147634, 0.25280368, 0.25413471, 0.25546941, 0.25680777, \
0.25814980, 0.25949547, 0.26084478, 0.26219773, 0.26355431, \
0.26491450, 0.26627830, 0.26764570, 0.26901670, 0.27039128, \
0.27176943, 0.27315115, 0.27453642, 0.27592524, 0.27731760, \
0.27871348, 0.28011289, 0.28151580, 0.28292221, 0.28433211, \
0.28574549, 0.28716234, 0.28858265, 0.29000640, 0.29143360, \
0.29286422, 0.29429825, 0.29573569, 0.29717653, 0.29862075, \
0.30006834, 0.30151929, 0.30297359, 0.30443123, 0.30589219, \
0.30735647, 0.30882405, 0.31029492, 0.31176907, 0.31324649, \
0.31472716, 0.31621107, 0.31769820, 0.31918856, 0.32068212, \
0.32217886, 0.32367879, 0.32518187, 0.32668811, 0.32819749, \
0.32970999, 0.33122559, 0.33274430, 0.33426609, 0.33579094, \
0.33731885, 0.33884980, 0.34038378, 0.34192076, 0.34346075, \
0.34500371, 0.34654965, 0.34809853, 0.34965035, 0.35120510, \
0.35276275, 0.35432329, 0.35588671, 0.35745299, 0.35902212, \
0.36059408, 0.36216884, 0.36374641, 0.36532676, 0.36690987, \
0.36849573, 0.37008432, 0.37167563, 0.37326964, 0.37486633, \
0.37646569, 0.37806769, 0.37967233, 0.38127957, 0.38288942, \
0.38450185, 0.38611683, 0.38773436, 0.38935442, 0.39097699, \
0.39260204, 0.39422957, 0.39585955, 0.39749197, 0.39912681, \
0.40076404, 0.40240366, 0.40404563, 0.40568995, 0.40733660, \
0.40898554, 0.41063678, 0.41229028, 0.41394603, 0.41560400, \
0.41726418, 0.41892656, 0.42059110, 0.42225779, 0.42392661, \
0.42559753, 0.42727055, 0.42894563, 0.43062277, 0.43230193, \
0.43398309, 0.43566625, 0.43735137, 0.43903843, 0.44072742, \
0.44241831, 0.44411108, 0.44580571, 0.44750218, 0.44920047, \
0.45090056, 0.45260242, 0.45430603, 0.45601137, 0.45771843, \
0.45942717, 0.46113757, 0.46284962, 0.46456328, 0.46627855, \
0.46799539, 0.46971379, 0.47143371, 0.47315514, 0.47487806, \
0.47660244, 0.47832826, 0.48005549, 0.48178412, 0.48351411, \
0.48524546, 0.48697812, 0.48871209, 0.49044733, 0.49218382, \
0.49392154, 0.49566046, 0.49740057, 0.49914183, 0.50088422, \
0.50262772, 0.50437230, 0.50611795, 0.50786463, 0.50961231, \
0.51136099, 0.51311062, 0.51486120, 0.51661268, 0.51836505, \
0.52011829, 0.52187235, 0.52362724, 0.52538290, 0.52713933, \
0.52889650, 0.53065437, 0.53241293, 0.53417215, 0.53593200, \
0.53769246, 0.53945351, 0.54121510, 0.54297723, 0.54473987, \
0.54650298, 0.54826655, 0.55003054, 0.55179493, 0.55355969, \
0.55532481, 0.55709024, 0.55885597, 0.56062196, 0.56238820, \
0.56415465, 0.56592129, 0.56768809, 0.56945502, 0.57122206, \
0.57298918, 0.57475636, 0.57652356, 0.57829076, 0.58005793, \
0.58182504, 0.58359208, 0.58535900, 0.58712578, 0.58889240, \
0.59065883, 0.59242503, 0.59419099, 0.59595668, 0.59772205, \
0.59948710, 0.60125179, 0.60301610, 0.60477998, 0.60654343, \
0.60830640, 0.61006888, 0.61183083, 0.61359222, 0.61535304, \
0.61711324, 0.61887280, 0.62063169, 0.62238989, 0.62414736, \
0.62590408, 0.62766001, 0.62941514, 0.63116943, 0.63292285, \
0.63467538, 0.63642698, 0.63817763, 0.63992730, 0.64167596, \
0.64342358, 0.64517013, 0.64691558, 0.64865991, 0.65040309, \
0.65214508, 0.65388586, 0.65562540, 0.65736366, 0.65910063, \
0.66083627, 0.66257056, 0.66430346, 0.66603494, 0.66776498, \
0.66949354, 0.67122061, 0.67294614, 0.67467011, 0.67639249, \
0.67811325, 0.67983236, 0.68154979, 0.68326552, 0.68497951, \
0.68669174, 0.68840217, 0.69011077, 0.69181753, 0.69352240, \
0.69522535, 0.69692637, 0.69862542, 0.70032246, 0.70201748, \
0.70371044, 0.70540131, 0.70709006, 0.70877667, 0.71046110, \
0.71214332, 0.71382331, 0.71550104, 0.71717647, 0.71884958, \
0.72052034, 0.72218871, 0.72385468, 0.72551820, 0.72717926, \
0.72883781, 0.73049384, 0.73214731, 0.73379820, 0.73544646, \
0.73709209, 0.73873504, 0.74037528, 0.74201279, 0.74364754, \
0.74527950, 0.74690864, 0.74853493, 0.75015834, 0.75177884, \
0.75339640, 0.75501100, 0.75662260, 0.75823118, 0.75983671, \
0.76143915, 0.76303849, 0.76463468, 0.76622770, 0.76781753, \
0.76940413, 0.77098747, 0.77256753, 0.77414428, 0.77571769, \
0.77728772, 0.77885436, 0.78041756, 0.78197731, 0.78353358, \
0.78508633, 0.78663554, 0.78818118, 0.78972322, 0.79126164, \
0.79279640, 0.79432747, 0.79585483, 0.79737845, 0.79889831, \
0.80041436, 0.80192659, 0.80343497, 0.80493947, 0.80644006, \
0.80793671, 0.80942940, 0.81091809, 0.81240277, 0.81388339, \
0.81535995, 0.81683239, 0.81830071, 0.81976487, 0.82122484, \
0.82268061, 0.82413213, 0.82557938, 0.82702234, 0.82846097, \
0.82989526, 0.83132517, 0.83275068, 0.83417176, 0.83558838, \
0.83700052, 0.83840814, 0.83981123, 0.84120976, 0.84260369, \
0.84399301, 0.84537769, 0.84675770, 0.84813301, 0.84950360, \
0.85086944, 0.85223050, 0.85358677, 0.85493821, 0.85628480, \
0.85762651, 0.85896332, 0.86029520, 0.86162213, 0.86294407, \
0.86426101, 0.86557292, 0.86687978, 0.86818155, 0.86947822, \
0.87076976, 0.87205614, 0.87333734, 0.87461333, 0.87588410, \
0.87714961, 0.87840984, 0.87966477, 0.88091437, 0.88215862, \
0.88339749, 0.88463097, 0.88585901, 0.88708161, 0.88829874, \
0.88951038, 0.89071649, 0.89191707, 0.89311207, 0.89430149, \
0.89548530, 0.89666347, 0.89783598, 0.89900281, 0.90016394, \
0.90131934, 0.90246899, 0.90361286, 0.90475095, 0.90588322, \
0.90700964, 0.90813021, 0.90924490, 0.91035368, 0.91145653, \
0.91255343, 0.91364437, 0.91472931, 0.91580824, 0.91688114, \
0.91794798, 0.91900874, 0.92006341, 0.92111196, 0.92215437, \
0.92319062, 0.92422069, 0.92524456, 0.92626221, 0.92727362, \
0.92827877, 0.92927763, 0.93027020, 0.93125645, 0.93223635, \
0.93320990, 0.93417707, 0.93513784, 0.93609220, 0.93704012, \
0.93798158, 0.93891657, 0.93984507, 0.94076705, 0.94168251, \
0.94259142, 0.94349377, 0.94438953, 0.94527869, 0.94616123, \
0.94703714, 0.94790639, 0.94876896, 0.94962485, 0.95047404, \
0.95131650, 0.95215222, 0.95298118, 0.95380337, 0.95461877, \
0.95542737, 0.95622914, 0.95702407, 0.95781215, 0.95859336, \
0.95936768, 0.96013510, 0.96089560, 0.96164918, 0.96239580, \
0.96313546, 0.96386815, 0.96459384, 0.96531252, 0.96602419, \
0.96672881, 0.96742639, 0.96811691, 0.96880034, 0.96947669, \
0.97014593, 0.97080805, 0.97146304, 0.97211088, 0.97275156, \
0.97338508, 0.97401140, 0.97463054, 0.97524246, 0.97584716, \
0.97644462, 0.97703484, 0.97761781, 0.97819350, 0.97876191, \
0.97932302, 0.97987684, 0.98042333, 0.98096250, 0.98149433, \
0.98201882, 0.98253594, 0.98304569, 0.98354807, 0.98404305, \
0.98453064, 0.98501081, 0.98548356, 0.98594888, 0.98640677, \
0.98685720, 0.98730018, 0.98773569, 0.98816373, 0.98858428, \
0.98899734, 0.98940290, 0.98980094, 0.99019147, 0.99057448, \
0.99094995, 0.99131788, 0.99167827, 0.99203109, 0.99237636, \
0.99271405, 0.99304417, 0.99336670, 0.99368164, 0.99398899, \
0.99428873, 0.99458087, 0.99486539, 0.99514229, 0.99541156, \
0.99567320, 0.99592720, 0.99617356, 0.99641228, 0.99664334, \
0.99686674, 0.99708248, 0.99729056, 0.99749096, 0.99768369, \
0.99786875, 0.99804612, 0.99821580, 0.99837780, 0.99853210, \
0.99867871, 0.99881762, 0.99894883, 0.99907233, 0.99918813, \
0.99929621, 0.99939659, 0.99948925, 0.99957420, 0.99965143, \
0.99972094, 0.99978274, 0.99983681, 0.99988315, 0.99992178, \
0.99995268, 0.99997586, 0.99999131, 0.99999903, } 

#define BLACKMAN4096 {\
0.00000000, 0.00000021, 0.00000085, 0.00000191, 0.00000339, \
0.00000530, 0.00000763, 0.00001038, 0.00001356, 0.00001716, \
0.00002119, 0.00002564, 0.00003051, 0.00003581, 0.00004154, \
0.00004768, 0.00005425, 0.00006125, 0.00006867, 0.00007651, \
0.00008478, 0.00009348, 0.00010259, 0.00011214, 0.00012210, \
0.00013250, 0.00014331, 0.00015456, 0.00016623, 0.00017832, \
0.00019084, 0.00020379, 0.00021716, 0.00023095, 0.00024518, \
0.00025983, 0.00027490, 0.00029040, 0.00030633, 0.00032269, \
0.00033947, 0.00035668, 0.00037432, 0.00039239, 0.00041088, \
0.00042980, 0.00044915, 0.00046893, 0.00048913, 0.00050977, \
0.00053083, 0.00055232, 0.00057424, 0.00059660, 0.00061938, \
0.00064259, 0.00066623, 0.00069030, 0.00071481, 0.00073974, \
0.00076511, 0.00079090, 0.00081713, 0.00084379, 0.00087089, \
0.00089841, 0.00092637, 0.00095476, 0.00098359, 0.00101285, \
0.00104254, 0.00107266, 0.00110323, 0.00113422, 0.00116565, \
0.00119752, 0.00122982, 0.00126256, 0.00129574, 0.00132935, \
0.00136340, 0.00139789, 0.00143281, 0.00146818, 0.00150398, \
0.00154022, 0.00157690, 0.00161402, 0.00165158, 0.00168958, \
0.00172802, 0.00176690, 0.00180622, 0.00184599, 0.00188620, \
0.00192685, 0.00196794, 0.00200948, 0.00205146, 0.00209388, \
0.00213675, 0.00218007, 0.00222383, 0.00226803, 0.00231268, \
0.00235778, 0.00240333, 0.00244933, 0.00249577, 0.00254266, \
0.00259000, 0.00263779, 0.00268603, 0.00273472, 0.00278386, \
0.00283345, 0.00288350, 0.00293400, 0.00298495, 0.00303635, \
0.00308821, 0.00314052, 0.00319328, 0.00324651, 0.00330018, \
0.00335432, 0.00340891, 0.00346396, 0.00351946, 0.00357543, \
0.00363185, 0.00368874, 0.00374608, 0.00380388, 0.00386215, \
0.00392088, 0.00398007, 0.00403972, 0.00409984, 0.00416042, \
0.00422146, 0.00428297, 0.00434495, 0.00440739, 0.00447030, \
0.00453367, 0.00459752, 0.00466183, 0.00472661, 0.00479187, \
0.00485759, 0.00492378, 0.00499045, 0.00505759, 0.00512520, \
0.00519328, 0.00526184, 0.00533088, 0.00540039, 0.00547037, \
0.00554084, 0.00561178, 0.00568319, 0.00575509, 0.00582747, \
0.00590032, 0.00597366, 0.00604748, 0.00612178, 0.00619656, \
0.00627183, 0.00634758, 0.00642382, 0.00650054, 0.00657775, \
0.00665544, 0.00673363, 0.00681230, 0.00689146, 0.00697111, \
0.00705125, 0.00713188, 0.00721300, 0.00729462, 0.00737672, \
0.00745933, 0.00754243, 0.00762602, 0.00771011, 0.00779470, \
0.00787978, 0.00796536, 0.00805145, 0.00813803, 0.00822511, \
0.00831270, 0.00840079, 0.00848938, 0.00857847, 0.00866807, \
0.00875818, 0.00884879, 0.00893991, 0.00903153, 0.00912367, \
0.00921631, 0.00930946, 0.00940313, 0.00949731, 0.00959200, \
0.00968720, 0.00978292, 0.00987915, 0.00997590, 0.01007316, \
0.01017095, 0.01026925, 0.01036807, 0.01046741, 0.01056727, \
0.01066765, 0.01076856, 0.01086999, 0.01097194, 0.01107442, \
0.01117743, 0.01128096, 0.01138502, 0.01148961, 0.01159472, \
0.01170037, 0.01180655, 0.01191326, 0.01202050, 0.01212828, \
0.01223659, 0.01234544, 0.01245483, 0.01256475, 0.01267521, \
0.01278621, 0.01289775, 0.01300983, 0.01312245, 0.01323562, \
0.01334933, 0.01346358, 0.01357838, 0.01369373, 0.01380962, \
0.01392606, 0.01404305, 0.01416059, 0.01427868, 0.01439733, \
0.01451653, 0.01463628, 0.01475658, 0.01487744, 0.01499886, \
0.01512084, 0.01524337, 0.01536647, 0.01549012, 0.01561434, \
0.01573912, 0.01586446, 0.01599037, 0.01611684, 0.01624388, \
0.01637149, 0.01649966, 0.01662841, 0.01675772, 0.01688761, \
0.01701806, 0.01714909, 0.01728070, 0.01741288, 0.01754564, \
0.01767897, 0.01781288, 0.01794737, 0.01808244, 0.01821810, \
0.01835433, 0.01849115, 0.01862855, 0.01876654, 0.01890511, \
0.01904427, 0.01918402, 0.01932436, 0.01946529, 0.01960681, \
0.01974892, 0.01989163, 0.02003493, 0.02017882, 0.02032332, \
0.02046841, 0.02061409, 0.02076038, 0.02090727, 0.02105476, \
0.02120285, 0.02135155, 0.02150085, 0.02165076, 0.02180127, \
0.02195240, 0.02210413, 0.02225647, 0.02240942, 0.02256299, \
0.02271717, 0.02287196, 0.02302737, 0.02318339, 0.02334003, \
0.02349729, 0.02365518, 0.02381368, 0.02397280, 0.02413254, \
0.02429291, 0.02445391, 0.02461553, 0.02477778, 0.02494065, \
0.02510416, 0.02526830, 0.02543306, 0.02559846, 0.02576450, \
0.02593117, 0.02609847, 0.02626641, 0.02643499, 0.02660421, \
0.02677407, 0.02694457, 0.02711572, 0.02728750, 0.02745993, \
0.02763301, 0.02780673, 0.02798111, 0.02815613, 0.02833180, \
0.02850812, 0.02868510, 0.02886272, 0.02904101, 0.02921995, \
0.02939954, 0.02957980, 0.02976071, 0.02994228, 0.03012451, \
0.03030741, 0.03049097, 0.03067520, 0.03086009, 0.03104564, \
0.03123187, 0.03141876, 0.03160633, 0.03179456, 0.03198347, \
0.03217305, 0.03236331, 0.03255424, 0.03274585, 0.03293814, \
0.03313111, 0.03332476, 0.03351909, 0.03371410, 0.03390979, \
0.03410617, 0.03430324, 0.03450099, 0.03469944, 0.03489857, \
0.03509839, 0.03529890, 0.03550011, 0.03570201, 0.03590460, \
0.03610789, 0.03631188, 0.03651657, 0.03672196, 0.03692805, \
0.03713484, 0.03734233, 0.03755052, 0.03775943, 0.03796904, \
0.03817935, 0.03839038, 0.03860211, 0.03881456, 0.03902771, \
0.03924159, 0.03945617, 0.03967147, 0.03988749, 0.04010423, \
0.04032168, 0.04053985, 0.04075875, 0.04097837, 0.04119871, \
0.04141978, 0.04164157, 0.04186409, 0.04208733, 0.04231131, \
0.04253602, 0.04276145, 0.04298762, 0.04321453, 0.04344217, \
0.04367054, 0.04389965, 0.04412950, 0.04436009, 0.04459142, \
0.04482350, 0.04505631, 0.04528987, 0.04552417, 0.04575922, \
0.04599502, 0.04623156, 0.04646886, 0.04670691, 0.04694570, \
0.04718525, 0.04742556, 0.04766662, 0.04790843, 0.04815101, \
0.04839434, 0.04863843, 0.04888329, 0.04912890, 0.04937528, \
0.04962242, 0.04987033, 0.05011900, 0.05036844, 0.05061865, \
0.05086963, 0.05112138, 0.05137391, 0.05162720, 0.05188127, \
0.05213612, 0.05239174, 0.05264814, 0.05290532, 0.05316328, \
0.05342201, 0.05368154, 0.05394184, 0.05420293, 0.05446480, \
0.05472746, 0.05499091, 0.05525515, 0.05552017, 0.05578599, \
0.05605260, 0.05632000, 0.05658820, 0.05685719, 0.05712697, \
0.05739756, 0.05766894, 0.05794113, 0.05821411, 0.05848789, \
0.05876248, 0.05903787, 0.05931407, 0.05959107, 0.05986888, \
0.06014750, 0.06042693, 0.06070717, 0.06098822, 0.06127008, \
0.06155275, 0.06183624, 0.06212055, 0.06240567, 0.06269161, \
0.06297837, 0.06326595, 0.06355435, 0.06384357, 0.06413362, \
0.06442449, 0.06471618, 0.06500870, 0.06530205, 0.06559623, \
0.06589123, 0.06618707, 0.06648374, 0.06678124, 0.06707957, \
0.06737874, 0.06767874, 0.06797958, 0.06828126, 0.06858378, \
0.06888714, 0.06919133, 0.06949637, 0.06980225, 0.07010898, \
0.07041655, 0.07072496, 0.07103423, 0.07134434, 0.07165530, \
0.07196710, 0.07227976, 0.07259328, 0.07290764, 0.07322286, \
0.07353893, 0.07385586, 0.07417364, 0.07449229, 0.07481179, \
0.07513215, 0.07545337, 0.07577545, 0.07609840, 0.07642221, \
0.07674688, 0.07707242, 0.07739883, 0.07772610, 0.07805424, \
0.07838325, 0.07871313, 0.07904388, 0.07937551, 0.07970800, \
0.08004137, 0.08037562, 0.08071074, 0.08104674, 0.08138362, \
0.08172137, 0.08206000, 0.08239952, 0.08273991, 0.08308119, \
0.08342335, 0.08376640, 0.08411033, 0.08445515, 0.08480085, \
0.08514744, 0.08549492, 0.08584329, 0.08619255, 0.08654270, \
0.08689374, 0.08724568, 0.08759851, 0.08795223, 0.08830685, \
0.08866237, 0.08901878, 0.08937609, 0.08973430, 0.09009341, \
0.09045342, 0.09081434, 0.09117615, 0.09153887, 0.09190249, \
0.09226702, 0.09263245, 0.09299879, 0.09336604, 0.09373420, \
0.09410326, 0.09447323, 0.09484412, 0.09521592, 0.09558862, \
0.09596225, 0.09633678, 0.09671223, 0.09708860, 0.09746588, \
0.09784408, 0.09822319, 0.09860323, 0.09898418, 0.09936605, \
0.09974885, 0.10013256, 0.10051720, 0.10090276, 0.10128925, \
0.10167666, 0.10206499, 0.10245425, 0.10284444, 0.10323556, \
0.10362760, 0.10402057, 0.10441447, 0.10480931, 0.10520507, \
0.10560176, 0.10599939, 0.10639795, 0.10679744, 0.10719787, \
0.10759924, 0.10800154, 0.10840477, 0.10880894, 0.10921405, \
0.10962010, 0.11002709, 0.11043502, 0.11084389, 0.11125370, \
0.11166445, 0.11207614, 0.11248878, 0.11290236, 0.11331689, \
0.11373236, 0.11414877, 0.11456613, 0.11498444, 0.11540370, \
0.11582390, 0.11624505, 0.11666715, 0.11709020, 0.11751420, \
0.11793915, 0.11836506, 0.11879191, 0.11921972, 0.11964848, \
0.12007819, 0.12050886, 0.12094049, 0.12137306, 0.12180660, \
0.12224109, 0.12267653, 0.12311294, 0.12355030, 0.12398862, \
0.12442790, 0.12486814, 0.12530934, 0.12575150, 0.12619462, \
0.12663870, 0.12708374, 0.12752975, 0.12797672, 0.12842465, \
0.12887354, 0.12932340, 0.12977423, 0.13022602, 0.13067877, \
0.13113249, 0.13158718, 0.13204283, 0.13249945, 0.13295704, \
0.13341559, 0.13387512, 0.13433561, 0.13479707, 0.13525951, \
0.13572291, 0.13618728, 0.13665262, 0.13711894, 0.13758622, \
0.13805448, 0.13852371, 0.13899391, 0.13946508, 0.13993723, \
0.14041035, 0.14088445, 0.14135952, 0.14183556, 0.14231258, \
0.14279057, 0.14326954, 0.14374949, 0.14423041, 0.14471230, \
0.14519518, 0.14567903, 0.14616385, 0.14664966, 0.14713644, \
0.14762420, 0.14811294, 0.14860265, 0.14909335, 0.14958502, \
0.15007768, 0.15057131, 0.15106592, 0.15156151, 0.15205808, \
0.15255563, 0.15305416, 0.15355367, 0.15405416, 0.15455564, \
0.15505809, 0.15556152, 0.15606594, 0.15657134, 0.15707772, \
0.15758508, 0.15809342, 0.15860274, 0.15911305, 0.15962434, \
0.16013661, 0.16064986, 0.16116410, 0.16167931, 0.16219551, \
0.16271270, 0.16323086, 0.16375001, 0.16427014, 0.16479126, \
0.16531336, 0.16583644, 0.16636050, 0.16688555, 0.16741158, \
0.16793860, 0.16846659, 0.16899557, 0.16952554, 0.17005649, \
0.17058842, 0.17112133, 0.17165523, 0.17219011, 0.17272597, \
0.17326282, 0.17380065, 0.17433946, 0.17487925, 0.17542003, \
0.17596179, 0.17650454, 0.17704826, 0.17759297, 0.17813866, \
0.17868534, 0.17923299, 0.17978163, 0.18033125, 0.18088186, \
0.18143344, 0.18198601, 0.18253955, 0.18309408, 0.18364959, \
0.18420609, 0.18476356, 0.18532201, 0.18588144, 0.18644186, \
0.18700325, 0.18756563, 0.18812898, 0.18869331, 0.18925863, \
0.18982492, 0.19039219, 0.19096044, 0.19152967, 0.19209987, \
0.19267105, 0.19324322, 0.19381635, 0.19439047, 0.19496556, \
0.19554163, 0.19611868, 0.19669670, 0.19727569, 0.19785567, \
0.19843661, 0.19901853, 0.19960143, 0.20018530, 0.20077014, \
0.20135596, 0.20194275, 0.20253051, 0.20311924, 0.20370895, \
0.20429963, 0.20489128, 0.20548389, 0.20607748, 0.20667204, \
0.20726757, 0.20786407, 0.20846153, 0.20905996, 0.20965936, \
0.21025973, 0.21086107, 0.21146337, 0.21206663, 0.21267087, \
0.21327606, 0.21388222, 0.21448935, 0.21509743, 0.21570648, \
0.21631650, 0.21692747, 0.21753940, 0.21815230, 0.21876616, \
0.21938097, 0.21999674, 0.22061348, 0.22123117, 0.22184981, \
0.22246942, 0.22308998, 0.22371149, 0.22433396, 0.22495739, \
0.22558176, 0.22620709, 0.22683338, 0.22746061, 0.22808880, \
0.22871793, 0.22934802, 0.22997905, 0.23061103, 0.23124396, \
0.23187784, 0.23251266, 0.23314843, 0.23378514, 0.23442280, \
0.23506140, 0.23570094, 0.23634143, 0.23698285, 0.23762522, \
0.23826853, 0.23891277, 0.23955795, 0.24020407, 0.24085113, \
0.24149912, 0.24214805, 0.24279791, 0.24344870, 0.24410043, \
0.24475308, 0.24540667, 0.24606119, 0.24671664, 0.24737301, \
0.24803031, 0.24868854, 0.24934770, 0.25000778, 0.25066878, \
0.25133070, 0.25199355, 0.25265732, 0.25332201, 0.25398761, \
0.25465414, 0.25532158, 0.25598994, 0.25665921, 0.25732940, \
0.25800050, 0.25867252, 0.25934544, 0.26001928, 0.26069402, \
0.26136967, 0.26204623, 0.26272370, 0.26340207, 0.26408135, \
0.26476153, 0.26544261, 0.26612459, 0.26680747, 0.26749125, \
0.26817593, 0.26886151, 0.26954798, 0.27023535, 0.27092360, \
0.27161276, 0.27230280, 0.27299373, 0.27368555, 0.27437826, \
0.27507186, 0.27576634, 0.27646170, 0.27715795, 0.27785508, \
0.27855309, 0.27925198, 0.27995175, 0.28065240, 0.28135392, \
0.28205631, 0.28275958, 0.28346373, 0.28416874, 0.28487462, \
0.28558137, 0.28628899, 0.28699747, 0.28770682, 0.28841703, \
0.28912810, 0.28984003, 0.29055283, 0.29126648, 0.29198098, \
0.29269635, 0.29341256, 0.29412963, 0.29484755, 0.29556632, \
0.29628594, 0.29700641, 0.29772772, 0.29844987, 0.29917287, \
0.29989671, 0.30062139, 0.30134691, 0.30207327, 0.30280046, \
0.30352849, 0.30425735, 0.30498704, 0.30571756, 0.30644891, \
0.30718108, 0.30791409, 0.30864791, 0.30938256, 0.31011803, \
0.31085432, 0.31159142, 0.31232935, 0.31306809, 0.31380764, \
0.31454800, 0.31528918, 0.31603116, 0.31677395, 0.31751754, \
0.31826194, 0.31900714, 0.31975314, 0.32049995, 0.32124754, \
0.32199594, 0.32274513, 0.32349511, 0.32424588, 0.32499744, \
0.32574979, 0.32650293, 0.32725685, 0.32801155, 0.32876703, \
0.32952329, 0.33028033, 0.33103815, 0.33179674, 0.33255610, \
0.33331623, 0.33407714, 0.33483880, 0.33560124, 0.33636444, \
0.33712840, 0.33789312, 0.33865859, 0.33942483, 0.34019182, \
0.34095956, 0.34172805, 0.34249730, 0.34326729, 0.34403802, \
0.34480950, 0.34558172, 0.34635468, 0.34712838, 0.34790282, \
0.34867799, 0.34945389, 0.35023053, 0.35100789, 0.35178598, \
0.35256479, 0.35334433, 0.35412459, 0.35490557, 0.35568726, \
0.35646967, 0.35725280, 0.35803663, 0.35882118, 0.35960643, \
0.36039239, 0.36117905, 0.36196641, 0.36275447, 0.36354323, \
0.36433269, 0.36512284, 0.36591368, 0.36670521, 0.36749742, \
0.36829032, 0.36908391, 0.36987818, 0.37067312, 0.37146875, \
0.37226504, 0.37306201, 0.37385966, 0.37465797, 0.37545694, \
0.37625658, 0.37705689, 0.37785785, 0.37865947, 0.37946175, \
0.38026468, 0.38106827, 0.38187250, 0.38267738, 0.38348290, \
0.38428907, 0.38509588, 0.38590333, 0.38671141, 0.38752013, \
0.38832948, 0.38913945, 0.38995006, 0.39076129, 0.39157315, \
0.39238562, 0.39319871, 0.39401242, 0.39482675, 0.39564168, \
0.39645723, 0.39727338, 0.39809013, 0.39890749, 0.39972545, \
0.40054400, 0.40136316, 0.40218290, 0.40300324, 0.40382416, \
0.40464567, 0.40546776, 0.40629044, 0.40711369, 0.40793752, \
0.40876193, 0.40958690, 0.41041245, 0.41123856, 0.41206524, \
0.41289248, 0.41372028, 0.41454863, 0.41537754, 0.41620701, \
0.41703702, 0.41786758, 0.41869869, 0.41953034, 0.42036253, \
0.42119525, 0.42202852, 0.42286231, 0.42369664, 0.42453149, \
0.42536686, 0.42620277, 0.42703919, 0.42787612, 0.42871358, \
0.42955154, 0.43039002, 0.43122900, 0.43206849, 0.43290848, \
0.43374896, 0.43458995, 0.43543143, 0.43627340, 0.43711587, \
0.43795881, 0.43880225, 0.43964616, 0.44049055, 0.44133542, \
0.44218077, 0.44302658, 0.44387286, 0.44471961, 0.44556682, \
0.44641449, 0.44726262, 0.44811120, 0.44896024, 0.44980972, \
0.45065966, 0.45151003, 0.45236085, 0.45321211, 0.45406380, \
0.45491592, 0.45576848, 0.45662147, 0.45747487, 0.45832871, \
0.45918296, 0.46003763, 0.46089271, 0.46174820, 0.46260410, \
0.46346041, 0.46431712, 0.46517423, 0.46603174, 0.46688964, \
0.46774794, 0.46860662, 0.46946569, 0.47032514, 0.47118497, \
0.47204518, 0.47290577, 0.47376673, 0.47462805, 0.47548974, \
0.47635180, 0.47721421, 0.47807699, 0.47894012, 0.47980360, \
0.48066742, 0.48153160, 0.48239612, 0.48326097, 0.48412617, \
0.48499170, 0.48585756, 0.48672375, 0.48759026, 0.48845710, \
0.48932425, 0.49019173, 0.49105951, 0.49192761, 0.49279602, \
0.49366473, 0.49453374, 0.49540305, 0.49627266, 0.49714256, \
0.49801275, 0.49888322, 0.49975398, 0.50062502, 0.50149634, \
0.50236793, 0.50323980, 0.50411193, 0.50498433, 0.50585699, \
0.50672991, 0.50760309, 0.50847652, 0.50935020, 0.51022413, \
0.51109831, 0.51197272, 0.51284737, 0.51372226, 0.51459738, \
0.51547272, 0.51634830, 0.51722409, 0.51810011, 0.51897634, \
0.51985278, 0.52072944, 0.52160630, 0.52248337, 0.52336063, \
0.52423809, 0.52511575, 0.52599360, 0.52687164, 0.52774986, \
0.52862826, 0.52950684, 0.53038560, 0.53126453, 0.53214363, \
0.53302289, 0.53390232, 0.53478190, 0.53566164, 0.53654154, \
0.53742158, 0.53830177, 0.53918211, 0.54006258, 0.54094319, \
0.54182394, 0.54270481, 0.54358581, 0.54446694, 0.54534819, \
0.54622955, 0.54711103, 0.54799262, 0.54887431, 0.54975611, \
0.55063801, 0.55152001, 0.55240211, 0.55328429, 0.55416656, \
0.55504892, 0.55593136, 0.55681387, 0.55769646, 0.55857912, \
0.55946185, 0.56034465, 0.56122750, 0.56211042, 0.56299339, \
0.56387641, 0.56475947, 0.56564258, 0.56652574, 0.56740893, \
0.56829215, 0.56917541, 0.57005870, 0.57094201, 0.57182534, \
0.57270868, 0.57359205, 0.57447542, 0.57535880, 0.57624219, \
0.57712557, 0.57800896, 0.57889233, 0.57977570, 0.58065906, \
0.58154240, 0.58242572, 0.58330901, 0.58419228, 0.58507552, \
0.58595873, 0.58684190, 0.58772503, 0.58860812, 0.58949115, \
0.59037414, 0.59125708, 0.59213996, 0.59302277, 0.59390552, \
0.59478821, 0.59567082, 0.59655336, 0.59743582, 0.59831820, \
0.59920049, 0.60008270, 0.60096481, 0.60184683, 0.60272875, \
0.60361057, 0.60449228, 0.60537388, 0.60625537, 0.60713674, \
0.60801799, 0.60889912, 0.60978012, 0.61066099, 0.61154173, \
0.61242233, 0.61330278, 0.61418310, 0.61506326, 0.61594328, \
0.61682314, 0.61770284, 0.61858237, 0.61946175, 0.62034095, \
0.62121998, 0.62209883, 0.62297751, 0.62385600, 0.62473430, \
0.62561242, 0.62649034, 0.62736806, 0.62824558, 0.62912289, \
0.63000000, 0.63087690, 0.63175358, 0.63263004, 0.63350627, \
0.63438229, 0.63525807, 0.63613362, 0.63700893, 0.63788400, \
0.63875883, 0.63963341, 0.64050774, 0.64138181, 0.64225563, \
0.64312918, 0.64400247, 0.64487549, 0.64574823, 0.64662070, \
0.64749289, 0.64836480, 0.64923642, 0.65010774, 0.65097878, \
0.65184951, 0.65271995, 0.65359008, 0.65445990, 0.65532940, \
0.65619859, 0.65706746, 0.65793601, 0.65880423, 0.65967212, \
0.66053968, 0.66140690, 0.66227377, 0.66314031, 0.66400649, \
0.66487232, 0.66573779, 0.66660291, 0.66746766, 0.66833204, \
0.66919606, 0.67005970, 0.67092296, 0.67178584, 0.67264833, \
0.67351044, 0.67437216, 0.67523347, 0.67609439, 0.67695491, \
0.67781501, 0.67867471, 0.67953399, 0.68039286, 0.68125130, \
0.68210932, 0.68296691, 0.68382407, 0.68468079, 0.68553707, \
0.68639290, 0.68724829, 0.68810323, 0.68895772, 0.68981174, \
0.69066531, 0.69151841, 0.69237104, 0.69322319, 0.69407487, \
0.69492607, 0.69577679, 0.69662702, 0.69747676, 0.69832600, \
0.69917474, 0.70002299, 0.70087072, 0.70171795, 0.70256466, \
0.70341086, 0.70425654, 0.70510169, 0.70594631, 0.70679041, \
0.70763397, 0.70847699, 0.70931946, 0.71016139, 0.71100277, \
0.71184360, 0.71268387, 0.71352358, 0.71436273, 0.71520131, \
0.71603931, 0.71687674, 0.71771359, 0.71854986, 0.71938554, \
0.72022063, 0.72105513, 0.72188903, 0.72272233, 0.72355502, \
0.72438711, 0.72521858, 0.72604944, 0.72687968, 0.72770930, \
0.72853828, 0.72936664, 0.73019437, 0.73102145, 0.73184790, \
0.73267370, 0.73349885, 0.73432335, 0.73514719, 0.73597038, \
0.73679290, 0.73761475, 0.73843593, 0.73925644, 0.74007627, \
0.74089542, 0.74171389, 0.74253166, 0.74334874, 0.74416513, \
0.74498082, 0.74579580, 0.74661008, 0.74742364, 0.74823649, \
0.74904862, 0.74986004, 0.75067072, 0.75148068, 0.75228990, \
0.75309839, 0.75390614, 0.75471315, 0.75551940, 0.75632491, \
0.75712966, 0.75793366, 0.75873689, 0.75953936, 0.76034106, \
0.76114199, 0.76194214, 0.76274151, 0.76354010, 0.76433790, \
0.76513491, 0.76593113, 0.76672654, 0.76752116, 0.76831497, \
0.76910798, 0.76990017, 0.77069155, 0.77148210, 0.77227184, \
0.77306074, 0.77384882, 0.77463607, 0.77542247, 0.77620804, \
0.77699276, 0.77777663, 0.77855965, 0.77934182, 0.78012313, \
0.78090357, 0.78168315, 0.78246186, 0.78323970, 0.78401666, \
0.78479274, 0.78556793, 0.78634224, 0.78711566, 0.78788818, \
0.78865981, 0.78943053, 0.79020035, 0.79096926, 0.79173726, \
0.79250434, 0.79327051, 0.79403575, 0.79480006, 0.79556345, \
0.79632590, 0.79708741, 0.79784799, 0.79860762, 0.79936630, \
0.80012403, 0.80088081, 0.80163663, 0.80239149, 0.80314538, \
0.80389831, 0.80465026, 0.80540124, 0.80615124, 0.80690026, \
0.80764829, 0.80839533, 0.80914138, 0.80988643, 0.81063048, \
0.81137353, 0.81211557, 0.81285661, 0.81359663, 0.81433563, \
0.81507361, 0.81581057, 0.81654650, 0.81728140, 0.81801526, \
0.81874809, 0.81947988, 0.82021062, 0.82094031, 0.82166895, \
0.82239654, 0.82312307, 0.82384854, 0.82457294, 0.82529627, \
0.82601854, 0.82673972, 0.82745983, 0.82817886, 0.82889680, \
0.82961365, 0.83032941, 0.83104408, 0.83175764, 0.83247010, \
0.83318146, 0.83389171, 0.83460085, 0.83530887, 0.83601577, \
0.83672155, 0.83742620, 0.83812973, 0.83883212, 0.83953337, \
0.84023349, 0.84093247, 0.84163029, 0.84232698, 0.84302250, \
0.84371688, 0.84441009, 0.84510214, 0.84579303, 0.84648274, \
0.84717129, 0.84785866, 0.84854485, 0.84922986, 0.84991368, \
0.85059632, 0.85127776, 0.85195801, 0.85263706, 0.85331491, \
0.85399156, 0.85466699, 0.85534122, 0.85601423, 0.85668603, \
0.85735660, 0.85802595, 0.85869407, 0.85936096, 0.86002662, \
0.86069105, 0.86135423, 0.86201617, 0.86267686, 0.86333630, \
0.86399449, 0.86465143, 0.86530711, 0.86596152, 0.86661467, \
0.86726655, 0.86791716, 0.86856650, 0.86921455, 0.86986133, \
0.87050682, 0.87115103, 0.87179394, 0.87243556, 0.87307589, \
0.87371492, 0.87435264, 0.87498906, 0.87562417, 0.87625796, \
0.87689045, 0.87752161, 0.87815146, 0.87877998, 0.87940717, \
0.88003303, 0.88065756, 0.88128076, 0.88190261, 0.88252313, \
0.88314229, 0.88376011, 0.88437658, 0.88499170, 0.88560545, \
0.88621785, 0.88682888, 0.88743855, 0.88804685, 0.88865378, \
0.88925933, 0.88986351, 0.89046630, 0.89106771, 0.89166773, \
0.89226637, 0.89286361, 0.89345946, 0.89405390, 0.89464695, \
0.89523859, 0.89582883, 0.89641765, 0.89700507, 0.89759106, \
0.89817564, 0.89875880, 0.89934054, 0.89992084, 0.90049972, \
0.90107716, 0.90165317, 0.90222774, 0.90280087, 0.90337256, \
0.90394280, 0.90451159, 0.90507892, 0.90564480, 0.90620923, \
0.90677219, 0.90733369, 0.90789373, 0.90845229, 0.90900938, \
0.90956500, 0.91011915, 0.91067181, 0.91122299, 0.91177268, \
0.91232089, 0.91286760, 0.91341283, 0.91395655, 0.91449878, \
0.91503951, 0.91557873, 0.91611645, 0.91665265, 0.91718735, \
0.91772053, 0.91825219, 0.91878233, 0.91931095, 0.91983805, \
0.92036362, 0.92088766, 0.92141016, 0.92193113, 0.92245056, \
0.92296845, 0.92348480, 0.92399960, 0.92451285, 0.92502456, \
0.92553471, 0.92604330, 0.92655034, 0.92705581, 0.92755972, \
0.92806207, 0.92856284, 0.92906205, 0.92955968, 0.93005574, \
0.93055022, 0.93104312, 0.93153443, 0.93202416, 0.93251230, \
0.93299885, 0.93348381, 0.93396718, 0.93444894, 0.93492911, \
0.93540767, 0.93588463, 0.93635998, 0.93683372, 0.93730585, \
0.93777637, 0.93824526, 0.93871254, 0.93917820, 0.93964224, \
0.94010465, 0.94056543, 0.94102458, 0.94148210, 0.94193798, \
0.94239222, 0.94284483, 0.94329579, 0.94374511, 0.94419279, \
0.94463881, 0.94508319, 0.94552591, 0.94596697, 0.94640638, \
0.94684413, 0.94728022, 0.94771464, 0.94814740, 0.94857849, \
0.94900791, 0.94943565, 0.94986172, 0.95028612, 0.95070883, \
0.95112987, 0.95154922, 0.95196688, 0.95238286, 0.95279715, \
0.95320974, 0.95362065, 0.95402985, 0.95443736, 0.95484317, \
0.95524728, 0.95564969, 0.95605038, 0.95644937, 0.95684666, \
0.95724222, 0.95763608, 0.95802822, 0.95841864, 0.95880734, \
0.95919432, 0.95957957, 0.95996310, 0.96034491, 0.96072498, \
0.96110332, 0.96147993, 0.96185480, 0.96222794, 0.96259934, \
0.96296899, 0.96333691, 0.96370308, 0.96406750, 0.96443017, \
0.96479110, 0.96515027, 0.96550769, 0.96586335, 0.96621726, \
0.96656941, 0.96691979, 0.96726842, 0.96761528, 0.96796037, \
0.96830370, 0.96864525, 0.96898504, 0.96932305, 0.96965929, \
0.96999375, 0.97032643, 0.97065733, 0.97098646, 0.97131379, \
0.97163935, 0.97196312, 0.97228510, 0.97260528, 0.97292368, \
0.97324029, 0.97355510, 0.97386812, 0.97417933, 0.97448875, \
0.97479637, 0.97510218, 0.97540620, 0.97570840, 0.97600880, \
0.97630739, 0.97660417, 0.97689914, 0.97719230, 0.97748364, \
0.97777316, 0.97806087, 0.97834676, 0.97863083, 0.97891308, \
0.97919350, 0.97947210, 0.97974887, 0.98002382, 0.98029694, \
0.98056822, 0.98083768, 0.98110530, 0.98137109, 0.98163504, \
0.98189716, 0.98215744, 0.98241587, 0.98267247, 0.98292723, \
0.98318014, 0.98343120, 0.98368042, 0.98392780, 0.98417332, \
0.98441699, 0.98465882, 0.98489879, 0.98513691, 0.98537317, \
0.98560758, 0.98584012, 0.98607082, 0.98629965, 0.98652662, \
0.98675173, 0.98697497, 0.98719636, 0.98741587, 0.98763352, \
0.98784931, 0.98806322, 0.98827527, 0.98848544, 0.98869374, \
0.98890017, 0.98910473, 0.98930741, 0.98950821, 0.98970714, \
0.98990419, 0.99009936, 0.99029265, 0.99048406, 0.99067359, \
0.99086124, 0.99104700, 0.99123088, 0.99141287, 0.99159297, \
0.99177119, 0.99194751, 0.99212195, 0.99229450, 0.99246516, \
0.99263392, 0.99280080, 0.99296577, 0.99312886, 0.99329005, \
0.99344934, 0.99360673, 0.99376223, 0.99391583, 0.99406753, \
0.99421733, 0.99436523, 0.99451122, 0.99465532, 0.99479751, \
0.99493779, 0.99507618, 0.99521265, 0.99534722, 0.99547989, \
0.99561064, 0.99573949, 0.99586643, 0.99599146, 0.99611458, \
0.99623579, 0.99635509, 0.99647248, 0.99658795, 0.99670151, \
0.99681316, 0.99692289, 0.99703071, 0.99713662, 0.99724060, \
0.99734268, 0.99744283, 0.99754107, 0.99763738, 0.99773178, \
0.99782427, 0.99791483, 0.99800347, 0.99809019, 0.99817499, \
0.99825787, 0.99833883, 0.99841787, 0.99849498, 0.99857017, \
0.99864344, 0.99871479, 0.99878421, 0.99885170, 0.99891728, \
0.99898092, 0.99904264, 0.99910244, 0.99916031, 0.99921625, \
0.99927027, 0.99932236, 0.99937253, 0.99942076, 0.99946707, \
0.99951145, 0.99955391, 0.99959443, 0.99963303, 0.99966969, \
0.99970443, 0.99973724, 0.99976812, 0.99979708, 0.99982410, \
0.99984919, 0.99987235, 0.99989359, 0.99991289, 0.99993026, \
0.99994571, 0.99995922, 0.99997080, 0.99998045, 0.99998818, \
0.99999397, 0.99999783, 0.99999976, } 


 #endif // _FPU_FFT_BLACKMAN_H_
//=============================================================================
// End of File
//=============================================================================
