//=============================================================================
// Blackmanharris Window 
//=============================================================================
#ifndef _FPU_FFT_BLACKMANHARRIS_H_
#define _FPU_FFT_BLACKMANHARRIS_H_

#define BLACKMANHARRIS32 {\
0.00006000, 0.00069917, 0.00331281, 0.00997433, 0.02404092, \
0.04986335, 0.09217934, 0.15515234, 0.24115767, 0.34956630, \
0.47587082, 0.61148961, 0.74445942, 0.86100833, 0.94775351, \
0.99406708, } 

#define BLACKMANHARRIS64 {\
0.00006000, 0.00020410, 0.00067727, 0.00160201, 0.00318210, \
0.00570128, 0.00952029, 0.01507117, 0.02284778, 0.03339172, \
0.04727299, 0.06506514, 0.08731538, 0.11451042, 0.14703956, \
0.18515707, 0.22894618, 0.27828737, 0.33283350, 0.39199450, \
0.45493331, 0.52057500, 0.58762931, 0.65462683, 0.71996741, \
0.78197899, 0.83898400, 0.88936977, 0.93165927, 0.96457794, \
0.98711285, 0.99856051, } 

#define BLACKMANHARRIS128 {\
0.00006000, 0.00009483, 0.00020179, 0.00038830, 0.00066674, \
0.00105442, 0.00157356, 0.00225133, 0.00311970, 0.00421547, \
0.00558012, 0.00725968, 0.00930454, 0.01176921, 0.01471203, \
0.01819474, 0.02228210, 0.02704131, 0.03254143, 0.03885264, \
0.04604553, 0.05419017, 0.06335527, 0.07360708, 0.08500844, \
0.09761763, 0.11148723, 0.12666304, 0.14318288, 0.16107550, \
0.18035950, 0.20104229, 0.22311918, 0.24657249, 0.27137086, \
0.29746867, 0.32480555, 0.35330618, 0.38288016, 0.41342216, \
0.44481218, 0.47691609, 0.50958637, 0.54266298, 0.57597455, \
0.60933964, 0.64256825, 0.67546351, 0.70782341, 0.73944280, \
0.77011533, 0.79963562, 0.82780135, 0.85441543, 0.87928816, \
0.90223927, 0.92309999, 0.94171497, 0.95794401, 0.97166377, \
0.98276910, 0.99117439, 0.99681451, 0.99964560, } 

#define BLACKMANHARRIS256 {\
0.00006000, 0.00006860, 0.00009455, 0.00013832, 0.00020065, \
0.00028262, 0.00038560, 0.00051126, 0.00066158, 0.00083884, \
0.00104563, 0.00128484, 0.00155964, 0.00187355, 0.00223033, \
0.00263409, 0.00308920, 0.00360034, 0.00417247, 0.00481084, \
0.00552098, 0.00630870, 0.00718006, 0.00814141, 0.00919934, \
0.01036068, 0.01163251, 0.01302212, 0.01453703, 0.01618495, \
0.01797378, 0.01991159, 0.02200659, 0.02426716, 0.02670175, \
0.02931895, 0.03212740, 0.03513580, 0.03835286, 0.04178733, \
0.04544788, 0.04934319, 0.05348180, 0.05787218, 0.06252264, \
0.06744132, 0.07263615, 0.07811482, 0.08388475, 0.08995306, \
0.09632651, 0.10301149, 0.11001398, 0.11733952, 0.12499316, \
0.13297941, 0.14130228, 0.14996514, 0.15897078, 0.16832133, \
0.17801823, 0.18806221, 0.19845326, 0.20919063, 0.22027273, \
0.23169719, 0.24346078, 0.25555943, 0.26798819, 0.28074121, \
0.29381174, 0.30719212, 0.32087377, 0.33484718, 0.34910191, \
0.36362660, 0.37840896, 0.39343578, 0.40869295, 0.42416547, \
0.43983746, 0.45569219, 0.47171207, 0.48787873, 0.50417301, \
0.52057500, 0.53706408, 0.55361894, 0.57021767, 0.58683774, \
0.60345608, 0.62004914, 0.63659291, 0.65306299, 0.66943466, \
0.68568289, 0.70178248, 0.71770802, 0.73343404, 0.74893503, \
0.76418550, 0.77916006, 0.79383351, 0.80818084, 0.82217737, \
0.83579875, 0.84902107, 0.86182093, 0.87417545, 0.88606241, \
0.89746024, 0.90834813, 0.91870606, 0.92851487, 0.93775632, \
0.94641312, 0.95446901, 0.96190878, 0.96871833, 0.97488471, \
0.98039615, 0.98524209, 0.98941323, 0.99290156, 0.99570034, \
0.99780417, 0.99920899, 0.99991208, } 

#define BLACKMANHARRIS512 {\
0.00006000, 0.00006214, 0.00006857, 0.00007931, 0.00009442, \
0.00011396, 0.00013801, 0.00016668, 0.00020009, 0.00023839, \
0.00028172, 0.00033028, 0.00038427, 0.00044389, 0.00050938, \
0.00058100, 0.00065903, 0.00074375, 0.00083548, 0.00093454, \
0.00104128, 0.00115608, 0.00127932, 0.00141141, 0.00155276, \
0.00170382, 0.00186505, 0.00203692, 0.00221995, 0.00241464, \
0.00262153, 0.00284117, 0.00307413, 0.00332100, 0.00358238, \
0.00385891, 0.00415123, 0.00445998, 0.00478586, 0.00512955, \
0.00549177, 0.00587325, 0.00627472, 0.00669696, 0.00714074, \
0.00760686, 0.00809612, 0.00860935, 0.00914739, 0.00971110, \
0.01030135, 0.01091902, 0.01156501, 0.01224024, 0.01294563, \
0.01368211, 0.01445065, 0.01525220, 0.01608773, 0.01695825, \
0.01786473, 0.01880818, 0.01978964, 0.02081011, 0.02187063, \
0.02297225, 0.02411601, 0.02530297, 0.02653419, 0.02781074, \
0.02913369, 0.03050412, 0.03192310, 0.03339172, 0.03491107, \
0.03648222, 0.03810626, 0.03978427, 0.04151735, 0.04330656, \
0.04515299, 0.04705771, 0.04902178, 0.05104628, 0.05313226, \
0.05528076, 0.05749283, 0.05976950, 0.06211178, 0.06452068, \
0.06699720, 0.06954232, 0.07215700, 0.07484220, 0.07759886, \
0.08042788, 0.08333017, 0.08630661, 0.08935804, 0.09248532, \
0.09568923, 0.09897058, 0.10233013, 0.10576861, 0.10928673, \
0.11288516, 0.11656456, 0.12032555, 0.12416871, 0.12809460, \
0.13210374, 0.13619660, 0.14037365, 0.14463529, 0.14898189, \
0.15341380, 0.15793130, 0.16253465, 0.16722405, 0.17199969, \
0.17686167, 0.18181009, 0.18684497, 0.19196630, 0.19717403, \
0.20246804, 0.20784817, 0.21331423, 0.21886594, 0.22450301, \
0.23022508, 0.23603172, 0.24192247, 0.24789682, 0.25395419, \
0.26009396, 0.26631543, 0.27261787, 0.27900048, 0.28546241, \
0.29200276, 0.29862056, 0.30531478, 0.31208436, 0.31892814, \
0.32584494, 0.33283350, 0.33989252, 0.34702063, 0.35421640, \
0.36147836, 0.36880496, 0.37619460, 0.38364564, 0.39115636, \
0.39872501, 0.40634976, 0.41402873, 0.42175999, 0.42954157, \
0.43737142, 0.44524746, 0.45316754, 0.46112946, 0.46913099, \
0.47716983, 0.48524364, 0.49335003, 0.50148656, 0.50965076, \
0.51784008, 0.52605197, 0.53428381, 0.54253295, 0.55079669, \
0.55907231, 0.56735703, 0.57564804, 0.58394252, 0.59223758, \
0.60053033, 0.60881783, 0.61709713, 0.62536522, 0.63361911, \
0.64185575, 0.65007210, 0.65826506, 0.66643156, 0.67456847, \
0.68267268, 0.69074104, 0.69877041, 0.70675763, 0.71469954, \
0.72259297, 0.73043475, 0.73822171, 0.74595068, 0.75361849, \
0.76122198, 0.76875800, 0.77622340, 0.78361504, 0.79092982, \
0.79816462, 0.80531635, 0.81238196, 0.81935838, 0.82624260, \
0.83303163, 0.83972249, 0.84631224, 0.85279798, 0.85917683, \
0.86544595, 0.87160255, 0.87764386, 0.88356716, 0.88936977, \
0.89504907, 0.90060247, 0.90602743, 0.91132147, 0.91648217, \
0.92150713, 0.92639404, 0.93114063, 0.93574470, 0.94020410, \
0.94451676, 0.94868064, 0.95269381, 0.95655436, 0.96026049, \
0.96381044, 0.96720253, 0.97043516, 0.97350680, 0.97641597, \
0.97916130, 0.98174147, 0.98415526, 0.98640152, 0.98847915, \
0.99038718, 0.99212468, 0.99369082, 0.99508485, 0.99630610, \
0.99735398, 0.99822799, 0.99892770, 0.99945277, 0.99980297, \
0.99997811, } 

#define BLACKMANHARRIS1024 {\
0.00006000, 0.00006053, 0.00006214, 0.00006481, 0.00006855, \
0.00007337, 0.00007927, 0.00008626, 0.00009435, 0.00010354, \
0.00011385, 0.00012528, 0.00013785, 0.00015158, 0.00016647, \
0.00018254, 0.00019981, 0.00021830, 0.00023803, 0.00025901, \
0.00028127, 0.00030484, 0.00032973, 0.00035598, 0.00038360, \
0.00041263, 0.00044309, 0.00047502, 0.00050844, 0.00054339, \
0.00057991, 0.00061802, 0.00065776, 0.00069917, 0.00074228, \
0.00078715, 0.00083380, 0.00088228, 0.00093263, 0.00098490, \
0.00103912, 0.00109536, 0.00115364, 0.00121404, 0.00127658, \
0.00134133, 0.00140834, 0.00147765, 0.00154933, 0.00162343, \
0.00170000, 0.00177911, 0.00186082, 0.00194517, 0.00203225, \
0.00212210, 0.00221479, 0.00231039, 0.00240896, 0.00251057, \
0.00261528, 0.00272318, 0.00283432, 0.00294878, 0.00306663, \
0.00318795, 0.00331281, 0.00344129, 0.00357346, 0.00370940, \
0.00384920, 0.00399292, 0.00414066, 0.00429250, 0.00444852, \
0.00460880, 0.00477344, 0.00494251, 0.00511611, 0.00529433, \
0.00547725, 0.00566497, 0.00585758, 0.00605517, 0.00625784, \
0.00646568, 0.00667879, 0.00689726, 0.00712120, 0.00735070, \
0.00758587, 0.00782681, 0.00807361, 0.00832638, 0.00858523, \
0.00885026, 0.00912158, 0.00939929, 0.00968350, 0.00997433, \
0.01027187, 0.01057625, 0.01088757, 0.01120594, 0.01153148, \
0.01186430, 0.01220453, 0.01255226, 0.01290762, 0.01327074, \
0.01364171, 0.01402067, 0.01440773, 0.01480302, 0.01520665, \
0.01561875, 0.01603944, 0.01646884, 0.01690707, 0.01735427, \
0.01781055, 0.01827604, 0.01875087, 0.01923517, 0.01972905, \
0.02023266, 0.02074611, 0.02126955, 0.02180309, 0.02234686, \
0.02290101, 0.02346565, 0.02404092, 0.02462696, 0.02522389, \
0.02583184, 0.02645095, 0.02708136, 0.02772319, 0.02837658, \
0.02904167, 0.02971858, 0.03040745, 0.03110842, 0.03182162, \
0.03254719, 0.03328526, 0.03403596, 0.03479944, 0.03557582, \
0.03636525, 0.03716785, 0.03798376, 0.03881312, 0.03965607, \
0.04051273, 0.04138324, 0.04226774, 0.04316636, 0.04407924, \
0.04500651, 0.04594830, 0.04690474, 0.04787598, 0.04886214, \
0.04986335, 0.05087975, 0.05191147, 0.05295864, 0.05402138, \
0.05509984, 0.05619414, 0.05730440, 0.05843076, 0.05957334, \
0.06073227, 0.06190768, 0.06309970, 0.06430843, 0.06553402, \
0.06677658, 0.06803624, 0.06931311, 0.07060732, 0.07191899, \
0.07324823, 0.07459516, 0.07595989, 0.07734255, 0.07874325, \
0.08016210, 0.08159920, 0.08305468, 0.08452864, 0.08602118, \
0.08753242, 0.08906246, 0.09061140, 0.09217934, 0.09376639, \
0.09537264, 0.09699820, 0.09864315, 0.10030760, 0.10199163, \
0.10369534, 0.10541881, 0.10716214, 0.10892541, 0.11070870, \
0.11251210, 0.11433569, 0.11617954, 0.11804373, 0.11992834, \
0.12183343, 0.12375909, 0.12570537, 0.12767235, 0.12966008, \
0.13166864, 0.13369807, 0.13574845, 0.13781981, 0.13991222, \
0.14202573, 0.14416038, 0.14631623, 0.14849330, 0.15069166, \
0.15291132, 0.15515234, 0.15741474, 0.15969855, 0.16200381, \
0.16433053, 0.16667875, 0.16904847, 0.17143973, 0.17385252, \
0.17628688, 0.17874279, 0.18122028, 0.18371935, 0.18623998, \
0.18878219, 0.19134597, 0.19393131, 0.19653819, 0.19916661, \
0.20181654, 0.20448797, 0.20718087, 0.20989522, 0.21263098, \
0.21538813, 0.21816662, 0.22096642, 0.22378749, 0.22662978, \
0.22949323, 0.23237781, 0.23528344, 0.23821009, 0.24115767, \
0.24412613, 0.24711539, 0.25012539, 0.25315605, 0.25620729, \
0.25927903, 0.26237118, 0.26548365, 0.26861635, 0.27176918, \
0.27494204, 0.27813483, 0.28134745, 0.28457977, 0.28783170, \
0.29110310, 0.29439387, 0.29770386, 0.30103297, 0.30438105, \
0.30774796, 0.31113358, 0.31453776, 0.31796035, 0.32140120, \
0.32486016, 0.32833707, 0.33183177, 0.33534410, 0.33887390, \
0.34242098, 0.34598517, 0.34956630, 0.35316419, 0.35677864, \
0.36040947, 0.36405650, 0.36771951, 0.37139831, 0.37509270, \
0.37880248, 0.38252742, 0.38626733, 0.39002197, 0.39379113, \
0.39757459, 0.40137212, 0.40518349, 0.40900845, 0.41284679, \
0.41669825, 0.42056258, 0.42443955, 0.42832890, 0.43223037, \
0.43614371, 0.44006866, 0.44400495, 0.44795232, 0.45191048, \
0.45587918, 0.45985813, 0.46384706, 0.46784567, 0.47185369, \
0.47587082, 0.47989677, 0.48393124, 0.48797395, 0.49202458, \
0.49608283, 0.50014839, 0.50422096, 0.50830023, 0.51238587, \
0.51647756, 0.52057500, 0.52467785, 0.52878579, 0.53289849, \
0.53701561, 0.54113684, 0.54526182, 0.54939022, 0.55352170, \
0.55765591, 0.56179252, 0.56593117, 0.57007151, 0.57421320, \
0.57835587, 0.58249917, 0.58664275, 0.59078623, 0.59492927, \
0.59907149, 0.60321254, 0.60735203, 0.61148961, 0.61562491, \
0.61975754, 0.62388714, 0.62801332, 0.63213572, 0.63625396, \
0.64036765, 0.64447641, 0.64857987, 0.65267763, 0.65676931, \
0.66085453, 0.66493290, 0.66900404, 0.67306754, 0.67712303, \
0.68117011, 0.68520840, 0.68923749, 0.69325701, 0.69726655, \
0.70126572, 0.70525412, 0.70923137, 0.71319707, 0.71715083, \
0.72109224, 0.72502092, 0.72893646, 0.73283848, 0.73672658, \
0.74060035, 0.74445942, 0.74830338, 0.75213184, 0.75594440, \
0.75974068, 0.76352027, 0.76728279, 0.77102784, 0.77475504, \
0.77846398, 0.78215429, 0.78582557, 0.78947744, 0.79310951, \
0.79672139, 0.80031269, 0.80388305, 0.80743206, 0.81095936, \
0.81446456, 0.81794728, 0.82140715, 0.82484379, 0.82825683, \
0.83164590, 0.83501062, 0.83835064, 0.84166557, 0.84495507, \
0.84821876, 0.85145629, 0.85466730, 0.85785143, 0.86100833, \
0.86413764, 0.86723903, 0.87031213, 0.87335662, 0.87637214, \
0.87935836, 0.88231494, 0.88524155, 0.88813786, 0.89100353, \
0.89383825, 0.89664170, 0.89941355, 0.90215349, 0.90486120, \
0.90753639, 0.91017873, 0.91278793, 0.91536369, 0.91790570, \
0.92041369, 0.92288736, 0.92532642, 0.92773060, 0.93009960, \
0.93243317, 0.93473102, 0.93699290, 0.93921853, 0.94140766, \
0.94356004, 0.94567540, 0.94775351, 0.94979413, 0.95179700, \
0.95376190, 0.95568859, 0.95757686, 0.95942647, 0.96123721, \
0.96300886, 0.96474123, 0.96643409, 0.96808726, 0.96970053, \
0.97127372, 0.97280663, 0.97429909, 0.97575093, 0.97716195, \
0.97853201, 0.97986094, 0.98114857, 0.98239475, 0.98359935, \
0.98476220, 0.98588318, 0.98696215, 0.98799897, 0.98899354, \
0.98994572, 0.99085540, 0.99172248, 0.99254685, 0.99332842, \
0.99406708, 0.99476275, 0.99541535, 0.99602479, 0.99659101, \
0.99711394, 0.99759351, 0.99802967, 0.99842236, 0.99877153, \
0.99907716, 0.99933919, 0.99955759, 0.99973235, 0.99986344, \
0.99995083, 0.99999454, } 

#define BLACKMANHARRIS2048 {\
0.00006000, 0.00006013, 0.00006053, 0.00006120, 0.00006213, \
0.00006333, 0.00006480, 0.00006654, 0.00006854, 0.00007081, \
0.00007336, 0.00007617, 0.00007925, 0.00008261, 0.00008624, \
0.00009014, 0.00009432, 0.00009877, 0.00010350, 0.00010851, \
0.00011380, 0.00011937, 0.00012522, 0.00013135, 0.00013778, \
0.00014449, 0.00015149, 0.00015878, 0.00016636, 0.00017424, \
0.00018242, 0.00019089, 0.00019967, 0.00020875, 0.00021814, \
0.00022784, 0.00023785, 0.00024817, 0.00025881, 0.00026977, \
0.00028105, 0.00029266, 0.00030459, 0.00031686, 0.00032946, \
0.00034240, 0.00035568, 0.00036930, 0.00038327, 0.00039759, \
0.00041227, 0.00042730, 0.00044270, 0.00045846, 0.00047459, \
0.00049109, 0.00050798, 0.00052524, 0.00054289, 0.00056093, \
0.00057936, 0.00059819, 0.00061743, 0.00063707, 0.00065712, \
0.00067759, 0.00069849, 0.00071980, 0.00074155, 0.00076374, \
0.00078637, 0.00080944, 0.00083296, 0.00085694, 0.00088139, \
0.00090629, 0.00093168, 0.00095754, 0.00098388, 0.00101071, \
0.00103804, 0.00106587, 0.00109421, 0.00112306, 0.00115243, \
0.00118232, 0.00121275, 0.00124371, 0.00127521, 0.00130727, \
0.00133988, 0.00137306, 0.00140681, 0.00144113, 0.00147603, \
0.00151153, 0.00154762, 0.00158432, 0.00162163, 0.00165955, \
0.00169810, 0.00173729, 0.00177711, 0.00181758, 0.00185871, \
0.00190050, 0.00194296, 0.00198609, 0.00202991, 0.00207443, \
0.00211965, 0.00216557, 0.00221221, 0.00225958, 0.00230768, \
0.00235653, 0.00240612, 0.00245648, 0.00250759, 0.00255949, \
0.00261217, 0.00266564, 0.00271992, 0.00277500, 0.00283090, \
0.00288764, 0.00294521, 0.00300362, 0.00306290, 0.00312303, \
0.00318405, 0.00324594, 0.00330873, 0.00337242, 0.00343702, \
0.00350255, 0.00356901, 0.00363641, 0.00370476, 0.00377407, \
0.00384435, 0.00391561, 0.00398787, 0.00406113, 0.00413540, \
0.00421069, 0.00428702, 0.00436438, 0.00444281, 0.00452229, \
0.00460286, 0.00468450, 0.00476725, 0.00485110, 0.00493607, \
0.00502217, 0.00510941, 0.00519781, 0.00528736, 0.00537810, \
0.00547001, 0.00556313, 0.00565745, 0.00575299, 0.00584977, \
0.00594778, 0.00604706, 0.00614760, 0.00624942, 0.00635253, \
0.00645694, 0.00656267, 0.00666972, 0.00677812, 0.00688786, \
0.00699897, 0.00711146, 0.00722533, 0.00734061, 0.00745730, \
0.00757541, 0.00769497, 0.00781597, 0.00793844, 0.00806239, \
0.00818783, 0.00831477, 0.00844322, 0.00857321, 0.00870474, \
0.00883782, 0.00897248, 0.00910871, 0.00924654, 0.00938598, \
0.00952705, 0.00966975, 0.00981410, 0.00996011, 0.01010780, \
0.01025718, 0.01040826, 0.01056107, 0.01071560, 0.01087189, \
0.01102993, 0.01118975, 0.01135136, 0.01151477, 0.01167999, \
0.01184705, 0.01201596, 0.01218672, 0.01235937, 0.01253390, \
0.01271033, 0.01288868, 0.01306897, 0.01325120, 0.01343540, \
0.01362157, 0.01380974, 0.01399991, 0.01419211, 0.01438634, \
0.01458263, 0.01478098, 0.01498142, 0.01518395, 0.01538860, \
0.01559537, 0.01580429, 0.01601537, 0.01622862, 0.01644406, \
0.01666170, 0.01688157, 0.01710367, 0.01732802, 0.01755464, \
0.01778355, 0.01801475, 0.01824827, 0.01848411, 0.01872231, \
0.01896286, 0.01920580, 0.01945112, 0.01969886, 0.01994902, \
0.02020163, 0.02045669, 0.02071422, 0.02097425, 0.02123678, \
0.02150183, 0.02176943, 0.02203957, 0.02231229, 0.02258760, \
0.02286550, 0.02314603, 0.02342920, 0.02371502, 0.02400350, \
0.02429468, 0.02458855, 0.02488515, 0.02518447, 0.02548655, \
0.02579140, 0.02609904, 0.02640947, 0.02672272, 0.02703881, \
0.02735775, 0.02767956, 0.02800425, 0.02833184, 0.02866236, \
0.02899580, 0.02933220, 0.02967157, 0.03001392, 0.03035927, \
0.03070765, 0.03105906, 0.03141352, 0.03177105, 0.03213166, \
0.03249538, 0.03286222, 0.03323220, 0.03360533, 0.03398163, \
0.03436111, 0.03474381, 0.03512972, 0.03551887, 0.03591127, \
0.03630695, 0.03670592, 0.03710819, 0.03751378, 0.03792271, \
0.03833500, 0.03875067, 0.03916972, 0.03959217, 0.04001806, \
0.04044738, 0.04088016, 0.04131641, 0.04175615, 0.04219940, \
0.04264618, 0.04309650, 0.04355037, 0.04400782, 0.04446886, \
0.04493351, 0.04540178, 0.04587369, 0.04634927, 0.04682851, \
0.04731145, 0.04779810, 0.04828847, 0.04878258, 0.04928044, \
0.04978209, 0.05028752, 0.05079676, 0.05130982, 0.05182672, \
0.05234748, 0.05287211, 0.05340063, 0.05393305, 0.05446939, \
0.05500967, 0.05555391, 0.05610211, 0.05665430, 0.05721049, \
0.05777070, 0.05833494, 0.05890323, 0.05947558, 0.06005202, \
0.06063255, 0.06121720, 0.06180597, 0.06239889, 0.06299597, \
0.06359722, 0.06420266, 0.06481231, 0.06542617, 0.06604428, \
0.06666664, 0.06729326, 0.06792417, 0.06855937, 0.06919888, \
0.06984273, 0.07049091, 0.07114345, 0.07180037, 0.07246167, \
0.07312737, 0.07379749, 0.07447203, 0.07515103, 0.07583448, \
0.07652241, 0.07721482, 0.07791173, 0.07861317, 0.07931913, \
0.08002963, 0.08074470, 0.08146434, 0.08218856, 0.08291738, \
0.08365081, 0.08438887, 0.08513157, 0.08587893, 0.08663095, \
0.08738765, 0.08814904, 0.08891514, 0.08968595, 0.09046150, \
0.09124179, 0.09202684, 0.09281666, 0.09361126, 0.09441066, \
0.09521486, 0.09602387, 0.09683772, 0.09765641, 0.09847996, \
0.09930837, 0.10014166, 0.10097984, 0.10182292, 0.10267091, \
0.10352383, 0.10438168, 0.10524448, 0.10611223, 0.10698495, \
0.10786264, 0.10874533, 0.10963301, 0.11052571, 0.11142342, \
0.11232617, 0.11323395, 0.11414678, 0.11506467, 0.11598763, \
0.11691567, 0.11784880, 0.11878702, 0.11973036, 0.12067880, \
0.12163237, 0.12259107, 0.12355492, 0.12452391, 0.12549807, \
0.12647739, 0.12746188, 0.12845156, 0.12944643, 0.13044650, \
0.13145177, 0.13246226, 0.13347796, 0.13449890, 0.13552507, \
0.13655648, 0.13759314, 0.13863505, 0.13968223, 0.14073467, \
0.14179239, 0.14285538, 0.14392367, 0.14499724, 0.14607611, \
0.14716028, 0.14824976, 0.14934456, 0.15044467, 0.15155010, \
0.15266086, 0.15377695, 0.15489838, 0.15602514, 0.15715725, \
0.15829471, 0.15943752, 0.16058568, 0.16173920, 0.16289808, \
0.16406233, 0.16523194, 0.16640692, 0.16758728, 0.16877301, \
0.16996411, 0.17116059, 0.17236246, 0.17356970, 0.17478233, \
0.17600035, 0.17722375, 0.17845253, 0.17968670, 0.18092627, \
0.18217121, 0.18342155, 0.18467728, 0.18593839, 0.18720490, \
0.18847679, 0.18975406, 0.19103673, 0.19232477, 0.19361821, \
0.19491702, 0.19622121, 0.19753078, 0.19884573, 0.20016606, \
0.20149175, 0.20282282, 0.20415925, 0.20550104, 0.20684820, \
0.20820071, 0.20955858, 0.21092179, 0.21229036, 0.21366426, \
0.21504350, 0.21642807, 0.21781797, 0.21921320, 0.22061374, \
0.22201960, 0.22343076, 0.22484722, 0.22626898, 0.22769603, \
0.22912836, 0.23056596, 0.23200884, 0.23345698, 0.23491037, \
0.23636901, 0.23783289, 0.23930201, 0.24077635, 0.24225590, \
0.24374066, 0.24523062, 0.24672578, 0.24822611, 0.24973161, \
0.25124228, 0.25275810, 0.25427906, 0.25580515, 0.25733637, \
0.25887270, 0.26041412, 0.26196064, 0.26351224, 0.26506890, \
0.26663062, 0.26819738, 0.26976918, 0.27134599, 0.27292781, \
0.27451463, 0.27610642, 0.27770318, 0.27930490, 0.28091156, \
0.28252315, 0.28413964, 0.28576104, 0.28738732, 0.28901847, \
0.29065448, 0.29229532, 0.29394099, 0.29559146, 0.29724673, \
0.29890678, 0.30057158, 0.30224113, 0.30391541, 0.30559439, \
0.30727807, 0.30896643, 0.31065944, 0.31235709, 0.31405936, \
0.31576624, 0.31747770, 0.31919373, 0.32091431, 0.32263942, \
0.32436903, 0.32610313, 0.32784171, 0.32958473, 0.33133218, \
0.33308404, 0.33484029, 0.33660090, 0.33836586, 0.34013515, \
0.34190873, 0.34368660, 0.34546873, 0.34725509, 0.34904567, \
0.35084044, 0.35263938, 0.35444246, 0.35624966, 0.35806096, \
0.35987634, 0.36169576, 0.36351921, 0.36534667, 0.36717809, \
0.36901347, 0.37085278, 0.37269599, 0.37454307, 0.37639400, \
0.37824876, 0.38010731, 0.38196964, 0.38383570, 0.38570549, \
0.38757896, 0.38945610, 0.39133687, 0.39322125, 0.39510920, \
0.39700071, 0.39889574, 0.40079427, 0.40269626, 0.40460168, \
0.40651051, 0.40842272, 0.41033828, 0.41225715, 0.41417931, \
0.41610472, 0.41803337, 0.41996520, 0.42190021, 0.42383834, \
0.42577958, 0.42772389, 0.42967123, 0.43162159, 0.43357491, \
0.43553118, 0.43749036, 0.43945241, 0.44141731, 0.44338502, \
0.44535550, 0.44732873, 0.44930466, 0.45128327, 0.45326453, \
0.45524838, 0.45723481, 0.45922378, 0.46121525, 0.46320919, \
0.46520555, 0.46720432, 0.46920544, 0.47120889, 0.47321462, \
0.47522261, 0.47723281, 0.47924519, 0.48125971, 0.48327633, \
0.48529502, 0.48731574, 0.48933846, 0.49136313, 0.49338971, \
0.49541817, 0.49744847, 0.49948057, 0.50151444, 0.50355002, \
0.50558730, 0.50762621, 0.50966673, 0.51170882, 0.51375244, \
0.51579754, 0.51784409, 0.51989204, 0.52194136, 0.52399201, \
0.52604394, 0.52809711, 0.53015149, 0.53220703, 0.53426368, \
0.53632142, 0.53838019, 0.54043996, 0.54250068, 0.54456231, \
0.54662482, 0.54868814, 0.55075225, 0.55281710, 0.55488265, \
0.55694886, 0.55901568, 0.56108306, 0.56315097, 0.56521936, \
0.56728819, 0.56935742, 0.57142699, 0.57349687, 0.57556701, \
0.57763737, 0.57970791, 0.58177857, 0.58384931, 0.58592010, \
0.58799088, 0.59006160, 0.59213223, 0.59420272, 0.59627302, \
0.59834309, 0.60041288, 0.60248234, 0.60455144, 0.60662012, \
0.60868833, 0.61075604, 0.61282319, 0.61488975, 0.61695565, \
0.61902086, 0.62108533, 0.62314901, 0.62521186, 0.62727382, \
0.62933485, 0.63139491, 0.63345395, 0.63551192, 0.63756876, \
0.63962444, 0.64167891, 0.64373212, 0.64578402, 0.64783456, \
0.64988370, 0.65193138, 0.65397757, 0.65602221, 0.65806525, \
0.66010664, 0.66214634, 0.66418430, 0.66622048, 0.66825481, \
0.67028725, 0.67231776, 0.67434629, 0.67637278, 0.67839720, \
0.68041948, 0.68243958, 0.68445745, 0.68647305, 0.68848632, \
0.69049722, 0.69250569, 0.69451169, 0.69651517, 0.69851608, \
0.70051436, 0.70250998, 0.70450288, 0.70649301, 0.70848032, \
0.71046477, 0.71244630, 0.71442487, 0.71640042, 0.71837291, \
0.72034228, 0.72230850, 0.72427150, 0.72623124, 0.72818767, \
0.73014074, 0.73209041, 0.73403661, 0.73597931, 0.73791845, \
0.73985398, 0.74178586, 0.74371404, 0.74563846, 0.74755907, \
0.74947584, 0.75138870, 0.75329761, 0.75520253, 0.75710339, \
0.75900015, 0.76089277, 0.76278119, 0.76466537, 0.76654525, \
0.76842079, 0.77029194, 0.77215865, 0.77402086, 0.77587854, \
0.77773163, 0.77958009, 0.78142386, 0.78326290, 0.78509715, \
0.78692658, 0.78875113, 0.79057076, 0.79238541, 0.79419503, \
0.79599959, 0.79779902, 0.79959329, 0.80138235, 0.80316614, \
0.80494463, 0.80671775, 0.80848547, 0.81024774, 0.81200451, \
0.81375573, 0.81550136, 0.81724134, 0.81897564, 0.82070420, \
0.82242698, 0.82414393, 0.82585500, 0.82756015, 0.82925934, \
0.83095251, 0.83263962, 0.83432062, 0.83599547, 0.83766412, \
0.83932652, 0.84098264, 0.84263242, 0.84427582, 0.84591279, \
0.84754329, 0.84916728, 0.85078471, 0.85239553, 0.85399970, \
0.85559717, 0.85718791, 0.85877186, 0.86034899, 0.86191925, \
0.86348259, 0.86503898, 0.86658836, 0.86813070, 0.86966595, \
0.87119408, 0.87271502, 0.87422876, 0.87573523, 0.87723441, \
0.87872624, 0.88021068, 0.88168770, 0.88315726, 0.88461930, \
0.88607379, 0.88752069, 0.88895996, 0.89039156, 0.89181544, \
0.89323156, 0.89463990, 0.89604039, 0.89743302, 0.89881773, \
0.90019448, 0.90156325, 0.90292398, 0.90427665, 0.90562120, \
0.90695761, 0.90828583, 0.90960583, 0.91091757, 0.91222101, \
0.91351611, 0.91480284, 0.91608116, 0.91735103, 0.91861242, \
0.91986528, 0.92110960, 0.92234532, 0.92357241, 0.92479084, \
0.92600057, 0.92720157, 0.92839381, 0.92957723, 0.93075183, \
0.93191755, 0.93307437, 0.93422225, 0.93536116, 0.93649106, \
0.93761193, 0.93872373, 0.93982642, 0.94091998, 0.94200438, \
0.94307957, 0.94414554, 0.94520225, 0.94624967, 0.94728776, \
0.94831650, 0.94933586, 0.95034581, 0.95134632, 0.95233736, \
0.95331889, 0.95429090, 0.95525335, 0.95620621, 0.95714946, \
0.95808307, 0.95900702, 0.95992126, 0.96082578, 0.96172055, \
0.96260555, 0.96348075, 0.96434611, 0.96520163, 0.96604726, \
0.96688299, 0.96770880, 0.96852465, 0.96933052, 0.97012640, \
0.97091224, 0.97168805, 0.97245378, 0.97320942, 0.97395494, \
0.97469032, 0.97541555, 0.97613060, 0.97683544, 0.97753006, \
0.97821443, 0.97888855, 0.97955237, 0.98020590, 0.98084910, \
0.98148196, 0.98210445, 0.98271657, 0.98331829, 0.98390959, \
0.98449046, 0.98506088, 0.98562083, 0.98617030, 0.98670926, \
0.98723771, 0.98775563, 0.98826299, 0.98875980, 0.98924602, \
0.98972166, 0.99018668, 0.99064108, 0.99108485, 0.99151797, \
0.99194044, 0.99235222, 0.99275332, 0.99314373, 0.99352342, \
0.99389240, 0.99425064, 0.99459814, 0.99493488, 0.99526086, \
0.99557607, 0.99588050, 0.99617414, 0.99645697, 0.99672900, \
0.99699021, 0.99724059, 0.99748014, 0.99770886, 0.99792672, \
0.99813374, 0.99832989, 0.99851518, 0.99868960, 0.99885314, \
0.99900581, 0.99914758, 0.99927847, 0.99939847, 0.99950756, \
0.99960576, 0.99969305, 0.99976944, 0.99983492, 0.99988949, \
0.99993315, 0.99996589, 0.99998772, 0.99999864, } 

#define BLACKMANHARRIS4096 {\
0.00006000, 0.00006003, 0.00006013, 0.00006030, 0.00006053, \
0.00006083, 0.00006120, 0.00006163, 0.00006213, 0.00006270, \
0.00006333, 0.00006403, 0.00006480, 0.00006563, 0.00006653, \
0.00006750, 0.00006854, 0.00006964, 0.00007081, 0.00007205, \
0.00007335, 0.00007472, 0.00007616, 0.00007767, 0.00007924, \
0.00008089, 0.00008260, 0.00008438, 0.00008623, 0.00008814, \
0.00009013, 0.00009218, 0.00009430, 0.00009649, 0.00009875, \
0.00010108, 0.00010348, 0.00010595, 0.00010848, 0.00011109, \
0.00011377, 0.00011652, 0.00011934, 0.00012223, 0.00012519, \
0.00012822, 0.00013132, 0.00013449, 0.00013774, 0.00014106, \
0.00014444, 0.00014791, 0.00015144, 0.00015505, 0.00015873, \
0.00016248, 0.00016631, 0.00017021, 0.00017418, 0.00017823, \
0.00018236, 0.00018655, 0.00019083, 0.00019518, 0.00019960, \
0.00020410, 0.00020868, 0.00021333, 0.00021806, 0.00022287, \
0.00022775, 0.00023272, 0.00023776, 0.00024288, 0.00024808, \
0.00025335, 0.00025871, 0.00026415, 0.00026966, 0.00027526, \
0.00028094, 0.00028670, 0.00029254, 0.00029846, 0.00030447, \
0.00031056, 0.00031673, 0.00032298, 0.00032932, 0.00033575, \
0.00034225, 0.00034885, 0.00035552, 0.00036229, 0.00036914, \
0.00037608, 0.00038310, 0.00039022, 0.00039742, 0.00040471, \
0.00041209, 0.00041955, 0.00042711, 0.00043476, 0.00044250, \
0.00045033, 0.00045825, 0.00046627, 0.00047437, 0.00048258, \
0.00049087, 0.00049926, 0.00050774, 0.00051632, 0.00052500, \
0.00053377, 0.00054264, 0.00055160, 0.00056067, 0.00056983, \
0.00057909, 0.00058845, 0.00059791, 0.00060747, 0.00061713, \
0.00062690, 0.00063676, 0.00064673, 0.00065681, 0.00066698, \
0.00067727, 0.00068765, 0.00069815, 0.00070875, 0.00071945, \
0.00073027, 0.00074119, 0.00075222, 0.00076336, 0.00077461, \
0.00078598, 0.00079745, 0.00080903, 0.00082073, 0.00083255, \
0.00084447, 0.00085651, 0.00086867, 0.00088094, 0.00089333, \
0.00090583, 0.00091846, 0.00093120, 0.00094406, 0.00095705, \
0.00097015, 0.00098337, 0.00099672, 0.00101019, 0.00102379, \
0.00103750, 0.00105135, 0.00106532, 0.00107941, 0.00109364, \
0.00110799, 0.00112247, 0.00113708, 0.00115182, 0.00116669, \
0.00118170, 0.00119683, 0.00121210, 0.00122751, 0.00124304, \
0.00125872, 0.00127453, 0.00129048, 0.00130657, 0.00132279, \
0.00133916, 0.00135567, 0.00137232, 0.00138911, 0.00140604, \
0.00142312, 0.00144034, 0.00145771, 0.00147523, 0.00149289, \
0.00151070, 0.00152866, 0.00154677, 0.00156503, 0.00158344, \
0.00160201, 0.00162073, 0.00163960, 0.00165863, 0.00167781, \
0.00169716, 0.00171666, 0.00173631, 0.00175613, 0.00177611, \
0.00179625, 0.00181656, 0.00183702, 0.00185766, 0.00187845, \
0.00189942, 0.00192055, 0.00194185, 0.00196332, 0.00198496, \
0.00200677, 0.00202875, 0.00205091, 0.00207324, 0.00209574, \
0.00211842, 0.00214128, 0.00216432, 0.00218753, 0.00221093, \
0.00223451, 0.00225827, 0.00228221, 0.00230634, 0.00233065, \
0.00235515, 0.00237983, 0.00240471, 0.00242977, 0.00245503, \
0.00248047, 0.00250611, 0.00253194, 0.00255797, 0.00258419, \
0.00261061, 0.00263723, 0.00266405, 0.00269107, 0.00271829, \
0.00274571, 0.00277333, 0.00280116, 0.00282920, 0.00285744, \
0.00288589, 0.00291455, 0.00294342, 0.00297251, 0.00300180, \
0.00303131, 0.00306103, 0.00309097, 0.00312113, 0.00315150, \
0.00318210, 0.00321291, 0.00324395, 0.00327521, 0.00330669, \
0.00333840, 0.00337034, 0.00340250, 0.00343490, 0.00346752, \
0.00350037, 0.00353346, 0.00356678, 0.00360034, 0.00363414, \
0.00366817, 0.00370244, 0.00373695, 0.00377170, 0.00380669, \
0.00384193, 0.00387741, 0.00391314, 0.00394912, 0.00398535, \
0.00402183, 0.00405855, 0.00409553, 0.00413277, 0.00417026, \
0.00420801, 0.00424601, 0.00428428, 0.00432280, 0.00436159, \
0.00440064, 0.00443995, 0.00447953, 0.00451938, 0.00455950, \
0.00459989, 0.00464054, 0.00468147, 0.00472268, 0.00476416, \
0.00480591, 0.00484795, 0.00489026, 0.00493286, 0.00497573, \
0.00501889, 0.00506234, 0.00510607, 0.00515009, 0.00519440, \
0.00523900, 0.00528389, 0.00532907, 0.00537455, 0.00542033, \
0.00546640, 0.00551277, 0.00555944, 0.00560642, 0.00565369, \
0.00570128, 0.00574917, 0.00579736, 0.00584587, 0.00589468, \
0.00594381, 0.00599325, 0.00604301, 0.00609308, 0.00614347, \
0.00619418, 0.00624522, 0.00629657, 0.00634825, 0.00640025, \
0.00645258, 0.00650524, 0.00655823, 0.00661155, 0.00666520, \
0.00671919, 0.00677351, 0.00682817, 0.00688317, 0.00693851, \
0.00699420, 0.00705022, 0.00710660, 0.00716332, 0.00722038, \
0.00727780, 0.00733557, 0.00739369, 0.00745217, 0.00751100, \
0.00757019, 0.00762974, 0.00768965, 0.00774993, 0.00781056, \
0.00787157, 0.00793294, 0.00799468, 0.00805679, 0.00811927, \
0.00818213, 0.00824536, 0.00830897, 0.00837296, 0.00843733, \
0.00850208, 0.00856721, 0.00863273, 0.00869863, 0.00876493, \
0.00883161, 0.00889869, 0.00896616, 0.00903403, 0.00910229, \
0.00917095, 0.00924001, 0.00930948, 0.00937934, 0.00944961, \
0.00952029, 0.00959138, 0.00966288, 0.00973479, 0.00980711, \
0.00987985, 0.00995301, 0.01002659, 0.01010058, 0.01017500, \
0.01024984, 0.01032511, 0.01040081, 0.01047693, 0.01055349, \
0.01063048, 0.01070790, 0.01078576, 0.01086406, 0.01094280, \
0.01102198, 0.01110160, 0.01118167, 0.01126218, 0.01134314, \
0.01142456, 0.01150642, 0.01158874, 0.01167152, 0.01175475, \
0.01183844, 0.01192259, 0.01200721, 0.01209229, 0.01217784, \
0.01226385, 0.01235034, 0.01243730, 0.01252473, 0.01261263, \
0.01270102, 0.01278988, 0.01287923, 0.01296905, 0.01305937, \
0.01315017, 0.01324145, 0.01333323, 0.01342550, 0.01351826, \
0.01361152, 0.01370528, 0.01379953, 0.01389429, 0.01398955, \
0.01408532, 0.01418159, 0.01427837, 0.01437567, 0.01447347, \
0.01457179, 0.01467063, 0.01476998, 0.01486986, 0.01497025, \
0.01507117, 0.01517262, 0.01527459, 0.01537710, 0.01548013, \
0.01558370, 0.01568781, 0.01579245, 0.01589763, 0.01600335, \
0.01610961, 0.01621642, 0.01632378, 0.01643169, 0.01654014, \
0.01664915, 0.01675872, 0.01686884, 0.01697951, 0.01709075, \
0.01720256, 0.01731492, 0.01742785, 0.01754135, 0.01765543, \
0.01777007, 0.01788529, 0.01800108, 0.01811745, 0.01823440, \
0.01835194, 0.01847005, 0.01858876, 0.01870805, 0.01882793, \
0.01894840, 0.01906947, 0.01919114, 0.01931340, 0.01943626, \
0.01955972, 0.01968379, 0.01980846, 0.01993374, 0.02005963, \
0.02018613, 0.02031325, 0.02044098, 0.02056933, 0.02069830, \
0.02082789, 0.02095811, 0.02108895, 0.02122042, 0.02135252, \
0.02148525, 0.02161862, 0.02175262, 0.02188726, 0.02202254, \
0.02215847, 0.02229503, 0.02243224, 0.02257011, 0.02270862, \
0.02284778, 0.02298760, 0.02312808, 0.02326921, 0.02341100, \
0.02355346, 0.02369658, 0.02384037, 0.02398482, 0.02412995, \
0.02427575, 0.02442223, 0.02456938, 0.02471721, 0.02486572, \
0.02501492, 0.02516480, 0.02531537, 0.02546663, 0.02561858, \
0.02577122, 0.02592456, 0.02607859, 0.02623333, 0.02638876, \
0.02654491, 0.02670175, 0.02685931, 0.02701757, 0.02717655, \
0.02733624, 0.02749665, 0.02765778, 0.02781963, 0.02798220, \
0.02814549, 0.02830951, 0.02847426, 0.02863974, 0.02880596, \
0.02897291, 0.02914060, 0.02930902, 0.02947819, 0.02964810, \
0.02981876, 0.02999016, 0.03016232, 0.03033523, 0.03050889, \
0.03068330, 0.03085848, 0.03103441, 0.03121111, 0.03138857, \
0.03156680, 0.03174580, 0.03192557, 0.03210611, 0.03228743, \
0.03246952, 0.03265240, 0.03283605, 0.03302049, 0.03320571, \
0.03339172, 0.03357852, 0.03376612, 0.03395451, 0.03414369, \
0.03433367, 0.03452445, 0.03471604, 0.03490843, 0.03510162, \
0.03529563, 0.03549044, 0.03568607, 0.03588251, 0.03607977, \
0.03627785, 0.03647675, 0.03667648, 0.03687703, 0.03707841, \
0.03728062, 0.03748366, 0.03768753, 0.03789224, 0.03809779, \
0.03830418, 0.03851141, 0.03871949, 0.03892841, 0.03913818, \
0.03934881, 0.03956028, 0.03977261, 0.03998580, 0.04019985, \
0.04041476, 0.04063053, 0.04084717, 0.04106467, 0.04128305, \
0.04150230, 0.04172242, 0.04194342, 0.04216529, 0.04238805, \
0.04261169, 0.04283621, 0.04306162, 0.04328792, 0.04351511, \
0.04374319, 0.04397217, 0.04420204, 0.04443282, 0.04466449, \
0.04489707, 0.04513055, 0.04536494, 0.04560024, 0.04583645, \
0.04607358, 0.04631162, 0.04655058, 0.04679046, 0.04703126, \
0.04727299, 0.04751564, 0.04775922, 0.04800373, 0.04824917, \
0.04849555, 0.04874286, 0.04899111, 0.04924031, 0.04949044, \
0.04974152, 0.04999355, 0.05024652, 0.05050045, 0.05075533, \
0.05101116, 0.05126796, 0.05152571, 0.05178442, 0.05204409, \
0.05230473, 0.05256634, 0.05282892, 0.05309246, 0.05335699, \
0.05362248, 0.05388896, 0.05415641, 0.05442484, 0.05469426, \
0.05496467, 0.05523606, 0.05550844, 0.05578181, 0.05605618, \
0.05633154, 0.05660790, 0.05688525, 0.05716361, 0.05744298, \
0.05772335, 0.05800472, 0.05828711, 0.05857051, 0.05885492, \
0.05914034, 0.05942679, 0.05971425, 0.06000273, 0.06029224, \
0.06058278, 0.06087434, 0.06116693, 0.06146055, 0.06175520, \
0.06205089, 0.06234761, 0.06264538, 0.06294419, 0.06324403, \
0.06354493, 0.06384687, 0.06414986, 0.06445390, 0.06475899, \
0.06506514, 0.06537234, 0.06568060, 0.06598992, 0.06630031, \
0.06661175, 0.06692427, 0.06723785, 0.06755250, 0.06786822, \
0.06818502, 0.06850289, 0.06882184, 0.06914186, 0.06946297, \
0.06978516, 0.07010844, 0.07043280, 0.07075825, 0.07108479, \
0.07141243, 0.07174115, 0.07207098, 0.07240190, 0.07273392, \
0.07306704, 0.07340126, 0.07373659, 0.07407303, 0.07441057, \
0.07474923, 0.07508900, 0.07542988, 0.07577187, 0.07611499, \
0.07645922, 0.07680458, 0.07715105, 0.07749866, 0.07784739, \
0.07819724, 0.07854823, 0.07890035, 0.07925360, 0.07960799, \
0.07996351, 0.08032017, 0.08067798, 0.08103692, 0.08139701, \
0.08175825, 0.08212063, 0.08248416, 0.08284884, 0.08321467, \
0.08358166, 0.08394980, 0.08431911, 0.08468957, 0.08506119, \
0.08543397, 0.08580792, 0.08618303, 0.08655931, 0.08693676, \
0.08731538, 0.08769517, 0.08807614, 0.08845828, 0.08884160, \
0.08922610, 0.08961177, 0.08999863, 0.09038668, 0.09077591, \
0.09116632, 0.09155793, 0.09195072, 0.09234470, 0.09273988, \
0.09313625, 0.09353382, 0.09393259, 0.09433255, 0.09473372, \
0.09513609, 0.09553966, 0.09594444, 0.09635042, 0.09675761, \
0.09716602, 0.09757563, 0.09798646, 0.09839850, 0.09881175, \
0.09922623, 0.09964192, 0.10005883, 0.10047696, 0.10089632, \
0.10131690, 0.10173870, 0.10216174, 0.10258600, 0.10301149, \
0.10343821, 0.10386617, 0.10429536, 0.10472578, 0.10515745, \
0.10559035, 0.10602449, 0.10645987, 0.10689649, 0.10733436, \
0.10777347, 0.10821383, 0.10865543, 0.10909829, 0.10954239, \
0.10998775, 0.11043436, 0.11088222, 0.11133134, 0.11178171, \
0.11223334, 0.11268624, 0.11314039, 0.11359580, 0.11405248, \
0.11451042, 0.11496962, 0.11543009, 0.11589183, 0.11635484, \
0.11681912, 0.11728467, 0.11775149, 0.11821959, 0.11868895, \
0.11915960, 0.11963152, 0.12010472, 0.12057920, 0.12105496, \
0.12153200, 0.12201032, 0.12248993, 0.12297082, 0.12345300, \
0.12393646, 0.12442121, 0.12490725, 0.12539458, 0.12588320, \
0.12637311, 0.12686432, 0.12735682, 0.12785061, 0.12834570, \
0.12884209, 0.12933977, 0.12983875, 0.13033904, 0.13084062, \
0.13134350, 0.13184769, 0.13235318, 0.13285998, 0.13336808, \
0.13387749, 0.13438820, 0.13490022, 0.13541355, 0.13592819, \
0.13644414, 0.13696140, 0.13747998, 0.13799986, 0.13852106, \
0.13904358, 0.13956741, 0.14009255, 0.14061902, 0.14114680, \
0.14167590, 0.14220631, 0.14273805, 0.14327111, 0.14380549, \
0.14434119, 0.14487822, 0.14541657, 0.14595624, 0.14649724, \
0.14703956, 0.14758321, 0.14812818, 0.14867448, 0.14922211, \
0.14977107, 0.15032136, 0.15087298, 0.15142593, 0.15198021, \
0.15253582, 0.15309276, 0.15365104, 0.15421065, 0.15477159, \
0.15533387, 0.15589748, 0.15646242, 0.15702870, 0.15759632, \
0.15816528, 0.15873557, 0.15930720, 0.15988017, 0.16045447, \
0.16103011, 0.16160710, 0.16218542, 0.16276508, 0.16334609, \
0.16392843, 0.16451211, 0.16509714, 0.16568351, 0.16627122, \
0.16686027, 0.16745066, 0.16804240, 0.16863548, 0.16922991, \
0.16982567, 0.17042278, 0.17102124, 0.17162104, 0.17222218, \
0.17282467, 0.17342851, 0.17403369, 0.17464021, 0.17524808, \
0.17585730, 0.17646786, 0.17707977, 0.17769302, 0.17830762, \
0.17892356, 0.17954085, 0.18015949, 0.18077948, 0.18140081, \
0.18202349, 0.18264751, 0.18327288, 0.18389960, 0.18452766, \
0.18515707, 0.18578782, 0.18641993, 0.18705337, 0.18768817, \
0.18832431, 0.18896180, 0.18960063, 0.19024081, 0.19088233, \
0.19152520, 0.19216942, 0.19281498, 0.19346189, 0.19411014, \
0.19475973, 0.19541067, 0.19606296, 0.19671659, 0.19737156, \
0.19802787, 0.19868553, 0.19934454, 0.20000488, 0.20066657, \
0.20132960, 0.20199397, 0.20265968, 0.20332673, 0.20399513, \
0.20466486, 0.20533594, 0.20600835, 0.20668211, 0.20735720, \
0.20803363, 0.20871140, 0.20939050, 0.21007095, 0.21075272, \
0.21143584, 0.21212029, 0.21280608, 0.21349320, 0.21418165, \
0.21487144, 0.21556255, 0.21625501, 0.21694879, 0.21764390, \
0.21834035, 0.21903812, 0.21973722, 0.22043766, 0.22113941, \
0.22184250, 0.22254691, 0.22325265, 0.22395971, 0.22466810, \
0.22537781, 0.22608884, 0.22680120, 0.22751487, 0.22822987, \
0.22894618, 0.22966382, 0.23038277, 0.23110304, 0.23182462, \
0.23254752, 0.23327173, 0.23399726, 0.23472410, 0.23545225, \
0.23618171, 0.23691249, 0.23764457, 0.23837796, 0.23911265, \
0.23984865, 0.24058596, 0.24132456, 0.24206448, 0.24280569, \
0.24354820, 0.24429202, 0.24503713, 0.24578354, 0.24653124, \
0.24728024, 0.24803053, 0.24878212, 0.24953500, 0.25028916, \
0.25104462, 0.25180137, 0.25255940, 0.25331871, 0.25407931, \
0.25484120, 0.25560436, 0.25636881, 0.25713453, 0.25790153, \
0.25866981, 0.25943936, 0.26021019, 0.26098229, 0.26175566, \
0.26253030, 0.26330620, 0.26408338, 0.26486182, 0.26564152, \
0.26642248, 0.26720471, 0.26798819, 0.26877293, 0.26955893, \
0.27034618, 0.27113469, 0.27192445, 0.27271545, 0.27350771, \
0.27430121, 0.27509596, 0.27589195, 0.27668918, 0.27748765, \
0.27828737, 0.27908831, 0.27989050, 0.28069391, 0.28149856, \
0.28230444, 0.28311154, 0.28391988, 0.28472943, 0.28554021, \
0.28635221, 0.28716543, 0.28797987, 0.28879552, 0.28961239, \
0.29043046, 0.29124975, 0.29207024, 0.29289195, 0.29371485, \
0.29453896, 0.29536426, 0.29619077, 0.29701847, 0.29784736, \
0.29867745, 0.29950873, 0.30034119, 0.30117485, 0.30200968, \
0.30284570, 0.30368289, 0.30452127, 0.30536082, 0.30620154, \
0.30704343, 0.30788650, 0.30873072, 0.30957612, 0.31042267, \
0.31127039, 0.31211926, 0.31296929, 0.31382048, 0.31467281, \
0.31552629, 0.31638092, 0.31723669, 0.31809361, 0.31895166, \
0.31981085, 0.32067118, 0.32153264, 0.32239523, 0.32325894, \
0.32412378, 0.32498974, 0.32585682, 0.32672502, 0.32759434, \
0.32846477, 0.32933631, 0.33020895, 0.33108270, 0.33195755, \
0.33283350, 0.33371055, 0.33458870, 0.33546793, 0.33634826, \
0.33722967, 0.33811217, 0.33899574, 0.33988040, 0.34076613, \
0.34165293, 0.34254081, 0.34342975, 0.34431976, 0.34521083, \
0.34610296, 0.34699615, 0.34789039, 0.34878568, 0.34968202, \
0.35057940, 0.35147783, 0.35237729, 0.35327780, 0.35417933, \
0.35508190, 0.35598550, 0.35689012, 0.35779576, 0.35870242, \
0.35961009, 0.36051878, 0.36142848, 0.36233919, 0.36325090, \
0.36416361, 0.36507732, 0.36599202, 0.36690772, 0.36782440, \
0.36874207, 0.36966072, 0.37058034, 0.37150095, 0.37242253, \
0.37334507, 0.37426858, 0.37519306, 0.37611849, 0.37704489, \
0.37797223, 0.37890052, 0.37982976, 0.38075995, 0.38169107, \
0.38262313, 0.38355613, 0.38449005, 0.38542490, 0.38636067, \
0.38729736, 0.38823497, 0.38917349, 0.39011292, 0.39105326, \
0.39199450, 0.39293663, 0.39387967, 0.39482359, 0.39576841, \
0.39671410, 0.39766068, 0.39860814, 0.39955647, 0.40050567, \
0.40145574, 0.40240667, 0.40335846, 0.40431111, 0.40526461, \
0.40621896, 0.40717415, 0.40813018, 0.40908706, 0.41004476, \
0.41100330, 0.41196266, 0.41292284, 0.41388385, 0.41484567, \
0.41580830, 0.41677173, 0.41773597, 0.41870101, 0.41966685, \
0.42063348, 0.42160089, 0.42256909, 0.42353807, 0.42450783, \
0.42547836, 0.42644965, 0.42742171, 0.42839454, 0.42936812, \
0.43034245, 0.43131753, 0.43229335, 0.43326991, 0.43424721, \
0.43522525, 0.43620401, 0.43718349, 0.43816370, 0.43914462, \
0.44012625, 0.44110859, 0.44209164, 0.44307538, 0.44405982, \
0.44504495, 0.44603077, 0.44701726, 0.44800444, 0.44899229, \
0.44998081, 0.45097000, 0.45195985, 0.45295035, 0.45394151, \
0.45493331, 0.45592576, 0.45691885, 0.45791258, 0.45890693, \
0.45990191, 0.46089752, 0.46189374, 0.46289058, 0.46388802, \
0.46488607, 0.46588472, 0.46688396, 0.46788380, 0.46888422, \
0.46988523, 0.47088681, 0.47188896, 0.47289169, 0.47389498, \
0.47489882, 0.47590323, 0.47690818, 0.47791368, 0.47891972, \
0.47992629, 0.48093340, 0.48194104, 0.48294920, 0.48395787, \
0.48496706, 0.48597676, 0.48698696, 0.48799766, 0.48900886, \
0.49002055, 0.49103272, 0.49204537, 0.49305850, 0.49407209, \
0.49508616, 0.49610068, 0.49711566, 0.49813110, 0.49914698, \
0.50016330, 0.50118006, 0.50219725, 0.50321487, 0.50423291, \
0.50525137, 0.50627024, 0.50728952, 0.50830920, 0.50932928, \
0.51034975, 0.51137061, 0.51239186, 0.51341348, 0.51443547, \
0.51545784, 0.51648056, 0.51750365, 0.51852709, 0.51955087, \
0.52057500, 0.52159947, 0.52262427, 0.52364939, 0.52467484, \
0.52570061, 0.52672669, 0.52775308, 0.52877977, 0.52980675, \
0.53083403, 0.53186160, 0.53288944, 0.53391757, 0.53494596, \
0.53597462, 0.53700354, 0.53803272, 0.53906215, 0.54009182, \
0.54112173, 0.54215188, 0.54318226, 0.54421286, 0.54524368, \
0.54627471, 0.54730595, 0.54833740, 0.54936904, 0.55040087, \
0.55143289, 0.55246510, 0.55349748, 0.55453003, 0.55556274, \
0.55659562, 0.55762865, 0.55866183, 0.55969515, 0.56072861, \
0.56176221, 0.56279593, 0.56382978, 0.56486374, 0.56589781, \
0.56693199, 0.56796627, 0.56900065, 0.57003511, 0.57106966, \
0.57210428, 0.57313898, 0.57417375, 0.57520858, 0.57624346, \
0.57727840, 0.57831338, 0.57934840, 0.58038345, 0.58141853, \
0.58245364, 0.58348876, 0.58452390, 0.58555904, 0.58659418, \
0.58762931, 0.58866444, 0.58969955, 0.59073463, 0.59176969, \
0.59280472, 0.59383970, 0.59487464, 0.59590953, 0.59694437, \
0.59797914, 0.59901384, 0.60004848, 0.60108303, 0.60211750, \
0.60315187, 0.60418615, 0.60522033, 0.60625440, 0.60728836, \
0.60832220, 0.60935591, 0.61038950, 0.61142294, 0.61245625, \
0.61348940, 0.61452241, 0.61555525, 0.61658792, 0.61762043, \
0.61865276, 0.61968490, 0.62071686, 0.62174862, 0.62278018, \
0.62381153, 0.62484267, 0.62587360, 0.62690429, 0.62793476, \
0.62896500, 0.62999499, 0.63102473, 0.63205422, 0.63308345, \
0.63411242, 0.63514111, 0.63616953, 0.63719766, 0.63822550, \
0.63925305, 0.64028030, 0.64130724, 0.64233387, 0.64336018, \
0.64438617, 0.64541182, 0.64643714, 0.64746211, 0.64848674, \
0.64951101, 0.65053492, 0.65155846, 0.65258163, 0.65360442, \
0.65462683, 0.65564885, 0.65667047, 0.65769168, 0.65871249, \
0.65973288, 0.66075286, 0.66177240, 0.66279152, 0.66381019, \
0.66482842, 0.66584620, 0.66686352, 0.66788037, 0.66889676, \
0.66991267, 0.67092810, 0.67194305, 0.67295750, 0.67397145, \
0.67498489, 0.67599783, 0.67701024, 0.67802213, 0.67903350, \
0.68004432, 0.68105460, 0.68206434, 0.68307352, 0.68408214, \
0.68509019, 0.68609767, 0.68710457, 0.68811089, 0.68911661, \
0.69012174, 0.69112626, 0.69213018, 0.69313348, 0.69413615, \
0.69513820, 0.69613962, 0.69714039, 0.69814052, 0.69914000, \
0.70013882, 0.70113697, 0.70213445, 0.70313126, 0.70412738, \
0.70512281, 0.70611755, 0.70711159, 0.70810491, 0.70909753, \
0.71008942, 0.71108059, 0.71207103, 0.71306072, 0.71404968, \
0.71503788, 0.71602532, 0.71701200, 0.71799791, 0.71898305, \
0.71996741, 0.72095097, 0.72193375, 0.72291572, 0.72389688, \
0.72487724, 0.72585677, 0.72683548, 0.72781336, 0.72879041, \
0.72976661, 0.73074196, 0.73171645, 0.73269008, 0.73366285, \
0.73463474, 0.73560575, 0.73657587, 0.73754511, 0.73851344, \
0.73948087, 0.74044738, 0.74141298, 0.74237766, 0.74334141, \
0.74430422, 0.74526609, 0.74622701, 0.74718697, 0.74814598, \
0.74910402, 0.75006109, 0.75101718, 0.75197228, 0.75292640, \
0.75387951, 0.75483163, 0.75578273, 0.75673282, 0.75768189, \
0.75862993, 0.75957693, 0.76052290, 0.76146782, 0.76241168, \
0.76335449, 0.76429623, 0.76523691, 0.76617650, 0.76711502, \
0.76805244, 0.76898877, 0.76992400, 0.77085812, 0.77179113, \
0.77272302, 0.77365378, 0.77458341, 0.77551190, 0.77643925, \
0.77736545, 0.77829050, 0.77921438, 0.78013709, 0.78105863, \
0.78197899, 0.78289816, 0.78381614, 0.78473293, 0.78564850, \
0.78656287, 0.78747602, 0.78838795, 0.78929865, 0.79020812, \
0.79111634, 0.79202332, 0.79292904, 0.79383351, 0.79473671, \
0.79563864, 0.79653930, 0.79743867, 0.79833675, 0.79923354, \
0.80012903, 0.80102321, 0.80191608, 0.80280763, 0.80369786, \
0.80458675, 0.80547431, 0.80636053, 0.80724540, 0.80812891, \
0.80901107, 0.80989186, 0.81077127, 0.81164931, 0.81252597, \
0.81340123, 0.81427510, 0.81514757, 0.81601863, 0.81688828, \
0.81775651, 0.81862331, 0.81948869, 0.82035262, 0.82121512, \
0.82207616, 0.82293575, 0.82379389, 0.82465055, 0.82550575, \
0.82635946, 0.82721170, 0.82806244, 0.82891169, 0.82975944, \
0.83060568, 0.83145041, 0.83229363, 0.83313532, 0.83397548, \
0.83481410, 0.83565119, 0.83648672, 0.83732071, 0.83815314, \
0.83898400, 0.83981329, 0.84064101, 0.84146715, 0.84229170, \
0.84311466, 0.84393602, 0.84475578, 0.84557393, 0.84639047, \
0.84720538, 0.84801867, 0.84883033, 0.84964035, 0.85044873, \
0.85125546, 0.85206053, 0.85286395, 0.85366570, 0.85446578, \
0.85526419, 0.85606091, 0.85685595, 0.85764929, 0.85844094, \
0.85923088, 0.86001911, 0.86080563, 0.86159043, 0.86237351, \
0.86315485, 0.86393445, 0.86471232, 0.86548844, 0.86626280, \
0.86703541, 0.86780625, 0.86857532, 0.86934263, 0.87010815, \
0.87087188, 0.87163383, 0.87239398, 0.87315233, 0.87390887, \
0.87466360, 0.87541652, 0.87616761, 0.87691688, 0.87766431, \
0.87840991, 0.87915366, 0.87989556, 0.88063562, 0.88137381, \
0.88211014, 0.88284460, 0.88357718, 0.88430789, 0.88503671, \
0.88576364, 0.88648868, 0.88721181, 0.88793304, 0.88865237, \
0.88936977, 0.89008526, 0.89079882, 0.89151045, 0.89222014, \
0.89292790, 0.89363371, 0.89433757, 0.89503947, 0.89573941, \
0.89643739, 0.89713340, 0.89782743, 0.89851948, 0.89920954, \
0.89989762, 0.90058370, 0.90126778, 0.90194986, 0.90262992, \
0.90330798, 0.90398401, 0.90465802, 0.90533000, 0.90599994, \
0.90666785, 0.90733372, 0.90799753, 0.90865929, 0.90931900, \
0.90997664, 0.91063222, 0.91128573, 0.91193715, 0.91258650, \
0.91323376, 0.91387894, 0.91452201, 0.91516299, 0.91580186, \
0.91643863, 0.91707328, 0.91770581, 0.91833622, 0.91896451, \
0.91959066, 0.92021468, 0.92083655, 0.92145629, 0.92207387, \
0.92268929, 0.92330256, 0.92391367, 0.92452261, 0.92512938, \
0.92573397, 0.92633638, 0.92693661, 0.92753465, 0.92813050, \
0.92872414, 0.92931559, 0.92990483, 0.93049186, 0.93107667, \
0.93165927, 0.93223964, 0.93281779, 0.93339370, 0.93396738, \
0.93453882, 0.93510801, 0.93567496, 0.93623965, 0.93680209, \
0.93736226, 0.93792018, 0.93847582, 0.93902919, 0.93958029, \
0.94012910, 0.94067563, 0.94121987, 0.94176182, 0.94230147, \
0.94283882, 0.94337386, 0.94390660, 0.94443703, 0.94496514, \
0.94549093, 0.94601439, 0.94653553, 0.94705434, 0.94757081, \
0.94808495, 0.94859674, 0.94910618, 0.94961327, 0.95011801, \
0.95062040, 0.95112042, 0.95161807, 0.95211336, 0.95260627, \
0.95309681, 0.95358497, 0.95407075, 0.95455414, 0.95503514, \
0.95551375, 0.95598996, 0.95646377, 0.95693517, 0.95740417, \
0.95787076, 0.95833493, 0.95879668, 0.95925602, 0.95971292, \
0.96016740, 0.96061945, 0.96106907, 0.96151624, 0.96196098, \
0.96240327, 0.96284311, 0.96328050, 0.96371544, 0.96414792, \
0.96457794, 0.96500549, 0.96543058, 0.96585320, 0.96627334, \
0.96669101, 0.96710620, 0.96751891, 0.96792913, 0.96833686, \
0.96874210, 0.96914485, 0.96954510, 0.96994285, 0.97033809, \
0.97073083, 0.97112106, 0.97150878, 0.97189398, 0.97227666, \
0.97265682, 0.97303446, 0.97340958, 0.97378216, 0.97415221, \
0.97451973, 0.97488471, 0.97524715, 0.97560705, 0.97596440, \
0.97631921, 0.97667146, 0.97702116, 0.97736830, 0.97771289, \
0.97805492, 0.97839438, 0.97873127, 0.97906560, 0.97939735, \
0.97972653, 0.98005314, 0.98037717, 0.98069861, 0.98101748, \
0.98133375, 0.98164744, 0.98195854, 0.98226705, 0.98257296, \
0.98287628, 0.98317699, 0.98347511, 0.98377062, 0.98406352, \
0.98435381, 0.98464150, 0.98492657, 0.98520903, 0.98548887, \
0.98576609, 0.98604069, 0.98631267, 0.98658202, 0.98684875, \
0.98711285, 0.98737431, 0.98763315, 0.98788934, 0.98814290, \
0.98839383, 0.98864211, 0.98888775, 0.98913074, 0.98937109, \
0.98960879, 0.98984385, 0.99007625, 0.99030599, 0.99053308, \
0.99075752, 0.99097930, 0.99119842, 0.99141487, 0.99162866, \
0.99183979, 0.99204825, 0.99225405, 0.99245717, 0.99265763, \
0.99285541, 0.99305051, 0.99324295, 0.99343270, 0.99361978, \
0.99380418, 0.99398589, 0.99416493, 0.99434128, 0.99451494, \
0.99468592, 0.99485421, 0.99501981, 0.99518273, 0.99534295, \
0.99550047, 0.99565531, 0.99580745, 0.99595689, 0.99610364, \
0.99624769, 0.99638904, 0.99652769, 0.99666363, 0.99679688, \
0.99692742, 0.99705526, 0.99718039, 0.99730281, 0.99742253, \
0.99753954, 0.99765384, 0.99776543, 0.99787431, 0.99798048, \
0.99808394, 0.99818468, 0.99828271, 0.99837803, 0.99847063, \
0.99856051, 0.99864768, 0.99873213, 0.99881386, 0.99889287, \
0.99896917, 0.99904274, 0.99911359, 0.99918173, 0.99924714, \
0.99930983, 0.99936980, 0.99942704, 0.99948156, 0.99953336, \
0.99958244, 0.99962879, 0.99967241, 0.99971331, 0.99975149, \
0.99978694, 0.99981966, 0.99984966, 0.99987693, 0.99990147, \
0.99992329, 0.99994238, 0.99995875, 0.99997238, 0.99998329, \
0.99999148, 0.99999693, 0.99999966, } 


 #endif // _FPU_FFT_BLACKMANHARRIS_H_
//=============================================================================
// End of File
//=============================================================================
