//=============================================================================
// Flattop Window 
//=============================================================================
#ifndef _FPU_FFT_FLATTOP_H_
#define _FPU_FFT_FLATTOP_H_

#define FLATTOP32 {\
-0.00042105, -0.00154305, -0.00564204, -0.01440417, -0.02900509, \
-0.04801163, -0.06536607, -0.06954848, -0.04501064, 0.02367638, \
0.14573717, 0.31822499, 0.52284788, 0.72769522, 0.89424299, \
0.98779079, } 

#define FLATTOP64 {\
-0.00042105, -0.00068051, -0.00150572, -0.00302975, -0.00544982, \
-0.00899103, -0.01385733, -0.02017203, -0.02791195, -0.03684078, \
-0.04644925, -0.05591064, -0.06406073, -0.06941070, -0.07019904, \
-0.06448554, -0.05028565, -0.02573845, 0.01070372, 0.06008053, \
0.12274341, 0.19821053, 0.28507664, 0.38099353, 0.48273102, \
0.58632067, 0.68727594, 0.78087391, 0.86247634, 0.92786261, \
0.97354445, 0.99703306, } 

#define FLATTOP128 {\
-0.00042105, -0.00048416, -0.00067638, -0.00100627, -0.00148775, \
-0.00213952, -0.00298428, -0.00404780, -0.00535768, -0.00694199, \
-0.00882771, -0.01103900, -0.01359534, -0.01650955, -0.01978582, \
-0.02341759, -0.02738557, -0.03165582, -0.03617795, -0.04088360, \
-0.04568513, -0.05047476, -0.05512402, -0.05948382, -0.06338494, \
-0.06663918, -0.06904108, -0.07037036, -0.07039486, -0.06887425, \
-0.06556424, -0.06022134, -0.05260807, -0.04249854, -0.02968430, \
-0.01398025, 0.00476941, 0.02668542, 0.05184806, 0.08029218, \
0.11200289, 0.14691208, 0.18489576, 0.22577256, 0.26930324, \
0.31519150, 0.36308599, 0.41258359, 0.46323393, 0.51454510, \
0.56599049, 0.61701657, 0.66705155, 0.71551475, 0.76182634, \
0.80541750, 0.84574052, 0.88227879, 0.91455633, 0.94214677, \
0.96468143, 0.98185638, 0.99343836, 0.99926926, } 

#define FLATTOP256 {\
-0.00042105, -0.00043666, -0.00048366, -0.00056260, -0.00067435, \
-0.00082014, -0.00100154, -0.00122042, -0.00147894, -0.00177956, \
-0.00212496, -0.00251807, -0.00296199, -0.00345999, -0.00401544, \
-0.00463180, -0.00531256, -0.00606119, -0.00688109, -0.00777558, \
-0.00874777, -0.00980058, -0.01093661, -0.01215815, -0.01346708, \
-0.01486481, -0.01635222, -0.01792961, -0.01959661, -0.02135216, \
-0.02319439, -0.02512063, -0.02712728, -0.02920980, -0.03136265, \
-0.03357922, -0.03585182, -0.03817158, -0.04052848, -0.04291126, \
-0.04530745, -0.04770328, -0.05008374, -0.05243252, -0.05473205, \
-0.05696349, -0.05910674, -0.06114051, -0.06304229, -0.06478848, \
-0.06635437, -0.06771425, -0.06884148, -0.06970856, -0.07028724, \
-0.07054863, -0.07046329, -0.07000138, -0.06913278, -0.06782723, \
-0.06605450, -0.06378448, -0.06098744, -0.05763412, -0.05369593, \
-0.04914512, -0.04395498, -0.03810000, -0.03155606, -0.02430062, \
-0.01631287, -0.00757398, 0.00193282, 0.01222198, 0.02330551, \
0.03519283, 0.04789057, 0.06140250, 0.07572934, 0.09086865, \
0.10681477, 0.12355866, 0.14108788, 0.15938650, 0.17843506, \
0.19821053, 0.21868633, 0.23983231, 0.26161478, 0.28399657, \
0.30693709, 0.33039239, 0.35431531, 0.37865557, 0.40335989, \
0.42837222, 0.45363385, 0.47908364, 0.50465822, 0.53029222, \
0.55591850, 0.58146843, 0.60687215, 0.63205883, 0.65695696, \
0.68149467, 0.70560001, 0.72920128, 0.75222730, 0.77460778, \
0.79627355, 0.81715697, 0.83719216, 0.85631532, 0.87446504, \
0.89158257, 0.90761211, 0.92250104, 0.93620020, 0.94866411, \
0.95985120, 0.96972398, 0.97824925, 0.98539824, 0.99114677, \
0.99547535, 0.99836928, 0.99981871, } 

#define FLATTOP512 {\
-0.00042105, -0.00042494, -0.00043660, -0.00045607, -0.00048342, \
-0.00051871, -0.00056204, -0.00061354, -0.00067334, -0.00074162, \
-0.00081855, -0.00090433, -0.00099920, -0.00110339, -0.00121716, \
-0.00134079, -0.00147458, -0.00161883, -0.00177388, -0.00194007, \
-0.00211775, -0.00230730, -0.00250909, -0.00272351, -0.00295096, \
-0.00319186, -0.00344663, -0.00371567, -0.00399943, -0.00429833, \
-0.00461281, -0.00494330, -0.00529023, -0.00565404, -0.00603515, \
-0.00643399, -0.00685096, -0.00728649, -0.00774095, -0.00821474, \
-0.00870823, -0.00922176, -0.00975569, -0.01031032, -0.01088595, \
-0.01148287, -0.01210131, -0.01274150, -0.01340363, -0.01408787, \
-0.01479435, -0.01552316, -0.01627437, -0.01704799, -0.01784402, \
-0.01866237, -0.01950296, -0.02036563, -0.02125019, -0.02215637, \
-0.02308389, -0.02403238, -0.02500144, -0.02599060, -0.02699934, \
-0.02802706, -0.02907312, -0.03013681, -0.03121735, -0.03231389, \
-0.03342552, -0.03455126, -0.03569006, -0.03684078, -0.03800224, \
-0.03917315, -0.04035217, -0.04153788, -0.04272877, -0.04392326, \
-0.04511970, -0.04631636, -0.04751141, -0.04870296, -0.04988905, \
-0.05106761, -0.05223652, -0.05339356, -0.05453645, -0.05566282, \
-0.05677022, -0.05785614, -0.05891797, -0.05995304, -0.06095861, \
-0.06193186, -0.06286990, -0.06376977, -0.06462846, -0.06544286, \
-0.06620982, -0.06692614, -0.06758854, -0.06819368, -0.06873819, \
-0.06921864, -0.06963154, -0.06997337, -0.07024057, -0.07042953, \
-0.07053662, -0.07055816, -0.07049047, -0.07032983, -0.07007250, \
-0.06971474, -0.06925278, -0.06868288, -0.06800126, -0.06720416, \
-0.06628783, -0.06524855, -0.06408259, -0.06278625, -0.06135589, \
-0.05978786, -0.05807858, -0.05622451, -0.05422216, -0.05206809, \
-0.04975893, -0.04729138, -0.04466219, -0.04186823, -0.03890642, \
-0.03577379, -0.03246745, -0.02898462, -0.02532264, -0.02147894, \
-0.01745108, -0.01323675, -0.00883376, -0.00424006, 0.00054627, \
0.00552699, 0.01070372, 0.01607791, 0.02165088, 0.02742375, \
0.03339750, 0.03957290, 0.04595058, 0.05253096, 0.05931430, \
0.06630063, 0.07348982, 0.08088153, 0.08847523, 0.09627015, \
0.10426537, 0.11245971, 0.12085180, 0.12944006, 0.13822269, \
0.14719766, 0.15636275, 0.16571549, 0.17525321, 0.18497300, \
0.19487175, 0.20494612, 0.21519254, 0.22560723, 0.23618618, \
0.24692518, 0.25781979, 0.26886536, 0.28005700, 0.29138966, \
0.30285804, 0.31445665, 0.32617980, 0.33802159, 0.34997595, \
0.36203658, 0.37419703, 0.38645066, 0.39879064, 0.41120998, \
0.42370152, 0.43625795, 0.44887180, 0.46153543, 0.47424111, \
0.48698093, 0.49974686, 0.51253079, 0.52532444, 0.53811946, \
0.55090741, 0.56367973, 0.57642781, 0.58914296, 0.60181642, \
0.61443937, 0.62700297, 0.63949832, 0.65191650, 0.66424858, \
0.67648561, 0.68861864, 0.70063876, 0.71253703, 0.72430458, \
0.73593257, 0.74741220, 0.75873473, 0.76989150, 0.78087391, \
0.79167348, 0.80228178, 0.81269053, 0.82289153, 0.83287674, \
0.84263824, 0.85216823, 0.86145911, 0.87050340, 0.87929381, \
0.88782323, 0.89608472, 0.90407155, 0.91177719, 0.91919533, \
0.92631985, 0.93314489, 0.93966479, 0.94587415, 0.95176781, \
0.95734086, 0.96258865, 0.96750679, 0.97209117, 0.97633792, \
0.98024349, 0.98380459, 0.98701821, 0.98988164, 0.99239247, \
0.99454857, 0.99634812, 0.99778959, 0.99887176, 0.99959372, \
0.99995485, } 

#define FLATTOP1024 {\
-0.00042105, -0.00042202, -0.00042493, -0.00042978, -0.00043657, \
-0.00044531, -0.00045601, -0.00046866, -0.00048330, -0.00049991, \
-0.00051852, -0.00053913, -0.00056176, -0.00058643, -0.00061316, \
-0.00064196, -0.00067284, -0.00070585, -0.00074098, -0.00077828, \
-0.00081775, -0.00085944, -0.00090336, -0.00094955, -0.00099803, \
-0.00104884, -0.00110200, -0.00115756, -0.00121553, -0.00127597, \
-0.00133890, -0.00140437, -0.00147240, -0.00154305, -0.00161635, \
-0.00169234, -0.00177106, -0.00185256, -0.00193688, -0.00202407, \
-0.00211417, -0.00220722, -0.00230329, -0.00240240, -0.00250461, \
-0.00260998, -0.00271854, -0.00283036, -0.00294547, -0.00306394, \
-0.00318581, -0.00331114, -0.00343998, -0.00357237, -0.00370838, \
-0.00384806, -0.00399146, -0.00413864, -0.00428965, -0.00444453, \
-0.00460336, -0.00476618, -0.00493304, -0.00510401, -0.00527913, \
-0.00545845, -0.00564204, -0.00582994, -0.00602220, -0.00621889, \
-0.00642005, -0.00662572, -0.00683598, -0.00705086, -0.00727041, \
-0.00749468, -0.00772373, -0.00795759, -0.00819632, -0.00843996, \
-0.00868856, -0.00894215, -0.00920079, -0.00946451, -0.00973336, \
-0.01000737, -0.01028659, -0.01057104, -0.01086076, -0.01115579, \
-0.01145616, -0.01176190, -0.01207303, -0.01238959, -0.01271161, \
-0.01303909, -0.01337207, -0.01371056, -0.01405459, -0.01440417, \
-0.01475930, -0.01512001, -0.01548630, -0.01585818, -0.01623564, \
-0.01661871, -0.01700736, -0.01740161, -0.01780144, -0.01820684, \
-0.01861781, -0.01903433, -0.01945638, -0.01988394, -0.02031699, \
-0.02075551, -0.02119946, -0.02164881, -0.02210353, -0.02256357, \
-0.02302890, -0.02349948, -0.02397524, -0.02445615, -0.02494213, \
-0.02543314, -0.02592911, -0.02642998, -0.02693567, -0.02744610, \
-0.02796121, -0.02848090, -0.02900509, -0.02953370, -0.03006662, \
-0.03060376, -0.03114502, -0.03169028, -0.03223944, -0.03279239, \
-0.03334899, -0.03390914, -0.03447270, -0.03503953, -0.03560950, \
-0.03618247, -0.03675830, -0.03733682, -0.03791789, -0.03850134, \
-0.03908701, -0.03967474, -0.04026433, -0.04085563, -0.04144843, \
-0.04204256, -0.04263782, -0.04323401, -0.04383093, -0.04442837, \
-0.04502611, -0.04562394, -0.04622164, -0.04681898, -0.04741572, \
-0.04801163, -0.04860646, -0.04919997, -0.04979191, -0.05038201, \
-0.05097002, -0.05155567, -0.05213868, -0.05271877, -0.05329568, \
-0.05386910, -0.05443875, -0.05500433, -0.05556554, -0.05612208, \
-0.05667362, -0.05721986, -0.05776048, -0.05829514, -0.05882353, \
-0.05934530, -0.05986012, -0.06036764, -0.06086752, -0.06135939, \
-0.06184292, -0.06231772, -0.06278345, -0.06323972, -0.06368617, \
-0.06412241, -0.06454806, -0.06496275, -0.06536607, -0.06575763, \
-0.06613703, -0.06650388, -0.06685776, -0.06719828, -0.06752500, \
-0.06783753, -0.06813544, -0.06841831, -0.06868570, -0.06893721, \
-0.06917238, -0.06939079, -0.06959200, -0.06977557, -0.06994105, \
-0.07008801, -0.07021599, -0.07032455, -0.07041323, -0.07048158, \
-0.07052914, -0.07055546, -0.07056007, -0.07054252, -0.07050234, \
-0.07043908, -0.07035225, -0.07024141, -0.07010608, -0.06994579, \
-0.06976008, -0.06954848, -0.06931052, -0.06904573, -0.06875365, \
-0.06843379, -0.06808570, -0.06770890, -0.06730294, -0.06686733, \
-0.06640161, -0.06590533, -0.06537801, -0.06481919, -0.06422841, \
-0.06360521, -0.06294913, -0.06225972, -0.06153652, -0.06077909, \
-0.05998696, -0.05915970, -0.05829686, -0.05739800, -0.05646268, \
-0.05549047, -0.05448093, -0.05343365, -0.05234820, -0.05122415, \
-0.05006109, -0.04885862, -0.04761631, -0.04633379, -0.04501064, \
-0.04364647, -0.04224090, -0.04079355, -0.03930404, -0.03777200, \
-0.03619707, -0.03457889, -0.03291711, -0.03121139, -0.02946137, \
-0.02766675, -0.02582718, -0.02394235, -0.02201196, -0.02003570, \
-0.01801327, -0.01594439, -0.01382878, -0.01166616, -0.00945629, \
-0.00719889, -0.00489373, -0.00254057, -0.00013918, 0.00231065, \
0.00480913, 0.00735647, 0.00995286, 0.01259847, 0.01529347, \
0.01803802, 0.02083228, 0.02367638, 0.02657046, 0.02951462, \
0.03250898, 0.03555364, 0.03864867, 0.04179415, 0.04499015, \
0.04823672, 0.05153390, 0.05488171, 0.05828017, 0.06172929, \
0.06522905, 0.06877944, 0.07238042, 0.07603196, 0.07973399, \
0.08348644, 0.08728924, 0.09114228, 0.09504545, 0.09899865, \
0.10300173, 0.10705454, 0.11115693, 0.11530872, 0.11950973, \
0.12375976, 0.12805858, 0.13240598, 0.13680172, 0.14124554, \
0.14573717, 0.15027633, 0.15486273, 0.15949606, 0.16417599, \
0.16890219, 0.17367432, 0.17849200, 0.18335486, 0.18826251, \
0.19321454, 0.19821053, 0.20325006, 0.20833267, 0.21345790, \
0.21862529, 0.22383434, 0.22908455, 0.23437541, 0.23970639, \
0.24507695, 0.25048653, 0.25593457, 0.26142047, 0.26694366, \
0.27250351, 0.27809940, 0.28373071, 0.28939678, 0.29509695, \
0.30083055, 0.30659689, 0.31239527, 0.31822499, 0.32408531, \
0.32997550, 0.33589482, 0.34184250, 0.34781778, 0.35381985, \
0.35984794, 0.36590124, 0.37197892, 0.37808015, 0.38420410, \
0.39034991, 0.39651672, 0.40270366, 0.40890985, 0.41513438, \
0.42137636, 0.42763488, 0.43390901, 0.44019782, 0.44650036, \
0.45281569, 0.45914285, 0.46548086, 0.47182876, 0.47818555, \
0.48455025, 0.49092185, 0.49729935, 0.50368173, 0.51006796, \
0.51645702, 0.52284788, 0.52923948, 0.53563079, 0.54202074, \
0.54840828, 0.55479234, 0.56117185, 0.56754574, 0.57391293, \
0.58027233, 0.58662285, 0.59296341, 0.59929291, 0.60561024, \
0.61191431, 0.61820402, 0.62447826, 0.63073591, 0.63697587, \
0.64319703, 0.64939827, 0.65557848, 0.66173655, 0.66787136, \
0.67398179, 0.68006674, 0.68612508, 0.69215570, 0.69815750, \
0.70412935, 0.71007016, 0.71597881, 0.72185419, 0.72769522, \
0.73350078, 0.73926978, 0.74500114, 0.75069375, 0.75634654, \
0.76195843, 0.76752833, 0.77305519, 0.77853793, 0.78397550, \
0.78936685, 0.79471092, 0.80000667, 0.80525307, 0.81044910, \
0.81559374, 0.82068597, 0.82572479, 0.83070920, 0.83563822, \
0.84051087, 0.84532618, 0.85008319, 0.85478095, 0.85941853, \
0.86399498, 0.86850940, 0.87296087, 0.87734849, 0.88167138, \
0.88592867, 0.89011949, 0.89424299, 0.89829833, 0.90228469, \
0.90620125, 0.91004721, 0.91382178, 0.91752419, 0.92115369, \
0.92470952, 0.92819095, 0.93159727, 0.93492776, 0.93818175, \
0.94135857, 0.94445754, 0.94747803, 0.95041942, 0.95328108, \
0.95606243, 0.95876289, 0.96138189, 0.96391889, 0.96637335, \
0.96874477, 0.97103264, 0.97323650, 0.97535587, 0.97739031, \
0.97933939, 0.98120271, 0.98297988, 0.98467051, 0.98627426, \
0.98779079, 0.98921977, 0.99056091, 0.99181392, 0.99297854, \
0.99405452, 0.99504164, 0.99593968, 0.99674847, 0.99746781, \
0.99809758, 0.99863762, 0.99908784, 0.99944812, 0.99971840, \
0.99989862, 0.99998874, } 

#define FLATTOP2048 {\
-0.00042105, -0.00042129, -0.00042202, -0.00042323, -0.00042492, \
-0.00042710, -0.00042977, -0.00043292, -0.00043655, -0.00044068, \
-0.00044529, -0.00045038, -0.00045597, -0.00046205, -0.00046862, \
-0.00047568, -0.00048323, -0.00049128, -0.00049983, -0.00050888, \
-0.00051842, -0.00052846, -0.00053901, -0.00055006, -0.00056162, \
-0.00057369, -0.00058627, -0.00059936, -0.00061297, -0.00062709, \
-0.00064174, -0.00065690, -0.00067259, -0.00068881, -0.00070556, \
-0.00072285, -0.00074066, -0.00075902, -0.00077792, -0.00079736, \
-0.00081736, -0.00083790, -0.00085900, -0.00088066, -0.00090288, \
-0.00092567, -0.00094902, -0.00097295, -0.00099745, -0.00102254, \
-0.00104821, -0.00107446, -0.00110131, -0.00112876, -0.00115681, \
-0.00118546, -0.00121472, -0.00124460, -0.00127510, -0.00130622, \
-0.00133796, -0.00137034, -0.00140336, -0.00143701, -0.00147132, \
-0.00150628, -0.00154189, -0.00157817, -0.00161511, -0.00165272, \
-0.00169101, -0.00172999, -0.00176965, -0.00181001, -0.00185106, \
-0.00189282, -0.00193529, -0.00197847, -0.00202238, -0.00206701, \
-0.00211238, -0.00215848, -0.00220533, -0.00225293, -0.00230128, \
-0.00235040, -0.00240029, -0.00245094, -0.00250238, -0.00255461, \
-0.00260763, -0.00266145, -0.00271607, -0.00277150, -0.00282775, \
-0.00288483, -0.00294274, -0.00300148, -0.00306107, -0.00312150, \
-0.00318279, -0.00324495, -0.00330797, -0.00337188, -0.00343666, \
-0.00350233, -0.00356890, -0.00363637, -0.00370475, -0.00377404, \
-0.00384426, -0.00391541, -0.00398749, -0.00406052, -0.00413449, \
-0.00420942, -0.00428531, -0.00436218, -0.00444002, -0.00451884, \
-0.00459865, -0.00467946, -0.00476127, -0.00484409, -0.00492793, \
-0.00501279, -0.00509868, -0.00518561, -0.00527359, -0.00536261, \
-0.00545269, -0.00554384, -0.00563605, -0.00572934, -0.00582372, \
-0.00591918, -0.00601575, -0.00611341, -0.00621219, -0.00631208, \
-0.00641309, -0.00651524, -0.00661851, -0.00672294, -0.00682850, \
-0.00693523, -0.00704311, -0.00715216, -0.00726239, -0.00737379, \
-0.00748638, -0.00760016, -0.00771514, -0.00783132, -0.00794870, \
-0.00806731, -0.00818713, -0.00830818, -0.00843046, -0.00855398, \
-0.00867875, -0.00880476, -0.00893202, -0.00906055, -0.00919033, \
-0.00932139, -0.00945372, -0.00958733, -0.00972223, -0.00985841, \
-0.00999589, -0.01013467, -0.01027475, -0.01041614, -0.01055884, \
-0.01070286, -0.01084820, -0.01099486, -0.01114285, -0.01129218, \
-0.01144284, -0.01159484, -0.01174819, -0.01190289, -0.01205893, \
-0.01221634, -0.01237509, -0.01253521, -0.01269670, -0.01285955, \
-0.01302377, -0.01318936, -0.01335633, -0.01352468, -0.01369440, \
-0.01386550, -0.01403799, -0.01421187, -0.01438713, -0.01456378, \
-0.01474182, -0.01492126, -0.01510208, -0.01528430, -0.01546791, \
-0.01565292, -0.01583933, -0.01602713, -0.01621633, -0.01640693, \
-0.01659892, -0.01679231, -0.01698710, -0.01718328, -0.01738086, \
-0.01757984, -0.01778020, -0.01798196, -0.01818511, -0.01838966, \
-0.01859558, -0.01880290, -0.01901160, -0.01922168, -0.01943314, \
-0.01964598, -0.01986019, -0.02007578, -0.02029273, -0.02051105, \
-0.02073073, -0.02095176, -0.02117415, -0.02139789, -0.02162298, \
-0.02184941, -0.02207717, -0.02230626, -0.02253668, -0.02276842, \
-0.02300148, -0.02323585, -0.02347152, -0.02370848, -0.02394674, \
-0.02418629, -0.02442711, -0.02466920, -0.02491255, -0.02515716, \
-0.02540302, -0.02565011, -0.02589844, -0.02614800, -0.02639876, \
-0.02665074, -0.02690390, -0.02715826, -0.02741379, -0.02767050, \
-0.02792836, -0.02818736, -0.02844750, -0.02870877, -0.02897116, \
-0.02923464, -0.02949922, -0.02976488, -0.03003160, -0.03029938, \
-0.03056821, -0.03083806, -0.03110893, -0.03138080, -0.03165366, \
-0.03192750, -0.03220230, -0.03247804, -0.03275472, -0.03303232, \
-0.03331081, -0.03359019, -0.03387045, -0.03415155, -0.03443349, \
-0.03471626, -0.03499983, -0.03528418, -0.03556931, -0.03585518, \
-0.03614179, -0.03642912, -0.03671714, -0.03700583, -0.03729519, \
-0.03758518, -0.03787579, -0.03816701, -0.03845879, -0.03875114, \
-0.03904402, -0.03933742, -0.03963131, -0.03992568, -0.04022049, \
-0.04051573, -0.04081138, -0.04110740, -0.04140379, -0.04170050, \
-0.04199753, -0.04229484, -0.04259242, -0.04289023, -0.04318825, \
-0.04348646, -0.04378483, -0.04408334, -0.04438195, -0.04468064, \
-0.04497938, -0.04527815, -0.04557692, -0.04587567, -0.04617435, \
-0.04647295, -0.04677143, -0.04706977, -0.04736794, -0.04766590, \
-0.04796363, -0.04826110, -0.04855827, -0.04885512, -0.04915161, \
-0.04944771, -0.04974340, -0.05003863, -0.05033337, -0.05062760, \
-0.05092127, -0.05121437, -0.05150684, -0.05179866, -0.05208980, \
-0.05238021, -0.05266987, -0.05295873, -0.05324677, -0.05353395, \
-0.05382022, -0.05410556, -0.05438993, -0.05467329, -0.05495560, \
-0.05523682, -0.05551692, -0.05579587, -0.05607361, -0.05635011, \
-0.05662533, -0.05689924, -0.05717178, -0.05744293, -0.05771265, \
-0.05798088, -0.05824760, -0.05851275, -0.05877630, -0.05903821, \
-0.05929843, -0.05955692, -0.05981364, -0.06006854, -0.06032159, \
-0.06057273, -0.06082194, -0.06106915, -0.06131432, -0.06155742, \
-0.06179840, -0.06203721, -0.06227380, -0.06250813, -0.06274016, \
-0.06296984, -0.06319712, -0.06342195, -0.06364429, -0.06386409, \
-0.06408130, -0.06429588, -0.06450778, -0.06471694, -0.06492333, \
-0.06512688, -0.06532756, -0.06552531, -0.06572009, -0.06591184, \
-0.06610051, -0.06628606, -0.06646842, -0.06664757, -0.06682343, \
-0.06699596, -0.06716512, -0.06733084, -0.06749307, -0.06765177, \
-0.06780689, -0.06795836, -0.06810613, -0.06825017, -0.06839040, \
-0.06852678, -0.06865925, -0.06878777, -0.06891227, -0.06903270, \
-0.06914902, -0.06926116, -0.06936906, -0.06947269, -0.06957197, \
-0.06966686, -0.06975730, -0.06984324, -0.06992461, -0.07000137, \
-0.07007346, -0.07014082, -0.07020340, -0.07026114, -0.07031398, \
-0.07036187, -0.07040475, -0.07044256, -0.07047525, -0.07050277, \
-0.07052504, -0.07054202, -0.07055366, -0.07055988, -0.07056064, \
-0.07055587, -0.07054552, -0.07052954, -0.07050786, -0.07048042, \
-0.07044717, -0.07040806, -0.07036301, -0.07031198, -0.07025490, \
-0.07019172, -0.07012238, -0.07004682, -0.06996498, -0.06987680, \
-0.06978223, -0.06968121, -0.06957367, -0.06945957, -0.06933883, \
-0.06921141, -0.06907724, -0.06893627, -0.06878843, -0.06863367, \
-0.06847194, -0.06830316, -0.06812729, -0.06794426, -0.06775401, \
-0.06755650, -0.06735165, -0.06713941, -0.06691973, -0.06669254, \
-0.06645779, -0.06621542, -0.06596536, -0.06570757, -0.06544198, \
-0.06516854, -0.06488719, -0.06459787, -0.06430052, -0.06399509, \
-0.06368152, -0.06335975, -0.06302973, -0.06269140, -0.06234469, \
-0.06198956, -0.06162595, -0.06125381, -0.06087307, -0.06048367, \
-0.06008558, -0.05967872, -0.05926304, -0.05883849, -0.05840501, \
-0.05796255, -0.05751106, -0.05705047, -0.05658073, -0.05610179, \
-0.05561360, -0.05511610, -0.05460924, -0.05409297, -0.05356722, \
-0.05303196, -0.05248712, -0.05193266, -0.05136852, -0.05079465, \
-0.05021099, -0.04961751, -0.04901414, -0.04840084, -0.04777756, \
-0.04714424, -0.04650083, -0.04584730, -0.04518358, -0.04450963, \
-0.04382540, -0.04313084, -0.04242590, -0.04171055, -0.04098472, \
-0.04024837, -0.03950146, -0.03874394, -0.03797577, -0.03719690, \
-0.03640727, -0.03560686, -0.03479562, -0.03397349, -0.03314045, \
-0.03229644, -0.03144142, -0.03057536, -0.02969820, -0.02880991, \
-0.02791045, -0.02699977, -0.02607784, -0.02514462, -0.02420007, \
-0.02324414, -0.02227681, -0.02129803, -0.02030777, -0.01930598, \
-0.01829264, -0.01726771, -0.01623115, -0.01518293, -0.01412301, \
-0.01305137, -0.01196796, -0.01087275, -0.00976572, -0.00864682, \
-0.00751604, -0.00637333, -0.00521868, -0.00405204, -0.00287340, \
-0.00168272, -0.00047997, 0.00073487, 0.00196183, 0.00320093, \
0.00445221, 0.00571567, 0.00699136, 0.00827929, 0.00957948, \
0.01089197, 0.01221676, 0.01355388, 0.01490336, 0.01626520, \
0.01763944, 0.01902608, 0.02042515, 0.02183666, 0.02326064, \
0.02469709, 0.02614603, 0.02760748, 0.02908145, 0.03056795, \
0.03206700, 0.03357860, 0.03510278, 0.03663953, 0.03818888, \
0.03975082, 0.04132537, 0.04291253, 0.04451232, 0.04612473, \
0.04774978, 0.04938747, 0.05103779, 0.05270077, 0.05437639, \
0.05606466, 0.05776559, 0.05947916, 0.06120539, 0.06294426, \
0.06469579, 0.06645996, 0.06823677, 0.07002622, 0.07182830, \
0.07364301, 0.07547034, 0.07731029, 0.07916284, 0.08102799, \
0.08290572, 0.08479603, 0.08669891, 0.08861434, 0.09054231, \
0.09248280, 0.09443581, 0.09640132, 0.09837931, 0.10036976, \
0.10237266, 0.10438798, 0.10641572, 0.10845584, 0.11050833, \
0.11257317, 0.11465033, 0.11673979, 0.11884152, 0.12095551, \
0.12308172, 0.12522013, 0.12737070, 0.12953342, 0.13170825, \
0.13389517, 0.13609413, 0.13830511, 0.14052808, 0.14276300, \
0.14500984, 0.14726857, 0.14953914, 0.15182152, 0.15411567, \
0.15642156, 0.15873914, 0.16106837, 0.16340922, 0.16576164, \
0.16812558, 0.17050101, 0.17288787, 0.17528613, 0.17769574, \
0.18011665, 0.18254881, 0.18499217, 0.18744668, 0.18991230, \
0.19238896, 0.19487663, 0.19737524, 0.19988474, 0.20240507, \
0.20493619, 0.20747803, 0.21003053, 0.21259364, 0.21516730, \
0.21775145, 0.22034602, 0.22295096, 0.22556620, 0.22819168, \
0.23082733, 0.23347310, 0.23612890, 0.23879468, 0.24147037, \
0.24415590, 0.24685120, 0.24955620, 0.25227083, 0.25499502, \
0.25772869, 0.26047177, 0.26322418, 0.26598586, 0.26875672, \
0.27153669, 0.27432569, 0.27712364, 0.27993046, 0.28274608, \
0.28557040, 0.28840336, 0.29124486, 0.29409482, 0.29695316, \
0.29981980, 0.30269465, 0.30557761, 0.30846861, 0.31136756, \
0.31427436, 0.31718893, 0.32011118, 0.32304101, 0.32597834, \
0.32892307, 0.33187511, 0.33483435, 0.33780072, 0.34077411, \
0.34375443, 0.34674157, 0.34973545, 0.35273595, 0.35574299, \
0.35875646, 0.36177627, 0.36480230, 0.36783446, 0.37087265, \
0.37391675, 0.37696668, 0.38002231, 0.38308356, 0.38615030, \
0.38922243, 0.39229985, 0.39538245, 0.39847011, 0.40156273, \
0.40466020, 0.40776240, 0.41086923, 0.41398057, 0.41709631, \
0.42021634, 0.42334054, 0.42646880, 0.42960100, 0.43273702, \
0.43587676, 0.43902009, 0.44216689, 0.44531705, 0.44847045, \
0.45162697, 0.45478649, 0.45794888, 0.46111404, 0.46428183, \
0.46745213, 0.47062483, 0.47379980, 0.47697691, 0.48015604, \
0.48333707, 0.48651987, 0.48970432, 0.49289029, 0.49607765, \
0.49926628, 0.50245605, 0.50564684, 0.50883851, 0.51203093, \
0.51522398, 0.51841753, 0.52161145, 0.52480561, 0.52799987, \
0.53119411, 0.53438819, 0.53758199, 0.54077537, 0.54396820, \
0.54716034, 0.55035167, 0.55354205, 0.55673135, 0.55991942, \
0.56310615, 0.56629139, 0.56947501, 0.57265687, 0.57583684, \
0.57901479, 0.58219057, 0.58536405, 0.58853510, 0.59170358, \
0.59486935, 0.59803227, 0.60119221, 0.60434903, 0.60750260, \
0.61065277, 0.61379940, 0.61694237, 0.62008153, 0.62321674, \
0.62634786, 0.62947476, 0.63259730, 0.63571534, 0.63882873, \
0.64193735, 0.64504105, 0.64813970, 0.65123314, 0.65432126, \
0.65740390, 0.66048092, 0.66355219, 0.66661758, 0.66967693, \
0.67273011, 0.67577698, 0.67881740, 0.68185124, 0.68487835, \
0.68789860, 0.69091184, 0.69391794, 0.69691675, 0.69990815, \
0.70289199, 0.70586813, 0.70883643, 0.71179676, 0.71474898, \
0.71769295, 0.72062853, 0.72355559, 0.72647399, 0.72938358, \
0.73228424, 0.73517583, 0.73805820, 0.74093123, 0.74379478, \
0.74664871, 0.74949288, 0.75232717, 0.75515143, 0.75796553, \
0.76076934, 0.76356273, 0.76634555, 0.76911767, 0.77187897, \
0.77462930, 0.77736855, 0.78009656, 0.78281322, 0.78551839, \
0.78821194, 0.79089374, 0.79356365, 0.79622156, 0.79886732, \
0.80150082, 0.80412191, 0.80673048, 0.80932640, 0.81190954, \
0.81447976, 0.81703696, 0.81958099, 0.82211174, 0.82462908, \
0.82713288, 0.82962303, 0.83209939, 0.83456185, 0.83701029, \
0.83944458, 0.84186460, 0.84427023, 0.84666136, 0.84903786, \
0.85139961, 0.85374649, 0.85607840, 0.85839521, 0.86069681, \
0.86298307, 0.86525390, 0.86750916, 0.86974875, 0.87197256, \
0.87418048, 0.87637238, 0.87854817, 0.88070773, 0.88285096, \
0.88497774, 0.88708796, 0.88918153, 0.89125833, 0.89331826, \
0.89536121, 0.89738708, 0.89939577, 0.90138718, 0.90336119, \
0.90531772, 0.90725666, 0.90917792, 0.91108139, 0.91296698, \
0.91483459, 0.91668412, 0.91851549, 0.92032859, 0.92212334, \
0.92389964, 0.92565740, 0.92739652, 0.92911693, 0.93081853, \
0.93250124, 0.93416496, 0.93580961, 0.93743511, 0.93904137, \
0.94062831, 0.94219585, 0.94374390, 0.94527239, 0.94678123, \
0.94827036, 0.94973968, 0.95118913, 0.95261863, 0.95402810, \
0.95541748, 0.95678668, 0.95813564, 0.95946430, 0.96077257, \
0.96206039, 0.96332769, 0.96457441, 0.96580049, 0.96700585, \
0.96819044, 0.96935419, 0.97049704, 0.97161894, 0.97271982, \
0.97379963, 0.97485831, 0.97589580, 0.97691205, 0.97790701, \
0.97888062, 0.97983284, 0.98076361, 0.98167289, 0.98256062, \
0.98342676, 0.98427127, 0.98509410, 0.98589520, 0.98667454, \
0.98743208, 0.98816777, 0.98888157, 0.98957345, 0.99024338, \
0.99089131, 0.99151721, 0.99212105, 0.99270280, 0.99326242, \
0.99379989, 0.99431518, 0.99480827, 0.99527911, 0.99572770, \
0.99615401, 0.99655801, 0.99693968, 0.99729901, 0.99763597, \
0.99795055, 0.99824272, 0.99851248, 0.99875982, 0.99898470, \
0.99918714, 0.99936710, 0.99952460, 0.99965960, 0.99977212, \
0.99986214, 0.99992967, 0.99997468, 0.99999719, } 

#define FLATTOP4096 {\
-0.00042105, -0.00042111, -0.00042129, -0.00042160, -0.00042202, \
-0.00042256, -0.00042323, -0.00042401, -0.00042492, -0.00042595, \
-0.00042710, -0.00042837, -0.00042976, -0.00043128, -0.00043291, \
-0.00043467, -0.00043655, -0.00043854, -0.00044067, -0.00044291, \
-0.00044527, -0.00044776, -0.00045037, -0.00045310, -0.00045595, \
-0.00045893, -0.00046203, -0.00046525, -0.00046859, -0.00047206, \
-0.00047565, -0.00047937, -0.00048320, -0.00048717, -0.00049125, \
-0.00049546, -0.00049979, -0.00050425, -0.00050883, -0.00051354, \
-0.00051837, -0.00052333, -0.00052841, -0.00053362, -0.00053895, \
-0.00054441, -0.00055000, -0.00055571, -0.00056155, -0.00056752, \
-0.00057362, -0.00057984, -0.00058619, -0.00059267, -0.00059927, \
-0.00060601, -0.00061287, -0.00061987, -0.00062699, -0.00063424, \
-0.00064163, -0.00064914, -0.00065679, -0.00066456, -0.00067247, \
-0.00068051, -0.00068868, -0.00069698, -0.00070542, -0.00071399, \
-0.00072270, -0.00073153, -0.00074050, -0.00074961, -0.00075885, \
-0.00076823, -0.00077774, -0.00078739, -0.00079718, -0.00080710, \
-0.00081716, -0.00082736, -0.00083769, -0.00084817, -0.00085878, \
-0.00086954, -0.00088043, -0.00089146, -0.00090264, -0.00091395, \
-0.00092541, -0.00093701, -0.00094875, -0.00096064, -0.00097267, \
-0.00098484, -0.00099716, -0.00100962, -0.00102223, -0.00103499, \
-0.00104789, -0.00106094, -0.00107413, -0.00108748, -0.00110097, \
-0.00111461, -0.00112840, -0.00114234, -0.00115643, -0.00117068, \
-0.00118507, -0.00119962, -0.00121432, -0.00122917, -0.00124418, \
-0.00125934, -0.00127466, -0.00129013, -0.00130576, -0.00132155, \
-0.00133749, -0.00135359, -0.00136985, -0.00138627, -0.00140285, \
-0.00141959, -0.00143649, -0.00145355, -0.00147078, -0.00148817, \
-0.00150572, -0.00152343, -0.00154131, -0.00155936, -0.00157757, \
-0.00159594, -0.00161449, -0.00163320, -0.00165208, -0.00167113, \
-0.00169035, -0.00170974, -0.00172931, -0.00174904, -0.00176895, \
-0.00178903, -0.00180928, -0.00182971, -0.00185031, -0.00187109, \
-0.00189205, -0.00191318, -0.00193450, -0.00195599, -0.00197766, \
-0.00199951, -0.00202154, -0.00204375, -0.00206615, -0.00208872, \
-0.00211149, -0.00213443, -0.00215756, -0.00218088, -0.00220439, \
-0.00222808, -0.00225196, -0.00227603, -0.00230028, -0.00232473, \
-0.00234937, -0.00237421, -0.00239923, -0.00242445, -0.00244986, \
-0.00247547, -0.00250127, -0.00252727, -0.00255347, -0.00257986, \
-0.00260646, -0.00263325, -0.00266024, -0.00268744, -0.00271483, \
-0.00274243, -0.00277023, -0.00279824, -0.00282645, -0.00285487, \
-0.00288350, -0.00291233, -0.00294137, -0.00297062, -0.00300008, \
-0.00302975, -0.00305963, -0.00308972, -0.00312003, -0.00315055, \
-0.00318129, -0.00321224, -0.00324341, -0.00327479, -0.00330639, \
-0.00333822, -0.00337026, -0.00340252, -0.00343500, -0.00346771, \
-0.00350064, -0.00353379, -0.00356716, -0.00360077, -0.00363459, \
-0.00366865, -0.00370293, -0.00373745, -0.00377219, -0.00380716, \
-0.00384236, -0.00387780, -0.00391347, -0.00394937, -0.00398551, \
-0.00402188, -0.00405849, -0.00409533, -0.00413242, -0.00416974, \
-0.00420730, -0.00424511, -0.00428315, -0.00432144, -0.00435997, \
-0.00439874, -0.00443776, -0.00447702, -0.00451653, -0.00455629, \
-0.00459630, -0.00463655, -0.00467706, -0.00471781, -0.00475882, \
-0.00480008, -0.00484159, -0.00488336, -0.00492538, -0.00496765, \
-0.00501019, -0.00505298, -0.00509603, -0.00513933, -0.00518290, \
-0.00522673, -0.00527082, -0.00531517, -0.00535979, -0.00540467, \
-0.00544982, -0.00549523, -0.00554090, -0.00558685, -0.00563306, \
-0.00567954, -0.00572630, -0.00577332, -0.00582061, -0.00586818, \
-0.00591602, -0.00596413, -0.00601252, -0.00606119, -0.00611013, \
-0.00615934, -0.00620884, -0.00625861, -0.00630867, -0.00635900, \
-0.00640962, -0.00646052, -0.00651170, -0.00656316, -0.00661491, \
-0.00666695, -0.00671927, -0.00677188, -0.00682477, -0.00687796, \
-0.00693143, -0.00698519, -0.00703925, -0.00709359, -0.00714823, \
-0.00720316, -0.00725838, -0.00731390, -0.00736972, -0.00742583, \
-0.00748223, -0.00753894, -0.00759594, -0.00765324, -0.00771085, \
-0.00776875, -0.00782695, -0.00788546, -0.00794427, -0.00800338, \
-0.00806280, -0.00812252, -0.00818254, -0.00824288, -0.00830352, \
-0.00836447, -0.00842572, -0.00848729, -0.00854916, -0.00861135, \
-0.00867385, -0.00873666, -0.00879978, -0.00886321, -0.00892696, \
-0.00899103, -0.00905541, -0.00912010, -0.00918511, -0.00925044, \
-0.00931608, -0.00938205, -0.00944833, -0.00951494, -0.00958186, \
-0.00964910, -0.00971667, -0.00978456, -0.00985277, -0.00992130, \
-0.00999016, -0.01005934, -0.01012885, -0.01019868, -0.01026884, \
-0.01033933, -0.01041014, -0.01048128, -0.01055275, -0.01062455, \
-0.01069668, -0.01076913, -0.01084192, -0.01091504, -0.01098849, \
-0.01106228, -0.01113639, -0.01121084, -0.01128562, -0.01136074, \
-0.01143619, -0.01151198, -0.01158810, -0.01166455, -0.01174135, \
-0.01181848, -0.01189595, -0.01197375, -0.01205189, -0.01213037, \
-0.01220919, -0.01228835, -0.01236785, -0.01244769, -0.01252787, \
-0.01260839, -0.01268925, -0.01277046, -0.01285200, -0.01293389, \
-0.01301612, -0.01309869, -0.01318161, -0.01326487, -0.01334847, \
-0.01343242, -0.01351671, -0.01360135, -0.01368633, -0.01377165, \
-0.01385733, -0.01394334, -0.01402971, -0.01411642, -0.01420347, \
-0.01429088, -0.01437862, -0.01446672, -0.01455516, -0.01464396, \
-0.01473309, -0.01482258, -0.01491242, -0.01500260, -0.01509313, \
-0.01518401, -0.01527523, -0.01536681, -0.01545873, -0.01555101, \
-0.01564363, -0.01573660, -0.01582992, -0.01592359, -0.01601761, \
-0.01611197, -0.01620669, -0.01630175, -0.01639717, -0.01649293, \
-0.01658904, -0.01668550, -0.01678231, -0.01687947, -0.01697698, \
-0.01707484, -0.01717304, -0.01727160, -0.01737050, -0.01746975, \
-0.01756935, -0.01766930, -0.01776960, -0.01787024, -0.01797124, \
-0.01807258, -0.01817426, -0.01827630, -0.01837868, -0.01848141, \
-0.01858449, -0.01868791, -0.01879168, -0.01889579, -0.01900025, \
-0.01910505, -0.01921020, -0.01931570, -0.01942154, -0.01952772, \
-0.01963425, -0.01974112, -0.01984833, -0.01995589, -0.02006379, \
-0.02017203, -0.02028061, -0.02038954, -0.02049880, -0.02060841, \
-0.02071835, -0.02082863, -0.02093926, -0.02105022, -0.02116152, \
-0.02127315, -0.02138513, -0.02149744, -0.02161008, -0.02172306, \
-0.02183638, -0.02195002, -0.02206401, -0.02217832, -0.02229297, \
-0.02240795, -0.02252325, -0.02263889, -0.02275486, -0.02287116, \
-0.02298779, -0.02310474, -0.02322202, -0.02333962, -0.02345755, \
-0.02357581, -0.02369439, -0.02381329, -0.02393251, -0.02405205, \
-0.02417192, -0.02429210, -0.02441260, -0.02453342, -0.02465456, \
-0.02477601, -0.02489778, -0.02501986, -0.02514225, -0.02526496, \
-0.02538797, -0.02551130, -0.02563493, -0.02575888, -0.02588313, \
-0.02600768, -0.02613254, -0.02625771, -0.02638317, -0.02650894, \
-0.02663501, -0.02676138, -0.02688804, -0.02701501, -0.02714226, \
-0.02726982, -0.02739766, -0.02752580, -0.02765423, -0.02778294, \
-0.02791195, -0.02804124, -0.02817082, -0.02830068, -0.02843083, \
-0.02856125, -0.02869196, -0.02882295, -0.02895421, -0.02908575, \
-0.02921756, -0.02934964, -0.02948200, -0.02961463, -0.02974752, \
-0.02988069, -0.03001412, -0.03014781, -0.03028176, -0.03041598, \
-0.03055045, -0.03068518, -0.03082017, -0.03095541, -0.03109091, \
-0.03122665, -0.03136265, -0.03149889, -0.03163538, -0.03177211, \
-0.03190908, -0.03204630, -0.03218375, -0.03232144, -0.03245936, \
-0.03259752, -0.03273591, -0.03287453, -0.03301337, -0.03315245, \
-0.03329174, -0.03343126, -0.03357099, -0.03371095, -0.03385112, \
-0.03399150, -0.03413210, -0.03427290, -0.03441391, -0.03455513, \
-0.03469655, -0.03483818, -0.03498000, -0.03512202, -0.03526423, \
-0.03540663, -0.03554923, -0.03569201, -0.03583498, -0.03597814, \
-0.03612147, -0.03626498, -0.03640867, -0.03655254, -0.03669658, \
-0.03684078, -0.03698515, -0.03712969, -0.03727439, -0.03741925, \
-0.03756427, -0.03770944, -0.03785477, -0.03800024, -0.03814587, \
-0.03829163, -0.03843754, -0.03858359, -0.03872978, -0.03887610, \
-0.03902255, -0.03916913, -0.03931584, -0.03946267, -0.03960962, \
-0.03975670, -0.03990388, -0.04005118, -0.04019859, -0.04034611, \
-0.04049373, -0.04064145, -0.04078927, -0.04093719, -0.04108520, \
-0.04123330, -0.04138148, -0.04152975, -0.04167810, -0.04182653, \
-0.04197504, -0.04212361, -0.04227226, -0.04242097, -0.04256974, \
-0.04271857, -0.04286746, -0.04301640, -0.04316540, -0.04331444, \
-0.04346352, -0.04361264, -0.04376180, -0.04391100, -0.04406022, \
-0.04420948, -0.04435875, -0.04450805, -0.04465737, -0.04480670, \
-0.04495604, -0.04510538, -0.04525473, -0.04540408, -0.04555343, \
-0.04570277, -0.04585210, -0.04600142, -0.04615072, -0.04630000, \
-0.04644925, -0.04659848, -0.04674767, -0.04689683, -0.04704595, \
-0.04719503, -0.04734406, -0.04749304, -0.04764197, -0.04779084, \
-0.04793965, -0.04808839, -0.04823707, -0.04838567, -0.04853419, \
-0.04868263, -0.04883099, -0.04897926, -0.04912744, -0.04927552, \
-0.04942350, -0.04957138, -0.04971915, -0.04986681, -0.05001435, \
-0.05016177, -0.05030906, -0.05045623, -0.05060326, -0.05075016, \
-0.05089691, -0.05104352, -0.05118998, -0.05133629, -0.05148244, \
-0.05162842, -0.05177424, -0.05191989, -0.05206537, -0.05221066, \
-0.05235577, -0.05250069, -0.05264542, -0.05278996, -0.05293429, \
-0.05307841, -0.05322233, -0.05336603, -0.05350951, -0.05365276, \
-0.05379579, -0.05393859, -0.05408114, -0.05422346, -0.05436553, \
-0.05450734, -0.05464890, -0.05479020, -0.05493124, -0.05507200, \
-0.05521249, -0.05535270, -0.05549262, -0.05563225, -0.05577159, \
-0.05591064, -0.05604937, -0.05618780, -0.05632592, -0.05646371, \
-0.05660119, -0.05673833, -0.05687514, -0.05701162, -0.05714775, \
-0.05728353, -0.05741896, -0.05755403, -0.05768873, -0.05782307, \
-0.05795703, -0.05809062, -0.05822382, -0.05835663, -0.05848905, \
-0.05862107, -0.05875268, -0.05888389, -0.05901467, -0.05914504, \
-0.05927498, -0.05940450, -0.05953357, -0.05966220, -0.05979039, \
-0.05991812, -0.06004540, -0.06017221, -0.06029856, -0.06042443, \
-0.06054982, -0.06067472, -0.06079914, -0.06092305, -0.06104647, \
-0.06116938, -0.06129178, -0.06141366, -0.06153501, -0.06165584, \
-0.06177613, -0.06189588, -0.06201508, -0.06213373, -0.06225182, \
-0.06236935, -0.06248631, -0.06260270, -0.06271850, -0.06283372, \
-0.06294835, -0.06306237, -0.06317580, -0.06328861, -0.06340081, \
-0.06351238, -0.06362333, -0.06373364, -0.06384332, -0.06395235, \
-0.06406073, -0.06416845, -0.06427551, -0.06438190, -0.06448761, \
-0.06459264, -0.06469699, -0.06480064, -0.06490359, -0.06500584, \
-0.06510737, -0.06520819, -0.06530828, -0.06540764, -0.06550627, \
-0.06560415, -0.06570129, -0.06579767, -0.06589329, -0.06598814, \
-0.06608222, -0.06617551, -0.06626803, -0.06635974, -0.06645066, \
-0.06654078, -0.06663008, -0.06671857, -0.06680623, -0.06689306, \
-0.06697905, -0.06706420, -0.06714850, -0.06723194, -0.06731452, \
-0.06739623, -0.06747707, -0.06755702, -0.06763608, -0.06771425, \
-0.06779152, -0.06786788, -0.06794332, -0.06801784, -0.06809143, \
-0.06816409, -0.06823581, -0.06830658, -0.06837639, -0.06844525, \
-0.06851313, -0.06858004, -0.06864597, -0.06871092, -0.06877486, \
-0.06883781, -0.06889975, -0.06896067, -0.06902057, -0.06907944, \
-0.06913728, -0.06919407, -0.06924982, -0.06930451, -0.06935814, \
-0.06941070, -0.06946218, -0.06951258, -0.06956189, -0.06961011, \
-0.06965722, -0.06970322, -0.06974810, -0.06979186, -0.06983449, \
-0.06987598, -0.06991632, -0.06995552, -0.06999355, -0.07003042, \
-0.07006611, -0.07010063, -0.07013396, -0.07016609, -0.07019702, \
-0.07022675, -0.07025526, -0.07028255, -0.07030861, -0.07033344, \
-0.07035702, -0.07037935, -0.07040042, -0.07042023, -0.07043877, \
-0.07045603, -0.07047200, -0.07048668, -0.07050007, -0.07051214, \
-0.07052290, -0.07053234, -0.07054045, -0.07054723, -0.07055266, \
-0.07055674, -0.07055947, -0.07056083, -0.07056082, -0.07055943, \
-0.07055666, -0.07055249, -0.07054692, -0.07053995, -0.07053156, \
-0.07052175, -0.07051051, -0.07049783, -0.07048371, -0.07046814, \
-0.07045111, -0.07043262, -0.07041265, -0.07039121, -0.07036827, \
-0.07034385, -0.07031792, -0.07029048, -0.07026153, -0.07023105, \
-0.07019904, -0.07016550, -0.07013041, -0.07009376, -0.07005556, \
-0.07001579, -0.06997444, -0.06993152, -0.06988700, -0.06984089, \
-0.06979318, -0.06974385, -0.06969290, -0.06964033, -0.06958613, \
-0.06953029, -0.06947280, -0.06941365, -0.06935285, -0.06929037, \
-0.06922622, -0.06916038, -0.06909285, -0.06902362, -0.06895269, \
-0.06888004, -0.06880568, -0.06872958, -0.06865175, -0.06857218, \
-0.06849086, -0.06840778, -0.06832293, -0.06823632, -0.06814792, \
-0.06805774, -0.06796577, -0.06787199, -0.06777641, -0.06767901, \
-0.06757978, -0.06747873, -0.06737584, -0.06727111, -0.06716452, \
-0.06705607, -0.06694576, -0.06683357, -0.06671951, -0.06660355, \
-0.06648570, -0.06636595, -0.06624428, -0.06612070, -0.06599519, \
-0.06586776, -0.06573838, -0.06560706, -0.06547378, -0.06533854, \
-0.06520134, -0.06506216, -0.06492100, -0.06477784, -0.06463270, \
-0.06448554, -0.06433638, -0.06418520, -0.06403199, -0.06387675, \
-0.06371947, -0.06356015, -0.06339877, -0.06323533, -0.06306982, \
-0.06290224, -0.06273257, -0.06256082, -0.06238696, -0.06221101, \
-0.06203294, -0.06185276, -0.06167045, -0.06148601, -0.06129943, \
-0.06111071, -0.06091983, -0.06072679, -0.06053159, -0.06033421, \
-0.06013465, -0.05993291, -0.05972897, -0.05952282, -0.05931447, \
-0.05910391, -0.05889112, -0.05867610, -0.05845885, -0.05823935, \
-0.05801761, -0.05779360, -0.05756734, -0.05733880, -0.05710799, \
-0.05687489, -0.05663950, -0.05640182, -0.05616183, -0.05591953, \
-0.05567491, -0.05542797, -0.05517870, -0.05492709, -0.05467313, \
-0.05441683, -0.05415816, -0.05389714, -0.05363374, -0.05336796, \
-0.05309980, -0.05282925, -0.05255630, -0.05228095, -0.05200319, \
-0.05172302, -0.05144041, -0.05115538, -0.05086792, -0.05057801, \
-0.05028565, -0.04999084, -0.04969357, -0.04939382, -0.04909161, \
-0.04878691, -0.04847973, -0.04817005, -0.04785787, -0.04754319, \
-0.04722599, -0.04690628, -0.04658404, -0.04625928, -0.04593197, \
-0.04560213, -0.04526973, -0.04493478, -0.04459727, -0.04425719, \
-0.04391453, -0.04356930, -0.04322149, -0.04287108, -0.04251807, \
-0.04216247, -0.04180425, -0.04144342, -0.04107996, -0.04071388, \
-0.04034517, -0.03997382, -0.03959983, -0.03922319, -0.03884389, \
-0.03846193, -0.03807730, -0.03769000, -0.03730003, -0.03690737, \
-0.03651202, -0.03611397, -0.03571323, -0.03530978, -0.03490362, \
-0.03449474, -0.03408314, -0.03366881, -0.03325175, -0.03283195, \
-0.03240940, -0.03198411, -0.03155606, -0.03112526, -0.03069168, \
-0.03025534, -0.02981623, -0.02937433, -0.02892965, -0.02848217, \
-0.02803191, -0.02757884, -0.02712296, -0.02666428, -0.02620278, \
-0.02573845, -0.02527131, -0.02480133, -0.02432852, -0.02385287, \
-0.02337437, -0.02289302, -0.02240882, -0.02192176, -0.02143184, \
-0.02093905, -0.02044338, -0.01994484, -0.01944342, -0.01893911, \
-0.01843190, -0.01792181, -0.01740881, -0.01689291, -0.01637410, \
-0.01585238, -0.01532774, -0.01480018, -0.01426969, -0.01373628, \
-0.01319992, -0.01266064, -0.01211840, -0.01157323, -0.01102510, \
-0.01047402, -0.00991998, -0.00936297, -0.00880300, -0.00824006, \
-0.00767415, -0.00710526, -0.00653339, -0.00595853, -0.00538068, \
-0.00479984, -0.00421601, -0.00362917, -0.00303933, -0.00244649, \
-0.00185063, -0.00125176, -0.00064988, -0.00004497, 0.00056296, \
0.00117392, 0.00178791, 0.00240494, 0.00302500, 0.00364810, \
0.00427424, 0.00490343, 0.00553567, 0.00617096, 0.00680931, \
0.00745071, 0.00809518, 0.00874271, 0.00939331, 0.01004698, \
0.01070372, 0.01136353, 0.01202642, 0.01269240, 0.01336145, \
0.01403360, 0.01470883, 0.01538715, 0.01606856, 0.01675307, \
0.01744067, 0.01813138, 0.01882519, 0.01952210, 0.02022212, \
0.02092525, 0.02163149, 0.02234084, 0.02305331, 0.02376889, \
0.02448760, 0.02520942, 0.02593437, 0.02666244, 0.02739364, \
0.02812796, 0.02886542, 0.02960601, 0.03034973, 0.03109658, \
0.03184657, 0.03259970, 0.03335597, 0.03411537, 0.03487792, \
0.03564362, 0.03641245, 0.03718443, 0.03795956, 0.03873784, \
0.03951926, 0.04030384, 0.04109156, 0.04188244, 0.04267647, \
0.04347366, 0.04427400, 0.04507749, 0.04588414, 0.04669395, \
0.04750691, 0.04832303, 0.04914231, 0.04996475, 0.05079035, \
0.05161911, 0.05245103, 0.05328610, 0.05412434, 0.05496574, \
0.05581030, 0.05665803, 0.05750891, 0.05836296, 0.05922016, \
0.06008053, 0.06094406, 0.06181075, 0.06268060, 0.06355361, \
0.06442979, 0.06530912, 0.06619161, 0.06707726, 0.06796607, \
0.06885804, 0.06975316, 0.07065145, 0.07155288, 0.07245748, \
0.07336523, 0.07427613, 0.07519019, 0.07610739, 0.07702775, \
0.07795126, 0.07887792, 0.07980773, 0.08074068, 0.08167678, \
0.08261602, 0.08355841, 0.08450393, 0.08545260, 0.08640441, \
0.08735935, 0.08831743, 0.08927865, 0.09024299, 0.09121047, \
0.09218108, 0.09315481, 0.09413167, 0.09511165, 0.09609475, \
0.09708098, 0.09807032, 0.09906277, 0.10005834, 0.10105702, \
0.10205881, 0.10306370, 0.10407170, 0.10508280, 0.10609700, \
0.10711429, 0.10813468, 0.10915816, 0.11018473, 0.11121438, \
0.11224712, 0.11328294, 0.11432183, 0.11536380, 0.11640884, \
0.11745695, 0.11850813, 0.11956236, 0.12061966, 0.12168001, \
0.12274341, 0.12380986, 0.12487936, 0.12595190, 0.12702748, \
0.12810609, 0.12918774, 0.13027241, 0.13136011, 0.13245082, \
0.13354456, 0.13464130, 0.13574106, 0.13684382, 0.13794957, \
0.13905833, 0.14017008, 0.14128482, 0.14240254, 0.14352324, \
0.14464691, 0.14577356, 0.14690317, 0.14803574, 0.14917127, \
0.15030976, 0.15145119, 0.15259556, 0.15374288, 0.15489312, \
0.15604630, 0.15720240, 0.15836142, 0.15952335, 0.16068819, \
0.16185593, 0.16302658, 0.16420011, 0.16537653, 0.16655584, \
0.16773802, 0.16892307, 0.17011099, 0.17130177, 0.17249540, \
0.17369188, 0.17489121, 0.17609337, 0.17729836, 0.17850618, \
0.17971682, 0.18093027, 0.18214653, 0.18336560, 0.18458745, \
0.18581210, 0.18703953, 0.18826973, 0.18950270, 0.19073844, \
0.19197694, 0.19321818, 0.19446217, 0.19570889, 0.19695835, \
0.19821053, 0.19946543, 0.20072303, 0.20198334, 0.20324635, \
0.20451204, 0.20578042, 0.20705147, 0.20832519, 0.20960157, \
0.21088060, 0.21216228, 0.21344659, 0.21473354, 0.21602311, \
0.21731529, 0.21861008, 0.21990748, 0.22120746, 0.22251004, \
0.22381518, 0.22512290, 0.22643318, 0.22774601, 0.22906139, \
0.23037930, 0.23169974, 0.23302270, 0.23434818, 0.23567616, \
0.23700663, 0.23833959, 0.23967503, 0.24101295, 0.24235332, \
0.24369614, 0.24504141, 0.24638912, 0.24773925, 0.24909180, \
0.25044676, 0.25180412, 0.25316387, 0.25452601, 0.25589051, \
0.25725738, 0.25862661, 0.25999818, 0.26137208, 0.26274832, \
0.26412687, 0.26550772, 0.26689088, 0.26827633, 0.26966405, \
0.27105404, 0.27244630, 0.27384080, 0.27523755, 0.27663652, \
0.27803771, 0.27944112, 0.28084672, 0.28225452, 0.28366450, \
0.28507664, 0.28649095, 0.28790740, 0.28932600, 0.29074672, \
0.29216956, 0.29359451, 0.29502156, 0.29645069, 0.29788190, \
0.29931518, 0.30075051, 0.30218789, 0.30362729, 0.30506872, \
0.30651216, 0.30795761, 0.30940504, 0.31085445, 0.31230583, \
0.31375916, 0.31521444, 0.31667165, 0.31813078, 0.31959183, \
0.32105477, 0.32251961, 0.32398631, 0.32545489, 0.32692532, \
0.32839759, 0.32987169, 0.33134761, 0.33282533, 0.33430485, \
0.33578615, 0.33726923, 0.33875406, 0.34024064, 0.34172895, \
0.34321899, 0.34471074, 0.34620419, 0.34769932, 0.34919613, \
0.35069460, 0.35219472, 0.35369647, 0.35519985, 0.35670484, \
0.35821143, 0.35971961, 0.36122936, 0.36274067, 0.36425354, \
0.36576793, 0.36728385, 0.36880128, 0.37032021, 0.37184062, \
0.37336251, 0.37488585, 0.37641063, 0.37793685, 0.37946449, \
0.38099353, 0.38252397, 0.38405579, 0.38558897, 0.38712350, \
0.38865937, 0.39019657, 0.39173508, 0.39327489, 0.39481598, \
0.39635834, 0.39790197, 0.39944683, 0.40099293, 0.40254024, \
0.40408875, 0.40563846, 0.40718934, 0.40874137, 0.41029456, \
0.41184888, 0.41340432, 0.41496086, 0.41651849, 0.41807720, \
0.41963697, 0.42119779, 0.42275964, 0.42432251, 0.42588639, \
0.42745126, 0.42901710, 0.43058390, 0.43215165, 0.43372034, \
0.43528994, 0.43686044, 0.43843184, 0.44000411, 0.44157723, \
0.44315120, 0.44472600, 0.44630162, 0.44787803, 0.44945523, \
0.45103320, 0.45261193, 0.45419140, 0.45577159, 0.45735249, \
0.45893408, 0.46051636, 0.46209930, 0.46368288, 0.46526711, \
0.46685195, 0.46843739, 0.47002343, 0.47161003, 0.47319720, \
0.47478490, 0.47637314, 0.47796188, 0.47955112, 0.48114084, \
0.48273102, 0.48432165, 0.48591272, 0.48750420, 0.48909608, \
0.49068835, 0.49228099, 0.49387399, 0.49546732, 0.49706098, \
0.49865494, 0.50024919, 0.50184372, 0.50343851, 0.50503354, \
0.50662880, 0.50822427, 0.50981994, 0.51141578, 0.51301179, \
0.51460794, 0.51620423, 0.51780063, 0.51939712, 0.52099370, \
0.52259035, 0.52418704, 0.52578377, 0.52738052, 0.52897726, \
0.53057399, 0.53217069, 0.53376733, 0.53536392, 0.53696042, \
0.53855682, 0.54015311, 0.54174927, 0.54334528, 0.54494112, \
0.54653679, 0.54813225, 0.54972750, 0.55132253, 0.55291730, \
0.55451181, 0.55610604, 0.55769997, 0.55929359, 0.56088687, \
0.56247981, 0.56407239, 0.56566458, 0.56725637, 0.56884775, \
0.57043869, 0.57202919, 0.57361922, 0.57520877, 0.57679782, \
0.57838635, 0.57997435, 0.58156180, 0.58314868, 0.58473497, \
0.58632067, 0.58790574, 0.58949018, 0.59107396, 0.59265708, \
0.59423951, 0.59582123, 0.59740224, 0.59898250, 0.60056201, \
0.60214075, 0.60371870, 0.60529584, 0.60687215, 0.60844763, \
0.61002224, 0.61159598, 0.61316883, 0.61474077, 0.61631177, \
0.61788184, 0.61945094, 0.62101906, 0.62258619, 0.62415230, \
0.62571738, 0.62728142, 0.62884438, 0.63040627, 0.63196705, \
0.63352672, 0.63508525, 0.63664262, 0.63819883, 0.63975385, \
0.64130767, 0.64286027, 0.64441162, 0.64596172, 0.64751055, \
0.64905808, 0.65060431, 0.65214921, 0.65369276, 0.65523496, \
0.65677577, 0.65831520, 0.65985320, 0.66138978, 0.66292491, \
0.66445858, 0.66599076, 0.66752145, 0.66905061, 0.67057824, \
0.67210432, 0.67362883, 0.67515176, 0.67667308, 0.67819278, \
0.67971084, 0.68122724, 0.68274197, 0.68425501, 0.68576634, \
0.68727594, 0.68878380, 0.69028990, 0.69179423, 0.69329676, \
0.69479747, 0.69629636, 0.69779340, 0.69928857, 0.70078187, \
0.70227326, 0.70376274, 0.70525028, 0.70673588, 0.70821950, \
0.70970114, 0.71118078, 0.71265840, 0.71413398, 0.71560751, \
0.71707897, 0.71854833, 0.72001559, 0.72148073, 0.72294373, \
0.72440457, 0.72586324, 0.72731971, 0.72877398, 0.73022602, \
0.73167581, 0.73312335, 0.73456861, 0.73601158, 0.73745223, \
0.73889056, 0.74032654, 0.74176016, 0.74319140, 0.74462024, \
0.74604667, 0.74747067, 0.74889222, 0.75031131, 0.75172792, \
0.75314203, 0.75455363, 0.75596269, 0.75736921, 0.75877316, \
0.76017453, 0.76157330, 0.76296946, 0.76436298, 0.76575386, \
0.76714207, 0.76852759, 0.76991042, 0.77129054, 0.77266792, \
0.77404255, 0.77541442, 0.77678351, 0.77814980, 0.77951327, \
0.78087391, 0.78223171, 0.78358664, 0.78493869, 0.78628785, \
0.78763409, 0.78897740, 0.79031777, 0.79165518, 0.79298960, \
0.79432104, 0.79564946, 0.79697485, 0.79829721, 0.79961650, \
0.80093272, 0.80224585, 0.80355587, 0.80486276, 0.80616652, \
0.80746713, 0.80876456, 0.81005880, 0.81134985, 0.81263767, \
0.81392226, 0.81520360, 0.81648167, 0.81775646, 0.81902796, \
0.82029614, 0.82156100, 0.82282250, 0.82408065, 0.82533543, \
0.82658681, 0.82783479, 0.82907935, 0.83032047, 0.83155814, \
0.83279234, 0.83402305, 0.83525027, 0.83647398, 0.83769416, \
0.83891079, 0.84012387, 0.84133337, 0.84253928, 0.84374159, \
0.84494028, 0.84613534, 0.84732675, 0.84851449, 0.84969856, \
0.85087893, 0.85205560, 0.85322854, 0.85439775, 0.85556321, \
0.85672490, 0.85788280, 0.85903692, 0.86018722, 0.86133370, \
0.86247634, 0.86361513, 0.86475006, 0.86588110, 0.86700824, \
0.86813148, 0.86925079, 0.87036616, 0.87147759, 0.87258504, \
0.87368852, 0.87478800, 0.87588348, 0.87697493, 0.87806235, \
0.87914572, 0.88022503, 0.88130026, 0.88237140, 0.88343844, \
0.88450136, 0.88556016, 0.88661480, 0.88766530, 0.88871162, \
0.88975375, 0.89079169, 0.89182543, 0.89285493, 0.89388021, \
0.89490123, 0.89591799, 0.89693047, 0.89793867, 0.89894257, \
0.89994215, 0.90093741, 0.90192833, 0.90291489, 0.90389710, \
0.90487492, 0.90584836, 0.90681740, 0.90778202, 0.90874221, \
0.90969797, 0.91064928, 0.91159612, 0.91253849, 0.91347637, \
0.91440975, 0.91533862, 0.91626297, 0.91718279, 0.91809805, \
0.91900876, 0.91991490, 0.92081646, 0.92171342, 0.92260578, \
0.92349353, 0.92437664, 0.92525512, 0.92612895, 0.92699812, \
0.92786261, 0.92872242, 0.92957754, 0.93042794, 0.93127364, \
0.93211460, 0.93295083, 0.93378231, 0.93460902, 0.93543097, \
0.93624814, 0.93706051, 0.93786808, 0.93867084, 0.93946878, \
0.94026188, 0.94105014, 0.94183354, 0.94261208, 0.94338575, \
0.94415453, 0.94491842, 0.94567741, 0.94643148, 0.94718063, \
0.94792484, 0.94866411, 0.94939843, 0.95012779, 0.95085218, \
0.95157158, 0.95228600, 0.95299541, 0.95369982, 0.95439921, \
0.95509357, 0.95578290, 0.95646718, 0.95714640, 0.95782057, \
0.95848966, 0.95915367, 0.95981260, 0.96046643, 0.96111515, \
0.96175875, 0.96239724, 0.96303059, 0.96365880, 0.96428187, \
0.96489978, 0.96551253, 0.96612010, 0.96672250, 0.96731971, \
0.96791172, 0.96849853, 0.96908013, 0.96965651, 0.97022767, \
0.97079359, 0.97135427, 0.97190971, 0.97245988, 0.97300480, \
0.97354445, 0.97407882, 0.97460790, 0.97513170, 0.97565020, \
0.97616339, 0.97667128, 0.97717384, 0.97767108, 0.97816299, \
0.97864957, 0.97913080, 0.97960668, 0.98007720, 0.98054237, \
0.98100216, 0.98145658, 0.98190562, 0.98234927, 0.98278753, \
0.98322040, 0.98364786, 0.98406991, 0.98448654, 0.98489776, \
0.98530355, 0.98570391, 0.98609883, 0.98648832, 0.98687235, \
0.98725094, 0.98762407, 0.98799173, 0.98835393, 0.98871066, \
0.98906192, 0.98940769, 0.98974798, 0.99008278, 0.99041209, \
0.99073590, 0.99105420, 0.99136700, 0.99167429, 0.99197607, \
0.99227232, 0.99256305, 0.99284826, 0.99312794, 0.99340208, \
0.99367069, 0.99393375, 0.99419127, 0.99444325, 0.99468967, \
0.99493054, 0.99516585, 0.99539559, 0.99561978, 0.99583840, \
0.99605145, 0.99625893, 0.99646083, 0.99665715, 0.99684790, \
0.99703306, 0.99721263, 0.99738662, 0.99755502, 0.99771783, \
0.99787504, 0.99802665, 0.99817267, 0.99831309, 0.99844790, \
0.99857711, 0.99870072, 0.99881872, 0.99893111, 0.99903789, \
0.99913905, 0.99923461, 0.99932455, 0.99940887, 0.99948758, \
0.99956067, 0.99962814, 0.99968999, 0.99974623, 0.99979684, \
0.99984183, 0.99988119, 0.99991494, 0.99994306, 0.99996555, \
0.99998243, 0.99999368, 0.99999930, } 


 #endif // _FPU_FFT_FLATTOP_H_
//=============================================================================
// End of File
//=============================================================================
