//=============================================================================
// Kaiser Window 
//=============================================================================
#ifndef _FPU_FFT_KAISER_H_
#define _FPU_FFT_KAISER_H_

#define KAISER32 {\
0.94030619, 0.94765902, 0.95454756, 0.96096651, 0.96691093, \
0.97237623, 0.97735819, 0.98185298, 0.98585713, 0.98936756, \
0.99238154, 0.99489675, 0.99691126, 0.99842350, 0.99943232, \
0.99993692, } 

#define KAISER64 {\
0.94030619, 0.94398193, 0.94754592, 0.95099752, 0.95433607, \
0.95756096, 0.96067157, 0.96366734, 0.96654770, 0.96931212, \
0.97196008, 0.97449108, 0.97690465, 0.97920034, 0.98137773, \
0.98343640, 0.98537598, 0.98719609, 0.98889640, 0.99047660, \
0.99193637, 0.99327547, 0.99449362, 0.99559061, 0.99656623, \
0.99742029, 0.99815264, 0.99876315, 0.99925169, 0.99961817, \
0.99986253, 0.99998473, } 

#define KAISER128 {\
0.94030619, 0.94214351, 0.94395342, 0.94573583, 0.94749067, \
0.94921784, 0.95091729, 0.95258891, 0.95423265, 0.95584842, \
0.95743615, 0.95899576, 0.96052719, 0.96203037, 0.96350522, \
0.96495168, 0.96636968, 0.96775916, 0.96912004, 0.97045228, \
0.97175581, 0.97303057, 0.97427649, 0.97549353, 0.97668163, \
0.97784073, 0.97897078, 0.98007173, 0.98114352, 0.98218611, \
0.98319945, 0.98418349, 0.98513819, 0.98606351, 0.98695939, \
0.98782581, 0.98866271, 0.98947007, 0.99024784, 0.99099599, \
0.99171449, 0.99240329, 0.99306238, 0.99369172, 0.99429127, \
0.99486102, 0.99540093, 0.99591099, 0.99639117, 0.99684144, \
0.99726178, 0.99765219, 0.99801263, 0.99834309, 0.99864356, \
0.99891402, 0.99915446, 0.99936487, 0.99954524, 0.99969556, \
0.99981583, 0.99990603, 0.99996617, 0.99999624, } 

#define KAISER256 {\
0.94030619, 0.94122467, 0.94213636, 0.94304125, 0.94393933, \
0.94483059, 0.94571502, 0.94659261, 0.94746335, 0.94832723, \
0.94918424, 0.95003438, 0.95087762, 0.95171396, 0.95254340, \
0.95336591, 0.95418151, 0.95499016, 0.95579187, 0.95658662, \
0.95737441, 0.95815523, 0.95892907, 0.95969591, 0.96045576, \
0.96120860, 0.96195442, 0.96269322, 0.96342498, 0.96414971, \
0.96486738, 0.96557800, 0.96628154, 0.96697802, 0.96766741, \
0.96834972, 0.96902492, 0.96969302, 0.97035401, 0.97100787, \
0.97165461, 0.97229422, 0.97292668, 0.97355199, 0.97417014, \
0.97478113, 0.97538495, 0.97598159, 0.97657105, 0.97715331, \
0.97772838, 0.97829624, 0.97885689, 0.97941032, 0.97995653, \
0.98049551, 0.98102726, 0.98155176, 0.98206901, 0.98257901, \
0.98308175, 0.98357723, 0.98406543, 0.98454635, 0.98502000, \
0.98548635, 0.98594542, 0.98639718, 0.98684164, 0.98727879, \
0.98770863, 0.98813115, 0.98854635, 0.98895422, 0.98935476, \
0.98974796, 0.99013382, 0.99051233, 0.99088349, 0.99124730, \
0.99160374, 0.99195283, 0.99229455, 0.99262890, 0.99295587, \
0.99327547, 0.99358768, 0.99389251, 0.99418995, 0.99447999, \
0.99476264, 0.99503789, 0.99530574, 0.99556619, 0.99581923, \
0.99606485, 0.99630306, 0.99653386, 0.99675724, 0.99697319, \
0.99718172, 0.99738283, 0.99757650, 0.99776275, 0.99794156, \
0.99811294, 0.99827688, 0.99843338, 0.99858244, 0.99872405, \
0.99885823, 0.99898495, 0.99910423, 0.99921607, 0.99932045, \
0.99941738, 0.99950686, 0.99958888, 0.99966346, 0.99973057, \
0.99979024, 0.99984244, 0.99988719, 0.99992448, 0.99995432, \
0.99997669, 0.99999161, 0.99999907, } 

#define KAISER512 {\
0.94030619, 0.94076538, 0.94122288, 0.94167869, 0.94213281, \
0.94258523, 0.94303596, 0.94348499, 0.94393233, 0.94437796, \
0.94482190, 0.94526414, 0.94570468, 0.94614351, 0.94658064, \
0.94701606, 0.94744977, 0.94788178, 0.94831208, 0.94874066, \
0.94916754, 0.94959270, 0.95001615, 0.95043788, 0.95085789, \
0.95127619, 0.95169277, 0.95210763, 0.95252076, 0.95293218, \
0.95334187, 0.95374983, 0.95415607, 0.95456059, 0.95496337, \
0.95536442, 0.95576375, 0.95616134, 0.95655720, 0.95695132, \
0.95734371, 0.95773436, 0.95812328, 0.95851046, 0.95889590, \
0.95927959, 0.95966155, 0.96004176, 0.96042023, 0.96079695, \
0.96117193, 0.96154516, 0.96191664, 0.96228638, 0.96265436, \
0.96302059, 0.96338507, 0.96374780, 0.96410877, 0.96446798, \
0.96482544, 0.96518114, 0.96553509, 0.96588727, 0.96623769, \
0.96658636, 0.96693326, 0.96727839, 0.96762176, 0.96796337, \
0.96830321, 0.96864128, 0.96897759, 0.96931212, 0.96964488, \
0.96997588, 0.97030510, 0.97063255, 0.97095822, 0.97128212, \
0.97160424, 0.97192459, 0.97224316, 0.97255995, 0.97287496, \
0.97318819, 0.97349964, 0.97380931, 0.97411720, 0.97442330, \
0.97472761, 0.97503014, 0.97533089, 0.97562984, 0.97592701, \
0.97622239, 0.97651598, 0.97680778, 0.97709779, 0.97738600, \
0.97767243, 0.97795705, 0.97823989, 0.97852093, 0.97880017, \
0.97907761, 0.97935326, 0.97962711, 0.97989915, 0.98016940, \
0.98043785, 0.98070450, 0.98096934, 0.98123238, 0.98149361, \
0.98175304, 0.98201067, 0.98226649, 0.98252050, 0.98277270, \
0.98302310, 0.98327168, 0.98351846, 0.98376343, 0.98400658, \
0.98424793, 0.98448746, 0.98472517, 0.98496108, 0.98519516, \
0.98542744, 0.98565789, 0.98588653, 0.98611336, 0.98633836, \
0.98656155, 0.98678292, 0.98700247, 0.98722019, 0.98743610, \
0.98765018, 0.98786245, 0.98807289, 0.98828150, 0.98848829, \
0.98869326, 0.98889640, 0.98909772, 0.98929721, 0.98949487, \
0.98969071, 0.98988471, 0.99007689, 0.99026724, 0.99045576, \
0.99064245, 0.99082731, 0.99101034, 0.99119153, 0.99137090, \
0.99154843, 0.99172412, 0.99189799, 0.99207002, 0.99224021, \
0.99240857, 0.99257509, 0.99273978, 0.99290263, 0.99306364, \
0.99322282, 0.99338015, 0.99353565, 0.99368931, 0.99384113, \
0.99399111, 0.99413925, 0.99428555, 0.99443001, 0.99457262, \
0.99471340, 0.99485233, 0.99498942, 0.99512467, 0.99525807, \
0.99538963, 0.99551934, 0.99564721, 0.99577324, 0.99589742, \
0.99601975, 0.99614024, 0.99625888, 0.99637567, 0.99649062, \
0.99660372, 0.99671497, 0.99682438, 0.99693193, 0.99703764, \
0.99714150, 0.99724351, 0.99734367, 0.99744198, 0.99753844, \
0.99763305, 0.99772581, 0.99781671, 0.99790577, 0.99799298, \
0.99807833, 0.99816183, 0.99824348, 0.99832328, 0.99840122, \
0.99847731, 0.99855155, 0.99862394, 0.99869447, 0.99876315, \
0.99882997, 0.99889494, 0.99895806, 0.99901932, 0.99907873, \
0.99913628, 0.99919198, 0.99924582, 0.99929781, 0.99934794, \
0.99939621, 0.99944264, 0.99948720, 0.99952991, 0.99957076, \
0.99960976, 0.99964690, 0.99968218, 0.99971561, 0.99974718, \
0.99977690, 0.99980475, 0.99983075, 0.99985490, 0.99987719, \
0.99989761, 0.99991619, 0.99993290, 0.99994776, 0.99996076, \
0.99997191, 0.99998119, 0.99998862, 0.99999420, 0.99999791, \
0.99999977, } 

#define KAISER1024 {\
0.94030619, 0.94053577, 0.94076493, 0.94099367, 0.94122199, \
0.94144988, 0.94167735, 0.94190440, 0.94213103, 0.94235724, \
0.94258302, 0.94280838, 0.94303332, 0.94325783, 0.94348192, \
0.94370559, 0.94392883, 0.94415165, 0.94437405, 0.94459602, \
0.94481757, 0.94503869, 0.94525939, 0.94547967, 0.94569952, \
0.94591894, 0.94613794, 0.94635652, 0.94657467, 0.94679239, \
0.94700969, 0.94722656, 0.94744300, 0.94765902, 0.94787461, \
0.94808978, 0.94830452, 0.94851883, 0.94873272, 0.94894618, \
0.94915921, 0.94937181, 0.94958399, 0.94979574, 0.95000706, \
0.95021795, 0.95042842, 0.95063845, 0.95084806, 0.95105724, \
0.95126599, 0.95147431, 0.95168220, 0.95188967, 0.95209670, \
0.95230331, 0.95250948, 0.95271522, 0.95292054, 0.95312542, \
0.95332988, 0.95353390, 0.95373750, 0.95394066, 0.95414339, \
0.95434569, 0.95454756, 0.95474900, 0.95495001, 0.95515059, \
0.95535073, 0.95555044, 0.95574972, 0.95594857, 0.95614699, \
0.95634497, 0.95654252, 0.95673964, 0.95693633, 0.95713258, \
0.95732840, 0.95752379, 0.95771874, 0.95791326, 0.95810735, \
0.95830100, 0.95849422, 0.95868700, 0.95887935, 0.95907127, \
0.95926275, 0.95945380, 0.95964441, 0.95983459, 0.96002433, \
0.96021364, 0.96040251, 0.96059095, 0.96077895, 0.96096651, \
0.96115364, 0.96134034, 0.96152660, 0.96171242, 0.96189780, \
0.96208275, 0.96226726, 0.96245134, 0.96263498, 0.96281818, \
0.96300095, 0.96318327, 0.96336516, 0.96354662, 0.96372763, \
0.96390821, 0.96408835, 0.96426805, 0.96444731, 0.96462614, \
0.96480453, 0.96498247, 0.96515998, 0.96533705, 0.96551369, \
0.96568988, 0.96586563, 0.96604095, 0.96621582, 0.96639026, \
0.96656426, 0.96673781, 0.96691093, 0.96708360, 0.96725584, \
0.96742764, 0.96759899, 0.96776991, 0.96794038, 0.96811042, \
0.96828001, 0.96844916, 0.96861787, 0.96878614, 0.96895397, \
0.96912136, 0.96928831, 0.96945481, 0.96962087, 0.96978649, \
0.96995167, 0.97011641, 0.97028070, 0.97044455, 0.97060796, \
0.97077093, 0.97093345, 0.97109553, 0.97125717, 0.97141837, \
0.97157912, 0.97173943, 0.97189929, 0.97205871, 0.97221769, \
0.97237623, 0.97253432, 0.97269196, 0.97284916, 0.97300592, \
0.97316224, 0.97331810, 0.97347353, 0.97362851, 0.97378305, \
0.97393714, 0.97409078, 0.97424398, 0.97439674, 0.97454905, \
0.97470091, 0.97485233, 0.97500330, 0.97515383, 0.97530391, \
0.97545355, 0.97560274, 0.97575148, 0.97589978, 0.97604763, \
0.97619504, 0.97634200, 0.97648851, 0.97663457, 0.97678019, \
0.97692536, 0.97707008, 0.97721436, 0.97735819, 0.97750157, \
0.97764451, 0.97778699, 0.97792903, 0.97807062, 0.97821177, \
0.97835246, 0.97849271, 0.97863251, 0.97877186, 0.97891076, \
0.97904922, 0.97918722, 0.97932478, 0.97946189, 0.97959855, \
0.97973476, 0.97987052, 0.98000583, 0.98014069, 0.98027511, \
0.98040907, 0.98054259, 0.98067565, 0.98080827, 0.98094043, \
0.98107215, 0.98120341, 0.98133423, 0.98146459, 0.98159451, \
0.98172397, 0.98185298, 0.98198155, 0.98210966, 0.98223732, \
0.98236453, 0.98249129, 0.98261760, 0.98274346, 0.98286886, \
0.98299382, 0.98311832, 0.98324238, 0.98336598, 0.98348913, \
0.98361182, 0.98373407, 0.98385586, 0.98397721, 0.98409810, \
0.98421853, 0.98433852, 0.98445805, 0.98457713, 0.98469576, \
0.98481394, 0.98493166, 0.98504893, 0.98516575, 0.98528211, \
0.98539802, 0.98551348, 0.98562848, 0.98574304, 0.98585713, \
0.98597078, 0.98608397, 0.98619671, 0.98630899, 0.98642082, \
0.98653220, 0.98664312, 0.98675359, 0.98686361, 0.98697317, \
0.98708228, 0.98719093, 0.98729913, 0.98740687, 0.98751416, \
0.98762099, 0.98772737, 0.98783330, 0.98793877, 0.98804378, \
0.98814834, 0.98825245, 0.98835610, 0.98845930, 0.98856204, \
0.98866432, 0.98876615, 0.98886752, 0.98896844, 0.98906890, \
0.98916891, 0.98926846, 0.98936756, 0.98946620, 0.98956438, \
0.98966211, 0.98975938, 0.98985619, 0.98995255, 0.99004845, \
0.99014390, 0.99023889, 0.99033342, 0.99042750, 0.99052112, \
0.99061428, 0.99070699, 0.99079924, 0.99089103, 0.99098237, \
0.99107325, 0.99116367, 0.99125363, 0.99134314, 0.99143219, \
0.99152078, 0.99160892, 0.99169659, 0.99178381, 0.99187058, \
0.99195688, 0.99204273, 0.99212812, 0.99221305, 0.99229752, \
0.99238154, 0.99246510, 0.99254819, 0.99263084, 0.99271302, \
0.99279474, 0.99287601, 0.99295682, 0.99303717, 0.99311706, \
0.99319649, 0.99327547, 0.99335398, 0.99343204, 0.99350964, \
0.99358677, 0.99366345, 0.99373968, 0.99381544, 0.99389074, \
0.99396558, 0.99403997, 0.99411389, 0.99418736, 0.99426037, \
0.99433292, 0.99440500, 0.99447663, 0.99454780, 0.99461851, \
0.99468876, 0.99475855, 0.99482788, 0.99489675, 0.99496516, \
0.99503312, 0.99510061, 0.99516764, 0.99523421, 0.99530032, \
0.99536597, 0.99543116, 0.99549589, 0.99556016, 0.99562397, \
0.99568732, 0.99575021, 0.99581264, 0.99587461, 0.99593612, \
0.99599717, 0.99605776, 0.99611788, 0.99617755, 0.99623675, \
0.99629550, 0.99635378, 0.99641160, 0.99646896, 0.99652586, \
0.99658230, 0.99663828, 0.99669380, 0.99674886, 0.99680345, \
0.99685759, 0.99691126, 0.99696447, 0.99701722, 0.99706951, \
0.99712134, 0.99717271, 0.99722361, 0.99727406, 0.99732404, \
0.99737356, 0.99742262, 0.99747121, 0.99751935, 0.99756702, \
0.99761424, 0.99766099, 0.99770728, 0.99775310, 0.99779847, \
0.99784337, 0.99788781, 0.99793179, 0.99797531, 0.99801837, \
0.99806096, 0.99810309, 0.99814476, 0.99818597, 0.99822671, \
0.99826699, 0.99830682, 0.99834617, 0.99838507, 0.99842350, \
0.99846148, 0.99849898, 0.99853603, 0.99857262, 0.99860874, \
0.99864440, 0.99867959, 0.99871433, 0.99874860, 0.99878241, \
0.99881576, 0.99884864, 0.99888106, 0.99891302, 0.99894452, \
0.99897555, 0.99900612, 0.99903623, 0.99906588, 0.99909506, \
0.99912378, 0.99915204, 0.99917983, 0.99920716, 0.99923403, \
0.99926044, 0.99928638, 0.99931186, 0.99933688, 0.99936143, \
0.99938552, 0.99940915, 0.99943232, 0.99945502, 0.99947726, \
0.99949903, 0.99952034, 0.99954119, 0.99956158, 0.99958150, \
0.99960096, 0.99961996, 0.99963850, 0.99965657, 0.99967417, \
0.99969132, 0.99970800, 0.99972422, 0.99973997, 0.99975526, \
0.99977009, 0.99978446, 0.99979836, 0.99981180, 0.99982477, \
0.99983728, 0.99984933, 0.99986092, 0.99987204, 0.99988270, \
0.99989289, 0.99990262, 0.99991189, 0.99992070, 0.99992904, \
0.99993692, 0.99994433, 0.99995128, 0.99995777, 0.99996379, \
0.99996936, 0.99997445, 0.99997909, 0.99998326, 0.99998697, \
0.99999021, 0.99999299, 0.99999531, 0.99999716, 0.99999855, \
0.99999948, 0.99999994, } 

#define KAISER2048 {\
0.94030619, 0.94042098, 0.94053566, 0.94065024, 0.94076471, \
0.94087908, 0.94099334, 0.94110749, 0.94122154, 0.94133549, \
0.94144933, 0.94156306, 0.94167669, 0.94179021, 0.94190363, \
0.94201694, 0.94213015, 0.94224325, 0.94235624, 0.94246913, \
0.94258192, 0.94269460, 0.94280717, 0.94291964, 0.94303200, \
0.94314426, 0.94325641, 0.94336845, 0.94348039, 0.94359223, \
0.94370395, 0.94381558, 0.94392709, 0.94403850, 0.94414981, \
0.94426100, 0.94437210, 0.94448308, 0.94459396, 0.94470474, \
0.94481541, 0.94492597, 0.94503643, 0.94514678, 0.94525702, \
0.94536716, 0.94547720, 0.94558712, 0.94569694, 0.94580666, \
0.94591627, 0.94602577, 0.94613516, 0.94624445, 0.94635364, \
0.94646271, 0.94657168, 0.94668055, 0.94678931, 0.94689796, \
0.94700650, 0.94711494, 0.94722328, 0.94733150, 0.94743962, \
0.94754764, 0.94765554, 0.94776334, 0.94787104, 0.94797862, \
0.94808611, 0.94819348, 0.94830075, 0.94840791, 0.94851496, \
0.94862191, 0.94872875, 0.94883549, 0.94894211, 0.94904864, \
0.94915505, 0.94926136, 0.94936756, 0.94947365, 0.94957964, \
0.94968552, 0.94979129, 0.94989696, 0.95000252, 0.95010797, \
0.95021332, 0.95031856, 0.95042369, 0.95052872, 0.95063363, \
0.95073845, 0.95084315, 0.95094775, 0.95105224, 0.95115662, \
0.95126090, 0.95136506, 0.95146913, 0.95157308, 0.95167693, \
0.95178067, 0.95188430, 0.95198783, 0.95209124, 0.95219456, \
0.95229776, 0.95240086, 0.95250385, 0.95260673, 0.95270950, \
0.95281217, 0.95291473, 0.95301718, 0.95311953, 0.95322176, \
0.95332389, 0.95342591, 0.95352783, 0.95362964, 0.95373134, \
0.95383293, 0.95393441, 0.95403579, 0.95413706, 0.95423822, \
0.95433928, 0.95444022, 0.95454106, 0.95464179, 0.95474242, \
0.95484293, 0.95494334, 0.95504364, 0.95514383, 0.95524392, \
0.95534389, 0.95544376, 0.95554352, 0.95564318, 0.95574272, \
0.95584216, 0.95594149, 0.95604071, 0.95613982, 0.95623883, \
0.95633773, 0.95643652, 0.95653520, 0.95663377, 0.95673224, \
0.95683059, 0.95692884, 0.95702698, 0.95712502, 0.95722294, \
0.95732076, 0.95741846, 0.95751606, 0.95761356, 0.95771094, \
0.95780822, 0.95790538, 0.95800244, 0.95809939, 0.95819623, \
0.95829297, 0.95838959, 0.95848611, 0.95858252, 0.95867882, \
0.95877501, 0.95887109, 0.95896707, 0.95906293, 0.95915869, \
0.95925434, 0.95934988, 0.95944531, 0.95954064, 0.95963585, \
0.95973096, 0.95982596, 0.95992085, 0.96001563, 0.96011030, \
0.96020486, 0.96029932, 0.96039366, 0.96048790, 0.96058203, \
0.96067605, 0.96076996, 0.96086376, 0.96095745, 0.96105104, \
0.96114451, 0.96123788, 0.96133114, 0.96142429, 0.96151733, \
0.96161026, 0.96170308, 0.96179579, 0.96188839, 0.96198089, \
0.96207328, 0.96216555, 0.96225772, 0.96234978, 0.96244173, \
0.96253357, 0.96262530, 0.96271692, 0.96280844, 0.96289984, \
0.96299114, 0.96308232, 0.96317340, 0.96326436, 0.96335522, \
0.96344597, 0.96353661, 0.96362714, 0.96371756, 0.96380787, \
0.96389808, 0.96398817, 0.96407815, 0.96416803, 0.96425779, \
0.96434745, 0.96443699, 0.96452643, 0.96461575, 0.96470497, \
0.96479408, 0.96488308, 0.96497197, 0.96506075, 0.96514942, \
0.96523798, 0.96532643, 0.96541477, 0.96550300, 0.96559112, \
0.96567913, 0.96576704, 0.96585483, 0.96594251, 0.96603008, \
0.96611755, 0.96620490, 0.96629215, 0.96637928, 0.96646630, \
0.96655322, 0.96664002, 0.96672672, 0.96681330, 0.96689978, \
0.96698614, 0.96707240, 0.96715854, 0.96724458, 0.96733051, \
0.96741632, 0.96750203, 0.96758762, 0.96767311, 0.96775848, \
0.96784375, 0.96792891, 0.96801395, 0.96809889, 0.96818371, \
0.96826843, 0.96835303, 0.96843753, 0.96852191, 0.96860619, \
0.96869035, 0.96877440, 0.96885835, 0.96894218, 0.96902591, \
0.96910952, 0.96919302, 0.96927641, 0.96935970, 0.96944287, \
0.96952593, 0.96960888, 0.96969172, 0.96977445, 0.96985707, \
0.96993958, 0.97002198, 0.97010427, 0.97018645, 0.97026852, \
0.97035047, 0.97043232, 0.97051406, 0.97059568, 0.97067720, \
0.97075860, 0.97083990, 0.97092108, 0.97100216, 0.97108312, \
0.97116397, 0.97124471, 0.97132534, 0.97140586, 0.97148627, \
0.97156657, 0.97164676, 0.97172683, 0.97180680, 0.97188666, \
0.97196640, 0.97204603, 0.97212556, 0.97220497, 0.97228427, \
0.97236346, 0.97244254, 0.97252151, 0.97260037, 0.97267912, \
0.97275775, 0.97283628, 0.97291469, 0.97299300, 0.97307119, \
0.97314927, 0.97322724, 0.97330510, 0.97338285, 0.97346049, \
0.97353801, 0.97361543, 0.97369273, 0.97376993, 0.97384701, \
0.97392398, 0.97400084, 0.97407759, 0.97415423, 0.97423075, \
0.97430717, 0.97438347, 0.97445966, 0.97453575, 0.97461172, \
0.97468758, 0.97476332, 0.97483896, 0.97491449, 0.97498990, \
0.97506520, 0.97514039, 0.97521547, 0.97529044, 0.97536530, \
0.97544004, 0.97551468, 0.97558920, 0.97566361, 0.97573791, \
0.97581210, 0.97588618, 0.97596015, 0.97603400, 0.97610774, \
0.97618137, 0.97625489, 0.97632830, 0.97640160, 0.97647478, \
0.97654786, 0.97662082, 0.97669367, 0.97676641, 0.97683904, \
0.97691155, 0.97698395, 0.97705625, 0.97712843, 0.97720050, \
0.97727245, 0.97734430, 0.97741603, 0.97748765, 0.97755916, \
0.97763056, 0.97770185, 0.97777302, 0.97784409, 0.97791504, \
0.97798588, 0.97805660, 0.97812722, 0.97819772, 0.97826811, \
0.97833839, 0.97840856, 0.97847862, 0.97854856, 0.97861839, \
0.97868811, 0.97875772, 0.97882722, 0.97889660, 0.97896587, \
0.97903503, 0.97910408, 0.97917302, 0.97924184, 0.97931056, \
0.97937916, 0.97944764, 0.97951602, 0.97958428, 0.97965243, \
0.97972047, 0.97978840, 0.97985621, 0.97992392, 0.97999151, \
0.98005899, 0.98012635, 0.98019361, 0.98026075, 0.98032778, \
0.98039469, 0.98046150, 0.98052819, 0.98059477, 0.98066124, \
0.98072760, 0.98079384, 0.98085997, 0.98092599, 0.98099190, \
0.98105769, 0.98112337, 0.98118894, 0.98125440, 0.98131974, \
0.98138497, 0.98145009, 0.98151510, 0.98157999, 0.98164478, \
0.98170945, 0.98177400, 0.98183845, 0.98190278, 0.98196700, \
0.98203110, 0.98209510, 0.98215898, 0.98222275, 0.98228641, \
0.98234995, 0.98241338, 0.98247670, 0.98253991, 0.98260300, \
0.98266598, 0.98272885, 0.98279160, 0.98285425, 0.98291678, \
0.98297919, 0.98304150, 0.98310369, 0.98316577, 0.98322773, \
0.98328959, 0.98335133, 0.98341296, 0.98347447, 0.98353587, \
0.98359716, 0.98365834, 0.98371940, 0.98378035, 0.98384119, \
0.98390192, 0.98396253, 0.98402303, 0.98408341, 0.98414369, \
0.98420385, 0.98426390, 0.98432383, 0.98438365, 0.98444336, \
0.98450296, 0.98456244, 0.98462181, 0.98468106, 0.98474021, \
0.98479924, 0.98485816, 0.98491696, 0.98497565, 0.98503423, \
0.98509269, 0.98515105, 0.98520929, 0.98526741, 0.98532542, \
0.98538332, 0.98544111, 0.98549878, 0.98555634, 0.98561379, \
0.98567112, 0.98572834, 0.98578545, 0.98584245, 0.98589933, \
0.98595609, 0.98601275, 0.98606929, 0.98612572, 0.98618203, \
0.98623823, 0.98629432, 0.98635029, 0.98640615, 0.98646190, \
0.98651754, 0.98657306, 0.98662847, 0.98668376, 0.98673894, \
0.98679401, 0.98684896, 0.98690380, 0.98695853, 0.98701314, \
0.98706764, 0.98712203, 0.98717630, 0.98723046, 0.98728451, \
0.98733844, 0.98739226, 0.98744597, 0.98749956, 0.98755304, \
0.98760641, 0.98765966, 0.98771280, 0.98776582, 0.98781873, \
0.98787153, 0.98792421, 0.98797678, 0.98802924, 0.98808158, \
0.98813381, 0.98818593, 0.98823793, 0.98828982, 0.98834160, \
0.98839326, 0.98844480, 0.98849624, 0.98854756, 0.98859876, \
0.98864986, 0.98870084, 0.98875170, 0.98880245, 0.98885309, \
0.98890361, 0.98895402, 0.98900432, 0.98905450, 0.98910457, \
0.98915453, 0.98920437, 0.98925409, 0.98930371, 0.98935321, \
0.98940259, 0.98945186, 0.98950102, 0.98955007, 0.98959900, \
0.98964781, 0.98969651, 0.98974510, 0.98979358, 0.98984194, \
0.98989018, 0.98993832, 0.98998634, 0.99003424, 0.99008203, \
0.99012971, 0.99017727, 0.99022472, 0.99027205, 0.99031927, \
0.99036638, 0.99041337, 0.99046025, 0.99050702, 0.99055367, \
0.99060020, 0.99064663, 0.99069293, 0.99073913, 0.99078521, \
0.99083117, 0.99087703, 0.99092276, 0.99096839, 0.99101390, \
0.99105929, 0.99110457, 0.99114974, 0.99119479, 0.99123973, \
0.99128455, 0.99132926, 0.99137386, 0.99141834, 0.99146271, \
0.99150696, 0.99155110, 0.99159513, 0.99163904, 0.99168283, \
0.99172651, 0.99177008, 0.99181354, 0.99185687, 0.99190010, \
0.99194321, 0.99198621, 0.99202909, 0.99207185, 0.99211451, \
0.99215705, 0.99219947, 0.99224178, 0.99228398, 0.99232606, \
0.99236802, 0.99240988, 0.99245162, 0.99249324, 0.99253475, \
0.99257614, 0.99261742, 0.99265859, 0.99269964, 0.99274058, \
0.99278140, 0.99282211, 0.99286270, 0.99290318, 0.99294355, \
0.99298380, 0.99302393, 0.99306395, 0.99310386, 0.99314365, \
0.99318333, 0.99322289, 0.99326234, 0.99330168, 0.99334089, \
0.99338000, 0.99341899, 0.99345787, 0.99349663, 0.99353527, \
0.99357381, 0.99361222, 0.99365053, 0.99368871, 0.99372679, \
0.99376475, 0.99380259, 0.99384032, 0.99387793, 0.99391543, \
0.99395282, 0.99399009, 0.99402725, 0.99406429, 0.99410122, \
0.99413803, 0.99417472, 0.99421131, 0.99424778, 0.99428413, \
0.99432037, 0.99435649, 0.99439250, 0.99442839, 0.99446417, \
0.99449984, 0.99453539, 0.99457082, 0.99460614, 0.99464135, \
0.99467644, 0.99471142, 0.99474628, 0.99478102, 0.99481566, \
0.99485017, 0.99488457, 0.99491886, 0.99495303, 0.99498709, \
0.99502103, 0.99505486, 0.99508857, 0.99512217, 0.99515565, \
0.99518902, 0.99522228, 0.99525541, 0.99528844, 0.99532135, \
0.99535414, 0.99538682, 0.99541938, 0.99545183, 0.99548416, \
0.99551638, 0.99554849, 0.99558048, 0.99561235, 0.99564411, \
0.99567575, 0.99570728, 0.99573870, 0.99577000, 0.99580118, \
0.99583225, 0.99586320, 0.99589404, 0.99592477, 0.99595538, \
0.99598587, 0.99601625, 0.99604651, 0.99607666, 0.99610670, \
0.99613661, 0.99616642, 0.99619611, 0.99622568, 0.99625514, \
0.99628448, 0.99631371, 0.99634282, 0.99637182, 0.99640071, \
0.99642947, 0.99645813, 0.99648666, 0.99651509, 0.99654339, \
0.99657159, 0.99659966, 0.99662763, 0.99665547, 0.99668321, \
0.99671082, 0.99673832, 0.99676571, 0.99679298, 0.99682014, \
0.99684718, 0.99687410, 0.99690091, 0.99692761, 0.99695419, \
0.99698065, 0.99700700, 0.99703324, 0.99705936, 0.99708536, \
0.99711125, 0.99713702, 0.99716268, 0.99718822, 0.99721365, \
0.99723896, 0.99726416, 0.99728924, 0.99731421, 0.99733906, \
0.99736380, 0.99738842, 0.99741292, 0.99743731, 0.99746159, \
0.99748575, 0.99750979, 0.99753372, 0.99755754, 0.99758123, \
0.99760482, 0.99762828, 0.99765164, 0.99767487, 0.99769800, \
0.99772100, 0.99774389, 0.99776667, 0.99778933, 0.99781188, \
0.99783431, 0.99785662, 0.99787882, 0.99790090, 0.99792287, \
0.99794472, 0.99796646, 0.99798808, 0.99800959, 0.99803098, \
0.99805226, 0.99807342, 0.99809446, 0.99811539, 0.99813621, \
0.99815691, 0.99817749, 0.99819796, 0.99821831, 0.99823855, \
0.99825867, 0.99827868, 0.99829857, 0.99831834, 0.99833800, \
0.99835755, 0.99837698, 0.99839629, 0.99841549, 0.99843457, \
0.99845354, 0.99847239, 0.99849113, 0.99850975, 0.99852825, \
0.99854664, 0.99856492, 0.99858307, 0.99860112, 0.99861905, \
0.99863686, 0.99865456, 0.99867214, 0.99868960, 0.99870695, \
0.99872419, 0.99874131, 0.99875831, 0.99877520, 0.99879197, \
0.99880863, 0.99882517, 0.99884160, 0.99885791, 0.99887410, \
0.99889018, 0.99890615, 0.99892199, 0.99893773, 0.99895334, \
0.99896885, 0.99898423, 0.99899950, 0.99901466, 0.99902970, \
0.99904462, 0.99905943, 0.99907412, 0.99908870, 0.99910316, \
0.99911751, 0.99913174, 0.99914585, 0.99915985, 0.99917373, \
0.99918750, 0.99920115, 0.99921469, 0.99922811, 0.99924142, \
0.99925461, 0.99926768, 0.99928064, 0.99929348, 0.99930621, \
0.99931882, 0.99933132, 0.99934370, 0.99935597, 0.99936812, \
0.99938015, 0.99939207, 0.99940387, 0.99941556, 0.99942713, \
0.99943858, 0.99944992, 0.99946115, 0.99947226, 0.99948325, \
0.99949413, 0.99950489, 0.99951553, 0.99952606, 0.99953648, \
0.99954678, 0.99955696, 0.99956703, 0.99957698, 0.99958682, \
0.99959654, 0.99960614, 0.99961563, 0.99962500, 0.99963426, \
0.99964341, 0.99965243, 0.99966134, 0.99967014, 0.99967882, \
0.99968738, 0.99969583, 0.99970416, 0.99971238, 0.99972048, \
0.99972846, 0.99973633, 0.99974409, 0.99975173, 0.99975925, \
0.99976666, 0.99977395, 0.99978112, 0.99978818, 0.99979513, \
0.99980195, 0.99980867, 0.99981526, 0.99982175, 0.99982811, \
0.99983436, 0.99984049, 0.99984651, 0.99985242, 0.99985820, \
0.99986387, 0.99986943, 0.99987487, 0.99988019, 0.99988540, \
0.99989049, 0.99989547, 0.99990033, 0.99990508, 0.99990971, \
0.99991422, 0.99991862, 0.99992290, 0.99992707, 0.99993112, \
0.99993505, 0.99993887, 0.99994258, 0.99994616, 0.99994964, \
0.99995299, 0.99995623, 0.99995936, 0.99996237, 0.99996526, \
0.99996804, 0.99997070, 0.99997325, 0.99997568, 0.99997799, \
0.99998019, 0.99998228, 0.99998424, 0.99998610, 0.99998783, \
0.99998945, 0.99999096, 0.99999235, 0.99999362, 0.99999478, \
0.99999582, 0.99999674, 0.99999755, 0.99999825, 0.99999883, \
0.99999929, 0.99999964, 0.99999987, 0.99999999, } 

#define KAISER4096 {\
0.94030619, 0.94036359, 0.94042095, 0.94047829, 0.94053561, \
0.94059289, 0.94065015, 0.94070739, 0.94076460, 0.94082178, \
0.94087894, 0.94093607, 0.94099317, 0.94105025, 0.94110730, \
0.94116432, 0.94122132, 0.94127829, 0.94133524, 0.94139216, \
0.94144905, 0.94150591, 0.94156275, 0.94161957, 0.94167636, \
0.94173312, 0.94178985, 0.94184656, 0.94190324, 0.94195990, \
0.94201653, 0.94207313, 0.94212971, 0.94218626, 0.94224278, \
0.94229928, 0.94235575, 0.94241219, 0.94246861, 0.94252500, \
0.94258137, 0.94263771, 0.94269402, 0.94275031, 0.94280657, \
0.94286280, 0.94291901, 0.94297519, 0.94303134, 0.94308747, \
0.94314357, 0.94319965, 0.94325570, 0.94331172, 0.94336771, \
0.94342368, 0.94347963, 0.94353554, 0.94359143, 0.94364730, \
0.94370314, 0.94375895, 0.94381473, 0.94387049, 0.94392622, \
0.94398193, 0.94403760, 0.94409326, 0.94414888, 0.94420448, \
0.94426005, 0.94431560, 0.94437112, 0.94442661, 0.94448208, \
0.94453752, 0.94459294, 0.94464832, 0.94470369, 0.94475902, \
0.94481433, 0.94486961, 0.94492487, 0.94498009, 0.94503530, \
0.94509047, 0.94514562, 0.94520074, 0.94525584, 0.94531091, \
0.94536595, 0.94542097, 0.94547596, 0.94553092, 0.94558586, \
0.94564077, 0.94569566, 0.94575051, 0.94580535, 0.94586015, \
0.94591493, 0.94596968, 0.94602440, 0.94607910, 0.94613377, \
0.94618842, 0.94624304, 0.94629763, 0.94635220, 0.94640674, \
0.94646125, 0.94651574, 0.94657019, 0.94662463, 0.94667903, \
0.94673341, 0.94678777, 0.94684209, 0.94689639, 0.94695067, \
0.94700491, 0.94705913, 0.94711333, 0.94716750, 0.94722164, \
0.94727575, 0.94732984, 0.94738390, 0.94743793, 0.94749194, \
0.94754592, 0.94759988, 0.94765380, 0.94770771, 0.94776158, \
0.94781543, 0.94786925, 0.94792304, 0.94797681, 0.94803055, \
0.94808427, 0.94813796, 0.94819162, 0.94824525, 0.94829886, \
0.94835244, 0.94840600, 0.94845953, 0.94851303, 0.94856650, \
0.94861995, 0.94867338, 0.94872677, 0.94878014, 0.94883348, \
0.94888680, 0.94894008, 0.94899335, 0.94904658, 0.94909979, \
0.94915297, 0.94920613, 0.94925926, 0.94931236, 0.94936543, \
0.94941848, 0.94947150, 0.94952450, 0.94957747, 0.94963041, \
0.94968332, 0.94973621, 0.94978907, 0.94984191, 0.94989472, \
0.94994750, 0.95000025, 0.95005298, 0.95010568, 0.95015836, \
0.95021101, 0.95026363, 0.95031622, 0.95036879, 0.95042133, \
0.95047385, 0.95052633, 0.95057879, 0.95063123, 0.95068364, \
0.95073602, 0.95078837, 0.95084070, 0.95089300, 0.95094527, \
0.95099752, 0.95104974, 0.95110193, 0.95115410, 0.95120624, \
0.95125835, 0.95131044, 0.95136250, 0.95141453, 0.95146654, \
0.95151851, 0.95157047, 0.95162239, 0.95167429, 0.95172616, \
0.95177801, 0.95182983, 0.95188162, 0.95193338, 0.95198512, \
0.95203683, 0.95208852, 0.95214018, 0.95219181, 0.95224341, \
0.95229499, 0.95234654, 0.95239806, 0.95244956, 0.95250103, \
0.95255247, 0.95260389, 0.95265528, 0.95270664, 0.95275798, \
0.95280929, 0.95286057, 0.95291182, 0.95296305, 0.95301425, \
0.95306543, 0.95311658, 0.95316770, 0.95321879, 0.95326986, \
0.95332090, 0.95337191, 0.95342290, 0.95347386, 0.95352479, \
0.95357570, 0.95362658, 0.95367743, 0.95372826, 0.95377906, \
0.95382983, 0.95388057, 0.95393129, 0.95398198, 0.95403265, \
0.95408329, 0.95413390, 0.95418448, 0.95423504, 0.95428557, \
0.95433607, 0.95438655, 0.95443700, 0.95448742, 0.95453781, \
0.95458818, 0.95463852, 0.95468884, 0.95473913, 0.95478939, \
0.95483962, 0.95488983, 0.95494001, 0.95499016, 0.95504029, \
0.95509039, 0.95514046, 0.95519050, 0.95524052, 0.95529051, \
0.95534048, 0.95539041, 0.95544033, 0.95549021, 0.95554007, \
0.95558990, 0.95563970, 0.95568947, 0.95573922, 0.95578894, \
0.95583864, 0.95588831, 0.95593795, 0.95598756, 0.95603715, \
0.95608671, 0.95613624, 0.95618575, 0.95623523, 0.95628468, \
0.95633411, 0.95638350, 0.95643287, 0.95648222, 0.95653154, \
0.95658083, 0.95663009, 0.95667933, 0.95672853, 0.95677772, \
0.95682687, 0.95687600, 0.95692510, 0.95697417, 0.95702322, \
0.95707224, 0.95712123, 0.95717020, 0.95721914, 0.95726805, \
0.95731694, 0.95736579, 0.95741462, 0.95746343, 0.95751221, \
0.95756096, 0.95760968, 0.95765837, 0.95770704, 0.95775568, \
0.95780430, 0.95785289, 0.95790145, 0.95794998, 0.95799848, \
0.95804696, 0.95809542, 0.95814384, 0.95819224, 0.95824061, \
0.95828895, 0.95833727, 0.95838556, 0.95843382, 0.95848206, \
0.95853027, 0.95857845, 0.95862660, 0.95867473, 0.95872283, \
0.95877090, 0.95881895, 0.95886697, 0.95891496, 0.95896292, \
0.95901086, 0.95905877, 0.95910665, 0.95915451, 0.95920234, \
0.95925014, 0.95929791, 0.95934566, 0.95939338, 0.95944108, \
0.95948874, 0.95953638, 0.95958399, 0.95963158, 0.95967913, \
0.95972667, 0.95977417, 0.95982164, 0.95986909, 0.95991652, \
0.95996391, 0.96001128, 0.96005862, 0.96010593, 0.96015322, \
0.96020048, 0.96024771, 0.96029491, 0.96034209, 0.96038924, \
0.96043636, 0.96048346, 0.96053053, 0.96057757, 0.96062459, \
0.96067157, 0.96071853, 0.96076547, 0.96081237, 0.96085925, \
0.96090610, 0.96095293, 0.96099972, 0.96104649, 0.96109323, \
0.96113995, 0.96118664, 0.96123330, 0.96127993, 0.96132654, \
0.96137312, 0.96141967, 0.96146620, 0.96151269, 0.96155916, \
0.96160561, 0.96165202, 0.96169841, 0.96174477, 0.96179111, \
0.96183741, 0.96188369, 0.96192995, 0.96197617, 0.96202237, \
0.96206854, 0.96211468, 0.96216080, 0.96220689, 0.96225295, \
0.96229899, 0.96234499, 0.96239097, 0.96243693, 0.96248285, \
0.96252875, 0.96257462, 0.96262047, 0.96266628, 0.96271207, \
0.96275783, 0.96280357, 0.96284927, 0.96289496, 0.96294061, \
0.96298623, 0.96303183, 0.96307740, 0.96312295, 0.96316846, \
0.96321395, 0.96325941, 0.96330485, 0.96335026, 0.96339564, \
0.96344099, 0.96348631, 0.96353161, 0.96357688, 0.96362213, \
0.96366734, 0.96371253, 0.96375769, 0.96380283, 0.96384793, \
0.96389301, 0.96393806, 0.96398309, 0.96402809, 0.96407306, \
0.96411800, 0.96416291, 0.96420780, 0.96425266, 0.96429750, \
0.96434230, 0.96438708, 0.96443183, 0.96447656, 0.96452125, \
0.96456592, 0.96461057, 0.96465518, 0.96469977, 0.96474433, \
0.96478886, 0.96483337, 0.96487784, 0.96492229, 0.96496672, \
0.96501111, 0.96505548, 0.96509982, 0.96514414, 0.96518842, \
0.96523268, 0.96527691, 0.96532112, 0.96536529, 0.96540944, \
0.96545356, 0.96549766, 0.96554173, 0.96558577, 0.96562978, \
0.96567376, 0.96571772, 0.96576165, 0.96580555, 0.96584943, \
0.96589328, 0.96593710, 0.96598089, 0.96602466, 0.96606839, \
0.96611210, 0.96615579, 0.96619944, 0.96624307, 0.96628667, \
0.96633025, 0.96637379, 0.96641731, 0.96646080, 0.96650427, \
0.96654770, 0.96659111, 0.96663449, 0.96667785, 0.96672117, \
0.96676447, 0.96680775, 0.96685099, 0.96689421, 0.96693740, \
0.96698056, 0.96702369, 0.96706680, 0.96710988, 0.96715293, \
0.96719596, 0.96723895, 0.96728192, 0.96732486, 0.96736778, \
0.96741067, 0.96745353, 0.96749636, 0.96753916, 0.96758194, \
0.96762469, 0.96766741, 0.96771011, 0.96775277, 0.96779541, \
0.96783803, 0.96788061, 0.96792317, 0.96796570, 0.96800820, \
0.96805068, 0.96809312, 0.96813554, 0.96817794, 0.96822030, \
0.96826264, 0.96830495, 0.96834723, 0.96838948, 0.96843171, \
0.96847391, 0.96851608, 0.96855823, 0.96860034, 0.96864243, \
0.96868450, 0.96872653, 0.96876854, 0.96881052, 0.96885247, \
0.96889439, 0.96893629, 0.96897816, 0.96902000, 0.96906181, \
0.96910360, 0.96914536, 0.96918709, 0.96922880, 0.96927047, \
0.96931212, 0.96935374, 0.96939533, 0.96943690, 0.96947844, \
0.96951995, 0.96956143, 0.96960289, 0.96964432, 0.96968572, \
0.96972709, 0.96976844, 0.96980975, 0.96985104, 0.96989231, \
0.96993354, 0.96997475, 0.97001593, 0.97005708, 0.97009821, \
0.97013930, 0.97018037, 0.97022141, 0.97026243, 0.97030342, \
0.97034437, 0.97038531, 0.97042621, 0.97046709, 0.97050793, \
0.97054876, 0.97058955, 0.97063031, 0.97067105, 0.97071176, \
0.97075245, 0.97079310, 0.97083373, 0.97087433, 0.97091490, \
0.97095545, 0.97099596, 0.97103645, 0.97107691, 0.97111735, \
0.97115775, 0.97119813, 0.97123848, 0.97127881, 0.97131910, \
0.97135937, 0.97139961, 0.97143983, 0.97148001, 0.97152017, \
0.97156030, 0.97160040, 0.97164048, 0.97168052, 0.97172054, \
0.97176053, 0.97180050, 0.97184043, 0.97188034, 0.97192022, \
0.97196008, 0.97199990, 0.97203970, 0.97207947, 0.97211921, \
0.97215893, 0.97219861, 0.97223827, 0.97227790, 0.97231751, \
0.97235709, 0.97239663, 0.97243615, 0.97247565, 0.97251511, \
0.97255455, 0.97259396, 0.97263334, 0.97267270, 0.97271203, \
0.97275132, 0.97279060, 0.97282984, 0.97286906, 0.97290824, \
0.97294740, 0.97298654, 0.97302564, 0.97306472, 0.97310377, \
0.97314279, 0.97318179, 0.97322075, 0.97325969, 0.97329860, \
0.97333749, 0.97337634, 0.97341517, 0.97345397, 0.97349274, \
0.97353149, 0.97357020, 0.97360889, 0.97364755, 0.97368619, \
0.97372479, 0.97376337, 0.97380192, 0.97384044, 0.97387894, \
0.97391741, 0.97395584, 0.97399426, 0.97403264, 0.97407100, \
0.97410932, 0.97414762, 0.97418590, 0.97422414, 0.97426236, \
0.97430055, 0.97433871, 0.97437684, 0.97441495, 0.97445303, \
0.97449108, 0.97452910, 0.97456709, 0.97460506, 0.97464300, \
0.97468091, 0.97471879, 0.97475665, 0.97479448, 0.97483228, \
0.97487005, 0.97490779, 0.97494551, 0.97498320, 0.97502086, \
0.97505849, 0.97509610, 0.97513368, 0.97517123, 0.97520875, \
0.97524624, 0.97528371, 0.97532115, 0.97535856, 0.97539594, \
0.97543330, 0.97547062, 0.97550792, 0.97554519, 0.97558244, \
0.97561965, 0.97565684, 0.97569400, 0.97573113, 0.97576824, \
0.97580531, 0.97584236, 0.97587938, 0.97591638, 0.97595334, \
0.97599028, 0.97602719, 0.97606407, 0.97610092, 0.97613775, \
0.97617455, 0.97621132, 0.97624806, 0.97628477, 0.97632146, \
0.97635812, 0.97639475, 0.97643135, 0.97646793, 0.97650447, \
0.97654099, 0.97657748, 0.97661395, 0.97665038, 0.97668679, \
0.97672317, 0.97675952, 0.97679585, 0.97683214, 0.97686841, \
0.97690465, 0.97694086, 0.97697705, 0.97701320, 0.97704933, \
0.97708543, 0.97712150, 0.97715755, 0.97719357, 0.97722956, \
0.97726552, 0.97730145, 0.97733736, 0.97737323, 0.97740908, \
0.97744490, 0.97748070, 0.97751646, 0.97755220, 0.97758791, \
0.97762359, 0.97765925, 0.97769487, 0.97773047, 0.97776604, \
0.97780158, 0.97783710, 0.97787258, 0.97790804, 0.97794347, \
0.97797887, 0.97801425, 0.97804960, 0.97808491, 0.97812021, \
0.97815547, 0.97819070, 0.97822591, 0.97826109, 0.97829624, \
0.97833136, 0.97836646, 0.97840152, 0.97843656, 0.97847157, \
0.97850656, 0.97854151, 0.97857644, 0.97861134, 0.97864621, \
0.97868105, 0.97871587, 0.97875066, 0.97878542, 0.97882015, \
0.97885485, 0.97888953, 0.97892417, 0.97895879, 0.97899338, \
0.97902795, 0.97906248, 0.97909699, 0.97913147, 0.97916592, \
0.97920034, 0.97923474, 0.97926911, 0.97930345, 0.97933776, \
0.97937204, 0.97940630, 0.97944052, 0.97947472, 0.97950889, \
0.97954304, 0.97957715, 0.97961124, 0.97964530, 0.97967933, \
0.97971333, 0.97974731, 0.97978126, 0.97981517, 0.97984907, \
0.97988293, 0.97991676, 0.97995057, 0.97998435, 0.98001810, \
0.98005182, 0.98008552, 0.98011919, 0.98015282, 0.98018643, \
0.98022002, 0.98025357, 0.98028710, 0.98032060, 0.98035407, \
0.98038751, 0.98042092, 0.98045431, 0.98048767, 0.98052100, \
0.98055430, 0.98058758, 0.98062082, 0.98065404, 0.98068723, \
0.98072039, 0.98075352, 0.98078663, 0.98081971, 0.98085276, \
0.98088578, 0.98091877, 0.98095174, 0.98098467, 0.98101758, \
0.98105047, 0.98108332, 0.98111614, 0.98114894, 0.98118171, \
0.98121445, 0.98124716, 0.98127985, 0.98131250, 0.98134513, \
0.98137773, 0.98141030, 0.98144285, 0.98147536, 0.98150785, \
0.98154031, 0.98157274, 0.98160514, 0.98163752, 0.98166987, \
0.98170219, 0.98173448, 0.98176674, 0.98179898, 0.98183118, \
0.98186336, 0.98189551, 0.98192763, 0.98195973, 0.98199179, \
0.98202383, 0.98205584, 0.98208782, 0.98211978, 0.98215170, \
0.98218360, 0.98221547, 0.98224731, 0.98227912, 0.98231091, \
0.98234266, 0.98237439, 0.98240609, 0.98243776, 0.98246941, \
0.98250102, 0.98253261, 0.98256417, 0.98259570, 0.98262721, \
0.98265868, 0.98269013, 0.98272155, 0.98275294, 0.98278430, \
0.98281563, 0.98284694, 0.98287822, 0.98290947, 0.98294069, \
0.98297188, 0.98300305, 0.98303418, 0.98306529, 0.98309637, \
0.98312743, 0.98315845, 0.98318945, 0.98322042, 0.98325136, \
0.98328227, 0.98331315, 0.98334401, 0.98337483, 0.98340563, \
0.98343640, 0.98346715, 0.98349786, 0.98352855, 0.98355920, \
0.98358983, 0.98362044, 0.98365101, 0.98368156, 0.98371207, \
0.98374256, 0.98377302, 0.98380345, 0.98383386, 0.98386423, \
0.98389458, 0.98392490, 0.98395519, 0.98398546, 0.98401569, \
0.98404590, 0.98407608, 0.98410623, 0.98413635, 0.98416644, \
0.98419651, 0.98422655, 0.98425656, 0.98428654, 0.98431649, \
0.98434641, 0.98437631, 0.98440618, 0.98443602, 0.98446583, \
0.98449561, 0.98452537, 0.98455509, 0.98458479, 0.98461446, \
0.98464411, 0.98467372, 0.98470331, 0.98473286, 0.98476239, \
0.98479189, 0.98482137, 0.98485081, 0.98488023, 0.98490961, \
0.98493897, 0.98496831, 0.98499761, 0.98502688, 0.98505613, \
0.98508535, 0.98511454, 0.98514370, 0.98517283, 0.98520194, \
0.98523102, 0.98526007, 0.98528909, 0.98531808, 0.98534704, \
0.98537598, 0.98540489, 0.98543376, 0.98546262, 0.98549144, \
0.98552023, 0.98554900, 0.98557774, 0.98560645, 0.98563513, \
0.98566378, 0.98569240, 0.98572100, 0.98574957, 0.98577811, \
0.98580662, 0.98583510, 0.98586356, 0.98589198, 0.98592038, \
0.98594875, 0.98597709, 0.98600541, 0.98603369, 0.98606195, \
0.98609018, 0.98611838, 0.98614655, 0.98617469, 0.98620281, \
0.98623090, 0.98625895, 0.98628698, 0.98631499, 0.98634296, \
0.98637091, 0.98639882, 0.98642671, 0.98645457, 0.98648240, \
0.98651021, 0.98653798, 0.98656573, 0.98659345, 0.98662114, \
0.98664880, 0.98667643, 0.98670404, 0.98673162, 0.98675917, \
0.98678669, 0.98681418, 0.98684164, 0.98686908, 0.98689648, \
0.98692386, 0.98695121, 0.98697854, 0.98700583, 0.98703309, \
0.98706033, 0.98708754, 0.98711472, 0.98714187, 0.98716900, \
0.98719609, 0.98722316, 0.98725020, 0.98727721, 0.98730419, \
0.98733114, 0.98735807, 0.98738496, 0.98741183, 0.98743867, \
0.98746548, 0.98749227, 0.98751902, 0.98754575, 0.98757245, \
0.98759912, 0.98762576, 0.98765237, 0.98767895, 0.98770551, \
0.98773204, 0.98775854, 0.98778501, 0.98781145, 0.98783787, \
0.98786425, 0.98789061, 0.98791694, 0.98794324, 0.98796951, \
0.98799576, 0.98802197, 0.98804816, 0.98807432, 0.98810045, \
0.98812655, 0.98815262, 0.98817867, 0.98820469, 0.98823067, \
0.98825663, 0.98828257, 0.98830847, 0.98833434, 0.98836019, \
0.98838601, 0.98841180, 0.98843756, 0.98846329, 0.98848900, \
0.98851467, 0.98854032, 0.98856594, 0.98859153, 0.98861709, \
0.98864263, 0.98866813, 0.98869361, 0.98871906, 0.98874448, \
0.98876987, 0.98879523, 0.98882057, 0.98884587, 0.98887115, \
0.98889640, 0.98892162, 0.98894682, 0.98897198, 0.98899712, \
0.98902222, 0.98904730, 0.98907235, 0.98909738, 0.98912237, \
0.98914734, 0.98917227, 0.98919718, 0.98922206, 0.98924691, \
0.98927174, 0.98929653, 0.98932130, 0.98934603, 0.98937074, \
0.98939542, 0.98942008, 0.98944470, 0.98946930, 0.98949386, \
0.98951840, 0.98954291, 0.98956739, 0.98959185, 0.98961627, \
0.98964067, 0.98966503, 0.98968937, 0.98971368, 0.98973797, \
0.98976222, 0.98978645, 0.98981064, 0.98983481, 0.98985895, \
0.98988306, 0.98990715, 0.98993120, 0.98995523, 0.98997923, \
0.99000319, 0.99002713, 0.99005105, 0.99007493, 0.99009879, \
0.99012261, 0.99014641, 0.99017018, 0.99019392, 0.99021764, \
0.99024132, 0.99026498, 0.99028860, 0.99031220, 0.99033577, \
0.99035931, 0.99038283, 0.99040631, 0.99042977, 0.99045320, \
0.99047660, 0.99049997, 0.99052331, 0.99054662, 0.99056991, \
0.99059316, 0.99061639, 0.99063959, 0.99066276, 0.99068591, \
0.99070902, 0.99073211, 0.99075516, 0.99077819, 0.99080119, \
0.99082417, 0.99084711, 0.99087002, 0.99089291, 0.99091577, \
0.99093860, 0.99096140, 0.99098417, 0.99100691, 0.99102963, \
0.99105231, 0.99107497, 0.99109760, 0.99112020, 0.99114278, \
0.99116532, 0.99118783, 0.99121032, 0.99123278, 0.99125521, \
0.99127761, 0.99129998, 0.99132233, 0.99134464, 0.99136693, \
0.99138919, 0.99141142, 0.99143362, 0.99145579, 0.99147794, \
0.99150005, 0.99152214, 0.99154420, 0.99156623, 0.99158823, \
0.99161020, 0.99163215, 0.99165406, 0.99167595, 0.99169781, \
0.99171964, 0.99174144, 0.99176322, 0.99178496, 0.99180668, \
0.99182836, 0.99185002, 0.99187165, 0.99189326, 0.99191483, \
0.99193637, 0.99195789, 0.99197938, 0.99200084, 0.99202227, \
0.99204367, 0.99206504, 0.99208639, 0.99210770, 0.99212899, \
0.99215025, 0.99217148, 0.99219268, 0.99221386, 0.99223500, \
0.99225612, 0.99227720, 0.99229826, 0.99231929, 0.99234030, \
0.99236127, 0.99238221, 0.99240313, 0.99242402, 0.99244488, \
0.99246571, 0.99248651, 0.99250728, 0.99252803, 0.99254874, \
0.99256943, 0.99259009, 0.99261072, 0.99263132, 0.99265189, \
0.99267244, 0.99269295, 0.99271344, 0.99273390, 0.99275433, \
0.99277473, 0.99279510, 0.99281545, 0.99283576, 0.99285605, \
0.99287631, 0.99289654, 0.99291674, 0.99293691, 0.99295705, \
0.99297717, 0.99299726, 0.99301731, 0.99303734, 0.99305734, \
0.99307732, 0.99309726, 0.99311718, 0.99313706, 0.99315692, \
0.99317675, 0.99319655, 0.99321632, 0.99323606, 0.99325578, \
0.99327547, 0.99329512, 0.99331475, 0.99333435, 0.99335392, \
0.99337347, 0.99339298, 0.99341247, 0.99343192, 0.99345135, \
0.99347075, 0.99349012, 0.99350946, 0.99352878, 0.99354806, \
0.99356732, 0.99358655, 0.99360575, 0.99362492, 0.99364406, \
0.99366317, 0.99368226, 0.99370131, 0.99372034, 0.99373934, \
0.99375831, 0.99377725, 0.99379617, 0.99381505, 0.99383391, \
0.99385273, 0.99387153, 0.99389030, 0.99390904, 0.99392775, \
0.99394644, 0.99396509, 0.99398372, 0.99400232, 0.99402089, \
0.99403943, 0.99405794, 0.99407642, 0.99409487, 0.99411330, \
0.99413170, 0.99415007, 0.99416841, 0.99418672, 0.99420500, \
0.99422325, 0.99424148, 0.99425967, 0.99427784, 0.99429598, \
0.99431409, 0.99433217, 0.99435023, 0.99436825, 0.99438625, \
0.99440421, 0.99442215, 0.99444006, 0.99445794, 0.99447580, \
0.99449362, 0.99451141, 0.99452918, 0.99454692, 0.99456463, \
0.99458231, 0.99459996, 0.99461758, 0.99463518, 0.99465274, \
0.99467028, 0.99468779, 0.99470527, 0.99472272, 0.99474014, \
0.99475753, 0.99477490, 0.99479223, 0.99480954, 0.99482682, \
0.99484407, 0.99486129, 0.99487848, 0.99489565, 0.99491278, \
0.99492989, 0.99494697, 0.99496402, 0.99498104, 0.99499803, \
0.99501499, 0.99503192, 0.99504883, 0.99506571, 0.99508256, \
0.99509938, 0.99511617, 0.99513293, 0.99514966, 0.99516637, \
0.99518304, 0.99519969, 0.99521631, 0.99523290, 0.99524946, \
0.99526599, 0.99528249, 0.99529897, 0.99531542, 0.99533183, \
0.99534822, 0.99536458, 0.99538091, 0.99539722, 0.99541349, \
0.99542974, 0.99544595, 0.99546214, 0.99547830, 0.99549443, \
0.99551053, 0.99552660, 0.99554265, 0.99555866, 0.99557465, \
0.99559061, 0.99560654, 0.99562244, 0.99563831, 0.99565415, \
0.99566997, 0.99568575, 0.99570151, 0.99571724, 0.99573294, \
0.99574861, 0.99576425, 0.99577986, 0.99579545, 0.99581100, \
0.99582653, 0.99584203, 0.99585750, 0.99587294, 0.99588835, \
0.99590373, 0.99591909, 0.99593441, 0.99594971, 0.99596498, \
0.99598022, 0.99599543, 0.99601061, 0.99602577, 0.99604089, \
0.99605599, 0.99607105, 0.99608609, 0.99610110, 0.99611608, \
0.99613103, 0.99614596, 0.99616085, 0.99617572, 0.99619056, \
0.99620536, 0.99622014, 0.99623489, 0.99624962, 0.99626431, \
0.99627897, 0.99629361, 0.99630822, 0.99632280, 0.99633734, \
0.99635187, 0.99636636, 0.99638082, 0.99639526, 0.99640966, \
0.99642404, 0.99643839, 0.99645271, 0.99646700, 0.99648126, \
0.99649549, 0.99650970, 0.99652387, 0.99653802, 0.99655214, \
0.99656623, 0.99658029, 0.99659432, 0.99660832, 0.99662230, \
0.99663624, 0.99665016, 0.99666405, 0.99667790, 0.99669173, \
0.99670554, 0.99671931, 0.99673305, 0.99674677, 0.99676046, \
0.99677411, 0.99678774, 0.99680134, 0.99681491, 0.99682846, \
0.99684197, 0.99685545, 0.99686891, 0.99688234, 0.99689574, \
0.99690911, 0.99692245, 0.99693576, 0.99694904, 0.99696230, \
0.99697552, 0.99698872, 0.99700189, 0.99701503, 0.99702814, \
0.99704122, 0.99705428, 0.99706730, 0.99708030, 0.99709326, \
0.99710620, 0.99711911, 0.99713199, 0.99714484, 0.99715766, \
0.99717046, 0.99718322, 0.99719596, 0.99720867, 0.99722135, \
0.99723400, 0.99724662, 0.99725921, 0.99727177, 0.99728431, \
0.99729681, 0.99730929, 0.99732174, 0.99733416, 0.99734655, \
0.99735891, 0.99737125, 0.99738355, 0.99739583, 0.99740807, \
0.99742029, 0.99743248, 0.99744464, 0.99745677, 0.99746888, \
0.99748095, 0.99749299, 0.99750501, 0.99751700, 0.99752896, \
0.99754089, 0.99755279, 0.99756466, 0.99757650, 0.99758832, \
0.99760010, 0.99761186, 0.99762359, 0.99763529, 0.99764696, \
0.99765860, 0.99767021, 0.99768180, 0.99769335, 0.99770488, \
0.99771638, 0.99772785, 0.99773929, 0.99775070, 0.99776208, \
0.99777343, 0.99778476, 0.99779605, 0.99780732, 0.99781856, \
0.99782977, 0.99784095, 0.99785210, 0.99786322, 0.99787432, \
0.99788538, 0.99789642, 0.99790743, 0.99791841, 0.99792936, \
0.99794028, 0.99795117, 0.99796203, 0.99797287, 0.99798367, \
0.99799445, 0.99800520, 0.99801592, 0.99802661, 0.99803727, \
0.99804790, 0.99805851, 0.99806908, 0.99807963, 0.99809015, \
0.99810063, 0.99811109, 0.99812152, 0.99813193, 0.99814230, \
0.99815264, 0.99816296, 0.99817325, 0.99818350, 0.99819373, \
0.99820393, 0.99821410, 0.99822425, 0.99823436, 0.99824445, \
0.99825450, 0.99826453, 0.99827453, 0.99828450, 0.99829444, \
0.99830435, 0.99831423, 0.99832409, 0.99833391, 0.99834371, \
0.99835348, 0.99836321, 0.99837292, 0.99838260, 0.99839226, \
0.99840188, 0.99841147, 0.99842104, 0.99843058, 0.99844008, \
0.99844956, 0.99845901, 0.99846843, 0.99847783, 0.99848719, \
0.99849653, 0.99850583, 0.99851511, 0.99852436, 0.99853358, \
0.99854277, 0.99855193, 0.99856106, 0.99857016, 0.99857924, \
0.99858829, 0.99859730, 0.99860629, 0.99861525, 0.99862418, \
0.99863308, 0.99864196, 0.99865080, 0.99865962, 0.99866840, \
0.99867716, 0.99868589, 0.99869459, 0.99870326, 0.99871190, \
0.99872051, 0.99872910, 0.99873765, 0.99874618, 0.99875468, \
0.99876315, 0.99877159, 0.99878000, 0.99878838, 0.99879673, \
0.99880506, 0.99881335, 0.99882162, 0.99882986, 0.99883807, \
0.99884625, 0.99885440, 0.99886252, 0.99887062, 0.99887868, \
0.99888672, 0.99889472, 0.99890270, 0.99891065, 0.99891857, \
0.99892646, 0.99893432, 0.99894216, 0.99894996, 0.99895774, \
0.99896549, 0.99897320, 0.99898089, 0.99898855, 0.99899619, \
0.99900379, 0.99901136, 0.99901891, 0.99902642, 0.99903391, \
0.99904137, 0.99904880, 0.99905620, 0.99906357, 0.99907091, \
0.99907823, 0.99908551, 0.99909277, 0.99910000, 0.99910719, \
0.99911436, 0.99912150, 0.99912862, 0.99913570, 0.99914275, \
0.99914978, 0.99915677, 0.99916374, 0.99917068, 0.99917759, \
0.99918447, 0.99919132, 0.99919814, 0.99920494, 0.99921170, \
0.99921844, 0.99922515, 0.99923183, 0.99923847, 0.99924510, \
0.99925169, 0.99925825, 0.99926478, 0.99927129, 0.99927777, \
0.99928421, 0.99929063, 0.99929702, 0.99930338, 0.99930971, \
0.99931602, 0.99932229, 0.99932853, 0.99933475, 0.99934094, \
0.99934710, 0.99935323, 0.99935933, 0.99936540, 0.99937144, \
0.99937746, 0.99938344, 0.99938940, 0.99939532, 0.99940122, \
0.99940709, 0.99941293, 0.99941874, 0.99942453, 0.99943028, \
0.99943601, 0.99944170, 0.99944737, 0.99945301, 0.99945862, \
0.99946420, 0.99946975, 0.99947527, 0.99948076, 0.99948623, \
0.99949167, 0.99949707, 0.99950245, 0.99950780, 0.99951312, \
0.99951841, 0.99952367, 0.99952891, 0.99953411, 0.99953929, \
0.99954444, 0.99954955, 0.99955464, 0.99955970, 0.99956473, \
0.99956974, 0.99957471, 0.99957966, 0.99958457, 0.99958946, \
0.99959432, 0.99959915, 0.99960395, 0.99960872, 0.99961346, \
0.99961817, 0.99962286, 0.99962751, 0.99963214, 0.99963674, \
0.99964131, 0.99964585, 0.99965036, 0.99965484, 0.99965929, \
0.99966372, 0.99966811, 0.99967248, 0.99967682, 0.99968112, \
0.99968540, 0.99968966, 0.99969388, 0.99969807, 0.99970223, \
0.99970637, 0.99971048, 0.99971455, 0.99971860, 0.99972262, \
0.99972661, 0.99973057, 0.99973451, 0.99973841, 0.99974229, \
0.99974613, 0.99974995, 0.99975374, 0.99975750, 0.99976123, \
0.99976493, 0.99976860, 0.99977225, 0.99977586, 0.99977945, \
0.99978300, 0.99978653, 0.99979003, 0.99979350, 0.99979694, \
0.99980036, 0.99980374, 0.99980709, 0.99981042, 0.99981372, \
0.99981698, 0.99982022, 0.99982343, 0.99982661, 0.99982977, \
0.99983289, 0.99983598, 0.99983905, 0.99984209, 0.99984509, \
0.99984807, 0.99985102, 0.99985394, 0.99985684, 0.99985970, \
0.99986253, 0.99986534, 0.99986812, 0.99987086, 0.99987358, \
0.99987627, 0.99987893, 0.99988156, 0.99988417, 0.99988674, \
0.99988928, 0.99989180, 0.99989429, 0.99989675, 0.99989918, \
0.99990158, 0.99990395, 0.99990629, 0.99990860, 0.99991089, \
0.99991314, 0.99991537, 0.99991757, 0.99991974, 0.99992188, \
0.99992399, 0.99992607, 0.99992813, 0.99993015, 0.99993215, \
0.99993411, 0.99993605, 0.99993796, 0.99993984, 0.99994169, \
0.99994351, 0.99994531, 0.99994707, 0.99994880, 0.99995051, \
0.99995219, 0.99995384, 0.99995546, 0.99995705, 0.99995861, \
0.99996014, 0.99996165, 0.99996312, 0.99996457, 0.99996598, \
0.99996737, 0.99996873, 0.99997006, 0.99997136, 0.99997264, \
0.99997388, 0.99997509, 0.99997628, 0.99997744, 0.99997857, \
0.99997966, 0.99998073, 0.99998178, 0.99998279, 0.99998377, \
0.99998473, 0.99998565, 0.99998655, 0.99998742, 0.99998825, \
0.99998906, 0.99998984, 0.99999060, 0.99999132, 0.99999201, \
0.99999268, 0.99999332, 0.99999392, 0.99999450, 0.99999505, \
0.99999557, 0.99999606, 0.99999653, 0.99999696, 0.99999736, \
0.99999774, 0.99999809, 0.99999841, 0.99999869, 0.99999896, \
0.99999919, 0.99999939, 0.99999956, 0.99999971, 0.99999982, \
0.99999991, 0.99999997, 1.00000000, } 


 #endif // _FPU_FFT_KAISER_H_
//=============================================================================
// End of File
//=============================================================================
