//=============================================================================
// Nuttall Window 
//=============================================================================
#ifndef _FPU_FFT_NUTTALL_H_
#define _FPU_FFT_NUTTALL_H_

#define NUTTALL32 {\
0.00036280, 0.00121324, 0.00446524, 0.01219183, 0.02771015, \
0.05525349, 0.09934601, 0.16385817, 0.25084832, 0.35942880, \
0.48497616, 0.61899264, 0.74980550, 0.86408777, 0.94895471, \
0.99420598, } 

#define NUTTALL64 {\
0.00036280, 0.00055796, 0.00118467, 0.00236637, 0.00430764, \
0.00729200, 0.01167775, 0.01789100, 0.02641512, 0.03777577, \
0.05252111, 0.07119707, 0.09431807, 0.12233421, 0.15559613, \
0.19431969, 0.23855253, 0.28814494, 0.34272762, 0.40169841, \
0.46422000, 0.52922980, 0.59546271, 0.66148635, 0.72574786, \
0.78663023, 0.84251554, 0.89185186, 0.93322022, 0.96539781, \
0.98741376, 0.99859427, } 

#define NUTTALL128 {\
0.00036280, 0.00041019, 0.00055484, 0.00080427, 0.00117093, \
0.00167228, 0.00233066, 0.00317331, 0.00423227, 0.00554427, \
0.00715059, 0.00909689, 0.01143301, 0.01421263, 0.01749301, \
0.02133449, 0.02580011, 0.03095499, 0.03686575, 0.04359978, \
0.05122450, 0.05980651, 0.06941066, 0.08009913, 0.09193039, \
0.10495817, 0.11923037, 0.13478802, 0.15166420, 0.16988295, \
0.18945834, 0.21039348, 0.23267967, 0.25629563, 0.28120686, \
0.30736514, 0.33470812, 0.36315911, 0.39262711, 0.42300687, \
0.45417928, 0.48601187, 0.51835956, 0.55106552, 0.58396233, \
0.61687320, 0.64961344, 0.68199204, 0.71381338, 0.74487911, \
0.77499002, 0.80394806, 0.83155837, 0.85763131, 0.88198451, \
0.90444482, 0.92485024, 0.94305173, 0.95891488, 0.97232146, \
0.98317077, 0.99138079, 0.99688916, 0.99965391, } 

#define NUTTALL256 {\
0.00036280, 0.00037452, 0.00040981, 0.00046916, 0.00055332, \
0.00066336, 0.00080068, 0.00096696, 0.00116419, 0.00139468, \
0.00166102, 0.00196611, 0.00231317, 0.00270568, 0.00314745, \
0.00364257, 0.00419541, 0.00481064, 0.00549321, 0.00624833, \
0.00708150, 0.00799847, 0.00900526, 0.01010812, 0.01131356, \
0.01262831, 0.01405931, 0.01561373, 0.01729891, 0.01912240, \
0.02109187, 0.02321519, 0.02550033, 0.02795539, 0.03058856, \
0.03340809, 0.03642230, 0.03963954, 0.04306814, 0.04671645, \
0.05059274, 0.05470522, 0.05906200, 0.06367105, 0.06854019, \
0.07367705, 0.07908903, 0.08478327, 0.09076665, 0.09704571, \
0.10362664, 0.11051525, 0.11771694, 0.12523665, 0.13307884, \
0.14124744, 0.14974586, 0.15857692, 0.16774282, 0.17724512, \
0.18708474, 0.19726187, 0.20777600, 0.21862586, 0.22980944, \
0.24132390, 0.25316561, 0.26533012, 0.27781212, 0.29060545, \
0.30370310, 0.31709715, 0.33077884, 0.34473848, 0.35896554, \
0.37344857, 0.38817527, 0.40313246, 0.41830609, 0.43368127, \
0.44924230, 0.46497265, 0.48085501, 0.49687130, 0.51300273, \
0.52922980, 0.54553233, 0.56188952, 0.57827998, 0.59468177, \
0.61107245, 0.62742912, 0.64372847, 0.65994683, 0.67606025, \
0.69204451, 0.70787519, 0.72352775, 0.73897759, 0.75420006, \
0.76917059, 0.78386471, 0.79825810, 0.81232670, 0.82604673, \
0.83939479, 0.85234788, 0.86488349, 0.87697966, 0.88861502, \
0.89976888, 0.91042125, 0.92055293, 0.93014553, 0.93918157, \
0.94764447, 0.95551864, 0.96278950, 0.96944356, 0.97546838, \
0.98085271, 0.98558643, 0.98966065, 0.99306767, 0.99580106, \
0.99785565, 0.99922755, 0.99991414, } 

#define NUTTALL512 {\
0.00036280, 0.00036571, 0.00037447, 0.00038909, 0.00040963, \
0.00043615, 0.00046874, 0.00050750, 0.00055256, 0.00060406, \
0.00066216, 0.00072704, 0.00079890, 0.00087797, 0.00096448, \
0.00105868, 0.00116086, 0.00127130, 0.00139032, 0.00151825, \
0.00165544, 0.00180227, 0.00195911, 0.00212639, 0.00230451, \
0.00249393, 0.00269510, 0.00290851, 0.00313466, 0.00337405, \
0.00362723, 0.00389475, 0.00417718, 0.00447510, 0.00478912, \
0.00511986, 0.00546796, 0.00583408, 0.00621889, 0.00662308, \
0.00704735, 0.00749243, 0.00795906, 0.00844799, 0.00895998, \
0.00949583, 0.01005633, 0.01064229, 0.01125455, 0.01189395, \
0.01256134, 0.01325759, 0.01398358, 0.01474022, 0.01552839, \
0.01634903, 0.01720306, 0.01809143, 0.01901508, 0.01997497, \
0.02097207, 0.02200737, 0.02308185, 0.02419650, 0.02535233, \
0.02655034, 0.02779156, 0.02907699, 0.03040766, 0.03178461, \
0.03320885, 0.03468144, 0.03620340, 0.03777577, 0.03939959, \
0.04107589, 0.04280572, 0.04459011, 0.04643008, 0.04832667, \
0.05028090, 0.05229379, 0.05436635, 0.05649959, 0.05869450, \
0.06095208, 0.06327329, 0.06565912, 0.06811051, 0.07062841, \
0.07321374, 0.07586744, 0.07859039, 0.08138347, 0.08424756, \
0.08718351, 0.09019213, 0.09327424, 0.09643062, 0.09966203, \
0.10296922, 0.10635290, 0.10981376, 0.11335246, 0.11696964, \
0.12066589, 0.12444180, 0.12829792, 0.13223475, 0.13625278, \
0.14035246, 0.14453418, 0.14879835, 0.15314528, 0.15757529, \
0.16208864, 0.16668556, 0.17136622, 0.17613077, 0.18097932, \
0.18591191, 0.19092856, 0.19602925, 0.20121390, 0.20648238, \
0.21183453, 0.21727013, 0.22278891, 0.22839056, 0.23407473, \
0.23984099, 0.24568888, 0.25161790, 0.25762746, 0.26371696, \
0.26988571, 0.27613301, 0.28245806, 0.28886004, 0.29533807, \
0.30189119, 0.30851843, 0.31521873, 0.32199098, 0.32883403, \
0.33574667, 0.34272762, 0.34977557, 0.35688913, 0.36406688, \
0.37130732, 0.37860892, 0.38597008, 0.39338915, 0.40086443, \
0.40839416, 0.41597654, 0.42360970, 0.43129174, 0.43902068, \
0.44679452, 0.45461120, 0.46246859, 0.47036455, 0.47829687, \
0.48626328, 0.49426149, 0.50228916, 0.51034390, 0.51842327, \
0.52652480, 0.53464598, 0.54278425, 0.55093703, 0.55910169, \
0.56727555, 0.57545593, 0.58364008, 0.59182526, 0.60000865, \
0.60818745, 0.61635879, 0.62451980, 0.63266759, 0.64079923, \
0.64891178, 0.65700226, 0.66506771, 0.67310512, 0.68111148, \
0.68908376, 0.69701894, 0.70491397, 0.71276579, 0.72057136, \
0.72832760, 0.73603147, 0.74367989, 0.75126981, 0.75879817, \
0.76626193, 0.77365804, 0.78098347, 0.78823520, 0.79541023, \
0.80250557, 0.80951824, 0.81644529, 0.82328379, 0.83003083, \
0.83668353, 0.84323904, 0.84969452, 0.85604719, 0.86229427, \
0.86843305, 0.87446083, 0.88037496, 0.88617283, 0.89185186, \
0.89740954, 0.90284338, 0.90815095, 0.91332986, 0.91837779, \
0.92329244, 0.92807160, 0.93271309, 0.93721480, 0.94157467, \
0.94579070, 0.94986096, 0.95378358, 0.95755675, 0.96117872, \
0.96464782, 0.96796244, 0.97112104, 0.97412216, 0.97696438, \
0.97964639, 0.98216692, 0.98452481, 0.98671895, 0.98874830, \
0.99061192, 0.99230892, 0.99383851, 0.99519997, 0.99639266, \
0.99741601, 0.99826954, 0.99895285, 0.99946561, 0.99980759, \
0.99997862, } 

#define NUTTALL1024 {\
0.00036280, 0.00036353, 0.00036571, 0.00036935, 0.00037445, \
0.00038101, 0.00038904, 0.00039855, 0.00040954, 0.00042202, \
0.00043601, 0.00045150, 0.00046853, 0.00048709, 0.00050721, \
0.00052890, 0.00055218, 0.00057706, 0.00060357, 0.00063173, \
0.00066156, 0.00069307, 0.00072630, 0.00076128, 0.00079802, \
0.00083656, 0.00087692, 0.00091914, 0.00096324, 0.00100927, \
0.00105724, 0.00110721, 0.00115920, 0.00121324, 0.00126939, \
0.00132768, 0.00138815, 0.00145084, 0.00151579, 0.00158305, \
0.00165267, 0.00172469, 0.00179916, 0.00187612, 0.00195563, \
0.00203774, 0.00212251, 0.00220997, 0.00230020, 0.00239324, \
0.00248916, 0.00258800, 0.00268984, 0.00279472, 0.00290272, \
0.00301389, 0.00312829, 0.00324600, 0.00336708, 0.00349159, \
0.00361961, 0.00375120, 0.00388643, 0.00402538, 0.00416811, \
0.00431471, 0.00446524, 0.00461979, 0.00477842, 0.00494122, \
0.00510826, 0.00527963, 0.00545541, 0.00563568, 0.00582052, \
0.00601002, 0.00620425, 0.00640332, 0.00660731, 0.00681629, \
0.00703038, 0.00724964, 0.00747419, 0.00770410, 0.00793947, \
0.00818040, 0.00842698, 0.00867930, 0.00893747, 0.00920159, \
0.00947174, 0.00974804, 0.01003058, 0.01031947, 0.01061480, \
0.01091669, 0.01122523, 0.01154053, 0.01186269, 0.01219183, \
0.01252806, 0.01287147, 0.01322218, 0.01358031, 0.01394595, \
0.01431923, 0.01470025, 0.01508913, 0.01548599, 0.01589093, \
0.01630407, 0.01672553, 0.01715543, 0.01759389, 0.01804101, \
0.01849693, 0.01896175, 0.01943560, 0.01991861, 0.02041088, \
0.02091255, 0.02142373, 0.02194455, 0.02247513, 0.02301560, \
0.02356607, 0.02412668, 0.02469755, 0.02527879, 0.02587055, \
0.02647295, 0.02708611, 0.02771015, 0.02834522, 0.02899143, \
0.02964891, 0.03031779, 0.03099819, 0.03169026, 0.03239411, \
0.03310987, 0.03383768, 0.03457765, 0.03532993, 0.03609464, \
0.03687191, 0.03766187, 0.03846465, 0.03928038, 0.04010918, \
0.04095119, 0.04180654, 0.04267535, 0.04355775, 0.04445388, \
0.04536385, 0.04628781, 0.04722587, 0.04817817, 0.04914483, \
0.05012598, 0.05112174, 0.05213225, 0.05315763, 0.05419800, \
0.05525349, 0.05632423, 0.05741033, 0.05851193, 0.05962914, \
0.06076209, 0.06191089, 0.06307568, 0.06425657, 0.06545368, \
0.06666713, 0.06789703, 0.06914351, 0.07040669, 0.07168667, \
0.07298357, 0.07429750, 0.07562859, 0.07697693, 0.07834265, \
0.07972585, 0.08112663, 0.08254512, 0.08398141, 0.08543560, \
0.08690781, 0.08839814, 0.08990668, 0.09143354, 0.09297882, \
0.09454261, 0.09612501, 0.09772611, 0.09934601, 0.10098481, \
0.10264258, 0.10431942, 0.10601541, 0.10773065, 0.10946521, \
0.11121917, 0.11299263, 0.11478565, 0.11659831, 0.11843068, \
0.12028285, 0.12215488, 0.12404684, 0.12595880, 0.12789082, \
0.12984297, 0.13181531, 0.13380789, 0.13582078, 0.13785404, \
0.13990770, 0.14198183, 0.14407647, 0.14619167, 0.14832747, \
0.15048392, 0.15266105, 0.15485890, 0.15707751, 0.15931690, \
0.16157711, 0.16385817, 0.16616010, 0.16848292, 0.17082665, \
0.17319131, 0.17557691, 0.17798347, 0.18041099, 0.18285949, \
0.18532895, 0.18781940, 0.19033081, 0.19286320, 0.19541655, \
0.19799085, 0.20058609, 0.20320225, 0.20583932, 0.20849727, \
0.21117607, 0.21387571, 0.21659614, 0.21933734, 0.22209927, \
0.22488189, 0.22768515, 0.23050901, 0.23335342, 0.23621834, \
0.23910369, 0.24200943, 0.24493549, 0.24788181, 0.25084832, \
0.25383495, 0.25684162, 0.25986826, 0.26291478, 0.26598110, \
0.26906714, 0.27217280, 0.27529798, 0.27844259, 0.28160653, \
0.28478969, 0.28799197, 0.29121326, 0.29445344, 0.29771238, \
0.30098998, 0.30428611, 0.30760063, 0.31093343, 0.31428435, \
0.31765327, 0.32104004, 0.32444451, 0.32786655, 0.33130599, \
0.33476268, 0.33823647, 0.34172719, 0.34523467, 0.34875874, \
0.35229924, 0.35585599, 0.35942880, 0.36301750, 0.36662190, \
0.37024181, 0.37387704, 0.37752738, 0.38119265, 0.38487264, \
0.38856714, 0.39227594, 0.39599883, 0.39973560, 0.40348601, \
0.40724987, 0.41102692, 0.41481696, 0.41861973, 0.42243502, \
0.42626257, 0.43010215, 0.43395351, 0.43781641, 0.44169059, \
0.44557579, 0.44947177, 0.45337825, 0.45729498, 0.46122169, \
0.46515810, 0.46910396, 0.47305897, 0.47702286, 0.48099535, \
0.48497616, 0.48896500, 0.49296158, 0.49696560, 0.50097677, \
0.50499479, 0.50901937, 0.51305019, 0.51708696, 0.52112935, \
0.52517707, 0.52922980, 0.53328722, 0.53734901, 0.54141486, \
0.54548443, 0.54955741, 0.55363346, 0.55771225, 0.56179346, \
0.56587675, 0.56996178, 0.57404821, 0.57813570, 0.58222391, \
0.58631249, 0.59040110, 0.59448939, 0.59857701, 0.60266360, \
0.60674882, 0.61083230, 0.61491370, 0.61899264, 0.62306878, \
0.62714174, 0.63121117, 0.63527670, 0.63933797, 0.64339461, \
0.64744624, 0.65149251, 0.65553304, 0.65956745, 0.66359538, \
0.66761646, 0.67163029, 0.67563652, 0.67963477, 0.68362465, \
0.68760580, 0.69157783, 0.69554036, 0.69949301, 0.70343541, \
0.70736717, 0.71128791, 0.71519726, 0.71909482, 0.72298023, \
0.72685309, 0.73071303, 0.73455966, 0.73839260, 0.74221148, \
0.74601591, 0.74980550, 0.75357988, 0.75733868, 0.76108150, \
0.76480796, 0.76851770, 0.77221033, 0.77588547, 0.77954274, \
0.78318178, 0.78680220, 0.79040363, 0.79398570, 0.79754803, \
0.80109025, 0.80461200, 0.80811290, 0.81159258, 0.81505068, \
0.81848683, 0.82190068, 0.82529184, 0.82865998, 0.83200472, \
0.83532571, 0.83862260, 0.84189502, 0.84514263, 0.84836508, \
0.85156202, 0.85473310, 0.85787798, 0.86099632, 0.86408777, \
0.86715201, 0.87018869, 0.87319748, 0.87617805, 0.87913007, \
0.88205323, 0.88494718, 0.88781163, 0.89064624, 0.89345070, \
0.89622471, 0.89896795, 0.90168011, 0.90436090, 0.90701001, \
0.90962715, 0.91221201, 0.91476433, 0.91728379, 0.91977013, \
0.92222305, 0.92464229, 0.92702757, 0.92937861, 0.93169516, \
0.93397694, 0.93622370, 0.93843518, 0.94061113, 0.94275130, \
0.94485545, 0.94692333, 0.94895471, 0.95094936, 0.95290704, \
0.95482752, 0.95671060, 0.95855605, 0.96036366, 0.96213322, \
0.96386452, 0.96555737, 0.96721157, 0.96882693, 0.97040325, \
0.97194036, 0.97343808, 0.97489624, 0.97631465, 0.97769317, \
0.97903163, 0.98032987, 0.98158773, 0.98280509, 0.98398178, \
0.98511768, 0.98621265, 0.98726656, 0.98827929, 0.98925072, \
0.99018074, 0.99106923, 0.99191610, 0.99272125, 0.99348457, \
0.99420598, 0.99488540, 0.99552274, 0.99611793, 0.99667090, \
0.99718158, 0.99764992, 0.99807586, 0.99845935, 0.99880035, \
0.99909880, 0.99935469, 0.99956797, 0.99973863, 0.99986664, \
0.99995199, 0.99999467, } 

#define NUTTALL2048 {\
0.00036280, 0.00036298, 0.00036353, 0.00036443, 0.00036571, \
0.00036734, 0.00036934, 0.00037171, 0.00037443, 0.00037753, \
0.00038099, 0.00038482, 0.00038901, 0.00039358, 0.00039851, \
0.00040382, 0.00040949, 0.00041554, 0.00042196, 0.00042876, \
0.00043593, 0.00044349, 0.00045142, 0.00045973, 0.00046842, \
0.00047750, 0.00048697, 0.00049683, 0.00050707, 0.00051771, \
0.00052874, 0.00054017, 0.00055199, 0.00056422, 0.00057685, \
0.00058989, 0.00060333, 0.00061719, 0.00063146, 0.00064615, \
0.00066126, 0.00067679, 0.00069274, 0.00070912, 0.00072594, \
0.00074319, 0.00076088, 0.00077900, 0.00079758, 0.00081660, \
0.00083608, 0.00085601, 0.00087640, 0.00089725, 0.00091857, \
0.00094036, 0.00096263, 0.00098537, 0.00100860, 0.00103232, \
0.00105653, 0.00108123, 0.00110644, 0.00113215, 0.00115837, \
0.00118510, 0.00121236, 0.00124013, 0.00126844, 0.00129728, \
0.00132666, 0.00135659, 0.00138706, 0.00141809, 0.00144968, \
0.00148184, 0.00151456, 0.00154786, 0.00158175, 0.00161622, \
0.00165129, 0.00168695, 0.00172322, 0.00176010, 0.00179760, \
0.00183572, 0.00187448, 0.00191387, 0.00195390, 0.00199458, \
0.00203591, 0.00207791, 0.00212057, 0.00216391, 0.00220794, \
0.00225265, 0.00229805, 0.00234416, 0.00239098, 0.00243852, \
0.00248678, 0.00253577, 0.00258550, 0.00263598, 0.00268721, \
0.00273921, 0.00279197, 0.00284550, 0.00289983, 0.00295494, \
0.00301086, 0.00306758, 0.00312512, 0.00318348, 0.00324268, \
0.00330272, 0.00336360, 0.00342534, 0.00348795, 0.00355144, \
0.00361581, 0.00368106, 0.00374722, 0.00381429, 0.00388228, \
0.00395119, 0.00402105, 0.00409184, 0.00416359, 0.00423631, \
0.00430999, 0.00438466, 0.00446033, 0.00453699, 0.00461466, \
0.00469336, 0.00477308, 0.00485385, 0.00493566, 0.00501854, \
0.00510248, 0.00518750, 0.00527362, 0.00536083, 0.00544915, \
0.00553860, 0.00562917, 0.00572089, 0.00581376, 0.00590779, \
0.00600299, 0.00609938, 0.00619696, 0.00629574, 0.00639575, \
0.00649698, 0.00659944, 0.00670316, 0.00680814, 0.00691438, \
0.00702191, 0.00713074, 0.00724087, 0.00735231, 0.00746509, \
0.00757920, 0.00769467, 0.00781150, 0.00792970, 0.00804929, \
0.00817028, 0.00829268, 0.00841650, 0.00854176, 0.00866846, \
0.00879662, 0.00892625, 0.00905737, 0.00918998, 0.00932410, \
0.00945974, 0.00959691, 0.00973563, 0.00987590, 0.01001775, \
0.01016118, 0.01030621, 0.01045284, 0.01060110, 0.01075099, \
0.01090253, 0.01105573, 0.01121061, 0.01136717, 0.01152543, \
0.01168541, 0.01184711, 0.01201056, 0.01217575, 0.01234272, \
0.01251147, 0.01268201, 0.01285436, 0.01302853, 0.01320453, \
0.01338239, 0.01356211, 0.01374370, 0.01392719, 0.01411258, \
0.01429989, 0.01448914, 0.01468033, 0.01487348, 0.01506861, \
0.01526572, 0.01546485, 0.01566599, 0.01586916, 0.01607438, \
0.01628166, 0.01649102, 0.01670247, 0.01691602, 0.01713169, \
0.01734950, 0.01756946, 0.01779158, 0.01801588, 0.01824237, \
0.01847108, 0.01870200, 0.01893517, 0.01917059, 0.01940827, \
0.01964824, 0.01989051, 0.02013510, 0.02038201, 0.02063126, \
0.02088288, 0.02113687, 0.02139325, 0.02165203, 0.02191324, \
0.02217688, 0.02244297, 0.02271153, 0.02298257, 0.02325611, \
0.02353217, 0.02381075, 0.02409188, 0.02437556, 0.02466183, \
0.02495068, 0.02524214, 0.02553623, 0.02583295, 0.02613233, \
0.02643437, 0.02673911, 0.02704654, 0.02735670, 0.02766958, \
0.02798522, 0.02830362, 0.02862480, 0.02894878, 0.02927557, \
0.02960520, 0.02993766, 0.03027299, 0.03061119, 0.03095229, \
0.03129630, 0.03164323, 0.03199311, 0.03234594, 0.03270174, \
0.03306053, 0.03342233, 0.03378715, 0.03415501, 0.03452593, \
0.03489991, 0.03527698, 0.03565715, 0.03604044, 0.03642687, \
0.03681644, 0.03720918, 0.03760511, 0.03800423, 0.03840657, \
0.03881214, 0.03922096, 0.03963305, 0.04004841, 0.04046707, \
0.04088904, 0.04131434, 0.04174298, 0.04217499, 0.04261037, \
0.04304914, 0.04349132, 0.04393693, 0.04438598, 0.04483848, \
0.04529446, 0.04575393, 0.04621690, 0.04668339, 0.04715342, \
0.04762700, 0.04810415, 0.04858489, 0.04906922, 0.04955718, \
0.05004876, 0.05054399, 0.05104289, 0.05154547, 0.05205174, \
0.05256172, 0.05307543, 0.05359288, 0.05411409, 0.05463908, \
0.05516785, 0.05570043, 0.05623683, 0.05677706, 0.05732114, \
0.05786910, 0.05842093, 0.05897666, 0.05953631, 0.06009988, \
0.06066739, 0.06123887, 0.06181432, 0.06239375, 0.06297719, \
0.06356465, 0.06415614, 0.06475168, 0.06535129, 0.06595497, \
0.06656275, 0.06717463, 0.06779064, 0.06841078, 0.06903508, \
0.06966354, 0.07029618, 0.07093302, 0.07157406, 0.07221933, \
0.07286884, 0.07352260, 0.07418063, 0.07484294, 0.07550954, \
0.07618045, 0.07685569, 0.07753526, 0.07821918, 0.07890746, \
0.07960012, 0.08029717, 0.08099862, 0.08170450, 0.08241480, \
0.08312955, 0.08384875, 0.08457243, 0.08530058, 0.08603324, \
0.08677040, 0.08751209, 0.08825831, 0.08900908, 0.08976441, \
0.09052431, 0.09128880, 0.09205788, 0.09283157, 0.09360989, \
0.09439284, 0.09518043, 0.09597268, 0.09676961, 0.09757121, \
0.09837750, 0.09918850, 0.10000422, 0.10082466, 0.10164984, \
0.10247977, 0.10331446, 0.10415392, 0.10499816, 0.10584720, \
0.10670103, 0.10755969, 0.10842316, 0.10929148, 0.11016463, \
0.11104264, 0.11192552, 0.11281327, 0.11370591, 0.11460344, \
0.11550587, 0.11641322, 0.11732549, 0.11824269, 0.11916483, \
0.12009193, 0.12102398, 0.12196100, 0.12290299, 0.12384997, \
0.12480194, 0.12575892, 0.12672090, 0.12768790, 0.12865993, \
0.12963699, 0.13061908, 0.13160623, 0.13259844, 0.13359570, \
0.13459804, 0.13560545, 0.13661795, 0.13763553, 0.13865822, \
0.13968600, 0.14071890, 0.14175691, 0.14280005, 0.14384831, \
0.14490170, 0.14596024, 0.14702392, 0.14809275, 0.14916673, \
0.15024588, 0.15133018, 0.15241966, 0.15351432, 0.15461415, \
0.15571916, 0.15682936, 0.15794476, 0.15906534, 0.16019113, \
0.16132212, 0.16245831, 0.16359971, 0.16474633, 0.16589816, \
0.16705520, 0.16821747, 0.16938496, 0.17055767, 0.17173561, \
0.17291878, 0.17410718, 0.17530081, 0.17649967, 0.17770377, \
0.17891310, 0.18012767, 0.18134748, 0.18257253, 0.18380281, \
0.18503834, 0.18627910, 0.18752510, 0.18877634, 0.19003282, \
0.19129453, 0.19256148, 0.19383367, 0.19511109, 0.19639375, \
0.19768164, 0.19897475, 0.20027310, 0.20157667, 0.20288546, \
0.20419948, 0.20551872, 0.20684317, 0.20817283, 0.20950771, \
0.21084779, 0.21219308, 0.21354356, 0.21489924, 0.21626011, \
0.21762617, 0.21899742, 0.22037384, 0.22175543, 0.22314220, \
0.22453412, 0.22593121, 0.22733344, 0.22874082, 0.23015335, \
0.23157101, 0.23299379, 0.23442170, 0.23585472, 0.23729285, \
0.23873608, 0.24018440, 0.24163781, 0.24309629, 0.24455985, \
0.24602847, 0.24750214, 0.24898085, 0.25046460, 0.25195338, \
0.25344718, 0.25494598, 0.25644979, 0.25795858, 0.25947235, \
0.26099109, 0.26251479, 0.26404344, 0.26557703, 0.26711554, \
0.26865897, 0.27020730, 0.27176052, 0.27331862, 0.27488159, \
0.27644942, 0.27802209, 0.27959959, 0.28118191, 0.28276903, \
0.28436095, 0.28595764, 0.28755910, 0.28916530, 0.29077625, \
0.29239191, 0.29401229, 0.29563735, 0.29726710, 0.29890150, \
0.30054056, 0.30218424, 0.30383254, 0.30548544, 0.30714293, \
0.30880498, 0.31047158, 0.31214271, 0.31381836, 0.31549851, \
0.31718315, 0.31887224, 0.32056578, 0.32226375, 0.32396613, \
0.32567289, 0.32738403, 0.32909953, 0.33081935, 0.33254349, \
0.33427193, 0.33600464, 0.33774160, 0.33948280, 0.34122821, \
0.34297782, 0.34473160, 0.34648953, 0.34825158, 0.35001775, \
0.35178800, 0.35356232, 0.35534068, 0.35712306, 0.35890943, \
0.36069978, 0.36249408, 0.36429231, 0.36609444, 0.36790046, \
0.36971033, 0.37152403, 0.37334154, 0.37516284, 0.37698789, \
0.37881668, 0.38064918, 0.38248536, 0.38432520, 0.38616867, \
0.38801575, 0.38986641, 0.39172062, 0.39357836, 0.39543960, \
0.39730431, 0.39917247, 0.40104405, 0.40291901, 0.40479734, \
0.40667901, 0.40856398, 0.41045223, 0.41234373, 0.41423846, \
0.41613637, 0.41803745, 0.41994165, 0.42184897, 0.42375935, \
0.42567278, 0.42758923, 0.42950865, 0.43143103, 0.43335633, \
0.43528452, 0.43721556, 0.43914944, 0.44108611, 0.44302555, \
0.44496772, 0.44691258, 0.44886012, 0.45081029, 0.45276306, \
0.45471841, 0.45667628, 0.45863666, 0.46059951, 0.46256480, \
0.46453249, 0.46650254, 0.46847493, 0.47044962, 0.47242657, \
0.47440575, 0.47638712, 0.47837066, 0.48035631, 0.48234406, \
0.48433386, 0.48632568, 0.48831947, 0.49031521, 0.49231286, \
0.49431238, 0.49631374, 0.49831689, 0.50032181, 0.50232845, \
0.50433677, 0.50634674, 0.50835833, 0.51037148, 0.51238618, \
0.51440236, 0.51642001, 0.51843908, 0.52045952, 0.52248131, \
0.52450440, 0.52652876, 0.52855434, 0.53058111, 0.53260902, \
0.53463803, 0.53666812, 0.53869922, 0.54073132, 0.54276436, \
0.54479830, 0.54683310, 0.54886873, 0.55090515, 0.55294230, \
0.55498015, 0.55701866, 0.55905778, 0.56109749, 0.56313772, \
0.56517845, 0.56721962, 0.56926120, 0.57130315, 0.57334542, \
0.57538797, 0.57743076, 0.57947374, 0.58151687, 0.58356011, \
0.58560342, 0.58764675, 0.58969005, 0.59173329, 0.59377643, \
0.59581941, 0.59786219, 0.59990473, 0.60194699, 0.60398892, \
0.60603048, 0.60807162, 0.61011230, 0.61215247, 0.61419209, \
0.61623112, 0.61826951, 0.62030721, 0.62234418, 0.62438037, \
0.62641574, 0.62845025, 0.63048384, 0.63251648, 0.63454811, \
0.63657870, 0.63860819, 0.64063654, 0.64266370, 0.64468963, \
0.64671429, 0.64873762, 0.65075958, 0.65278012, 0.65479920, \
0.65681677, 0.65883278, 0.66084719, 0.66285996, 0.66487102, \
0.66688035, 0.66888788, 0.67089358, 0.67289739, 0.67489928, \
0.67689919, 0.67889707, 0.68089288, 0.68288658, 0.68487811, \
0.68686743, 0.68885449, 0.69083924, 0.69282163, 0.69480163, \
0.69677917, 0.69875422, 0.70072673, 0.70269664, 0.70466392, \
0.70662851, 0.70859037, 0.71054944, 0.71250569, 0.71445906, \
0.71640950, 0.71835698, 0.72030143, 0.72224282, 0.72418109, \
0.72611620, 0.72804811, 0.72997675, 0.73190209, 0.73382408, \
0.73574266, 0.73765780, 0.73956945, 0.74147755, 0.74338206, \
0.74528293, 0.74718011, 0.74907356, 0.75096324, 0.75284908, \
0.75473105, 0.75660909, 0.75848316, 0.76035322, 0.76221921, \
0.76408108, 0.76593880, 0.76779231, 0.76964157, 0.77148652, \
0.77332712, 0.77516333, 0.77699510, 0.77882237, 0.78064511, \
0.78246326, 0.78427678, 0.78608563, 0.78788975, 0.78968910, \
0.79148363, 0.79327330, 0.79505806, 0.79683786, 0.79861265, \
0.80038240, 0.80214705, 0.80390656, 0.80566088, 0.80740996, \
0.80915377, 0.81089225, 0.81262536, 0.81435305, 0.81607527, \
0.81779199, 0.81950316, 0.82120872, 0.82290865, 0.82460288, \
0.82629137, 0.82797409, 0.82965098, 0.83132201, 0.83298712, \
0.83464627, 0.83629942, 0.83794652, 0.83958754, 0.84122241, \
0.84285111, 0.84447358, 0.84608979, 0.84769969, 0.84930324, \
0.85090038, 0.85249109, 0.85407532, 0.85565302, 0.85722415, \
0.85878866, 0.86034653, 0.86189770, 0.86344213, 0.86497977, \
0.86651060, 0.86803456, 0.86955161, 0.87106172, 0.87256484, \
0.87406092, 0.87554994, 0.87703184, 0.87850659, 0.87997415, \
0.88143447, 0.88288752, 0.88433325, 0.88577163, 0.88720261, \
0.88862616, 0.89004224, 0.89145080, 0.89285181, 0.89424523, \
0.89563102, 0.89700915, 0.89837957, 0.89974224, 0.90109713, \
0.90244420, 0.90378341, 0.90511473, 0.90643811, 0.90775353, \
0.90906094, 0.91036030, 0.91165159, 0.91293476, 0.91420978, \
0.91547661, 0.91673521, 0.91798556, 0.91922761, 0.92046134, \
0.92168670, 0.92290366, 0.92411219, 0.92531225, 0.92650381, \
0.92768683, 0.92886129, 0.93002715, 0.93118437, 0.93233292, \
0.93347277, 0.93460389, 0.93572625, 0.93683980, 0.93794453, \
0.93904040, 0.94012738, 0.94120544, 0.94227454, 0.94333466, \
0.94438576, 0.94542782, 0.94646081, 0.94748469, 0.94849944, \
0.94950503, 0.95050143, 0.95148860, 0.95246653, 0.95343519, \
0.95439454, 0.95534456, 0.95628522, 0.95721649, 0.95813836, \
0.95905078, 0.95995374, 0.96084721, 0.96173116, 0.96260556, \
0.96347040, 0.96432565, 0.96517128, 0.96600726, 0.96683358, \
0.96765021, 0.96845713, 0.96925430, 0.97004172, 0.97081936, \
0.97158718, 0.97234518, 0.97309333, 0.97383161, 0.97456000, \
0.97527847, 0.97598700, 0.97668558, 0.97737418, 0.97805279, \
0.97872138, 0.97937993, 0.98002843, 0.98066686, 0.98129519, \
0.98191341, 0.98252151, 0.98311945, 0.98370724, 0.98428484, \
0.98485224, 0.98540943, 0.98595639, 0.98649310, 0.98701955, \
0.98753572, 0.98804160, 0.98853717, 0.98902242, 0.98949733, \
0.98996189, 0.99041609, 0.99085991, 0.99129334, 0.99171636, \
0.99212897, 0.99253116, 0.99292290, 0.99330419, 0.99367502, \
0.99403538, 0.99438525, 0.99472463, 0.99505350, 0.99537187, \
0.99567971, 0.99597701, 0.99626378, 0.99654000, 0.99680566, \
0.99706075, 0.99730527, 0.99753922, 0.99776257, 0.99797533, \
0.99817750, 0.99836906, 0.99855000, 0.99872033, 0.99888004, \
0.99902913, 0.99916758, 0.99929540, 0.99941258, 0.99951912, \
0.99961501, 0.99970026, 0.99977485, 0.99983879, 0.99989208, \
0.99993472, 0.99996669, 0.99998801, 0.99999867, } 

#define NUTTALL4096 {\
0.00036280, 0.00036285, 0.00036298, 0.00036321, 0.00036353, \
0.00036393, 0.00036443, 0.00036502, 0.00036570, 0.00036648, \
0.00036734, 0.00036829, 0.00036934, 0.00037047, 0.00037170, \
0.00037302, 0.00037443, 0.00037593, 0.00037752, 0.00037921, \
0.00038098, 0.00038285, 0.00038481, 0.00038686, 0.00038900, \
0.00039124, 0.00039356, 0.00039598, 0.00039849, 0.00040110, \
0.00040380, 0.00040659, 0.00040947, 0.00041244, 0.00041551, \
0.00041868, 0.00042193, 0.00042528, 0.00042873, 0.00043226, \
0.00043590, 0.00043962, 0.00044345, 0.00044736, 0.00045137, \
0.00045548, 0.00045968, 0.00046398, 0.00046837, 0.00047286, \
0.00047745, 0.00048213, 0.00048691, 0.00049179, 0.00049676, \
0.00050183, 0.00050700, 0.00051227, 0.00051763, 0.00052309, \
0.00052866, 0.00053432, 0.00054008, 0.00054594, 0.00055190, \
0.00055796, 0.00056412, 0.00057038, 0.00057674, 0.00058321, \
0.00058978, 0.00059644, 0.00060321, 0.00061009, 0.00061706, \
0.00062414, 0.00063133, 0.00063862, 0.00064601, 0.00065350, \
0.00066111, 0.00066881, 0.00067663, 0.00068455, 0.00069257, \
0.00070071, 0.00070895, 0.00071730, 0.00072576, 0.00073432, \
0.00074300, 0.00075178, 0.00076067, 0.00076968, 0.00077879, \
0.00078802, 0.00079736, 0.00080681, 0.00081637, 0.00082605, \
0.00083584, 0.00084574, 0.00085576, 0.00086589, 0.00087613, \
0.00088650, 0.00089698, 0.00090757, 0.00091829, 0.00092912, \
0.00094007, 0.00095113, 0.00096232, 0.00097363, 0.00098505, \
0.00099660, 0.00100827, 0.00102006, 0.00103197, 0.00104401, \
0.00105617, 0.00106845, 0.00108086, 0.00109339, 0.00110605, \
0.00111884, 0.00113175, 0.00114479, 0.00115795, 0.00117125, \
0.00118467, 0.00119823, 0.00121191, 0.00122573, 0.00123968, \
0.00125376, 0.00126797, 0.00128231, 0.00129679, 0.00131141, \
0.00132616, 0.00134104, 0.00135607, 0.00137123, 0.00138652, \
0.00140196, 0.00141754, 0.00143325, 0.00144911, 0.00146510, \
0.00148124, 0.00149753, 0.00151395, 0.00153052, 0.00154723, \
0.00156409, 0.00158110, 0.00159825, 0.00161555, 0.00163300, \
0.00165060, 0.00166834, 0.00168624, 0.00170429, 0.00172249, \
0.00174084, 0.00175935, 0.00177801, 0.00179683, 0.00181580, \
0.00183493, 0.00185421, 0.00187366, 0.00189326, 0.00191302, \
0.00193295, 0.00195303, 0.00197328, 0.00199368, 0.00201426, \
0.00203500, 0.00205590, 0.00207697, 0.00209820, 0.00211961, \
0.00214118, 0.00216292, 0.00218483, 0.00220692, 0.00222917, \
0.00225160, 0.00227420, 0.00229698, 0.00231993, 0.00234306, \
0.00236637, 0.00238985, 0.00241352, 0.00243736, 0.00246139, \
0.00248559, 0.00250998, 0.00253456, 0.00255931, 0.00258426, \
0.00260939, 0.00263470, 0.00266021, 0.00268590, 0.00271179, \
0.00273786, 0.00276413, 0.00279059, 0.00281725, 0.00284410, \
0.00287114, 0.00289838, 0.00292582, 0.00295346, 0.00298130, \
0.00300934, 0.00303759, 0.00306603, 0.00309468, 0.00312353, \
0.00315259, 0.00318186, 0.00321134, 0.00324102, 0.00327091, \
0.00330102, 0.00333133, 0.00336186, 0.00339261, 0.00342357, \
0.00345474, 0.00348614, 0.00351775, 0.00354958, 0.00358163, \
0.00361391, 0.00364640, 0.00367912, 0.00371207, 0.00374524, \
0.00377864, 0.00381227, 0.00384612, 0.00388021, 0.00391453, \
0.00394908, 0.00398386, 0.00401888, 0.00405414, 0.00408963, \
0.00412536, 0.00416134, 0.00419755, 0.00423400, 0.00427070, \
0.00430764, 0.00434483, 0.00438226, 0.00441994, 0.00445787, \
0.00449605, 0.00453448, 0.00457317, 0.00461211, 0.00465130, \
0.00469075, 0.00473045, 0.00477042, 0.00481064, 0.00485113, \
0.00489188, 0.00493289, 0.00497416, 0.00501571, 0.00505751, \
0.00509959, 0.00514194, 0.00518456, 0.00522745, 0.00527061, \
0.00531405, 0.00535777, 0.00540176, 0.00544603, 0.00549058, \
0.00553541, 0.00558053, 0.00562592, 0.00567161, 0.00571758, \
0.00576383, 0.00581038, 0.00585722, 0.00590434, 0.00595177, \
0.00599948, 0.00604749, 0.00609580, 0.00614441, 0.00619331, \
0.00624252, 0.00629203, 0.00634184, 0.00639196, 0.00644239, \
0.00649312, 0.00654416, 0.00659552, 0.00664718, 0.00669916, \
0.00675145, 0.00680406, 0.00685699, 0.00691023, 0.00696380, \
0.00701769, 0.00707190, 0.00712644, 0.00718130, 0.00723649, \
0.00729200, 0.00734785, 0.00740403, 0.00746055, 0.00751739, \
0.00757458, 0.00763210, 0.00768996, 0.00774816, 0.00780671, \
0.00786559, 0.00792482, 0.00798440, 0.00804433, 0.00810460, \
0.00816523, 0.00822621, 0.00828754, 0.00834923, 0.00841127, \
0.00847367, 0.00853644, 0.00859956, 0.00866305, 0.00872690, \
0.00879111, 0.00885570, 0.00892065, 0.00898598, 0.00905167, \
0.00911774, 0.00918418, 0.00925101, 0.00931820, 0.00938578, \
0.00945374, 0.00952209, 0.00959081, 0.00965993, 0.00972943, \
0.00979932, 0.00986960, 0.00994027, 0.01001134, 0.01008281, \
0.01015467, 0.01022692, 0.01029958, 0.01037264, 0.01044611, \
0.01051998, 0.01059426, 0.01066894, 0.01074404, 0.01081954, \
0.01089546, 0.01097180, 0.01104855, 0.01112572, 0.01120331, \
0.01128132, 0.01135975, 0.01143861, 0.01151789, 0.01159761, \
0.01167775, 0.01175832, 0.01183933, 0.01192077, 0.01200265, \
0.01208497, 0.01216773, 0.01225092, 0.01233456, 0.01241865, \
0.01250318, 0.01258816, 0.01267359, 0.01275948, 0.01284581, \
0.01293260, 0.01301985, 0.01310756, 0.01319572, 0.01328435, \
0.01337344, 0.01346300, 0.01355302, 0.01364351, 0.01373448, \
0.01382591, 0.01391782, 0.01401021, 0.01410307, 0.01419642, \
0.01429024, 0.01438455, 0.01447934, 0.01457462, 0.01467038, \
0.01476664, 0.01486338, 0.01496062, 0.01505836, 0.01515659, \
0.01525533, 0.01535456, 0.01545429, 0.01555453, 0.01565528, \
0.01575653, 0.01585829, 0.01596056, 0.01606335, 0.01616665, \
0.01627047, 0.01637481, 0.01647966, 0.01658504, 0.01669095, \
0.01679738, 0.01690433, 0.01701182, 0.01711984, 0.01722839, \
0.01733748, 0.01744710, 0.01755726, 0.01766796, 0.01777921, \
0.01789100, 0.01800333, 0.01811622, 0.01822965, 0.01834363, \
0.01845817, 0.01857327, 0.01868892, 0.01880513, 0.01892190, \
0.01903923, 0.01915713, 0.01927560, 0.01939463, 0.01951423, \
0.01963441, 0.01975516, 0.01987649, 0.01999839, 0.02012088, \
0.02024394, 0.02036759, 0.02049183, 0.02061665, 0.02074206, \
0.02086807, 0.02099466, 0.02112185, 0.02124964, 0.02137803, \
0.02150702, 0.02163661, 0.02176680, 0.02189761, 0.02202902, \
0.02216104, 0.02229367, 0.02242692, 0.02256078, 0.02269526, \
0.02283036, 0.02296609, 0.02310244, 0.02323941, 0.02337701, \
0.02351524, 0.02365410, 0.02379360, 0.02393373, 0.02407450, \
0.02421591, 0.02435796, 0.02450066, 0.02464400, 0.02478798, \
0.02493262, 0.02507790, 0.02522384, 0.02537044, 0.02551769, \
0.02566560, 0.02581418, 0.02596341, 0.02611331, 0.02626388, \
0.02641512, 0.02656702, 0.02671960, 0.02687286, 0.02702679, \
0.02718140, 0.02733669, 0.02749267, 0.02764933, 0.02780667, \
0.02796471, 0.02812343, 0.02828285, 0.02844297, 0.02860378, \
0.02876528, 0.02892749, 0.02909040, 0.02925402, 0.02941834, \
0.02958337, 0.02974912, 0.02991557, 0.03008274, 0.03025063, \
0.03041923, 0.03058856, 0.03075861, 0.03092938, 0.03110088, \
0.03127311, 0.03144607, 0.03161976, 0.03179418, 0.03196935, \
0.03214525, 0.03232189, 0.03249927, 0.03267740, 0.03285628, \
0.03303591, 0.03321628, 0.03339741, 0.03357929, 0.03376193, \
0.03394533, 0.03412949, 0.03431442, 0.03450010, 0.03468656, \
0.03487378, 0.03506178, 0.03525054, 0.03544009, 0.03563040, \
0.03582150, 0.03601338, 0.03620604, 0.03639949, 0.03659372, \
0.03678875, 0.03698456, 0.03718117, 0.03737857, 0.03757677, \
0.03777577, 0.03797557, 0.03817617, 0.03837758, 0.03857979, \
0.03878282, 0.03898665, 0.03919130, 0.03939677, 0.03960305, \
0.03981015, 0.04001807, 0.04022682, 0.04043639, 0.04064679, \
0.04085801, 0.04107007, 0.04128296, 0.04149669, 0.04171126, \
0.04192666, 0.04214291, 0.04235999, 0.04257793, 0.04279671, \
0.04301634, 0.04323683, 0.04345816, 0.04368035, 0.04390340, \
0.04412731, 0.04435208, 0.04457772, 0.04480422, 0.04503158, \
0.04525982, 0.04548893, 0.04571891, 0.04594977, 0.04618150, \
0.04641411, 0.04664761, 0.04688199, 0.04711725, 0.04735340, \
0.04759045, 0.04782838, 0.04806720, 0.04830693, 0.04854755, \
0.04878906, 0.04903148, 0.04927481, 0.04951903, 0.04976417, \
0.05001022, 0.05025717, 0.05050504, 0.05075383, 0.05100353, \
0.05125415, 0.05150569, 0.05175816, 0.05201155, 0.05226586, \
0.05252111, 0.05277729, 0.05303440, 0.05329244, 0.05355142, \
0.05381134, 0.05407221, 0.05433401, 0.05459676, 0.05486045, \
0.05512510, 0.05539069, 0.05565724, 0.05592474, 0.05619319, \
0.05646261, 0.05673298, 0.05700432, 0.05727662, 0.05754989, \
0.05782412, 0.05809933, 0.05837551, 0.05865266, 0.05893078, \
0.05920988, 0.05948997, 0.05977103, 0.06005307, 0.06033611, \
0.06062012, 0.06090513, 0.06119113, 0.06147812, 0.06176610, \
0.06205509, 0.06234506, 0.06263604, 0.06292803, 0.06322101, \
0.06351500, 0.06381000, 0.06410601, 0.06440303, 0.06470106, \
0.06500011, 0.06530017, 0.06560126, 0.06590336, 0.06620649, \
0.06651064, 0.06681582, 0.06712202, 0.06742926, 0.06773752, \
0.06804682, 0.06835716, 0.06866853, 0.06898094, 0.06929440, \
0.06960889, 0.06992443, 0.07024101, 0.07055865, 0.07087733, \
0.07119707, 0.07151785, 0.07183970, 0.07216260, 0.07248655, \
0.07281157, 0.07313766, 0.07346480, 0.07379301, 0.07412229, \
0.07445264, 0.07478406, 0.07511655, 0.07545012, 0.07578476, \
0.07612048, 0.07645728, 0.07679516, 0.07713413, 0.07747417, \
0.07781531, 0.07815754, 0.07850085, 0.07884526, 0.07919076, \
0.07953735, 0.07988504, 0.08023384, 0.08058373, 0.08093472, \
0.08128681, 0.08164002, 0.08199432, 0.08234974, 0.08270627, \
0.08306391, 0.08342266, 0.08378253, 0.08414351, 0.08450561, \
0.08486884, 0.08523318, 0.08559865, 0.08596524, 0.08633296, \
0.08670181, 0.08707178, 0.08744289, 0.08781513, 0.08818851, \
0.08856302, 0.08893867, 0.08931546, 0.08969339, 0.09007246, \
0.09045267, 0.09083403, 0.09121654, 0.09160020, 0.09198500, \
0.09237096, 0.09275807, 0.09314633, 0.09353576, 0.09392633, \
0.09431807, 0.09471097, 0.09510503, 0.09550025, 0.09589664, \
0.09629420, 0.09669292, 0.09709281, 0.09749388, 0.09789611, \
0.09829952, 0.09870411, 0.09910987, 0.09951681, 0.09992493, \
0.10033423, 0.10074471, 0.10115638, 0.10156923, 0.10198327, \
0.10239849, 0.10281490, 0.10323251, 0.10365131, 0.10407130, \
0.10449248, 0.10491486, 0.10533844, 0.10576322, 0.10618920, \
0.10661637, 0.10704475, 0.10747434, 0.10790513, 0.10833713, \
0.10877033, 0.10920474, 0.10964037, 0.11007720, 0.11051525, \
0.11095452, 0.11139499, 0.11183669, 0.11227960, 0.11272373, \
0.11316908, 0.11361566, 0.11406345, 0.11451248, 0.11496272, \
0.11541419, 0.11586689, 0.11632082, 0.11677598, 0.11723237, \
0.11768999, 0.11814884, 0.11860893, 0.11907025, 0.11953281, \
0.11999661, 0.12046165, 0.12092793, 0.12139544, 0.12186420, \
0.12233421, 0.12280546, 0.12327795, 0.12375169, 0.12422667, \
0.12470291, 0.12518039, 0.12565913, 0.12613912, 0.12662036, \
0.12710285, 0.12758660, 0.12807160, 0.12855786, 0.12904538, \
0.12953415, 0.13002419, 0.13051548, 0.13100804, 0.13150186, \
0.13199694, 0.13249328, 0.13299089, 0.13348977, 0.13398991, \
0.13449132, 0.13499400, 0.13549795, 0.13600317, 0.13650965, \
0.13701741, 0.13752645, 0.13803676, 0.13854834, 0.13906119, \
0.13957532, 0.14009073, 0.14060742, 0.14112538, 0.14164463, \
0.14216515, 0.14268695, 0.14321004, 0.14373440, 0.14426005, \
0.14478698, 0.14531520, 0.14584470, 0.14637549, 0.14690756, \
0.14744092, 0.14797556, 0.14851150, 0.14904872, 0.14958723, \
0.15012704, 0.15066813, 0.15121051, 0.15175419, 0.15229915, \
0.15284541, 0.15339297, 0.15394182, 0.15449196, 0.15504339, \
0.15559613, 0.15615015, 0.15670548, 0.15726210, 0.15782002, \
0.15837924, 0.15893975, 0.15950157, 0.16006468, 0.16062910, \
0.16119481, 0.16176183, 0.16233014, 0.16289976, 0.16347068, \
0.16404290, 0.16461643, 0.16519125, 0.16576738, 0.16634482, \
0.16692355, 0.16750360, 0.16808494, 0.16866759, 0.16925155, \
0.16983681, 0.17042338, 0.17101125, 0.17160043, 0.17219092, \
0.17278271, 0.17337581, 0.17397022, 0.17456594, 0.17516296, \
0.17576129, 0.17636092, 0.17696187, 0.17756412, 0.17816769, \
0.17877256, 0.17937874, 0.17998622, 0.18059502, 0.18120512, \
0.18181654, 0.18242926, 0.18304329, 0.18365863, 0.18427528, \
0.18489324, 0.18551251, 0.18613309, 0.18675497, 0.18737817, \
0.18800267, 0.18862848, 0.18925561, 0.18988404, 0.19051378, \
0.19114482, 0.19177718, 0.19241085, 0.19304582, 0.19368210, \
0.19431969, 0.19495859, 0.19559879, 0.19624031, 0.19688313, \
0.19752725, 0.19817269, 0.19881943, 0.19946748, 0.20011683, \
0.20076749, 0.20141945, 0.20207272, 0.20272730, 0.20338318, \
0.20404037, 0.20469886, 0.20535865, 0.20601975, 0.20668215, \
0.20734585, 0.20801085, 0.20867716, 0.20934477, 0.21001368, \
0.21068389, 0.21135540, 0.21202821, 0.21270232, 0.21337773, \
0.21405444, 0.21473244, 0.21541174, 0.21609234, 0.21677424, \
0.21745743, 0.21814192, 0.21882770, 0.21951477, 0.22020314, \
0.22089281, 0.22158376, 0.22227601, 0.22296954, 0.22366437, \
0.22436049, 0.22505789, 0.22575659, 0.22645657, 0.22715784, \
0.22786039, 0.22856423, 0.22926936, 0.22997577, 0.23068346, \
0.23139243, 0.23210269, 0.23281423, 0.23352704, 0.23424114, \
0.23495651, 0.23567316, 0.23639109, 0.23711030, 0.23783077, \
0.23855253, 0.23927555, 0.23999985, 0.24072542, 0.24145226, \
0.24218036, 0.24290974, 0.24364038, 0.24437229, 0.24510546, \
0.24583990, 0.24657560, 0.24731256, 0.24805079, 0.24879027, \
0.24953101, 0.25027301, 0.25101627, 0.25176078, 0.25250654, \
0.25325356, 0.25400183, 0.25475135, 0.25550212, 0.25625414, \
0.25700740, 0.25776192, 0.25851767, 0.25927467, 0.26003291, \
0.26079239, 0.26155311, 0.26231507, 0.26307827, 0.26384270, \
0.26460837, 0.26537526, 0.26614339, 0.26691275, 0.26768334, \
0.26845516, 0.26922820, 0.27000246, 0.27077795, 0.27155466, \
0.27233259, 0.27311173, 0.27389210, 0.27467368, 0.27545647, \
0.27624048, 0.27702569, 0.27781212, 0.27859975, 0.27938859, \
0.28017863, 0.28096988, 0.28176233, 0.28255597, 0.28335082, \
0.28414686, 0.28494409, 0.28574252, 0.28654214, 0.28734294, \
0.28814494, 0.28894812, 0.28975248, 0.29055803, 0.29136476, \
0.29217267, 0.29298175, 0.29379201, 0.29460344, 0.29541604, \
0.29622981, 0.29704475, 0.29786085, 0.29867812, 0.29949655, \
0.30031614, 0.30113689, 0.30195879, 0.30278185, 0.30360606, \
0.30443142, 0.30525792, 0.30608558, 0.30691437, 0.30774431, \
0.30857539, 0.30940761, 0.31024096, 0.31107544, 0.31191106, \
0.31274780, 0.31358567, 0.31442467, 0.31526479, 0.31610603, \
0.31694839, 0.31779186, 0.31863645, 0.31948215, 0.32032896, \
0.32117687, 0.32202589, 0.32287601, 0.32372724, 0.32457956, \
0.32543297, 0.32628748, 0.32714308, 0.32799977, 0.32885755, \
0.32971640, 0.33057634, 0.33143736, 0.33229945, 0.33316262, \
0.33402686, 0.33489217, 0.33575854, 0.33662598, 0.33749448, \
0.33836404, 0.33923465, 0.34010632, 0.34097904, 0.34185281, \
0.34272762, 0.34360348, 0.34448037, 0.34535831, 0.34623728, \
0.34711728, 0.34799832, 0.34888038, 0.34976346, 0.35064757, \
0.35153270, 0.35241884, 0.35330600, 0.35419416, 0.35508334, \
0.35597352, 0.35686470, 0.35775688, 0.35865006, 0.35954424, \
0.36043940, 0.36133555, 0.36223269, 0.36313081, 0.36402991, \
0.36492998, 0.36583103, 0.36673305, 0.36763604, 0.36853999, \
0.36944491, 0.37035078, 0.37125761, 0.37216539, 0.37307412, \
0.37398379, 0.37489441, 0.37580597, 0.37671847, 0.37763190, \
0.37854626, 0.37946155, 0.38037776, 0.38129490, 0.38221295, \
0.38313192, 0.38405180, 0.38497259, 0.38589429, 0.38681688, \
0.38774038, 0.38866477, 0.38959005, 0.39051622, 0.39144328, \
0.39237122, 0.39330004, 0.39422974, 0.39516030, 0.39609174, \
0.39702404, 0.39795720, 0.39889123, 0.39982610, 0.40076183, \
0.40169841, 0.40263583, 0.40357410, 0.40451320, 0.40545314, \
0.40639390, 0.40733550, 0.40827792, 0.40922116, 0.41016521, \
0.41111008, 0.41205576, 0.41300224, 0.41394953, 0.41489762, \
0.41584650, 0.41679617, 0.41774663, 0.41869787, 0.41964989, \
0.42060269, 0.42155627, 0.42251061, 0.42346572, 0.42442158, \
0.42537821, 0.42633559, 0.42729372, 0.42825260, 0.42921222, \
0.43017258, 0.43113368, 0.43209550, 0.43305806, 0.43402133, \
0.43498533, 0.43595004, 0.43691546, 0.43788160, 0.43884843, \
0.43981597, 0.44078420, 0.44175312, 0.44272273, 0.44369303, \
0.44466400, 0.44563565, 0.44660797, 0.44758096, 0.44855462, \
0.44952893, 0.45050390, 0.45147952, 0.45245579, 0.45343270, \
0.45441025, 0.45538844, 0.45636725, 0.45734670, 0.45832676, \
0.45930745, 0.46028875, 0.46127065, 0.46225317, 0.46323628, \
0.46422000, 0.46520430, 0.46618920, 0.46717468, 0.46816073, \
0.46914737, 0.47013457, 0.47112235, 0.47211068, 0.47309958, \
0.47408903, 0.47507903, 0.47606957, 0.47706065, 0.47805228, \
0.47904443, 0.48003711, 0.48103031, 0.48202404, 0.48301828, \
0.48401302, 0.48500828, 0.48600403, 0.48700028, 0.48799702, \
0.48899425, 0.48999196, 0.49099015, 0.49198882, 0.49298795, \
0.49398755, 0.49498761, 0.49598812, 0.49698909, 0.49799050, \
0.49899235, 0.49999464, 0.50099736, 0.50200051, 0.50300408, \
0.50400807, 0.50501247, 0.50601728, 0.50702250, 0.50802811, \
0.50903412, 0.51004052, 0.51104731, 0.51205447, 0.51306201, \
0.51406992, 0.51507820, 0.51608684, 0.51709583, 0.51810518, \
0.51911487, 0.52012491, 0.52113528, 0.52214598, 0.52315702, \
0.52416837, 0.52518004, 0.52619202, 0.52720431, 0.52821691, \
0.52922980, 0.53024298, 0.53125646, 0.53227021, 0.53328425, \
0.53429855, 0.53531313, 0.53632796, 0.53734306, 0.53835840, \
0.53937400, 0.54038984, 0.54140592, 0.54242222, 0.54343876, \
0.54445552, 0.54547250, 0.54648969, 0.54750708, 0.54852468, \
0.54954248, 0.55056047, 0.55157864, 0.55259700, 0.55361553, \
0.55463424, 0.55565311, 0.55667214, 0.55769133, 0.55871067, \
0.55973015, 0.56074978, 0.56176954, 0.56278943, 0.56380944, \
0.56482957, 0.56584982, 0.56687017, 0.56789063, 0.56891119, \
0.56993184, 0.57095258, 0.57197340, 0.57299430, 0.57401527, \
0.57503631, 0.57605740, 0.57707856, 0.57809976, 0.57912101, \
0.58014230, 0.58116362, 0.58218497, 0.58320634, 0.58422774, \
0.58524914, 0.58627056, 0.58729197, 0.58831338, 0.58933478, \
0.59035617, 0.59137754, 0.59239888, 0.59342020, 0.59444147, \
0.59546271, 0.59648389, 0.59750503, 0.59852611, 0.59954712, \
0.60056806, 0.60158893, 0.60260972, 0.60363043, 0.60465104, \
0.60567155, 0.60669197, 0.60771227, 0.60873246, 0.60975254, \
0.61077249, 0.61179231, 0.61281199, 0.61383153, 0.61485092, \
0.61587017, 0.61688925, 0.61790817, 0.61892692, 0.61994550, \
0.62096389, 0.62198210, 0.62300012, 0.62401794, 0.62503556, \
0.62605297, 0.62707016, 0.62808713, 0.62910388, 0.63012040, \
0.63113667, 0.63215271, 0.63316850, 0.63418403, 0.63519930, \
0.63621431, 0.63722905, 0.63824351, 0.63925768, 0.64027157, \
0.64128516, 0.64229846, 0.64331144, 0.64432412, 0.64533648, \
0.64634851, 0.64736022, 0.64837159, 0.64938262, 0.65039331, \
0.65140364, 0.65241362, 0.65342323, 0.65443247, 0.65544134, \
0.65644983, 0.65745793, 0.65846564, 0.65947295, 0.66047985, \
0.66148635, 0.66249243, 0.66349808, 0.66450331, 0.66550811, \
0.66651247, 0.66751638, 0.66851985, 0.66952285, 0.67052539, \
0.67152747, 0.67252907, 0.67353019, 0.67453082, 0.67553097, \
0.67653061, 0.67752975, 0.67852839, 0.67952650, 0.68052410, \
0.68152117, 0.68251770, 0.68351370, 0.68450915, 0.68550405, \
0.68649839, 0.68749218, 0.68848539, 0.68947803, 0.69047009, \
0.69146156, 0.69245244, 0.69344273, 0.69443241, 0.69542148, \
0.69640993, 0.69739776, 0.69838497, 0.69937154, 0.70035747, \
0.70134276, 0.70232740, 0.70331137, 0.70429469, 0.70527734, \
0.70625931, 0.70724060, 0.70822120, 0.70920111, 0.71018033, \
0.71115883, 0.71213663, 0.71311371, 0.71409007, 0.71506570, \
0.71604060, 0.71701475, 0.71798816, 0.71896082, 0.71993272, \
0.72090385, 0.72187422, 0.72284381, 0.72381261, 0.72478063, \
0.72574786, 0.72671428, 0.72767990, 0.72864471, 0.72960870, \
0.73057187, 0.73153421, 0.73249571, 0.73345637, 0.73441618, \
0.73537514, 0.73633324, 0.73729048, 0.73824684, 0.73920233, \
0.74015693, 0.74111065, 0.74206347, 0.74301539, 0.74396640, \
0.74491650, 0.74586568, 0.74681394, 0.74776126, 0.74870765, \
0.74965310, 0.75059760, 0.75154114, 0.75248372, 0.75342534, \
0.75436599, 0.75530566, 0.75624434, 0.75718203, 0.75811873, \
0.75905443, 0.75998911, 0.76092279, 0.76185545, 0.76278707, \
0.76371767, 0.76464724, 0.76557575, 0.76650322, 0.76742964, \
0.76835499, 0.76927928, 0.77020249, 0.77112463, 0.77204568, \
0.77296564, 0.77388450, 0.77480227, 0.77571892, 0.77663446, \
0.77754889, 0.77846218, 0.77937435, 0.78028537, 0.78119526, \
0.78210399, 0.78301157, 0.78391799, 0.78482325, 0.78572733, \
0.78663023, 0.78753195, 0.78843248, 0.78933181, 0.79022994, \
0.79112687, 0.79202258, 0.79291707, 0.79381034, 0.79470237, \
0.79559317, 0.79648273, 0.79737104, 0.79825810, 0.79914389, \
0.80002843, 0.80091169, 0.80179367, 0.80267437, 0.80355378, \
0.80443190, 0.80530872, 0.80618423, 0.80705843, 0.80793132, \
0.80880288, 0.80967311, 0.81054201, 0.81140957, 0.81227579, \
0.81314065, 0.81400415, 0.81486629, 0.81572707, 0.81658647, \
0.81744449, 0.81830112, 0.81915636, 0.82001021, 0.82086265, \
0.82171369, 0.82256331, 0.82341151, 0.82425829, 0.82510363, \
0.82594754, 0.82679001, 0.82763103, 0.82847060, 0.82930871, \
0.83014535, 0.83098053, 0.83181423, 0.83264645, 0.83347718, \
0.83430642, 0.83513416, 0.83596040, 0.83678513, 0.83760835, \
0.83843004, 0.83925022, 0.84006886, 0.84088596, 0.84170152, \
0.84251554, 0.84332800, 0.84413890, 0.84494825, 0.84575602, \
0.84656221, 0.84736683, 0.84816986, 0.84897130, 0.84977115, \
0.85056939, 0.85136603, 0.85216105, 0.85295446, 0.85374624, \
0.85453640, 0.85532492, 0.85611180, 0.85689704, 0.85768062, \
0.85846256, 0.85924283, 0.86002143, 0.86079837, 0.86157363, \
0.86234720, 0.86311909, 0.86388929, 0.86465779, 0.86542459, \
0.86618968, 0.86695305, 0.86771471, 0.86847464, 0.86923285, \
0.86998932, 0.87074405, 0.87149704, 0.87224828, 0.87299776, \
0.87374549, 0.87449145, 0.87523564, 0.87597805, 0.87671869, \
0.87745754, 0.87819460, 0.87892986, 0.87966332, 0.88039498, \
0.88112483, 0.88185286, 0.88257907, 0.88330345, 0.88402601, \
0.88474672, 0.88546560, 0.88618264, 0.88689782, 0.88761114, \
0.88832261, 0.88903221, 0.88973994, 0.89044580, 0.89114977, \
0.89185186, 0.89255206, 0.89325037, 0.89394677, 0.89464128, \
0.89533387, 0.89602455, 0.89671331, 0.89740014, 0.89808505, \
0.89876803, 0.89944906, 0.90012816, 0.90080531, 0.90148050, \
0.90215374, 0.90282502, 0.90349433, 0.90416167, 0.90482703, \
0.90549041, 0.90615181, 0.90681122, 0.90746864, 0.90812406, \
0.90877747, 0.90942888, 0.91007827, 0.91072565, 0.91137100, \
0.91201433, 0.91265563, 0.91329489, 0.91393212, 0.91456730, \
0.91520043, 0.91583151, 0.91646053, 0.91708749, 0.91771238, \
0.91833520, 0.91895595, 0.91957462, 0.92019121, 0.92080570, \
0.92141811, 0.92202841, 0.92263662, 0.92324272, 0.92384671, \
0.92444859, 0.92504835, 0.92564599, 0.92624150, 0.92683488, \
0.92742612, 0.92801523, 0.92860219, 0.92918700, 0.92976967, \
0.93035017, 0.93092852, 0.93150470, 0.93207872, 0.93265056, \
0.93322022, 0.93378771, 0.93435301, 0.93491613, 0.93547705, \
0.93603577, 0.93659229, 0.93714661, 0.93769873, 0.93824862, \
0.93879631, 0.93934177, 0.93988501, 0.94042602, 0.94096480, \
0.94150135, 0.94203565, 0.94256771, 0.94309753, 0.94362509, \
0.94415040, 0.94467345, 0.94519424, 0.94571277, 0.94622902, \
0.94674300, 0.94725471, 0.94776413, 0.94827127, 0.94877612, \
0.94927868, 0.94977895, 0.95027692, 0.95077258, 0.95126594, \
0.95175699, 0.95224573, 0.95273215, 0.95321625, 0.95369803, \
0.95417748, 0.95465460, 0.95512939, 0.95560184, 0.95607195, \
0.95653972, 0.95700514, 0.95746821, 0.95792893, 0.95838728, \
0.95884328, 0.95929692, 0.95974819, 0.96019708, 0.96064361, \
0.96108775, 0.96152952, 0.96196890, 0.96240590, 0.96284051, \
0.96327273, 0.96370255, 0.96412997, 0.96455499, 0.96497760, \
0.96539781, 0.96581561, 0.96623099, 0.96664395, 0.96705450, \
0.96746262, 0.96786831, 0.96827158, 0.96867242, 0.96907082, \
0.96946678, 0.96986030, 0.97025138, 0.97064001, 0.97102620, \
0.97140993, 0.97179121, 0.97217003, 0.97254639, 0.97292028, \
0.97329172, 0.97366068, 0.97402717, 0.97439119, 0.97475273, \
0.97511180, 0.97546838, 0.97582248, 0.97617409, 0.97652321, \
0.97686985, 0.97721398, 0.97755562, 0.97789476, 0.97823140, \
0.97856554, 0.97889717, 0.97922629, 0.97955290, 0.97987699, \
0.98019857, 0.98051763, 0.98083417, 0.98114818, 0.98145967, \
0.98176864, 0.98207507, 0.98237897, 0.98268034, 0.98297917, \
0.98327546, 0.98356921, 0.98386042, 0.98414908, 0.98443520, \
0.98471876, 0.98499978, 0.98527824, 0.98555414, 0.98582749, \
0.98609828, 0.98636651, 0.98663217, 0.98689527, 0.98715580, \
0.98741376, 0.98766915, 0.98792197, 0.98817221, 0.98841987, \
0.98866496, 0.98890747, 0.98914739, 0.98938473, 0.98961949, \
0.98985166, 0.99008124, 0.99030823, 0.99053262, 0.99075443, \
0.99097363, 0.99119024, 0.99140425, 0.99161566, 0.99182447, \
0.99203068, 0.99223428, 0.99243527, 0.99263366, 0.99282943, \
0.99302260, 0.99321315, 0.99340109, 0.99358642, 0.99376913, \
0.99394922, 0.99412669, 0.99430154, 0.99447377, 0.99464338, \
0.99481036, 0.99497472, 0.99513645, 0.99529556, 0.99545203, \
0.99560587, 0.99575709, 0.99590567, 0.99605162, 0.99619493, \
0.99633561, 0.99647365, 0.99660905, 0.99674182, 0.99687195, \
0.99699943, 0.99712428, 0.99724648, 0.99736604, 0.99748295, \
0.99759722, 0.99770884, 0.99781782, 0.99792415, 0.99802783, \
0.99812886, 0.99822725, 0.99832298, 0.99841606, 0.99850649, \
0.99859427, 0.99867939, 0.99876186, 0.99884168, 0.99891884, \
0.99899334, 0.99906519, 0.99913439, 0.99920092, 0.99926480, \
0.99932602, 0.99938458, 0.99944048, 0.99949373, 0.99954431, \
0.99959223, 0.99963750, 0.99968010, 0.99972004, 0.99975732, \
0.99979194, 0.99982389, 0.99985319, 0.99987982, 0.99990379, \
0.99992509, 0.99994374, 0.99995972, 0.99997303, 0.99998369, \
0.99999168, 0.99999700, 0.99999967, } 


 #endif // _FPU_FFT_NUTTALL_H_
//=============================================================================
// End of File
//=============================================================================
