//=============================================================================
// Parzen Window 
//=============================================================================
#ifndef _FPU_FFT_PARZEN_H_
#define _FPU_FFT_PARZEN_H_

#define PARZEN32 {\
0.00006104, 0.00164795, 0.00762939, 0.02093506, 0.04449463, \
0.08123779, 0.13409424, 0.20599365, 0.29962158, 0.41204834, \
0.53472900, 0.65887451, 0.77569580, 0.87640381, 0.95220947, \
0.99432373, } 

#define PARZEN64 {\
0.00000763, 0.00020599, 0.00095367, 0.00261688, 0.00556183, \
0.01015472, 0.01676178, 0.02574921, 0.03748322, 0.05233002, \
0.07065582, 0.09282684, 0.11920929, 0.15016937, 0.18607330, \
0.22728729, 0.27414703, 0.32628632, 0.38263702, 0.44210052, \
0.50357819, 0.56597137, 0.62818146, 0.68910980, 0.74765778, \
0.80272675, 0.85321808, 0.89803314, 0.93607330, 0.96623993, \
0.98743439, 0.99855804, } 

#define PARZEN128 {\
0.00000095, 0.00002575, 0.00011921, 0.00032711, 0.00069523, \
0.00126934, 0.00209522, 0.00321865, 0.00468540, 0.00654125, \
0.00883198, 0.01160336, 0.01490116, 0.01877117, 0.02325916, \
0.02841091, 0.03427219, 0.04088879, 0.04830647, 0.05657101, \
0.06572819, 0.07582378, 0.08690357, 0.09901333, 0.11219883, \
0.12650585, 0.14198017, 0.15866756, 0.17661381, 0.19586468, \
0.21646595, 0.23846340, 0.26189899, 0.28672695, 0.31281376, \
0.34002209, 0.36821461, 0.39725399, 0.42700291, 0.45732403, \
0.48808002, 0.51913357, 0.55034733, 0.58158398, 0.61270618, \
0.64357662, 0.67405796, 0.70401287, 0.73330402, 0.76179409, \
0.78934574, 0.81582165, 0.84108448, 0.86499691, 0.88742161, \
0.90822124, 0.92725849, 0.94439602, 0.95949650, 0.97242260, \
0.98303699, 0.99120235, 0.99678135, 0.99963665, } 

#define PARZEN256 {\
0.00000012, 0.00000322, 0.00001490, 0.00004089, 0.00008690, \
0.00015867, 0.00026190, 0.00040233, 0.00058568, 0.00081766, \
0.00110400, 0.00145042, 0.00186265, 0.00234640, 0.00290740, \
0.00355136, 0.00428402, 0.00511110, 0.00603831, 0.00707138, \
0.00821602, 0.00947797, 0.01086295, 0.01237667, 0.01402485, \
0.01581323, 0.01774752, 0.01983345, 0.02207673, 0.02448308, \
0.02705824, 0.02980793, 0.03273785, 0.03585374, 0.03916132, \
0.04266632, 0.04637444, 0.05029142, 0.05442297, 0.05877483, \
0.06335270, 0.06816232, 0.07320940, 0.07849967, 0.08403885, \
0.08983266, 0.09588683, 0.10220706, 0.10879910, 0.11566865, \
0.12282145, 0.13026321, 0.13799965, 0.14603651, 0.15437949, \
0.16303432, 0.17200673, 0.18130243, 0.19092715, 0.20088661, \
0.21118653, 0.22183263, 0.23283064, 0.24418628, 0.25590479, \
0.26798046, 0.28039658, 0.29313600, 0.30618155, 0.31951606, \
0.33312237, 0.34698331, 0.36108172, 0.37540042, 0.38992226, \
0.40463006, 0.41950667, 0.43453491, 0.44969761, 0.46497762, \
0.48035777, 0.49582088, 0.51134980, 0.52692735, 0.54253638, \
0.55815971, 0.57378018, 0.58938062, 0.60494387, 0.62045276, \
0.63589013, 0.65123880, 0.66648161, 0.68160141, 0.69658101, \
0.71140325, 0.72605097, 0.74050701, 0.75475419, 0.76877534, \
0.78255332, 0.79607093, 0.80931103, 0.82225645, 0.83489001, \
0.84719455, 0.85915291, 0.87074792, 0.88196242, 0.89277923, \
0.90318120, 0.91315114, 0.92267191, 0.93172634, 0.94029725, \
0.94836748, 0.95591986, 0.96293724, 0.96940243, 0.97529829, \
0.98060763, 0.98531330, 0.98939812, 0.99284494, 0.99563658, \
0.99775589, 0.99918568, 0.99990880, } 

#define PARZEN512 {\
0.00000001, 0.00000040, 0.00000186, 0.00000511, 0.00001086, \
0.00001983, 0.00003274, 0.00005029, 0.00007321, 0.00010221, \
0.00013800, 0.00018130, 0.00023283, 0.00029330, 0.00036342, \
0.00044392, 0.00053550, 0.00063889, 0.00075479, 0.00088392, \
0.00102700, 0.00118475, 0.00135787, 0.00154708, 0.00175311, \
0.00197665, 0.00221844, 0.00247918, 0.00275959, 0.00306039, \
0.00338228, 0.00372599, 0.00409223, 0.00448172, 0.00489517, \
0.00533329, 0.00579681, 0.00628643, 0.00680287, 0.00734685, \
0.00791909, 0.00852029, 0.00915118, 0.00981246, 0.01050486, \
0.01122908, 0.01198585, 0.01277588, 0.01359989, 0.01445858, \
0.01535268, 0.01628290, 0.01724996, 0.01825456, 0.01929744, \
0.02037929, 0.02150084, 0.02266280, 0.02386589, 0.02511083, \
0.02639832, 0.02772908, 0.02910383, 0.03052329, 0.03198816, \
0.03349917, 0.03505702, 0.03666244, 0.03831615, 0.04001884, \
0.04177125, 0.04357408, 0.04542805, 0.04733388, 0.04929228, \
0.05130397, 0.05336966, 0.05549006, 0.05766590, 0.05989788, \
0.06218673, 0.06453316, 0.06693788, 0.06940161, 0.07192506, \
0.07450895, 0.07715400, 0.07986091, 0.08263041, 0.08546321, \
0.08836003, 0.09132157, 0.09434856, 0.09744172, 0.10060175, \
0.10382937, 0.10712530, 0.11049025, 0.11392494, 0.11743008, \
0.12100638, 0.12465458, 0.12837537, 0.13216947, 0.13603760, \
0.13998048, 0.14399882, 0.14809333, 0.15226473, 0.15651374, \
0.16084106, 0.16524743, 0.16973354, 0.17430012, 0.17894788, \
0.18367754, 0.18848981, 0.19338541, 0.19836505, 0.20342945, \
0.20857932, 0.21381538, 0.21913834, 0.22454892, 0.23004784, \
0.23563580, 0.24131353, 0.24708174, 0.25294109, 0.25889085, \
0.26492895, 0.27105324, 0.27726157, 0.28355180, 0.28992178, \
0.29636936, 0.30289240, 0.30948876, 0.31615628, 0.32289283, \
0.32969625, 0.33656441, 0.34349515, 0.35048632, 0.35753579, \
0.36464141, 0.37180103, 0.37901251, 0.38627370, 0.39358245, \
0.40093662, 0.40833406, 0.41577263, 0.42325018, 0.43076457, \
0.43831365, 0.44589527, 0.45350729, 0.46114756, 0.46881394, \
0.47650428, 0.48421644, 0.49194826, 0.49969761, 0.50746234, \
0.51524030, 0.52302934, 0.53082733, 0.53863211, 0.54644154, \
0.55425347, 0.56206577, 0.56987627, 0.57768284, 0.58548333, \
0.59327559, 0.60105748, 0.60882686, 0.61658157, 0.62431948, \
0.63203843, 0.63973628, 0.64741088, 0.65506010, 0.66268177, \
0.67027377, 0.67783393, 0.68536012, 0.69285019, 0.70030199, \
0.70771338, 0.71508221, 0.72240634, 0.72968362, 0.73691191, \
0.74408905, 0.75121291, 0.75828134, 0.76529218, 0.77224331, \
0.77913256, 0.78595780, 0.79271688, 0.79940765, 0.80602796, \
0.81257568, 0.81904866, 0.82544474, 0.83176179, 0.83799766, \
0.84415020, 0.85021727, 0.85619672, 0.86208640, 0.86788417, \
0.87358789, 0.87919541, 0.88470457, 0.89011325, 0.89541928, \
0.90062054, 0.90571485, 0.91070010, 0.91557412, 0.92033477, \
0.92497991, 0.92950739, 0.93391506, 0.93820079, 0.94236241, \
0.94639780, 0.95030479, 0.95408125, 0.95772503, 0.96123399, \
0.96460597, 0.96783884, 0.97093044, 0.97387864, 0.97668128, \
0.97933622, 0.98184131, 0.98419441, 0.98639338, 0.98843606, \
0.99032031, 0.99204399, 0.99360494, 0.99500103, 0.99623011, \
0.99729003, 0.99817865, 0.99889381, 0.99943338, 0.99979521, \
0.99997716, } 

#define PARZEN1024 {\
0.00000000, 0.00000005, 0.00000023, 0.00000064, 0.00000136, \
0.00000248, 0.00000409, 0.00000629, 0.00000915, 0.00001278, \
0.00001725, 0.00002266, 0.00002910, 0.00003666, 0.00004543, \
0.00005549, 0.00006694, 0.00007986, 0.00009435, 0.00011049, \
0.00012838, 0.00014809, 0.00016973, 0.00019339, 0.00021914, \
0.00024708, 0.00027731, 0.00030990, 0.00034495, 0.00038255, \
0.00042279, 0.00046575, 0.00051153, 0.00056021, 0.00061190, \
0.00066666, 0.00072460, 0.00078580, 0.00085036, 0.00091836, \
0.00098989, 0.00106504, 0.00114390, 0.00122656, 0.00131311, \
0.00140364, 0.00149823, 0.00159699, 0.00169999, 0.00180732, \
0.00191909, 0.00203536, 0.00215624, 0.00228182, 0.00241218, \
0.00254741, 0.00268761, 0.00283285, 0.00298324, 0.00313885, \
0.00329979, 0.00346613, 0.00363798, 0.00381541, 0.00399852, \
0.00418740, 0.00438213, 0.00458281, 0.00478952, 0.00500236, \
0.00522141, 0.00544676, 0.00567851, 0.00591674, 0.00616154, \
0.00641300, 0.00667121, 0.00693626, 0.00720824, 0.00748724, \
0.00777334, 0.00806664, 0.00836723, 0.00867520, 0.00899063, \
0.00931362, 0.00964425, 0.00998261, 0.01032880, 0.01068290, \
0.01104500, 0.01141520, 0.01179357, 0.01218021, 0.01257522, \
0.01297867, 0.01339066, 0.01381128, 0.01424062, 0.01467876, \
0.01512580, 0.01558182, 0.01604692, 0.01652118, 0.01700470, \
0.01749756, 0.01799985, 0.01851167, 0.01903309, 0.01956422, \
0.02010513, 0.02065593, 0.02121669, 0.02178751, 0.02236849, \
0.02295969, 0.02356123, 0.02417318, 0.02479563, 0.02542868, \
0.02607241, 0.02672692, 0.02739229, 0.02806862, 0.02875598, \
0.02945448, 0.03016419, 0.03088522, 0.03161764, 0.03236156, \
0.03311705, 0.03388421, 0.03466313, 0.03545389, 0.03625659, \
0.03707132, 0.03789815, 0.03873720, 0.03958854, 0.04045225, \
0.04132845, 0.04221720, 0.04311861, 0.04403275, 0.04495973, \
0.04589962, 0.04685252, 0.04781852, 0.04879771, 0.04979018, \
0.05079601, 0.05181530, 0.05284813, 0.05389460, 0.05495479, \
0.05602880, 0.05711670, 0.05821860, 0.05933459, 0.06046474, \
0.06160915, 0.06276791, 0.06394112, 0.06512885, 0.06633119, \
0.06754825, 0.06878010, 0.07002684, 0.07128856, 0.07256534, \
0.07385727, 0.07516445, 0.07648696, 0.07782490, 0.07917834, \
0.08054739, 0.08193213, 0.08333265, 0.08474904, 0.08618139, \
0.08762978, 0.08909432, 0.09057508, 0.09207216, 0.09358564, \
0.09511562, 0.09666219, 0.09822543, 0.09980543, 0.10140229, \
0.10301609, 0.10464692, 0.10629487, 0.10796004, 0.10964250, \
0.11134235, 0.11305969, 0.11479459, 0.11654715, 0.11831745, \
0.12010560, 0.12191167, 0.12373575, 0.12557794, 0.12743832, \
0.12931699, 0.13121403, 0.13312954, 0.13506359, 0.13701629, \
0.13898771, 0.14097796, 0.14298712, 0.14501528, 0.14706252, \
0.14912894, 0.15121463, 0.15331968, 0.15544417, 0.15758820, \
0.15975185, 0.16193522, 0.16413839, 0.16636145, 0.16860450, \
0.17086761, 0.17315089, 0.17545442, 0.17777829, 0.18012259, \
0.18248741, 0.18487283, 0.18727896, 0.18970587, 0.19215366, \
0.19462241, 0.19711222, 0.19962317, 0.20215536, 0.20470887, \
0.20728380, 0.20988022, 0.21249824, 0.21513794, 0.21779941, \
0.22048274, 0.22318802, 0.22591534, 0.22866479, 0.23143645, \
0.23423042, 0.23704679, 0.23988564, 0.24274707, 0.24563117, \
0.24853802, 0.25146770, 0.25442013, 0.25739505, 0.26039218, \
0.26341126, 0.26645203, 0.26951420, 0.27259753, 0.27570173, \
0.27882653, 0.28197168, 0.28513690, 0.28832192, 0.29152648, \
0.29475030, 0.29799313, 0.30125468, 0.30453470, 0.30783291, \
0.31114905, 0.31448285, 0.31783403, 0.32120234, 0.32458750, \
0.32798924, 0.33140731, 0.33484142, 0.33829131, 0.34175671, \
0.34523736, 0.34873298, 0.35224331, 0.35576808, 0.35930702, \
0.36285986, 0.36642634, 0.37000618, 0.37359913, 0.37720490, \
0.38082323, 0.38445386, 0.38809651, 0.39175092, 0.39541682, \
0.39909394, 0.40278201, 0.40648076, 0.41018993, 0.41390925, \
0.41763845, 0.42137726, 0.42512541, 0.42888264, 0.43264867, \
0.43642324, 0.44020609, 0.44399693, 0.44779551, 0.45160155, \
0.45541479, 0.45923496, 0.46306179, 0.46689502, 0.47073436, \
0.47457957, 0.47843036, 0.48228647, 0.48614763, 0.49001358, \
0.49388404, 0.49775875, 0.50163743, 0.50551983, 0.50940567, \
0.51329468, 0.51718660, 0.52108116, 0.52497808, 0.52887711, \
0.53277797, 0.53668039, 0.54058412, 0.54448886, 0.54839437, \
0.55230037, 0.55620660, 0.56011278, 0.56401864, 0.56792393, \
0.57182836, 0.57573168, 0.57963361, 0.58353389, 0.58743225, \
0.59132841, 0.59522212, 0.59911310, 0.60300109, 0.60688581, \
0.61076700, 0.61464439, 0.61851771, 0.62238670, 0.62625108, \
0.63011059, 0.63396495, 0.63781391, 0.64165719, 0.64549453, \
0.64932565, 0.65315029, 0.65696818, 0.66077905, 0.66458264, \
0.66837867, 0.67216687, 0.67594699, 0.67971875, 0.68348187, \
0.68723611, 0.69098117, 0.69471681, 0.69844274, 0.70215871, \
0.70586444, 0.70955966, 0.71324411, 0.71691752, 0.72057962, \
0.72423014, 0.72786881, 0.73149537, 0.73510955, 0.73871107, \
0.74229968, 0.74587510, 0.74943706, 0.75298530, 0.75651954, \
0.76003953, 0.76354499, 0.76703565, 0.77051124, 0.77397150, \
0.77741616, 0.78084495, 0.78425761, 0.78765385, 0.79103343, \
0.79439606, 0.79774147, 0.80106941, 0.80437961, 0.80767178, \
0.81094568, 0.81420102, 0.81743754, 0.82065497, 0.82385305, \
0.82703150, 0.83019006, 0.83332845, 0.83644642, 0.83954369, \
0.84261999, 0.84567506, 0.84870863, 0.85172043, 0.85471019, \
0.85767764, 0.86062251, 0.86354454, 0.86644346, 0.86931900, \
0.87217090, 0.87499887, 0.87780266, 0.88058200, 0.88333662, \
0.88606625, 0.88877062, 0.89144946, 0.89410252, 0.89672950, \
0.89933016, 0.90190422, 0.90445142, 0.90697148, 0.90946413, \
0.91192911, 0.91436616, 0.91677499, 0.91915535, 0.92150697, \
0.92382957, 0.92612289, 0.92838667, 0.93062062, 0.93282449, \
0.93499801, 0.93714091, 0.93925291, 0.94133376, 0.94338318, \
0.94540090, 0.94738667, 0.94934020, 0.95126123, 0.95314949, \
0.95500472, 0.95682664, 0.95861500, 0.96036951, 0.96208991, \
0.96377593, 0.96542731, 0.96704378, 0.96862507, 0.97017090, \
0.97168102, 0.97315515, 0.97459303, 0.97599438, 0.97735894, \
0.97868645, 0.97997662, 0.98122920, 0.98244392, 0.98362050, \
0.98475869, 0.98585820, 0.98691878, 0.98794016, 0.98892206, \
0.98986422, 0.99076637, 0.99162824, 0.99244956, 0.99323008, \
0.99396951, 0.99466758, 0.99532404, 0.99593862, 0.99651103, \
0.99704103, 0.99752833, 0.99797267, 0.99837378, 0.99873140, \
0.99904525, 0.99931507, 0.99954059, 0.99972154, 0.99985765, \
0.99994865, 0.99999428, } 

#define PARZEN2048 {\
0.00000000, 0.00000001, 0.00000003, 0.00000008, 0.00000017, \
0.00000031, 0.00000051, 0.00000079, 0.00000114, 0.00000160, \
0.00000216, 0.00000283, 0.00000364, 0.00000458, 0.00000568, \
0.00000694, 0.00000837, 0.00000998, 0.00001179, 0.00001381, \
0.00001605, 0.00001851, 0.00002122, 0.00002417, 0.00002739, \
0.00003089, 0.00003466, 0.00003874, 0.00004312, 0.00004782, \
0.00005285, 0.00005822, 0.00006394, 0.00007003, 0.00007649, \
0.00008333, 0.00009058, 0.00009823, 0.00010629, 0.00011479, \
0.00012374, 0.00013313, 0.00014299, 0.00015332, 0.00016414, \
0.00017545, 0.00018728, 0.00019962, 0.00021250, 0.00022592, \
0.00023989, 0.00025442, 0.00026953, 0.00028523, 0.00030152, \
0.00031843, 0.00033595, 0.00035411, 0.00037290, 0.00039236, \
0.00041247, 0.00043327, 0.00045475, 0.00047693, 0.00049981, \
0.00052342, 0.00054777, 0.00057285, 0.00059869, 0.00062529, \
0.00065268, 0.00068084, 0.00070981, 0.00073959, 0.00077019, \
0.00080162, 0.00083390, 0.00086703, 0.00090103, 0.00093590, \
0.00097167, 0.00100833, 0.00104590, 0.00108440, 0.00112383, \
0.00116420, 0.00120553, 0.00124783, 0.00129110, 0.00133536, \
0.00138063, 0.00142690, 0.00147420, 0.00152253, 0.00157190, \
0.00162233, 0.00167383, 0.00172641, 0.00178008, 0.00183484, \
0.00189072, 0.00194773, 0.00200587, 0.00206515, 0.00212559, \
0.00218720, 0.00224998, 0.00231396, 0.00237914, 0.00244553, \
0.00251314, 0.00258199, 0.00265209, 0.00272344, 0.00279606, \
0.00286996, 0.00294515, 0.00302165, 0.00309945, 0.00317859, \
0.00325905, 0.00334087, 0.00342404, 0.00350858, 0.00359450, \
0.00368181, 0.00377052, 0.00386065, 0.00395221, 0.00404519, \
0.00413963, 0.00423553, 0.00433289, 0.00443174, 0.00453207, \
0.00463391, 0.00473727, 0.00484215, 0.00494857, 0.00505653, \
0.00516606, 0.00527715, 0.00538983, 0.00550409, 0.00561997, \
0.00573745, 0.00585657, 0.00597732, 0.00609971, 0.00622377, \
0.00634950, 0.00647691, 0.00660602, 0.00673682, 0.00686935, \
0.00700360, 0.00713959, 0.00727733, 0.00741682, 0.00755809, \
0.00770114, 0.00784599, 0.00799264, 0.00814111, 0.00829140, \
0.00844353, 0.00859751, 0.00875336, 0.00891107, 0.00907067, \
0.00923216, 0.00939556, 0.00956087, 0.00972811, 0.00989729, \
0.01006842, 0.01024152, 0.01041658, 0.01059363, 0.01077267, \
0.01095372, 0.01113679, 0.01132188, 0.01150902, 0.01169821, \
0.01188945, 0.01208277, 0.01227818, 0.01247568, 0.01267529, \
0.01287701, 0.01308086, 0.01328686, 0.01349500, 0.01370531, \
0.01391779, 0.01413246, 0.01434932, 0.01456839, 0.01478968, \
0.01501320, 0.01523896, 0.01546697, 0.01569724, 0.01592979, \
0.01616462, 0.01640175, 0.01664119, 0.01688295, 0.01712704, \
0.01737346, 0.01762225, 0.01787339, 0.01812691, 0.01838281, \
0.01864112, 0.01890183, 0.01916496, 0.01943052, 0.01969852, \
0.01996898, 0.02024190, 0.02051730, 0.02079518, 0.02107556, \
0.02135845, 0.02164386, 0.02193180, 0.02222229, 0.02251532, \
0.02281093, 0.02310910, 0.02340987, 0.02371323, 0.02401921, \
0.02432780, 0.02463903, 0.02495290, 0.02526942, 0.02558861, \
0.02591047, 0.02623503, 0.02656228, 0.02689224, 0.02722493, \
0.02756034, 0.02789850, 0.02823942, 0.02858310, 0.02892956, \
0.02927880, 0.02963085, 0.02998571, 0.03034338, 0.03070390, \
0.03106725, 0.03143346, 0.03180254, 0.03217450, 0.03254934, \
0.03292709, 0.03330774, 0.03369132, 0.03407783, 0.03446729, \
0.03485970, 0.03525508, 0.03565344, 0.03605479, 0.03645914, \
0.03686650, 0.03727689, 0.03769030, 0.03810677, 0.03852629, \
0.03894888, 0.03937454, 0.03980330, 0.04023516, 0.04067013, \
0.04110822, 0.04154945, 0.04199383, 0.04244136, 0.04289206, \
0.04334594, 0.04380302, 0.04426329, 0.04472677, 0.04519348, \
0.04566343, 0.04613662, 0.04661307, 0.04709279, 0.04757579, \
0.04806208, 0.04855168, 0.04904458, 0.04954081, 0.05004038, \
0.05054330, 0.05104957, 0.05155921, 0.05207223, 0.05258865, \
0.05310847, 0.05363170, 0.05415836, 0.05468845, 0.05522199, \
0.05575900, 0.05629947, 0.05684342, 0.05739086, 0.05794181, \
0.05849628, 0.05905427, 0.05961579, 0.06018087, 0.06074950, \
0.06132171, 0.06189749, 0.06247687, 0.06305986, 0.06364646, \
0.06423668, 0.06483055, 0.06542806, 0.06602923, 0.06663408, \
0.06724260, 0.06785482, 0.06847075, 0.06909039, 0.06971376, \
0.07034086, 0.07097172, 0.07160634, 0.07224473, 0.07288690, \
0.07353286, 0.07418263, 0.07483622, 0.07549364, 0.07615489, \
0.07682000, 0.07748896, 0.07816180, 0.07883852, 0.07951914, \
0.08020366, 0.08089210, 0.08158447, 0.08228078, 0.08298103, \
0.08368525, 0.08439345, 0.08510562, 0.08582180, 0.08654198, \
0.08726617, 0.08799440, 0.08872667, 0.08946298, 0.09020336, \
0.09094781, 0.09169635, 0.09244899, 0.09320573, 0.09396659, \
0.09473158, 0.09550071, 0.09627399, 0.09705143, 0.09783305, \
0.09861885, 0.09940885, 0.10020306, 0.10100149, 0.10180415, \
0.10261104, 0.10342220, 0.10423761, 0.10505730, 0.10588127, \
0.10670955, 0.10754213, 0.10837903, 0.10922026, 0.11006583, \
0.11091576, 0.11177004, 0.11262871, 0.11349176, 0.11435921, \
0.11523107, 0.11610735, 0.11698806, 0.11787321, 0.11876281, \
0.11965688, 0.12055543, 0.12145846, 0.12236599, 0.12327804, \
0.12419460, 0.12511569, 0.12604133, 0.12697152, 0.12790627, \
0.12884561, 0.12978953, 0.13073804, 0.13169117, 0.13264892, \
0.13361131, 0.13457833, 0.13555001, 0.13652636, 0.13750738, \
0.13849310, 0.13948351, 0.14047863, 0.14147847, 0.14248305, \
0.14349237, 0.14450645, 0.14552529, 0.14654891, 0.14757732, \
0.14861053, 0.14964855, 0.15069140, 0.15173907, 0.15279160, \
0.15384897, 0.15491122, 0.15597834, 0.15705035, 0.15812727, \
0.15920909, 0.16029584, 0.16138752, 0.16248415, 0.16358573, \
0.16469228, 0.16580381, 0.16692033, 0.16804186, 0.16916839, \
0.17029995, 0.17143654, 0.17257818, 0.17372487, 0.17487664, \
0.17603348, 0.17719541, 0.17836245, 0.17953459, 0.18071187, \
0.18189427, 0.18308183, 0.18427454, 0.18547242, 0.18667548, \
0.18788373, 0.18909719, 0.19031586, 0.19153975, 0.19276888, \
0.19400325, 0.19524289, 0.19648779, 0.19773797, 0.19899345, \
0.20025423, 0.20152032, 0.20279174, 0.20406849, 0.20535059, \
0.20663805, 0.20793088, 0.20922910, 0.21053270, 0.21184171, \
0.21315613, 0.21447598, 0.21580126, 0.21713200, 0.21846819, \
0.21980986, 0.22115700, 0.22250964, 0.22386778, 0.22523144, \
0.22660062, 0.22797535, 0.22935562, 0.23074145, 0.23213285, \
0.23352983, 0.23493241, 0.23634059, 0.23775439, 0.23917382, \
0.24059888, 0.24202960, 0.24346597, 0.24490801, 0.24635574, \
0.24780917, 0.24926829, 0.25073314, 0.25220368, 0.25367990, \
0.25516176, 0.25664922, 0.25814226, 0.25964083, 0.26114490, \
0.26265445, 0.26416943, 0.26568982, 0.26721557, 0.26874667, \
0.27028306, 0.27182473, 0.27337163, 0.27492373, 0.27648101, \
0.27804341, 0.27961092, 0.28118350, 0.28276111, 0.28434373, \
0.28593131, 0.28752382, 0.28912124, 0.29072352, 0.29233064, \
0.29394256, 0.29555924, 0.29718066, 0.29880677, 0.30043755, \
0.30207297, 0.30371298, 0.30535756, 0.30700667, 0.30866028, \
0.31031835, 0.31198086, 0.31364776, 0.31531902, 0.31699462, \
0.31867451, 0.32035867, 0.32204706, 0.32373964, 0.32543639, \
0.32713727, 0.32884224, 0.33055128, 0.33226434, 0.33398140, \
0.33570242, 0.33742737, 0.33915621, 0.34088892, 0.34262545, \
0.34436578, 0.34610987, 0.34785769, 0.34960919, 0.35136436, \
0.35312316, 0.35488555, 0.35665150, 0.35842097, 0.36019394, \
0.36197036, 0.36375021, 0.36553346, 0.36732006, 0.36910998, \
0.37090320, 0.37269968, 0.37449938, 0.37630227, 0.37810831, \
0.37991748, 0.38172975, 0.38354506, 0.38536340, 0.38718473, \
0.38900902, 0.39083623, 0.39266633, 0.39449928, 0.39633505, \
0.39817362, 0.40001494, 0.40185898, 0.40370570, 0.40555509, \
0.40740709, 0.40926168, 0.41111882, 0.41297848, 0.41484063, \
0.41670524, 0.41857226, 0.42044167, 0.42231343, 0.42418751, \
0.42606388, 0.42794250, 0.42982333, 0.43170635, 0.43359152, \
0.43547882, 0.43736819, 0.43925962, 0.44115306, 0.44304848, \
0.44494586, 0.44684515, 0.44874633, 0.45064936, 0.45255420, \
0.45446082, 0.45636920, 0.45827928, 0.46019106, 0.46210448, \
0.46401951, 0.46593613, 0.46785429, 0.46977397, 0.47169513, \
0.47361773, 0.47554175, 0.47746715, 0.47939390, 0.48132196, \
0.48325130, 0.48518188, 0.48711368, 0.48904666, 0.49098078, \
0.49291602, 0.49485233, 0.49678969, 0.49872806, 0.50066740, \
0.50260770, 0.50454890, 0.50649098, 0.50843390, 0.51037764, \
0.51232215, 0.51426740, 0.51621337, 0.51816000, 0.52010729, \
0.52205518, 0.52400365, 0.52595265, 0.52790217, 0.52985216, \
0.53180260, 0.53375344, 0.53570466, 0.53765621, 0.53960808, \
0.54156022, 0.54351260, 0.54546518, 0.54741794, 0.54937084, \
0.55132384, 0.55327692, 0.55523003, 0.55718316, 0.55913625, \
0.56108928, 0.56304222, 0.56499503, 0.56694768, 0.56890013, \
0.57085235, 0.57280431, 0.57475597, 0.57670731, 0.57865828, \
0.58060885, 0.58255899, 0.58450867, 0.58645785, 0.58840651, \
0.59035459, 0.59230208, 0.59424894, 0.59619513, 0.59814063, \
0.60008539, 0.60202939, 0.60397258, 0.60591495, 0.60785645, \
0.60979705, 0.61173671, 0.61367541, 0.61561311, 0.61754978, \
0.61948537, 0.62141987, 0.62335323, 0.62528543, 0.62721642, \
0.62914618, 0.63107467, 0.63300186, 0.63492771, 0.63685219, \
0.63877528, 0.64069692, 0.64261710, 0.64453577, 0.64645290, \
0.64836847, 0.65028243, 0.65219475, 0.65410541, 0.65601436, \
0.65792157, 0.65982701, 0.66173064, 0.66363244, 0.66553236, \
0.66743038, 0.66932646, 0.67122057, 0.67311267, 0.67500273, \
0.67689072, 0.67877661, 0.68066035, 0.68254192, 0.68442128, \
0.68629840, 0.68817324, 0.69004578, 0.69191598, 0.69378380, \
0.69564921, 0.69751218, 0.69937268, 0.70123067, 0.70308611, \
0.70493898, 0.70678924, 0.70863686, 0.71048180, 0.71232402, \
0.71416351, 0.71600022, 0.71783412, 0.71966517, 0.72149334, \
0.72331861, 0.72514093, 0.72696027, 0.72877660, 0.73058988, \
0.73240009, 0.73420718, 0.73601112, 0.73781189, 0.73960945, \
0.74140375, 0.74319478, 0.74498249, 0.74676686, 0.74854784, \
0.75032542, 0.75209954, 0.75387018, 0.75563731, 0.75740089, \
0.75916088, 0.76091727, 0.76267000, 0.76441905, 0.76616438, \
0.76790597, 0.76964377, 0.77137776, 0.77310789, 0.77483414, \
0.77655648, 0.77827486, 0.77998926, 0.78169964, 0.78340597, \
0.78510822, 0.78680635, 0.78850032, 0.79019011, 0.79187568, \
0.79355700, 0.79523403, 0.79690675, 0.79857511, 0.80023908, \
0.80189864, 0.80355374, 0.80520435, 0.80685044, 0.80849198, \
0.81012893, 0.81176126, 0.81338894, 0.81501192, 0.81663019, \
0.81824370, 0.81985242, 0.82145632, 0.82305536, 0.82464951, \
0.82623874, 0.82782301, 0.82940230, 0.83097656, 0.83254576, \
0.83410987, 0.83566886, 0.83722269, 0.83877133, 0.84031474, \
0.84185290, 0.84338576, 0.84491330, 0.84643548, 0.84795227, \
0.84946363, 0.85096953, 0.85246994, 0.85396483, 0.85545415, \
0.85693788, 0.85841598, 0.85988842, 0.86135517, 0.86281619, \
0.86427145, 0.86572092, 0.86716455, 0.86860233, 0.87003421, \
0.87146016, 0.87288014, 0.87429414, 0.87570210, 0.87710400, \
0.87849980, 0.87988948, 0.88127299, 0.88265030, 0.88402138, \
0.88538620, 0.88674472, 0.88809691, 0.88944273, 0.89078216, \
0.89211516, 0.89344169, 0.89476172, 0.89607522, 0.89738215, \
0.89868248, 0.89997618, 0.90126322, 0.90254355, 0.90381715, \
0.90508399, 0.90634402, 0.90759722, 0.90884355, 0.91008298, \
0.91131548, 0.91254100, 0.91375953, 0.91497102, 0.91617544, \
0.91737276, 0.91856295, 0.91974596, 0.92092177, 0.92209035, \
0.92325166, 0.92440566, 0.92555232, 0.92669162, 0.92782351, \
0.92894796, 0.93006494, 0.93117442, 0.93227636, 0.93337073, \
0.93445749, 0.93553662, 0.93660807, 0.93767181, 0.93872782, \
0.93977605, 0.94081648, 0.94184907, 0.94287378, 0.94389059, \
0.94489946, 0.94590035, 0.94689324, 0.94787808, 0.94885485, \
0.94982351, 0.95078403, 0.95173638, 0.95268051, 0.95361641, \
0.95454402, 0.95546333, 0.95637430, 0.95727689, 0.95817107, \
0.95905681, 0.95993407, 0.96080282, 0.96166302, 0.96251465, \
0.96335767, 0.96419204, 0.96501773, 0.96583472, 0.96664295, \
0.96744241, 0.96823306, 0.96901486, 0.96978778, 0.97055179, \
0.97130685, 0.97205294, 0.97279001, 0.97351803, 0.97423697, \
0.97494680, 0.97564748, 0.97633898, 0.97702127, 0.97769430, \
0.97835806, 0.97901250, 0.97965759, 0.98029330, 0.98091960, \
0.98153644, 0.98214380, 0.98274165, 0.98332995, 0.98390866, \
0.98447776, 0.98503720, 0.98558696, 0.98612701, 0.98665730, \
0.98717781, 0.98768850, 0.98818934, 0.98868030, 0.98916133, \
0.98963242, 0.99009352, 0.99054460, 0.99098562, 0.99141656, \
0.99183738, 0.99224805, 0.99264853, 0.99303879, 0.99341880, \
0.99378851, 0.99414791, 0.99449696, 0.99483561, 0.99516385, \
0.99548162, 0.99578891, 0.99608568, 0.99637190, 0.99664752, \
0.99691252, 0.99716686, 0.99741052, 0.99764345, 0.99786563, \
0.99807701, 0.99827757, 0.99846727, 0.99864609, 0.99881398, \
0.99897091, 0.99911684, 0.99925176, 0.99937561, 0.99948838, \
0.99959001, 0.99968049, 0.99975978, 0.99982784, 0.99988464, \
0.99993014, 0.99996432, 0.99998714, 0.99999857, } 

#define PARZEN4096 {\
0.00000000, 0.00000000, 0.00000000, 0.00000001, 0.00000002, \
0.00000004, 0.00000006, 0.00000010, 0.00000014, 0.00000020, \
0.00000027, 0.00000035, 0.00000045, 0.00000057, 0.00000071, \
0.00000087, 0.00000105, 0.00000125, 0.00000147, 0.00000173, \
0.00000201, 0.00000231, 0.00000265, 0.00000302, 0.00000342, \
0.00000386, 0.00000433, 0.00000484, 0.00000539, 0.00000598, \
0.00000661, 0.00000728, 0.00000799, 0.00000875, 0.00000956, \
0.00001042, 0.00001132, 0.00001228, 0.00001329, 0.00001435, \
0.00001547, 0.00001664, 0.00001787, 0.00001916, 0.00002052, \
0.00002193, 0.00002341, 0.00002495, 0.00002656, 0.00002824, \
0.00002999, 0.00003180, 0.00003369, 0.00003565, 0.00003769, \
0.00003980, 0.00004199, 0.00004426, 0.00004661, 0.00004904, \
0.00005156, 0.00005416, 0.00005684, 0.00005962, 0.00006248, \
0.00006543, 0.00006847, 0.00007161, 0.00007484, 0.00007816, \
0.00008158, 0.00008511, 0.00008873, 0.00009245, 0.00009627, \
0.00010020, 0.00010424, 0.00010838, 0.00011263, 0.00011699, \
0.00012146, 0.00012604, 0.00013074, 0.00013555, 0.00014048, \
0.00014553, 0.00015069, 0.00015598, 0.00016139, 0.00016692, \
0.00017258, 0.00017836, 0.00018427, 0.00019032, 0.00019649, \
0.00020279, 0.00020923, 0.00021580, 0.00022251, 0.00022936, \
0.00023634, 0.00024347, 0.00025073, 0.00025814, 0.00026570, \
0.00027340, 0.00028125, 0.00028924, 0.00029739, 0.00030569, \
0.00031414, 0.00032275, 0.00033151, 0.00034043, 0.00034951, \
0.00035875, 0.00036814, 0.00037771, 0.00038743, 0.00039732, \
0.00040738, 0.00041761, 0.00042800, 0.00043857, 0.00044931, \
0.00046023, 0.00047132, 0.00048258, 0.00049403, 0.00050565, \
0.00051745, 0.00052944, 0.00054161, 0.00055397, 0.00056651, \
0.00057924, 0.00059216, 0.00060527, 0.00061857, 0.00063207, \
0.00064576, 0.00065964, 0.00067373, 0.00068801, 0.00070250, \
0.00071718, 0.00073207, 0.00074716, 0.00076246, 0.00077797, \
0.00079369, 0.00080961, 0.00082575, 0.00084210, 0.00085867, \
0.00087545, 0.00089245, 0.00090967, 0.00092710, 0.00094476, \
0.00096264, 0.00098075, 0.00099908, 0.00101764, 0.00103642, \
0.00105544, 0.00107469, 0.00109417, 0.00111388, 0.00113383, \
0.00115402, 0.00117444, 0.00119511, 0.00121601, 0.00123716, \
0.00125855, 0.00128019, 0.00130207, 0.00132420, 0.00134658, \
0.00136922, 0.00139210, 0.00141524, 0.00143863, 0.00146228, \
0.00148618, 0.00151035, 0.00153477, 0.00155946, 0.00158441, \
0.00160963, 0.00163511, 0.00166086, 0.00168688, 0.00171316, \
0.00173972, 0.00176656, 0.00179367, 0.00182105, 0.00184871, \
0.00187665, 0.00190487, 0.00193337, 0.00196216, 0.00199122, \
0.00202058, 0.00205022, 0.00208015, 0.00211037, 0.00214088, \
0.00217168, 0.00220278, 0.00223417, 0.00226586, 0.00229785, \
0.00233014, 0.00236273, 0.00239562, 0.00242882, 0.00246232, \
0.00249612, 0.00253024, 0.00256466, 0.00259940, 0.00263445, \
0.00266981, 0.00270548, 0.00274148, 0.00277779, 0.00281442, \
0.00285137, 0.00288864, 0.00292623, 0.00296415, 0.00300240, \
0.00304098, 0.00307988, 0.00311911, 0.00315868, 0.00319858, \
0.00323881, 0.00327938, 0.00332029, 0.00336153, 0.00340312, \
0.00344504, 0.00348731, 0.00352993, 0.00357289, 0.00361619, \
0.00365985, 0.00370386, 0.00374821, 0.00379292, 0.00383799, \
0.00388341, 0.00392918, 0.00397532, 0.00402181, 0.00406867, \
0.00411589, 0.00416347, 0.00421142, 0.00425973, 0.00430841, \
0.00435746, 0.00440689, 0.00445668, 0.00450685, 0.00455739, \
0.00460831, 0.00465961, 0.00471129, 0.00476335, 0.00481579, \
0.00486861, 0.00492182, 0.00497541, 0.00502939, 0.00508377, \
0.00513853, 0.00519368, 0.00524923, 0.00530517, 0.00536151, \
0.00541824, 0.00547538, 0.00553291, 0.00559085, 0.00564919, \
0.00570793, 0.00576708, 0.00582663, 0.00588660, 0.00594697, \
0.00600776, 0.00606896, 0.00613057, 0.00619260, 0.00625505, \
0.00631791, 0.00638120, 0.00644490, 0.00650903, 0.00657358, \
0.00663856, 0.00670396, 0.00676979, 0.00683606, 0.00690275, \
0.00696987, 0.00703743, 0.00710543, 0.00717386, 0.00724273, \
0.00731203, 0.00738178, 0.00745197, 0.00752261, 0.00759369, \
0.00766521, 0.00773719, 0.00780961, 0.00788248, 0.00795581, \
0.00802959, 0.00810382, 0.00817851, 0.00825365, 0.00832926, \
0.00840533, 0.00848185, 0.00855884, 0.00863630, 0.00871422, \
0.00879261, 0.00887147, 0.00895079, 0.00903059, 0.00911086, \
0.00919161, 0.00927283, 0.00935453, 0.00943670, 0.00951936, \
0.00960250, 0.00968612, 0.00977023, 0.00985482, 0.00993989, \
0.01002546, 0.01011151, 0.01019806, 0.01028510, 0.01037263, \
0.01046066, 0.01054918, 0.01063820, 0.01072772, 0.01081775, \
0.01090827, 0.01099930, 0.01109083, 0.01118287, 0.01127542, \
0.01136848, 0.01146204, 0.01155612, 0.01165072, 0.01174582, \
0.01184145, 0.01193759, 0.01203425, 0.01213143, 0.01222913, \
0.01232736, 0.01242611, 0.01252538, 0.01262519, 0.01272552, \
0.01282638, 0.01292777, 0.01302970, 0.01313216, 0.01323516, \
0.01333869, 0.01344277, 0.01354738, 0.01365253, 0.01375823, \
0.01386447, 0.01397126, 0.01407859, 0.01418647, 0.01429490, \
0.01440388, 0.01451342, 0.01462351, 0.01473415, 0.01484535, \
0.01495711, 0.01506943, 0.01518231, 0.01529575, 0.01540975, \
0.01552432, 0.01563946, 0.01575517, 0.01587144, 0.01598828, \
0.01610570, 0.01622369, 0.01634226, 0.01646140, 0.01658112, \
0.01670141, 0.01682229, 0.01694375, 0.01706580, 0.01718842, \
0.01731164, 0.01743544, 0.01755983, 0.01768481, 0.01781038, \
0.01793655, 0.01806331, 0.01819066, 0.01831861, 0.01844717, \
0.01857632, 0.01870607, 0.01883642, 0.01896738, 0.01909895, \
0.01923112, 0.01936390, 0.01949729, 0.01963129, 0.01976591, \
0.01990114, 0.02003698, 0.02017344, 0.02031052, 0.02044822, \
0.02058654, 0.02072548, 0.02086504, 0.02100523, 0.02114605, \
0.02128749, 0.02142957, 0.02157227, 0.02171561, 0.02185958, \
0.02200418, 0.02214943, 0.02229531, 0.02244182, 0.02258898, \
0.02273678, 0.02288523, 0.02303432, 0.02318405, 0.02333444, \
0.02348547, 0.02363715, 0.02378948, 0.02394247, 0.02409611, \
0.02425041, 0.02440536, 0.02456097, 0.02471725, 0.02487418, \
0.02503178, 0.02519004, 0.02534897, 0.02550856, 0.02566882, \
0.02582976, 0.02599136, 0.02615364, 0.02631659, 0.02648021, \
0.02664452, 0.02680950, 0.02697516, 0.02714150, 0.02730852, \
0.02747623, 0.02764463, 0.02781370, 0.02798347, 0.02815393, \
0.02832508, 0.02849692, 0.02866945, 0.02884268, 0.02901661, \
0.02919123, 0.02936655, 0.02954257, 0.02971930, 0.02989673, \
0.03007486, 0.03025370, 0.03043325, 0.03061350, 0.03079447, \
0.03097615, 0.03115854, 0.03134164, 0.03152546, 0.03171000, \
0.03189526, 0.03208124, 0.03226794, 0.03245536, 0.03264351, \
0.03283238, 0.03302198, 0.03321231, 0.03340336, 0.03359515, \
0.03378767, 0.03398093, 0.03417492, 0.03436965, 0.03456512, \
0.03476132, 0.03495827, 0.03515596, 0.03535440, 0.03555357, \
0.03575350, 0.03595417, 0.03615560, 0.03635777, 0.03656070, \
0.03676438, 0.03696881, 0.03717401, 0.03737996, 0.03758666, \
0.03779413, 0.03800237, 0.03821136, 0.03842112, 0.03863165, \
0.03884294, 0.03905500, 0.03926784, 0.03948144, 0.03969582, \
0.03991097, 0.04012690, 0.04034361, 0.04056110, 0.04077936, \
0.04099841, 0.04121824, 0.04143885, 0.04166025, 0.04188244, \
0.04210542, 0.04232918, 0.04255374, 0.04277909, 0.04300523, \
0.04323217, 0.04345991, 0.04368845, 0.04391778, 0.04414792, \
0.04437886, 0.04461060, 0.04484315, 0.04507650, 0.04531067, \
0.04554564, 0.04578142, 0.04601802, 0.04625543, 0.04649365, \
0.04673270, 0.04697256, 0.04721323, 0.04745473, 0.04769706, \
0.04794020, 0.04818417, 0.04842897, 0.04867459, 0.04892104, \
0.04916833, 0.04941644, 0.04966539, 0.04991518, 0.05016580, \
0.05041725, 0.05066955, 0.05092268, 0.05117666, 0.05143148, \
0.05168715, 0.05194366, 0.05220102, 0.05245923, 0.05271828, \
0.05297819, 0.05323896, 0.05350057, 0.05376304, 0.05402637, \
0.05429056, 0.05455561, 0.05482151, 0.05508828, 0.05535592, \
0.05562442, 0.05589379, 0.05616402, 0.05643513, 0.05670710, \
0.05697995, 0.05725367, 0.05752827, 0.05780375, 0.05808010, \
0.05835733, 0.05863544, 0.05891444, 0.05919431, 0.05947508, \
0.05975673, 0.06003926, 0.06032269, 0.06060701, 0.06089222, \
0.06117832, 0.06146532, 0.06175321, 0.06204200, 0.06233169, \
0.06262228, 0.06291377, 0.06320617, 0.06349947, 0.06379367, \
0.06408879, 0.06438481, 0.06468174, 0.06497958, 0.06527834, \
0.06557801, 0.06587860, 0.06618010, 0.06648252, 0.06678586, \
0.06709013, 0.06739531, 0.06770142, 0.06800846, 0.06831642, \
0.06862531, 0.06893513, 0.06924588, 0.06955757, 0.06987018, \
0.07018374, 0.07049823, 0.07081365, 0.07113002, 0.07144733, \
0.07176558, 0.07208477, 0.07240491, 0.07272600, 0.07304803, \
0.07337102, 0.07369495, 0.07401983, 0.07434567, 0.07467247, \
0.07500022, 0.07532892, 0.07565859, 0.07598922, 0.07632081, \
0.07665336, 0.07698688, 0.07732136, 0.07765681, 0.07799323, \
0.07833062, 0.07866898, 0.07900831, 0.07934862, 0.07968990, \
0.08003216, 0.08037540, 0.08071962, 0.08106482, 0.08141101, \
0.08175818, 0.08210633, 0.08245547, 0.08280560, 0.08315672, \
0.08350883, 0.08386193, 0.08421603, 0.08457112, 0.08492721, \
0.08528429, 0.08564238, 0.08600147, 0.08636156, 0.08672265, \
0.08708475, 0.08744785, 0.08781196, 0.08817709, 0.08854322, \
0.08891036, 0.08927852, 0.08964770, 0.09001789, 0.09038909, \
0.09076132, 0.09113457, 0.09150883, 0.09188413, 0.09226044, \
0.09263779, 0.09301616, 0.09339556, 0.09377599, 0.09415745, \
0.09453994, 0.09492347, 0.09530803, 0.09569364, 0.09608028, \
0.09646796, 0.09685668, 0.09724644, 0.09763725, 0.09802911, \
0.09842201, 0.09881596, 0.09921096, 0.09960701, 0.10000412, \
0.10040227, 0.10080149, 0.10120176, 0.10160308, 0.10200547, \
0.10240892, 0.10281343, 0.10321901, 0.10362565, 0.10403336, \
0.10444213, 0.10485198, 0.10526289, 0.10567488, 0.10608794, \
0.10650207, 0.10691729, 0.10733358, 0.10775095, 0.10816940, \
0.10858893, 0.10900954, 0.10943124, 0.10985403, 0.11027790, \
0.11070287, 0.11112892, 0.11155606, 0.11198430, 0.11241363, \
0.11284406, 0.11327559, 0.11370821, 0.11414194, 0.11457676, \
0.11501269, 0.11544972, 0.11588786, 0.11632711, 0.11676746, \
0.11720893, 0.11765150, 0.11809519, 0.11853999, 0.11898591, \
0.11943295, 0.11988110, 0.12033037, 0.12078077, 0.12123228, \
0.12168492, 0.12213869, 0.12259358, 0.12304960, 0.12350675, \
0.12396503, 0.12442444, 0.12488499, 0.12534667, 0.12580949, \
0.12627345, 0.12673854, 0.12720478, 0.12767216, 0.12814068, \
0.12861034, 0.12908115, 0.12955311, 0.13002622, 0.13050048, \
0.13097589, 0.13145246, 0.13193018, 0.13240905, 0.13288908, \
0.13337028, 0.13385263, 0.13433614, 0.13482082, 0.13530666, \
0.13579366, 0.13628184, 0.13677118, 0.13726169, 0.13775337, \
0.13824623, 0.13874026, 0.13923546, 0.13973185, 0.14022941, \
0.14072815, 0.14122807, 0.14172918, 0.14223146, 0.14273494, \
0.14323960, 0.14374545, 0.14425248, 0.14476071, 0.14527013, \
0.14578075, 0.14629256, 0.14680557, 0.14731977, 0.14783518, \
0.14835178, 0.14886959, 0.14938860, 0.14990881, 0.15043023, \
0.15095286, 0.15147670, 0.15200175, 0.15252801, 0.15305548, \
0.15358417, 0.15411408, 0.15464520, 0.15517754, 0.15571110, \
0.15624589, 0.15678189, 0.15731912, 0.15785758, 0.15839726, \
0.15893817, 0.15948032, 0.16002369, 0.16056830, 0.16111414, \
0.16166121, 0.16220953, 0.16275908, 0.16330987, 0.16386190, \
0.16441518, 0.16496970, 0.16552546, 0.16608248, 0.16664074, \
0.16720024, 0.16776101, 0.16832302, 0.16888629, 0.16945081, \
0.17001659, 0.17058362, 0.17115192, 0.17172147, 0.17229229, \
0.17286438, 0.17343772, 0.17401234, 0.17458822, 0.17516537, \
0.17574379, 0.17632348, 0.17690445, 0.17748669, 0.17807021, \
0.17865500, 0.17924108, 0.17982843, 0.18041707, 0.18100699, \
0.18159819, 0.18219068, 0.18278446, 0.18337952, 0.18397588, \
0.18457353, 0.18517247, 0.18577270, 0.18637423, 0.18697706, \
0.18758118, 0.18818661, 0.18879334, 0.18940137, 0.19001070, \
0.19062134, 0.19123328, 0.19184654, 0.19246110, 0.19307698, \
0.19369417, 0.19431267, 0.19493248, 0.19555362, 0.19617607, \
0.19679984, 0.19742493, 0.19805134, 0.19867908, 0.19930814, \
0.19993853, 0.20057025, 0.20120330, 0.20183767, 0.20247338, \
0.20311042, 0.20374880, 0.20438851, 0.20502957, 0.20567195, \
0.20631569, 0.20696076, 0.20760717, 0.20825493, 0.20890404, \
0.20955449, 0.21020629, 0.21085945, 0.21151395, 0.21216981, \
0.21282702, 0.21348558, 0.21414551, 0.21480679, 0.21546943, \
0.21613344, 0.21679880, 0.21746553, 0.21813363, 0.21880309, \
0.21947393, 0.22014613, 0.22081970, 0.22149465, 0.22217096, \
0.22284866, 0.22352773, 0.22420818, 0.22489001, 0.22557322, \
0.22625781, 0.22694379, 0.22763115, 0.22831989, 0.22901003, \
0.22970155, 0.23039447, 0.23108878, 0.23178448, 0.23248157, \
0.23318006, 0.23387995, 0.23458124, 0.23528393, 0.23598802, \
0.23669352, 0.23740042, 0.23810872, 0.23881843, 0.23952956, \
0.24024209, 0.24095603, 0.24167139, 0.24238816, 0.24310634, \
0.24382595, 0.24454697, 0.24526941, 0.24599328, 0.24671856, \
0.24744528, 0.24817341, 0.24890298, 0.24963397, 0.25036639, \
0.25110024, 0.25183551, 0.25257221, 0.25331032, 0.25404984, \
0.25479077, 0.25553310, 0.25627683, 0.25702196, 0.25776848, \
0.25851638, 0.25926567, 0.26001633, 0.26076837, 0.26152178, \
0.26227655, 0.26303269, 0.26379018, 0.26454902, 0.26530922, \
0.26607076, 0.26683363, 0.26759785, 0.26836340, 0.26913027, \
0.26989847, 0.27066799, 0.27143882, 0.27221096, 0.27298442, \
0.27375917, 0.27453522, 0.27531257, 0.27609121, 0.27687113, \
0.27765233, 0.27843481, 0.27921857, 0.28000359, 0.28078988, \
0.28157743, 0.28236624, 0.28315630, 0.28394761, 0.28474016, \
0.28553395, 0.28632898, 0.28712523, 0.28792272, 0.28872143, \
0.28952136, 0.29032250, 0.29112485, 0.29192841, 0.29273317, \
0.29353913, 0.29434628, 0.29515462, 0.29596415, 0.29677486, \
0.29758675, 0.29839980, 0.29921403, 0.30002942, 0.30084597, \
0.30166368, 0.30248254, 0.30330255, 0.30412370, 0.30494599, \
0.30576941, 0.30659397, 0.30741965, 0.30824646, 0.30907438, \
0.30990342, 0.31073356, 0.31156482, 0.31239717, 0.31323062, \
0.31406517, 0.31490080, 0.31573752, 0.31657532, 0.31741419, \
0.31825414, 0.31909516, 0.31993724, 0.32078037, 0.32162457, \
0.32246981, 0.32331611, 0.32416344, 0.32501182, 0.32586122, \
0.32671166, 0.32756313, 0.32841562, 0.32926912, 0.33012364, \
0.33097917, 0.33183570, 0.33269323, 0.33355176, 0.33441128, \
0.33527180, 0.33613329, 0.33699577, 0.33785922, 0.33872364, \
0.33958903, 0.34045538, 0.34132270, 0.34219096, 0.34306018, \
0.34393035, 0.34480145, 0.34567350, 0.34654648, 0.34742038, \
0.34829522, 0.34917097, 0.35004764, 0.35092523, 0.35180372, \
0.35268312, 0.35356342, 0.35444462, 0.35532670, 0.35620968, \
0.35709354, 0.35797827, 0.35886389, 0.35975037, 0.36063772, \
0.36152593, 0.36241501, 0.36330493, 0.36419571, 0.36508733, \
0.36597979, 0.36687309, 0.36776723, 0.36866219, 0.36955798, \
0.37045459, 0.37135202, 0.37225025, 0.37314930, 0.37404915, \
0.37494980, 0.37585125, 0.37675348, 0.37765651, 0.37856031, \
0.37946490, 0.38037026, 0.38127639, 0.38218329, 0.38309095, \
0.38399937, 0.38490854, 0.38581846, 0.38672912, 0.38764053, \
0.38855267, 0.38946555, 0.39037915, 0.39129348, 0.39220853, \
0.39312430, 0.39404078, 0.39495796, 0.39587585, 0.39679444, \
0.39771372, 0.39863369, 0.39955435, 0.40047569, 0.40139771, \
0.40232041, 0.40324377, 0.40416780, 0.40509249, 0.40601784, \
0.40694384, 0.40787049, 0.40879779, 0.40972573, 0.41065430, \
0.41158350, 0.41251333, 0.41344379, 0.41437487, 0.41530656, \
0.41623886, 0.41717177, 0.41810528, 0.41903939, 0.41997410, \
0.42090939, 0.42184527, 0.42278174, 0.42371878, 0.42465639, \
0.42559457, 0.42653332, 0.42747263, 0.42841250, 0.42935292, \
0.43029388, 0.43123539, 0.43217745, 0.43312003, 0.43406315, \
0.43500680, 0.43595096, 0.43689565, 0.43784086, 0.43878657, \
0.43973279, 0.44067951, 0.44162673, 0.44257444, 0.44352265, \
0.44447134, 0.44542051, 0.44637015, 0.44732027, 0.44827086, \
0.44922191, 0.45017343, 0.45112540, 0.45207782, 0.45303069, \
0.45398400, 0.45493775, 0.45589194, 0.45684656, 0.45780160, \
0.45875707, 0.45971296, 0.46066926, 0.46162597, 0.46258308, \
0.46354060, 0.46449852, 0.46545683, 0.46641552, 0.46737460, \
0.46833407, 0.46929391, 0.47025412, 0.47121470, 0.47217564, \
0.47313695, 0.47409861, 0.47506062, 0.47602297, 0.47698567, \
0.47794871, 0.47891209, 0.47987579, 0.48083982, 0.48180417, \
0.48276884, 0.48373383, 0.48469912, 0.48566472, 0.48663062, \
0.48759682, 0.48856331, 0.48953008, 0.49049715, 0.49146449, \
0.49243211, 0.49339999, 0.49436815, 0.49533657, 0.49630525, \
0.49727419, 0.49824337, 0.49921280, 0.50018248, 0.50115239, \
0.50212254, 0.50309291, 0.50406351, 0.50503434, 0.50600538, \
0.50697663, 0.50794809, 0.50891976, 0.50989163, 0.51086369, \
0.51183595, 0.51280839, 0.51378102, 0.51475383, 0.51572681, \
0.51669996, 0.51767328, 0.51864677, 0.51962041, 0.52059420, \
0.52156815, 0.52254224, 0.52351648, 0.52449085, 0.52546535, \
0.52643999, 0.52741475, 0.52838963, 0.52936462, 0.53033973, \
0.53131495, 0.53229027, 0.53326569, 0.53424121, 0.53521682, \
0.53619252, 0.53716829, 0.53814415, 0.53912009, 0.54009609, \
0.54107216, 0.54204829, 0.54302448, 0.54400072, 0.54497702, \
0.54595336, 0.54692973, 0.54790615, 0.54888260, 0.54985908, \
0.55083558, 0.55181211, 0.55278864, 0.55376520, 0.55474175, \
0.55571832, 0.55669488, 0.55767143, 0.55864798, 0.55962452, \
0.56060103, 0.56157753, 0.56255400, 0.56353044, 0.56450684, \
0.56548321, 0.56645953, 0.56743581, 0.56841203, 0.56938821, \
0.57036432, 0.57134036, 0.57231634, 0.57329225, 0.57426809, \
0.57524384, 0.57621950, 0.57719508, 0.57817057, 0.57914596, \
0.58012124, 0.58109643, 0.58207150, 0.58304646, 0.58402130, \
0.58499602, 0.58597061, 0.58694507, 0.58791939, 0.58889358, \
0.58986763, 0.59084152, 0.59181527, 0.59278886, 0.59376229, \
0.59473555, 0.59570865, 0.59668157, 0.59765432, 0.59862689, \
0.59959927, 0.60057146, 0.60154346, 0.60251526, 0.60348686, \
0.60445825, 0.60542944, 0.60640041, 0.60737115, 0.60834168, \
0.60931198, 0.61028205, 0.61125188, 0.61222148, 0.61319083, \
0.61415993, 0.61512878, 0.61609737, 0.61706571, 0.61803378, \
0.61900158, 0.61996910, 0.62093635, 0.62190332, 0.62287000, \
0.62383639, 0.62480249, 0.62576829, 0.62673379, 0.62769898, \
0.62866386, 0.62962842, 0.63059267, 0.63155659, 0.63252019, \
0.63348345, 0.63444638, 0.63540896, 0.63637120, 0.63733310, \
0.63829464, 0.63925582, 0.64021665, 0.64117710, 0.64213719, \
0.64309691, 0.64405624, 0.64501520, 0.64597377, 0.64693194, \
0.64788973, 0.64884711, 0.64980409, 0.65076067, 0.65171683, \
0.65267258, 0.65362790, 0.65458281, 0.65553728, 0.65649132, \
0.65744493, 0.65839810, 0.65935082, 0.66030309, 0.66125491, \
0.66220627, 0.66315716, 0.66410760, 0.66505756, 0.66600705, \
0.66695606, 0.66790459, 0.66885263, 0.66980018, 0.67074723, \
0.67169379, 0.67263984, 0.67358538, 0.67453041, 0.67547493, \
0.67641892, 0.67736239, 0.67830533, 0.67924774, 0.68018961, \
0.68113094, 0.68207173, 0.68301196, 0.68395164, 0.68489077, \
0.68582933, 0.68676732, 0.68770475, 0.68864159, 0.68957786, \
0.69051355, 0.69144865, 0.69238316, 0.69331707, 0.69425038, \
0.69518309, 0.69611519, 0.69704667, 0.69797754, 0.69890779, \
0.69983741, 0.70076641, 0.70169477, 0.70262249, 0.70354957, \
0.70447601, 0.70540179, 0.70632692, 0.70725139, 0.70817520, \
0.70909834, 0.71002081, 0.71094261, 0.71186372, 0.71278415, \
0.71370390, 0.71462295, 0.71554130, 0.71645896, 0.71737591, \
0.71829215, 0.71920767, 0.72012248, 0.72103657, 0.72194993, \
0.72286257, 0.72377447, 0.72468563, 0.72559604, 0.72650571, \
0.72741463, 0.72832280, 0.72923021, 0.73013685, 0.73104272, \
0.73194783, 0.73285215, 0.73375570, 0.73465846, 0.73556044, \
0.73646162, 0.73736200, 0.73826158, 0.73916036, 0.74005833, \
0.74095548, 0.74185182, 0.74274733, 0.74364202, 0.74453588, \
0.74542890, 0.74632108, 0.74721242, 0.74810292, 0.74899256, \
0.74988134, 0.75076927, 0.75165633, 0.75254253, 0.75342785, \
0.75431229, 0.75519586, 0.75607854, 0.75696033, 0.75784122, \
0.75872122, 0.75960032, 0.76047851, 0.76135579, 0.76223216, \
0.76310761, 0.76398213, 0.76485573, 0.76572840, 0.76660013, \
0.76747093, 0.76834077, 0.76920968, 0.77007763, 0.77094462, \
0.77181065, 0.77267572, 0.77353982, 0.77440294, 0.77526509, \
0.77612626, 0.77698644, 0.77784564, 0.77870383, 0.77956104, \
0.78041723, 0.78127242, 0.78212661, 0.78297977, 0.78383192, \
0.78468304, 0.78553314, 0.78638220, 0.78723023, 0.78807722, \
0.78892316, 0.78976806, 0.79061190, 0.79145469, 0.79229641, \
0.79313707, 0.79397666, 0.79481518, 0.79565262, 0.79648898, \
0.79732425, 0.79815843, 0.79899151, 0.79982350, 0.80065439, \
0.80148416, 0.80231283, 0.80314038, 0.80396681, 0.80479212, \
0.80561630, 0.80643935, 0.80726126, 0.80808203, 0.80890165, \
0.80972013, 0.81053745, 0.81135361, 0.81216862, 0.81298246, \
0.81379512, 0.81460662, 0.81541693, 0.81622607, 0.81703401, \
0.81784077, 0.81864633, 0.81945069, 0.82025385, 0.82105580, \
0.82185653, 0.82265605, 0.82345436, 0.82425143, 0.82504728, \
0.82584190, 0.82663527, 0.82742741, 0.82821830, 0.82900795, \
0.82979633, 0.83058346, 0.83136933, 0.83215393, 0.83293727, \
0.83371932, 0.83450010, 0.83527959, 0.83605780, 0.83683472, \
0.83761034, 0.83838466, 0.83915767, 0.83992938, 0.84069978, \
0.84146885, 0.84223661, 0.84300305, 0.84376815, 0.84453192, \
0.84529435, 0.84605544, 0.84681519, 0.84757358, 0.84833062, \
0.84908630, 0.84984062, 0.85059357, 0.85134515, 0.85209536, \
0.85284418, 0.85359163, 0.85433768, 0.85508234, 0.85582561, \
0.85656747, 0.85730793, 0.85804699, 0.85878462, 0.85952085, \
0.86025565, 0.86098902, 0.86172097, 0.86245148, 0.86318055, \
0.86390818, 0.86463436, 0.86535909, 0.86608237, 0.86680419, \
0.86752455, 0.86824343, 0.86896085, 0.86967679, 0.87039125, \
0.87110423, 0.87181571, 0.87252571, 0.87323421, 0.87394120, \
0.87464669, 0.87535068, 0.87605314, 0.87675409, 0.87745352, \
0.87815142, 0.87884780, 0.87954263, 0.88023593, 0.88092769, \
0.88161790, 0.88230655, 0.88299365, 0.88367920, 0.88436317, \
0.88504558, 0.88572642, 0.88640568, 0.88708336, 0.88775946, \
0.88843396, 0.88910688, 0.88977819, 0.89044791, 0.89111601, \
0.89178251, 0.89244740, 0.89311066, 0.89377230, 0.89443232, \
0.89509071, 0.89574745, 0.89640257, 0.89705603, 0.89770785, \
0.89835802, 0.89900653, 0.89965338, 0.90029857, 0.90094208, \
0.90158393, 0.90222410, 0.90286258, 0.90349938, 0.90413450, \
0.90476791, 0.90539963, 0.90602965, 0.90665796, 0.90728456, \
0.90790945, 0.90853261, 0.90915406, 0.90977377, 0.91039176, \
0.91100800, 0.91162251, 0.91223528, 0.91284629, 0.91345556, \
0.91406306, 0.91466881, 0.91527279, 0.91587500, 0.91647544, \
0.91707410, 0.91767098, 0.91826607, 0.91885938, 0.91945088, \
0.92004059, 0.92062850, 0.92121460, 0.92179889, 0.92238136, \
0.92296201, 0.92354084, 0.92411784, 0.92469301, 0.92526635, \
0.92583784, 0.92640749, 0.92697529, 0.92754123, 0.92810532, \
0.92866755, 0.92922791, 0.92978640, 0.93034302, 0.93089776, \
0.93145062, 0.93200159, 0.93255066, 0.93309785, 0.93364313, \
0.93418652, 0.93472799, 0.93526755, 0.93580520, 0.93634093, \
0.93687473, 0.93740660, 0.93793654, 0.93846455, 0.93899061, \
0.93951473, 0.94003689, 0.94055711, 0.94107537, 0.94159166, \
0.94210599, 0.94261835, 0.94312873, 0.94363713, 0.94414355, \
0.94464799, 0.94515043, 0.94565088, 0.94614932, 0.94664577, \
0.94714020, 0.94763262, 0.94812303, 0.94861142, 0.94909778, \
0.94958211, 0.95006441, 0.95054467, 0.95102289, 0.95149906, \
0.95197318, 0.95244525, 0.95291526, 0.95338321, 0.95384909, \
0.95431290, 0.95477463, 0.95523429, 0.95569186, 0.95614734, \
0.95660073, 0.95705203, 0.95750122, 0.95794832, 0.95839330, \
0.95883617, 0.95927692, 0.95971555, 0.96015205, 0.96058643, \
0.96101867, 0.96144877, 0.96187673, 0.96230255, 0.96272621, \
0.96314772, 0.96356707, 0.96398426, 0.96439928, 0.96481212, \
0.96522280, 0.96563129, 0.96603760, 0.96644172, 0.96684364, \
0.96724337, 0.96764090, 0.96803622, 0.96842934, 0.96882024, \
0.96920892, 0.96959539, 0.96997962, 0.97036163, 0.97074140, \
0.97111893, 0.97149422, 0.97186726, 0.97223805, 0.97260659, \
0.97297286, 0.97333687, 0.97369862, 0.97405809, 0.97441528, \
0.97477020, 0.97512283, 0.97547317, 0.97582122, 0.97616697, \
0.97651042, 0.97685156, 0.97719039, 0.97752691, 0.97786111, \
0.97819299, 0.97852254, 0.97884977, 0.97917465, 0.97949720, \
0.97981740, 0.98013526, 0.98045076, 0.98076391, 0.98107470, \
0.98138312, 0.98168917, 0.98199285, 0.98229416, 0.98259308, \
0.98288962, 0.98318377, 0.98347553, 0.98376488, 0.98405184, \
0.98433639, 0.98461852, 0.98489825, 0.98517555, 0.98545043, \
0.98572289, 0.98599291, 0.98626050, 0.98652565, 0.98678835, \
0.98704860, 0.98730641, 0.98756175, 0.98781464, 0.98806506, \
0.98831301, 0.98855849, 0.98880149, 0.98904201, 0.98928004, \
0.98951558, 0.98974863, 0.98997918, 0.99020723, 0.99043277, \
0.99065580, 0.99087631, 0.99109430, 0.99130977, 0.99152272, \
0.99173313, 0.99194100, 0.99214634, 0.99234913, 0.99254937, \
0.99274705, 0.99294218, 0.99313475, 0.99332476, 0.99351219, \
0.99369705, 0.99387933, 0.99405903, 0.99423615, 0.99441067, \
0.99458259, 0.99475192, 0.99491865, 0.99508277, 0.99524427, \
0.99540316, 0.99555943, 0.99571308, 0.99586409, 0.99601248, \
0.99615823, 0.99630133, 0.99644180, 0.99657961, 0.99671477, \
0.99684727, 0.99697711, 0.99710428, 0.99722878, 0.99735061, \
0.99746976, 0.99758623, 0.99770000, 0.99781109, 0.99791948, \
0.99802518, 0.99812817, 0.99822845, 0.99832602, 0.99842087, \
0.99851300, 0.99860241, 0.99868908, 0.99877303, 0.99885424, \
0.99893270, 0.99900842, 0.99908139, 0.99915161, 0.99921906, \
0.99928376, 0.99934569, 0.99940485, 0.99946123, 0.99951483, \
0.99956565, 0.99961368, 0.99965892, 0.99970136, 0.99974101, \
0.99977785, 0.99981188, 0.99984309, 0.99987150, 0.99989707, \
0.99991983, 0.99993975, 0.99995684, 0.99997110, 0.99998251, \
0.99999107, 0.99999678, 0.99999964, } 


 #endif // _FPU_FFT_PARZEN_H_
//=============================================================================
// End of File
//=============================================================================
