#ifndef _RS_TABLESN255K239_H_
#define _RS_TABLESN255K239_H_
//#############################################################################
//! \file include/common/RS_TablesN255K239.h
//!
//! \brief  Galois Field Lookup Table for polynomial 0x0000011D 
//!         Field Generator Polynomial: x^{8}+x^{4}+x^{3}+x^{2}+1
//!
//! \date   Apr 7, 2011
//
//  Group: 			C2000
//  Target Family:	F2837x
//
//#############################################################################
//
//
// $Copyright: Copyright (C) 2022 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//#############################################################################
#include <stdint.h>

#define FIELDGENPOLY		0x0000011D 
#define TABLE_SIZE			256
#define NUM_ROOTS			16

#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_expTable ,2)
#endif //__cplusplus
const int16_t RS_expTable[TABLE_SIZE] = {
//| Decimal  | Index  | Polynomial 
//|   Form   |  Form  |   Form     
         1, // a^{  0}| 1
         2, // a^{  1}| a^{1}
         4, // a^{  2}| a^{2}
         8, // a^{  3}| a^{3}
        16, // a^{  4}| a^{4}
        32, // a^{  5}| a^{5}
        64, // a^{  6}| a^{6}
       128, // a^{  7}| a^{7}
        29, // a^{  8}| a^{4}+a^{3}+a^{2}+1
        58, // a^{  9}| a^{5}+a^{4}+a^{3}+a^{1}
       116, // a^{ 10}| a^{6}+a^{5}+a^{4}+a^{2}
       232, // a^{ 11}| a^{7}+a^{6}+a^{5}+a^{3}
       205, // a^{ 12}| a^{7}+a^{6}+a^{3}+a^{2}+1
       135, // a^{ 13}| a^{7}+a^{2}+a^{1}+1
        19, // a^{ 14}| a^{4}+a^{1}+1
        38, // a^{ 15}| a^{5}+a^{2}+a^{1}
        76, // a^{ 16}| a^{6}+a^{3}+a^{2}
       152, // a^{ 17}| a^{7}+a^{4}+a^{3}
        45, // a^{ 18}| a^{5}+a^{3}+a^{2}+1
        90, // a^{ 19}| a^{6}+a^{4}+a^{3}+a^{1}
       180, // a^{ 20}| a^{7}+a^{5}+a^{4}+a^{2}
       117, // a^{ 21}| a^{6}+a^{5}+a^{4}+a^{2}+1
       234, // a^{ 22}| a^{7}+a^{6}+a^{5}+a^{3}+a^{1}
       201, // a^{ 23}| a^{7}+a^{6}+a^{3}+1
       143, // a^{ 24}| a^{7}+a^{3}+a^{2}+a^{1}+1
         3, // a^{ 25}| a^{1}+1
         6, // a^{ 26}| a^{2}+a^{1}
        12, // a^{ 27}| a^{3}+a^{2}
        24, // a^{ 28}| a^{4}+a^{3}
        48, // a^{ 29}| a^{5}+a^{4}
        96, // a^{ 30}| a^{6}+a^{5}
       192, // a^{ 31}| a^{7}+a^{6}
       157, // a^{ 32}| a^{7}+a^{4}+a^{3}+a^{2}+1
        39, // a^{ 33}| a^{5}+a^{2}+a^{1}+1
        78, // a^{ 34}| a^{6}+a^{3}+a^{2}+a^{1}
       156, // a^{ 35}| a^{7}+a^{4}+a^{3}+a^{2}
        37, // a^{ 36}| a^{5}+a^{2}+1
        74, // a^{ 37}| a^{6}+a^{3}+a^{1}
       148, // a^{ 38}| a^{7}+a^{4}+a^{2}
        53, // a^{ 39}| a^{5}+a^{4}+a^{2}+1
       106, // a^{ 40}| a^{6}+a^{5}+a^{3}+a^{1}
       212, // a^{ 41}| a^{7}+a^{6}+a^{4}+a^{2}
       181, // a^{ 42}| a^{7}+a^{5}+a^{4}+a^{2}+1
       119, // a^{ 43}| a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       238, // a^{ 44}| a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
       193, // a^{ 45}| a^{7}+a^{6}+1
       159, // a^{ 46}| a^{7}+a^{4}+a^{3}+a^{2}+a^{1}+1
        35, // a^{ 47}| a^{5}+a^{1}+1
        70, // a^{ 48}| a^{6}+a^{2}+a^{1}
       140, // a^{ 49}| a^{7}+a^{3}+a^{2}
         5, // a^{ 50}| a^{2}+1
        10, // a^{ 51}| a^{3}+a^{1}
        20, // a^{ 52}| a^{4}+a^{2}
        40, // a^{ 53}| a^{5}+a^{3}
        80, // a^{ 54}| a^{6}+a^{4}
       160, // a^{ 55}| a^{7}+a^{5}
        93, // a^{ 56}| a^{6}+a^{4}+a^{3}+a^{2}+1
       186, // a^{ 57}| a^{7}+a^{5}+a^{4}+a^{3}+a^{1}
       105, // a^{ 58}| a^{6}+a^{5}+a^{3}+1
       210, // a^{ 59}| a^{7}+a^{6}+a^{4}+a^{1}
       185, // a^{ 60}| a^{7}+a^{5}+a^{4}+a^{3}+1
       111, // a^{ 61}| a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       222, // a^{ 62}| a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
       161, // a^{ 63}| a^{7}+a^{5}+1
        95, // a^{ 64}| a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       190, // a^{ 65}| a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        97, // a^{ 66}| a^{6}+a^{5}+1
       194, // a^{ 67}| a^{7}+a^{6}+a^{1}
       153, // a^{ 68}| a^{7}+a^{4}+a^{3}+1
        47, // a^{ 69}| a^{5}+a^{3}+a^{2}+a^{1}+1
        94, // a^{ 70}| a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
       188, // a^{ 71}| a^{7}+a^{5}+a^{4}+a^{3}+a^{2}
       101, // a^{ 72}| a^{6}+a^{5}+a^{2}+1
       202, // a^{ 73}| a^{7}+a^{6}+a^{3}+a^{1}
       137, // a^{ 74}| a^{7}+a^{3}+1
        15, // a^{ 75}| a^{3}+a^{2}+a^{1}+1
        30, // a^{ 76}| a^{4}+a^{3}+a^{2}+a^{1}
        60, // a^{ 77}| a^{5}+a^{4}+a^{3}+a^{2}
       120, // a^{ 78}| a^{6}+a^{5}+a^{4}+a^{3}
       240, // a^{ 79}| a^{7}+a^{6}+a^{5}+a^{4}
       253, // a^{ 80}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       231, // a^{ 81}| a^{7}+a^{6}+a^{5}+a^{2}+a^{1}+1
       211, // a^{ 82}| a^{7}+a^{6}+a^{4}+a^{1}+1
       187, // a^{ 83}| a^{7}+a^{5}+a^{4}+a^{3}+a^{1}+1
       107, // a^{ 84}| a^{6}+a^{5}+a^{3}+a^{1}+1
       214, // a^{ 85}| a^{7}+a^{6}+a^{4}+a^{2}+a^{1}
       177, // a^{ 86}| a^{7}+a^{5}+a^{4}+1
       127, // a^{ 87}| a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       254, // a^{ 88}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       225, // a^{ 89}| a^{7}+a^{6}+a^{5}+1
       223, // a^{ 90}| a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       163, // a^{ 91}| a^{7}+a^{5}+a^{1}+1
        91, // a^{ 92}| a^{6}+a^{4}+a^{3}+a^{1}+1
       182, // a^{ 93}| a^{7}+a^{5}+a^{4}+a^{2}+a^{1}
       113, // a^{ 94}| a^{6}+a^{5}+a^{4}+1
       226, // a^{ 95}| a^{7}+a^{6}+a^{5}+a^{1}
       217, // a^{ 96}| a^{7}+a^{6}+a^{4}+a^{3}+1
       175, // a^{ 97}| a^{7}+a^{5}+a^{3}+a^{2}+a^{1}+1
        67, // a^{ 98}| a^{6}+a^{1}+1
       134, // a^{ 99}| a^{7}+a^{2}+a^{1}
        17, // a^{100}| a^{4}+1
        34, // a^{101}| a^{5}+a^{1}
        68, // a^{102}| a^{6}+a^{2}
       136, // a^{103}| a^{7}+a^{3}
        13, // a^{104}| a^{3}+a^{2}+1
        26, // a^{105}| a^{4}+a^{3}+a^{1}
        52, // a^{106}| a^{5}+a^{4}+a^{2}
       104, // a^{107}| a^{6}+a^{5}+a^{3}
       208, // a^{108}| a^{7}+a^{6}+a^{4}
       189, // a^{109}| a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+1
       103, // a^{110}| a^{6}+a^{5}+a^{2}+a^{1}+1
       206, // a^{111}| a^{7}+a^{6}+a^{3}+a^{2}+a^{1}
       129, // a^{112}| a^{7}+1
        31, // a^{113}| a^{4}+a^{3}+a^{2}+a^{1}+1
        62, // a^{114}| a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       124, // a^{115}| a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
       248, // a^{116}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}
       237, // a^{117}| a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+1
       199, // a^{118}| a^{7}+a^{6}+a^{2}+a^{1}+1
       147, // a^{119}| a^{7}+a^{4}+a^{1}+1
        59, // a^{120}| a^{5}+a^{4}+a^{3}+a^{1}+1
       118, // a^{121}| a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
       236, // a^{122}| a^{7}+a^{6}+a^{5}+a^{3}+a^{2}
       197, // a^{123}| a^{7}+a^{6}+a^{2}+1
       151, // a^{124}| a^{7}+a^{4}+a^{2}+a^{1}+1
        51, // a^{125}| a^{5}+a^{4}+a^{1}+1
       102, // a^{126}| a^{6}+a^{5}+a^{2}+a^{1}
       204, // a^{127}| a^{7}+a^{6}+a^{3}+a^{2}
       133, // a^{128}| a^{7}+a^{2}+1
        23, // a^{129}| a^{4}+a^{2}+a^{1}+1
        46, // a^{130}| a^{5}+a^{3}+a^{2}+a^{1}
        92, // a^{131}| a^{6}+a^{4}+a^{3}+a^{2}
       184, // a^{132}| a^{7}+a^{5}+a^{4}+a^{3}
       109, // a^{133}| a^{6}+a^{5}+a^{3}+a^{2}+1
       218, // a^{134}| a^{7}+a^{6}+a^{4}+a^{3}+a^{1}
       169, // a^{135}| a^{7}+a^{5}+a^{3}+1
        79, // a^{136}| a^{6}+a^{3}+a^{2}+a^{1}+1
       158, // a^{137}| a^{7}+a^{4}+a^{3}+a^{2}+a^{1}
        33, // a^{138}| a^{5}+1
        66, // a^{139}| a^{6}+a^{1}
       132, // a^{140}| a^{7}+a^{2}
        21, // a^{141}| a^{4}+a^{2}+1
        42, // a^{142}| a^{5}+a^{3}+a^{1}
        84, // a^{143}| a^{6}+a^{4}+a^{2}
       168, // a^{144}| a^{7}+a^{5}+a^{3}
        77, // a^{145}| a^{6}+a^{3}+a^{2}+1
       154, // a^{146}| a^{7}+a^{4}+a^{3}+a^{1}
        41, // a^{147}| a^{5}+a^{3}+1
        82, // a^{148}| a^{6}+a^{4}+a^{1}
       164, // a^{149}| a^{7}+a^{5}+a^{2}
        85, // a^{150}| a^{6}+a^{4}+a^{2}+1
       170, // a^{151}| a^{7}+a^{5}+a^{3}+a^{1}
        73, // a^{152}| a^{6}+a^{3}+1
       146, // a^{153}| a^{7}+a^{4}+a^{1}
        57, // a^{154}| a^{5}+a^{4}+a^{3}+1
       114, // a^{155}| a^{6}+a^{5}+a^{4}+a^{1}
       228, // a^{156}| a^{7}+a^{6}+a^{5}+a^{2}
       213, // a^{157}| a^{7}+a^{6}+a^{4}+a^{2}+1
       183, // a^{158}| a^{7}+a^{5}+a^{4}+a^{2}+a^{1}+1
       115, // a^{159}| a^{6}+a^{5}+a^{4}+a^{1}+1
       230, // a^{160}| a^{7}+a^{6}+a^{5}+a^{2}+a^{1}
       209, // a^{161}| a^{7}+a^{6}+a^{4}+1
       191, // a^{162}| a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
        99, // a^{163}| a^{6}+a^{5}+a^{1}+1
       198, // a^{164}| a^{7}+a^{6}+a^{2}+a^{1}
       145, // a^{165}| a^{7}+a^{4}+1
        63, // a^{166}| a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       126, // a^{167}| a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       252, // a^{168}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
       229, // a^{169}| a^{7}+a^{6}+a^{5}+a^{2}+1
       215, // a^{170}| a^{7}+a^{6}+a^{4}+a^{2}+a^{1}+1
       179, // a^{171}| a^{7}+a^{5}+a^{4}+a^{1}+1
       123, // a^{172}| a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       246, // a^{173}| a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
       241, // a^{174}| a^{7}+a^{6}+a^{5}+a^{4}+1
       255, // a^{175}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       227, // a^{176}| a^{7}+a^{6}+a^{5}+a^{1}+1
       219, // a^{177}| a^{7}+a^{6}+a^{4}+a^{3}+a^{1}+1
       171, // a^{178}| a^{7}+a^{5}+a^{3}+a^{1}+1
        75, // a^{179}| a^{6}+a^{3}+a^{1}+1
       150, // a^{180}| a^{7}+a^{4}+a^{2}+a^{1}
        49, // a^{181}| a^{5}+a^{4}+1
        98, // a^{182}| a^{6}+a^{5}+a^{1}
       196, // a^{183}| a^{7}+a^{6}+a^{2}
       149, // a^{184}| a^{7}+a^{4}+a^{2}+1
        55, // a^{185}| a^{5}+a^{4}+a^{2}+a^{1}+1
       110, // a^{186}| a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
       220, // a^{187}| a^{7}+a^{6}+a^{4}+a^{3}+a^{2}
       165, // a^{188}| a^{7}+a^{5}+a^{2}+1
        87, // a^{189}| a^{6}+a^{4}+a^{2}+a^{1}+1
       174, // a^{190}| a^{7}+a^{5}+a^{3}+a^{2}+a^{1}
        65, // a^{191}| a^{6}+1
       130, // a^{192}| a^{7}+a^{1}
        25, // a^{193}| a^{4}+a^{3}+1
        50, // a^{194}| a^{5}+a^{4}+a^{1}
       100, // a^{195}| a^{6}+a^{5}+a^{2}
       200, // a^{196}| a^{7}+a^{6}+a^{3}
       141, // a^{197}| a^{7}+a^{3}+a^{2}+1
         7, // a^{198}| a^{2}+a^{1}+1
        14, // a^{199}| a^{3}+a^{2}+a^{1}
        28, // a^{200}| a^{4}+a^{3}+a^{2}
        56, // a^{201}| a^{5}+a^{4}+a^{3}
       112, // a^{202}| a^{6}+a^{5}+a^{4}
       224, // a^{203}| a^{7}+a^{6}+a^{5}
       221, // a^{204}| a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+1
       167, // a^{205}| a^{7}+a^{5}+a^{2}+a^{1}+1
        83, // a^{206}| a^{6}+a^{4}+a^{1}+1
       166, // a^{207}| a^{7}+a^{5}+a^{2}+a^{1}
        81, // a^{208}| a^{6}+a^{4}+1
       162, // a^{209}| a^{7}+a^{5}+a^{1}
        89, // a^{210}| a^{6}+a^{4}+a^{3}+1
       178, // a^{211}| a^{7}+a^{5}+a^{4}+a^{1}
       121, // a^{212}| a^{6}+a^{5}+a^{4}+a^{3}+1
       242, // a^{213}| a^{7}+a^{6}+a^{5}+a^{4}+a^{1}
       249, // a^{214}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+1
       239, // a^{215}| a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       195, // a^{216}| a^{7}+a^{6}+a^{1}+1
       155, // a^{217}| a^{7}+a^{4}+a^{3}+a^{1}+1
        43, // a^{218}| a^{5}+a^{3}+a^{1}+1
        86, // a^{219}| a^{6}+a^{4}+a^{2}+a^{1}
       172, // a^{220}| a^{7}+a^{5}+a^{3}+a^{2}
        69, // a^{221}| a^{6}+a^{2}+1
       138, // a^{222}| a^{7}+a^{3}+a^{1}
         9, // a^{223}| a^{3}+1
        18, // a^{224}| a^{4}+a^{1}
        36, // a^{225}| a^{5}+a^{2}
        72, // a^{226}| a^{6}+a^{3}
       144, // a^{227}| a^{7}+a^{4}
        61, // a^{228}| a^{5}+a^{4}+a^{3}+a^{2}+1
       122, // a^{229}| a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
       244, // a^{230}| a^{7}+a^{6}+a^{5}+a^{4}+a^{2}
       245, // a^{231}| a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+1
       247, // a^{232}| a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       243, // a^{233}| a^{7}+a^{6}+a^{5}+a^{4}+a^{1}+1
       251, // a^{234}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       235, // a^{235}| a^{7}+a^{6}+a^{5}+a^{3}+a^{1}+1
       203, // a^{236}| a^{7}+a^{6}+a^{3}+a^{1}+1
       139, // a^{237}| a^{7}+a^{3}+a^{1}+1
        11, // a^{238}| a^{3}+a^{1}+1
        22, // a^{239}| a^{4}+a^{2}+a^{1}
        44, // a^{240}| a^{5}+a^{3}+a^{2}
        88, // a^{241}| a^{6}+a^{4}+a^{3}
       176, // a^{242}| a^{7}+a^{5}+a^{4}
       125, // a^{243}| a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       250, // a^{244}| a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
       233, // a^{245}| a^{7}+a^{6}+a^{5}+a^{3}+1
       207, // a^{246}| a^{7}+a^{6}+a^{3}+a^{2}+a^{1}+1
       131, // a^{247}| a^{7}+a^{1}+1
        27, // a^{248}| a^{4}+a^{3}+a^{1}+1
        54, // a^{249}| a^{5}+a^{4}+a^{2}+a^{1}
       108, // a^{250}| a^{6}+a^{5}+a^{3}+a^{2}
       216, // a^{251}| a^{7}+a^{6}+a^{4}+a^{3}
       173, // a^{252}| a^{7}+a^{5}+a^{3}+a^{2}+1
        71, // a^{253}| a^{6}+a^{2}+a^{1}+1
       142, // a^{254}| a^{7}+a^{3}+a^{2}+a^{1}
        -1, // -Inf   | a^{-Inf}
};
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_logTable ,2)
#endif //__cplusplus
const int16_t RS_logTable[TABLE_SIZE] = {
// Index     | Index   | Decimal  |Polynomial 
// Exponent  | Form    | Form     | Form 
       255, // a^{-Inf}|   -Inf   | a^{-Inf}
         0, // a^{  0} |     1    | 1
         1, // a^{  1} |     2    | a^{1}
        25, // a^{ 25} |     3    | a^{1}+1
         2, // a^{  2} |     4    | a^{2}
        50, // a^{ 50} |     5    | a^{2}+1
        26, // a^{ 26} |     6    | a^{2}+a^{1}
       198, // a^{198} |     7    | a^{2}+a^{1}+1
         3, // a^{  3} |     8    | a^{3}
       223, // a^{223} |     9    | a^{3}+1
        51, // a^{ 51} |    10    | a^{3}+a^{1}
       238, // a^{238} |    11    | a^{3}+a^{1}+1
        27, // a^{ 27} |    12    | a^{3}+a^{2}
       104, // a^{104} |    13    | a^{3}+a^{2}+1
       199, // a^{199} |    14    | a^{3}+a^{2}+a^{1}
        75, // a^{ 75} |    15    | a^{3}+a^{2}+a^{1}+1
         4, // a^{  4} |    16    | a^{4}
       100, // a^{100} |    17    | a^{4}+1
       224, // a^{224} |    18    | a^{4}+a^{1}
        14, // a^{ 14} |    19    | a^{4}+a^{1}+1
        52, // a^{ 52} |    20    | a^{4}+a^{2}
       141, // a^{141} |    21    | a^{4}+a^{2}+1
       239, // a^{239} |    22    | a^{4}+a^{2}+a^{1}
       129, // a^{129} |    23    | a^{4}+a^{2}+a^{1}+1
        28, // a^{ 28} |    24    | a^{4}+a^{3}
       193, // a^{193} |    25    | a^{4}+a^{3}+1
       105, // a^{105} |    26    | a^{4}+a^{3}+a^{1}
       248, // a^{248} |    27    | a^{4}+a^{3}+a^{1}+1
       200, // a^{200} |    28    | a^{4}+a^{3}+a^{2}
         8, // a^{  8} |    29    | a^{4}+a^{3}+a^{2}+1
        76, // a^{ 76} |    30    | a^{4}+a^{3}+a^{2}+a^{1}
       113, // a^{113} |    31    | a^{4}+a^{3}+a^{2}+a^{1}+1
         5, // a^{  5} |    32    | a^{5}
       138, // a^{138} |    33    | a^{5}+1
       101, // a^{101} |    34    | a^{5}+a^{1}
        47, // a^{ 47} |    35    | a^{5}+a^{1}+1
       225, // a^{225} |    36    | a^{5}+a^{2}
        36, // a^{ 36} |    37    | a^{5}+a^{2}+1
        15, // a^{ 15} |    38    | a^{5}+a^{2}+a^{1}
        33, // a^{ 33} |    39    | a^{5}+a^{2}+a^{1}+1
        53, // a^{ 53} |    40    | a^{5}+a^{3}
       147, // a^{147} |    41    | a^{5}+a^{3}+1
       142, // a^{142} |    42    | a^{5}+a^{3}+a^{1}
       218, // a^{218} |    43    | a^{5}+a^{3}+a^{1}+1
       240, // a^{240} |    44    | a^{5}+a^{3}+a^{2}
        18, // a^{ 18} |    45    | a^{5}+a^{3}+a^{2}+1
       130, // a^{130} |    46    | a^{5}+a^{3}+a^{2}+a^{1}
        69, // a^{ 69} |    47    | a^{5}+a^{3}+a^{2}+a^{1}+1
        29, // a^{ 29} |    48    | a^{5}+a^{4}
       181, // a^{181} |    49    | a^{5}+a^{4}+1
       194, // a^{194} |    50    | a^{5}+a^{4}+a^{1}
       125, // a^{125} |    51    | a^{5}+a^{4}+a^{1}+1
       106, // a^{106} |    52    | a^{5}+a^{4}+a^{2}
        39, // a^{ 39} |    53    | a^{5}+a^{4}+a^{2}+1
       249, // a^{249} |    54    | a^{5}+a^{4}+a^{2}+a^{1}
       185, // a^{185} |    55    | a^{5}+a^{4}+a^{2}+a^{1}+1
       201, // a^{201} |    56    | a^{5}+a^{4}+a^{3}
       154, // a^{154} |    57    | a^{5}+a^{4}+a^{3}+1
         9, // a^{  9} |    58    | a^{5}+a^{4}+a^{3}+a^{1}
       120, // a^{120} |    59    | a^{5}+a^{4}+a^{3}+a^{1}+1
        77, // a^{ 77} |    60    | a^{5}+a^{4}+a^{3}+a^{2}
       228, // a^{228} |    61    | a^{5}+a^{4}+a^{3}+a^{2}+1
       114, // a^{114} |    62    | a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       166, // a^{166} |    63    | a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
         6, // a^{  6} |    64    | a^{6}
       191, // a^{191} |    65    | a^{6}+1
       139, // a^{139} |    66    | a^{6}+a^{1}
        98, // a^{ 98} |    67    | a^{6}+a^{1}+1
       102, // a^{102} |    68    | a^{6}+a^{2}
       221, // a^{221} |    69    | a^{6}+a^{2}+1
        48, // a^{ 48} |    70    | a^{6}+a^{2}+a^{1}
       253, // a^{253} |    71    | a^{6}+a^{2}+a^{1}+1
       226, // a^{226} |    72    | a^{6}+a^{3}
       152, // a^{152} |    73    | a^{6}+a^{3}+1
        37, // a^{ 37} |    74    | a^{6}+a^{3}+a^{1}
       179, // a^{179} |    75    | a^{6}+a^{3}+a^{1}+1
        16, // a^{ 16} |    76    | a^{6}+a^{3}+a^{2}
       145, // a^{145} |    77    | a^{6}+a^{3}+a^{2}+1
        34, // a^{ 34} |    78    | a^{6}+a^{3}+a^{2}+a^{1}
       136, // a^{136} |    79    | a^{6}+a^{3}+a^{2}+a^{1}+1
        54, // a^{ 54} |    80    | a^{6}+a^{4}
       208, // a^{208} |    81    | a^{6}+a^{4}+1
       148, // a^{148} |    82    | a^{6}+a^{4}+a^{1}
       206, // a^{206} |    83    | a^{6}+a^{4}+a^{1}+1
       143, // a^{143} |    84    | a^{6}+a^{4}+a^{2}
       150, // a^{150} |    85    | a^{6}+a^{4}+a^{2}+1
       219, // a^{219} |    86    | a^{6}+a^{4}+a^{2}+a^{1}
       189, // a^{189} |    87    | a^{6}+a^{4}+a^{2}+a^{1}+1
       241, // a^{241} |    88    | a^{6}+a^{4}+a^{3}
       210, // a^{210} |    89    | a^{6}+a^{4}+a^{3}+1
        19, // a^{ 19} |    90    | a^{6}+a^{4}+a^{3}+a^{1}
        92, // a^{ 92} |    91    | a^{6}+a^{4}+a^{3}+a^{1}+1
       131, // a^{131} |    92    | a^{6}+a^{4}+a^{3}+a^{2}
        56, // a^{ 56} |    93    | a^{6}+a^{4}+a^{3}+a^{2}+1
        70, // a^{ 70} |    94    | a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
        64, // a^{ 64} |    95    | a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
        30, // a^{ 30} |    96    | a^{6}+a^{5}
        66, // a^{ 66} |    97    | a^{6}+a^{5}+1
       182, // a^{182} |    98    | a^{6}+a^{5}+a^{1}
       163, // a^{163} |    99    | a^{6}+a^{5}+a^{1}+1
       195, // a^{195} |   100    | a^{6}+a^{5}+a^{2}
        72, // a^{ 72} |   101    | a^{6}+a^{5}+a^{2}+1
       126, // a^{126} |   102    | a^{6}+a^{5}+a^{2}+a^{1}
       110, // a^{110} |   103    | a^{6}+a^{5}+a^{2}+a^{1}+1
       107, // a^{107} |   104    | a^{6}+a^{5}+a^{3}
        58, // a^{ 58} |   105    | a^{6}+a^{5}+a^{3}+1
        40, // a^{ 40} |   106    | a^{6}+a^{5}+a^{3}+a^{1}
        84, // a^{ 84} |   107    | a^{6}+a^{5}+a^{3}+a^{1}+1
       250, // a^{250} |   108    | a^{6}+a^{5}+a^{3}+a^{2}
       133, // a^{133} |   109    | a^{6}+a^{5}+a^{3}+a^{2}+1
       186, // a^{186} |   110    | a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
        61, // a^{ 61} |   111    | a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       202, // a^{202} |   112    | a^{6}+a^{5}+a^{4}
        94, // a^{ 94} |   113    | a^{6}+a^{5}+a^{4}+1
       155, // a^{155} |   114    | a^{6}+a^{5}+a^{4}+a^{1}
       159, // a^{159} |   115    | a^{6}+a^{5}+a^{4}+a^{1}+1
        10, // a^{ 10} |   116    | a^{6}+a^{5}+a^{4}+a^{2}
        21, // a^{ 21} |   117    | a^{6}+a^{5}+a^{4}+a^{2}+1
       121, // a^{121} |   118    | a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
        43, // a^{ 43} |   119    | a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
        78, // a^{ 78} |   120    | a^{6}+a^{5}+a^{4}+a^{3}
       212, // a^{212} |   121    | a^{6}+a^{5}+a^{4}+a^{3}+1
       229, // a^{229} |   122    | a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
       172, // a^{172} |   123    | a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       115, // a^{115} |   124    | a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
       243, // a^{243} |   125    | a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       167, // a^{167} |   126    | a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        87, // a^{ 87} |   127    | a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
         7, // a^{  7} |   128    | a^{7}
       112, // a^{112} |   129    | a^{7}+1
       192, // a^{192} |   130    | a^{7}+a^{1}
       247, // a^{247} |   131    | a^{7}+a^{1}+1
       140, // a^{140} |   132    | a^{7}+a^{2}
       128, // a^{128} |   133    | a^{7}+a^{2}+1
        99, // a^{ 99} |   134    | a^{7}+a^{2}+a^{1}
        13, // a^{ 13} |   135    | a^{7}+a^{2}+a^{1}+1
       103, // a^{103} |   136    | a^{7}+a^{3}
        74, // a^{ 74} |   137    | a^{7}+a^{3}+1
       222, // a^{222} |   138    | a^{7}+a^{3}+a^{1}
       237, // a^{237} |   139    | a^{7}+a^{3}+a^{1}+1
        49, // a^{ 49} |   140    | a^{7}+a^{3}+a^{2}
       197, // a^{197} |   141    | a^{7}+a^{3}+a^{2}+1
       254, // a^{254} |   142    | a^{7}+a^{3}+a^{2}+a^{1}
        24, // a^{ 24} |   143    | a^{7}+a^{3}+a^{2}+a^{1}+1
       227, // a^{227} |   144    | a^{7}+a^{4}
       165, // a^{165} |   145    | a^{7}+a^{4}+1
       153, // a^{153} |   146    | a^{7}+a^{4}+a^{1}
       119, // a^{119} |   147    | a^{7}+a^{4}+a^{1}+1
        38, // a^{ 38} |   148    | a^{7}+a^{4}+a^{2}
       184, // a^{184} |   149    | a^{7}+a^{4}+a^{2}+1
       180, // a^{180} |   150    | a^{7}+a^{4}+a^{2}+a^{1}
       124, // a^{124} |   151    | a^{7}+a^{4}+a^{2}+a^{1}+1
        17, // a^{ 17} |   152    | a^{7}+a^{4}+a^{3}
        68, // a^{ 68} |   153    | a^{7}+a^{4}+a^{3}+1
       146, // a^{146} |   154    | a^{7}+a^{4}+a^{3}+a^{1}
       217, // a^{217} |   155    | a^{7}+a^{4}+a^{3}+a^{1}+1
        35, // a^{ 35} |   156    | a^{7}+a^{4}+a^{3}+a^{2}
        32, // a^{ 32} |   157    | a^{7}+a^{4}+a^{3}+a^{2}+1
       137, // a^{137} |   158    | a^{7}+a^{4}+a^{3}+a^{2}+a^{1}
        46, // a^{ 46} |   159    | a^{7}+a^{4}+a^{3}+a^{2}+a^{1}+1
        55, // a^{ 55} |   160    | a^{7}+a^{5}
        63, // a^{ 63} |   161    | a^{7}+a^{5}+1
       209, // a^{209} |   162    | a^{7}+a^{5}+a^{1}
        91, // a^{ 91} |   163    | a^{7}+a^{5}+a^{1}+1
       149, // a^{149} |   164    | a^{7}+a^{5}+a^{2}
       188, // a^{188} |   165    | a^{7}+a^{5}+a^{2}+1
       207, // a^{207} |   166    | a^{7}+a^{5}+a^{2}+a^{1}
       205, // a^{205} |   167    | a^{7}+a^{5}+a^{2}+a^{1}+1
       144, // a^{144} |   168    | a^{7}+a^{5}+a^{3}
       135, // a^{135} |   169    | a^{7}+a^{5}+a^{3}+1
       151, // a^{151} |   170    | a^{7}+a^{5}+a^{3}+a^{1}
       178, // a^{178} |   171    | a^{7}+a^{5}+a^{3}+a^{1}+1
       220, // a^{220} |   172    | a^{7}+a^{5}+a^{3}+a^{2}
       252, // a^{252} |   173    | a^{7}+a^{5}+a^{3}+a^{2}+1
       190, // a^{190} |   174    | a^{7}+a^{5}+a^{3}+a^{2}+a^{1}
        97, // a^{ 97} |   175    | a^{7}+a^{5}+a^{3}+a^{2}+a^{1}+1
       242, // a^{242} |   176    | a^{7}+a^{5}+a^{4}
        86, // a^{ 86} |   177    | a^{7}+a^{5}+a^{4}+1
       211, // a^{211} |   178    | a^{7}+a^{5}+a^{4}+a^{1}
       171, // a^{171} |   179    | a^{7}+a^{5}+a^{4}+a^{1}+1
        20, // a^{ 20} |   180    | a^{7}+a^{5}+a^{4}+a^{2}
        42, // a^{ 42} |   181    | a^{7}+a^{5}+a^{4}+a^{2}+1
        93, // a^{ 93} |   182    | a^{7}+a^{5}+a^{4}+a^{2}+a^{1}
       158, // a^{158} |   183    | a^{7}+a^{5}+a^{4}+a^{2}+a^{1}+1
       132, // a^{132} |   184    | a^{7}+a^{5}+a^{4}+a^{3}
        60, // a^{ 60} |   185    | a^{7}+a^{5}+a^{4}+a^{3}+1
        57, // a^{ 57} |   186    | a^{7}+a^{5}+a^{4}+a^{3}+a^{1}
        83, // a^{ 83} |   187    | a^{7}+a^{5}+a^{4}+a^{3}+a^{1}+1
        71, // a^{ 71} |   188    | a^{7}+a^{5}+a^{4}+a^{3}+a^{2}
       109, // a^{109} |   189    | a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+1
        65, // a^{ 65} |   190    | a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       162, // a^{162} |   191    | a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
        31, // a^{ 31} |   192    | a^{7}+a^{6}
        45, // a^{ 45} |   193    | a^{7}+a^{6}+1
        67, // a^{ 67} |   194    | a^{7}+a^{6}+a^{1}
       216, // a^{216} |   195    | a^{7}+a^{6}+a^{1}+1
       183, // a^{183} |   196    | a^{7}+a^{6}+a^{2}
       123, // a^{123} |   197    | a^{7}+a^{6}+a^{2}+1
       164, // a^{164} |   198    | a^{7}+a^{6}+a^{2}+a^{1}
       118, // a^{118} |   199    | a^{7}+a^{6}+a^{2}+a^{1}+1
       196, // a^{196} |   200    | a^{7}+a^{6}+a^{3}
        23, // a^{ 23} |   201    | a^{7}+a^{6}+a^{3}+1
        73, // a^{ 73} |   202    | a^{7}+a^{6}+a^{3}+a^{1}
       236, // a^{236} |   203    | a^{7}+a^{6}+a^{3}+a^{1}+1
       127, // a^{127} |   204    | a^{7}+a^{6}+a^{3}+a^{2}
        12, // a^{ 12} |   205    | a^{7}+a^{6}+a^{3}+a^{2}+1
       111, // a^{111} |   206    | a^{7}+a^{6}+a^{3}+a^{2}+a^{1}
       246, // a^{246} |   207    | a^{7}+a^{6}+a^{3}+a^{2}+a^{1}+1
       108, // a^{108} |   208    | a^{7}+a^{6}+a^{4}
       161, // a^{161} |   209    | a^{7}+a^{6}+a^{4}+1
        59, // a^{ 59} |   210    | a^{7}+a^{6}+a^{4}+a^{1}
        82, // a^{ 82} |   211    | a^{7}+a^{6}+a^{4}+a^{1}+1
        41, // a^{ 41} |   212    | a^{7}+a^{6}+a^{4}+a^{2}
       157, // a^{157} |   213    | a^{7}+a^{6}+a^{4}+a^{2}+1
        85, // a^{ 85} |   214    | a^{7}+a^{6}+a^{4}+a^{2}+a^{1}
       170, // a^{170} |   215    | a^{7}+a^{6}+a^{4}+a^{2}+a^{1}+1
       251, // a^{251} |   216    | a^{7}+a^{6}+a^{4}+a^{3}
        96, // a^{ 96} |   217    | a^{7}+a^{6}+a^{4}+a^{3}+1
       134, // a^{134} |   218    | a^{7}+a^{6}+a^{4}+a^{3}+a^{1}
       177, // a^{177} |   219    | a^{7}+a^{6}+a^{4}+a^{3}+a^{1}+1
       187, // a^{187} |   220    | a^{7}+a^{6}+a^{4}+a^{3}+a^{2}
       204, // a^{204} |   221    | a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+1
        62, // a^{ 62} |   222    | a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
        90, // a^{ 90} |   223    | a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       203, // a^{203} |   224    | a^{7}+a^{6}+a^{5}
        89, // a^{ 89} |   225    | a^{7}+a^{6}+a^{5}+1
        95, // a^{ 95} |   226    | a^{7}+a^{6}+a^{5}+a^{1}
       176, // a^{176} |   227    | a^{7}+a^{6}+a^{5}+a^{1}+1
       156, // a^{156} |   228    | a^{7}+a^{6}+a^{5}+a^{2}
       169, // a^{169} |   229    | a^{7}+a^{6}+a^{5}+a^{2}+1
       160, // a^{160} |   230    | a^{7}+a^{6}+a^{5}+a^{2}+a^{1}
        81, // a^{ 81} |   231    | a^{7}+a^{6}+a^{5}+a^{2}+a^{1}+1
        11, // a^{ 11} |   232    | a^{7}+a^{6}+a^{5}+a^{3}
       245, // a^{245} |   233    | a^{7}+a^{6}+a^{5}+a^{3}+1
        22, // a^{ 22} |   234    | a^{7}+a^{6}+a^{5}+a^{3}+a^{1}
       235, // a^{235} |   235    | a^{7}+a^{6}+a^{5}+a^{3}+a^{1}+1
       122, // a^{122} |   236    | a^{7}+a^{6}+a^{5}+a^{3}+a^{2}
       117, // a^{117} |   237    | a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+1
        44, // a^{ 44} |   238    | a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
       215, // a^{215} |   239    | a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
        79, // a^{ 79} |   240    | a^{7}+a^{6}+a^{5}+a^{4}
       174, // a^{174} |   241    | a^{7}+a^{6}+a^{5}+a^{4}+1
       213, // a^{213} |   242    | a^{7}+a^{6}+a^{5}+a^{4}+a^{1}
       233, // a^{233} |   243    | a^{7}+a^{6}+a^{5}+a^{4}+a^{1}+1
       230, // a^{230} |   244    | a^{7}+a^{6}+a^{5}+a^{4}+a^{2}
       231, // a^{231} |   245    | a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+1
       173, // a^{173} |   246    | a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
       232, // a^{232} |   247    | a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       116, // a^{116} |   248    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}
       214, // a^{214} |   249    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+1
       244, // a^{244} |   250    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
       234, // a^{234} |   251    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       168, // a^{168} |   252    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
        80, // a^{ 80} |   253    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
        88, // a^{ 88} |   254    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       175, // a^{175} |   255    | a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
};
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_expInvTable ,2)
#endif //__cplusplus
const int16_t RS_expInvTable[TABLE_SIZE] = {
// Decimal   | Index    | Inverse   |Polynomial 
//   Form    |  Form    |   Of      | Form  
         1, // a^{  0}  |  a^{  0}  |  1
       142, // a^{  1}  |  a^{254}  |  a^{7}+a^{3}+a^{2}+a^{1}
        71, // a^{  2}  |  a^{253}  |  a^{6}+a^{2}+a^{1}+1
       173, // a^{  3}  |  a^{252}  |  a^{7}+a^{5}+a^{3}+a^{2}+1
       216, // a^{  4}  |  a^{251}  |  a^{7}+a^{6}+a^{4}+a^{3}
       108, // a^{  5}  |  a^{250}  |  a^{6}+a^{5}+a^{3}+a^{2}
        54, // a^{  6}  |  a^{249}  |  a^{5}+a^{4}+a^{2}+a^{1}
        27, // a^{  7}  |  a^{248}  |  a^{4}+a^{3}+a^{1}+1
       131, // a^{  8}  |  a^{247}  |  a^{7}+a^{1}+1
       207, // a^{  9}  |  a^{246}  |  a^{7}+a^{6}+a^{3}+a^{2}+a^{1}+1
       233, // a^{ 10}  |  a^{245}  |  a^{7}+a^{6}+a^{5}+a^{3}+1
       250, // a^{ 11}  |  a^{244}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
       125, // a^{ 12}  |  a^{243}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       176, // a^{ 13}  |  a^{242}  |  a^{7}+a^{5}+a^{4}
        88, // a^{ 14}  |  a^{241}  |  a^{6}+a^{4}+a^{3}
        44, // a^{ 15}  |  a^{240}  |  a^{5}+a^{3}+a^{2}
        22, // a^{ 16}  |  a^{239}  |  a^{4}+a^{2}+a^{1}
        11, // a^{ 17}  |  a^{238}  |  a^{3}+a^{1}+1
       139, // a^{ 18}  |  a^{237}  |  a^{7}+a^{3}+a^{1}+1
       203, // a^{ 19}  |  a^{236}  |  a^{7}+a^{6}+a^{3}+a^{1}+1
       235, // a^{ 20}  |  a^{235}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{1}+1
       251, // a^{ 21}  |  a^{234}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       243, // a^{ 22}  |  a^{233}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{1}+1
       247, // a^{ 23}  |  a^{232}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       245, // a^{ 24}  |  a^{231}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+1
       244, // a^{ 25}  |  a^{230}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}
       122, // a^{ 26}  |  a^{229}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
        61, // a^{ 27}  |  a^{228}  |  a^{5}+a^{4}+a^{3}+a^{2}+1
       144, // a^{ 28}  |  a^{227}  |  a^{7}+a^{4}
        72, // a^{ 29}  |  a^{226}  |  a^{6}+a^{3}
        36, // a^{ 30}  |  a^{225}  |  a^{5}+a^{2}
        18, // a^{ 31}  |  a^{224}  |  a^{4}+a^{1}
         9, // a^{ 32}  |  a^{223}  |  a^{3}+1
       138, // a^{ 33}  |  a^{222}  |  a^{7}+a^{3}+a^{1}
        69, // a^{ 34}  |  a^{221}  |  a^{6}+a^{2}+1
       172, // a^{ 35}  |  a^{220}  |  a^{7}+a^{5}+a^{3}+a^{2}
        86, // a^{ 36}  |  a^{219}  |  a^{6}+a^{4}+a^{2}+a^{1}
        43, // a^{ 37}  |  a^{218}  |  a^{5}+a^{3}+a^{1}+1
       155, // a^{ 38}  |  a^{217}  |  a^{7}+a^{4}+a^{3}+a^{1}+1
       195, // a^{ 39}  |  a^{216}  |  a^{7}+a^{6}+a^{1}+1
       239, // a^{ 40}  |  a^{215}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       249, // a^{ 41}  |  a^{214}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+1
       242, // a^{ 42}  |  a^{213}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{1}
       121, // a^{ 43}  |  a^{212}  |  a^{6}+a^{5}+a^{4}+a^{3}+1
       178, // a^{ 44}  |  a^{211}  |  a^{7}+a^{5}+a^{4}+a^{1}
        89, // a^{ 45}  |  a^{210}  |  a^{6}+a^{4}+a^{3}+1
       162, // a^{ 46}  |  a^{209}  |  a^{7}+a^{5}+a^{1}
        81, // a^{ 47}  |  a^{208}  |  a^{6}+a^{4}+1
       166, // a^{ 48}  |  a^{207}  |  a^{7}+a^{5}+a^{2}+a^{1}
        83, // a^{ 49}  |  a^{206}  |  a^{6}+a^{4}+a^{1}+1
       167, // a^{ 50}  |  a^{205}  |  a^{7}+a^{5}+a^{2}+a^{1}+1
       221, // a^{ 51}  |  a^{204}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+1
       224, // a^{ 52}  |  a^{203}  |  a^{7}+a^{6}+a^{5}
       112, // a^{ 53}  |  a^{202}  |  a^{6}+a^{5}+a^{4}
        56, // a^{ 54}  |  a^{201}  |  a^{5}+a^{4}+a^{3}
        28, // a^{ 55}  |  a^{200}  |  a^{4}+a^{3}+a^{2}
        14, // a^{ 56}  |  a^{199}  |  a^{3}+a^{2}+a^{1}
         7, // a^{ 57}  |  a^{198}  |  a^{2}+a^{1}+1
       141, // a^{ 58}  |  a^{197}  |  a^{7}+a^{3}+a^{2}+1
       200, // a^{ 59}  |  a^{196}  |  a^{7}+a^{6}+a^{3}
       100, // a^{ 60}  |  a^{195}  |  a^{6}+a^{5}+a^{2}
        50, // a^{ 61}  |  a^{194}  |  a^{5}+a^{4}+a^{1}
        25, // a^{ 62}  |  a^{193}  |  a^{4}+a^{3}+1
       130, // a^{ 63}  |  a^{192}  |  a^{7}+a^{1}
        65, // a^{ 64}  |  a^{191}  |  a^{6}+1
       174, // a^{ 65}  |  a^{190}  |  a^{7}+a^{5}+a^{3}+a^{2}+a^{1}
        87, // a^{ 66}  |  a^{189}  |  a^{6}+a^{4}+a^{2}+a^{1}+1
       165, // a^{ 67}  |  a^{188}  |  a^{7}+a^{5}+a^{2}+1
       220, // a^{ 68}  |  a^{187}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}
       110, // a^{ 69}  |  a^{186}  |  a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
        55, // a^{ 70}  |  a^{185}  |  a^{5}+a^{4}+a^{2}+a^{1}+1
       149, // a^{ 71}  |  a^{184}  |  a^{7}+a^{4}+a^{2}+1
       196, // a^{ 72}  |  a^{183}  |  a^{7}+a^{6}+a^{2}
        98, // a^{ 73}  |  a^{182}  |  a^{6}+a^{5}+a^{1}
        49, // a^{ 74}  |  a^{181}  |  a^{5}+a^{4}+1
       150, // a^{ 75}  |  a^{180}  |  a^{7}+a^{4}+a^{2}+a^{1}
        75, // a^{ 76}  |  a^{179}  |  a^{6}+a^{3}+a^{1}+1
       171, // a^{ 77}  |  a^{178}  |  a^{7}+a^{5}+a^{3}+a^{1}+1
       219, // a^{ 78}  |  a^{177}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{1}+1
       227, // a^{ 79}  |  a^{176}  |  a^{7}+a^{6}+a^{5}+a^{1}+1
       255, // a^{ 80}  |  a^{175}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       241, // a^{ 81}  |  a^{174}  |  a^{7}+a^{6}+a^{5}+a^{4}+1
       246, // a^{ 82}  |  a^{173}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
       123, // a^{ 83}  |  a^{172}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       179, // a^{ 84}  |  a^{171}  |  a^{7}+a^{5}+a^{4}+a^{1}+1
       215, // a^{ 85}  |  a^{170}  |  a^{7}+a^{6}+a^{4}+a^{2}+a^{1}+1
       229, // a^{ 86}  |  a^{169}  |  a^{7}+a^{6}+a^{5}+a^{2}+1
       252, // a^{ 87}  |  a^{168}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
       126, // a^{ 88}  |  a^{167}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        63, // a^{ 89}  |  a^{166}  |  a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       145, // a^{ 90}  |  a^{165}  |  a^{7}+a^{4}+1
       198, // a^{ 91}  |  a^{164}  |  a^{7}+a^{6}+a^{2}+a^{1}
        99, // a^{ 92}  |  a^{163}  |  a^{6}+a^{5}+a^{1}+1
       191, // a^{ 93}  |  a^{162}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       209, // a^{ 94}  |  a^{161}  |  a^{7}+a^{6}+a^{4}+1
       230, // a^{ 95}  |  a^{160}  |  a^{7}+a^{6}+a^{5}+a^{2}+a^{1}
       115, // a^{ 96}  |  a^{159}  |  a^{6}+a^{5}+a^{4}+a^{1}+1
       183, // a^{ 97}  |  a^{158}  |  a^{7}+a^{5}+a^{4}+a^{2}+a^{1}+1
       213, // a^{ 98}  |  a^{157}  |  a^{7}+a^{6}+a^{4}+a^{2}+1
       228, // a^{ 99}  |  a^{156}  |  a^{7}+a^{6}+a^{5}+a^{2}
       114, // a^{100}  |  a^{155}  |  a^{6}+a^{5}+a^{4}+a^{1}
        57, // a^{101}  |  a^{154}  |  a^{5}+a^{4}+a^{3}+1
       146, // a^{102}  |  a^{153}  |  a^{7}+a^{4}+a^{1}
        73, // a^{103}  |  a^{152}  |  a^{6}+a^{3}+1
       170, // a^{104}  |  a^{151}  |  a^{7}+a^{5}+a^{3}+a^{1}
        85, // a^{105}  |  a^{150}  |  a^{6}+a^{4}+a^{2}+1
       164, // a^{106}  |  a^{149}  |  a^{7}+a^{5}+a^{2}
        82, // a^{107}  |  a^{148}  |  a^{6}+a^{4}+a^{1}
        41, // a^{108}  |  a^{147}  |  a^{5}+a^{3}+1
       154, // a^{109}  |  a^{146}  |  a^{7}+a^{4}+a^{3}+a^{1}
        77, // a^{110}  |  a^{145}  |  a^{6}+a^{3}+a^{2}+1
       168, // a^{111}  |  a^{144}  |  a^{7}+a^{5}+a^{3}
        84, // a^{112}  |  a^{143}  |  a^{6}+a^{4}+a^{2}
        42, // a^{113}  |  a^{142}  |  a^{5}+a^{3}+a^{1}
        21, // a^{114}  |  a^{141}  |  a^{4}+a^{2}+1
       132, // a^{115}  |  a^{140}  |  a^{7}+a^{2}
        66, // a^{116}  |  a^{139}  |  a^{6}+a^{1}
        33, // a^{117}  |  a^{138}  |  a^{5}+1
       158, // a^{118}  |  a^{137}  |  a^{7}+a^{4}+a^{3}+a^{2}+a^{1}
        79, // a^{119}  |  a^{136}  |  a^{6}+a^{3}+a^{2}+a^{1}+1
       169, // a^{120}  |  a^{135}  |  a^{7}+a^{5}+a^{3}+1
       218, // a^{121}  |  a^{134}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{1}
       109, // a^{122}  |  a^{133}  |  a^{6}+a^{5}+a^{3}+a^{2}+1
       184, // a^{123}  |  a^{132}  |  a^{7}+a^{5}+a^{4}+a^{3}
        92, // a^{124}  |  a^{131}  |  a^{6}+a^{4}+a^{3}+a^{2}
        46, // a^{125}  |  a^{130}  |  a^{5}+a^{3}+a^{2}+a^{1}
        23, // a^{126}  |  a^{129}  |  a^{4}+a^{2}+a^{1}+1
       133, // a^{127}  |  a^{128}  |  a^{7}+a^{2}+1
       204, // a^{128}  |  a^{127}  |  a^{7}+a^{6}+a^{3}+a^{2}
       102, // a^{129}  |  a^{126}  |  a^{6}+a^{5}+a^{2}+a^{1}
        51, // a^{130}  |  a^{125}  |  a^{5}+a^{4}+a^{1}+1
       151, // a^{131}  |  a^{124}  |  a^{7}+a^{4}+a^{2}+a^{1}+1
       197, // a^{132}  |  a^{123}  |  a^{7}+a^{6}+a^{2}+1
       236, // a^{133}  |  a^{122}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}
       118, // a^{134}  |  a^{121}  |  a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
        59, // a^{135}  |  a^{120}  |  a^{5}+a^{4}+a^{3}+a^{1}+1
       147, // a^{136}  |  a^{119}  |  a^{7}+a^{4}+a^{1}+1
       199, // a^{137}  |  a^{118}  |  a^{7}+a^{6}+a^{2}+a^{1}+1
       237, // a^{138}  |  a^{117}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+1
       248, // a^{139}  |  a^{116}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}
       124, // a^{140}  |  a^{115}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
        62, // a^{141}  |  a^{114}  |  a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        31, // a^{142}  |  a^{113}  |  a^{4}+a^{3}+a^{2}+a^{1}+1
       129, // a^{143}  |  a^{112}  |  a^{7}+1
       206, // a^{144}  |  a^{111}  |  a^{7}+a^{6}+a^{3}+a^{2}+a^{1}
       103, // a^{145}  |  a^{110}  |  a^{6}+a^{5}+a^{2}+a^{1}+1
       189, // a^{146}  |  a^{109}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+1
       208, // a^{147}  |  a^{108}  |  a^{7}+a^{6}+a^{4}
       104, // a^{148}  |  a^{107}  |  a^{6}+a^{5}+a^{3}
        52, // a^{149}  |  a^{106}  |  a^{5}+a^{4}+a^{2}
        26, // a^{150}  |  a^{105}  |  a^{4}+a^{3}+a^{1}
        13, // a^{151}  |  a^{104}  |  a^{3}+a^{2}+1
       136, // a^{152}  |  a^{103}  |  a^{7}+a^{3}
        68, // a^{153}  |  a^{102}  |  a^{6}+a^{2}
        34, // a^{154}  |  a^{101}  |  a^{5}+a^{1}
        17, // a^{155}  |  a^{100}  |  a^{4}+1
       134, // a^{156}  |  a^{ 99}  |  a^{7}+a^{2}+a^{1}
        67, // a^{157}  |  a^{ 98}  |  a^{6}+a^{1}+1
       175, // a^{158}  |  a^{ 97}  |  a^{7}+a^{5}+a^{3}+a^{2}+a^{1}+1
       217, // a^{159}  |  a^{ 96}  |  a^{7}+a^{6}+a^{4}+a^{3}+1
       226, // a^{160}  |  a^{ 95}  |  a^{7}+a^{6}+a^{5}+a^{1}
       113, // a^{161}  |  a^{ 94}  |  a^{6}+a^{5}+a^{4}+1
       182, // a^{162}  |  a^{ 93}  |  a^{7}+a^{5}+a^{4}+a^{2}+a^{1}
        91, // a^{163}  |  a^{ 92}  |  a^{6}+a^{4}+a^{3}+a^{1}+1
       163, // a^{164}  |  a^{ 91}  |  a^{7}+a^{5}+a^{1}+1
       223, // a^{165}  |  a^{ 90}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       225, // a^{166}  |  a^{ 89}  |  a^{7}+a^{6}+a^{5}+1
       254, // a^{167}  |  a^{ 88}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       127, // a^{168}  |  a^{ 87}  |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       177, // a^{169}  |  a^{ 86}  |  a^{7}+a^{5}+a^{4}+1
       214, // a^{170}  |  a^{ 85}  |  a^{7}+a^{6}+a^{4}+a^{2}+a^{1}
       107, // a^{171}  |  a^{ 84}  |  a^{6}+a^{5}+a^{3}+a^{1}+1
       187, // a^{172}  |  a^{ 83}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{1}+1
       211, // a^{173}  |  a^{ 82}  |  a^{7}+a^{6}+a^{4}+a^{1}+1
       231, // a^{174}  |  a^{ 81}  |  a^{7}+a^{6}+a^{5}+a^{2}+a^{1}+1
       253, // a^{175}  |  a^{ 80}  |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       240, // a^{176}  |  a^{ 79}  |  a^{7}+a^{6}+a^{5}+a^{4}
       120, // a^{177}  |  a^{ 78}  |  a^{6}+a^{5}+a^{4}+a^{3}
        60, // a^{178}  |  a^{ 77}  |  a^{5}+a^{4}+a^{3}+a^{2}
        30, // a^{179}  |  a^{ 76}  |  a^{4}+a^{3}+a^{2}+a^{1}
        15, // a^{180}  |  a^{ 75}  |  a^{3}+a^{2}+a^{1}+1
       137, // a^{181}  |  a^{ 74}  |  a^{7}+a^{3}+1
       202, // a^{182}  |  a^{ 73}  |  a^{7}+a^{6}+a^{3}+a^{1}
       101, // a^{183}  |  a^{ 72}  |  a^{6}+a^{5}+a^{2}+1
       188, // a^{184}  |  a^{ 71}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}
        94, // a^{185}  |  a^{ 70}  |  a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
        47, // a^{186}  |  a^{ 69}  |  a^{5}+a^{3}+a^{2}+a^{1}+1
       153, // a^{187}  |  a^{ 68}  |  a^{7}+a^{4}+a^{3}+1
       194, // a^{188}  |  a^{ 67}  |  a^{7}+a^{6}+a^{1}
        97, // a^{189}  |  a^{ 66}  |  a^{6}+a^{5}+1
       190, // a^{190}  |  a^{ 65}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        95, // a^{191}  |  a^{ 64}  |  a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       161, // a^{192}  |  a^{ 63}  |  a^{7}+a^{5}+1
       222, // a^{193}  |  a^{ 62}  |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
       111, // a^{194}  |  a^{ 61}  |  a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       185, // a^{195}  |  a^{ 60}  |  a^{7}+a^{5}+a^{4}+a^{3}+1
       210, // a^{196}  |  a^{ 59}  |  a^{7}+a^{6}+a^{4}+a^{1}
       105, // a^{197}  |  a^{ 58}  |  a^{6}+a^{5}+a^{3}+1
       186, // a^{198}  |  a^{ 57}  |  a^{7}+a^{5}+a^{4}+a^{3}+a^{1}
        93, // a^{199}  |  a^{ 56}  |  a^{6}+a^{4}+a^{3}+a^{2}+1
       160, // a^{200}  |  a^{ 55}  |  a^{7}+a^{5}
        80, // a^{201}  |  a^{ 54}  |  a^{6}+a^{4}
        40, // a^{202}  |  a^{ 53}  |  a^{5}+a^{3}
        20, // a^{203}  |  a^{ 52}  |  a^{4}+a^{2}
        10, // a^{204}  |  a^{ 51}  |  a^{3}+a^{1}
         5, // a^{205}  |  a^{ 50}  |  a^{2}+1
       140, // a^{206}  |  a^{ 49}  |  a^{7}+a^{3}+a^{2}
        70, // a^{207}  |  a^{ 48}  |  a^{6}+a^{2}+a^{1}
        35, // a^{208}  |  a^{ 47}  |  a^{5}+a^{1}+1
       159, // a^{209}  |  a^{ 46}  |  a^{7}+a^{4}+a^{3}+a^{2}+a^{1}+1
       193, // a^{210}  |  a^{ 45}  |  a^{7}+a^{6}+1
       238, // a^{211}  |  a^{ 44}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
       119, // a^{212}  |  a^{ 43}  |  a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       181, // a^{213}  |  a^{ 42}  |  a^{7}+a^{5}+a^{4}+a^{2}+1
       212, // a^{214}  |  a^{ 41}  |  a^{7}+a^{6}+a^{4}+a^{2}
       106, // a^{215}  |  a^{ 40}  |  a^{6}+a^{5}+a^{3}+a^{1}
        53, // a^{216}  |  a^{ 39}  |  a^{5}+a^{4}+a^{2}+1
       148, // a^{217}  |  a^{ 38}  |  a^{7}+a^{4}+a^{2}
        74, // a^{218}  |  a^{ 37}  |  a^{6}+a^{3}+a^{1}
        37, // a^{219}  |  a^{ 36}  |  a^{5}+a^{2}+1
       156, // a^{220}  |  a^{ 35}  |  a^{7}+a^{4}+a^{3}+a^{2}
        78, // a^{221}  |  a^{ 34}  |  a^{6}+a^{3}+a^{2}+a^{1}
        39, // a^{222}  |  a^{ 33}  |  a^{5}+a^{2}+a^{1}+1
       157, // a^{223}  |  a^{ 32}  |  a^{7}+a^{4}+a^{3}+a^{2}+1
       192, // a^{224}  |  a^{ 31}  |  a^{7}+a^{6}
        96, // a^{225}  |  a^{ 30}  |  a^{6}+a^{5}
        48, // a^{226}  |  a^{ 29}  |  a^{5}+a^{4}
        24, // a^{227}  |  a^{ 28}  |  a^{4}+a^{3}
        12, // a^{228}  |  a^{ 27}  |  a^{3}+a^{2}
         6, // a^{229}  |  a^{ 26}  |  a^{2}+a^{1}
         3, // a^{230}  |  a^{ 25}  |  a^{1}+1
       143, // a^{231}  |  a^{ 24}  |  a^{7}+a^{3}+a^{2}+a^{1}+1
       201, // a^{232}  |  a^{ 23}  |  a^{7}+a^{6}+a^{3}+1
       234, // a^{233}  |  a^{ 22}  |  a^{7}+a^{6}+a^{5}+a^{3}+a^{1}
       117, // a^{234}  |  a^{ 21}  |  a^{6}+a^{5}+a^{4}+a^{2}+1
       180, // a^{235}  |  a^{ 20}  |  a^{7}+a^{5}+a^{4}+a^{2}
        90, // a^{236}  |  a^{ 19}  |  a^{6}+a^{4}+a^{3}+a^{1}
        45, // a^{237}  |  a^{ 18}  |  a^{5}+a^{3}+a^{2}+1
       152, // a^{238}  |  a^{ 17}  |  a^{7}+a^{4}+a^{3}
        76, // a^{239}  |  a^{ 16}  |  a^{6}+a^{3}+a^{2}
        38, // a^{240}  |  a^{ 15}  |  a^{5}+a^{2}+a^{1}
        19, // a^{241}  |  a^{ 14}  |  a^{4}+a^{1}+1
       135, // a^{242}  |  a^{ 13}  |  a^{7}+a^{2}+a^{1}+1
       205, // a^{243}  |  a^{ 12}  |  a^{7}+a^{6}+a^{3}+a^{2}+1
       232, // a^{244}  |  a^{ 11}  |  a^{7}+a^{6}+a^{5}+a^{3}
       116, // a^{245}  |  a^{ 10}  |  a^{6}+a^{5}+a^{4}+a^{2}
        58, // a^{246}  |  a^{  9}  |  a^{5}+a^{4}+a^{3}+a^{1}
        29, // a^{247}  |  a^{  8}  |  a^{4}+a^{3}+a^{2}+1
       128, // a^{248}  |  a^{  7}  |  a^{7}
        64, // a^{249}  |  a^{  6}  |  a^{6}
        32, // a^{250}  |  a^{  5}  |  a^{5}
        16, // a^{251}  |  a^{  4}  |  a^{4}
         8, // a^{252}  |  a^{  3}  |  a^{3}
         4, // a^{253}  |  a^{  2}  |  a^{2}
         2, // a^{254}  |  a^{  1}  |  a^{1}
        -1, //  -Inf    |  a^{-Inf} |  a^{-Inf} 
};
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_logInvTable ,2)
#endif //__cplusplus
const int16_t RS_logInvTable[TABLE_SIZE] = {
// Index     | Index    |  Inverse  | Decimal   |Polynomial 
// Exponent  |  Form    |   Of      | Form      | Form 
       255, // a^{-Inf} | a^{-Inf}  |  -Inf     | 0
         0, // a^{  0}  |  a^{  0}  |      1    |  1
       254, // a^{254}  |  a^{  1}  |      2    |  a^{1}
       230, // a^{230}  |  a^{ 25}  |      3    |  a^{1}+1
       253, // a^{253}  |  a^{  2}  |      4    |  a^{2}
       205, // a^{205}  |  a^{ 50}  |      5    |  a^{2}+1
       229, // a^{229}  |  a^{ 26}  |      6    |  a^{2}+a^{1}
        57, // a^{ 57}  |  a^{198}  |      7    |  a^{2}+a^{1}+1
       252, // a^{252}  |  a^{  3}  |      8    |  a^{3}
        32, // a^{ 32}  |  a^{223}  |      9    |  a^{3}+1
       204, // a^{204}  |  a^{ 51}  |     10    |  a^{3}+a^{1}
        17, // a^{ 17}  |  a^{238}  |     11    |  a^{3}+a^{1}+1
       228, // a^{228}  |  a^{ 27}  |     12    |  a^{3}+a^{2}
       151, // a^{151}  |  a^{104}  |     13    |  a^{3}+a^{2}+1
        56, // a^{ 56}  |  a^{199}  |     14    |  a^{3}+a^{2}+a^{1}
       180, // a^{180}  |  a^{ 75}  |     15    |  a^{3}+a^{2}+a^{1}+1
       251, // a^{251}  |  a^{  4}  |     16    |  a^{4}
       155, // a^{155}  |  a^{100}  |     17    |  a^{4}+1
        31, // a^{ 31}  |  a^{224}  |     18    |  a^{4}+a^{1}
       241, // a^{241}  |  a^{ 14}  |     19    |  a^{4}+a^{1}+1
       203, // a^{203}  |  a^{ 52}  |     20    |  a^{4}+a^{2}
       114, // a^{114}  |  a^{141}  |     21    |  a^{4}+a^{2}+1
        16, // a^{ 16}  |  a^{239}  |     22    |  a^{4}+a^{2}+a^{1}
       126, // a^{126}  |  a^{129}  |     23    |  a^{4}+a^{2}+a^{1}+1
       227, // a^{227}  |  a^{ 28}  |     24    |  a^{4}+a^{3}
        62, // a^{ 62}  |  a^{193}  |     25    |  a^{4}+a^{3}+1
       150, // a^{150}  |  a^{105}  |     26    |  a^{4}+a^{3}+a^{1}
         7, // a^{  7}  |  a^{248}  |     27    |  a^{4}+a^{3}+a^{1}+1
        55, // a^{ 55}  |  a^{200}  |     28    |  a^{4}+a^{3}+a^{2}
       247, // a^{247}  |  a^{  8}  |     29    |  a^{4}+a^{3}+a^{2}+1
       179, // a^{179}  |  a^{ 76}  |     30    |  a^{4}+a^{3}+a^{2}+a^{1}
       142, // a^{142}  |  a^{113}  |     31    |  a^{4}+a^{3}+a^{2}+a^{1}+1
       250, // a^{250}  |  a^{  5}  |     32    |  a^{5}
       117, // a^{117}  |  a^{138}  |     33    |  a^{5}+1
       154, // a^{154}  |  a^{101}  |     34    |  a^{5}+a^{1}
       208, // a^{208}  |  a^{ 47}  |     35    |  a^{5}+a^{1}+1
        30, // a^{ 30}  |  a^{225}  |     36    |  a^{5}+a^{2}
       219, // a^{219}  |  a^{ 36}  |     37    |  a^{5}+a^{2}+1
       240, // a^{240}  |  a^{ 15}  |     38    |  a^{5}+a^{2}+a^{1}
       222, // a^{222}  |  a^{ 33}  |     39    |  a^{5}+a^{2}+a^{1}+1
       202, // a^{202}  |  a^{ 53}  |     40    |  a^{5}+a^{3}
       108, // a^{108}  |  a^{147}  |     41    |  a^{5}+a^{3}+1
       113, // a^{113}  |  a^{142}  |     42    |  a^{5}+a^{3}+a^{1}
        37, // a^{ 37}  |  a^{218}  |     43    |  a^{5}+a^{3}+a^{1}+1
        15, // a^{ 15}  |  a^{240}  |     44    |  a^{5}+a^{3}+a^{2}
       237, // a^{237}  |  a^{ 18}  |     45    |  a^{5}+a^{3}+a^{2}+1
       125, // a^{125}  |  a^{130}  |     46    |  a^{5}+a^{3}+a^{2}+a^{1}
       186, // a^{186}  |  a^{ 69}  |     47    |  a^{5}+a^{3}+a^{2}+a^{1}+1
       226, // a^{226}  |  a^{ 29}  |     48    |  a^{5}+a^{4}
        74, // a^{ 74}  |  a^{181}  |     49    |  a^{5}+a^{4}+1
        61, // a^{ 61}  |  a^{194}  |     50    |  a^{5}+a^{4}+a^{1}
       130, // a^{130}  |  a^{125}  |     51    |  a^{5}+a^{4}+a^{1}+1
       149, // a^{149}  |  a^{106}  |     52    |  a^{5}+a^{4}+a^{2}
       216, // a^{216}  |  a^{ 39}  |     53    |  a^{5}+a^{4}+a^{2}+1
         6, // a^{  6}  |  a^{249}  |     54    |  a^{5}+a^{4}+a^{2}+a^{1}
        70, // a^{ 70}  |  a^{185}  |     55    |  a^{5}+a^{4}+a^{2}+a^{1}+1
        54, // a^{ 54}  |  a^{201}  |     56    |  a^{5}+a^{4}+a^{3}
       101, // a^{101}  |  a^{154}  |     57    |  a^{5}+a^{4}+a^{3}+1
       246, // a^{246}  |  a^{  9}  |     58    |  a^{5}+a^{4}+a^{3}+a^{1}
       135, // a^{135}  |  a^{120}  |     59    |  a^{5}+a^{4}+a^{3}+a^{1}+1
       178, // a^{178}  |  a^{ 77}  |     60    |  a^{5}+a^{4}+a^{3}+a^{2}
        27, // a^{ 27}  |  a^{228}  |     61    |  a^{5}+a^{4}+a^{3}+a^{2}+1
       141, // a^{141}  |  a^{114}  |     62    |  a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        89, // a^{ 89}  |  a^{166}  |     63    |  a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       249, // a^{249}  |  a^{  6}  |     64    |  a^{6}
        64, // a^{ 64}  |  a^{191}  |     65    |  a^{6}+1
       116, // a^{116}  |  a^{139}  |     66    |  a^{6}+a^{1}
       157, // a^{157}  |  a^{ 98}  |     67    |  a^{6}+a^{1}+1
       153, // a^{153}  |  a^{102}  |     68    |  a^{6}+a^{2}
        34, // a^{ 34}  |  a^{221}  |     69    |  a^{6}+a^{2}+1
       207, // a^{207}  |  a^{ 48}  |     70    |  a^{6}+a^{2}+a^{1}
         2, // a^{  2}  |  a^{253}  |     71    |  a^{6}+a^{2}+a^{1}+1
        29, // a^{ 29}  |  a^{226}  |     72    |  a^{6}+a^{3}
       103, // a^{103}  |  a^{152}  |     73    |  a^{6}+a^{3}+1
       218, // a^{218}  |  a^{ 37}  |     74    |  a^{6}+a^{3}+a^{1}
        76, // a^{ 76}  |  a^{179}  |     75    |  a^{6}+a^{3}+a^{1}+1
       239, // a^{239}  |  a^{ 16}  |     76    |  a^{6}+a^{3}+a^{2}
       110, // a^{110}  |  a^{145}  |     77    |  a^{6}+a^{3}+a^{2}+1
       221, // a^{221}  |  a^{ 34}  |     78    |  a^{6}+a^{3}+a^{2}+a^{1}
       119, // a^{119}  |  a^{136}  |     79    |  a^{6}+a^{3}+a^{2}+a^{1}+1
       201, // a^{201}  |  a^{ 54}  |     80    |  a^{6}+a^{4}
        47, // a^{ 47}  |  a^{208}  |     81    |  a^{6}+a^{4}+1
       107, // a^{107}  |  a^{148}  |     82    |  a^{6}+a^{4}+a^{1}
        49, // a^{ 49}  |  a^{206}  |     83    |  a^{6}+a^{4}+a^{1}+1
       112, // a^{112}  |  a^{143}  |     84    |  a^{6}+a^{4}+a^{2}
       105, // a^{105}  |  a^{150}  |     85    |  a^{6}+a^{4}+a^{2}+1
        36, // a^{ 36}  |  a^{219}  |     86    |  a^{6}+a^{4}+a^{2}+a^{1}
        66, // a^{ 66}  |  a^{189}  |     87    |  a^{6}+a^{4}+a^{2}+a^{1}+1
        14, // a^{ 14}  |  a^{241}  |     88    |  a^{6}+a^{4}+a^{3}
        45, // a^{ 45}  |  a^{210}  |     89    |  a^{6}+a^{4}+a^{3}+1
       236, // a^{236}  |  a^{ 19}  |     90    |  a^{6}+a^{4}+a^{3}+a^{1}
       163, // a^{163}  |  a^{ 92}  |     91    |  a^{6}+a^{4}+a^{3}+a^{1}+1
       124, // a^{124}  |  a^{131}  |     92    |  a^{6}+a^{4}+a^{3}+a^{2}
       199, // a^{199}  |  a^{ 56}  |     93    |  a^{6}+a^{4}+a^{3}+a^{2}+1
       185, // a^{185}  |  a^{ 70}  |     94    |  a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
       191, // a^{191}  |  a^{ 64}  |     95    |  a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
       225, // a^{225}  |  a^{ 30}  |     96    |  a^{6}+a^{5}
       189, // a^{189}  |  a^{ 66}  |     97    |  a^{6}+a^{5}+1
        73, // a^{ 73}  |  a^{182}  |     98    |  a^{6}+a^{5}+a^{1}
        92, // a^{ 92}  |  a^{163}  |     99    |  a^{6}+a^{5}+a^{1}+1
        60, // a^{ 60}  |  a^{195}  |    100    |  a^{6}+a^{5}+a^{2}
       183, // a^{183}  |  a^{ 72}  |    101    |  a^{6}+a^{5}+a^{2}+1
       129, // a^{129}  |  a^{126}  |    102    |  a^{6}+a^{5}+a^{2}+a^{1}
       145, // a^{145}  |  a^{110}  |    103    |  a^{6}+a^{5}+a^{2}+a^{1}+1
       148, // a^{148}  |  a^{107}  |    104    |  a^{6}+a^{5}+a^{3}
       197, // a^{197}  |  a^{ 58}  |    105    |  a^{6}+a^{5}+a^{3}+1
       215, // a^{215}  |  a^{ 40}  |    106    |  a^{6}+a^{5}+a^{3}+a^{1}
       171, // a^{171}  |  a^{ 84}  |    107    |  a^{6}+a^{5}+a^{3}+a^{1}+1
         5, // a^{  5}  |  a^{250}  |    108    |  a^{6}+a^{5}+a^{3}+a^{2}
       122, // a^{122}  |  a^{133}  |    109    |  a^{6}+a^{5}+a^{3}+a^{2}+1
        69, // a^{ 69}  |  a^{186}  |    110    |  a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
       194, // a^{194}  |  a^{ 61}  |    111    |  a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
        53, // a^{ 53}  |  a^{202}  |    112    |  a^{6}+a^{5}+a^{4}
       161, // a^{161}  |  a^{ 94}  |    113    |  a^{6}+a^{5}+a^{4}+1
       100, // a^{100}  |  a^{155}  |    114    |  a^{6}+a^{5}+a^{4}+a^{1}
        96, // a^{ 96}  |  a^{159}  |    115    |  a^{6}+a^{5}+a^{4}+a^{1}+1
       245, // a^{245}  |  a^{ 10}  |    116    |  a^{6}+a^{5}+a^{4}+a^{2}
       234, // a^{234}  |  a^{ 21}  |    117    |  a^{6}+a^{5}+a^{4}+a^{2}+1
       134, // a^{134}  |  a^{121}  |    118    |  a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
       212, // a^{212}  |  a^{ 43}  |    119    |  a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       177, // a^{177}  |  a^{ 78}  |    120    |  a^{6}+a^{5}+a^{4}+a^{3}
        43, // a^{ 43}  |  a^{212}  |    121    |  a^{6}+a^{5}+a^{4}+a^{3}+1
        26, // a^{ 26}  |  a^{229}  |    122    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
        83, // a^{ 83}  |  a^{172}  |    123    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
       140, // a^{140}  |  a^{115}  |    124    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
        12, // a^{ 12}  |  a^{243}  |    125    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
        88, // a^{ 88}  |  a^{167}  |    126    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
       168, // a^{168}  |  a^{ 87}  |    127    |  a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       248, // a^{248}  |  a^{  7}  |    128    |  a^{7}
       143, // a^{143}  |  a^{112}  |    129    |  a^{7}+1
        63, // a^{ 63}  |  a^{192}  |    130    |  a^{7}+a^{1}
         8, // a^{  8}  |  a^{247}  |    131    |  a^{7}+a^{1}+1
       115, // a^{115}  |  a^{140}  |    132    |  a^{7}+a^{2}
       127, // a^{127}  |  a^{128}  |    133    |  a^{7}+a^{2}+1
       156, // a^{156}  |  a^{ 99}  |    134    |  a^{7}+a^{2}+a^{1}
       242, // a^{242}  |  a^{ 13}  |    135    |  a^{7}+a^{2}+a^{1}+1
       152, // a^{152}  |  a^{103}  |    136    |  a^{7}+a^{3}
       181, // a^{181}  |  a^{ 74}  |    137    |  a^{7}+a^{3}+1
        33, // a^{ 33}  |  a^{222}  |    138    |  a^{7}+a^{3}+a^{1}
        18, // a^{ 18}  |  a^{237}  |    139    |  a^{7}+a^{3}+a^{1}+1
       206, // a^{206}  |  a^{ 49}  |    140    |  a^{7}+a^{3}+a^{2}
        58, // a^{ 58}  |  a^{197}  |    141    |  a^{7}+a^{3}+a^{2}+1
         1, // a^{  1}  |  a^{254}  |    142    |  a^{7}+a^{3}+a^{2}+a^{1}
       231, // a^{231}  |  a^{ 24}  |    143    |  a^{7}+a^{3}+a^{2}+a^{1}+1
        28, // a^{ 28}  |  a^{227}  |    144    |  a^{7}+a^{4}
        90, // a^{ 90}  |  a^{165}  |    145    |  a^{7}+a^{4}+1
       102, // a^{102}  |  a^{153}  |    146    |  a^{7}+a^{4}+a^{1}
       136, // a^{136}  |  a^{119}  |    147    |  a^{7}+a^{4}+a^{1}+1
       217, // a^{217}  |  a^{ 38}  |    148    |  a^{7}+a^{4}+a^{2}
        71, // a^{ 71}  |  a^{184}  |    149    |  a^{7}+a^{4}+a^{2}+1
        75, // a^{ 75}  |  a^{180}  |    150    |  a^{7}+a^{4}+a^{2}+a^{1}
       131, // a^{131}  |  a^{124}  |    151    |  a^{7}+a^{4}+a^{2}+a^{1}+1
       238, // a^{238}  |  a^{ 17}  |    152    |  a^{7}+a^{4}+a^{3}
       187, // a^{187}  |  a^{ 68}  |    153    |  a^{7}+a^{4}+a^{3}+1
       109, // a^{109}  |  a^{146}  |    154    |  a^{7}+a^{4}+a^{3}+a^{1}
        38, // a^{ 38}  |  a^{217}  |    155    |  a^{7}+a^{4}+a^{3}+a^{1}+1
       220, // a^{220}  |  a^{ 35}  |    156    |  a^{7}+a^{4}+a^{3}+a^{2}
       223, // a^{223}  |  a^{ 32}  |    157    |  a^{7}+a^{4}+a^{3}+a^{2}+1
       118, // a^{118}  |  a^{137}  |    158    |  a^{7}+a^{4}+a^{3}+a^{2}+a^{1}
       209, // a^{209}  |  a^{ 46}  |    159    |  a^{7}+a^{4}+a^{3}+a^{2}+a^{1}+1
       200, // a^{200}  |  a^{ 55}  |    160    |  a^{7}+a^{5}
       192, // a^{192}  |  a^{ 63}  |    161    |  a^{7}+a^{5}+1
        46, // a^{ 46}  |  a^{209}  |    162    |  a^{7}+a^{5}+a^{1}
       164, // a^{164}  |  a^{ 91}  |    163    |  a^{7}+a^{5}+a^{1}+1
       106, // a^{106}  |  a^{149}  |    164    |  a^{7}+a^{5}+a^{2}
        67, // a^{ 67}  |  a^{188}  |    165    |  a^{7}+a^{5}+a^{2}+1
        48, // a^{ 48}  |  a^{207}  |    166    |  a^{7}+a^{5}+a^{2}+a^{1}
        50, // a^{ 50}  |  a^{205}  |    167    |  a^{7}+a^{5}+a^{2}+a^{1}+1
       111, // a^{111}  |  a^{144}  |    168    |  a^{7}+a^{5}+a^{3}
       120, // a^{120}  |  a^{135}  |    169    |  a^{7}+a^{5}+a^{3}+1
       104, // a^{104}  |  a^{151}  |    170    |  a^{7}+a^{5}+a^{3}+a^{1}
        77, // a^{ 77}  |  a^{178}  |    171    |  a^{7}+a^{5}+a^{3}+a^{1}+1
        35, // a^{ 35}  |  a^{220}  |    172    |  a^{7}+a^{5}+a^{3}+a^{2}
         3, // a^{  3}  |  a^{252}  |    173    |  a^{7}+a^{5}+a^{3}+a^{2}+1
        65, // a^{ 65}  |  a^{190}  |    174    |  a^{7}+a^{5}+a^{3}+a^{2}+a^{1}
       158, // a^{158}  |  a^{ 97}  |    175    |  a^{7}+a^{5}+a^{3}+a^{2}+a^{1}+1
        13, // a^{ 13}  |  a^{242}  |    176    |  a^{7}+a^{5}+a^{4}
       169, // a^{169}  |  a^{ 86}  |    177    |  a^{7}+a^{5}+a^{4}+1
        44, // a^{ 44}  |  a^{211}  |    178    |  a^{7}+a^{5}+a^{4}+a^{1}
        84, // a^{ 84}  |  a^{171}  |    179    |  a^{7}+a^{5}+a^{4}+a^{1}+1
       235, // a^{235}  |  a^{ 20}  |    180    |  a^{7}+a^{5}+a^{4}+a^{2}
       213, // a^{213}  |  a^{ 42}  |    181    |  a^{7}+a^{5}+a^{4}+a^{2}+1
       162, // a^{162}  |  a^{ 93}  |    182    |  a^{7}+a^{5}+a^{4}+a^{2}+a^{1}
        97, // a^{ 97}  |  a^{158}  |    183    |  a^{7}+a^{5}+a^{4}+a^{2}+a^{1}+1
       123, // a^{123}  |  a^{132}  |    184    |  a^{7}+a^{5}+a^{4}+a^{3}
       195, // a^{195}  |  a^{ 60}  |    185    |  a^{7}+a^{5}+a^{4}+a^{3}+1
       198, // a^{198}  |  a^{ 57}  |    186    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{1}
       172, // a^{172}  |  a^{ 83}  |    187    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{1}+1
       184, // a^{184}  |  a^{ 71}  |    188    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}
       146, // a^{146}  |  a^{109}  |    189    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+1
       190, // a^{190}  |  a^{ 65}  |    190    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        93, // a^{ 93}  |  a^{162}  |    191    |  a^{7}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
       224, // a^{224}  |  a^{ 31}  |    192    |  a^{7}+a^{6}
       210, // a^{210}  |  a^{ 45}  |    193    |  a^{7}+a^{6}+1
       188, // a^{188}  |  a^{ 67}  |    194    |  a^{7}+a^{6}+a^{1}
        39, // a^{ 39}  |  a^{216}  |    195    |  a^{7}+a^{6}+a^{1}+1
        72, // a^{ 72}  |  a^{183}  |    196    |  a^{7}+a^{6}+a^{2}
       132, // a^{132}  |  a^{123}  |    197    |  a^{7}+a^{6}+a^{2}+1
        91, // a^{ 91}  |  a^{164}  |    198    |  a^{7}+a^{6}+a^{2}+a^{1}
       137, // a^{137}  |  a^{118}  |    199    |  a^{7}+a^{6}+a^{2}+a^{1}+1
        59, // a^{ 59}  |  a^{196}  |    200    |  a^{7}+a^{6}+a^{3}
       232, // a^{232}  |  a^{ 23}  |    201    |  a^{7}+a^{6}+a^{3}+1
       182, // a^{182}  |  a^{ 73}  |    202    |  a^{7}+a^{6}+a^{3}+a^{1}
        19, // a^{ 19}  |  a^{236}  |    203    |  a^{7}+a^{6}+a^{3}+a^{1}+1
       128, // a^{128}  |  a^{127}  |    204    |  a^{7}+a^{6}+a^{3}+a^{2}
       243, // a^{243}  |  a^{ 12}  |    205    |  a^{7}+a^{6}+a^{3}+a^{2}+1
       144, // a^{144}  |  a^{111}  |    206    |  a^{7}+a^{6}+a^{3}+a^{2}+a^{1}
         9, // a^{  9}  |  a^{246}  |    207    |  a^{7}+a^{6}+a^{3}+a^{2}+a^{1}+1
       147, // a^{147}  |  a^{108}  |    208    |  a^{7}+a^{6}+a^{4}
        94, // a^{ 94}  |  a^{161}  |    209    |  a^{7}+a^{6}+a^{4}+1
       196, // a^{196}  |  a^{ 59}  |    210    |  a^{7}+a^{6}+a^{4}+a^{1}
       173, // a^{173}  |  a^{ 82}  |    211    |  a^{7}+a^{6}+a^{4}+a^{1}+1
       214, // a^{214}  |  a^{ 41}  |    212    |  a^{7}+a^{6}+a^{4}+a^{2}
        98, // a^{ 98}  |  a^{157}  |    213    |  a^{7}+a^{6}+a^{4}+a^{2}+1
       170, // a^{170}  |  a^{ 85}  |    214    |  a^{7}+a^{6}+a^{4}+a^{2}+a^{1}
        85, // a^{ 85}  |  a^{170}  |    215    |  a^{7}+a^{6}+a^{4}+a^{2}+a^{1}+1
         4, // a^{  4}  |  a^{251}  |    216    |  a^{7}+a^{6}+a^{4}+a^{3}
       159, // a^{159}  |  a^{ 96}  |    217    |  a^{7}+a^{6}+a^{4}+a^{3}+1
       121, // a^{121}  |  a^{134}  |    218    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{1}
        78, // a^{ 78}  |  a^{177}  |    219    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{1}+1
        68, // a^{ 68}  |  a^{187}  |    220    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}
        51, // a^{ 51}  |  a^{204}  |    221    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+1
       193, // a^{193}  |  a^{ 62}  |    222    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}
       165, // a^{165}  |  a^{ 90}  |    223    |  a^{7}+a^{6}+a^{4}+a^{3}+a^{2}+a^{1}+1
        52, // a^{ 52}  |  a^{203}  |    224    |  a^{7}+a^{6}+a^{5}
       166, // a^{166}  |  a^{ 89}  |    225    |  a^{7}+a^{6}+a^{5}+1
       160, // a^{160}  |  a^{ 95}  |    226    |  a^{7}+a^{6}+a^{5}+a^{1}
        79, // a^{ 79}  |  a^{176}  |    227    |  a^{7}+a^{6}+a^{5}+a^{1}+1
        99, // a^{ 99}  |  a^{156}  |    228    |  a^{7}+a^{6}+a^{5}+a^{2}
        86, // a^{ 86}  |  a^{169}  |    229    |  a^{7}+a^{6}+a^{5}+a^{2}+1
        95, // a^{ 95}  |  a^{160}  |    230    |  a^{7}+a^{6}+a^{5}+a^{2}+a^{1}
       174, // a^{174}  |  a^{ 81}  |    231    |  a^{7}+a^{6}+a^{5}+a^{2}+a^{1}+1
       244, // a^{244}  |  a^{ 11}  |    232    |  a^{7}+a^{6}+a^{5}+a^{3}
        10, // a^{ 10}  |  a^{245}  |    233    |  a^{7}+a^{6}+a^{5}+a^{3}+1
       233, // a^{233}  |  a^{ 22}  |    234    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{1}
        20, // a^{ 20}  |  a^{235}  |    235    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{1}+1
       133, // a^{133}  |  a^{122}  |    236    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}
       138, // a^{138}  |  a^{117}  |    237    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+1
       211, // a^{211}  |  a^{ 44}  |    238    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}
        40, // a^{ 40}  |  a^{215}  |    239    |  a^{7}+a^{6}+a^{5}+a^{3}+a^{2}+a^{1}+1
       176, // a^{176}  |  a^{ 79}  |    240    |  a^{7}+a^{6}+a^{5}+a^{4}
        81, // a^{ 81}  |  a^{174}  |    241    |  a^{7}+a^{6}+a^{5}+a^{4}+1
        42, // a^{ 42}  |  a^{213}  |    242    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{1}
        22, // a^{ 22}  |  a^{233}  |    243    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{1}+1
        25, // a^{ 25}  |  a^{230}  |    244    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}
        24, // a^{ 24}  |  a^{231}  |    245    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+1
        82, // a^{ 82}  |  a^{173}  |    246    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}
        23, // a^{ 23}  |  a^{232}  |    247    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{2}+a^{1}+1
       139, // a^{139}  |  a^{116}  |    248    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}
        41, // a^{ 41}  |  a^{214}  |    249    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+1
        11, // a^{ 11}  |  a^{244}  |    250    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}
        21, // a^{ 21}  |  a^{234}  |    251    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{1}+1
        87, // a^{ 87}  |  a^{168}  |    252    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}
       175, // a^{175}  |  a^{ 80}  |    253    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+1
       167, // a^{167}  |  a^{ 88}  |    254    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}
        80, // a^{ 80}  |  a^{175}  |    255    |  a^{7}+a^{6}+a^{5}+a^{4}+a^{3}+a^{2}+a^{1}+1
};

#define CODEGENPOLY_SIZE		    17 
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_codeGenPoly ,2)
#endif //__cplusplus
const int16_t RS_codeGenPoly[CODEGENPOLY_SIZE] = {
// Codegenerator Polynomial: 
//   1.x^{ 16} +118.x^{ 15} + 52.x^{ 14} +103.x^{ 13} + 31.x^{ 12} +104.x^{ 11} +126.x^{ 10} +187.x^{  9} +232.x^{  8} + 17.x^{  7} + 56.x^{  6} +183.x^{  5} + 49.x^{  4} +100.x^{  3} + 81.x^{  2} + 44.x^{  1} + 79
// coefficients in order of increasing power (Index Form)
       136,	 // x^{  0}, decimal =  79 
       240,	 // x^{  1}, decimal =  44 
       208,	 // x^{  2}, decimal =  81 
       195,	 // x^{  3}, decimal = 100 
       181,	 // x^{  4}, decimal =  49 
       158,	 // x^{  5}, decimal = 183 
       201,	 // x^{  6}, decimal =  56 
       100,	 // x^{  7}, decimal =  17 
        11,	 // x^{  8}, decimal = 232 
        83,	 // x^{  9}, decimal = 187 
       167,	 // x^{ 10}, decimal = 126 
       107,	 // x^{ 11}, decimal = 104 
       113,	 // x^{ 12}, decimal =  31 
       110,	 // x^{ 13}, decimal = 103 
       106,	 // x^{ 14}, decimal =  52 
       121,	 // x^{ 15}, decimal = 118 
         0,	 // x^{ 16}, decimal =   1 
};
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_packedAlpha ,2)
#endif //__cplusplus
const int16_t  RS_packedAlpha[NUM_ROOTS] = {
  0x0402,  0x1008,  0x4020,  0x1D80, 
  0x743A,  0xCDE8,  0x1387,  0x4C26, 
  0x2D98,  0xB45A,  0xEA75,  0x8FC9, 
  0x0603,  0x180C,  0x6030,  0x9DC0, 
};
#ifdef __cplusplus
#pragma DATA_ALIGN(2)
#else
#pragma DATA_ALIGN(RS_packedBeta,2)
#endif //__cplusplus
const int16_t RS_packedBeta[NUM_ROOTS>>1] = {
  0x0201,  0x0804,  0x2010,  0x8040, 
  0x3A1D,  0xE874,  0x87CD,  0x2613, 
};

#endif // _RS_TABLESN255K239_H_

// End of File
