/****************************************************************************
 *                                                                          *
 *   File            :   Main.c                                             *
 *   Project         :   Foc Stepper V6                                     *
 *   Compiler        :   Code Composer Studio V8 Texas Instruments          *
 *                                                                          *
 *   Function        :   Main program                                       *
 *                                                                          *
 *       Boot                                           GPIO72  GPIO84      *
 *   N.  Mode                                           GPIO-72 USB-TX      *
 * -------------------------------------------------------------------      *
 *   1   Jump to FLASH................................  1       1           *
 *   0   SCI-A boot...................................  1       0           *
 *                                                                          *
 *   Vers.   Data   Programmer    Description                               *
 *   1.00  01/10/18 G.Z.          Prima versione per F2837x scheda SMD2204  *
 *                                                                          *
 ****************************************************************************/
#include "../Source/AEC_Device.h"
#include "../Source/src_cpu/DefineTypedef.h"
#include "F28x_Project.h"                                       // DSP320F28x Headerfile Include File

#include <math.h>
#include <_lock.h>
#include <string.h>

#include "main.h"

#include "../Source/src_cpu/EpwmDrive.h"
#include "F2837xS_Cla_defines.h"
#include "F2837xS_SWPrioritizedIsrLevels.h"

#include "../Source/src_board/DefineSw.h"
#include "../Source/src_board/SetupCmpss.h"                 	// Inizializzazione comparatori interni al DSP

#if (AECDEVICE_TIPOENCODERABS == AECDEVICE_TIPOENCODERABS_ENDAT)
	#include "../Source/lib_TI/Position_Manager/v01_00_00_00/endat22/Float/include/endat.h"
#endif

#include "../Source/src_database/Variables.h"                  	// Esegui la dichiarazione e inizializzazione delle variabili


/*----------------------------------------------------------------------------*/
/*                SECTION CODE AND DATA ASSIGNED                              */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*             LOCAL                                                          */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*             LOCAL FUNCTION  PROTOTYPE                                      */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*             INLINE FUNCTION  PROTOTYPE                                     */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*             EXTERNAL FUNCTION  PROTOTYPE                                   */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*             EXTERNAL VARIABLES DECLARATION                                 */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*         V A R I A B L E S                                                  */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*          P R O T O T Y P E                                                 */
/*----------------------------------------------------------------------------*/
/*******************************************************************************
*
*   Funzione:     Main
*
*   Descrizione:  Ciclo principale
*
*
*   Parametri:    no
*
*
*   Return Value: no
*
*********************************************************************************/
void main(void)
{
}

//===========================================================================
// No more.
//===========================================================================
