/****************************************************************************
 *                                                                         	*
 *   File            :   SetupDspGpio_SMD2204.h                            	*
 *   Project         :   Foc Stepper                                       	*
 *   Compiler        :   Code Composer Studio Texas Instruments            	*
 *                                                                         	*
 *   Function        :   DSP280x function init Dsp Gpio                   	*
 *                                                                        	*
 *   Vers.   Data   Programmer    	Description                    			*
 *   1.00  18/04/18 GZ 				Prima versione						  	*
 *  																	    * 
 *   Significato LED da antaios												*
 *  																		*
 *	  							Profinet	Ethernet/IP	ModBus	EtherCAT	*
 *  GPIO_5 LED_YEL				  MT			-		 MT			-		*
 *  																	 	*
 *  FIELD1 GPIO_1 LED_GRN_1		  -				MS		 RUN	   RUN		*
 *  FIELD1 GPIO_2 LED_RED_1		  -				MS		 -    		-	 	*
 *  																	 	*
 *  FIELD2 GPIO_3 LED_GRN_2		  -				NS		 -			- 		*
 *  FIELD2 GPIO_4 LED_RED_2 	  BF			NS		 -		  ERROR		*
 *  																	 	*
 *  RJ45 RT_GPIO_4 LNK1													 	*
 *  RJ45 RT_GPIO_5 LNK2													 	*
 *  																	 	*
 ****************************************************************************/

#ifndef SETUPDSPGPIO_SMD2204_H_INCLUDED
#define SETUPDSPGPIO_SMD2204_H_INCLUDED

//#include "../../../Source/src_cpu/f2837xs/headers/include/F2837xS_gpio.h"
#include "F2837xS_device.h"

/*----------------------------------------------------------------------------*/
/*      PIN  GPIO DEFINITIONS                                                 */
/*----------------------------------------------------------------------------*/

//=============================================================================
// GPIO_PORT_A_0	I2C_SDA
//=============================================================================
#define GPIO_0_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_0_MUX              6					///<0:GPIO0	 		1:EPWM1A		2:Reserved		3:Reserved
													///<4:GPIO0			5:Reserved		6:SDAA			7:Reserved
													///<8:GPIO0			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO0		13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_0_DIR              GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_0_FLAG             GPIO_SYNC | GPIO_OPENDRAIN | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_1	I2C_SCL
//=============================================================================
#define GPIO_1_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_1_MUX              6					///<0:GPIO1	 		1:EPWM1B		2:Reserved		3:MFSRB
													///<4:GPIO1			5:Reserved		6:SDAA			7:Reserved
													///<8:GPIO1			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO1		13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_1_DIR              GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_1_FLAG             GPIO_SYNC | GPIO_OPENDRAIN | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_2    Free
//=============================================================================
#define GPIO_2_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_2_MUX              0                   ///<0:GPIO2         1:EPWM2A        2:Reserved      3:Reserved
                                                    ///<4:GPIO2         5:OUTPUTXBAR1   6:SDAB          7:Reserved
                                                    ///<8:GPIO2         9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO2        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_2_DIR              GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_2_FLAG             GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_3    DigOut 0 su 2204 V7.10
//=============================================================================
#define GPIO_3_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_3_MUX_1            0
#define GPIO_3_MUX              0                   ///<0:GPIO3         1:EPWM2B        2:OUTPUTXBAR2   3:MCLKRB
                                                    ///<4:GPIO3         5:OUTPUTXBAR2   6:SCLB          7:Reserved
                                                    ///<8:GPIO3         9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO3        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_3_DIR_1            GPIO_OUTPUT          ///< GPIO_OUTPUT: Output
#define GPIO_3_DIR              GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_3_FLAG_1           GPIO_SYNC | GPIO_PUSHPULL
#define GPIO_3_FLAG             GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_4    CAN_TX
//=============================================================================
#define GPIO_4_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_4_MUX              6                   ///<0:GPIO4         1:EPWM3A        2:Reserved      3:Reserved
													///<4:GPIO4         5:OUTPUTXBAR3   6:CANTXA        7:Reserved
													///<8:GPIO4         9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO4        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_4_DIR              GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_4_FLAG             GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_5    CAN_RX
//=============================================================================
#define GPIO_5_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_5_MUX              6                   ///<0:GPIO5         1:EPWM3B        2:MFSRA         3:OUTPUTXBAR3
													///<4:GPIO5         5:Reserved      6:CANRXA        7:Reserved
													///<8:GPIO5         9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO5        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_5_DIR              GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_5_FLAG             GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_6	ENDATCLOCKOUT
//=============================================================================
#define GPIO_6_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_6_MUX              0					///<0:GPIO6	 		1:EPWM4A		2:OUTPUTXBAR4	3:EXTSYNCOUT
													///<4:GPIO6			5:EQEP3A		6:CANTXB		7:Reserved
													///<8:GPIO6			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO6		13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_6_DIR              GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_6_FLAG             GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_7	Free
//=============================================================================
#define GPIO_7_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_7_MUX              0					///<0:GPIO7	 		1:EPWM4B		2:MCLKRA		3:OUTPUTXBAR5
													///<4:GPIO7			5:EQEP3B		6:CANRXB		7:Reserved
													///<8:GPIO7			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO7		13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_7_DIR              GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_7_FLAG             GPIO_SYNC

//=============================================================================
// GPIO_PORT_A_8    DIGOUT_F5
//               	Digout1 su 2204 V7.10
//=============================================================================
#define GPIO_8_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_8_MUX              0                   ///<0:GPIO8         1:EPWM5A        2:CANTXB        3:ADCSOCAO
                                                    ///<4:GPIO8         5:EQEP3S        6:SCITXDA       7:Reserved
                                                    ///<8:GPIO8         9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO8        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_8_DIR              GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_8_FLAG             GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_9    DIGOUT_F6
//               	Digout2 su 2204 V7.10
//=============================================================================
#define GPIO_9_DEFAULTVALUE     0
//-----------------------------------------------------------------------------
#define GPIO_9_MUX              0                   ///<0:GPIO9         1:EPWM5B        2:SCITXDB       3:OUTPUTXBAR6
                                                    ///<4:GPIO9         5:EQEP3I        6:SCIRXDA       7:Reserved
                                                    ///<8:GPIO9         9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO9        13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_9_DIR              GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_9_FLAG             GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_10   DIGOUT_F7
//               	Digout3 su 2204 V7.10
//=============================================================================
#define GPIO_10_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_10_MUX             0                   ///<0:GPIO10            1:EPWM6A        2:CANRXB        3:ADCSOCBO
                                                    ///<4:GPIO10            5:EQEP1A        6:SCITXDB       7:Reserved
                                                    ///<8:GPIO10            9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO10           13:Reserved     14:Reserved     15:UPP-WAIT
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_10_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_10_FLAG            GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_11   DIGOUT_F8
//               	Digout4 su 2204 V7.10
//=============================================================================
#define GPIO_11_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_11_MUX             0                   ///<0:GPIO11            1:EPWM6B        2:SCIRXDB       3:OUTPUTXBAR7
                                                    ///<4:GPIO11            5:EQEP1B        6:SCIRXDB       7:Reserved
                                                    ///<8:GPIO11            9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO11           13:Reserved     14:Reserved     15:UPP-START
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_11_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_11_FLAG            GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_12	Function 1 (Se 0-> No STO / Se 1-> STO)
//=============================================================================
#define GPIO_12_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_12_MUX             0					///<0:GPIO12	 		1:EPWM7A  		2:CANTXB  		3:MDXB
													///<4:GPIO12			5:EQEP1S  		6:SCITXDC 		7:Reserved
													///<8:GPIO12			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO12			13:Reserved		14:Reserved		15:UPP-ENA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_12_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_12_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_13	Function 2
//=============================================================================
#define GPIO_13_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_13_MUX             0					///<0:GPIO13	 		1:EPWM7B  		2:CANRXB  		3:MDRB
													///<4:GPIO13			5:EQEP1I  		6:SCIRXDC 		7:Reserved
													///<8:GPIO13			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO13			13:Reserved		14:Reserved		15:UPP-D7
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_13_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_13_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_14	Function 3
//=============================================================================
#define GPIO_14_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_14_MUX             0					///<0:GPIO14	 		1:EPWM8A  		2:SCITXDB 		3:MCLKXB
													///<4:GPIO14			5:Reserved		6:OUTPUTXBAT3	7:Reserved
													///<8:GPIO14			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO14			13:Reserved		14:Reserved		15:UPP-D6
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_14_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_14_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_15	Digout Enable
//               	Digout5 su 2204 V7.10
//=============================================================================
#define GPIO_15_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_15_MUX             0					///<0:GPIO15	 		1:EPWM8B  		2:SCIRXDB 		3:MFSXB
													///<4:GPIO15			5:Reserved		6:OUTPUTXBAR4	7:Reserved
													///<8:GPIO15			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO15			13:Reserved		14:Reserved		15:UPP-D5
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_15_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_15_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_16	Digout SI
//               	Digout6 su 2204 V7.10
//=============================================================================
#define GPIO_16_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_16_MUX_1			0
#define GPIO_16_MUX             1					///<0:GPIO16	 		1:SPISIMOA		2:CANTXB  		3:OUTPUTXBAR7
													///<4:GPIO16			5:EPWM9A  		6:Reserved		7:SD1-D1
													///<8:GPIO16			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO16			13:Reserved		14:Reserved		15:UPP-D4
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_16_DIR_1           GPIO_OUTPUT			///< GPIO_OUTPUT: Output
#define GPIO_16_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_16_FLAG_1			GPIO_SYNC | GPIO_PUSHPULL
#define GPIO_16_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_17	Digout SO
//                	Digout7 su 2204 V7.10
//=============================================================================
#define GPIO_17_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_17_MUX_1           0
#define GPIO_17_MUX             1					///<0:GPIO17	 		1:SPISOMIA 		2:CANRXB  		3:OUTPUTXBAR8
													///<4:GPIO17			5:EPWM9B  		6:Reserved		7:SD1-C1
													///<8:GPIO17			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO17			13:Reserved		14:Reserved		15:UPP-D3
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_17_DIR_1           GPIO_OUTPUT			///< GPIO_OUTPUT: Output
#define GPIO_17_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_17_FLAG_1			GPIO_SYNC | GPIO_PUSHPULL
#define GPIO_17_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_18	Digout SCLK
//           		Digout Fault su 2204 V7.10
//=============================================================================
#define GPIO_18_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_18_MUX_1           0
#define GPIO_18_MUX             1					///<0:GPIO18	 		1:SPICLKA 		2:SCITXDB 		3:CANRXA
													///<4:GPIO18			5:EPWM10A 		6:Reserved		7:SD1-D2
													///<8:GPIO18			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO18			13:Reserved		14:Reserved		15:UPP-D2
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_18_DIR_1           GPIO_INPUT   		///< GPIO_OUTPUT: Output
#define GPIO_18_DIR             GPIO_OUTPUT 		///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_18_FLAG_1			GPIO_SYNC | GPIO_PULLUP
#define GPIO_18_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_19	Digout CS
//           		Digout su 2204 V7.10
//                  Viene fatto partire come GPIO19 a stato basso per non abilitare
//                  le uscite con il nuovo chip di uscite.
//                  Se deve diventare /SPISTEA lo fa nel codice eseguito in main.c
//=============================================================================
#define GPIO_19_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_19_MUX_1           1
#define GPIO_19_MUX             0					///<0:GPIO19	 		1:/SPISTEA		2:SCIRXDB 		3:CANTXA
													///<4:GPIO19			5:EPWM10B 		6:Reserved		7:SD1-C2
													///<8:GPIO19			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO19			13:Reserved		14:Reserved		15:UPP-D1
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_19_DIR_1           GPIO_OUTPUT			///< GPIO_OUTPUT: Output
#define GPIO_19_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_19_FLAG_1			GPIO_SYNC | GPIO_PUSHPULL
#define GPIO_19_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_20	2204: Encoder Motore 2 CHA	1104,1204,5106: Encoder2 CHA
//=============================================================================
#define GPIO_20_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_20_MUX             1 					///<0:GPIO20	 		1:EQEP1A  		2:MDXA    		3:CANTXB
													///<4:GPIO20			5:EPWM11A  		6:Reserved		7:SD1-D3
													///<8:GPIO20			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO20			13:Reserved		14:Reserved		15:UPP-D0
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_20_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_20_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_21	2204: Encoder Motore 2 CHB	1104,1204,5106: Encoder2 CHB
//=============================================================================
#define GPIO_21_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_21_MUX             1					///<0:GPIO21	 		1:EQEP1B  		2:MDRA    		3:CANRXB
													///<4:GPIO21			5:EPWM11B 		6:Reserved		7:SD1-C3
													///<8:GPIO21			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO21			13:Reserved		14:Reserved		15:UPP-CLK
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_21_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_21_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_22	Free
//=============================================================================
#define GPIO_22_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_22_MUX             0					///<0:GPIO22	 		1:EQEP1S  		2:MCLKXA  		3:SCITXDB
													///<4:GPIO22			5:EPWM12A 		6:SPICLKB 		7:SD1-D4
													///<8:GPIO22			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO22			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_22_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_22_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_23	2204: Encoder Motore 2 CHI	1104,1204,5106: Encoder 2 CHI
//=============================================================================
#define GPIO_23_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_23_MUX             1					///<0:GPIO23	 		1:EQEP1I  		2:MFSXA   		3:SCIRXDB
													///<4:GPIO23			5:EPWM12B 		6:/SPISTEB 		7:SD1-C4
													///<8:GPIO23			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO23			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_23_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_23_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_24	Endat data in (SSI DIRECTION)
//=============================================================================
#define GPIO_24_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_24_MUX             0					///<0:GPIO24	 		1:OUTPUTXBAR1	2:EQEP2A  		3:MDXB
													///<4:GPIO24			5:Reserved		6:SPISIMOB 		7:SD2-D1
													///<8:GPIO24			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO24			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_24_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_24_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_25	Endat data out (SSI IN)
//=============================================================================
#define GPIO_25_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_25_MUX             6					///<0:GPIO25	 		1:OUTPUTXBAR2	2:EQEP2B  		3:MDRB
													///<4:GPIO25			5:Reserved		6:SPISOMIB		7:SD2-C1
													///<8:GPIO25			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO25			13:Reserved		14:Reserved		15:Reserved
#define GPIO_25_MUX_            0
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_25_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_25_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_26	Endat clock out
//=============================================================================
#define GPIO_26_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_26_MUX             6					///<0:GPIO26	 		1:OUTPUTXBAR3	2:EQEP2I  		3:MCLKXB
													///<4:GPIO26			5:OUTPUTXBAR3	6:SPICLKB 		7:SD2-D2
													///<8:GPIO26			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO26			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_26_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_26_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_A_27	Endat /SPISTEB
//=============================================================================
#define GPIO_27_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_27_MUX             6					///<0:GPIO27	 		1:OUTPUTXBAR4	2:EQEP2S  		3:MFSXB
													///<4:GPIO27			5:OUTPUTXBAR4	6:/SPISTEB		7:SD2-C2
													///<8:GPIO27			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO27			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_27_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_27_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_28	Encoder Motore 3 CHA
//=============================================================================
#define GPIO_28_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_28_MUX             6					///<0:GPIO28	 		1:SCIRXDA 		2:/EM1CS4 		3:Reserved
													///<4:GPIO28			5:OUTPUTXBAR5	6:EQEP3A  		7:SD2-D3
													///<8:GPIO28			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO28			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_28_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_28_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP
	
//=============================================================================
// GPIO_PORT_A_29	Encoder Motore 3 CHB
//=============================================================================
#define GPIO_29_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_29_MUX             6					///<0:GPIO29	 		1:SCITXDA 		2:EM1SDCKE 		3:Reserved
													///<4:GPIO29			5:OUTPUTXBAR6	6:EQEP3B		7:SD2-C3
													///<8:GPIO29			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO29			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_29_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_29_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_30	Free
//=============================================================================
#define GPIO_30_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_30_MUX             0					///<0:GPIO30	 		1:CANRXA		2:EM1CLK		3:Reserved
													///<4:GPIO30			5:OUTPUTXBAR7	6:EQEP3S  		7:SD2-D4
													///<8:GPIO30			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO30			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_30_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_30_FLAG			GPIO_INVERT | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_A_31	Encoder Motore 3 CHI
//=============================================================================
#define GPIO_31_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_31_MUX             6					///<0:GPIO31	 		1:CANTXA  		2:/EM1WE  		3:Reserved
													///<4:GPIO31			5:OUTPUTXBAR8	6:EQEP3I  		7:SD2-C4
													///<8:GPIO31			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO31			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_31_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_31_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_0    Service input FLS1
//=============================================================================
#define GPIO_32_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_32_MUX             0					///<0:GPIO32	 		1:SDAA    		2:/EM1CS0  		3:Reserved
													///<4:GPIO32			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO32			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO32			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_32_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_32_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_1 	Service input BLS1
//=============================================================================
#define GPIO_33_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_33_MUX             0					///<0:GPIO33	 		1:SCLA  		2:EM1RNW  		3:Reserved
													///<4:GPIO33			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO33			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO33			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_33_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_33_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_2    Service input FLS2
//=============================================================================
#define GPIO_34_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_34_MUX             0					///<0:GPIO34	 		1:OUTPUTXBAR1	2:/EM1CS2		3:Reserved
													///<4:GPIO34			5:Reserved		6:SDAB			7:Reserved
													///<8:GPIO34			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO34			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_34_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_34_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_3    Service input BLS2
//=============================================================================
#define GPIO_35_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_35_MUX             0					///<0:GPIO35	 		1:SCIRXDA  		2:/EM1CS3 		3:Reserved
													///<4:GPIO35			5:Reserved		6:SCLB    		7:Reserved
													///<8:GPIO35			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO35			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_35_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_35_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_4 	Service input FLS3
//=============================================================================
#define GPIO_36_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_36_MUX             0					///<0:GPIO36	 		1:SCITXDA 		2:EM1WAIT 		3:Reserved
													///<4:GPIO36			5:Reserved		6:CANRXA  		7:Reserved
													///<8:GPIO36			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO36			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_36_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_36_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_5 	Service input BLS3
//=============================================================================
#define GPIO_37_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_37_MUX             0					///<0:GPIO37	 		1:OUTPUTXBAR2	2:/EM1OE		3:Reserved
													///<4:GPIO37			5:Reserved		6:CANTXA		7:Reserved
													///<8:GPIO37			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO37			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_37_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_37_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_6    Free
//=============================================================================
#define GPIO_38_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_38_MUX             0                   ///<0:GPIO38            1:Reserved      2:EM1A0         3:Reserved
													///<4:GPIO38            5:SCITXDC       6:CANTXB        7:Reserved
													///<8:GPIO38            9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO38           13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_38_DIR             GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_38_FLAG            GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_7 	STO Check canale B dal DSP da versione SMD1204 V9 in poi
//=============================================================================
#define GPIO_39_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_39_MUX             0					///<0:GPIO39	 		1:Reserved		2:EM1A1			3:Reserved
													///<4:GPIO39			5:SCIRXDC		6:CANRXB		7:Reserved
													///<8:GPIO39			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO39			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_39_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_39_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_8 	Free
//=============================================================================
#define GPIO_40_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_40_MUX             0					///<0:GPIO40	 		1:Reserved		2:EM1A2			3:Reserved
													///<4:GPIO40			5:Reserved		6:SDAB			7:Reserved
													///<8:GPIO40			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO40
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_40_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_40_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_9 	Free
//=============================================================================
#define GPIO_41_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_41_MUX             0					///<0:GPIO41	 		1:Reserved		2:EM1A3			3:Reserved
													///<4:GPIO41			5:Reserved		6:SCLB			7:Reserved
													///<8:GPIO41			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO41			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_41_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_41_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_10	USB0_DM
//=============================================================================
#define GPIO_42_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_42_MUX             0					///<0:GPIO42	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO42			5:Reserved		6:SDAA			7:Reserved
													///<8:GPIO42			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO42			13:Reserved		14:Reserved		15:SCITXDA
													///<USB0DM -> Analog
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_42_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_42_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_11	USB0_DP
//=============================================================================
#define GPIO_43_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_43_MUX             0					///<0:GPIO43	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO43			5:Reserved		6:SCLA			7:Reserved
													///<8:GPIO43			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO43			13:Reserved		14:Reserved		15:SCIRXDA
													///<USB0DP -> Analog
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_43_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_43_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_12	Free
//=============================================================================
#define GPIO_44_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_44_MUX             0					///<0:GPIO44	 		1:Reserved		2:EM1A4			3:Reserved
													///<4:GPIO44			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO44			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO44			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_44_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_44_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_13	Free
//=============================================================================
#define GPIO_45_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_45_MUX             0					///<0:GPIO45	 		1:Reserved		2:EM1A5			3:Reserved
													///<4:GPIO45			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO45			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO45			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_45_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_45_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_14	Free
//=============================================================================
#define GPIO_46_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_46_MUX             0					///<0:GPIO46	 		1:Reserved		2:EM1A6			3:Reserved
													///<4:GPIO46			5:Reserved		6:SCIRXDD		7:Reserved
													///<8:GPIO46			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO46			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_46_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_46_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_15	Free
//=============================================================================
#define GPIO_47_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_47_MUX             0					///<0:GPIO47	 		1:Reserved		2:EM1A7			3:Reserved
													///<4:GPIO47			5:Reserved		6:SCITXDD		7:Reserved
													///<8:GPIO47			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO47			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_47_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_47_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_16	Free
//=============================================================================
#define GPIO_48_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_48_MUX             0					///<0:GPIO48	 		1:OUTPUTXBAR3	2:EM1A8   		3:Reserved
													///<4:GPIO48			5:Reserved		6:SCITXDA 		7:SD1-D1
													///<8:GPIO48			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO48			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_48_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_48_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_17	DIP_SW_5
//=============================================================================
#define GPIO_49_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_49_MUX             0					///<0:GPIO49	 		1:OUTPUTXBAR4	2:EM1A9			3:Reserved
													///<4:GPIO49			5:Reserved		6:SCIRXDA		7:SD1-C1
													///<8:GPIO49			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO49			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_49_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_49_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_18	Free
//=============================================================================
#define GPIO_50_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_50_MUX             0					///<0:GPIO50	 		1:EQEP1A		2:EM1A10		3:Reserved
													///<4:GPIO50			5:Reserved		6:SPISIMOC		7:SD1-D2
													///<8:GPIO50			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO50			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_50_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_50_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_19	Free
//=============================================================================
#define GPIO_51_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_51_MUX             0					///<0:GPIO51	 		1:EQEP1B		2:EM1A11		3:Reserved
													///<4:GPIO51			5:Reserved		6:SPISOMIC		7:SD1-C2
													///<8:GPIO51			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO51			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_51_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_51_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_20	Free
//=============================================================================
#define GPIO_52_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_52_MUX             0					///<0:GPIO52	 		1:EQEP1S		2:EM1A12		3:Reserved
													///<4:GPIO52			5:Reserved		6:SPICLKC		7:SD1-D3
													///<8:GPIO52			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO52			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_52_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_52_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_21	EM2_D15 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_53_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_53_MUX             0					///<0:GPIO53	 		1:EQEP1I		2:EM1D31		3:EM2D15
													///<4:GPIO53			5:Reserved		6:/SPISTEC		7:SD1-C3
													///<8:GPIO53			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO53			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_53_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_53_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_53_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_22	EM2_D14 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_54_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_54_MUX             0					///<0:GPIO54	 		1:SPISIMOA		2:EM1D30		3:EM2D14
													///<4:GPIO54			5:EQEP2A		6:SCITXDB		7:SD1-D4
													///<8:GPIO54			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO54			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_54_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_54_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_54_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_23	EM2_D13 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_55_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_55_MUX             0					///<0:GPIO55	 		1:SPISOMIA		2:EM1D29		3:EM2D13
													///<4:GPIO55			5:EQEP2B		6:SCIRXDB		7:SD1-C4
													///<8:GPIO55			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO55			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_55_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_55_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_55_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_24	EM2_D12 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_56_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_56_MUX             0					///<0:GPIO56	 		1:SPICLKA		2:EM1D28		3:EM2D12
													///<4:GPIO56			5:EQEP2S		6:SCITXDC		7:SD2-D1
													///<8:GPIO56			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO56			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_56_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_56_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_56_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_25	EM2_D11 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_57_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_57_MUX             0					///<0:GPIO57	 		1:/SPISTEA		2:EM1D27		3:EM2D11
													///<4:GPIO57			5:EQEP2I		6:SCIRXDC		7:SD2-C1
													///<8:GPIO57			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO57			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_57_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_57_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_57_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_26	EM2_D10 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_58_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_58_MUX             0					///<0:GPIO58	 		1:MCLKRA		2:EM1D26		3:EM2D10
													///<4:GPIO58			5:OUTPUTXBAR1	6:SPICLKB		7:SD2-D2
													///<8:GPIO58			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO58			13:Reserved		14:Reserved		15:SPISIMOA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_58_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_58_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_58_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_27	EM2_D9 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_59_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_59_MUX             0					///<0:GPIO59	 		1:MFSRA			2:EM1D25		3:EM2D9
													///<4:GPIO59			5:OUTPUTXBAR2	6:/SPISTEB		7:SD2-C2
													///<8:GPIO59			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO59			13:Reserved		14:Reserved		15:SPISOMIA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_59_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_59_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_59_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_28	EM2_D8 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_60_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_60_MUX             0					///<0:GPIO60	 		1:MCLKRB		2:EM1D24		3:EM2D8
													///<4:GPIO60			5:OUTPUTXBAR3	6:SPISIMOB		7:SD2-D3
													///<8:GPIO60			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO60			13:Reserved		14:Reserved		15:SPICLKA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
//#define GPIO_60_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
#define GPIO_60_DIR             GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_60_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_B_29	EM2_D7 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_61_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_61_MUX             0					///<0:GPIO61	 		1:MFSRB			2:EM1D23		3:EM2D7
													///<4:GPIO61			5:OUTPUTXBAR4	6:SPISOMIB		7:SD2-C3
													///<8:GPIO61			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO61			13:Reserved		14:Reserved		15:/SPISTEA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_61_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_61_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_30	EM2_D6 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_62_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_62_MUX             0					///<0:GPIO62	 		1:SCIRXDC		2:EM1D22		3:EM2D6
													///<4:GPIO62			5:EQEP3A		6:CANRXA		7:SD2-D4
													///<8:GPIO62			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO62			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_62_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_62_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_B_31	EM2_D5 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_63_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_63_MUX             0					///<0:GPIO63	 		1:SCITXDC		2:EM1D21		3:EM2D5
													///<4:GPIO63			5:EQEP3B		6:CANTXA  		7:SD2-C4
													///<8:GPIO63			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO63			13:Reserved		14:Reserved		15:SPISIMOB
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_63_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_63_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_0 	EM2_D4 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_64_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_64_MUX             0					///<0:GPIO64	 		1:Reserved		2:EM1D20  		3:EM2D4
													///<4:GPIO64			5:EQEP3S  		6:SCIRXDA 		7:Reserved
													///<8:GPIO64			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO64			13:Reserved		14:Reserved		15:SPISOMIB
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_64_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_64_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_1 	EM2_D3 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_65_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_65_MUX             0					///<0:GPIO65	 		1:Reserved		2:EM1D19  		3:EM2D3
													///<4:GPIO65			5:EQEP3I  		6:SCITXDA  		7:Reserved
													///<8:GPIO65			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO65			13:Reserved		14:Reserved		15:SPICLKB
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_65_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_65_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_2 	EM2_D2 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_66_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_66_MUX             0					///<0:GPIO66	 		1:Reserved		2:EM1D18		3:EM2D2
													///<4:GPIO66			5:Reserved		6:SDAB			7:Reserved
													///<8:GPIO66			9:Reserved		10:Reserved		11:Reserved
													///<13:GPIO66			13:Reserved		14:Reserved		15:/SPISTEB
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_66_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_66_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_3 	EM2_D1 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_67_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_67_MUX             0					///<0:GPIO67	 		1:Reserved		2:EM1D17  		3:EM2D1
													///<4:GPIO67			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO67			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO67			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_67_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_67_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_4 	EM2_D0 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_68_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_68_MUX             0					///<0:GPIO68	 		1:Reserved		2:EM1D16  		3:EM2D0
													///<4:GPIO68			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO68			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO68			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_68_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_68_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_5 	VANA_0_OFF
//=============================================================================
//-----------------------------------------------------------------------------
#define GPIO_69_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_69_MUX             0					///<0:GPIO69	 		1:Reserved		2:EM1D15  		3:Reserved
													///<4:GPIO69			5:Reserved		6:SCLB    		7:Reserved
													///<8:GPIO69			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO69			13:Reserved		14:Reserved		15:SPISIMOC
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_69_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_69_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_6 	VANA_1_OFF
//=============================================================================
#define GPIO_70_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_70_MUX             0					///<0:GPIO70	 		1:Reserved		2:EM1D14  		3:Reserved
													///<4:GPIO70			5:CANRXA  		6:SCITXDB 		7:Reserved
													///<8:GPIO70			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO70			13:Reserved		14:Reserved		15:SPISOMIC
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_70_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_70_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_7 	VANA_2_OFF
//=============================================================================
#define GPIO_71_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_71_MUX             0					///<0:GPIO71	 		1:Reserved		2:EM1D13  		3:Reserved
													///<4:GPIO71			5:CANTXA  		6:SCIRXDB  		7:Reserved
													///<8:GPIO71			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO71			13:Reserved		14:Reserved		15:SPICLKC
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_71_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_71_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_8 	Free
//=============================================================================
#define GPIO_72_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_72_MUX             0					///<0:GPIO72	 		1:Reserved		2:EM1D12		3:Reserved
													///<4:GPIO72			5:CANTXB		6:SCITXDC		7:Reserved
													///<8:GPIO72			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO72			13:Reserved		14:Reserved		15:/SPISTEC
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_72_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_72_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_9 	/CUR_ON_3
//=============================================================================
//-----------------------------------------------------------------------------
#define GPIO_73_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_73_MUX             0					///<0:GPIO73	 		1:Reserved		2:EM1D11		3:XCLKOUT
													///<4:GPIO73			5:CANRXB		6:SCIRXDC		7:Reserved
													///<8:GPIO73			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO73			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_73_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_73_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_10	/CUR_RED_3
//=============================================================================
#define GPIO_74_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_74_MUX             0					///<0:GPIO74	 		1:Reserved		2:EM1D10		3:Reserved
													///<4:GPIO74			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO74			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO74			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_74_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_74_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_11	/CUR_ON_2
//=============================================================================
#define GPIO_75_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_75_MUX             0					///<0:GPIO75	 		1:Reserved		2:EM1D9			3:Reserved
													///<4:GPIO75			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO75			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO75			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_75_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_75_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_12	/CUR_RED_2
//=============================================================================
#define GPIO_76_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_76_MUX             0					///<0:GPIO76	 		1:Reserved		2:EM1D8			3:Reserved
													///<4:GPIO76			5:Reserved		6:SCITXDD		7:Reserved
													///<8:GPIO76			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO76			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_76_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_76_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_13	Vana_3_off
//=============================================================================
#define GPIO_77_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_77_MUX             0					///<0:GPIO77	 		1:Reserved		2:EM1D7			3:Reserved
													///<4:GPIO77			5:Reserved		6:SCIRXDD		7:Reserved
													///<8:GPIO77			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO77			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_77_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_77_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_14	2204: Encoder Motore 1 CHA	1104,1204,5106: Encoder 1 CHA
//=============================================================================
#define GPIO_78_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_78_MUX             6					///<0:GPIO78	 		1:Reserved		2:EM1D6			3:Reserved
													///<4:GPIO78			5:Reserved		6:EQEP2A		7:Reserved
													///<8:GPIO78			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO78			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_78_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_78_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_15	2204: Encoder Motore 1 CHB	1104,1204,5106: Encoder 1 CHB
//=============================================================================
#define GPIO_79_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_79_MUX             6					///<0:GPIO79	 		1:Reserved		2:EM1D5			3:Reserved
													///<4:GPIO79			5:Reserved		6:EQEP2B		7:Reserved
													///<8:GPIO79			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO79			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_79_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_79_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_16	Free
//=============================================================================
#define GPIO_80_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_80_MUX             0					///<0:GPIO80	 		1:Reserved		2:EM1D4			3:Reserved
													///<4:GPIO80			5:Reserved		6:EQEP2S		7:Reserved
													///<8:GPIO80			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO80			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_80_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_80_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_17	2204: Encoder Motore 1 CHI	1104,1204,5106: Encoder 1 CHI
//=============================================================================
#define GPIO_81_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_81_MUX             6					///<0:GPIO81	 		1:Reserved		2:EM1D3			3:Reserved
													///<4:GPIO81			5:Reserved		6:EQEP2I		7:Reserved
													///<8:GPIO81			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO81			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_81_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_81_FLAG			GPIO_INVERT | GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_18	Free
//=============================================================================
#define GPIO_82_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_82_MUX             0					///<0:GPIO82	 		1:Reserved		2:EM1D2			3:Reserved
													///<4:GPIO82			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO82			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO82			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_82_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_82_FLAG			GPIO_SYNC | GPIO_PULLUP

								  
//=============================================================================
// GPIO_PORT_C_19	/FLD_LED_YEL
//=============================================================================
#define GPIO_83_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_83_MUX             0					///<0:GPIO83	 		1:Reserved		2:EM1D1			3:Reserved
													///<4:GPIO83			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO83			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO83			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_83_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_83_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_20	USB-TX
//=============================================================================
#define GPIO_84_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_84_MUX             5					///<0:GPIO84	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO84			5:SCITXDA		6:MDXB			7:Reserved
													///<8:GPIO84			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO84			13:Reserved		14:Reserved		15:MDXA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_84_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
// #define GPIO_84_FLAG			GPIO_SYNC | GPIO_OPENDRAIN
#define GPIO_84_FLAG            0

//=============================================================================
// GPIO_PORT_C_21	USB-RX
//=============================================================================
#define GPIO_85_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_85_MUX             5					///<0:GPIO85	 		1:Reserved		2:EM1D0			3:Reserved
													///<4:GPIO85			5:SCIRXDA		6:MDRB			7:Reserved
													///<8:GPIO85			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO85			13:Reserved		14:Reserved		15:MDRA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_85_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
// #define GPIO_85_FLAG			GPIO_SYNC
#define GPIO_85_FLAG            0

//=============================================================================
// GPIO_PORT_C_22	/ALARM_2
//=============================================================================
#define GPIO_86_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_86_MUX             0					///<0:GPIO86	 		1:Reserved		2:EM1A13		3:EM1CAS
													///<4:GPIO86			5:SCITXDB		6:MCLKXB		7:Reserved
													///<8:GPIO86			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO86			13:Reserved		14:Reserved		15:MCLKXA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_86_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_86_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_23	/DRIVE_OK_2
//=============================================================================
#define GPIO_87_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_87_MUX             0					///<0:GPIO87	 		1:Reserved		2:EM1A14		3:EM1RAS
													///<4:GPIO87			5:SCIRXDB		6:MFSXB			7:Reserved
													///<8:GPIO87			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO87			13:Reserved		14:Reserved		15:MFSXA
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_87_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_87_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_24	/ALARM_3
//=============================================================================
#define GPIO_88_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_88_MUX             0					///<0:GPIO88	 		1:Reserved		2:EM1A15		3:EM1DQM0
													///<4:GPIO88			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO88			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO88			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_88_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_88_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_25	/DRIVE_OK_3
//=============================================================================
#define GPIO_89_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_89_MUX             0					///<0:GPIO89	 		1:Reserved		2:EM1A16		3:EM1DQM1
													///<4:GPIO89			5:Reserved		6:SCITXDC		7:Reserved
													///<8:GPIO89			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO89			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_89_DIR             GPIO_OUTPUT		///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_89_FLAG			GPIO_SYNC | GPIO_PULLUP

#if AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_MODBUS
	//=============================================================================
	// GPIO_PORT_C_26	/RS485_TXE
	//=============================================================================
	#define GPIO_90_DEFAULTVALUE    1
	//-----------------------------------------------------------------------------
	#define GPIO_90_MUX             0					///<0:GPIO90	 		1:Reserved		2:EM1A17		3:EM1DQM2
														///<4:GPIO90			5:Reserved		6:SCIRSDC		7:Reserved
														///<8:GPIO90			9:Reserved		10:Reserved		11:Reserved
														///<12:GPIO90			13:Reserved		14:Reserved		15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_90_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_90_FLAG			GPIO_SYNC | GPIO_PUSHPULL
#else
		//=============================================================================
	// GPIO_PORT_C_26	EXP_IO_1
	//=============================================================================
	#define GPIO_90_DEFAULTVALUE    0
	//-----------------------------------------------------------------------------
	#define GPIO_90_MUX             0					///<0:GPIO90	 		1:Reserved		2:EM1A17		3:EM1DQM2
														///<4:GPIO90			5:Reserved		6:SCIRSDC		7:Reserved
														///<8:GPIO90			9:Reserved		10:Reserved		11:Reserved
														///<12:GPIO90			13:Reserved		14:Reserved		15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_90_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_90_FLAG			GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_C_27	EXP_IO_2
//=============================================================================
#define GPIO_91_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_91_MUX             0					///<0:GPIO91	 		1:Reserved		2:EM1A18		3:EM1DQM3
													///<4:GPIO91			5:Reserved		6:SDAA			7:Reserved
													///<8:GPIO91			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO91			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_91_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                     				///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                					///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                					///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                					///< GPIO_ASYNC    : Async
#define GPIO_91_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_C_28	/FLD1_LED_GREEN
//=============================================================================
#define GPIO_92_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_92_MUX             0					///<0:GPIO92	 		1:Reserved		2:EM1A19		3:EM1BA1
													///<4:GPIO92			5:Reserved		6:SCLA			7:Reserved
													///<8:GPIO92			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO92			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_92_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_92_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_29	/FLD1_LED_RED
//=============================================================================
#define GPIO_93_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_93_MUX             0					///<0:GPIO93	 		1:Reserved		2:EM1BA0		3:Reserved
													///<4:GPIO93			5:Reserved		6:SCITXDD		7:Reserved
													///<8:GPIO93			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO93			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_93_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_93_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_30	/FLD2_LED_GREEN
//=============================================================================
#define GPIO_94_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_94_MUX             0					///<0:GPIO94	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO94			5:Reserved		6:SCIRXDD		7:Reserved
													///<8:GPIO94			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO94			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_94_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_94_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_C_31	/FLD2_LED_RED
//=============================================================================
#define GPIO_95_DEFAULTVALUE    1
//-----------------------------------------------------------------------------
#define GPIO_95_MUX             0					///<0:GPIO95	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO95			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO95			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO95			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_95_DIR             GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_95_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_0  	Free (EXP_IO_3)
//=============================================================================
#define GPIO_96_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_96_MUX             0                  	///<0:GPIO96            1:Reserved      2:Reserved      3:EM2DQM1
													///<4:GPIO96            5:EQEP1A        6:Reserved      7:Reserved
													///<8:GPIO96            9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO96           13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_96_DIR				GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_96_FLAG            GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_1    EXP_IO_4
//=============================================================================
#define GPIO_97_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_97_MUX             0                  	///<0:GPIO97            1:Reserved      2:Reserved      3:EM2A11
													///<4:GPIO97            5:Reserved      6:Reserved      7:Reserved
													///<8:GPIO97            9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO97           13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_97_DIR             GPIO_OUTPUT       	///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_97_FLAG            GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_2 	EM2-A0      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_98_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_98_MUX             0					///<0:GPIO98	 		1:Reserved		2:EM2A0			3:Reserved
													///<4:GPIO98			5:EQEP1S		6:Reserved		7:Reserved
													///<8:GPIO98			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO98			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_98_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_98_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_3 	EM2-A1      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_99_DEFAULTVALUE    0
//-----------------------------------------------------------------------------
#define GPIO_99_MUX             0					///<0:GPIO99	 		1:Reserved		2:Reserved		3:EM2A1
													///<4:GPIO99			5:EQEP1I		6:Reserved		7:Reserved
													///<8:GPIO99			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO99			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_99_DIR             GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_99_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_4  	EM2-A2      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_100_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_100_MUX            0					///<0:GPIO100	 		1:Reserved		2:Reserved		3:EM2A2
													///<4:GPIO100			5:EQEP2A		6:SPISIMOC		7:Reserved
													///<8:GPIO100			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO100			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_100_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_100_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_5  	EM2-A3      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_101_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_101_MUX            0					///<0:GPIO101	 		1:Reserved		2:Reserved		3:EM2A3
													///<4:GPIO101			5:EQEP2B		6:SPISOMIC		7:Reserved
													///<8:GPIO101			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO101			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_101_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_101_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_6  	EM2-A4      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_102_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_102_MUX            0					///<0:GPIO102	 		1:Reserved		2:Reserved		3:EM2A4
													///<4:GPIO102			5:EQEP2S		6:SPICLKC		7:Reserved
													///<8:GPIO102			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO102			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_102_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_102_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_7  	EM2-A5      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_103_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_103_MUX            0					///<0:GPIO103	 		1:Reserved		2:Reserved		3:EM2A5
													///<4:GPIO103			5:EQEP2I		6:/SPISTEC		7:Reserved
													///<8:GPIO103			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO103			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_103_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_103_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_8  	EM2-A6      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_104_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_104_MUX            0					///<0:GPIO104	 		1:SDAA			2:Reserved		3:EM2A6
													///<4:GPIO104			5:EQEP3A		6:SCITXDD		7:Reserved
													///<8:GPIO104			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO104			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_104_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_104_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_9  	EM2-A7      Scambia tra memoria AEI FIFO e CI
//=============================================================================
#if (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_ANTAIOS)
	#define GPIO_105_DEFAULTVALUE  	0
	//-----------------------------------------------------------------------------
	#define GPIO_105_MUX            0					///<0:GPIO105	 		1:SCLA			2:Reserved		3:EM2A7
														///<4:GPIO105			5:EQEP3B		6:SCIRXDD		7:Reserved
														///<8:GPIO105			9:Reserved		10:Reserved		11:Reserved
														///<12:GPIO105			13:Reserved		14:Reserved		15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_105_DIR           	GPIO_OUTPUT 		///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_105_FLAG			GPIO_SYNC | GPIO_PUSHPULL
#else
	// GPIO_PORT_D_9    EM2-A7      (Viene impostato durante la configurazione dell'EMIF2)
	//
	#define GPIO_105_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_105_MUX            0                   ///<0:GPIO105           1:SCLA          2:Reserved      3:EM2A7
														///<4:GPIO105           5:EQEP3B        6:SCIRXDD       7:Reserved
														///<8:GPIO105           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO105          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_105_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_105_FLAG           GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_D_10 	EM2-A8 (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#if ((AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_PROFIBUS) && (AECDEVICE_COM_DEVICE==AECDEVICE_COM_DEVICE_VPC3)) || \
	 ((AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_ETHERNET) && (AECDEVICE_COM_DEVICE==AECDEVICE_COM_DEVICE_WIZNET))
	#define GPIO_106_DEFAULTVALUE  	0
	//-----------------------------------------------------------------------------
	#define GPIO_106_MUX            0					///<0:GPIO106	 		1:Reserved		2:Reserved		3:EM2A8
														///<4:GPIO106			5:EQEP3S		6:SCITXDC		7:Reserved
														///<8:GPIO106			9:Reserved		10:Reserved		11:Reserved
														///<12:GPIO106			13:Reserved		14:Reserved		15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_106_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_106_FLAG			GPIO_SYNC | GPIO_PULLUP
#elif (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_ANTAIOS)
	// GPIO_PORT_D_10   GPIO    Ingresso per interrupt PPUGPIO_0 in modo normale / Impostato come SCITXDC durante il boot dell'Antaios
	//
	#define GPIO_106_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_106_MUX            0                   ///<0:GPIO106           1:Reserved      2:Reserved      3:EM2A8
														///<4:GPIO106           5:EQEP3S        6:SCITXDC       7:Reserved
														///<8:GPIO106           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO106          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_106_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_106_FLAG           GPIO_PULLUP
#elif (AECDEVICE_CANALECOM == AECDEVICE_CANALECOM_MODBUS)
	//=============================================================================
	// GPIO_PORT_D_10   RS232_Tx
	//=============================================================================
	#define GPIO_106_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_106_MUX            6                   ///<0:GPIO106           1:Reserved      2:Reserved      3:EM2A8
														///<4:GPIO106           5:EQEP3S        6:SCITXDC       7:Reserved
														///<8:GPIO106           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO106          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_106_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_106_FLAG           GPIO_SYNC | GPIO_PUSHPULL
#else
	//=============================================================================
	// GPIO_PORT_D_10   Free
	//=============================================================================
	#define GPIO_106_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_106_MUX            0                   ///<0:GPIO106           1:Reserved      2:Reserved      3:EM2A8
														///<4:GPIO106           5:EQEP3S        6:SCITXDC       7:Reserved
														///<8:GPIO106           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO106          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_106_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_106_FLAG           GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_D_11   EM2-A9      (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#if ((AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_PROFIBUS) && (AECDEVICE_COM_DEVICE==AECDEVICE_COM_DEVICE_VPC3)) || \
	 ((AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_ETHERNET) && (AECDEVICE_COM_DEVICE==AECDEVICE_COM_DEVICE_WIZNET))
	#define GPIO_107_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_107_MUX            0                   ///<0:GPIO107           1:Reserved      2:Reserved      3:EM2A9
														///<4:GPIO107           5:EQEP3I        6:SCIRXDC       7:Reserved
														///<8:GPIO107           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO107          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_107_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_107_FLAG           GPIO_SYNC | GPIO_PULLUP
#elif (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_ANTAIOS)
	// GPIO_PORT_D_11   GPIO    Ingresso per interrupt PPUGPIO_1 in modo normale / Impostato come SCIRXDC durante il boot dell'Antaios
	//
	#define GPIO_107_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_107_MUX            0                   ///<0:GPIO107           1:Reserved      2:Reserved      3:EM2A9
														///<4:GPIO107           5:EQEP3I        6:SCIRXDC       7:Reserved
														///<8:GPIO107           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO107          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_107_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_107_FLAG           GPIO_SYNC | GPIO_PULLUP
#elif (AECDEVICE_CANALECOM==AECDEVICE_CANALECOM_MODBUS)
	//=============================================================================
	// GPIO_PORT_D_11   RS232_Rx
	//=============================================================================
	#define GPIO_107_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_107_MUX            6                   ///<0:GPIO107           1:Reserved      2:Reserved      3:EM2A9
														///<4:GPIO107           5:EQEP3I        6:SCIRXDC       7:Reserved
														///<8:GPIO107           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO107          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_107_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_107_FLAG           GPIO_SYNC  
	
#else
	//=============================================================================
	// GPIO_PORT_D_11   Free
	//=============================================================================
	#define GPIO_107_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_107_MUX            0                   ///<0:GPIO107           1:Reserved      2:Reserved      3:EM2A9
														///<4:GPIO107           5:EQEP3I        6:SCIRXDC       7:Reserved
														///<8:GPIO107           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO107          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_107_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_107_FLAG           GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_D_12   Antaios Profinet interrupt input
//=============================================================================
#if (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_ANTAIOS)
	#define GPIO_108_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_108_MUX            0                   ///<0:GPIO108           1:Reserved      2:Reserved      3:EM2A10
														///<4:GPIO108           5:Reserved      6:Reserved      7:Reserved
														///<8:GPIO108           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO108          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_108_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_108_FLAG           GPIO_SYNC | GPIO_PULLUP
#else
	// GPIO_PORT_D_12   EM2A10      (Viene impostato durante la configurazione dell'EMIF2)
	//
	#define GPIO_108_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_108_MUX            0                   ///<0:GPIO108           1:Reserved      2:Reserved      3:EM2A10
														///<4:GPIO108           5:Reserved      6:Reserved      7:Reserved
														///<8:GPIO108           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO108          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_108_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_108_FLAG           GPIO_SYNC | GPIO_PULLUP
#endif

#if ((AECDEVICE_TIPOENCODERABS == AECDEVICE_TIPOENCODERABS_SSI) || \
	 (AECDEVICE_TIPOENCODERABS==AECDEVICE_TIPOENCODERABS_BISSC))
	//=============================================================================
	// GPIO_PORT_D_13   SSIPRESET
	//=============================================================================
	#define GPIO_109_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_109_MUX            0                   ///<0:GPIO109           1:Reserved      2:Reserved      3:EM2A11
														///<4:GPIO109           5:Reserved      6:Reserved      7:Reserved
														///<8:GPIO109           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO109          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_109_DIR            GPIO_OUTPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_109_FLAG           GPIO_SYNC | GPIO_PUSHPULL
#else

	//=============================================================================
	// GPIO_PORT_D_13   Free
	//=============================================================================
	#define GPIO_109_DEFAULTVALUE   0
	//-----------------------------------------------------------------------------
	#define GPIO_109_MUX            0                   ///<0:GPIO109           1:Reserved      2:Reserved      3:EM2A11
														///<4:GPIO109           5:Reserved      6:Reserved      7:Reserved
														///<8:GPIO109           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO109          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_109_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_109_FLAG           GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_D_14 	EM2-WAIT    (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_110_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_110_MUX            0					///<0:GPIO110	 		1:Reserved		2:Reserved		3:EM2WAIT
													///<4:GPIO110			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO110			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO110			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_110_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_110_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_15   BYTE_MODE Antaios
//=============================================================================
#if (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_ANTAIOS)
	//-----------------------------------------------------------------------------
	#define GPIO_111_DEFAULTVALUE   1
	//-----------------------------------------------------------------------------
	#define GPIO_111_MUX            0                   ///<0:GPIO111           1:Reserved      2:Reserved      3:EM2BA0
														///<4:GPIO111           5:Reserved      6:Reserved      7:Reserved
														///<8:GPIO111           9:Reserved      10:Reserved     11:Reserved
														///<12:GPIO111          13:Reserved     14:Reserved     15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_111_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_111_FLAG           GPIO_ASYNC | GPIO_PUSHPULL
#else
	// GPIO_PORT_D_15 	EM2-BA0     (Viene impostato durante la configurazione dell'EMIF2)
	//
	#define GPIO_111_DEFAULTVALUE  	0
	//-----------------------------------------------------------------------------
	#define GPIO_111_MUX            0					///<0:GPIO111	 		1:Reserved		2:Reserved		3:EM2BA0
														///<4:GPIO111			5:Reserved		6:Reserved		7:Reserved
														///<8:GPIO111			9:Reserved		10:Reserved		11:Reserved
														///<12:GPIO111			13:Reserved		14:Reserved		15:Reserved
	//-----------------------------------------------------------------------------
														///< GPIO_INPUT : Input
	#define GPIO_111_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
	//-----------------------------------------------------------------------------
														///< GPIO_PUSHPULL : PushPull Output pin
														///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
														///< GPIO_OPENDRAIN: OpenDrain Output pin
														///< GPIO_INVERT   : Invert input state of the pin
														///< GPIO_SYNC     : SYSCLKOUT
														///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
														///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
														///< GPIO_ASYNC    : Async
	#define GPIO_111_FLAG			GPIO_SYNC | GPIO_PULLUP
#endif

//=============================================================================
// GPIO_PORT_D_16 	EM2-BA1     (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_112_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_112_MUX            0					///<0:GPIO112	 		1:Reserved		2:Reserved		3:EM2BA1
													///<4:GPIO112			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO112			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO112			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_112_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_112_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_17 	Led Green 1 (Da Antaios GPIO_1)
//=============================================================================
#define GPIO_113_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_113_MUX            0					///<0:GPIO113	 		1:Reserved		2:Reserved		3:EM2CAS
													///<4:GPIO113			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO113			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO113			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_113_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_113_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_18 	Led Red 1 (Da Antaios GPIO_2)
//=============================================================================
#define GPIO_114_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_114_MUX            0					///<0:GPIO114	 		1:Reserved		2:Reserved		3:EM2RAS
													///<4:GPIO114			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO114			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO114			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_114_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_114_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_19   /EM2-CS0    (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_115_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_115_MUX            0                   ///<0:GPIO115           1:Reserved      2:Reserved      3:/EM2CS0
													///<4:GPIO115           5:Reserved      6:Reserved      7:Reserved
													///<8:GPIO115           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO115          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_115_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_115_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_20   /EM2-CS2    (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_116_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_116_MUX            0					///<0:GPIO116	 		1:Reserved		2:Reserved		3:/EM2CS2
													///<4:GPIO116			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO116			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO116			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_116_DIR           	GPIO_INPUT  		///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_116_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_21   Led Green 2 (Da Antaios GPIO_3)
//=============================================================================
#define GPIO_117_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_117_MUX            0					///<0:GPIO117	 		1:Reserved		2:Reserved		3:EM2SDCKE
													///<4:GPIO117			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO117			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO117			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_117_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_117_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_22 	Led Red 2 (Da Antaios GPIO_4)
//=============================================================================
#define GPIO_118_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_118_MUX            0					///<0:GPIO118	 		1:Reserved		2:Reserved		3:EM2CLK
													///<4:GPIO118			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO118			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO118			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_118_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_118_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_23 	Led Yellow (Da Antaios GPIO_5)
//=============================================================================
#define GPIO_119_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_119_MUX            0					///<0:GPIO119	 		1:Reserved		2:Reserved		3:EM2RNW
													///<4:GPIO119			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO119			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO119			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_119_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_119_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_24 	/EM2-WE (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_120_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_120_MUX            0					///<0:GPIO120	 		1:Reserved		2:Reserved		3:/EM2WE
													///<4:GPIO120			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO120			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO120			13:Reserved		14:Reserved		15:USB0EPEN
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_120_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_120_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_25 	/EM2-RD (Viene impostato durante la configurazione dell'EMIF2)
//=============================================================================
#define GPIO_121_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_121_MUX            0					///<0:GPIO121	 		1:Reserved		2:Reserved		3:/EM2OE
													///<4:GPIO121			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO121			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO121			13:Reserved		14:Reserved		15:USB0EPEN
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_121_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_121_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_26 	/IRQ-EXP
//=============================================================================
#define GPIO_122_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_122_MUX            0					///<0:GPIO122	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO122			5:Reserved		6:SPISIMOC		7:SD1-D1
													///<8:GPIO122			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO122			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_122_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_122_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_D_27 	BOOT-MAIN (Manda in modo BOOT l'Antaios)
//=============================================================================
#define GPIO_123_DEFAULTVALUE  	1
//-----------------------------------------------------------------------------
#define GPIO_123_MUX            0					///<0:GPIO123	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO123			5:Reserved		6:SPISOMIC		7:SD1-C1
													///<8:GPIO123			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO123			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_123_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_123_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_28 	/ALARM_1
//=============================================================================
#define GPIO_124_DEFAULTVALUE  	1
//-----------------------------------------------------------------------------
#define GPIO_124_MUX            0					///<0:GPIO124	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO124			5:Reserved		6:SPICLKC		7:SD1-D2
													///<8:GPIO124			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO124			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_124_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_124_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_29 	/DRIVE_OK_1
//=============================================================================
#define GPIO_125_DEFAULTVALUE  	1
//-----------------------------------------------------------------------------
#define GPIO_125_MUX            0					///<0:GPIO125	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO125			5:Reserved		6:/SPISTEC		7:SD1-C2
													///<8:GPIO125			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO125			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_125_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_125_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_30 	/CUR_RED_1
//=============================================================================
#define GPIO_126_DEFAULTVALUE  	1
//-----------------------------------------------------------------------------
#define GPIO_126_MUX            0					///<0:GPIO126	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO126			5:Reserved		6:Reserved		7:SD1-D3
													///<8:GPIO126			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO126			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_126_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_126_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_D_31 	/CUR_ON_1
//=============================================================================
#define GPIO_127_DEFAULTVALUE  	1
//-----------------------------------------------------------------------------
#define GPIO_127_MUX            0					///<0:GPIO127	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO127			5:Reserved		6:Reserved		7:SD1-C3
													///<8:GPIO127			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO127			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_127_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                         			///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                    				///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                    				///< GPIO_ASYNC    : Async
#define GPIO_127_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_0  	DIG-INP0
//=============================================================================
#define GPIO_128_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_128_MUX            0					///<0:GPIO128	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO128			5:Reserved		6:Reserved		7:SD1-D4
													///<8:GPIO128			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO128			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_128_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_128_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_1  	DIG-INP1
//=============================================================================
#define GPIO_129_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_129_MUX            0					///<0:GPIO129	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO129			5:Reserved		6:Reserved		7:SD1-C4
													///<8:GPIO129			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO129			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_129_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_129_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_2  	DIG-INP2
//=============================================================================
#define GPIO_130_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_130_MUX            0					///<0:GPIO130	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO130			5:Reserved		6:Reserved		7:SD2-D1
													///<8:GPIO130			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO130			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_130_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                       				///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                   					///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_ASYNC    : Async
#define GPIO_130_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_3  	DIG-INP3
//=============================================================================
#define GPIO_131_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_131_MUX            0					///<0:GPIO131	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO131			5:Reserved		6:Reserved		7:SD2-C1
													///<8:GPIO131			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO131			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_131_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                       				///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                   					///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_ASYNC    : Async
#define GPIO_131_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_4  	DIG-INP4
//=============================================================================
#define GPIO_132_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_132_MUX            0					///<0:GPIO132	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO132			5:Reserved		6:Reserved		7:SD2-D2
													///<8:GPIO132			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO132			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_132_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
                                       				///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
                                   					///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                   					///< GPIO_ASYNC    : Async
#define GPIO_132_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_5  	DIG-INP5
//=============================================================================
#define GPIO_133_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_133_MUX            0					///<0:GPIO133	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO133			5:Reserved		6:Reserved		7:SD2-C2
													///<8:GPIO133			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO133			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_133_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_133_FLAG			GPIO_SYNC | GPIO_PULLUP
	
//=============================================================================
// GPIO_PORT_E_6  	DIG-INP6
//=============================================================================
#define GPIO_134_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_134_MUX            0					///<0:GPIO134	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO134			5:Reserved		6:Reserved		7:SD2-D3
													///<8:GPIO134			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO134			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_134_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_134_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_7  	DIG-INP7
//=============================================================================
#define GPIO_135_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_135_MUX            0					///<0:GPIO135	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO135			5:Reserved		6:SCITXDA 		7:SD2-C3
													///<8:GPIO135			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO135			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_135_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_135_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_8  	DIG-INP8
//=============================================================================
#define GPIO_136_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_136_MUX            0					///<0:GPIO136	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO136			5:Reserved		6:SCIRXDA 		7:SD2-D4
													///<8:GPIO136			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO136			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_136_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_136_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_9  	Free
//=============================================================================
#define GPIO_137_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_137_MUX            0					///<0:GPIO137	 		1:Reserved		2:Reserved		3:Reserved
													///<4:GPIO137			5:Reserved		6:SCITXDB 		7:SD2-C4
													///<8:GPIO137			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO137			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_137_DIR           	GPIO_INPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_137_FLAG			GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_10   Free
//=============================================================================
#define GPIO_138_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_138_MUX            0                   ///<0:GPIO138           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO138           5:Reserved      6:SCIRXDB       7:Reserved
													///<8:GPIO138           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO138          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_138_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_138_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_11   Free
//=============================================================================
#define GPIO_139_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_139_MUX            0                   ///<0:GPIO139           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO139           5:Reserved      6:SCIRXDC       7:Reserved
													///<8:GPIO139           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO139          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_139_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_139_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_12   Free
//=============================================================================
#define GPIO_140_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_140_MUX            0                   ///<0:GPIO140           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO140           5:Reserved      6:SCITXDC       7:Reserved
													///<8:GPIO140           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO140          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_140_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_140_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_13   Free
//=============================================================================
#define GPIO_141_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_141_MUX            0                   ///<0:GPIO141           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO141           5:Reserved      6:SCIRXDD       7:Reserved
													///<8:GPIO141           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO141          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_141_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_141_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_14   Free
//=============================================================================
#define GPIO_142_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_142_MUX            0                   ///<0:GPIO142           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO142           5:Reserved      6:SCITXDD       7:Reserved
													///<8:GPIO142           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO142          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_142_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_142_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_15   Free
//=============================================================================
#define GPIO_143_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_143_MUX            0                   ///<0:GPIO143           1:Reserved      2:Reserved      3:Reserved
													///<4:GPIO143           5:Reserved      6:Reserved      7:Reserved
													///<8:GPIO143           9:Reserved      10:Reserved     11:Reserved
													///<12:GPIO143          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_143_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_143_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_16   Free
//=============================================================================
#define GPIO_144_DEFAULTVALUE   1
//-----------------------------------------------------------------------------
#define GPIO_144_MUX            0                   ///<0:GPIO144           1:Reserved      2:Reserved      3:Reserved
                                                    ///<4:GPIO144           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO144           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO144          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_144_DIR            GPIO_INPUT          ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_144_FLAG           GPIO_SYNC | GPIO_PULLUP

//=============================================================================
// GPIO_PORT_E_17 	Fase-AH-3
//=============================================================================
#define GPIO_145_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_145_MUX            1					///<0:GPIO145	 		1:EPWM1A  		2:Reserved		3:Reserved
													///<4:GPIO145			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO145			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO145			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_145_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_145_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_18 	Fase-AL-3
//=============================================================================
#define GPIO_146_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_146_MUX            1					///<0:GPIO146	 		1:EPWM1B  		2:Reserved		3:Reserved
													///<4:GPIO146			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO146			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO146			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_146_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_146_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_19 	Fase-ANH-3
//=============================================================================
#define GPIO_147_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_147_MUX            1					///<0:GPIO147	 		1:EPWM2A  		2:Reserved		3:Reserved
													///<4:GPIO147			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO147			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO147			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_147_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_147_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_20 	Fase-ANL-3
//=============================================================================
#define GPIO_148_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_148_MUX            1					///<0:GPIO148	 		1:EPWM2B  		2:Reserved		3:Reserved
													///<4:GPIO148			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO148			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO148			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_148_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_148_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_21 	Fase-BH-3
//=============================================================================
#define GPIO_149_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_149_MUX            1					///<0:GPIO149	 		1:EPWM3A  		2:Reserved		3:Reserved
													///<4:GPIO149			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO149			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO149			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_149_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_149_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_22 	Fase-BL-3
//=============================================================================
#define GPIO_150_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_150_MUX            1					///<0:GPIO150	 		1:EPWM3B  		2:Reserved		3:Reserved
													///<4:GPIO150			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO150			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO150			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_150_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_150_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_23 	Fase-BNH-3
//=============================================================================
#define GPIO_151_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_151_MUX            1					///<0:GPIO151	 		1:EPWM4A  		2:Reserved		3:Reserved
													///<4:GPIO151			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO151			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO151			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_151_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_151_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_24 	Fase-BNL-3
//=============================================================================
#define GPIO_152_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_152_MUX            1					///<0:GPIO152	 		1:EPWM4B  		2:Reserved		3:Reserved
													///<4:GPIO152			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO152			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO152			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_152_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_152_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_25 	Fase-AH-2
//=============================================================================
#define GPIO_153_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_153_MUX            1					///<0:GPIO153	 		1:EPWM5A  		2:Reserved		3:Reserved
													///<4:GPIO153			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO153			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO153			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_153_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_153_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_26 	Fase-AL-2
//=============================================================================
#define GPIO_154_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_154_MUX            1					///<0:GPIO154	 		1:EPWM5B  		2:Reserved		3:Reserved
													///<4:GPIO154			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO154			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO154			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_154_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_154_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_27 	Fase-ANH-2
//=============================================================================
#define GPIO_155_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_155_MUX            1					///<0:GPIO155	 		1:EPWM6A  		2:Reserved		3:Reserved
													///<4:GPIO155			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO155			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO155			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_155_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_155_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_28 	Fase-ANL-2
//=============================================================================
#define GPIO_156_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_156_MUX            1					///<0:GPIO150	 		1:EPWM6B  		2:Reserved		3:Reserved
													///<4:GPIO150			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO150			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO150			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_156_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_156_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_29 	Fase_BH-2
//=============================================================================
#define GPIO_157_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_157_MUX            1					///<0:GPIO157	 		1:EPWM7A  		2:Reserved		3:Reserved
													///<4:GPIO157			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO157			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO157			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_157_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_157_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_30 	Fase-BL-2
//=============================================================================
#define GPIO_158_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_158_MUX            1					///<0:GPIO158	 		1:EPWM7B  		2:Reserved		3:Reserved
													///<4:GPIO158			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO158			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO158			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_158_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_158_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_E_31 	Fase-BNH-2
//=============================================================================
#define GPIO_159_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_159_MUX            1					///<0:GPIO159	 		1:EPWM8A  		2:Reserved		3:Reserved
													///<4:GPIO159			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO159			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO159			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_159_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_159_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_0  	Fase-BNL-2
//=============================================================================
#define GPIO_160_DEFAULTVALUE  	0
//-----------------------------------------------------------------------------
#define GPIO_160_MUX            1					///<0:GPIO160	 		1:EPWM8B  		2:Reserved		3:Reserved
													///<4:GPIO160			5:Reserved		6:Reserved		7:Reserved
													///<8:GPIO160			9:Reserved		10:Reserved		11:Reserved
													///<12:GPIO160			13:Reserved		14:Reserved		15:Reserved
//-----------------------------------------------------------------------------
													///< GPIO_INPUT : Input
#define GPIO_160_DIR           	GPIO_OUTPUT			///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
													///< GPIO_PUSHPULL : PushPull Output pin
													///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
													///< GPIO_OPENDRAIN: OpenDrain Output pin
													///< GPIO_INVERT   : Invert input state of the pin
													///< GPIO_SYNC     : SYSCLKOUT
													///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
													///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
													///< GPIO_ASYNC    : Async
#define GPIO_160_FLAG			GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_1    Fase AH
//=============================================================================
#define GPIO_161_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_161_MUX            1                   ///<0:GPIO161           1:EPWM9A        2:Reserved      3:Reserved
                                                    ///<4:GPIO161           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO161           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO161          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_161_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_161_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_2    Fase AL
//=============================================================================
#define GPIO_162_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_162_MUX            1                   ///<0:GPIO162           1:EPWM9B        2:Reserved      3:Reserved
                                                    ///<4:GPIO162           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO162           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO162          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_162_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_162_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_3    Fase ANH
//=============================================================================
#define GPIO_163_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_163_MUX            1                   ///<0:GPIO163           1:EPWM10A       2:Reserved      3:Reserved
                                                    ///<4:GPIO163           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO163           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO163          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_163_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_163_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_4    Fase ANL
//=============================================================================
#define GPIO_164_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_164_MUX            1                   ///<0:GPIO164           1:EPWM10B       2:Reserved      3:Reserved
                                                    ///<4:GPIO164           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO164           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO164          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_164_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_164_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_5    Fase BH
//=============================================================================
#define GPIO_165_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_165_MUX            1                   ///<0:GPIO165           1:EPWM11A       2:Reserved      3:Reserved
                                                    ///<4:GPIO165           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO165           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO165          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_165_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_165_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_6    Fase BL
//=============================================================================
#define GPIO_166_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_166_MUX            1                   ///<0:GPIO166           1:EPWM11B       2:Reserved      3:Reserved
                                                    ///<4:GPIO166           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO166           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO166          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_166_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_166_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_7    Fase BNH
//=============================================================================
#define GPIO_167_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_167_MUX            1                   ///<0:GPIO167           1:EPWM12A       2:Reserved      3:Reserved
                                                    ///<4:GPIO167           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO167           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO167          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_167_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_167_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================
// GPIO_PORT_F_8    Fase BNL
//=============================================================================
#define GPIO_168_DEFAULTVALUE   0
//-----------------------------------------------------------------------------
#define GPIO_168_MUX            1                   ///<0:GPIO168           1:EPWM12B       2:Reserved      3:Reserved
                                                    ///<4:GPIO168           5:Reserved      6:Reserved      7:Reserved
                                                    ///<8:GPIO168           9:Reserved      10:Reserved     11:Reserved
                                                    ///<12:GPIO168          13:Reserved     14:Reserved     15:Reserved
//-----------------------------------------------------------------------------
                                                    ///< GPIO_INPUT : Input
#define GPIO_168_DIR            GPIO_OUTPUT         ///< GPIO_OUTPUT: Output
//-----------------------------------------------------------------------------
                                                    ///< GPIO_PUSHPULL : PushPull Output pin
                                                    ///< GPIO_PULLUP   : Internal pull-up enable if Output Open Drain or Input
                                                    ///< GPIO_OPENDRAIN: OpenDrain Output pin
                                                    ///< GPIO_INVERT   : Invert input state of the pin
                                                    ///< GPIO_SYNC     : SYSCLKOUT
                                                    ///< GPIO_QUAL3    : 3 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_QUAL6    : 6 Sample. Time between sample specified by GPACTRL.
                                                    ///< GPIO_ASYNC    : Async
#define GPIO_168_FLAG           GPIO_SYNC | GPIO_PUSHPULL

//=============================================================================

#define GPIO_0_PIN()    	GPIO_ReadPin(0)
#define GPIO_1_PIN()    	GPIO_ReadPin(1)
#define GPIO_2_PIN()    	GPIO_ReadPin(2)
#define GPIO_3_PIN()    	GPIO_ReadPin(3)
#define GPIO_4_PIN()    	GPIO_ReadPin(4)
#define GPIO_5_PIN()    	GPIO_ReadPin(5)
#define GPIO_6_PIN()    	GPIO_ReadPin(6)
#define GPIO_7_PIN()    	GPIO_ReadPin(7)
#define GPIO_8_PIN()    	GPIO_ReadPin(8)
#define GPIO_9_PIN()    	GPIO_ReadPin(9)
#define GPIO_10_PIN()   	GPIO_ReadPin(10)
#define GPIO_11_PIN()   	GPIO_ReadPin(11)
#define GPIO_12_PIN()   	GPIO_ReadPin(12)
#define GPIO_13_PIN()   	GPIO_ReadPin(13)
#define GPIO_14_PIN()   	GPIO_ReadPin(14)
#define GPIO_15_PIN()   	GPIO_ReadPin(15)
#define GPIO_16_PIN()   	GPIO_ReadPin(16)
#define GPIO_17_PIN()   	GPIO_ReadPin(17)
#define GPIO_18_PIN()   	GPIO_ReadPin(18)
#define GPIO_19_PIN()   	GPIO_ReadPin(19)
#define GPIO_20_PIN()   	GPIO_ReadPin(20)
#define GPIO_21_PIN()   	GPIO_ReadPin(21)
#define GPIO_22_PIN()   	GPIO_ReadPin(22)
#define GPIO_23_PIN()   	GPIO_ReadPin(23)
#define GPIO_24_PIN()   	GPIO_ReadPin(24)
#define GPIO_25_PIN()   	GPIO_ReadPin(25)
#define GPIO_26_PIN()   	GPIO_ReadPin(26)
#define GPIO_27_PIN()   	GPIO_ReadPin(27)
#define GPIO_28_PIN()   	GPIO_ReadPin(28)
#define GPIO_29_PIN()   	GPIO_ReadPin(29)
#define GPIO_30_PIN()   	GPIO_ReadPin(30)
#define GPIO_31_PIN()   	GPIO_ReadPin(31)
#define GPIO_32_PIN()   	GPIO_ReadPin(32)
#define GPIO_33_PIN()   	GPIO_ReadPin(33)
#define GPIO_34_PIN()   	GPIO_ReadPin(34)
#define GPIO_35_PIN()   	GPIO_ReadPin(35)
#define GPIO_36_PIN()   	GPIO_ReadPin(36)
#define GPIO_37_PIN()   	GPIO_ReadPin(37)
#define GPIO_38_PIN()   	GPIO_ReadPin(38)
#define GPIO_39_PIN()   	GPIO_ReadPin(39)
#define GPIO_40_PIN()   	GPIO_ReadPin(40)
#define GPIO_41_PIN()   	GPIO_ReadPin(41)
#define GPIO_42_PIN()   	GPIO_ReadPin(42)
#define GPIO_43_PIN()   	GPIO_ReadPin(43)
#define GPIO_44_PIN()   	GPIO_ReadPin(44)
#define GPIO_45_PIN()   	GPIO_ReadPin(45)
#define GPIO_46_PIN()   	GPIO_ReadPin(46)
#define GPIO_47_PIN()   	GPIO_ReadPin(47)
#define GPIO_48_PIN()   	GPIO_ReadPin(48)
#define GPIO_49_PIN()   	GPIO_ReadPin(49)
#define GPIO_50_PIN()   	GPIO_ReadPin(50)
#define GPIO_51_PIN()   	GPIO_ReadPin(51)
#define GPIO_52_PIN()   	GPIO_ReadPin(52)
#define GPIO_53_PIN()   	GPIO_ReadPin(53)
#define GPIO_54_PIN()   	GPIO_ReadPin(54)
#define GPIO_55_PIN()   	GPIO_ReadPin(55)
#define GPIO_56_PIN()   	GPIO_ReadPin(56)
#define GPIO_57_PIN()   	GPIO_ReadPin(57)
#define GPIO_58_PIN()   	GPIO_ReadPin(58)
#define GPIO_59_PIN()   	GPIO_ReadPin(59)
#define GPIO_60_PIN()   	GPIO_ReadPin(60)
#define GPIO_61_PIN()   	GPIO_ReadPin(61)
#define GPIO_62_PIN()   	GPIO_ReadPin(62)
#define GPIO_63_PIN()		GPIO_ReadPin(63)
#define GPIO_64_PIN()   	GPIO_ReadPin(64)
#define GPIO_65_PIN()   	GPIO_ReadPin(65)
#define GPIO_66_PIN()   	GPIO_ReadPin(66)
#define GPIO_67_PIN()   	GPIO_ReadPin(67)
#define GPIO_68_PIN()   	GPIO_ReadPin(68)
#define GPIO_69_PIN()   	GPIO_ReadPin(69)
#define GPIO_70_PIN()   	GPIO_ReadPin(70)
#define GPIO_71_PIN()   	GPIO_ReadPin(71)
#define GPIO_72_PIN()   	GPIO_ReadPin(72)
#define GPIO_73_PIN()   	GPIO_ReadPin(73)
#define GPIO_74_PIN()   	GPIO_ReadPin(74)
#define GPIO_75_PIN()   	GPIO_ReadPin(75)
#define GPIO_76_PIN()   	GPIO_ReadPin(76)
#define GPIO_77_PIN()   	GPIO_ReadPin(77)
#define GPIO_78_PIN()   	GPIO_ReadPin(78)
#define GPIO_79_PIN()   	GPIO_ReadPin(79)
#define GPIO_80_PIN()   	GPIO_ReadPin(80)
#define GPIO_81_PIN()   	GPIO_ReadPin(81)
#define GPIO_82_PIN()   	GPIO_ReadPin(82)
#define GPIO_83_PIN()   	GPIO_ReadPin(83)
#define GPIO_84_PIN()   	GPIO_ReadPin(84)
#define GPIO_85_PIN()   	GPIO_ReadPin(85)
#define GPIO_86_PIN()   	GPIO_ReadPin(86)
#define GPIO_87_PIN()   	GPIO_ReadPin(87)
#define GPIO_88_PIN()   	GPIO_ReadPin(88)
#define GPIO_89_PIN()   	GPIO_ReadPin(89)
#define GPIO_90_PIN()   	GPIO_ReadPin(90)
#define GPIO_91_PIN()   	GPIO_ReadPin(91)
#define GPIO_92_PIN()   	GPIO_ReadPin(92)
#define GPIO_93_PIN()   	GPIO_ReadPin(93)
#define GPIO_94_PIN()   	GPIO_ReadPin(94)
#define GPIO_95_PIN()   	GPIO_ReadPin(95)
#define GPIO_96_PIN()   	GPIO_ReadPin(96)
#define GPIO_97_PIN()   	GPIO_ReadPin(97)
#define GPIO_98_PIN()   	GPIO_ReadPin(98)
#define GPIO_99_PIN()   	GPIO_ReadPin(99)
#define GPIO_100_PIN()  	GPIO_ReadPin(100)
#define GPIO_101_PIN()  	GPIO_ReadPin(101)
#define GPIO_102_PIN()  	GPIO_ReadPin(102)
#define GPIO_103_PIN()  	GPIO_ReadPin(103)
#define GPIO_104_PIN()  	GPIO_ReadPin(104)
#define GPIO_105_PIN()  	GPIO_ReadPin(105)
#define GPIO_106_PIN()  	GPIO_ReadPin(106)
#define GPIO_107_PIN()  	GPIO_ReadPin(107)
#define GPIO_108_PIN()  	GPIO_ReadPin(108)
#define GPIO_109_PIN()  	GPIO_ReadPin(109)
#define GPIO_110_PIN()  	GPIO_ReadPin(110)
#define GPIO_111_PIN()  	GPIO_ReadPin(111)
#define GPIO_112_PIN()  	GPIO_ReadPin(112)
#define GPIO_113_PIN()  	GPIO_ReadPin(113)
#define GPIO_114_PIN()  	GPIO_ReadPin(114)
#define GPIO_115_PIN()  	GPIO_ReadPin(115)
#define GPIO_116_PIN()  	GPIO_ReadPin(116)
#define GPIO_117_PIN()  	GPIO_ReadPin(117)
#define GPIO_118_PIN()  	GPIO_ReadPin(118)
#define GPIO_119_PIN()  	GPIO_ReadPin(119)
#define GPIO_120_PIN()  	GPIO_ReadPin(120)
#define GPIO_121_PIN()  	GPIO_ReadPin(121)
#define GPIO_122_PIN()  	GPIO_ReadPin(122)
#define GPIO_123_PIN()  	GPIO_ReadPin(123)
#define GPIO_124_PIN()  	GPIO_ReadPin(124)
#define GPIO_125_PIN()  	GPIO_ReadPin(125)
#define GPIO_126_PIN()  	GPIO_ReadPin(126)
#define GPIO_127_PIN()  	GPIO_ReadPin(127)
#define GPIO_128_PIN()  	GPIO_ReadPin(128)
#define GPIO_129_PIN()  	GPIO_ReadPin(129)
#define GPIO_130_PIN()  	GPIO_ReadPin(130)
#define GPIO_131_PIN()  	GPIO_ReadPin(131)
#define GPIO_132_PIN()  	GPIO_ReadPin(132)
#define GPIO_133_PIN()  	GPIO_ReadPin(133)
#define GPIO_134_PIN()  	GPIO_ReadPin(134)
#define GPIO_135_PIN()  	GPIO_ReadPin(135)
#define GPIO_136_PIN()  	GPIO_ReadPin(136)
#define GPIO_137_PIN()  	GPIO_ReadPin(137)
#define GPIO_138_PIN()  	GPIO_ReadPin(138)
#define GPIO_139_PIN()  	GPIO_ReadPin(139)
#define GPIO_140_PIN()  	GPIO_ReadPin(140)
#define GPIO_141_PIN()  	GPIO_ReadPin(141)
#define GPIO_142_PIN()  	GPIO_ReadPin(142)
#define GPIO_143_PIN()  	GPIO_ReadPin(143)
#define GPIO_144_PIN()  	GPIO_ReadPin(144)
#define GPIO_145_PIN()  	GPIO_ReadPin(145)
#define GPIO_146_PIN()  	GPIO_ReadPin(146)
#define GPIO_147_PIN()  	GPIO_ReadPin(147)
#define GPIO_148_PIN()  	GPIO_ReadPin(148)
#define GPIO_149_PIN()  	GPIO_ReadPin(149)
#define GPIO_150_PIN()  	GPIO_ReadPin(150)
#define GPIO_151_PIN()  	GPIO_ReadPin(151)
#define GPIO_152_PIN()  	GPIO_ReadPin(152)
#define GPIO_153_PIN()  	GPIO_ReadPin(153)
#define GPIO_154_PIN()  	GPIO_ReadPin(154)
#define GPIO_155_PIN()  	GPIO_ReadPin(155)
#define GPIO_156_PIN()  	GPIO_ReadPin(156)
#define GPIO_157_PIN()  	GPIO_ReadPin(157)
#define GPIO_158_PIN()  	GPIO_ReadPin(158)
#define GPIO_159_PIN()  	GPIO_ReadPin(159)
#define GPIO_160_PIN()  	GPIO_ReadPin(160)
#define GPIO_161_PIN()  	GPIO_ReadPin(161)
#define GPIO_162_PIN()  	GPIO_ReadPin(162)
#define GPIO_163_PIN()  	GPIO_ReadPin(163)
#define GPIO_164_PIN()  	GPIO_ReadPin(164)
#define GPIO_165_PIN()  	GPIO_ReadPin(165)
#define GPIO_166_PIN()  	GPIO_ReadPin(166)
#define GPIO_167_PIN()  	GPIO_ReadPin(167)
#define GPIO_168_PIN()  	GPIO_ReadPin(168)
	
#define GPIO_0_SET()    	GPIO_WritePin(0,1)
#define GPIO_1_SET()    	GPIO_WritePin(1,1)
#define GPIO_2_SET()    	GPIO_WritePin(2,1)
#define GPIO_3_SET()    	GPIO_WritePin(3,1)
#define GPIO_4_SET()    	GPIO_WritePin(4,1)
#define GPIO_5_SET()    	GPIO_WritePin(5,1)
#define GPIO_6_SET()    	GPIO_WritePin(6,1)
#define GPIO_7_SET()    	GPIO_WritePin(7,1)
#define GPIO_8_SET()    	GPIO_WritePin(8,1)
#define GPIO_9_SET()    	GPIO_WritePin(9,1)
#define GPIO_10_SET()   	GPIO_WritePin(10,1)
#define GPIO_11_SET()   	GPIO_WritePin(11,1)
#define GPIO_12_SET()   	GPIO_WritePin(12,1)
#define GPIO_13_SET()   	GPIO_WritePin(13,1)
#define GPIO_14_SET()   	GPIO_WritePin(14,1)
#define GPIO_15_SET()   	GPIO_WritePin(15,1)
#define GPIO_16_SET()   	GPIO_WritePin(16,1)
#define GPIO_17_SET()   	GPIO_WritePin(17,1)
#define GPIO_18_SET()   	GPIO_WritePin(18,1)
#define GPIO_19_SET()   	GPIO_WritePin(19,1)
#define GPIO_20_SET()   	GPIO_WritePin(20,1)
#define GPIO_21_SET()   	GPIO_WritePin(21,1)
#define GPIO_22_SET()   	GPIO_WritePin(22,1)
#define GPIO_23_SET()   	GPIO_WritePin(23,1)
#define GPIO_24_SET()   	GPIO_WritePin(24,1)
#define GPIO_25_SET()   	GPIO_WritePin(25,1)
#define GPIO_26_SET()   	GPIO_WritePin(26,1)
#define GPIO_27_SET()   	GPIO_WritePin(27,1)
#define GPIO_28_SET()   	GPIO_WritePin(28,1)
#define GPIO_29_SET()   	GPIO_WritePin(29,1)
#define GPIO_30_SET()   	GPIO_WritePin(30,1)
#define GPIO_31_SET()   	GPIO_WritePin(31,1)
#define GPIO_32_SET()   	GPIO_WritePin(32,1)
#define GPIO_33_SET()   	GPIO_WritePin(33,1)
#define GPIO_34_SET()   	GPIO_WritePin(34,1)
#define GPIO_35_SET()   	GPIO_WritePin(35,1)
#define GPIO_36_SET()   	GPIO_WritePin(36,1)
#define GPIO_37_SET()   	GPIO_WritePin(37,1)
#define GPIO_38_SET()   	GPIO_WritePin(38,1)
#define GPIO_39_SET()   	GPIO_WritePin(39,1)
#define GPIO_40_SET()   	GPIO_WritePin(40,1)
#define GPIO_41_SET()   	GPIO_WritePin(41,1)
#define GPIO_42_SET()   	GPIO_WritePin(42,1)
#define GPIO_43_SET()   	GPIO_WritePin(43,1)
#define GPIO_44_SET()   	GPIO_WritePin(44,1)
#define GPIO_45_SET()   	GPIO_WritePin(45,1)
#define GPIO_46_SET()   	GPIO_WritePin(46,1)
#define GPIO_47_SET()   	GPIO_WritePin(47,1)
#define GPIO_48_SET()   	GPIO_WritePin(48,1)
#define GPIO_49_SET()   	GPIO_WritePin(49,1)
#define GPIO_50_SET()   	GPIO_WritePin(50,1)
#define GPIO_51_SET()   	GPIO_WritePin(51,1)
#define GPIO_52_SET()   	GPIO_WritePin(52,1)
#define GPIO_53_SET()   	GPIO_WritePin(53,1)
#define GPIO_54_SET()   	GPIO_WritePin(54,1)
#define GPIO_55_SET()   	GPIO_WritePin(55,1)
#define GPIO_56_SET()   	GPIO_WritePin(56,1)
#define GPIO_57_SET()   	GPIO_WritePin(57,1)
#define GPIO_58_SET()   	GPIO_WritePin(58,1)
#define GPIO_59_SET()   	GPIO_WritePin(59,1)
#define GPIO_60_SET()   	GPIO_WritePin(60,1)
#define GPIO_61_SET()   	GPIO_WritePin(61,1)
#define GPIO_62_SET()   	GPIO_WritePin(62,1)
#define GPIO_63_SET()   	GPIO_WritePin(63,1)
#define GPIO_64_SET()   	GPIO_WritePin(64,1)
#define GPIO_65_SET()   	GPIO_WritePin(65,1)
#define GPIO_66_SET()   	GPIO_WritePin(66,1)
#define GPIO_67_SET()   	GPIO_WritePin(67,1)
#define GPIO_68_SET()   	GPIO_WritePin(68,1)
#define GPIO_69_SET()   	GPIO_WritePin(69,1)
#define GPIO_70_SET()   	GPIO_WritePin(70,1)
#define GPIO_71_SET()   	GPIO_WritePin(71,1)
#define GPIO_72_SET()   	GPIO_WritePin(72,1)
#define GPIO_73_SET()   	GPIO_WritePin(73,1)
#define GPIO_74_SET()   	GPIO_WritePin(74,1)
#define GPIO_75_SET()   	GPIO_WritePin(75,1)
#define GPIO_76_SET()   	GPIO_WritePin(76,1)
#define GPIO_77_SET()   	GPIO_WritePin(77,1)
#define GPIO_78_SET()   	GPIO_WritePin(78,1)
#define GPIO_79_SET()   	GPIO_WritePin(79,1)
#define GPIO_80_SET()   	GPIO_WritePin(80,1)
#define GPIO_81_SET()   	GPIO_WritePin(81,1)
#define GPIO_82_SET()   	GPIO_WritePin(82,1)
#define GPIO_83_SET()   	GPIO_WritePin(83,1)
#define GPIO_84_SET()   	GPIO_WritePin(84,1)
#define GPIO_85_SET()   	GPIO_WritePin(85,1)
#define GPIO_86_SET()   	GPIO_WritePin(86,1)
#define GPIO_87_SET()   	GPIO_WritePin(87,1)
#define GPIO_88_SET()   	GPIO_WritePin(88,1)
#define GPIO_89_SET()   	GPIO_WritePin(89,1)
#define GPIO_90_SET()   	GPIO_WritePin(90,1)
#define GPIO_91_SET()   	GPIO_WritePin(91,1)
#define GPIO_92_SET()   	GPIO_WritePin(92,1)
#define GPIO_93_SET()   	GPIO_WritePin(93,1)
#define GPIO_94_SET()   	GPIO_WritePin(94,1)
#define GPIO_95_SET()   	GPIO_WritePin(95,1)
#define GPIO_96_SET()   	GPIO_WritePin(96,1)
#define GPIO_97_SET()   	GPIO_WritePin(97,1)
#define GPIO_98_SET()   	GPIO_WritePin(98,1)
#define GPIO_99_SET()   	GPIO_WritePin(99,1)
#define GPIO_100_SET()  	GPIO_WritePin(100,1)
#define GPIO_101_SET()  	GPIO_WritePin(101,1)
#define GPIO_102_SET()  	GPIO_WritePin(102,1)
#define GPIO_103_SET()  	GPIO_WritePin(103,1)
#define GPIO_104_SET()  	GPIO_WritePin(104,1)
#define GPIO_105_SET()  	GPIO_WritePin(105,1)
#define GPIO_106_SET()  	GPIO_WritePin(106,1)
#define GPIO_107_SET()  	GPIO_WritePin(107,1)
#define GPIO_108_SET()  	GPIO_WritePin(108,1)
#define GPIO_109_SET()  	GPIO_WritePin(109,1)
#define GPIO_110_SET()  	GPIO_WritePin(110,1)
#define GPIO_111_SET()  	GPIO_WritePin(111,1)
#define GPIO_112_SET()  	GPIO_WritePin(112,1)
#define GPIO_113_SET()  	GPIO_WritePin(113,1)
#define GPIO_114_SET()  	GPIO_WritePin(114,1)
#define GPIO_115_SET()  	GPIO_WritePin(115,1)
#define GPIO_116_SET()  	GPIO_WritePin(116,1)
#define GPIO_117_SET()  	GPIO_WritePin(117,1)
#define GPIO_118_SET()  	GPIO_WritePin(118,1)
#define GPIO_119_SET()  	GPIO_WritePin(119,1)
#define GPIO_120_SET()  	GPIO_WritePin(120,1)
#define GPIO_121_SET()  	GPIO_WritePin(121,1)
#define GPIO_122_SET()  	GPIO_WritePin(122,1)
#define GPIO_123_SET()  	GPIO_WritePin(123,1)
#define GPIO_124_SET()  	GPIO_WritePin(124,1)
#define GPIO_125_SET()  	GPIO_WritePin(125,1)
#define GPIO_126_SET()  	GPIO_WritePin(126,1)
#define GPIO_127_SET()  	GPIO_WritePin(127,1)
#define GPIO_128_SET()  	GPIO_WritePin(128,1)
#define GPIO_129_SET()  	GPIO_WritePin(129,1)
#define GPIO_130_SET()  	GPIO_WritePin(130,1)
#define GPIO_131_SET()  	GPIO_WritePin(131,1)
#define GPIO_132_SET()  	GPIO_WritePin(132,1)
#define GPIO_133_SET()  	GPIO_WritePin(133,1)
#define GPIO_134_SET()  	GPIO_WritePin(134,1)
#define GPIO_135_SET()  	GPIO_WritePin(135,1)
#define GPIO_136_SET()  	GPIO_WritePin(136,1)
#define GPIO_137_SET()  	GPIO_WritePin(137,1)
#define GPIO_138_SET()  	GPIO_WritePin(138,1)
#define GPIO_139_SET()  	GPIO_WritePin(139,1)
#define GPIO_140_SET()  	GPIO_WritePin(140,1)
#define GPIO_141_SET()  	GPIO_WritePin(141,1)
#define GPIO_142_SET()  	GPIO_WritePin(142,1)
#define GPIO_143_SET()  	GPIO_WritePin(143,1)
#define GPIO_144_SET()  	GPIO_WritePin(144,1)
#define GPIO_145_SET()  	GPIO_WritePin(145,1)
#define GPIO_146_SET()  	GPIO_WritePin(146,1)
#define GPIO_147_SET()  	GPIO_WritePin(147,1)
#define GPIO_148_SET()  	GPIO_WritePin(148,1)
#define GPIO_149_SET()  	GPIO_WritePin(149,1)
#define GPIO_150_SET()  	GPIO_WritePin(150,1)
#define GPIO_151_SET()  	GPIO_WritePin(151,1)
#define GPIO_152_SET()  	GPIO_WritePin(152,1)
#define GPIO_153_SET()  	GPIO_WritePin(153,1)
#define GPIO_154_SET()  	GPIO_WritePin(154,1)
#define GPIO_155_SET()  	GPIO_WritePin(155,1)
#define GPIO_156_SET()  	GPIO_WritePin(156,1)
#define GPIO_157_SET()  	GPIO_WritePin(157,1)
#define GPIO_158_SET()  	GPIO_WritePin(158,1)
#define GPIO_159_SET()  	GPIO_WritePin(159,1)
#define GPIO_160_SET()  	GPIO_WritePin(160,1)
#define GPIO_161_SET()  	GPIO_WritePin(161,1)
#define GPIO_162_SET()  	GPIO_WritePin(162,1)
#define GPIO_163_SET()  	GPIO_WritePin(163,1)
#define GPIO_164_SET()  	GPIO_WritePin(164,1)
#define GPIO_165_SET()  	GPIO_WritePin(165,1)
#define GPIO_166_SET()  	GPIO_WritePin(166,1)
#define GPIO_167_SET()  	GPIO_WritePin(167,1)
#define GPIO_168_SET()  	GPIO_WritePin(168,1)
	
#define GPIO_0_RESET()  	GPIO_WritePin(0,0)
#define GPIO_1_RESET()  	GPIO_WritePin(1,0)
#define GPIO_2_RESET()  	GPIO_WritePin(2,0)
#define GPIO_3_RESET()  	GPIO_WritePin(3,0)
#define GPIO_4_RESET()  	GPIO_WritePin(4,0)
#define GPIO_5_RESET()  	GPIO_WritePin(5,0)
#define GPIO_6_RESET()  	GPIO_WritePin(6,0)
#define GPIO_7_RESET()  	GPIO_WritePin(7,0)
#define GPIO_8_RESET()  	GPIO_WritePin(8,0)
#define GPIO_9_RESET()  	GPIO_WritePin(9,0)
#define GPIO_10_RESET() 	GPIO_WritePin(10,0)
#define GPIO_11_RESET() 	GPIO_WritePin(11,0)
#define GPIO_12_RESET() 	GPIO_WritePin(12,0)
#define GPIO_13_RESET() 	GPIO_WritePin(13,0)
#define GPIO_14_RESET() 	GPIO_WritePin(14,0)
#define GPIO_15_RESET() 	GPIO_WritePin(15,0)
#define GPIO_16_RESET() 	GPIO_WritePin(16,0)
#define GPIO_17_RESET() 	GPIO_WritePin(17,0)
#define GPIO_18_RESET() 	GPIO_WritePin(18,0)
#define GPIO_19_RESET() 	GPIO_WritePin(19,0)
#define GPIO_20_RESET() 	GPIO_WritePin(20,0)
#define GPIO_21_RESET() 	GPIO_WritePin(21,0)
#define GPIO_22_RESET() 	GPIO_WritePin(22,0)
#define GPIO_23_RESET() 	GPIO_WritePin(23,0)
#define GPIO_24_RESET() 	GPIO_WritePin(24,0)
#define GPIO_25_RESET() 	GPIO_WritePin(25,0)
#define GPIO_26_RESET() 	GPIO_WritePin(26,0)
#define GPIO_27_RESET() 	GPIO_WritePin(27,0)
#define GPIO_28_RESET() 	GPIO_WritePin(28,0)
#define GPIO_29_RESET() 	GPIO_WritePin(29,0)
#define GPIO_30_RESET() 	GPIO_WritePin(30,0)
#define GPIO_31_RESET() 	GPIO_WritePin(31,0)
#define GPIO_32_RESET() 	GPIO_WritePin(32,0)
#define GPIO_33_RESET() 	GPIO_WritePin(33,0)
#define GPIO_34_RESET() 	GPIO_WritePin(34,0)
#define GPIO_35_RESET() 	GPIO_WritePin(35,0)
#define GPIO_36_RESET() 	GPIO_WritePin(36,0)
#define GPIO_37_RESET() 	GPIO_WritePin(37,0)
#define GPIO_38_RESET() 	GPIO_WritePin(38,0)
#define GPIO_39_RESET() 	GPIO_WritePin(39,0)
#define GPIO_40_RESET() 	GPIO_WritePin(40,0)
#define GPIO_41_RESET() 	GPIO_WritePin(41,0)
#define GPIO_42_RESET() 	GPIO_WritePin(42,0)
#define GPIO_43_RESET() 	GPIO_WritePin(43,0)
#define GPIO_44_RESET() 	GPIO_WritePin(44,0)
#define GPIO_45_RESET() 	GPIO_WritePin(45,0)
#define GPIO_46_RESET() 	GPIO_WritePin(46,0)
#define GPIO_47_RESET() 	GPIO_WritePin(47,0)
#define GPIO_48_RESET() 	GPIO_WritePin(48,0)
#define GPIO_49_RESET() 	GPIO_WritePin(49,0)
#define GPIO_50_RESET() 	GPIO_WritePin(50,0)
#define GPIO_51_RESET() 	GPIO_WritePin(51,0)
#define GPIO_52_RESET() 	GPIO_WritePin(52,0)
#define GPIO_53_RESET() 	GPIO_WritePin(53,0)
#define GPIO_54_RESET() 	GPIO_WritePin(54,0)
#define GPIO_55_RESET() 	GPIO_WritePin(55,0)
#define GPIO_56_RESET() 	GPIO_WritePin(56,0)
#define GPIO_57_RESET() 	GPIO_WritePin(57,0)
#define GPIO_58_RESET() 	GPIO_WritePin(58,0)
#define GPIO_59_RESET() 	GPIO_WritePin(59,0)
#define GPIO_60_RESET() 	GPIO_WritePin(60,0)
#define GPIO_61_RESET() 	GPIO_WritePin(61,0)
#define GPIO_62_RESET() 	GPIO_WritePin(62,0)
#define GPIO_63_RESET() 	GPIO_WritePin(63,0)
#define GPIO_64_RESET() 	GPIO_WritePin(64,0)
#define GPIO_65_RESET() 	GPIO_WritePin(65,0)
#define GPIO_66_RESET() 	GPIO_WritePin(66,0)
#define GPIO_67_RESET() 	GPIO_WritePin(67,0)
#define GPIO_68_RESET() 	GPIO_WritePin(68,0)
#define GPIO_69_RESET() 	GPIO_WritePin(69,0)
#define GPIO_70_RESET() 	GPIO_WritePin(70,0)
#define GPIO_71_RESET() 	GPIO_WritePin(71,0)
#define GPIO_72_RESET() 	GPIO_WritePin(72,0)
#define GPIO_73_RESET() 	GPIO_WritePin(73,0)
#define GPIO_74_RESET() 	GPIO_WritePin(74,0)
#define GPIO_75_RESET() 	GPIO_WritePin(75,0)
#define GPIO_76_RESET() 	GPIO_WritePin(76,0)
#define GPIO_77_RESET() 	GPIO_WritePin(77,0)
#define GPIO_78_RESET() 	GPIO_WritePin(78,0)
#define GPIO_79_RESET() 	GPIO_WritePin(79,0)
#define GPIO_80_RESET() 	GPIO_WritePin(80,0)
#define GPIO_81_RESET() 	GPIO_WritePin(81,0)
#define GPIO_82_RESET() 	GPIO_WritePin(82,0)
#define GPIO_83_RESET() 	GPIO_WritePin(83,0)
#define GPIO_84_RESET() 	GPIO_WritePin(84,0)
#define GPIO_85_RESET() 	GPIO_WritePin(85,0)
#define GPIO_86_RESET() 	GPIO_WritePin(86,0)
#define GPIO_87_RESET() 	GPIO_WritePin(87,0)
#define GPIO_88_RESET() 	GPIO_WritePin(88,0)
#define GPIO_89_RESET() 	GPIO_WritePin(89,0)
#define GPIO_90_RESET() 	GPIO_WritePin(90,0)
#define GPIO_91_RESET() 	GPIO_WritePin(91,0)
#define GPIO_92_RESET() 	GPIO_WritePin(92,0)
#define GPIO_93_RESET() 	GPIO_WritePin(93,0)
#define GPIO_94_RESET() 	GPIO_WritePin(94,0)
#define GPIO_95_RESET() 	GPIO_WritePin(95,0)
#define GPIO_96_RESET() 	GPIO_WritePin(96,0)
#define GPIO_97_RESET() 	GPIO_WritePin(97,0)
#define GPIO_98_RESET() 	GPIO_WritePin(98,0)
#define GPIO_99_RESET() 	GPIO_WritePin(99,0)
#define GPIO_100_RESET()	GPIO_WritePin(100,0)
#define GPIO_101_RESET()	GPIO_WritePin(101,0)
#define GPIO_102_RESET()	GPIO_WritePin(102,0)
#define GPIO_103_RESET()	GPIO_WritePin(103,0)
#define GPIO_104_RESET()	GPIO_WritePin(104,0)
#define GPIO_105_RESET()	GPIO_WritePin(105,0)
#define GPIO_106_RESET()	GPIO_WritePin(106,0)
#define GPIO_107_RESET()	GPIO_WritePin(107,0)
#define GPIO_108_RESET()	GPIO_WritePin(108,0)
#define GPIO_109_RESET()	GPIO_WritePin(109,0)
#define GPIO_110_RESET()	GPIO_WritePin(110,0)
#define GPIO_111_RESET()	GPIO_WritePin(111,0)
#define GPIO_112_RESET()	GPIO_WritePin(112,0)
#define GPIO_113_RESET()	GPIO_WritePin(113,0)
#define GPIO_114_RESET()	GPIO_WritePin(114,0)
#define GPIO_115_RESET()	GPIO_WritePin(115,0)
#define GPIO_116_RESET()	GPIO_WritePin(116,0)
#define GPIO_117_RESET()	GPIO_WritePin(117,0)
#define GPIO_118_RESET()	GPIO_WritePin(118,0)
#define GPIO_119_RESET()	GPIO_WritePin(119,0)
#define GPIO_120_RESET()	GPIO_WritePin(120,0)
#define GPIO_121_RESET()	GPIO_WritePin(121,0)
#define GPIO_122_RESET()	GPIO_WritePin(122,0)
#define GPIO_123_RESET()	GPIO_WritePin(123,0)
#define GPIO_124_RESET()	GPIO_WritePin(124,0)
#define GPIO_125_RESET()	GPIO_WritePin(125,0)
#define GPIO_126_RESET()	GPIO_WritePin(126,0)
#define GPIO_127_RESET()	GPIO_WritePin(127,0)
#define GPIO_128_RESET()	GPIO_WritePin(128,0)
#define GPIO_129_RESET()	GPIO_WritePin(129,0)
#define GPIO_130_RESET()	GPIO_WritePin(130,0)
#define GPIO_131_RESET()	GPIO_WritePin(131,0)
#define GPIO_132_RESET()	GPIO_WritePin(132,0)
#define GPIO_133_RESET()	GPIO_WritePin(133,0)
#define GPIO_134_RESET()	GPIO_WritePin(134,0)
#define GPIO_135_RESET()	GPIO_WritePin(135,0)
#define GPIO_136_RESET()	GPIO_WritePin(136,0)
#define GPIO_137_RESET()	GPIO_WritePin(137,0)
#define GPIO_138_RESET()	GPIO_WritePin(138,0)
#define GPIO_139_RESET()	GPIO_WritePin(139,0)
#define GPIO_140_RESET()	GPIO_WritePin(140,0)
#define GPIO_141_RESET()	GPIO_WritePin(141,0)
#define GPIO_142_RESET()	GPIO_WritePin(142,0)
#define GPIO_143_RESET()	GPIO_WritePin(143,0)
#define GPIO_144_RESET()	GPIO_WritePin(144,0)
#define GPIO_145_RESET()	GPIO_WritePin(145,0)
#define GPIO_146_RESET()	GPIO_WritePin(146,0)
#define GPIO_147_RESET()	GPIO_WritePin(147,0)
#define GPIO_148_RESET()	GPIO_WritePin(148,0)
#define GPIO_149_RESET()	GPIO_WritePin(149,0)
#define GPIO_150_RESET()	GPIO_WritePin(150,0)
#define GPIO_151_RESET()	GPIO_WritePin(151,0)
#define GPIO_152_RESET()	GPIO_WritePin(152,0)
#define GPIO_153_RESET()	GPIO_WritePin(153,0)
#define GPIO_154_RESET()	GPIO_WritePin(154,0)
#define GPIO_155_RESET()	GPIO_WritePin(155,0)
#define GPIO_156_RESET()	GPIO_WritePin(156,0)
#define GPIO_157_RESET()	GPIO_WritePin(157,0)
#define GPIO_158_RESET()	GPIO_WritePin(158,0)
#define GPIO_159_RESET()	GPIO_WritePin(159,0)
#define GPIO_160_RESET()	GPIO_WritePin(160,0)
#define GPIO_161_RESET()	GPIO_WritePin(161,0)
#define GPIO_162_RESET()	GPIO_WritePin(162,0)
#define GPIO_163_RESET()	GPIO_WritePin(163,0)
#define GPIO_164_RESET()	GPIO_WritePin(164,0)
#define GPIO_165_RESET()	GPIO_WritePin(165,0)
#define GPIO_166_RESET()	GPIO_WritePin(166,0)
#define GPIO_167_RESET()	GPIO_WritePin(167,0)
#define GPIO_168_RESET()	GPIO_WritePin(168,0)
	 
#define GPIO_0_TOGGLE()		GPIO_TogglePin(0)
#define GPIO_1_TOGGLE()		GPIO_TogglePin(1)
#define GPIO_2_TOGGLE()		GPIO_TogglePin(2)
#define GPIO_3_TOGGLE()		GPIO_TogglePin(3)
#define GPIO_4_TOGGLE()		GPIO_TogglePin(4)
#define GPIO_5_TOGGLE()		GPIO_TogglePin(5)
#define GPIO_6_TOGGLE()		GPIO_TogglePin(6)
#define GPIO_7_TOGGLE()		GPIO_TogglePin(7)
#define GPIO_8_TOGGLE()		GPIO_TogglePin(8)
#define GPIO_9_TOGGLE()		GPIO_TogglePin(9)
#define GPIO_10_TOGGLE()	GPIO_TogglePin(10)
#define GPIO_11_TOGGLE()	GPIO_TogglePin(11)
#define GPIO_12_TOGGLE()	GPIO_TogglePin(12)
#define GPIO_13_TOGGLE()	GPIO_TogglePin(13)
#define GPIO_14_TOGGLE()	GPIO_TogglePin(14)
#define GPIO_15_TOGGLE()	GPIO_TogglePin(15)
#define GPIO_16_TOGGLE()	GPIO_TogglePin(16)
#define GPIO_17_TOGGLE()	GPIO_TogglePin(17)
#define GPIO_18_TOGGLE()	GPIO_TogglePin(18)
#define GPIO_19_TOGGLE()	GPIO_TogglePin(19)
#define GPIO_20_TOGGLE()	GPIO_TogglePin(20)
#define GPIO_21_TOGGLE()	GPIO_TogglePin(21)
#define GPIO_22_TOGGLE()	GPIO_TogglePin(22)
#define GPIO_23_TOGGLE()	GPIO_TogglePin(23)
#define GPIO_24_TOGGLE()	GPIO_TogglePin(24)
#define GPIO_25_TOGGLE()	GPIO_TogglePin(25)
#define GPIO_26_TOGGLE()	GPIO_TogglePin(26)
#define GPIO_27_TOGGLE()	GPIO_TogglePin(27)
#define GPIO_28_TOGGLE()	GPIO_TogglePin(28)
#define GPIO_29_TOGGLE()	GPIO_TogglePin(29)
#define GPIO_30_TOGGLE()	GPIO_TogglePin(30)
#define GPIO_31_TOGGLE()	GPIO_TogglePin(31)
#define GPIO_32_TOGGLE()	GPIO_TogglePin(32)
#define GPIO_33_TOGGLE()	GPIO_TogglePin(33)
#define GPIO_34_TOGGLE()	GPIO_TogglePin(34)
#define GPIO_35_TOGGLE()	GPIO_TogglePin(35)
#define GPIO_36_TOGGLE()	GPIO_TogglePin(36)
#define GPIO_37_TOGGLE()	GPIO_TogglePin(37)
#define GPIO_38_TOGGLE()	GPIO_TogglePin(38)
#define GPIO_39_TOGGLE()	GPIO_TogglePin(39)
#define GPIO_40_TOGGLE()	GPIO_TogglePin(40)
#define GPIO_41_TOGGLE()	GPIO_TogglePin(41)
#define GPIO_42_TOGGLE()	GPIO_TogglePin(42)
#define GPIO_43_TOGGLE()	GPIO_TogglePin(43)
#define GPIO_44_TOGGLE()	GPIO_TogglePin(44)
#define GPIO_45_TOGGLE()	GPIO_TogglePin(45)
#define GPIO_46_TOGGLE()	GPIO_TogglePin(46)
#define GPIO_47_TOGGLE()	GPIO_TogglePin(47)
#define GPIO_48_TOGGLE()	GPIO_TogglePin(48)
#define GPIO_49_TOGGLE()	GPIO_TogglePin(49)
#define GPIO_50_TOGGLE()	GPIO_TogglePin(50)
#define GPIO_51_TOGGLE()	GPIO_TogglePin(51)
#define GPIO_52_TOGGLE()	GPIO_TogglePin(52)
#define GPIO_53_TOGGLE()	GPIO_TogglePin(53)
#define GPIO_54_TOGGLE()	GPIO_TogglePin(54)
#define GPIO_55_TOGGLE()	GPIO_TogglePin(55)
#define GPIO_56_TOGGLE()	GPIO_TogglePin(56)
#define GPIO_57_TOGGLE()	GPIO_TogglePin(57)
#define GPIO_58_TOGGLE()	GPIO_TogglePin(58)
#define GPIO_59_TOGGLE()	GPIO_TogglePin(59)
#define GPIO_60_TOGGLE()	GPIO_TogglePin(60)
#define GPIO_61_TOGGLE()	GPIO_TogglePin(61)
#define GPIO_62_TOGGLE()	GPIO_TogglePin(62)
#define GPIO_63_TOGGLE()	GPIO_TogglePin(63)
#define GPIO_64_TOGGLE()	GPIO_TogglePin(64)
#define GPIO_65_TOGGLE()	GPIO_TogglePin(65)
#define GPIO_66_TOGGLE()	GPIO_TogglePin(66)
#define GPIO_67_TOGGLE()	GPIO_TogglePin(67)
#define GPIO_68_TOGGLE()	GPIO_TogglePin(68)
#define GPIO_69_TOGGLE()	GPIO_TogglePin(69)
#define GPIO_70_TOGGLE()	GPIO_TogglePin(70)
#define GPIO_71_TOGGLE()	GPIO_TogglePin(71)
#define GPIO_72_TOGGLE()	GPIO_TogglePin(72)
#define GPIO_73_TOGGLE()	GPIO_TogglePin(73)
#define GPIO_74_TOGGLE()	GPIO_TogglePin(74)
#define GPIO_75_TOGGLE()	GPIO_TogglePin(75)
#define GPIO_76_TOGGLE()	GPIO_TogglePin(76)
#define GPIO_77_TOGGLE()	GPIO_TogglePin(77)
#define GPIO_78_TOGGLE()	GPIO_TogglePin(78)
#define GPIO_79_TOGGLE()	GPIO_TogglePin(79)
#define GPIO_80_TOGGLE()	GPIO_TogglePin(80)
#define GPIO_81_TOGGLE()	GPIO_TogglePin(81)
#define GPIO_82_TOGGLE()	GPIO_TogglePin(82)
#define GPIO_83_TOGGLE()	GPIO_TogglePin(83)
#define GPIO_84_TOGGLE()	GPIO_TogglePin(84)
#define GPIO_85_TOGGLE()	GPIO_TogglePin(85)
#define GPIO_86_TOGGLE()	GPIO_TogglePin(86)
#define GPIO_87_TOGGLE()	GPIO_TogglePin(87)
#define GPIO_88_TOGGLE()	GPIO_TogglePin(88)
#define GPIO_89_TOGGLE()	GPIO_TogglePin(89)
#define GPIO_90_TOGGLE()	GPIO_TogglePin(90)
#define GPIO_91_TOGGLE()	GPIO_TogglePin(91)
#define GPIO_92_TOGGLE()	GPIO_TogglePin(92)
#define GPIO_93_TOGGLE()	GPIO_TogglePin(93)
#define GPIO_94_TOGGLE()	GPIO_TogglePin(94)
#define GPIO_95_TOGGLE()	GPIO_TogglePin(95)
#define GPIO_96_TOGGLE()	GPIO_TogglePin(96)
#define GPIO_97_TOGGLE()	GPIO_TogglePin(97)
#define GPIO_98_TOGGLE()	GPIO_TogglePin(98)
#define GPIO_99_TOGGLE()	GPIO_TogglePin(99)
#define GPIO_100_TOGGLE()	GPIO_TogglePin(100)
#define GPIO_101_TOGGLE()	GPIO_TogglePin(101)
#define GPIO_102_TOGGLE()	GPIO_TogglePin(102)
#define GPIO_103_TOGGLE()	GPIO_TogglePin(103)
#define GPIO_104_TOGGLE()	GPIO_TogglePin(104)
#define GPIO_105_TOGGLE()	GPIO_TogglePin(105)
#define GPIO_106_TOGGLE()	GPIO_TogglePin(106)
#define GPIO_107_TOGGLE()	GPIO_TogglePin(107)
#define GPIO_108_TOGGLE()	GPIO_TogglePin(108)
#define GPIO_109_TOGGLE()	GPIO_TogglePin(109)
#define GPIO_110_TOGGLE()	GPIO_TogglePin(110)
#define GPIO_111_TOGGLE()	GPIO_TogglePin(111)
#define GPIO_112_TOGGLE()	GPIO_TogglePin(112)
#define GPIO_113_TOGGLE()	GPIO_TogglePin(113)
#define GPIO_114_TOGGLE()	GPIO_TogglePin(114)
#define GPIO_115_TOGGLE()	GPIO_TogglePin(115)
#define GPIO_116_TOGGLE()	GPIO_TogglePin(116)
#define GPIO_117_TOGGLE()	GPIO_TogglePin(117)
#define GPIO_118_TOGGLE()	GPIO_TogglePin(118)
#define GPIO_119_TOGGLE()	GPIO_TogglePin(119)
#define GPIO_120_TOGGLE()	GPIO_TogglePin(120)
#define GPIO_121_TOGGLE()	GPIO_TogglePin(121)
#define GPIO_122_TOGGLE()	GPIO_TogglePin(122)
#define GPIO_123_TOGGLE()	GPIO_TogglePin(123)
#define GPIO_124_TOGGLE()	GPIO_TogglePin(124)
#define GPIO_125_TOGGLE()	GPIO_TogglePin(125)
#define GPIO_126_TOGGLE()	GPIO_TogglePin(126)
#define GPIO_127_TOGGLE()	GPIO_TogglePin(127)
#define GPIO_128_TOGGLE()	GPIO_TogglePin(128)
#define GPIO_129_TOGGLE()	GPIO_TogglePin(129)
#define GPIO_130_TOGGLE()	GPIO_TogglePin(130)
#define GPIO_131_TOGGLE()	GPIO_TogglePin(131)
#define GPIO_132_TOGGLE()	GPIO_TogglePin(132)
#define GPIO_133_TOGGLE()	GPIO_TogglePin(133)
#define GPIO_134_TOGGLE()	GPIO_TogglePin(134)
#define GPIO_135_TOGGLE()	GPIO_TogglePin(135)
#define GPIO_136_TOGGLE()	GPIO_TogglePin(136)
#define GPIO_137_TOGGLE()	GPIO_TogglePin(137)
#define GPIO_138_TOGGLE()	GPIO_TogglePin(138)
#define GPIO_139_TOGGLE()	GPIO_TogglePin(139)
#define GPIO_140_TOGGLE()	GPIO_TogglePin(140)
#define GPIO_141_TOGGLE()	GPIO_TogglePin(141)
#define GPIO_142_TOGGLE()	GPIO_TogglePin(142)
#define GPIO_143_TOGGLE()	GPIO_TogglePin(143)
#define GPIO_144_TOGGLE()	GPIO_TogglePin(144)
#define GPIO_145_TOGGLE()	GPIO_TogglePin(145)
#define GPIO_146_TOGGLE()	GPIO_TogglePin(146)
#define GPIO_147_TOGGLE()	GPIO_TogglePin(147)
#define GPIO_148_TOGGLE()	GPIO_TogglePin(148)
#define GPIO_149_TOGGLE()	GPIO_TogglePin(149)
#define GPIO_150_TOGGLE()	GPIO_TogglePin(150)
#define GPIO_151_TOGGLE()	GPIO_TogglePin(151)
#define GPIO_152_TOGGLE()	GPIO_TogglePin(152)
#define GPIO_153_TOGGLE()	GPIO_TogglePin(153)
#define GPIO_154_TOGGLE()	GPIO_TogglePin(154)
#define GPIO_155_TOGGLE()	GPIO_TogglePin(155)
#define GPIO_156_TOGGLE()	GPIO_TogglePin(156)
#define GPIO_157_TOGGLE()	GPIO_TogglePin(157)
#define GPIO_158_TOGGLE()	GPIO_TogglePin(158)
#define GPIO_159_TOGGLE()	GPIO_TogglePin(159)
#define GPIO_160_TOGGLE()	GPIO_TogglePin(160)
#define GPIO_161_TOGGLE()	GPIO_TogglePin(161)
#define GPIO_162_TOGGLE()	GPIO_TogglePin(162)
#define GPIO_163_TOGGLE()	GPIO_TogglePin(163)
#define GPIO_164_TOGGLE()	GPIO_TogglePin(164)
#define GPIO_165_TOGGLE()	GPIO_TogglePin(165)
#define GPIO_166_TOGGLE()	GPIO_TogglePin(166)
#define GPIO_167_TOGGLE()	GPIO_TogglePin(167)
#define GPIO_168_TOGGLE()	GPIO_TogglePin(168)

//_______________________________________________________Definizione nomi PINOUT

	// Enumerazioni specifiche per la SMD2204
	//_______________________________________________________________________DAC
    #define GPIO_NAMEDAC_OUT0               0   // DACOUTA
    #define GPIO_NAMEDAC_VTGDINP            1   // DACOUTB
    #define GPIO_NAMEDAC_NOTUSED            2   // DACOUTC

	//______________________________________________________________________ADCA
	//#define ANA_OUT1        				0   ///< Analog input A0 / Analog output DACOUTA
	//#define ANA_OUT_VTRG    				1   ///< Analog input A1 / Analog output Vtrg_dinp
	//#define PW_OFF          				2   ///< Analog input A2 / Compare register
	#define GPIO_NAMEADC_VBUS24				2   // ADCINA2 (VBUS24V)
	#define GPIO_NAMEADC_IA1   				3   // ADCINA3 (SENSE_A_1)
	#define GPIO_NAMEADC_IA2   				4   // ADCINA4 (SENSE_A_2)
	//#define VFREE2          				5	// ADCINA5
	
	//______________________________________________________________________ADCB
	#define GPIO_NAMEADC_IB1     			0 	// ADCINB0 (SENSE_B_1)
	#define GPIO_NAMEADC_IB2     			1   // ADCINB1 (SENSE_B_2)
	#define GPIO_NAMEADC_VSENS     			2   // ADCINB2 (VSENS)
	#define GPIO_NAMEADC_IBUS1    			3   // ADCINB3 (IBUS_HV_1)
	#define GPIO_NAMEADC_IBUS2    			4   // ADCINB4 (IBUS_HV_2)
	#define GPIO_NAMEADC_IBUS3    			5   // ADCINB5 (IBUS_HV_3)
	
	//______________________________________________________________________ADCC
	//#define SHORT_CIRC3     				2	///< Analog input C2 / Compare register
	#define GPIO_NAMEADC_IA3     			3 	// ADCINC3 (SENSE_A_3)
	//#define SHORT_CIRC2     				4   ///< Analog input C4 / Compare register
	#define GPIO_NAMEADC_IB3     			5   // ADCINC5 (SENSE_B_3)
	
	//______________________________________________________________________ADCD
	#define GPIO_NAMEADC_VTH       			0	// ADCIND0 (VTH)
	#define GPIO_NAMEADC_VBUS_HV1  			1   // ADCIND1 (VBUS_HV1)
	#define GPIO_NAMEADC_VBUS_HV3  			2   // ADCIND2 (VBUS_HV3)
	#define GPIO_NAMEADC_VANA1     			3   // ADCIND3 (VANA_0)
	#define GPIO_NAMEADC_VANA2     			4   // ADCIND4 (VANA_1)
	#define GPIO_NAMEADC_VANA3     			5   // ADCIND5 (VANA_2)
	
	//_______________________________________________________________________ENCODER
	#define GPIO_NAMEIO_TOPENC1				81	// EQEPI (Top encoder externo)
	#define GPIO_NAMEIO_TOPENC2				23	// EQEPI (Top encoder externo)
	#define GPIO_NAMEIO_TOPENC3				31	// EQEPI (Top encoder externo)
	
	#define GPIO_NAMEADC_VBUS_HV2  			15  // ADCIN15 (VUBUS_HV2)

	//_______________________________________________________________________I/O
	#define GPIO_NAMEIO_VANA1OFF   			69	// VANA_1_OFF
	#define GPIO_NAMEIO_VANA2OFF   			70  // VANA_2_OFF
	#define GPIO_NAMEIO_VANA3OFF   			71  // VANA_3_OFF

	#define GPIO_NAMEIO_BOOTMAIN			123
	
	//_______________________________________________________________________LED
	#define GPIO_NAMEIO_FLD1_LED_GREEN		92
	#define GPIO_NAMEIO_FLD1_LED_RED		93
	#define GPIO_NAMEIO_FLD2_LED_GREEN		94
	#define GPIO_NAMEIO_FLD2_LED_RED		95
	#define GPIO_NAMEIO_FLD_LED_YEL			83
	#define GPIO_NAMEIO_LED_GRN_1			113
	#define GPIO_NAMEIO_LED_RED_1			114
	#define GPIO_NAMEIO_LED_GRN_2			117
	#define GPIO_NAMEIO_LED_RED_2			118
	#define GPIO_NAMEIO_LED_YEL				119

#if (AECDEVICE_COM_DEVICE == AECDEVICE_COM_DEVICE_VPC3)
    #define GPIO_IO_VPC3_RESET_ON()
    #define GPIO_IO_VPC3_RESET_OFF()
#endif

	#define GPIO_IO_LED_FLD1GREEN_ON()		GPIO_WritePin(	GPIO_NAMEIO_FLD1_LED_GREEN,	0)
	#define GPIO_IO_LED_FLD1GREEN_OFF()		GPIO_WritePin(	GPIO_NAMEIO_FLD1_LED_GREEN,	1)
	#define GPIO_IO_LED_FLD1RED_ON()		GPIO_WritePin(	GPIO_NAMEIO_FLD1_LED_RED,	0)
	#define GPIO_IO_LED_FLD1RED_OFF()		GPIO_WritePin(	GPIO_NAMEIO_FLD1_LED_RED,	1)
	#define GPIO_IO_LED_FLD2GREEN_ON()		GPIO_WritePin(	GPIO_NAMEIO_FLD2_LED_GREEN,	0)
	#define GPIO_IO_LED_FLD2GREEN_OFF()		GPIO_WritePin(	GPIO_NAMEIO_FLD2_LED_GREEN,	1)
	#define GPIO_IO_LED_FLD2RED_ON()		GPIO_WritePin(	GPIO_NAMEIO_FLD2_LED_RED,	0)
	#define GPIO_IO_LED_FLD2RED_OFF()		GPIO_WritePin(	GPIO_NAMEIO_FLD2_LED_RED,	1)
	#define GPIO_IO_LED_FLDYELLOW_ON()  	GPIO_WritePin(	GPIO_NAMEIO_FLD_LED_YEL,	0)
	#define GPIO_IO_LED_FLDYELLOW_OFF()  	GPIO_WritePin(	GPIO_NAMEIO_FLD_LED_YEL,	1)

	//_______________________________________________________________________INGRESSI
	#define GPIO_NAMEIO_DIGI00				128
	#define GPIO_NAMEIO_DIGI01				129
	#define GPIO_NAMEIO_DIGI02				130
	#define GPIO_NAMEIO_DIGI03				131
	#define GPIO_NAMEIO_DIGI04				132
	#define GPIO_NAMEIO_DIGI05				133
	#define GPIO_NAMEIO_DIGI06				134
	#define GPIO_NAMEIO_DIGI07				135
	#define GPIO_NAMEIO_DIGI08				136


	//_______________________________________________________________________USCITE
	#define GPIO_NAMEIO_RS485TXE			90
	#define GPIO_NAMEIO_SSIPRESET			109
	#define GPIO_NAMEIO_SSIDIRECTION		24

    #define GPIO_NAMEIO_ENDATDATAOUT        24
    #define GPIO_NAMEIO_ENDATDATAIN         25
    #define GPIO_NAMEIO_ENDATDIRECTION      34

	#define GPIO_IO_FUNCTION_1_GET()		1
	#define GPIO_IO_FUNCTION_2_GET()		1
	#define GPIO_IO_FUNCTION_3_GET()		1

	//_______________________________________________________________________USCITE CON INTEGRATO ISO8200BQ
	#define GPIO_NAMEIO_DIGOUT0				3
	#define GPIO_NAMEIO_DIGOUT1				8
	#define GPIO_NAMEIO_DIGOUT2				9
	#define GPIO_NAMEIO_DIGOUT3				10
	#define GPIO_NAMEIO_DIGOUT4				11
	#define GPIO_NAMEIO_DIGOUT5				15
	#define GPIO_NAMEIO_DIGOUT6				16
	#define GPIO_NAMEIO_DIGOUT7				17

	#define GPIO_NAMEIO_DIGOOUT_FAULT		18
	#define GPIO_NAMEIO_DIGOOUT_EN			19

	//_______________________________________________________________________I/O
	#define GPIO_NAMEIO_NIRQEXP				122
	
	#define GPIO_NAMEIO_XA10				106
	#define GPIO_NAMEIO_XA11				107
	#define GPIO_NAMEIO_XA12				108
	
	#define GPIO_NAMEIO_TOPENCMOT1			81
	#define GPIO_NAMEIO_TOPENCMOT2			23
	#define GPIO_NAMEIO_TOPENCMOT3			31
	
	#define GPIO_NAMEIO_ASSE1CURON			127	// CUR_ON_1
	#define GPIO_NAMEIO_ASSE2CURON			75	// CUR_ON_2 (Usato sse multiasse)
	#define GPIO_NAMEIO_ASSE3CURON			73	// CUR_ON_3 (Usato sse multiasse)
												//
	#define GPIO_NAMEIO_ASSE1CURRED			126 // CUR_RED_1
	#define GPIO_NAMEIO_ASSE2CURRED			76 	// CUR_RED_2 (Usato sse multiasse)
	#define GPIO_NAMEIO_ASSE3CURRED			74	// CUR_RED_3 (Usato sse multiasse)
												//
	#define GPIO_NAMEIO_ASSE1DRIVEOK		125 // DRIVEOK_1
	#define GPIO_NAMEIO_ASSE2DRIVEOK		87 	// DRIVEOK_2 (Usato sse multiasse)
	#define GPIO_NAMEIO_ASSE3DRIVEOK		89	// DRIVEOK_3 (Usato sse multiasse)

	#define GPIO_NAMEIO_ASSE1ALARM			124
	#define GPIO_NAMEIO_ASSE2ALARM			86
	#define GPIO_NAMEIO_ASSE3ALARM			88
	
	#define GPIO_NAMEIO_FUNCTION_1			12
	#define GPIO_NAMEIO_FUNCTION_2			13
	#define GPIO_NAMEIO_FUNCTION_3			14
	
	#define GPIO_NAMEIO_DIGOUTENABLE		15
	
	#define GPIO_NAMEIO_DIPSWSEL			48
	
	#define GPIO_NAMEIO_DIGOUTFUNC5  		8   // Uscite dirette con vecchio integrato gestione uscite
	#define GPIO_NAMEIO_DIGOUTFUNC6 		9   // Uscite dirette con vecchio integrato gestione uscite
	#define GPIO_NAMEIO_DIGOUTFUNC7 		10  // Uscite dirette con vecchio integrato gestione uscite
	#define GPIO_NAMEIO_DIGOUTFUNC8 		11  // Uscite dirette con vecchio integrato gestione uscite

	#define GPIO_NAMEIO_EXPIO1				90
	#define GPIO_NAMEIO_EXPIO2				91
	#define GPIO_NAMEIO_EXPIO3				96
	#define GPIO_NAMEIO_EXPIO4				97
	
	#define GPIO_IO_VANA1_DISABLE()     	GPIO_WritePin(	GPIO_NAMEIO_VANA1OFF,		1)
	#define GPIO_IO_VANA1_ENABLE()   		GPIO_WritePin(	GPIO_NAMEIO_VANA1OFF,		0)
	#define GPIO_IO_VANA2_DISABLE()     	GPIO_WritePin(	GPIO_NAMEIO_VANA2OFF,		1)
	#define GPIO_IO_VANA2_ENABLE()   		GPIO_WritePin(	GPIO_NAMEIO_VANA2OFF,		0)
	#define GPIO_IO_VANA3_DISABLE()     	GPIO_WritePin(	GPIO_NAMEIO_VANA3OFF,		1)
	#define GPIO_IO_VANA3_ENABLE()   		GPIO_WritePin(	GPIO_NAMEIO_VANA3OFF,		0)

	#define GPIO_IO_ASSE1CURON_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1CURON,		0)
	#define GPIO_IO_ASSE1CURON_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1CURON,		1)
	#define GPIO_IO_ASSE1CURON_TOGGLE()		GPIO_TogglePin(	GPIO_NAMEIO_ASSE1CURON		)
	#define GPIO_IO_ASSE2CURON_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2CURON,		0)
	#define GPIO_IO_ASSE2CURON_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2CURON,		1)
	#define GPIO_IO_ASSE2CURON_TOGGLE()		GPIO_TogglePin(	GPIO_NAMEIO_ASSE2CURON		)
	#define GPIO_IO_ASSE3CURON_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3CURON,		0)
	#define GPIO_IO_ASSE3CURON_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3CURON,		1)
	#define GPIO_IO_ASSE3CURON_TOGGLE()		GPIO_TogglePin(	GPIO_NAMEIO_ASSE3CURON		)
	
	#define GPIO_IO_ASSE1CURRED_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1CURRED,	0)
	#define GPIO_IO_ASSE1CURRED_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1CURRED,	1)
	#define GPIO_IO_ASSE1CURRED_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE1CURRED		)
	#define GPIO_IO_ASSE2CURRED_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2CURRED,	0)
	#define GPIO_IO_ASSE2CURRED_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2CURRED,	1)
	#define GPIO_IO_ASSE2CURRED_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE2CURRED		)
	#define GPIO_IO_ASSE3CURRED_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3CURRED,	0)
	#define GPIO_IO_ASSE3CURRED_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3CURRED,	1)
	#define GPIO_IO_ASSE3CURRED_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE3CURRED		)

	#define GPIO_IO_ASSE1DRIVEOK_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1DRIVEOK,	0)
	#define GPIO_IO_ASSE1DRIVEOK_RESET()	GPIO_WritePin(	GPIO_NAMEIO_ASSE1DRIVEOK,	1)
	#define GPIO_IO_ASSE1DRIVEOK_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE1DRIVEOK	)
	#define GPIO_IO_ASSE2DRIVEOK_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2DRIVEOK,	0)
	#define GPIO_IO_ASSE2DRIVEOK_RESET()	GPIO_WritePin(	GPIO_NAMEIO_ASSE2DRIVEOK,	1)
	#define GPIO_IO_ASSE2DRIVEOK_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE2DRIVEOK	)
	#define GPIO_IO_ASSE3DRIVEOK_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3DRIVEOK,	0)
	#define GPIO_IO_ASSE3DRIVEOK_RESET()	GPIO_WritePin(	GPIO_NAMEIO_ASSE3DRIVEOK,	1)
	#define GPIO_IO_ASSE3DRIVEOK_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_ASSE3DRIVEOK	)

	#define GPIO_IO_ASSE1ALARM_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1ALARM,		0)
	#define GPIO_IO_ASSE1ALARM_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE1ALARM,		1)
	#define GPIO_IO_ASSE2ALARM_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2ALARM,		0)
	#define GPIO_IO_ASSE2ALARM_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE2ALARM,		1)
	#define GPIO_IO_ASSE3ALARM_SET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3ALARM,		0)
	#define GPIO_IO_ASSE3ALARM_RESET()		GPIO_WritePin(	GPIO_NAMEIO_ASSE3ALARM,		1)

	#define GPIO_IO_RS485TXE_SET()			GPIO_WritePin(	GPIO_NAMEIO_RS485TXE,		1)
	#define GPIO_IO_RS485TXE_RESET()		GPIO_WritePin(	GPIO_NAMEIO_RS485TXE,		0)

	#define GPIO_IO_LEDGRN1_GET()			GPIO_ReadPin(	GPIO_NAMEIO_LED_GRN_1   	 )
	#define GPIO_IO_LEDRED1_GET()			GPIO_ReadPin(	GPIO_NAMEIO_LED_RED_1   	 )
	#define GPIO_IO_LEDGRN2_GET()			GPIO_ReadPin(	GPIO_NAMEIO_LED_GRN_2   	 )
	#define GPIO_IO_LEDRED2_GET()			GPIO_ReadPin(	GPIO_NAMEIO_LED_RED_2   	 )
	#define GPIO_IO_LEDYEL_GET()			GPIO_ReadPin(	GPIO_NAMEIO_LED_YEL     	 )

	#define GPIO_IO_DIGOUTENABLE_SET()		GPIO_WritePin(	GPIO_NAMEIO_DIGOUTENABLE,	1)
	#define GPIO_IO_DIGOUTENABLE_RESET()	GPIO_WritePin(	GPIO_NAMEIO_DIGOUTENABLE,	0)
	
	#define GPIO_IO_DIPSWSEL_SET()			GPIO_WritePin(	GPIO_NAMEIO_DIPSWSEL,		1)
	#define GPIO_IO_DIPSWSEL_RESET()		GPIO_WritePin(	GPIO_NAMEIO_DIPSWSEL,		0)

	#define GPIO_IO_NIRQEXP_GET() 			GPIO_ReadPin(	GPIO_NAMEIO_NIRQEXP 		 )

#if AECDEVICE_TESTTEMPIESECUZIONE
	#define GPIO_IO_DIGOUTFUNC5_FORCE()		GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC5,	1)
	#define GPIO_IO_DIGOUTFUNC5_UNFORCE()  	GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC5,	0)
	#define GPIO_IO_DIGOUTFUNC5_TOGGLE()   	GPIO_TogglePin(	GPIO_NAMEIO_DIGOUTFUNC5		 )
	#define GPIO_IO_DIGOUTFUNC6_FORCE()		GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC6,	1)
	#define GPIO_IO_DIGOUTFUNC6_UNFORCE()	GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC6,	0)
	#define GPIO_IO_DIGOUTFUNC6_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_DIGOUTFUNC6		 )
	#define GPIO_IO_DIGOUTFUNC7_FORCE()		GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC7,	1)
	#define GPIO_IO_DIGOUTFUNC7_UNFORCE()	GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC7,	0)
	#define GPIO_IO_DIGOUTFUNC7_TOGGLE()	GPIO_TogglePin(	GPIO_NAMEIO_DIGOUTFUNC7		 )
	#define GPIO_IO_DIGOUTFUNC8_FORCE()		GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC8,	1)
	#define GPIO_IO_DIGOUTFUNC8_UNFORCE()	GPIO_WritePin(	GPIO_NAMEIO_DIGOUTFUNC8,	0)
	#define GPIO_IO_DIGOUTFUNC8_TOGGLE()    GPIO_TogglePin(	GPIO_NAMEIO_DIGOUTFUNC8		 )
#else
	#define GPIO_IO_DIGOUTFUNC5_FORCE()		;
	#define GPIO_IO_DIGOUTFUNC5_UNFORCE()  	;
	#define GPIO_IO_DIGOUTFUNC5_TOGGLE()   	;
	#define GPIO_IO_DIGOUTFUNC6_FORCE()		;
	#define GPIO_IO_DIGOUTFUNC6_UNFORCE()	;
	#define GPIO_IO_DIGOUTFUNC6_TOGGLE()	;
	#define GPIO_IO_DIGOUTFUNC7_FORCE()		;
	#define GPIO_IO_DIGOUTFUNC7_UNFORCE()	;
	#define GPIO_IO_DIGOUTFUNC7_TOGGLE()	;
	#define GPIO_IO_DIGOUTFUNC8_FORCE()		;
	#define GPIO_IO_DIGOUTFUNC8_UNFORCE()	;
	#define GPIO_IO_DIGOUTFUNC8_TOGGLE()	;
#endif

	#define GPIO_IO_EXPIO2_GET()			GPIO_ReadPin (	GPIO_NAMEIO_EXPIO2 			 )
	#define GPIO_IO_EXPIO4_SET()			GPIO_WritePin(	GPIO_NAMEIO_EXPIO4,			1)
	#define GPIO_IO_EXPIO4_RESET()			GPIO_WritePin(	GPIO_NAMEIO_EXPIO4,			0)
		
	#define GPIO_IO_BOOTMAIN_SET()			GPIO_WritePin(	GPIO_NAMEIO_BOOTMAIN,		0)
	#define GPIO_IO_BOOTMAIN_RESET()		GPIO_WritePin(	GPIO_NAMEIO_BOOTMAIN,		1)

	#define GPIO_IO_TOPENC1GET()			GPIO_ReadPin (	GPIO_NAMEIO_TOPENC1		     )
	#define GPIO_IO_TOPENC2GET()			GPIO_ReadPin (	GPIO_NAMEIO_TOPENC2		     )
	#define GPIO_IO_TOPENC3GET()			GPIO_ReadPin (	GPIO_NAMEIO_TOPENC3		     )

	#define GPIO_IO_SSIPRESET_SET() 		GPIO_WritePin(	GPIO_NAMEIO_SSIPRESET,		1)
	#define GPIO_IO_SSIPRESET_RESET() 		GPIO_WritePin(	GPIO_NAMEIO_SSIPRESET,		0)

	#define GPIO_IO_SSIDIRECTION_SET() 		GPIO_WritePin(	GPIO_NAMEIO_SSIDIRECTION,	1)
	#define GPIO_IO_SSIDIRECTION_RESET() 	GPIO_WritePin(	GPIO_NAMEIO_SSIDIRECTION,	0)

    #define GPIO_IO_ENDATDIRECTION_SET()    GPIO_WritePin(  GPIO_NAMEIO_ENDATDIRECTION, 1)
    #define GPIO_IO_ENDATDIRECTION_RESET()  GPIO_WritePin(  GPIO_NAMEIO_ENDATDIRECTION, 0)
    #define GPIO_IO_ENDATDIRECTION_GET()    GPIO_ReadPin (  GPIO_NAMEIO_ENDATDIRECTION   )

    #define GPIO_IO_ENDATDATAOUT_SET()      GPIO_WritePin(  GPIO_NAMEIO_ENDATDATAOUT,   1)
    #define GPIO_IO_ENDATDATAOUT_RESET()    GPIO_WritePin(  GPIO_NAMEIO_ENDATDATAOUT,   0)
    #define GPIO_IO_ENDATDATAOUT_GET()      GPIO_ReadPin (  GPIO_NAMEIO_ENDATDATAOUT     )

    #define GPIO_IO_ENDATDATAIN_SET()       GPIO_WritePin(  GPIO_NAMEIO_ENDATDATAIN,    1)
    #define GPIO_IO_ENDATDATAIN_RESET()     GPIO_WritePin(  GPIO_NAMEIO_ENDATDATAIN,    0)
    #define GPIO_IO_ENDATDATAIN_GET()       GPIO_ReadPin (  GPIO_NAMEIO_ENDATDATAIN      )

	#define	GPIO_IO_STO_ENABLE				0
	#define	GPIO_IO_STO_OUT					0
	#define	GPIO_IO_STO_A_FB				0
	#define	GPIO_IO_STO_B_FB				0
	#define	GPIO_IO_STO_A_CHECK				0
	#define	GPIO_IO_STO_B_CHECK_V8			0
	#define	GPIO_IO_STO_B_CHECK				0

    #define BIT_INPUT_STO_A                 0
    #define BIT_INPUT_STO_B                 0

	#define GPIO_IO_STO_ENABLE_GET()		GPIO_ReadPin(	GPIO_IO_STO_ENABLE 			)

	#define GPIO_IO_STO_A_FB_GET()			GPIO_ReadPin(	GPIO_IO_STO_A_FB 			)
	#define GPIO_IO_STO_B_FB_GET()			GPIO_ReadPin(	GPIO_IO_STO_B_FB 			)

	#define GPIO_IO_STO_OUT_GET()			GPIO_ReadPin(	GPIO_IO_STO_OUT 			)		// Lettura del pin fisico non del latch
	#define GPIO_IO_STO_OUT_SET()			GPIO_WritePin(	GPIO_IO_STO_OUT,			1)
	#define GPIO_IO_STO_OUT_RESET() 		GPIO_WritePin(	GPIO_IO_STO_OUT,			0)

	#define GPIO_IO_STO_A_CHECK_GET()		GPIO_ReadPin(	GPIO_IO_STO_A_CHECK			)
	#define GPIO_IO_STO_A_CHECK_SET()		GPIO_WritePin(	GPIO_IO_STO_A_CHECK,		1)
	#define GPIO_IO_STO_A_CHECK_RESET()		GPIO_WritePin(	GPIO_IO_STO_A_CHECK,		0)

	#define GPIO_IO_STO_B_CHECK_GET()		GPIO_ReadPin(	GPIO_IO_STO_B_CHECK			)
	#define GPIO_IO_STO_B_CHECK_SET()		GPIO_WritePin(	GPIO_IO_STO_B_CHECK,		1)
	#define GPIO_IO_STO_B_CHECK_RESET()		GPIO_WritePin(	GPIO_IO_STO_B_CHECK,		0)
	#define GPIO_IO_STO_B_CHECK_V8_SET()	GPIO_WritePin(	GPIO_IO_STO_B_CHECK_V8,		1)		// Per schede SMD1204 V8
	#define GPIO_IO_STO_B_CHECK_V8_RESET()	GPIO_WritePin(	GPIO_IO_STO_B_CHECK_V8,		0)		// Per schede SMD1204 V8

//-----------------------------------------------------------------------------

void setupdspgpio_InitModule(void);

#endif  // SETUPDSPGPIO_SMD2204_H_INCLUDED

/*===================================================================================*/

