/****************************************************************************
 *                                                                          *
 *                                                                          *
 *   File            :   SetupDspSpi.c                                      *
 *   Project         :   Foc Stepper                                        *
 *   Compiler        :   Code Composer Studio Texas Instruments             *
 *                                                                          *
 *   Function        :   Spi initializations                                *
 *                                                                          *
 *                                                                          *
 *   Vers.   Data   Programmer    Description                               *
 *   1.00  27/06/16 Z.G.          Prima versione                            *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

/*--------------------------------------------------------------------------*/
/*                       I N C L U D E S                                    */
/*--------------------------------------------------------------------------*/
#include "../../Source/AEC_Device.h"
#include "../../Source/src_cpu/DefineTypedef.h"
#include "F28x_Project.h"               // DSP320F28x Headerfile Include File

#include "../../Source/main.h"
#include "../../Source/src_board/DefineSw.h"
#include "../../Source/src_database/Variables.h"

#include "SetupDspSpi.h"                // SetupDspSpi definition file

/*----------------------------------------------------------------------------*/
/*          EXTERNAL FUNCTIONS                                                */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*          STATIC FUNCTIONS                                                  */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/*             T A B L E S                                                    */
/*----------------------------------------------------------------------------*/

/*******************************************************************************
*
*   Function:     spia_init
*
*   Description:  This function initializes the Spia modules
*
*   Parameter:    none
*
*   Return Value: none
*
*********************************************************************************/
void spia_init(void)
{
}

/*******************************************************************************
*
*   Function:     spia_xmit
*
*   Description:  This function send data to the spia
*
*   Parameter:    Uint16 Data
*
*   Return Value: none
*
*********************************************************************************/
void spia_xmit(Uint16 a)
{
}

/*******************************************************************************
*
*   Function:     spia_receive
*
*   Description:  This function read received data from fifo
*
*   Parameter:    none
*
*   Return Value: Uint16 Data
*
*********************************************************************************/
Uint32 spia_receive(void)
{
    return(0);
}

//===========================================================================
// End of file.
//===========================================================================
