//#############################################################################
//
// FILE:    F2837x_FLASH_lnk.cmd
//
//#############################################################################
// $TI Release: MotorControl SDK v3.00.01.00 $
// $Release Date: Tue May 26 19:13:59 CDT 2020 $
// $Copyright:
// Copyright (C) 2017-2020 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
//   Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################
// 1. In addition to this memory linker command file, add the header linker 
//    command file directly to the project. The header linker command file is 
//    required to link the peripheral structures to the proper locations within
//    the memory map.
//    
//    The header linker files are found in 
//    controlSUITE\device_support\f2837x\F2837x_headers\cmd
//    
//    For BIOS applications add:      F2837x_Headers_BIOS_cpuX.cmd
//    For nonBIOS applications add:   F2837x_Headers_nonBIOS_cpuX.cmd
//
// 2. On reset all RAMGSx blocks are under the mastership of CPU1. The user
//     must configure the appropriate control registers to transfer mastership
//     of a RAMGSx block over to CPU2
//
// 3. Memory blocks on F2837x are uniform (ie same physical memory) in both 
//    PAGE 0 and PAGE 1. That is the same memory region should not be defined 
//    for both PAGE 0 and PAGE 1. Doing so will result in corruption of program
//    and/or data.
//    
//    Contiguous SARAM memory blocks can be combined if required to create a 
//    larger memory block.
//
//#############################################################################

--define=FLASH=1

// The user may define CLA_C in the project linker settings if using the
// CLA C compiler,
//   Project Properties -> C2000 Linker -> Advanced Options -> Command File
//   Preprocessing -> --define
// or here in the linker file as shown below. If writing CLA code in assembly
// only set the value to 0 (or comment it) as the user is not required to use
// the compiler specific sections
--define=CLA_C=1

// Set this variable to 1 to use the CLA Math Tables in the CLA Data ROM
// If set to 0, make sure the right CLA Math library (one without the _datarom
// suffix) is used in the project
--define=CLA_MATH_TABLES_IN_ROM=1

#if CLA_C
// Define a size for the CLA scratchpad area that will be used
// by the CLA compiler for local symbols and temps
// Also force references to the special symbols that mark the
// scratchpad are.
CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start
#endif //CLA_C

MEMORY
{
PAGE 0 :
		/* Program Memory */
		/* Memory (RAM/FLASH) blocks can be moved to PAGE1 for data allocation */
		/* BEGIN is used for the "boot to Flash" bootloader mode   */

		BEGIN		: origin = 0x080000, length = 0x000002

		RAMM0		: origin = 0x000122, length = 0x0002DE
//		RAMM0		: origin = 0x000002, length = 0x0003FE
//		RAMM1		: origin = 0x000400, length = 0x000400

		RAMLS03		: origin = 0x008000, length = 0x002000		/* CLA Program Sect */
//		RAMLS0		: origin = 0x008000, length = 0x000800
//		RAMLS1		: origin = 0x008800, length = 0x000800
//		RAMLS2		: origin = 0x009000, length = 0x000800
// 		RAMLS3		: origin = 0x009800, length = 0x000800
//		RAMLS4		: origin = 0x00A000, length = 0x000800
		RAMLS5GS1	: origin = 0x00A800, length = 0x003800		/* Program Code on RAM */
//		RAMLS5		: origin = 0x00A800, length = 0x000800

//		RAMD0		: origin = 0x00B000, length = 0x000800
//		RAMD1		: origin = 0x00B800, length = 0x000800

//		RAMGS0		: origin = 0x00C000, length = 0x001000
//		RAMGS1		: origin = 0x00D000, length = 0x001000
//		RAMGS2		: origin = 0x00E000, length = 0x001000
//		RAMGS3		: origin = 0x00F000, length = 0x001000
//		RAMGS4		: origin = 0x010000, length = 0x001000
//		RAMGS5		: origin = 0x011000, length = 0x001000
//		RAMGS6		: origin = 0x012000, length = 0x001000
//		RAMGS7		: origin = 0x013000, length = 0x001000
//		RAMGS8		: origin = 0x014000, length = 0x001000
//		RAMGS9		: origin = 0x015000, length = 0x001000
//		RAMGS10		: origin = 0x016000, length = 0x001000
//		RAMGS11		: origin = 0x017000, length = 0x001000
////	RAMGS12		: origin = 0x018000, length = 0x001000
////	RAMGS13		: origin = 0x019000, length = 0x001000
////	RAMGS14		: origin = 0x01A000, length = 0x001000
////	RAMGS15		: origin = 0x01B000, length = 0x001000

		/* Flash sectors */
		FLASHA		: origin = 0x080002, length = 0x03FFFE		/* on-chip Flash */
//		FLASHB		: origin = 0x082000, length = 0x002000		/* on-chip Flash */
//		FLASHC		: origin = 0x084000, length = 0x002000		/* on-chip Flash */
//		FLASHD		: origin = 0x086000, length = 0x002000		/* on-chip Flash */
//		FLASHE		: origin = 0x088000, length = 0x008000		/* on-chip Flash */
//		FLASHF		: origin = 0x090000, length = 0x008000		/* on-chip Flash */
//		FLASHG		: origin = 0x098000, length = 0x008000		/* on-chip Flash */
//		FLASHH		: origin = 0x0A0000, length = 0x008000		/* on-chip Flash */
//		FLASHI		: origin = 0x0A8000, length = 0x008000		/* on-chip Flash */
//		FLASHJ		: origin = 0x0B0000, length = 0x008000		/* on-chip Flash */
//		FLASHK		: origin = 0x0B8000, length = 0x002000		/* on-chip Flash */
//		FLASHL		: origin = 0x0BA000, length = 0x002000		/* on-chip Flash */
//		FLASHM		: origin = 0x0BC000, length = 0x002000		/* on-chip Flash */
//		FLASHN		: origin = 0x0BE000, length = 0x002000		/* on-chip Flash */

////	FLASHO		: origin = 0x0C0000, length = 0x002000		/* on-chip Flash */
////	FLASHP		: origin = 0x0C2000, length = 0x002000		/* on-chip Flash */
////	FLASHQ		: origin = 0x0C4000, length = 0x002000		/* on-chip Flash */
////	FLASHR		: origin = 0x0C6000, length = 0x002000		/* on-chip Flash */
////	FLASHS		: origin = 0x0C8000, length = 0x008000		/* on-chip Flash */
////	FLASHT		: origin = 0x0D0000, length = 0x008000		/* on-chip Flash */
////	FLASHU		: origin = 0x0D8000, length = 0x008000		/* on-chip Flash */
////	FLASHV		: origin = 0x0E0000, length = 0x008000		/* on-chip Flash */
////	FLASHW		: origin = 0x0E8000, length = 0x008000		/* on-chip Flash */
////	FLASHX		: origin = 0x0F0000, length = 0x008000		/* on-chip Flash */
////	FLASHY		: origin = 0x0F8000, length = 0x002000		/* on-chip Flash */
////	FLASHZ		: origin = 0x0FA000, length = 0x002000		/* on-chip Flash */
////	FLASHAA		: origin = 0x0FC000, length = 0x002000		/* on-chip Flash */
////	FLASHAB		: origin = 0x0FE000, length = 0x002000		/* on-chip Flash */

		IQTABLES	: origin = 0x3FE000, length = 0x000B50		/* IQ Math Tables in Boot ROM */
		IQTABLES2	: origin = 0x3FEB50, length = 0x00008C
		IQTABLES3	: origin = 0x3FEBDC, length = 0x0000AA

		RESET		: origin = 0x3FFFC0, length = 0x000002

PAGE 1 :
		/* Data Memory */
		/* Memory (RAM/FLASH) blocks can be moved to PAGE0 for program allocation */

		BOOT_RSVD	: origin = 0x000002, length = 0x000120		/* Part of M0, BOOT rom will use this for stack */

//		RAMM0		: origin = 0x000002, length = 0x0003FE
		RAMM1		: origin = 0x000400, length = 0x000400		/* on-chip RAM block M1 */

//		PieVectTable: origin = 0x000D00, length = 0x0001FF

		ClaCpuMsgRAM: origin = 0x001480, length = 0x000080
		CpuClaMsgRAM: origin = 0x001500, length = 0x000080

		EMIF2_CS2	: origin = 0x00002000, length = 0x00000FFF	/* EMIF2_CS2 	 */

		UppTxMsgRAM	: origin = 0x006C00, length = 0x0001FF
		UppRxMsgRAM	: origin = 0x006E00, length = 0x0001FF

//		RAMLS0		: origin = 0x008000, length = 0x000800
//		RAMLS1		: origin = 0x008800, length = 0x000800
//		RAMLS2		: origin = 0x009000, length = 0x000800
//		RAMLS3		: origin = 0x009800, length = 0x000800
		RAMLS4		: origin = 0x00A000, length = 0x000800		/* CLA Data Sect */
// 		RAMLS5		: origin = 0x00A800, length = 0x000800

//		RAMD0		: origin = 0x00B000, length = 0x000800
//		RAMD1		: origin = 0x00B800, length = 0x000800

//		RAMGS0		: origin = 0x00C000, length = 0x001000
//		RAMGS1		: origin = 0x00D000, length = 0x001000
		RAMGS215	: origin = 0x00E000, length = 0x00E000		/* Program Data */
//		RAMGS2		: origin = 0x00E000, length = 0x001000
//		RAMGS3		: origin = 0x00F000, length = 0x001000
//		RAMGS4		: origin = 0x010000, length = 0x001000
//		RAMGS5		: origin = 0x011000, length = 0x001000
//		RAMGS6		: origin = 0x012000, length = 0x001000
//		RAMGS7		: origin = 0x013000, length = 0x001000
//		RAMGS8		: origin = 0x014000, length = 0x001000
//		RAMGS9		: origin = 0x015000, length = 0x001000
//		RAMGS10		: origin = 0x016000, length = 0x001000
//		RAMGS11		: origin = 0x017000, length = 0x001000
////	RAMGS12		: origin = 0x018000, length = 0x001000		/* Available only on F28379x, F28378x, F28377x, and F28375x !!!! */
////	RAMGS13		: origin = 0x019000, length = 0x001000		/* Available only on F28379x, F28378x, F28377x, and F28375x !!!! */
////	RAMGS14		: origin = 0x01A000, length = 0x001000		/* Available only on F28379x, F28378x, F28377x, and F28375x !!!! */
////	RAMGS15		: origin = 0x01B000, length = 0x001000		/* Available only on F28379x, F28378x, F28377x, and F28375x !!!! */

		CPU1TOCPU2RAM: origin = 0x03A000, length = 0x000800
		CPU2TOCPU1RAM: origin = 0x03B000, length = 0x000800

		CANA_MSG_RAM: origin = 0x049000, length = 0x000800
		CANB_MSG_RAM: origin = 0x04B000, length = 0x000800
}

SECTIONS
{
   	/* Initalized sections go in Flash */
   	.reset          : > RESET,  PAGE=0, TYPE = DSECT	/* not used, */
   	codestart     	: > BEGIN,  PAGE=0, ALIGN(4)

 	.cinit          : > FLASHA, PAGE=0, ALIGN(4)
 	.switch         : > FLASHA, PAGE=0, ALIGN(4)
	
#if defined(__TI_EABI__)

	.const          : > FLASHA, PAGE=0, ALIGN(4)
	.farconst       : > FLASHA, PAGE=0, ALIGN(4)
   	.text           : > FLASHA, PAGE=0, ALIGN(4)
	.init_array     : > FLASHA, PAGE=0, ALIGN(4)
	.c28xabi.exidx  : > FLASHA, PAGE=0, ALIGN(4)
	.c28xabi.extab  : > FLASHA, PAGE=0, ALIGN(4)

	.bss			: > RAMGS215,	PAGE=1
	.data			: > RAMGS215,   PAGE=1
	.farbss         : > RAMGS215,   PAGE=1
	.fardata        : > RAMGS215,   PAGE=1
	.sysmem			: > RAMGS215,	PAGE=1
	.stack			: > RAMM1,		PAGE=1				/* Needs to be in lower 64K memory */
	.bss:cio		: > RAMGS215,	PAGE=1

	#ifdef __TI_COMPILER_VERSION__
		#if __TI_COMPILER_VERSION__ >= 15009000
			.TI.ramfunc	: {}
				LOAD = FLASHA,
		     	RUN = RAMLS5GS1,
		     	LOAD_START(RamfuncsLoadStart),
		     	LOAD_SIZE(RamfuncsLoadSize),
		     	LOAD_END(RamfuncsLoadEnd),
		     	RUN_START(RamfuncsRunStart),
		     	RUN_SIZE(RamfuncsRunSize),
		     	RUN_END(RamfuncsRunEnd),
		     	ALIGN(4),
				PAGE=0 
		#else
			ramfuncs : {}
				LOAD = FLASHA,
		    	RUN = RAMLS5GS1,
		     	LOAD_START(RamfuncsLoadStart),
		     	LOAD_SIZE(RamfuncsLoadSize),
		    	LOAD_END(RamfuncsLoadEnd),
		     	RUN_START(RamfuncsRunStart),
		     	RUN_SIZE(RamfuncsRunSize),
		     	RUN_END(RamfuncsRunEnd),
		     	ALIGN(4),
				PAGE=0
		#endif
	#endif
#else

	.econst         : > FLASHA, PAGE=0, ALIGN(4)
	.farconst       : > FLASHA, PAGE=0, ALIGN(4)
   	.text           : > FLASHA, PAGE=0, ALIGN(4)
	.pinit          : > FLASHA, PAGE=0, ALIGN(4)

	.ebss			: > RAMGS215,	PAGE=1
	.farbss         : > RAMGS215,   PAGE=1
	.esysmem		: > RAMGS215,	PAGE=1
	.stack			: > RAMM1,		PAGE=1				/* Needs to be in lower 64K memory */
	.cio			: > RAMGS215,	PAGE=1

	#ifdef __TI_COMPILER_VERSION__
		#if __TI_COMPILER_VERSION__ >= 15009000
			.TI.ramfunc	: {}
				LOAD = FLASHA,
		     	RUN = RAMLS5GS1,
		     	LOAD_START(_RamfuncsLoadStart),
		     	LOAD_SIZE(_RamfuncsLoadSize),
		     	LOAD_END(_RamfuncsLoadEnd),
		     	RUN_START(_RamfuncsRunStart),
		     	RUN_SIZE(_RamfuncsRunSize),
		     	RUN_END(_RamfuncsRunEnd),
		     	ALIGN(4),
				PAGE=0
		#else
			ramfuncs : {}
				LOAD = FLASHA,
		    	RUN = RAMLS5GS1,
		     	LOAD_START(_RamfuncsLoadStart),
		     	LOAD_SIZE(_RamfuncsLoadSize),
		    	LOAD_END(_RamfuncsLoadEnd),
		     	RUN_START(_RamfuncsRunStart),
		     	RUN_SIZE(_RamfuncsRunSize),
		     	RUN_END(_RamfuncsRunEnd),
		     	ALIGN(4),
				PAGE=0
		#endif
	#endif
#endif

    /* CLA specific sections */
#if defined(__TI_EABI__)
	Cla1Prog    : fill = 0x5555 	// fill value for holes
                {
					.+=0x4;  		// empty space at head of section
                    *(Cla1Prog)
				}
   				LOAD = FLASHA,
                RUN = RAMLS03,
                LOAD_START(Cla1funcsLoadStart),
                LOAD_END(Cla1funcsLoadEnd),
                RUN_START(Cla1funcsRunStart),
                LOAD_SIZE(Cla1funcsLoadSize),
                ALIGN(8),
				PAGE=0

//	#if  !(CLA_MATH_TABLES_IN_ROM)
	   //
	   //Load tables to Flash and copy over to RAM
	   //
	   CLA1mathTables    :  LOAD = FLASHA,
	                        RUN = RAMLS03,
	                        RUN_START(CLA1mathTablesRunStart),
	                        LOAD_START(CLA1mathTablesLoadStart),
	                        LOAD_SIZE(CLA1mathTablesLoadSize),
	                        PAGE = 0
//	#endif
#else
	Cla1Prog    : fill = 0x5555		// fill value for holes
                {
					.+=0x4;  		// empty space at head of section
//                  *(Cla1Prog)
                }
   				LOAD = FLASHA,
                RUN = RAMLS03,
                LOAD_START(_Cla1funcsLoadStart),
                LOAD_END(_Cla1funcsLoadEnd),
                RUN_START(_Cla1funcsRunStart),
                LOAD_SIZE(_Cla1funcsLoadSize),
                ALIGN(8),
				PAGE=0

//	#if  !(CLA_MATH_TABLES_IN_ROM)
	   //
	   //Load tables to Flash and copy over to RAM
	   //
	   CLA1mathTables    :  LOAD = FLASHA,
	                        RUN = RAMLS03,
	                        RUN_START(_CLA1mathTablesRunStart),
	                        LOAD_START(_CLA1mathTablesLoadStart),
	                        LOAD_SIZE(_CLA1mathTablesLoadSize),
	                        PAGE = 0
//	#endif
#endif

	Cla1ToCpuMsgRAM	: > ClaCpuMsgRAM, PAGE=1, type=NOINIT
	CpuToCla1MsgRAM : > CpuClaMsgRAM, PAGE=1, type=NOINIT
   
#ifdef CLA_C
	/* CLA C compiler sections */
	//
	// Must be allocated to memory the CLA has write access to
	//
	CLAscratch	:
                { *.obj(CLAscratch)
                   . += CLA_SCRATCHPAD_SIZE;
                  *.obj(CLAscratch_end)
                } >  RAMLS4, PAGE=1
				 
	.scratchpad	: > RAMLS4
   	.bss_cla	: > RAMLS4

	#if defined(__TI_EABI__)
		.const_cla:
				LOAD = FLASHA,
				RUN = RAMLS4,
				RUN_START(Cla1ConstRunStart),
				LOAD_START(Cla1ConstLoadStart),
				LOAD_SIZE(Cla1ConstLoadSize),
				ALIGN(8),
				PAGE=1
	#else
		.const_cla:
				LOAD = FLASHA,
				RUN = RAMLS4,
				RUN_START(_Cla1ConstRunStart),
				LOAD_START(_Cla1ConstLoadStart),
				LOAD_SIZE(_Cla1ConstLoadSize),
				ALIGN(8),
				PAGE=1
	#endif

	ClaData	   	: > RAMLS4,	PAGE=1
#else
   .bss_cla		: > RAMLS4, PAGE=1
#endif //CLA_C

	Emif2_CS2	 : > EMIF2_CS2, PAGE=1, ALIGN(2)

	/* Allocate IQ math areas: */
	IQmath		 : > FLASHA, PAGE=0, ALIGN(4)	/* Math Code */
	IQmathTables : > FLASHA, PAGE=0, ALIGN(4)
}

//#############################################################################
// End of file.
//#############################################################################
