/****************************************************************************
 *                                                                          *
 *                                                                          *
 *   File            :   EpwmDrive.h                                        *
 *   Project         :   Foc Stepper                                        *
 *   Compiler        :   Code Composer Studio Texas Instruments             *
 *                                                                          *
 *   Function        :   DSP280x function init Epwm                         *
 *                                                                          *
 *                                                                          *
 *   Vers.   Data   Programmer    Description                               *
 *   1.00  01/07/07 Mezzadri      Prima versione                            *
 *                                                                          *
 ****************************************************************************/

#ifndef EPWMDRIVE_H_INCLUDED
#define EPWMDRIVE_H_INCLUDED

// #include "../../Source/AEC_Device.h"

#include "EpwmDriveDefine.h"

/*----------------------------------------------------------------------------*/
/*         PROTOTYPE                                                          */
/*----------------------------------------------------------------------------*/
int16_t epwmdrive_InitEpwm(volatile struct EPWM_REGS *EPWMnRegs,                          \
                                         int16_t Type, uint16_t TzTrip, uint16_t dcxyCompSel, \
                                         uint16_t INT_Trigger, int16_t SOCA_Trigger, int16_t SOCB_Trigger, int32_t Freq_CPU, int32_t Period);
int16_t epwmdrive_SyncSocSetup(void);
void    epwmdrive_SetPwmMode	(void);

interrupt void Epwm1_isr    (void);

interrupt void Epwm1TZ_isr  (void);
interrupt void Epwm2TZ_isr  (void);
interrupt void Epwm3TZ_isr  (void);
interrupt void Epwm4TZ_isr  (void);
interrupt void Epwm5TZ_isr  (void);
interrupt void Epwm6TZ_isr  (void);
interrupt void Epwm7TZ_isr  (void);
interrupt void Epwm8TZ_isr  (void);
interrupt void Epwm9TZ_isr  (void);
interrupt void Epwm10TZ_isr (void);
interrupt void Epwm11TZ_isr (void);
interrupt void Epwm12TZ_isr (void);

void epwmdrive_DisableOutputEPWMn(volatile struct EPWM_REGS *);
void epwmdrive_EnableOutputEPWMn(volatile struct EPWM_REGS *);
void epwmdrive_SetOCFilter(variables_Asse_e numAsse);

interrupt void TaskPosISR(void);
interrupt void TaskSpeedISR(void);
interrupt void Task50usISR(void);

#endif  // EPWMDRIVE_H_INCLUDED
