/****************************************************************************
 *                                                                          *
 *                                                                          *
 *   File            :   EpwmDriveDefine.h                                  *
 *   Project         :   Foc Stepper                                        *
 *   Compiler        :   Code Composer Studio Texas Instruments             *
 *                                                                          *
 *   Function        :   DSP280x define constant for Epwm                   *
 *                                                                          *
 *                                                                          *
 *   Vers.   Data   Programmer    Description                               *
 *   1.00  01/07/07 Mezzadri      Prima versione                            *
 *                                                                          *
 ****************************************************************************/

#ifndef EPWMDRIVEDEFINE_H_INCLUDED
#define EPWMDRIVEDEFINE_H_INCLUDED

/*----------------------------------------------------------------------------*/
/*     DEFINE                                                                 */
/*----------------------------------------------------------------------------*/

// Selezione tempo per frequenza portante PWM
// 200 MHz (con conteggio up-down)
#define PWM_20KHz       	        20000   					// 20kHz 50   uS	(25uS * 2) <- Utilizzato
#define PWM_16KHz       	        16000				        // 16kHz 62,5 uS
#define PWM_10KHz       	        10000   					// 10kHz 100  uS
#define PWM_8KHz        	        8000    					//  8kHz 125  uS
#define PWM_5KHz       	            5000 						//  5kHz 200  uS

#define PWM_FREQ_SELECT             PWM_20KHz			        //<<<<< Frequenza portante PWM impostata <<<<<

// Selezione tempo minimo ricarica condensatore bootstrap
#if(PWM_CENTERED)
	// 200MHz (con conteggio up-down)
	#define PWM_BOOT10_200MHz       250							//  5 uS
	#define PWM_BOOT9_200MHz        225     					//4.5 uS
	#define PWM_BOOT8_200MHz        200     					//  4 uS
	#define PWM_BOOT7_200MHz        175     					//3.5 uS
	#define PWM_BOOT6_200MHz        150     					//  3 uS
	#define PWM_BOOT5_200MHz        125     					//2.5 uS
	#define PWM_BOOT4_200MHz        100     					//  2 uS
	#define PWM_BOOT3_200MHz         75     					//1.5 uS
	#define PWM_BOOT2_200MHz         50     					//  1 uS
	#define PWM_BOOT1_200MHz         25     					//0.5 uS
#else
	// 200MHz (con conteggio up)
	#define PWM_BOOT10_200MHz       500							//  5 uS
	#define PWM_BOOT9_200MHz        450     					//4.5 uS
	#define PWM_BOOT8_200MHz        400     					//  4 uS
	#define PWM_BOOT7_200MHz        350     					//3.5 uS
	#define PWM_BOOT6_200MHz        300     					//  3 uS
	#define PWM_BOOT5_200MHz        250     					//2.5 uS
	#define PWM_BOOT4_200MHz        200     					//  2 uS
	#define PWM_BOOT3_200MHz        150     					//1.5 uS
	#define PWM_BOOT2_200MHz        100     					//  1 uS
	#define PWM_BOOT1_200MHz         50     					//0.5 uS
#endif

#define		BOOT_SELECT				PWM_BOOT2_200MHz			//<<<<< Tempo minimo per carico capacita' di boot <<<<<

// Selezione tempo dead band
#define		PWM_DB_2uS_200MHz		200    						//	2 uS
#define		PWM_DB_1uS_200MHz       100    						//  1 uS
#define 	PWM_DB_600nS_200MHz      60    						//  600nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_550nS_200MHz      55    						//  550nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_500nS_200MHz      50    						//  500nS       (1/SYSCLOCKOUT)*50
#define		PWM_DB_450nS_200MHz      45    						//  450nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_400nS_200MHz      40    						//  400nS       (1/SYSCLOCKOUT)*50
#define		PWM_DB_350nS_200MHz      35    						//  350nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_300nS_200MHz      30    						//  300nS       (1/SYSCLOCKOUT)*50
#define		PWM_DB_250nS_200MHz      25    						//  250nS       (1/SYSCLOCKOUT)*50	(valore originale)
#define		PWM_DB_200nS_200MHz      20    						//  200nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_150nS_200MHz      15    						//  150nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_100nS_200MHz      10    						//  100nS       (1/SYSCLOCKOUT)*50
#define 	PWM_DB_50nS_200MHz 		  5    						//  50nS        (1/SYSCLOCKOUT)*50

#if(AECDEVICE_MOTORE == AECDEVICE_MOTORE_DC)
	#define	DB_SELECT				PWM_DB_150nS_200MHz			//<<<<< Dead band impostato <<<<<
#elif(AECDEVICE_MOTORE == AECDEVICE_MOTORE_BRUSHLESS)
//  #define DB_SELECT               PWM_DB_150nS_200MHz         //<<<<< Dead band impostato <<<<<
    #define DB_SELECT               PWM_DB_500nS_200MHz         //<<<<< Dead band impostato <<<<<
#elif (AECDEVICE_BOARDTYPE == AECDEVICE_BOARDTYPE_5106)
	#define	DB_SELECT	            PWM_DB_250nS_200MHz			//<<<<< Dead band impostato <<<<<
#elif (AECDEVICE_BOARDTYPE == AECDEVICE_BOARDTYPE_5206)
	#define	DB_SELECT	            PWM_DB_150nS_200MHz			//<<<<< Dead band impostato <<<<<
#elif (AECDEVICE_BOARDTYPE == AECDEVICE_BOARDTYPE_1204)
	#define	DB_SELECT	            PWM_DB_150nS_200MHz			//<<<<< Dead band impostato <<<<<
#else
	#define	DB_SELECT	            PWM_DB_150nS_200MHz			//<<<<< Dead band impostato <<<<<
#endif

//==============================================================
//==== Da qui in poi non si dovrebbe modificare piu' niente ====
//==== Le selezioni vengono eseguite sopra 					====
//==============================================================
#if(PWM_CENTERED)
    #define EPWMn_DEFAULT_PRD       ((int)(((long)FREQ_CPU_200MHz) / ((long)PWM_FREQ_SELECT * 2 * 2)))
#else
    #define EPWMn_DEFAULT_PRD       ((int)(((long)FREQ_CPU_200MHz) / ((long)PWM_FREQ_SELECT * 2)))
#endif

#define EPWMn_DEFAULT_PRD_CLA       ((float)EPWMn_DEFAULT_PRD)

#define EPWMn_DEFAULT_DB            DB_SELECT                                   //< Dead band
#define EPWMn_PWM_MAX       		(EPWMn_DEFAULT_PRD - DB_SELECT - BOOT_SELECT)	//< Apertura max PWM
#define EPWMn_PWM_CNTR             	(EPWMn_DEFAULT_PRD >> 1)				        //< PWM 50%
#define EPWMn_PWM_MIN             	0											//< Apertura min PWM

#if(PWM_CENTERED)
	#define EPWMn_DEFAULT_CC		EPWMn_PWM_CNTR      						//< Counter compare default value
#else
	#define EPWMn_DEFAULT_CC    	EPWMn_PWM_MIN								//< Counter compare default value
#endif

// TB Clock prescaler bits
#define EPWMn_CLKDIV_1        		0x0     //< Divide by 1
#define EPWMn_CLKDIV_2       		0x1     //< Divide by 2
#define EPWMn_CLKDIV_4        		0x2     //< Divide by 4
#define EPWMn_CLKDIV_8        		0x3     //< Divide by 8
#define EPWMn_CLKDIV_16       		0x4     //< Divide by 16
#define EPWMn_CLKDIV_32       		0x5     //< Divide by 32
#define EPWMn_CLKDIV_64       		0x6     //< Divide by 64
#define EPWMn_CLKDIV_128      		0x7 	//< Divide by 128

// High speed TB Clock prescaler bits
#define EPWMn_HSPCLKDIV_1      		0x0		//< Divide by 1
#define EPWMn_HSPCLKDIV_2      		0x1     //< Divide by 2
#define EPWMn_HSPCLKDIV_4     		0x2     //< Divide by 4
#define EPWMn_HSPCLKDIV_6      		0x3     //< Divide by 6
#define EPWMn_HSPCLKDIV_8      		0x4     //< Divide by 8
#define EPWMn_HSPCLKDIV_10    		0x5     //< Divide by 10
#define EPWMn_HSPCLKDIV_12     		0x6     //< Divide by 12
#define EPWMn_HSPCLKDIV_14    		0x7     //< Divide by 14

// Select syncout or syncin
#define EPWMn_MASTER          		0x0    	//< Master
#define EPWMn_SLAVE            		0x1     //< Slave

// Select trip mode
#define NO_TRIP              		0x0000  //< Pwm without trip
#define TZ1_TRIP             		0x0001  //< Use TZ1 trip
#define TZ2_TRIP             		0x0002  //< Use TZ2 trip
#define TZ3_TRIP             		0x0004  //< Use TZ3 trip
#define TZ4_TRIP             		0x0008  //< Use TZ4 trip
#define TZ5_TRIP             		0x0010  //< Use TZ5 trip
#define TZ6_TRIP             		0x0020  //< Use TZ6 trip
#define DCAEVT1_TRIP            	0x0040  //< Use DCAEVT1 trip
#define DCAEVT2_TRIP            	0x0080  //< Use DCAEVT2 trip
#define DCBEVT1_TRIP            	0x0100  //< Use DCBEVT1 trip
#define DCBEVT2_TRIP            	0x0200  //< Use DCBEVT2 trip

// Digital Compare A/B High/Low Input Select Bits
#define EPWM_DCxy_TRIPIN1_TZ1		0		// 00: TRIPIN1 and (TZ1 input)
#define EPWM_DCxy_TRIPIN2_TZ2		1		// 01: TRIPIN2 and (TZ2 input)
#define EPWM_DCxy_TRIPIN3_TZ3		2		// 02: TRIPIN3 and (TZ3 input)
#define EPWM_DCxy_TRIPIN4			3		// 03: TRIPIN4
#define EPWM_DCxy_TRIPIN5			4		// 04: TRIPIN5
#define EPWM_DCxy_TRIPIN6			5		// 05: TRIPIN6
#define EPWM_DCxy_TRIPIN7			6		// 06: TRIPIN7
#define EPWM_DCxy_TRIPIN8			7		// 07: TRIPIN8
#define EPWM_DCxy_TRIPIN9			8		// 08: TRIPIN9
#define EPWM_DCxy_TRIPIN10			9		// 09: TRIPIN10
#define EPWM_DCxy_TRIPIN11			10		// 10: TRIPIN11
#define EPWM_DCxy_TRIPIN12			11		// 11: TRIPIN12
#define EPWM_DCxy_RESERVED			12		// 12: Reserved
#define EPWM_DCxy_TRIPIN14			13		// 13: TRIPIN14
#define EPWM_DCxy_TRIPIN15			14		// 14: TRIPIN15
#define EPWM_DCxy_COMBINATION		15		// 15: Trip combination input (all trip inputs selected by DCAHTRIPSEL register ORed together)

#endif  // EPWMDRIVEDEFINE_H_INCLUDED
