//###########################################################################
// FILE:    Example_2837xSI2c_eeprom.c
// TITLE:   I2C EEPROM Example
//
//! \addtogroup cpu01_example_list
//! <h1>I2C EEPROM Example (i2c_eeprom)</h1>
//!
//! This program will write 1-14 words to EEPROM and read them back.
//! The data written and the EEPROM address written to are contained
//! in the message structure, I2cMsgOut1. The data read back will be
//! contained in the message structure I2cMsgIn1.
//!
//! \b External \b Connections \n
//! - This program requires an external I2C EEPROM connected to
//!   the I2C bus at address 0x50.
//
//###########################################################################
// $TI Release: F2837xS Support Library v191 $
// $Release Date: Fri Mar 11 15:58:35 CST 2016 $
// $Copyright: Copyright (C) 2014-2016 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################
//###########################################################################
//
// FILE:    I2c_master.c
//
// TITLE:   DSP280x I2C MASTER
//
// DESCRIPTION:
//
//  I2C MemWrite
//
//  S ADDR W A DATA_ADDR_H A DATA_ADDR_L A DATA ...... A P
//
//     S = Start bit
//  ADDR = Device Address
//     W = Write
//     A = Acknowledge
//  DATA_ADDR_H = Memory data address (MSB)
//     A = Acknowledge
//  DATA_ADDR_L = Memory data address (LSB)
//     A = Ack
//  DATA = Byte to be write
//     A = Ack
//     P = Stop bit
//
//
//  I2C MemRead
//
//  S ADDR W A DATA_ADDR_H A DATA_ADDR_L A S ADDR R A DATA ...... A P
//
//     S = Start bit
//  ADDR = Device Address
//     W = Write
//     A = Acknowledge
//  DATA_ADDR_H = Memory data address (MSB)
//     A = Acknowledge
//  DATA_ADDR_L = Memory data address (LSB)
//     A = Acknowledge
//
//     S = Repeated Start Bit
//  ADDR = Device Address
//     R = Read
//     A = Acknowlege
//  DATA = Byte data read
//     A = (N)Ack (from host)
//     P = Stop bit
//
//---------------------------------------------------------------------------
#include "../../Source/AEC_Device.h"

#include "_lock.h"

#include "../../Source/src_board/DefineSw.h"
#include "../../Source/src_board/SetupDspGpio.h"
#include "../../Source/src_cpu/DefineTypedef.h"
#include "F2837xS_SWPrioritizedIsrLevels.h"
#include "F28x_Project.h"				// DSP320F28x Headerfile Include File
#include "../../Source/src_database/Variables.h"

#include "I2C_Master.h"

/*------------------------------------------------------*/
/* Inizializza il modulo di gestione comunicazione I2C  */
/*------------------------------------------------------*/
void i2cmaster_InitModule(void)
{
}

/*------------------------------------------------------*/
/* i2cmaster_Manager1Ms routine                         */
/* Gestione in interrupt 1ms I2C                        */
/*------------------------------------------------------*/
void i2cmaster_Manager1ms(void)
{
}

/*------------------------------------------------------*/
/* Write                                                */
/* Scrivi un dato nel DAC                               */
/* Se non trova la periferica libera, esce senza        */
/* attendere.											*/
/*------------------------------------------------------*/
int16 DacWrite(int32 Data)
{

 	 return(0);
}


//===========================================================================
// No more.
//===========================================================================
