//****************************************************************************/
//*                                                                          */
//*  FILE        : I2C_Master.h                                              */
//*  DESCRIPTION : Gestione comunicazione con periferiche I2C bus            */
//*  CPU TYPE    : Texas TMS320F28232                                        */
//*  Programmer  : G.Z.                                                      */
//*                                                                          */
//*  DATE        : 18-07-08                                                  */
//*                                                                          */
//****************************************************************************/
#ifndef I2CMASTER_H_INCLUDED
#define I2CMASTER_H_INCLUDED

#define I2CMASTER_EEPROMID		0xA0				// Slave Address EEPROM
#define I2CMASTER_DACID			0x9A				// Slave Address DAC
#define I2CMASTER_MCP23008ID	0x40				// Slave Address Digital I/O

//---- Dichiarazione funzioni pubbliche modulo --------------------------------
//---- Dichiarazione funzioni globali -----------------------------------------
// EXTERN void I2CA_test(void);
void i2cmaster_InitModule(void);
void i2cmaster_Manager1ms(void);

__interrupt void i2c_int1a_isr(void);

int16_t I2CA_DacWrite(uint8_t Slave_id, int32_t Data);

#endif // I2CMASTER_H_INCLUDED
