/*
 * File: Inverter_000_test.c
 *
 * Code generated for Simulink model 'Inverter_000_test'.
 *
 * Model version                  : 1.126
 * Simulink Coder version         : 8.14 (R2018a) 06-Feb-2018
 * C/C++ source code generated on : Wed Apr 14 17:29:45 2021
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Inverter_000_test.h"
#include "Inverter_000_test_private.h"

/* Block signals (default storage) */
B_Inverter_000_test_T Inverter_000_test_B;

/* Block states (default storage) */
DW_Inverter_000_test_T Inverter_000_test_DW;

/* Real-time model */
RT_MODEL_Inverter_000_test_T Inverter_000_test_M_;
RT_MODEL_Inverter_000_test_T *const Inverter_000_test_M = &Inverter_000_test_M_;
static void rate_monotonic_scheduler(void);

/*
 * Set which subrates need to run this base step (base rate always runs).
 * This function must be called prior to calling the model step function
 * in order to "remember" which rates need to run this base step.  The
 * buffering of events allows for overlapping preemption.
 */
void Inverter_000_test_SetEventsForThisBaseStep(boolean_T *eventFlags)
{
  /* Task runs when its counter is zero, computed via rtmStepTask macro */
  eventFlags[1] = ((boolean_T)rtmStepTask(Inverter_000_test_M, 1));
}

/*
 *   This function updates active task flag for each subrate
 * and rate transition flags for tasks that exchange data.
 * The function assumes rate-monotonic multitasking scheduler.
 * The function must be called at model base rate so that
 * the generated code self-manages all its subrates and rate
 * transition flags.
 */
static void rate_monotonic_scheduler(void)
{
  /* To ensure a deterministic data transfer between two rates,
   * data is transferred at the priority of a fast task and the frequency
   * of the slow task.  The following flags indicate when the data transfer
   * happens.  That is, a rate interaction flag is set true when both rates
   * will run, and false otherwise.
   */

  /* tid 0 shares data with slower tid rate: 1 */
  Inverter_000_test_M->Timing.RateInteraction.TID0_1 =
    (Inverter_000_test_M->Timing.TaskCounters.TID[1] == 0);

  /* Compute which subrates run during the next base time step.  Subrates
   * are an integer multiple of the base rate counter.  Therefore, the subtask
   * counter is reset when it reaches its limit (zero means run).
   */
  (Inverter_000_test_M->Timing.TaskCounters.TID[1])++;
  if ((Inverter_000_test_M->Timing.TaskCounters.TID[1]) > 1) {/* Sample time: [0.0001s, 0.0s] */
    Inverter_000_test_M->Timing.TaskCounters.TID[1] = 0;
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

real32_T rt_roundf_snf(real32_T u)
{
  real32_T y;
  if (fabsf(u) < 8.388608E+6F) {
    if (u >= 0.5F) {
      y = (real32_T)floor(u + 0.5F);
    } else if (u > -0.5F) {
      y = u * 0.0F;
    } else {
      y = (real32_T)ceil(u - 0.5F);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model step function for TID0 */
void Inverter_000_test_step0(void)     /* Sample time: [5.0E-5s, 0.0s] */
{
  /* local block i/o variables */
  int32_T rtb_FloattoIQN[3];
  int32_T rtb_Sum5;
  int32_T rtb_Sum4_p;
  int32_T rtb_Sum1_p;
  int32_T rtb_u;
  int32_T rtb_Product7;
  int32_T rtb_u_g;
  int32_T rtb_u_a;
  int32_T rtb_Product5;
  int32_T rtb_Sum1;
  real32_T rtb_DataTypeConversion2[3];
  real32_T rtb_Gain2_b;
  real_T tmp;
  uint16_T tmp_0;
  real32_T rtb_DataTypeConversion2_tmp;

  {                                    /* Sample time: [5.0E-5s, 0.0s] */
    rate_monotonic_scheduler();
  }

  /* RateTransition: '<Root>/Rate Transition1' */
  if (Inverter_000_test_M->Timing.RateInteraction.TID0_1) {
    Inverter_000_test_B.RateTransition1 =
      Inverter_000_test_DW.RateTransition1_Buffer0;
  }

  /* End of RateTransition: '<Root>/Rate Transition1' */

  /* Gain: '<S4>/Gain3' */
  rtb_Gain2_b = Inverter_000_test_P.Gain3_Gain *
    Inverter_000_test_B.RateTransition1;

  /* S-Function (stiiqmath_iq): '<S4>/Float to IQN2' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S4>/Float to IQN2' */
  {
    rtb_u_a = _IQ10 (rtb_Gain2_b);
  }

  /* Product: '<S4>/Product5' incorporates:
   *  Constant: '<S4>/Constant10'
   *  Constant: '<S4>/Constant13'
   *  Constant: '<S4>/Constant14'
   */
  rtb_DataTypeConversion2_tmp = (real32_T)rtb_u_a * 0.0009765625F;
  rtb_DataTypeConversion2[0] = rtb_DataTypeConversion2_tmp *
    Inverter_000_test_P.Constant13_Value;
  rtb_DataTypeConversion2[1] = rtb_DataTypeConversion2_tmp *
    Inverter_000_test_P.Constant14_Value;
  rtb_DataTypeConversion2[2] = rtb_DataTypeConversion2_tmp *
    Inverter_000_test_P.Constant10_Value;

  /* S-Function (stiiqmath_iq): '<S4>/Float to IQN' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S4>/Float to IQN' */
  {
    rtb_FloattoIQN[0] = _IQ10 (rtb_DataTypeConversion2[0]);
    rtb_FloattoIQN[1] = _IQ10 (rtb_DataTypeConversion2[1]);
    rtb_FloattoIQN[2] = _IQ10 (rtb_DataTypeConversion2[2]);
  }

  /* S-Function (scheckfractionlength): '<S11>/ ' */
  rtb_u_a = rtb_FloattoIQN[0];

  /* S-Function (scheckfractionlength): '<S12>/ ' incorporates:
   *  Constant: '<S4>/Constant11'
   */
  rtb_u = Inverter_000_test_P.Constant11_Value;

  /* S-Function (scheckfractionlength): '<S12>/ 1' incorporates:
   *  Constant: '<S4>/Constant8'
   */
  rtb_Product5 = Inverter_000_test_P.Constant8_Value_e;

  /* S-Function (scheckfractionlength): '<S12>/ 2' incorporates:
   *  Constant: '<S4>/Constant9'
   */
  rtb_u_g = Inverter_000_test_P.Constant9_Value;

  /* Product: '<S12>/Product1' */
  rtb_Sum1 = rtb_u;

  /* Sum: '<S12>/Sum2' incorporates:
   *  UnitDelay: '<S12>/Unit Delay'
   */
  Inverter_000_test_DW.UnitDelay_DSTATE += rtb_Sum1;

  /* Switch: '<S14>/Switch' incorporates:
   *  Constant: '<S14>/1'
   *  RelationalOperator: '<S14>/Relational Operator'
   *  Sum: '<S14>/Sum2'
   */
  if (Inverter_000_test_DW.UnitDelay_DSTATE > Inverter_000_test_P.u_Value) {
    Inverter_000_test_DW.UnitDelay_DSTATE -= Inverter_000_test_P.u_Value;
  }

  /* End of Switch: '<S14>/Switch' */

  /* Switch: '<S14>/Switch1' incorporates:
   *  Constant: '<S14>/-1'
   *  Constant: '<S14>/1'
   *  RelationalOperator: '<S14>/Relational Operator1'
   *  Sum: '<S14>/Sum1'
   *  UnitDelay: '<S12>/Unit Delay'
   */
  if (Inverter_000_test_DW.UnitDelay_DSTATE < Inverter_000_test_P.u_Value_e) {
    Inverter_000_test_DW.UnitDelay_DSTATE += Inverter_000_test_P.u_Value;
  }

  /* End of Switch: '<S14>/Switch1' */

  /* Product: '<S12>/Product2' incorporates:
   *  UnitDelay: '<S12>/Unit Delay'
   */
  rtb_Sum1 = __IQmpy(Inverter_000_test_DW.UnitDelay_DSTATE, rtb_Product5, 29);

  /* Sum: '<S12>/Sum1' */
  rtb_Sum1 += rtb_u_g;

  /* Switch: '<S15>/Switch2' incorporates:
   *  Constant: '<S15>/1'
   *  RelationalOperator: '<S15>/Relational Operator2'
   *  Sum: '<S15>/Sum4'
   */
  if (rtb_Sum1 > Inverter_000_test_P.u_Value_f) {
    rtb_Sum1 -= Inverter_000_test_P.u_Value_f;
  }

  /* End of Switch: '<S15>/Switch2' */

  /* Switch: '<S15>/Switch3' incorporates:
   *  Constant: '<S15>/-1'
   *  Constant: '<S15>/1'
   *  RelationalOperator: '<S15>/Relational Operator3'
   *  Sum: '<S15>/Sum3'
   */
  if (rtb_Sum1 < Inverter_000_test_P.u_Value_c) {
    rtb_Sum1 += Inverter_000_test_P.u_Value_f;
  }

  /* End of Switch: '<S15>/Switch3' */

  /* S-Function (stiiqmath_iqtof): '<S4>/IQN to Float3' */

  /* C28x IQmath Library (stiiqmath_iqtof) - '<S4>/IQN to Float3' */
  {
    rtb_Gain2_b = _IQ29toF (rtb_Sum1);
  }

  /* Gain: '<S4>/Gain2' */
  rtb_Gain2_b *= Inverter_000_test_P.Gain2_Gain;

  /* S-Function (stiiqmath_iq): '<S4>/Float to IQN1' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S4>/Float to IQN1' */
  {
    rtb_Sum1 = _IQ10 (rtb_Gain2_b);
  }

  /* S-Function (stiiqmath_iqtrig): '<S11>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/cos IQN' */
  {
    rtb_u_g = _IQ10cos(rtb_Sum1);
  }

  /* Product: '<S11>/Product2' */
  rtb_Product5 = __IQmpy(rtb_u_a, rtb_u_g, 10);

  /* S-Function (scheckfractionlength): '<S11>/ 1' */
  rtb_u_g = rtb_FloattoIQN[1];

  /* S-Function (stiiqmath_iqtrig): '<S11>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/sin IQN' */
  {
    rtb_u = _IQ10sin(rtb_Sum1);
  }

  /* Product: '<S11>/Product3' */
  rtb_Sum5 = __IQmpy(rtb_u_g, rtb_u, 10);

  /* S-Function (scheckfractionlength): '<S11>/ 3' */
  rtb_u = rtb_FloattoIQN[2];

  /* Sum: '<S11>/Sum1' */
  rtb_Sum1_p = (rtb_Product5 - rtb_Sum5) + rtb_u;

  /* S-Function (stiiqmath_iq): '<S11>/Float to IQN' incorporates:
   *  Constant: '<S11>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S11>/Float to IQN' */
  {
    rtb_Sum5 = _IQ10 (Inverter_000_test_P.Constant_Value_j);
  }

  /* Sum: '<S11>/Sum3' */
  rtb_Product5 = rtb_Sum1 - rtb_Sum5;

  /* S-Function (stiiqmath_iqtrig): '<S11>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/cos IQN1' */
  {
    rtb_Sum4_p = _IQ10cos(rtb_Product5);
  }

  /* Product: '<S11>/Product4' */
  rtb_Product7 = __IQmpy(rtb_u_a, rtb_Sum4_p, 10);

  /* S-Function (stiiqmath_iqtrig): '<S11>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/sin IQN1' */
  {
    rtb_Sum4_p = _IQ10sin(rtb_Product5);
  }

  /* Product: '<S11>/Product5' */
  rtb_Product5 = __IQmpy(rtb_u_g, rtb_Sum4_p, 10);

  /* Sum: '<S11>/Sum4' */
  rtb_Sum4_p = (rtb_Product7 - rtb_Product5) + rtb_u;

  /* Sum: '<S11>/Sum' */
  rtb_Product7 = rtb_Sum1 + rtb_Sum5;

  /* S-Function (stiiqmath_iqtrig): '<S11>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/cos IQN2' */
  {
    rtb_Sum5 = _IQ10cos(rtb_Product7);
  }

  /* Product: '<S11>/Product6' */
  rtb_Sum1 = __IQmpy(rtb_u_a, rtb_Sum5, 10);

  /* S-Function (stiiqmath_iqtrig): '<S11>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S11>/sin IQN2' */
  {
    rtb_Sum5 = _IQ10sin(rtb_Product7);
  }

  /* Product: '<S11>/Product7' */
  rtb_Product7 = __IQmpy(rtb_u_g, rtb_Sum5, 10);

  /* Sum: '<S11>/Sum5' */
  rtb_Sum5 = (rtb_Sum1 - rtb_Product7) + rtb_u;

  /* RateTransition: '<Root>/Rate Transition60' */
  if (Inverter_000_test_M->Timing.RateInteraction.TID0_1) {
    Inverter_000_test_B.RateTransition60[0] = rtb_Sum1_p;
    Inverter_000_test_B.RateTransition60[1] = rtb_Sum4_p;
    Inverter_000_test_B.RateTransition60[2] = rtb_Sum5;
  }

  /* End of RateTransition: '<Root>/Rate Transition60' */

  /* RelationalOperator: '<Root>/Relational Operator2' incorporates:
   *  Constant: '<Root>/Constant3'
   */
  Inverter_000_test_B.RelationalOperator2[0] = (rtb_Sum1_p >
    Inverter_000_test_P.Constant3_Value);
  Inverter_000_test_B.RelationalOperator2[1] = (rtb_Sum4_p >
    Inverter_000_test_P.Constant3_Value);
  Inverter_000_test_B.RelationalOperator2[2] = (rtb_Sum5 >
    Inverter_000_test_P.Constant3_Value);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output' */
  {
    if (Inverter_000_test_B.RelationalOperator2[0])
      GpioDataRegs.GPBSET.bit.GPIO61 = 1;
    else
      GpioDataRegs.GPBCLEAR.bit.GPIO61 = 1;
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  {
    if (Inverter_000_test_B.RelationalOperator2[1])
      GpioDataRegs.GPBSET.bit.GPIO63 = 1;
    else
      GpioDataRegs.GPBCLEAR.bit.GPIO63 = 1;
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  {
    if (Inverter_000_test_B.RelationalOperator2[2])
      GpioDataRegs.GPCSET.bit.GPIO66 = 1;
    else
      GpioDataRegs.GPCCLEAR.bit.GPIO66 = 1;
  }

  /* DataTypeConversion: '<Root>/Data Type Conversion2' */
  rtb_DataTypeConversion2[0] = (real32_T)rtb_Sum1_p * 0.0009765625F;
  rtb_DataTypeConversion2[1] = (real32_T)rtb_Sum4_p * 0.0009765625F;
  rtb_DataTypeConversion2[2] = (real32_T)rtb_Sum5 * 0.0009765625F;

  /* RateTransition: '<Root>/Rate Transition5' */
  if (Inverter_000_test_M->Timing.RateInteraction.TID0_1) {
    Inverter_000_test_B.RateTransition5[0] = rtb_DataTypeConversion2[0];
    Inverter_000_test_B.RateTransition5[1] = rtb_DataTypeConversion2[1];
    Inverter_000_test_B.RateTransition5[2] = rtb_DataTypeConversion2[2];
  }

  /* End of RateTransition: '<Root>/Rate Transition5' */

  /* MATLABSystem: '<Root>/DAC2' incorporates:
   *  Constant: '<Root>/Constant'
   */
  tmp = rt_roundd_snf(Inverter_000_test_P.Constant_Value);
  if (tmp < 65536.0) {
    if (tmp >= 0.0) {
      tmp_0 = (uint16_T)tmp;
    } else {
      tmp_0 = 0U;
    }
  } else {
    tmp_0 = MAX_uint16_T;
  }

  MW_C2000DACSat(2U, tmp_0);

  /* End of MATLABSystem: '<Root>/DAC2' */
}

/* Model step function for TID1 */
void Inverter_000_test_step1(void)     /* Sample time: [0.0001s, 0.0s] */
{
  /* local block i/o variables */
  real32_T rtb_Product19;
  int32_T rtb_IQNIQN;
  int32_T rtb_IQNIQN1;
  int32_T rtb_IQNIQN2;
  int64_T rtb_Sum;
  int64_T rtb_PhaseB;
  int32_T rtb_MinMax1;
  int32_T rtb_Saturation4[3];
  real32_T tmp;
  uint16_T tmp_0;

  /* Saturate: '<Root>/Saturation4' */
  if (Inverter_000_test_B.RateTransition60[0] >
      Inverter_000_test_P.Saturation4_UpperSat) {
    rtb_Saturation4[0] = Inverter_000_test_P.Saturation4_UpperSat;
  } else if (Inverter_000_test_B.RateTransition60[0] <
             Inverter_000_test_P.Saturation4_LowerSat) {
    rtb_Saturation4[0] = Inverter_000_test_P.Saturation4_LowerSat;
  } else {
    rtb_Saturation4[0] = Inverter_000_test_B.RateTransition60[0];
  }

  if (Inverter_000_test_B.RateTransition60[1] >
      Inverter_000_test_P.Saturation4_UpperSat) {
    rtb_Saturation4[1] = Inverter_000_test_P.Saturation4_UpperSat;
  } else if (Inverter_000_test_B.RateTransition60[1] <
             Inverter_000_test_P.Saturation4_LowerSat) {
    rtb_Saturation4[1] = Inverter_000_test_P.Saturation4_LowerSat;
  } else {
    rtb_Saturation4[1] = Inverter_000_test_B.RateTransition60[1];
  }

  if (Inverter_000_test_B.RateTransition60[2] >
      Inverter_000_test_P.Saturation4_UpperSat) {
    rtb_Saturation4[2] = Inverter_000_test_P.Saturation4_UpperSat;
  } else if (Inverter_000_test_B.RateTransition60[2] <
             Inverter_000_test_P.Saturation4_LowerSat) {
    rtb_Saturation4[2] = Inverter_000_test_P.Saturation4_LowerSat;
  } else {
    rtb_Saturation4[2] = Inverter_000_test_B.RateTransition60[2];
  }

  /* End of Saturate: '<Root>/Saturation4' */

  /* Saturate: '<Root>/Saturation5' incorporates:
   *  Constant: '<Root>/Constant8'
   */
  if (Inverter_000_test_P.Constant8_Value >
      Inverter_000_test_P.Saturation5_UpperSat) {
    rtb_MinMax1 = Inverter_000_test_P.Saturation5_UpperSat;
  } else if (Inverter_000_test_P.Constant8_Value <
             Inverter_000_test_P.Saturation5_LowerSat) {
    rtb_MinMax1 = Inverter_000_test_P.Saturation5_LowerSat;
  } else {
    rtb_MinMax1 = Inverter_000_test_P.Constant8_Value;
  }

  /* End of Saturate: '<Root>/Saturation5' */

  /* Gain: '<S2>/Gain' */
  rtb_Product19 = (real32_T)Inverter_000_test_P.Gain_Gain * 4.65661287E-10F *
    ((real32_T)rtb_MinMax1 * 0.0009765625F);

  /* S-Function (stiiqmath_iq): '<S2>/Float to IQN1' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S2>/Float to IQN1' */
  {
    rtb_MinMax1 = _IQ10 (rtb_Product19);
  }

  /* S-Function (stiiqmath_iqdiv): '<S2>/IQN // IQN' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S2>/IQN // IQN' */
  {
    rtb_IQNIQN = _IQ10div (rtb_Saturation4[0], rtb_MinMax1);
  }

  /* S-Function (stiiqmath_iqdiv): '<S2>/IQN // IQN1' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S2>/IQN // IQN1' */
  {
    rtb_IQNIQN1 = _IQ10div (rtb_Saturation4[1], rtb_MinMax1);
  }

  /* S-Function (stiiqmath_iqdiv): '<S2>/IQN // IQN2' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S2>/IQN // IQN2' */
  {
    rtb_IQNIQN2 = _IQ10div (rtb_Saturation4[2], rtb_MinMax1);
  }

  /* MinMax: '<S5>/MinMax' */
  rtb_MinMax1 = rtb_IQNIQN;
  if (!(rtb_IQNIQN < rtb_IQNIQN1)) {
    rtb_MinMax1 = rtb_IQNIQN1;
  }

  if (!(rtb_MinMax1 < rtb_IQNIQN2)) {
    rtb_MinMax1 = rtb_IQNIQN2;
  }

  /* End of MinMax: '<S5>/MinMax' */

  /* Gain: '<S5>/Gain' */
  rtb_PhaseB = (int64_T)Inverter_000_test_P.Gain_Gain_h * rtb_MinMax1;

  /* MinMax: '<S5>/MinMax1' */
  rtb_MinMax1 = rtb_IQNIQN;
  if (!(rtb_IQNIQN > rtb_IQNIQN1)) {
    rtb_MinMax1 = rtb_IQNIQN1;
  }

  if (!(rtb_MinMax1 > rtb_IQNIQN2)) {
    rtb_MinMax1 = rtb_IQNIQN2;
  }

  /* End of MinMax: '<S5>/MinMax1' */

  /* Sum: '<S5>/Sum' incorporates:
   *  Gain: '<S5>/Gain1'
   */
  rtb_Sum = (int64_T)Inverter_000_test_P.Gain1_Gain * rtb_MinMax1 + rtb_PhaseB;

  /* Sum: '<S2>/Add17' */
  rtb_PhaseB = ((int64_T)rtb_IQNIQN1 << 32U) + rtb_Sum;

  /* MATLABSystem: '<Root>/DAC' incorporates:
   *  Bias: '<Root>/Bias1'
   */
  tmp = rt_roundf_snf(Inverter_000_test_B.RateTransition5[1] +
                      Inverter_000_test_P.Bias1_Bias);
  if (tmp < 65536.0F) {
    if (tmp >= 0.0F) {
      tmp_0 = (uint16_T)tmp;
    } else {
      tmp_0 = 0U;
    }
  } else {
    tmp_0 = MAX_uint16_T;
  }

  MW_C2000DACSat(0U, tmp_0);

  /* End of MATLABSystem: '<Root>/DAC' */

  /* Product: '<S1>/Product21' incorporates:
   *  Constant: '<S1>/Constant13'
   *  Constant: '<S1>/Constant14'
   *  Constant: '<S1>/Constant15'
   *  Product: '<S1>/Product20'
   *  Sum: '<S1>/Add15'
   *  Sum: '<S2>/Add16'
   */
  rtb_Product19 = ((real32_T)(((int64_T)rtb_IQNIQN << 32U) + rtb_Sum) *
                   2.27373675E-13F + Inverter_000_test_P.Constant15_Value) *
    Inverter_000_test_P.Constant13_Value_a *
    Inverter_000_test_P.Constant14_Value_m;

  /* S-Function (c2802xpwm): '<S1>/ePWM' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM5 --*/
  {
    EPwm5Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product19);
  }

  /*-- Update CMPB value for ePWM5 --*/
  {
    EPwm5Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product19);
  }

  EPwm5Regs.DBRED.bit.DBRED = Inverter_000_test_P.Constant2_Value;
  EPwm5Regs.DBFED.bit.DBFED = Inverter_000_test_P.Constant2_Value;

  /* Product: '<S1>/Product17' incorporates:
   *  Constant: '<S1>/Constant13'
   *  Constant: '<S1>/Constant14'
   *  Constant: '<S1>/Constant15'
   *  Product: '<S1>/Product16'
   *  Sum: '<S1>/Add13'
   *  Sum: '<S2>/Add18'
   */
  rtb_Product19 = ((real32_T)(((int64_T)rtb_IQNIQN2 << 32U) + rtb_Sum) *
                   2.27373675E-13F + Inverter_000_test_P.Constant15_Value) *
    Inverter_000_test_P.Constant13_Value_a *
    Inverter_000_test_P.Constant14_Value_m;

  /* S-Function (c2802xpwm): '<S1>/ePWM1' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM3 --*/
  {
    EPwm3Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product19);
  }

  /*-- Update CMPB value for ePWM3 --*/
  {
    EPwm3Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product19);
  }

  EPwm3Regs.DBRED.bit.DBRED = Inverter_000_test_P.Constant2_Value;
  EPwm3Regs.DBFED.bit.DBFED = Inverter_000_test_P.Constant2_Value;

  /* Product: '<S1>/Product15' incorporates:
   *  Constant: '<S1>/Constant13'
   *  Constant: '<S1>/Constant14'
   *  Constant: '<S1>/Constant15'
   *  Product: '<S1>/Product'
   *  Sum: '<S1>/Add'
   */
  rtb_Product19 = ((real32_T)rtb_PhaseB * 2.27373675E-13F +
                   Inverter_000_test_P.Constant15_Value) *
    Inverter_000_test_P.Constant13_Value_a *
    Inverter_000_test_P.Constant14_Value_m;

  /* S-Function (c2802xpwm): '<S1>/ePWM2' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM6 --*/
  {
    EPwm6Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product19);
  }

  /*-- Update CMPB value for ePWM6 --*/
  {
    EPwm6Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product19);
  }

  EPwm6Regs.DBRED.bit.DBRED = Inverter_000_test_P.Constant2_Value;
  EPwm6Regs.DBFED.bit.DBFED = Inverter_000_test_P.Constant2_Value;

  /* Product: '<S1>/Product19' incorporates:
   *  Constant: '<S1>/Constant13'
   *  Constant: '<S1>/Constant14'
   *  Constant: '<S1>/Constant15'
   *  Product: '<S1>/Product18'
   *  Sum: '<S1>/Add14'
   */
  rtb_Product19 = ((real32_T)rtb_Sum * 2.27373675E-13F +
                   Inverter_000_test_P.Constant15_Value) *
    Inverter_000_test_P.Constant13_Value_a *
    Inverter_000_test_P.Constant14_Value_m;

  /* S-Function (c2802xpwm): '<S1>/ePWM3' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM4 --*/
  {
    EPwm4Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product19);
  }

  /*-- Update CMPB value for ePWM4 --*/
  {
    EPwm4Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product19);
  }

  EPwm4Regs.DBRED.bit.DBRED = Inverter_000_test_P.Constant2_Value;
  EPwm4Regs.DBFED.bit.DBFED = Inverter_000_test_P.Constant2_Value;

  /* MATLABSystem: '<Root>/DAC1' incorporates:
   *  Bias: '<Root>/Bias2'
   *  DataTypeConversion: '<Root>/Data Type Conversion3'
   *  Gain: '<Root>/Gain2'
   */
  tmp = rt_roundf_snf((real32_T)rtb_PhaseB * 2.27373675E-13F *
                      Inverter_000_test_P.Gain2_Gain_f +
                      Inverter_000_test_P.Bias2_Bias);
  if (tmp < 65536.0F) {
    if (tmp >= 0.0F) {
      tmp_0 = (uint16_T)tmp;
    } else {
      tmp_0 = 0U;
    }
  } else {
    tmp_0 = MAX_uint16_T;
  }

  MW_C2000DACSat(1U, tmp_0);

  /* End of MATLABSystem: '<Root>/DAC1' */

  /* Update for RateTransition: '<Root>/Rate Transition1' incorporates:
   *  Constant: '<Root>/Constant14'
   */
  Inverter_000_test_DW.RateTransition1_Buffer0 =
    Inverter_000_test_P.Constant14_Value_mo;
}

/* Model initialize function */
void Inverter_000_test_initialize(void)
{
  /* Registration code */

  /* initialize real-time model */
  (void) memset((void *)Inverter_000_test_M, 0,
                sizeof(RT_MODEL_Inverter_000_test_T));

  /* block I/O */
  (void) memset(((void *) &Inverter_000_test_B), 0,
                sizeof(B_Inverter_000_test_T));

  /* states (dwork) */
  (void) memset((void *)&Inverter_000_test_DW, 0,
                sizeof(DW_Inverter_000_test_T));

  /* Start for RateTransition: '<Root>/Rate Transition1' */
  Inverter_000_test_B.RateTransition1 =
    Inverter_000_test_P.RateTransition1_InitialConditio;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output' */
  EALLOW;
  GpioCtrlRegs.GPBMUX2.all &= 0xF3FFFFFF;
  GpioCtrlRegs.GPBDIR.all |= 0x20000000;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  EALLOW;
  GpioCtrlRegs.GPBMUX2.all &= 0x3FFFFFFF;
  GpioCtrlRegs.GPBDIR.all |= 0x80000000;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  EALLOW;
  GpioCtrlRegs.GPCMUX1.all &= 0xFFFFFFCF;
  GpioCtrlRegs.GPCDIR.all |= 0x4;
  EDIS;

  /* Start for MATLABSystem: '<Root>/DAC' */
  MW_ConfigureDACA();

  /* Start for S-Function (c2802xpwm): '<S1>/ePWM' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM5 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM5 modules ***/
  {
    /*  // Time Base Control Register
       EPwm5Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm5Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm5Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm5Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm5Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm5Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm5Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm5Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm5Regs.TBCTL.all = (EPwm5Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm5Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm5Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm5Regs.TBPHS.all = (EPwm5Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm5Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm5Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm5Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm5Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm5Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm5Regs.CMPCTL.all = (EPwm5Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm5Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm5Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm5Regs.CMPCTL2.all = (EPwm5Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm5Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm5Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm5Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm5Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm5Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm5Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm5Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm5Regs.AQSFRC.all = (EPwm5Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm5Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm5Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm5Regs.AQCSFRC.all = (EPwm5Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm5Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm5Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm5Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm5Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm5Regs.DBCTL.all = (EPwm5Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm5Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm5Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm5Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm5Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm5Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm5Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM5SOCA Period Select

       EPwm5Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm5Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm5Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm5Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM5SOCB Period Select
       EPwm5Regs.ETSEL.bit.INTEN                = 0;          // EPWM5INTn Enable
       EPwm5Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm5Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm5Regs.ETPS.bit.INTPRD                = 1;          // EPWM5INTn Period Select
     */
    EPwm5Regs.ETSEL.all = (EPwm5Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm5Regs.ETPS.all = (EPwm5Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm5Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm5Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm5Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm5Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm5Regs.PCCTL.all = (EPwm5Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm5Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm5Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM5A
       EPwm5Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM5B
       EPwm5Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM5A action on DCAEVT1
       EPwm5Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM5A action on DCAEVT2
       EPwm5Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM5B action on DCBEVT1
       EPwm5Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM5B action on DCBEVT2
     */
    EPwm5Regs.TZCTL.all = (EPwm5Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm5Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm5Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm5Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm5Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm5Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm5Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm5Regs.TZEINT.all = (EPwm5Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm5Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm5Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm5Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm5Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm5Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm5Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm5Regs.DCACTL.all = (EPwm5Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm5Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm5Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm5Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm5Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm5Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm5Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm5Regs.DCBCTL.all = (EPwm5Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm5Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm5Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm5Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm5Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm5Regs.DCTRIPSEL.all = (EPwm5Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm5Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm5Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm5Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm5Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm5Regs.TZDCSEL.all = (EPwm5Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm5Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm5Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm5Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm5Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm5Regs.DCFCTL.all = (EPwm5Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm5Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm5Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm5Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm5Regs.DCCAPCTL.all = (EPwm5Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm5Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm5Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm5Regs.HRCNFG.all = (EPwm5Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm5Regs.EPWMXLINK.bit.TBPRDLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPALINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPBLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPCLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPDLINK = 4;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S1>/ePWM1' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM3 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM3 modules ***/
  {
    /*  // Time Base Control Register
       EPwm3Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm3Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm3Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm3Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm3Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm3Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm3Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm3Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm3Regs.TBCTL.all = (EPwm3Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm3Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm3Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm3Regs.TBPHS.all = (EPwm3Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm3Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm3Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm3Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm3Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm3Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm3Regs.CMPCTL.all = (EPwm3Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm3Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm3Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm3Regs.CMPCTL2.all = (EPwm3Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm3Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm3Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm3Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm3Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm3Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm3Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm3Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm3Regs.AQSFRC.all = (EPwm3Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm3Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm3Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm3Regs.AQCSFRC.all = (EPwm3Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm3Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm3Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm3Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm3Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm3Regs.DBCTL.all = (EPwm3Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm3Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm3Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm3Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm3Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm3Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm3Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM3SOCA Period Select

       EPwm3Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm3Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm3Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm3Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM3SOCB Period Select
       EPwm3Regs.ETSEL.bit.INTEN                = 0;          // EPWM3INTn Enable
       EPwm3Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm3Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm3Regs.ETPS.bit.INTPRD                = 1;          // EPWM3INTn Period Select
     */
    EPwm3Regs.ETSEL.all = (EPwm3Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm3Regs.ETPS.all = (EPwm3Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm3Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm3Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm3Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm3Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm3Regs.PCCTL.all = (EPwm3Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm3Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm3Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM3A
       EPwm3Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM3B
       EPwm3Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM3A action on DCAEVT1
       EPwm3Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM3A action on DCAEVT2
       EPwm3Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM3B action on DCBEVT1
       EPwm3Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM3B action on DCBEVT2
     */
    EPwm3Regs.TZCTL.all = (EPwm3Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm3Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm3Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm3Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm3Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm3Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm3Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm3Regs.TZEINT.all = (EPwm3Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm3Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm3Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm3Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm3Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm3Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm3Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm3Regs.DCACTL.all = (EPwm3Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm3Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm3Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm3Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm3Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm3Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm3Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm3Regs.DCBCTL.all = (EPwm3Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm3Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm3Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm3Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm3Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm3Regs.DCTRIPSEL.all = (EPwm3Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm3Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm3Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm3Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm3Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm3Regs.TZDCSEL.all = (EPwm3Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm3Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm3Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm3Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm3Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm3Regs.DCFCTL.all = (EPwm3Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm3Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm3Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm3Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm3Regs.DCCAPCTL.all = (EPwm3Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm3Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm3Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm3Regs.HRCNFG.all = (EPwm3Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm3Regs.EPWMXLINK.bit.TBPRDLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPALINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPBLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPCLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPDLINK = 2;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S1>/ePWM2' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM6 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM6 modules ***/
  {
    /*  // Time Base Control Register
       EPwm6Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm6Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm6Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm6Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm6Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm6Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm6Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm6Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm6Regs.TBCTL.all = (EPwm6Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm6Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm6Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm6Regs.TBPHS.all = (EPwm6Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm6Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm6Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm6Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm6Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm6Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm6Regs.CMPCTL.all = (EPwm6Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm6Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm6Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm6Regs.CMPCTL2.all = (EPwm6Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm6Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm6Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm6Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm6Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm6Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm6Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm6Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm6Regs.AQSFRC.all = (EPwm6Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm6Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm6Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm6Regs.AQCSFRC.all = (EPwm6Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm6Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm6Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm6Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm6Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm6Regs.DBCTL.all = (EPwm6Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm6Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm6Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm6Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm6Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm6Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm6Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM6SOCA Period Select

       EPwm6Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm6Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm6Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm6Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM6SOCB Period Select
       EPwm6Regs.ETSEL.bit.INTEN                = 0;          // EPWM6INTn Enable
       EPwm6Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm6Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm6Regs.ETPS.bit.INTPRD                = 1;          // EPWM6INTn Period Select
     */
    EPwm6Regs.ETSEL.all = (EPwm6Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm6Regs.ETPS.all = (EPwm6Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm6Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm6Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm6Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm6Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm6Regs.PCCTL.all = (EPwm6Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm6Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm6Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM6A
       EPwm6Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM6B
       EPwm6Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM6A action on DCAEVT1
       EPwm6Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM6A action on DCAEVT2
       EPwm6Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM6B action on DCBEVT1
       EPwm6Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM6B action on DCBEVT2
     */
    EPwm6Regs.TZCTL.all = (EPwm6Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm6Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm6Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm6Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm6Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm6Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm6Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm6Regs.TZEINT.all = (EPwm6Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm6Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm6Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm6Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm6Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm6Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm6Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm6Regs.DCACTL.all = (EPwm6Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm6Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm6Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm6Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm6Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm6Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm6Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm6Regs.DCBCTL.all = (EPwm6Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm6Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm6Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm6Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm6Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm6Regs.DCTRIPSEL.all = (EPwm6Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm6Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm6Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm6Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm6Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm6Regs.TZDCSEL.all = (EPwm6Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm6Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm6Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm6Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm6Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm6Regs.DCFCTL.all = (EPwm6Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm6Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm6Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm6Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm6Regs.DCCAPCTL.all = (EPwm6Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm6Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm6Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm6Regs.HRCNFG.all = (EPwm6Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm6Regs.EPWMXLINK.bit.TBPRDLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPALINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPBLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPCLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPDLINK = 5;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S1>/ePWM3' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM4 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM4 modules ***/
  {
    /*  // Time Base Control Register
       EPwm4Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm4Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm4Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm4Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm4Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm4Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm4Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm4Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm4Regs.TBCTL.all = (EPwm4Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm4Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm4Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm4Regs.TBPHS.all = (EPwm4Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm4Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm4Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm4Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm4Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm4Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm4Regs.CMPCTL.all = (EPwm4Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm4Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm4Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm4Regs.CMPCTL2.all = (EPwm4Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm4Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm4Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm4Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm4Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm4Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm4Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm4Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm4Regs.AQSFRC.all = (EPwm4Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm4Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm4Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm4Regs.AQCSFRC.all = (EPwm4Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm4Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm4Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm4Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm4Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm4Regs.DBCTL.all = (EPwm4Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm4Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm4Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm4Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm4Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm4Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm4Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM4SOCA Period Select

       EPwm4Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm4Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm4Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm4Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM4SOCB Period Select
       EPwm4Regs.ETSEL.bit.INTEN                = 0;          // EPWM4INTn Enable
       EPwm4Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm4Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm4Regs.ETPS.bit.INTPRD                = 1;          // EPWM4INTn Period Select
     */
    EPwm4Regs.ETSEL.all = (EPwm4Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm4Regs.ETPS.all = (EPwm4Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm4Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm4Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm4Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm4Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm4Regs.PCCTL.all = (EPwm4Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm4Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm4Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM4A
       EPwm4Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM4B
       EPwm4Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM4A action on DCAEVT1
       EPwm4Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM4A action on DCAEVT2
       EPwm4Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM4B action on DCBEVT1
       EPwm4Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM4B action on DCBEVT2
     */
    EPwm4Regs.TZCTL.all = (EPwm4Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm4Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm4Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm4Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm4Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm4Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm4Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm4Regs.TZEINT.all = (EPwm4Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm4Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm4Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm4Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm4Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm4Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm4Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm4Regs.DCACTL.all = (EPwm4Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm4Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm4Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm4Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm4Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm4Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm4Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm4Regs.DCBCTL.all = (EPwm4Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm4Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm4Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm4Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm4Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm4Regs.DCTRIPSEL.all = (EPwm4Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm4Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm4Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm4Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm4Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm4Regs.TZDCSEL.all = (EPwm4Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm4Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm4Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm4Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm4Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm4Regs.DCFCTL.all = (EPwm4Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm4Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm4Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm4Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm4Regs.DCCAPCTL.all = (EPwm4Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm4Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm4Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm4Regs.HRCNFG.all = (EPwm4Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm4Regs.EPWMXLINK.bit.TBPRDLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPALINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPBLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPCLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPDLINK = 3;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for MATLABSystem: '<Root>/DAC1' */
  MW_ConfigureDACB();

  /* Start for MATLABSystem: '<Root>/DAC2' */
  MW_ConfigureDACC();

  /* InitializeConditions for RateTransition: '<Root>/Rate Transition1' */
  Inverter_000_test_DW.RateTransition1_Buffer0 =
    Inverter_000_test_P.RateTransition1_InitialConditio;

  /* InitializeConditions for UnitDelay: '<S12>/Unit Delay' */
  Inverter_000_test_DW.UnitDelay_DSTATE =
    Inverter_000_test_P.UnitDelay_InitialCondition;
}

/* Model terminate function */
void Inverter_000_test_terminate(void)
{
  /* (no terminate code required) */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
