/*
 * File: Inverter_001.c
 *
 * Code generated for Simulink model 'Inverter_001'.
 *
 * Model version                  : 1.139
 * Simulink Coder version         : 8.14 (R2018a) 06-Feb-2018
 * C/C++ source code generated on : Wed Apr 14 17:37:41 2021
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Texas Instruments->C2000
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Inverter_001.h"
#include "Inverter_001_private.h"

/* Block signals (default storage) */
B_Inverter_001_T Inverter_001_B;

/* Block states (default storage) */
DW_Inverter_001_T Inverter_001_DW;

/* Real-time model */
RT_MODEL_Inverter_001_T Inverter_001_M_;
RT_MODEL_Inverter_001_T *const Inverter_001_M = &Inverter_001_M_;
static void rate_monotonic_scheduler(void);
static uint16_T adcDInitFlag = 0;
static uint16_T adcAInitFlag = 0;
static uint16_T adcCInitFlag = 0;

/*
 * Set which subrates need to run this base step (base rate always runs).
 * This function must be called prior to calling the model step function
 * in order to "remember" which rates need to run this base step.  The
 * buffering of events allows for overlapping preemption.
 */
void Inverter_001_SetEventsForThisBaseStep(boolean_T *eventFlags)
{
  /* Task runs when its counter is zero, computed via rtmStepTask macro */
  eventFlags[1] = ((boolean_T)rtmStepTask(Inverter_001_M, 1));
  eventFlags[2] = ((boolean_T)rtmStepTask(Inverter_001_M, 2));
  eventFlags[3] = ((boolean_T)rtmStepTask(Inverter_001_M, 3));
}

/*
 *   This function updates active task flag for each subrate
 * and rate transition flags for tasks that exchange data.
 * The function assumes rate-monotonic multitasking scheduler.
 * The function must be called at model base rate so that
 * the generated code self-manages all its subrates and rate
 * transition flags.
 */
static void rate_monotonic_scheduler(void)
{
  /* To ensure a deterministic data transfer between two rates,
   * data is transferred at the priority of a fast task and the frequency
   * of the slow task.  The following flags indicate when the data transfer
   * happens.  That is, a rate interaction flag is set true when both rates
   * will run, and false otherwise.
   */

  /* tid 0 shares data with slower tid rates: 1, 3 */
  Inverter_001_M->Timing.RateInteraction.TID0_1 =
    (Inverter_001_M->Timing.TaskCounters.TID[1] == 0);
  Inverter_001_M->Timing.RateInteraction.TID0_3 =
    (Inverter_001_M->Timing.TaskCounters.TID[3] == 0);

  /* Compute which subrates run during the next base time step.  Subrates
   * are an integer multiple of the base rate counter.  Therefore, the subtask
   * counter is reset when it reaches its limit (zero means run).
   */
  (Inverter_001_M->Timing.TaskCounters.TID[1])++;
  if ((Inverter_001_M->Timing.TaskCounters.TID[1]) > 1) {/* Sample time: [0.0001s, 0.0s] */
    Inverter_001_M->Timing.TaskCounters.TID[1] = 0;
  }

  (Inverter_001_M->Timing.TaskCounters.TID[2])++;
  if ((Inverter_001_M->Timing.TaskCounters.TID[2]) > 3) {/* Sample time: [0.0002s, 0.0s] */
    Inverter_001_M->Timing.TaskCounters.TID[2] = 0;
  }

  (Inverter_001_M->Timing.TaskCounters.TID[3])++;
  if ((Inverter_001_M->Timing.TaskCounters.TID[3]) > 1999) {/* Sample time: [0.1s, 0.0s] */
    Inverter_001_M->Timing.TaskCounters.TID[3] = 0;
  }
}

real32_T rt_roundf_snf(real32_T u)
{
  real32_T y;
  if (fabsf(u) < 8.388608E+6F) {
    if (u >= 0.5F) {
      y = (real32_T)floor(u + 0.5F);
    } else if (u > -0.5F) {
      y = u * 0.0F;
    } else {
      y = (real32_T)ceil(u - 0.5F);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model step function for TID0 */
void Inverter_001_step0(void)          /* Sample time: [5.0E-5s, 0.0s] */
{
  /* local block i/o variables */
  int32_T rtb_FloattoIQN4[3];
  int32_T rtb_FloattoIQN[3];
  int32_T rtb_FloattoIQN4_g[9];
  int32_T rtb_HighPassFilterOutput_m;
  int32_T rtb_HighPassFilterOutput_ei;
  int32_T rtb_HighPassFilterOutput_hd;
  int32_T rtb_HighPassFilterOutput_au;
  int32_T rtb_HighPassFilterOutput_hi;
  int32_T rtb_HighPassFilterOutput;
  int32_T rtb_HighPassFilterOutput_pm;
  int32_T rtb_HighPassFilterOutput_a;
  int32_T rtb_HighPassFilterOutput_l1;
  int32_T rtb_Sum5_o;
  int32_T rtb_Sum4_p;
  int32_T rtb_Sum1_p;
  int32_T rtb_Sum1;
  real32_T rtb_Add7;
  real32_T rtb_Add3;
  real32_T rtb_Add4;
  real32_T rtb_Add5;
  real32_T rtb_Add16;
  real32_T rtb_Add9;
  real32_T rtb_Add10;
  real32_T rtb_Add11;
  real32_T rtb_DataTypeConversion2[3];
  real32_T rtb_DataTypeConversion13;
  real32_T rtb_TmpSignalConversionAtFloatt[9];

  {                                    /* Sample time: [5.0E-5s, 0.0s] */
    rate_monotonic_scheduler();
  }

  /* RateTransition: '<Root>/TmpRTBAtConstant62Outport1' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtConstant62Outport1 =
      Inverter_001_DW.TmpRTBAtConstant62Outport1_Buff;

    /* RateTransition: '<S2>/TmpRTBAtAdd11Inport2' */
    Inverter_001_B.TmpRTBAtAdd11Inport2 =
      Inverter_001_DW.TmpRTBAtAdd11Inport2_Buffer0;
  }

  /* End of RateTransition: '<Root>/TmpRTBAtConstant62Outport1' */

  /* RateTransition: '<Root>/Rate Transition1' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition1 = Inverter_001_DW.RateTransition1_Buffer0;
  }

  /* End of RateTransition: '<Root>/Rate Transition1' */

  /* Gain: '<S6>/Gain3' */
  rtb_DataTypeConversion13 = Inverter_001_P.Gain3_Gain *
    Inverter_001_B.RateTransition1;

  /* S-Function (stiiqmath_iq): '<S6>/Float to IQN2' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S6>/Float to IQN2' */
  {
    rtb_HighPassFilterOutput_au = _IQ10 (rtb_DataTypeConversion13);
  }

  /* Product: '<S6>/Product5' incorporates:
   *  Constant: '<S6>/Constant10'
   *  Constant: '<S6>/Constant13'
   *  Constant: '<S6>/Constant14'
   */
  rtb_Add11 = (real32_T)rtb_HighPassFilterOutput_au * 0.0009765625F;
  rtb_DataTypeConversion2[0] = rtb_Add11 * Inverter_001_P.Constant13_Value_c;
  rtb_DataTypeConversion2[1] = rtb_Add11 * Inverter_001_P.Constant14_Value_p;
  rtb_DataTypeConversion2[2] = rtb_Add11 * Inverter_001_P.Constant10_Value;

  /* S-Function (stiiqmath_iq): '<S6>/Float to IQN' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S6>/Float to IQN' */
  {
    rtb_FloattoIQN[0] = _IQ10 (rtb_DataTypeConversion2[0]);
    rtb_FloattoIQN[1] = _IQ10 (rtb_DataTypeConversion2[1]);
    rtb_FloattoIQN[2] = _IQ10 (rtb_DataTypeConversion2[2]);
  }

  /* S-Function (scheckfractionlength): '<S33>/ ' */
  rtb_HighPassFilterOutput_au = rtb_FloattoIQN[0];

  /* Product: '<S34>/Product1' incorporates:
   *  Constant: '<S6>/Constant11'
   *  S-Function (scheckfractionlength): '<S34>/ '
   */
  rtb_Sum1 = Inverter_001_P.Constant11_Value;

  /* S-Function (scheckfractionlength): '<S34>/ 1' incorporates:
   *  Constant: '<S6>/Constant8'
   */
  rtb_HighPassFilterOutput = Inverter_001_P.Constant8_Value_e;

  /* S-Function (scheckfractionlength): '<S34>/ 2' incorporates:
   *  Constant: '<S6>/Constant9'
   */
  rtb_HighPassFilterOutput_pm = Inverter_001_P.Constant9_Value;

  /* Sum: '<S34>/Sum2' incorporates:
   *  UnitDelay: '<S34>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_lw += rtb_Sum1;

  /* Switch: '<S36>/Switch' incorporates:
   *  Constant: '<S36>/1'
   *  RelationalOperator: '<S36>/Relational Operator'
   *  Sum: '<S36>/Sum2'
   */
  if (Inverter_001_DW.UnitDelay_DSTATE_lw > Inverter_001_P.u_Value) {
    Inverter_001_DW.UnitDelay_DSTATE_lw -= Inverter_001_P.u_Value;
  }

  /* End of Switch: '<S36>/Switch' */

  /* Switch: '<S36>/Switch1' incorporates:
   *  Constant: '<S36>/-1'
   *  Constant: '<S36>/1'
   *  RelationalOperator: '<S36>/Relational Operator1'
   *  Sum: '<S36>/Sum1'
   *  UnitDelay: '<S34>/Unit Delay'
   */
  if (Inverter_001_DW.UnitDelay_DSTATE_lw < Inverter_001_P.u_Value_e) {
    Inverter_001_DW.UnitDelay_DSTATE_lw += Inverter_001_P.u_Value;
  }

  /* End of Switch: '<S36>/Switch1' */

  /* Product: '<S34>/Product2' incorporates:
   *  UnitDelay: '<S34>/Unit Delay'
   */
  rtb_Sum1 = __IQmpy(Inverter_001_DW.UnitDelay_DSTATE_lw,
                     rtb_HighPassFilterOutput, 29);

  /* Sum: '<S34>/Sum1' */
  rtb_Sum1 += rtb_HighPassFilterOutput_pm;

  /* Switch: '<S37>/Switch2' incorporates:
   *  Constant: '<S37>/1'
   *  RelationalOperator: '<S37>/Relational Operator2'
   *  Sum: '<S37>/Sum4'
   */
  if (rtb_Sum1 > Inverter_001_P.u_Value_f) {
    rtb_Sum1 -= Inverter_001_P.u_Value_f;
  }

  /* End of Switch: '<S37>/Switch2' */

  /* Switch: '<S37>/Switch3' incorporates:
   *  Constant: '<S37>/-1'
   *  Constant: '<S37>/1'
   *  RelationalOperator: '<S37>/Relational Operator3'
   *  Sum: '<S37>/Sum3'
   */
  if (rtb_Sum1 < Inverter_001_P.u_Value_c) {
    rtb_Sum1 += Inverter_001_P.u_Value_f;
  }

  /* End of Switch: '<S37>/Switch3' */

  /* S-Function (stiiqmath_iqtof): '<S6>/IQN to Float3' */

  /* C28x IQmath Library (stiiqmath_iqtof) - '<S6>/IQN to Float3' */
  {
    rtb_DataTypeConversion13 = _IQ29toF (rtb_Sum1);
  }

  /* Gain: '<S6>/Gain2' */
  rtb_DataTypeConversion13 *= Inverter_001_P.Gain2_Gain;

  /* S-Function (stiiqmath_iq): '<S6>/Float to IQN1' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S6>/Float to IQN1' */
  {
    rtb_Sum1 = _IQ10 (rtb_DataTypeConversion13);
  }

  /* S-Function (scheckfractionlength): '<S33>/ 2' */
  rtb_HighPassFilterOutput_pm = rtb_Sum1;

  /* S-Function (stiiqmath_iqtrig): '<S33>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/cos IQN' */
  {
    rtb_HighPassFilterOutput = _IQ10cos(rtb_HighPassFilterOutput_pm);
  }

  /* Product: '<S33>/Product2' */
  rtb_HighPassFilterOutput_hi = __IQmpy(rtb_HighPassFilterOutput_au,
    rtb_HighPassFilterOutput, 10);

  /* S-Function (scheckfractionlength): '<S33>/ 1' */
  rtb_HighPassFilterOutput = rtb_FloattoIQN[1];

  /* S-Function (stiiqmath_iqtrig): '<S33>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/sin IQN' */
  {
    rtb_HighPassFilterOutput_a = _IQ10sin(rtb_HighPassFilterOutput_pm);
  }

  /* Product: '<S33>/Product3' */
  rtb_Sum5_o = __IQmpy(rtb_HighPassFilterOutput, rtb_HighPassFilterOutput_a, 10);

  /* S-Function (scheckfractionlength): '<S33>/ 3' */
  rtb_HighPassFilterOutput_a = rtb_FloattoIQN[2];

  /* Sum: '<S33>/Sum1' */
  rtb_Sum1_p = (rtb_HighPassFilterOutput_hi - rtb_Sum5_o) +
    rtb_HighPassFilterOutput_a;

  /* S-Function (stiiqmath_iq): '<S33>/Float to IQN' incorporates:
   *  Constant: '<S33>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S33>/Float to IQN' */
  {
    rtb_Sum5_o = _IQ10 (Inverter_001_P.Constant_Value);
  }

  /* Sum: '<S33>/Sum3' */
  rtb_HighPassFilterOutput_hi = rtb_HighPassFilterOutput_pm - rtb_Sum5_o;

  /* S-Function (stiiqmath_iqtrig): '<S33>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/cos IQN1' */
  {
    rtb_Sum4_p = _IQ10cos(rtb_HighPassFilterOutput_hi);
  }

  /* Product: '<S33>/Product4' */
  rtb_HighPassFilterOutput_l1 = __IQmpy(rtb_HighPassFilterOutput_au, rtb_Sum4_p,
    10);

  /* S-Function (stiiqmath_iqtrig): '<S33>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/sin IQN1' */
  {
    rtb_Sum4_p = _IQ10sin(rtb_HighPassFilterOutput_hi);
  }

  /* Product: '<S33>/Product5' */
  rtb_HighPassFilterOutput_hi = __IQmpy(rtb_HighPassFilterOutput, rtb_Sum4_p, 10);

  /* Sum: '<S33>/Sum4' */
  rtb_Sum4_p = (rtb_HighPassFilterOutput_l1 - rtb_HighPassFilterOutput_hi) +
    rtb_HighPassFilterOutput_a;

  /* Sum: '<S33>/Sum' */
  rtb_HighPassFilterOutput_l1 = rtb_HighPassFilterOutput_pm + rtb_Sum5_o;

  /* S-Function (stiiqmath_iqtrig): '<S33>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/cos IQN2' */
  {
    rtb_Sum5_o = _IQ10cos(rtb_HighPassFilterOutput_l1);
  }

  /* Product: '<S33>/Product6' */
  rtb_HighPassFilterOutput_pm = __IQmpy(rtb_HighPassFilterOutput_au, rtb_Sum5_o,
    10);

  /* S-Function (stiiqmath_iqtrig): '<S33>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S33>/sin IQN2' */
  {
    rtb_Sum5_o = _IQ10sin(rtb_HighPassFilterOutput_l1);
  }

  /* Product: '<S33>/Product7' */
  rtb_HighPassFilterOutput_l1 = __IQmpy(rtb_HighPassFilterOutput, rtb_Sum5_o, 10);

  /* Sum: '<S33>/Sum5' */
  rtb_Sum5_o = (rtb_HighPassFilterOutput_pm - rtb_HighPassFilterOutput_l1) +
    rtb_HighPassFilterOutput_a;

  /* RateTransition: '<Root>/Rate Transition60' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition60[0] = rtb_Sum1_p;
    Inverter_001_B.RateTransition60[1] = rtb_Sum4_p;
    Inverter_001_B.RateTransition60[2] = rtb_Sum5_o;
  }

  /* End of RateTransition: '<Root>/Rate Transition60' */

  /* RelationalOperator: '<Root>/Relational Operator2' incorporates:
   *  Constant: '<Root>/Constant3'
   */
  Inverter_001_B.RelationalOperator2[0] = (rtb_Sum1_p >
    Inverter_001_P.Constant3_Value);
  Inverter_001_B.RelationalOperator2[1] = (rtb_Sum4_p >
    Inverter_001_P.Constant3_Value);
  Inverter_001_B.RelationalOperator2[2] = (rtb_Sum5_o >
    Inverter_001_P.Constant3_Value);

  /* S-Function (c280xgpio_do): '<Root>/Digital Output' */
  {
    if (Inverter_001_B.RelationalOperator2[0])
      GpioDataRegs.GPBSET.bit.GPIO61 = 1;
    else
      GpioDataRegs.GPBCLEAR.bit.GPIO61 = 1;
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  {
    if (Inverter_001_B.RelationalOperator2[1])
      GpioDataRegs.GPBSET.bit.GPIO63 = 1;
    else
      GpioDataRegs.GPBCLEAR.bit.GPIO63 = 1;
  }

  /* S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  {
    if (Inverter_001_B.RelationalOperator2[2])
      GpioDataRegs.GPCSET.bit.GPIO66 = 1;
    else
      GpioDataRegs.GPCCLEAR.bit.GPIO66 = 1;
  }

  /* Sum: '<S7>/Sum2' incorporates:
   *  UnitDelay: '<S7>/Unit Delay'
   *  UnitDelay: '<S7>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S7>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S7>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_l1 = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE, 10);
  }

  /* S-Function (c2802xadc): '<S2>/ADC2' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcdRegs.ADCSOCFRC1.bit.SOC2 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC2 = (AdcdResultRegs.ADCRESULT2);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion3' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC2;

  /* Sum: '<S2>/Add11' */
  rtb_Add11 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd11Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd10Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd10Inport2 =
      Inverter_001_DW.TmpRTBAtAdd10Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd10Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC3' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcdRegs.ADCSOCFRC1.bit.SOC5 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC3 = (AdcdResultRegs.ADCRESULT5);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion4' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC3;

  /* Sum: '<S2>/Add10' */
  rtb_Add10 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd10Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd9Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd9Inport2 =
      Inverter_001_DW.TmpRTBAtAdd9Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd9Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC4' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcdRegs.ADCSOCFRC1.bit.SOC7 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC4 = (AdcdResultRegs.ADCRESULT7);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion5' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC4;

  /* Sum: '<S2>/Add9' */
  rtb_Add9 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd9Inport2;

  /* RateTransition: '<Root>/TmpRTBAtConstant12Outport1' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtConstant12Outport1 =
      Inverter_001_DW.TmpRTBAtConstant12Outport1_Buff;

    /* RateTransition: '<S2>/TmpRTBAtAdd16Inport2' */
    Inverter_001_B.TmpRTBAtAdd16Inport2 =
      Inverter_001_DW.TmpRTBAtAdd16Inport2_Buffer0;
  }

  /* End of RateTransition: '<Root>/TmpRTBAtConstant12Outport1' */

  /* S-Function (c2802xadc): '<S2>/ADC5' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcaRegs.ADCSOCFRC1.bit.SOC4 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC5 = (AdcaResultRegs.ADCRESULT4);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion16' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC5;

  /* Sum: '<S2>/Add16' */
  rtb_Add16 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd16Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd5Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd5Inport2 =
      Inverter_001_DW.TmpRTBAtAdd5Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd5Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC6' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcaRegs.ADCSOCFRC1.bit.SOC6 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.LoadCurrentIa = (AdcaResultRegs.ADCRESULT6);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion9' */
  rtb_DataTypeConversion13 = Inverter_001_B.LoadCurrentIa;

  /* Sum: '<S2>/Add5' */
  rtb_Add5 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd5Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd4Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd4Inport2 =
      Inverter_001_DW.TmpRTBAtAdd4Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd4Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC7' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdcaRegs.ADCSOCFRC1.bit.SOC8 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.InverterCurrentIc = (AdcaResultRegs.ADCRESULT8);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion11' */
  rtb_DataTypeConversion13 = Inverter_001_B.InverterCurrentIc;

  /* Sum: '<S2>/Add4' */
  rtb_Add4 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd4Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd3Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd3Inport2 =
      Inverter_001_DW.TmpRTBAtAdd3Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd3Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC9' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdccRegs.ADCSOCFRC1.bit.SOC10 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC9 = (AdccResultRegs.ADCRESULT10);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion12' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC9;

  /* Sum: '<S2>/Add3' */
  rtb_Add3 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd3Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd7Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd7Inport2 =
      Inverter_001_DW.TmpRTBAtAdd7Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd7Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC10' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdccRegs.ADCSOCFRC1.bit.SOC11 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC10 = (AdccResultRegs.ADCRESULT11);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion7' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC10;

  /* Sum: '<S2>/Add7' */
  rtb_Add7 = rtb_DataTypeConversion13 + Inverter_001_B.TmpRTBAtAdd7Inport2;

  /* RateTransition: '<S2>/TmpRTBAtAdd2Inport2' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_3) {
    Inverter_001_B.TmpRTBAtAdd2Inport2 =
      Inverter_001_DW.TmpRTBAtAdd2Inport2_Buffer0;
  }

  /* End of RateTransition: '<S2>/TmpRTBAtAdd2Inport2' */

  /* S-Function (c2802xadc): '<S2>/ADC11' */
  {
    /*  Internal Reference Voltage : Fixed scale 0 to 3.3 V range.  */
    /*  External Reference Voltage : Allowable ranges of VREFHI(ADCINA0) = 3.3 and VREFLO(tied to ground) = 0  */
    AdccRegs.ADCSOCFRC1.bit.SOC12 = 1;

    /* Wait for the period of Sampling window and EOC result to be latched after trigger */
    asm(" RPT #75 || NOP");
    Inverter_001_B.ADC11 = (AdccResultRegs.ADCRESULT12);
  }

  /* DataTypeConversion: '<S2>/Data Type Conversion13' */
  rtb_DataTypeConversion13 = Inverter_001_B.ADC11;

  /* SignalConversion: '<Root>/TmpSignal ConversionAtFloat to IQN4Inport1' incorporates:
   *  Product: '<S2>/Product11'
   *  Product: '<S2>/Product12'
   *  Product: '<S2>/Product13'
   *  Product: '<S2>/Product14'
   *  Product: '<S2>/Product16'
   *  Product: '<S2>/Product4'
   *  Product: '<S2>/Product5'
   *  Product: '<S2>/Product6'
   *  Product: '<S2>/Product9'
   *  Sum: '<S2>/Add2'
   */
  rtb_TmpSignalConversionAtFloatt[0] = rtb_Add11 *
    Inverter_001_B.TmpRTBAtConstant62Outport1;
  rtb_TmpSignalConversionAtFloatt[1] = rtb_Add10 *
    Inverter_001_B.TmpRTBAtConstant62Outport1;
  rtb_TmpSignalConversionAtFloatt[2] = rtb_Add9 *
    Inverter_001_B.TmpRTBAtConstant62Outport1;
  rtb_TmpSignalConversionAtFloatt[3] = rtb_Add16 *
    Inverter_001_B.TmpRTBAtConstant12Outport1;
  rtb_TmpSignalConversionAtFloatt[4] = rtb_Add5 *
    Inverter_001_B.TmpRTBAtConstant12Outport1;
  rtb_TmpSignalConversionAtFloatt[5] = rtb_Add4 *
    Inverter_001_B.TmpRTBAtConstant12Outport1;
  rtb_TmpSignalConversionAtFloatt[6] = rtb_Add3 *
    Inverter_001_B.TmpRTBAtConstant12Outport1;
  rtb_TmpSignalConversionAtFloatt[7] = rtb_Add7 *
    Inverter_001_B.TmpRTBAtConstant12Outport1;
  rtb_TmpSignalConversionAtFloatt[8] = (rtb_DataTypeConversion13 +
    Inverter_001_B.TmpRTBAtAdd2Inport2) *
    Inverter_001_B.TmpRTBAtConstant12Outport1;

  /* S-Function (stiiqmath_iq): '<Root>/Float to IQN4' */

  /* C28x IQmath Library (stiiqmath_iq) - '<Root>/Float to IQN4' */
  {
    {
      int_T i1;
      const real32_T *u0 = &rtb_TmpSignalConversionAtFloatt[0];
      int32_T *y0 = &rtb_FloattoIQN4_g[0];
      for (i1=0; i1 < 9; i1++) {
        y0[i1] = _IQ10 (u0[i1]);
      }
    }
  }

  /* DataTypeConversion: '<Root>/Data Type Conversion2' */
  rtb_DataTypeConversion2[0] = (real32_T)rtb_Sum1_p * 0.0009765625F;
  rtb_DataTypeConversion2[1] = (real32_T)rtb_Sum4_p * 0.0009765625F;
  rtb_DataTypeConversion2[2] = (real32_T)rtb_Sum5_o * 0.0009765625F;

  /* RateTransition: '<Root>/Rate Transition5' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition5[0] = rtb_DataTypeConversion2[0];

    /* RateTransition: '<Root>/Rate Transition62' */
    Inverter_001_B.RateTransition62[0] = rtb_FloattoIQN[0];
    Inverter_001_B.RateTransition5[1] = rtb_DataTypeConversion2[1];

    /* RateTransition: '<Root>/Rate Transition62' */
    Inverter_001_B.RateTransition62[1] = rtb_FloattoIQN[1];
    Inverter_001_B.RateTransition5[2] = rtb_DataTypeConversion2[2];

    /* RateTransition: '<Root>/Rate Transition62' */
    Inverter_001_B.RateTransition62[2] = rtb_FloattoIQN[2];
  }

  /* End of RateTransition: '<Root>/Rate Transition5' */

  /* SignalConversion: '<S3>/TmpSignal ConversionAtFloat to IQN4Inport1' incorporates:
   *  Constant: '<S3>/Constant10'
   *  Constant: '<S3>/Constant13'
   *  Constant: '<S3>/Constant14'
   */
  rtb_DataTypeConversion2[0] = Inverter_001_P.Constant13_Value_cs;
  rtb_DataTypeConversion2[1] = Inverter_001_P.Constant14_Value_o;
  rtb_DataTypeConversion2[2] = Inverter_001_P.Constant10_Value_j;

  /* Sum: '<S7>/Sum1' incorporates:
   *  UnitDelay: '<S7>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[0] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_l1
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE = rtb_DataTypeConversion13 < 0.0F ? -(int32_T)
    (uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S7>/Sum3' incorporates:
   *  UnitDelay: '<S7>/Unit Delay'
   */
  rtb_HighPassFilterOutput_l1 = rtb_FloattoIQN4_g[0] -
    Inverter_001_DW.UnitDelay_DSTATE;

  /* Sum: '<S8>/Sum2' incorporates:
   *  UnitDelay: '<S8>/Unit Delay'
   *  UnitDelay: '<S8>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_c * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_k * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_k = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S8>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S8>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_a = _IQ10mpyIQX (Inverter_001_P.Constant2_Value, 10,
      Inverter_001_DW.UnitDelay1_DSTATE_k, 10);
  }

  /* Sum: '<S8>/Sum1' incorporates:
   *  UnitDelay: '<S8>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[1] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_a *
    0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_c = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S8>/Sum3' incorporates:
   *  UnitDelay: '<S8>/Unit Delay'
   */
  rtb_HighPassFilterOutput_a = rtb_FloattoIQN4_g[1] -
    Inverter_001_DW.UnitDelay_DSTATE_c;

  /* Sum: '<S9>/Sum2' incorporates:
   *  UnitDelay: '<S9>/Unit Delay'
   *  UnitDelay: '<S9>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_f * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_j * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_j = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S9>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S9>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_pm = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE_j, 10);
  }

  /* Sum: '<S9>/Sum1' incorporates:
   *  UnitDelay: '<S9>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[2] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_pm
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_f = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S9>/Sum3' incorporates:
   *  UnitDelay: '<S9>/Unit Delay'
   */
  rtb_HighPassFilterOutput_pm = rtb_FloattoIQN4_g[2] -
    Inverter_001_DW.UnitDelay_DSTATE_f;

  /* RateTransition: '<Root>/Rate Transition21' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition21[0] = rtb_HighPassFilterOutput_l1;
    Inverter_001_B.RateTransition21[1] = rtb_HighPassFilterOutput_a;
    Inverter_001_B.RateTransition21[2] = rtb_HighPassFilterOutput_pm;

    /* RateTransition: '<Root>/Rate Transition61' */
    Inverter_001_B.RateTransition61 = rtb_Sum1;
  }

  /* End of RateTransition: '<Root>/Rate Transition21' */

  /* Sum: '<S10>/Sum2' incorporates:
   *  UnitDelay: '<S10>/Unit Delay'
   *  UnitDelay: '<S10>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_g * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_l * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_l = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S10>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S10>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput = _IQ10mpyIQX (Inverter_001_P.Constant2_Value, 10,
      Inverter_001_DW.UnitDelay1_DSTATE_l, 10);
  }

  /* Sum: '<S10>/Sum1' incorporates:
   *  UnitDelay: '<S10>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[3] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput *
    0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_g = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S10>/Sum3' incorporates:
   *  UnitDelay: '<S10>/Unit Delay'
   */
  rtb_HighPassFilterOutput = rtb_FloattoIQN4_g[3] -
    Inverter_001_DW.UnitDelay_DSTATE_g;

  /* Sum: '<S11>/Sum2' incorporates:
   *  UnitDelay: '<S11>/Unit Delay'
   *  UnitDelay: '<S11>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_k * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_h * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_h = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S11>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S11>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_hi = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE_h, 10);
  }

  /* Sum: '<S11>/Sum1' incorporates:
   *  UnitDelay: '<S11>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[4] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_hi
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_k = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S11>/Sum3' incorporates:
   *  UnitDelay: '<S11>/Unit Delay'
   */
  rtb_HighPassFilterOutput_hi = rtb_FloattoIQN4_g[4] -
    Inverter_001_DW.UnitDelay_DSTATE_k;

  /* Sum: '<S12>/Sum2' incorporates:
   *  UnitDelay: '<S12>/Unit Delay'
   *  UnitDelay: '<S12>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_p * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_i * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_i = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S12>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S12>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_au = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE_i, 10);
  }

  /* Sum: '<S12>/Sum1' incorporates:
   *  UnitDelay: '<S12>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[5] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_au
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_p = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S12>/Sum3' incorporates:
   *  UnitDelay: '<S12>/Unit Delay'
   */
  rtb_HighPassFilterOutput_au = rtb_FloattoIQN4_g[5] -
    Inverter_001_DW.UnitDelay_DSTATE_p;

  /* RateTransition: '<Root>/Rate Transition20' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition20[0] = rtb_HighPassFilterOutput;
    Inverter_001_B.RateTransition20[1] = rtb_HighPassFilterOutput_hi;
    Inverter_001_B.RateTransition20[2] = rtb_HighPassFilterOutput_au;
  }

  /* End of RateTransition: '<Root>/Rate Transition20' */

  /* Sum: '<S13>/Sum2' incorporates:
   *  UnitDelay: '<S13>/Unit Delay'
   *  UnitDelay: '<S13>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_d * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_hy * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_hy = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S13>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S13>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_hd = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE_hy, 10);
  }

  /* Sum: '<S14>/Sum2' incorporates:
   *  UnitDelay: '<S14>/Unit Delay'
   *  UnitDelay: '<S14>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_j * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_jm * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_jm = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S14>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S14>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_ei = _IQ10mpyIQX (Inverter_001_P.Constant2_Value,
      10, Inverter_001_DW.UnitDelay1_DSTATE_jm, 10);
  }

  /* Sum: '<S15>/Sum2' incorporates:
   *  UnitDelay: '<S15>/Unit Delay'
   *  UnitDelay: '<S15>/Unit Delay1'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    Inverter_001_DW.UnitDelay_DSTATE_l * 0.0009765625F + (real32_T)
    Inverter_001_DW.UnitDelay1_DSTATE_p * 0.0009765625F) * 1024.0F),
    4.294967296E+9);
  Inverter_001_DW.UnitDelay1_DSTATE_p = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* S-Function (stiiqmath_iqmpyiqx): '<S15>/IQN1 x IQN2' incorporates:
   *  Constant: '<S1>/Constant2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S15>/IQN1 x IQN2' */
  {
    rtb_HighPassFilterOutput_m = _IQ10mpyIQX (Inverter_001_P.Constant2_Value, 10,
      Inverter_001_DW.UnitDelay1_DSTATE_p, 10);
  }

  /* Sum: '<S13>/Sum1' incorporates:
   *  UnitDelay: '<S13>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[6] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_hd
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_d = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S13>/Sum3' incorporates:
   *  UnitDelay: '<S13>/Unit Delay'
   */
  rtb_HighPassFilterOutput_hd = rtb_FloattoIQN4_g[6] -
    Inverter_001_DW.UnitDelay_DSTATE_d;

  /* Sum: '<S14>/Sum1' incorporates:
   *  UnitDelay: '<S14>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[7] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_ei
    * 0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_j = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S14>/Sum3' incorporates:
   *  UnitDelay: '<S14>/Unit Delay'
   */
  rtb_HighPassFilterOutput_ei = rtb_FloattoIQN4_g[7] -
    Inverter_001_DW.UnitDelay_DSTATE_j;

  /* Sum: '<S15>/Sum1' incorporates:
   *  UnitDelay: '<S15>/Unit Delay'
   */
  rtb_DataTypeConversion13 = (real32_T)fmod((real32_T)floor(((real32_T)
    rtb_FloattoIQN4_g[8] * 0.0009765625F - (real32_T)rtb_HighPassFilterOutput_m *
    0.0009765625F) * 1024.0F), 4.294967296E+9);
  Inverter_001_DW.UnitDelay_DSTATE_l = rtb_DataTypeConversion13 < 0.0F ?
    -(int32_T)(uint32_T)-rtb_DataTypeConversion13 : (int32_T)(uint32_T)
    rtb_DataTypeConversion13;

  /* Sum: '<S15>/Sum3' incorporates:
   *  UnitDelay: '<S15>/Unit Delay'
   */
  rtb_HighPassFilterOutput_m = rtb_FloattoIQN4_g[8] -
    Inverter_001_DW.UnitDelay_DSTATE_l;

  /* RateTransition: '<Root>/Rate Transition19' */
  if (Inverter_001_M->Timing.RateInteraction.TID0_1) {
    Inverter_001_B.RateTransition19[0] = rtb_HighPassFilterOutput_hd;
    Inverter_001_B.RateTransition19[1] = rtb_HighPassFilterOutput_ei;
    Inverter_001_B.RateTransition19[2] = rtb_HighPassFilterOutput_m;
  }

  /* End of RateTransition: '<Root>/Rate Transition19' */

  /* S-Function (stiiqmath_iq): '<S3>/Float to IQN4' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S3>/Float to IQN4' */
  {
    rtb_FloattoIQN4[0] = _IQ10 (rtb_DataTypeConversion2[0]);
    rtb_FloattoIQN4[1] = _IQ10 (rtb_DataTypeConversion2[1]);
    rtb_FloattoIQN4[2] = _IQ10 (rtb_DataTypeConversion2[2]);
  }

  /* MATLABSystem: '<Root>/DAC2' */
  MW_C2000DAC(2U, 0U);
}

/* Model step function for TID1 */
void Inverter_001_step1(void)          /* Sample time: [0.0001s, 0.0s] */
{
  /* local block i/o variables */
  real32_T rtb_Product15;
  real32_T rtb_Product17;
  real32_T rtb_Product21;
  real32_T rtb_Product19;
  int32_T rtb_IQN1xIQN6;
  int32_T rtb_IQN1xIQN6_j;
  int32_T rtb_IQN1xIQN6_n;
  int32_T rtb_cosIQN;
  int32_T rtb_cosIQN1;
  int32_T rtb_cosIQN2;
  int32_T rtb_sinIQN;
  int32_T rtb_sinIQN1;
  int32_T rtb_sinIQN2;
  int32_T rtb_IQN1xIQN6_m;
  int32_T rtb_IQN1xIQN6_i;
  int32_T rtb_IQN1xIQN6_c;
  int32_T rtb_cosIQN_p;
  int32_T rtb_sinIQN1_j;
  int32_T rtb_IQN1xIQN1;
  int32_T rtb_Sum3_kh;
  int32_T rtb_Sum9;
  int32_T rtb_Gain6;
  int32_T rtb_Sum1;
  int32_T rtb_Sum1_d;
  int32_T rtb_TmpSignalConversionAtGain1I[3];
  int32_T rtb_u_j0;
  int32_T rtb_Product7;
  int32_T rtb_Product5_p;
  int32_T rtb_Product6_n;
  int32_T rtb_u_ad;
  int32_T rtb_u_p;
  int64_T rtb_PhaseC;
  int64_T rtb_PhaseB;
  int32_T rtb_FloattoIQN_n;
  int32_T rtb_IQN1xIQN7;
  int32_T rtb_Sum_o;
  int32_T rtb_IQN1xIQN2;
  int32_T rtb_Sum_e;
  int32_T rtb_Gain1_idx_0;
  int32_T rtb_Gain1_idx_1;
  int32_T rtb_Gain1_d_idx_1;
  real32_T tmp;
  real_T v;
  uint16_T tmp_0;
  real_T u_tmp;

  /* Saturate: '<Root>/Saturation4' */
  if (Inverter_001_B.RateTransition60[0] > Inverter_001_P.Saturation4_UpperSat)
  {
    rtb_TmpSignalConversionAtGain1I[0] = Inverter_001_P.Saturation4_UpperSat;
  } else if (Inverter_001_B.RateTransition60[0] <
             Inverter_001_P.Saturation4_LowerSat) {
    rtb_TmpSignalConversionAtGain1I[0] = Inverter_001_P.Saturation4_LowerSat;
  } else {
    rtb_TmpSignalConversionAtGain1I[0] = Inverter_001_B.RateTransition60[0];
  }

  if (Inverter_001_B.RateTransition60[1] > Inverter_001_P.Saturation4_UpperSat)
  {
    rtb_TmpSignalConversionAtGain1I[1] = Inverter_001_P.Saturation4_UpperSat;
  } else if (Inverter_001_B.RateTransition60[1] <
             Inverter_001_P.Saturation4_LowerSat) {
    rtb_TmpSignalConversionAtGain1I[1] = Inverter_001_P.Saturation4_LowerSat;
  } else {
    rtb_TmpSignalConversionAtGain1I[1] = Inverter_001_B.RateTransition60[1];
  }

  if (Inverter_001_B.RateTransition60[2] > Inverter_001_P.Saturation4_UpperSat)
  {
    rtb_TmpSignalConversionAtGain1I[2] = Inverter_001_P.Saturation4_UpperSat;
  } else if (Inverter_001_B.RateTransition60[2] <
             Inverter_001_P.Saturation4_LowerSat) {
    rtb_TmpSignalConversionAtGain1I[2] = Inverter_001_P.Saturation4_LowerSat;
  } else {
    rtb_TmpSignalConversionAtGain1I[2] = Inverter_001_B.RateTransition60[2];
  }

  /* End of Saturate: '<Root>/Saturation4' */

  /* Saturate: '<Root>/Saturation5' incorporates:
   *  Constant: '<Root>/Constant8'
   */
  if (Inverter_001_P.Constant8_Value > Inverter_001_P.Saturation5_UpperSat) {
    rtb_u_ad = Inverter_001_P.Saturation5_UpperSat;
  } else if (Inverter_001_P.Constant8_Value <
             Inverter_001_P.Saturation5_LowerSat) {
    rtb_u_ad = Inverter_001_P.Saturation5_LowerSat;
  } else {
    rtb_u_ad = Inverter_001_P.Constant8_Value;
  }

  /* End of Saturate: '<Root>/Saturation5' */

  /* Gain: '<S5>/Gain' */
  rtb_Product19 = (real32_T)Inverter_001_P.Gain_Gain * 4.65661287E-10F *
    ((real32_T)rtb_u_ad * 0.0009765625F);

  /* S-Function (stiiqmath_iq): '<S5>/Float to IQN1' */

  /* C28x IQmath Library (stiiqmath_iq) - '<S5>/Float to IQN1' */
  {
    rtb_u_ad = _IQ10 (rtb_Product19);
  }

  /* S-Function (stiiqmath_iqdiv): '<S5>/IQN // IQN' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S5>/IQN // IQN' */
  {
    rtb_cosIQN_p = _IQ10div (rtb_TmpSignalConversionAtGain1I[0], rtb_u_ad);
  }

  /* S-Function (stiiqmath_iqdiv): '<S5>/IQN // IQN1' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S5>/IQN // IQN1' */
  {
    rtb_sinIQN1_j = _IQ10div (rtb_TmpSignalConversionAtGain1I[1], rtb_u_ad);
  }

  /* S-Function (stiiqmath_iqdiv): '<S5>/IQN // IQN2' */

  /* C28x IQmath Library (stiiqmath_iqdiv) - '<S5>/IQN // IQN2' */
  {
    rtb_u_p = _IQ10div (rtb_TmpSignalConversionAtGain1I[2], rtb_u_ad);
  }

  /* MinMax: '<S31>/MinMax' */
  rtb_u_ad = rtb_cosIQN_p;
  if (!(rtb_cosIQN_p < rtb_sinIQN1_j)) {
    rtb_u_ad = rtb_sinIQN1_j;
  }

  if (!(rtb_u_ad < rtb_u_p)) {
    rtb_u_ad = rtb_u_p;
  }

  /* End of MinMax: '<S31>/MinMax' */

  /* Gain: '<S31>/Gain' */
  rtb_PhaseC = (int64_T)Inverter_001_P.Gain_Gain_j * rtb_u_ad;

  /* MinMax: '<S31>/MinMax1' */
  rtb_u_ad = rtb_cosIQN_p;
  if (!(rtb_cosIQN_p > rtb_sinIQN1_j)) {
    rtb_u_ad = rtb_sinIQN1_j;
  }

  if (!(rtb_u_ad > rtb_u_p)) {
    rtb_u_ad = rtb_u_p;
  }

  /* End of MinMax: '<S31>/MinMax1' */

  /* Sum: '<S31>/Sum' incorporates:
   *  Gain: '<S31>/Gain1'
   */
  rtb_PhaseC += (int64_T)Inverter_001_P.Gain1_Gain_o * rtb_u_ad;

  /* Product: '<S4>/Product19' incorporates:
   *  Constant: '<S4>/Constant13'
   *  Constant: '<S4>/Constant14'
   *  Constant: '<S4>/Constant15'
   *  Product: '<S4>/Product18'
   *  Sum: '<S4>/Add14'
   */
  rtb_Product19 = ((real32_T)rtb_PhaseC * 2.27373675E-13F +
                   Inverter_001_P.Constant15_Value) *
    Inverter_001_P.Constant13_Value * Inverter_001_P.Constant14_Value;

  /* Sum: '<S5>/Add17' */
  rtb_PhaseB = ((int64_T)rtb_sinIQN1_j << 32U) + rtb_PhaseC;

  /* Product: '<S4>/Product15' incorporates:
   *  Constant: '<S4>/Constant13'
   *  Constant: '<S4>/Constant14'
   *  Constant: '<S4>/Constant15'
   *  Product: '<S4>/Product'
   *  Sum: '<S4>/Add'
   */
  rtb_Product15 = ((real32_T)rtb_PhaseB * 2.27373675E-13F +
                   Inverter_001_P.Constant15_Value) *
    Inverter_001_P.Constant13_Value * Inverter_001_P.Constant14_Value;

  /* Product: '<S4>/Product17' incorporates:
   *  Constant: '<S4>/Constant13'
   *  Constant: '<S4>/Constant14'
   *  Constant: '<S4>/Constant15'
   *  Product: '<S4>/Product16'
   *  Sum: '<S4>/Add13'
   *  Sum: '<S5>/Add18'
   */
  rtb_Product17 = ((real32_T)(((int64_T)rtb_u_p << 32U) + rtb_PhaseC) *
                   2.27373675E-13F + Inverter_001_P.Constant15_Value) *
    Inverter_001_P.Constant13_Value * Inverter_001_P.Constant14_Value;

  /* Product: '<S4>/Product21' incorporates:
   *  Constant: '<S4>/Constant13'
   *  Constant: '<S4>/Constant14'
   *  Constant: '<S4>/Constant15'
   *  Product: '<S4>/Product20'
   *  Sum: '<S4>/Add15'
   *  Sum: '<S5>/Add16'
   */
  rtb_Product21 = ((real32_T)(((int64_T)rtb_cosIQN_p << 32U) + rtb_PhaseC) *
                   2.27373675E-13F + Inverter_001_P.Constant15_Value) *
    Inverter_001_P.Constant13_Value * Inverter_001_P.Constant14_Value;

  /* S-Function (c2802xpwm): '<S4>/ePWM' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM5 --*/
  {
    EPwm5Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product21);
  }

  /*-- Update CMPB value for ePWM5 --*/
  {
    EPwm5Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product21);
  }

  EPwm5Regs.DBRED.bit.DBRED = Inverter_001_P.Constant2_Value_p;
  EPwm5Regs.DBFED.bit.DBFED = Inverter_001_P.Constant2_Value_p;

  /* S-Function (c2802xpwm): '<S4>/ePWM1' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM3 --*/
  {
    EPwm3Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product17);
  }

  /*-- Update CMPB value for ePWM3 --*/
  {
    EPwm3Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product17);
  }

  EPwm3Regs.DBRED.bit.DBRED = Inverter_001_P.Constant2_Value_p;
  EPwm3Regs.DBFED.bit.DBFED = Inverter_001_P.Constant2_Value_p;

  /* S-Function (c2802xpwm): '<S4>/ePWM2' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM6 --*/
  {
    EPwm6Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product15);
  }

  /*-- Update CMPB value for ePWM6 --*/
  {
    EPwm6Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product15);
  }

  EPwm6Regs.DBRED.bit.DBRED = Inverter_001_P.Constant2_Value_p;
  EPwm6Regs.DBFED.bit.DBFED = Inverter_001_P.Constant2_Value_p;

  /* S-Function (c2802xpwm): '<S4>/ePWM3' incorporates:
   *  Constant: '<Root>/Constant2'
   */

  /*-- Update CMPA value for ePWM4 --*/
  {
    EPwm4Regs.CMPA.bit.CMPA = (uint16_T)(rtb_Product19);
  }

  /*-- Update CMPB value for ePWM4 --*/
  {
    EPwm4Regs.CMPB.bit.CMPB = (uint16_T)(rtb_Product19);
  }

  EPwm4Regs.DBRED.bit.DBRED = Inverter_001_P.Constant2_Value_p;
  EPwm4Regs.DBFED.bit.DBFED = Inverter_001_P.Constant2_Value_p;

  /* S-Function (scheckfractionlength): '<S18>/ ' */
  rtb_u_p = Inverter_001_B.RateTransition20[0];

  /* S-Function (scheckfractionlength): '<S18>/ 2' */
  rtb_sinIQN1_j = Inverter_001_B.RateTransition61;

  /* S-Function (stiiqmath_iqtrig): '<S18>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/cos IQN' */
  {
    rtb_cosIQN_p = _IQ10cos(rtb_sinIQN1_j);
  }

  /* S-Function (scheckfractionlength): '<S18>/ 1' */
  rtb_u_ad = Inverter_001_B.RateTransition20[1];

  /* S-Function (stiiqmath_iq): '<S18>/Float to IQN' incorporates:
   *  Constant: '<S18>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S18>/Float to IQN' */
  {
    rtb_Product6_n = _IQ10 (Inverter_001_P.Constant_Value_h);
  }

  /* Sum: '<S18>/Sum' */
  rtb_Sum_e = rtb_sinIQN1_j + rtb_Product6_n;

  /* Sum: '<S18>/Sum3' */
  rtb_Product7 = rtb_sinIQN1_j - rtb_Product6_n;

  /* S-Function (stiiqmath_iqtrig): '<S18>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/cos IQN1' */
  {
    rtb_Product6_n = _IQ10cos(rtb_Product7);
  }

  /* S-Function (scheckfractionlength): '<S18>/ 3' */
  rtb_u_j0 = Inverter_001_B.RateTransition20[2];

  /* S-Function (stiiqmath_iqtrig): '<S18>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/cos IQN2' */
  {
    rtb_Product5_p = _IQ10cos(rtb_Sum_e);
  }

  /* S-Function (stiiqmath_iqtrig): '<S18>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/sin IQN' */
  {
    rtb_Sum1_d = _IQ10sin(rtb_sinIQN1_j);
  }

  /* S-Function (stiiqmath_iqtrig): '<S18>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/sin IQN1' */
  {
    rtb_sinIQN1_j = _IQ10sin(rtb_Product7);
  }

  /* S-Function (stiiqmath_iqtrig): '<S18>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S18>/sin IQN2' */
  {
    rtb_Product7 = _IQ10sin(rtb_Sum_e);
  }

  /* S-Function (scheckfractionlength): '<S19>/ ' */
  rtb_Sum_e = Inverter_001_B.RateTransition21[0];

  /* S-Function (scheckfractionlength): '<S19>/ 2' */
  rtb_Sum1 = Inverter_001_B.RateTransition61;

  /* S-Function (stiiqmath_iqtrig): '<S19>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/cos IQN' */
  {
    rtb_Gain6 = _IQ10cos(rtb_Sum1);
  }

  /* Product: '<S19>/Product2' */
  rtb_IQN1xIQN2 = __IQmpy(rtb_Sum_e, rtb_Gain6, 10);

  /* S-Function (scheckfractionlength): '<S19>/ 1' */
  rtb_Gain6 = Inverter_001_B.RateTransition21[1];

  /* S-Function (stiiqmath_iq): '<S19>/Float to IQN' incorporates:
   *  Constant: '<S19>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S19>/Float to IQN' */
  {
    rtb_IQN1xIQN1 = _IQ10 (Inverter_001_P.Constant_Value_b);
  }

  /* Sum: '<S19>/Sum3' */
  rtb_Sum9 = rtb_Sum1 - rtb_IQN1xIQN1;

  /* S-Function (stiiqmath_iqtrig): '<S19>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/cos IQN1' */
  {
    rtb_Sum3_kh = _IQ10cos(rtb_Sum9);
  }

  /* Product: '<S19>/Product4' */
  rtb_Sum_o = __IQmpy(rtb_Gain6, rtb_Sum3_kh, 10);

  /* S-Function (scheckfractionlength): '<S19>/ 3' */
  rtb_Sum3_kh = Inverter_001_B.RateTransition21[2];

  /* Sum: '<S19>/Sum' */
  rtb_FloattoIQN_n = rtb_Sum1 + rtb_IQN1xIQN1;

  /* S-Function (stiiqmath_iqtrig): '<S19>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/cos IQN2' */
  {
    rtb_IQN1xIQN1 = _IQ10cos(rtb_FloattoIQN_n);
  }

  /* Product: '<S19>/Product6' */
  rtb_IQN1xIQN7 = __IQmpy(rtb_Sum3_kh, rtb_IQN1xIQN1, 10);

  /* Sum: '<S19>/Sum1' */
  rtb_IQN1xIQN1 = (rtb_IQN1xIQN2 + rtb_Sum_o) + rtb_IQN1xIQN7;

  /* S-Function (stiiqmath_iqtrig): '<S19>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/sin IQN' */
  {
    rtb_IQN1xIQN7 = _IQ10sin(rtb_Sum1);
  }

  /* Product: '<S19>/Product3' */
  rtb_Sum_o = __IQmpy(rtb_Sum_e, rtb_IQN1xIQN7, 10);

  /* S-Function (stiiqmath_iqtrig): '<S19>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/sin IQN1' */
  {
    rtb_IQN1xIQN7 = _IQ10sin(rtb_Sum9);
  }

  /* Product: '<S19>/Product5' */
  rtb_Sum9 = __IQmpy(rtb_Gain6, rtb_IQN1xIQN7, 10);

  /* S-Function (stiiqmath_iqtrig): '<S19>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S19>/sin IQN2' */
  {
    rtb_IQN1xIQN7 = _IQ10sin(rtb_FloattoIQN_n);
  }

  /* Product: '<S19>/Product7' */
  rtb_FloattoIQN_n = __IQmpy(rtb_Sum3_kh, rtb_IQN1xIQN7, 10);

  /* SignalConversion: '<S19>/TmpSignal ConversionAtGain1Inport1' incorporates:
   *  Sum: '<S19>/Sum4'
   */
  rtb_TmpSignalConversionAtGain1I[1] = (-rtb_Sum_o - rtb_Sum9) -
    rtb_FloattoIQN_n;

  /* Sum: '<S19>/Sum5' */
  rtb_FloattoIQN_n = (rtb_Sum_e + rtb_Gain6) + rtb_Sum3_kh;

  /* SignalConversion: '<S19>/TmpSignal ConversionAtGain1Inport1' incorporates:
   *  Gain: '<S19>/Gain'
   */
  rtb_TmpSignalConversionAtGain1I[2] = __IQxmpy(Inverter_001_P.Gain_Gain_g,
    rtb_FloattoIQN_n, 1);
  rtb_TmpSignalConversionAtGain1I[0] = rtb_IQN1xIQN1;

  /* Gain: '<S19>/Gain1' */
  rtb_Gain1_idx_0 = __IQxmpy(Inverter_001_P.Gain1_Gain,
    rtb_TmpSignalConversionAtGain1I[0], 1);
  rtb_Gain1_idx_1 = __IQxmpy(Inverter_001_P.Gain1_Gain,
    rtb_TmpSignalConversionAtGain1I[1], 1);

  /* Sum: '<S30>/Sum' incorporates:
   *  Gain: '<S19>/Gain1'
   */
  rtb_IQN1xIQN7 = Inverter_001_B.RateTransition62[2] - __IQxmpy
    (Inverter_001_P.Gain1_Gain, rtb_TmpSignalConversionAtGain1I[2], 1);

  /* Sum: '<S30>/Sum11' incorporates:
   *  UnitDelay: '<S30>/Unit Delay3'
   */
  rtb_FloattoIQN_n = rtb_IQN1xIQN7 - Inverter_001_DW.UnitDelay3_DSTATE;

  /* Gain: '<S30>/Gain' incorporates:
   *  Gain: '<S24>/Gain'
   *  Gain: '<S24>/Gain1'
   *  Gain: '<S25>/Gain'
   *  Gain: '<S25>/Gain1'
   *  Gain: '<S26>/Gain'
   *  Gain: '<S26>/Gain1'
   *  Gain: '<S28>/Gain'
   *  Gain: '<S28>/Gain1'
   *  Gain: '<S29>/Gain'
   *  Gain: '<S29>/Gain1'
   *  Gain: '<S30>/Gain1'
   */
  u_tmp = Inverter_001_P.Control.Ts * 4.398046511104E+12;
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum_o = __IQxmpy(rtb_Sum_e, rtb_FloattoIQN_n, -10);

  /* End of Gain: '<S30>/Gain' */

  /* Sum: '<S30>/Sum5' incorporates:
   *  UnitDelay: '<S30>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE += rtb_Sum_o;

  /* Gain: '<S30>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_FloattoIQN_n = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE, -10);

  /* Sum: '<S30>/Sum4' incorporates:
   *  UnitDelay: '<S30>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_b += rtb_FloattoIQN_n;

  /* Sum: '<S29>/Sum' */
  rtb_FloattoIQN_n = Inverter_001_B.RateTransition62[0] - rtb_Gain1_idx_0;

  /* Sum: '<S29>/Sum11' incorporates:
   *  UnitDelay: '<S29>/Unit Delay3'
   */
  rtb_Sum_o = rtb_FloattoIQN_n - Inverter_001_DW.UnitDelay3_DSTATE_c;

  /* Gain: '<S29>/Gain' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum3_kh = __IQxmpy(rtb_Sum_e, rtb_Sum_o, -10);

  /* Sum: '<S29>/Sum5' incorporates:
   *  UnitDelay: '<S29>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE_h += rtb_Sum3_kh;

  /* Gain: '<S29>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum_o = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE_h, -10);

  /* Sum: '<S29>/Sum4' incorporates:
   *  UnitDelay: '<S29>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_d += rtb_Sum_o;

  /* Sum: '<S28>/Sum' */
  rtb_Sum_o = Inverter_001_B.RateTransition62[1] - rtb_Gain1_idx_1;

  /* Sum: '<S28>/Sum11' incorporates:
   *  UnitDelay: '<S28>/Unit Delay3'
   */
  rtb_Sum3_kh = rtb_Sum_o - Inverter_001_DW.UnitDelay3_DSTATE_m;

  /* Gain: '<S28>/Gain' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum9 = __IQxmpy(rtb_Sum_e, rtb_Sum3_kh, -10);

  /* Sum: '<S28>/Sum5' incorporates:
   *  UnitDelay: '<S28>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE_g += rtb_Sum9;

  /* Gain: '<S28>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum3_kh = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE_g, -10);

  /* Sum: '<S28>/Sum4' incorporates:
   *  UnitDelay: '<S28>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_hyo += rtb_Sum3_kh;

  /* Product: '<S18>/Product2' */
  rtb_Sum3_kh = __IQmpy(rtb_u_p, rtb_cosIQN_p, 10);

  /* Product: '<S18>/Product4' */
  rtb_Sum9 = __IQmpy(rtb_u_ad, rtb_Product6_n, 10);

  /* Product: '<S18>/Product6' */
  rtb_IQN1xIQN1 = __IQmpy(rtb_u_j0, rtb_Product5_p, 10);

  /* SignalConversion: '<S18>/TmpSignal ConversionAtGain1Inport1' incorporates:
   *  Sum: '<S18>/Sum1'
   */
  rtb_TmpSignalConversionAtGain1I[0] = (rtb_Sum3_kh + rtb_Sum9) + rtb_IQN1xIQN1;

  /* Product: '<S18>/Product3' */
  rtb_Sum3_kh = __IQmpy(rtb_u_p, rtb_Sum1_d, 10);

  /* Product: '<S18>/Product5' */
  rtb_Sum9 = __IQmpy(rtb_u_ad, rtb_sinIQN1_j, 10);

  /* Product: '<S18>/Product7' */
  rtb_IQN1xIQN1 = __IQmpy(rtb_u_j0, rtb_Product7, 10);

  /* Sum: '<S18>/Sum4' */
  rtb_Gain6 = (-rtb_Sum3_kh - rtb_Sum9) - rtb_IQN1xIQN1;

  /* Sum: '<S18>/Sum5' */
  rtb_Sum3_kh = (rtb_u_p + rtb_u_ad) + rtb_u_j0;

  /* Gain: '<S18>/Gain' */
  rtb_Sum9 = __IQxmpy(Inverter_001_P.Gain_Gain_b, rtb_Sum3_kh, 1);

  /* SignalConversion: '<S18>/TmpSignal ConversionAtGain1Inport1' */
  rtb_TmpSignalConversionAtGain1I[1] = rtb_Gain6;
  rtb_TmpSignalConversionAtGain1I[2] = rtb_Sum9;

  /* Gain: '<S18>/Gain1' */
  rtb_u_ad = __IQxmpy(Inverter_001_P.Gain1_Gain_g,
                      rtb_TmpSignalConversionAtGain1I[0], 1);
  rtb_Gain1_d_idx_1 = __IQxmpy(Inverter_001_P.Gain1_Gain_g,
    rtb_TmpSignalConversionAtGain1I[1], 1);
  rtb_u_p = __IQxmpy(Inverter_001_P.Gain1_Gain_g,
                     rtb_TmpSignalConversionAtGain1I[2], 1);

  /* S-Function (stiiqmath_iqmpyiqx): '<S28>/IQN1 x IQN1' incorporates:
   *  Constant: '<S23>/Kr3'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S28>/IQN1 x IQN1' */
  {
    rtb_Sum3_kh = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE_g, 10,
      Inverter_001_P.VC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S28>/IQN1 x IQN2' incorporates:
   *  Constant: '<S23>/Kp4'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S28>/IQN1 x IQN2' */
  {
    rtb_Sum9 = _IQ10mpyIQX (rtb_Sum_o, 10, Inverter_001_P.Kvp, 10);
  }

  /* Sum: '<S28>/Sum3' incorporates:
   *  UnitDelay: '<S28>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_lt += rtb_Sum_o;

  /* S-Function (stiiqmath_iqmpyiqx): '<S28>/IQN1 x IQN3' incorporates:
   *  Constant: '<S23>/Ki3'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S28>/IQN1 x IQN3' */
  {
    rtb_Sum_o = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_lt, 10,
      Inverter_001_P.VC_Tci, 10);
  }

  /* S-Function (scheckfractionlength): '<S20>/ ' */
  rtb_IQN1xIQN1 = Inverter_001_B.RateTransition19[0];

  /* S-Function (scheckfractionlength): '<S20>/ 2' */
  rtb_IQN1xIQN2 = Inverter_001_B.RateTransition61;

  /* S-Function (stiiqmath_iqtrig): '<S20>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/cos IQN' */
  {
    rtb_Gain6 = _IQ10cos(rtb_IQN1xIQN2);
  }

  /* Product: '<S20>/Product2' */
  rtb_Sum1 = __IQmpy(rtb_IQN1xIQN1, rtb_Gain6, 10);

  /* S-Function (scheckfractionlength): '<S20>/ 1' */
  rtb_Gain6 = Inverter_001_B.RateTransition19[1];

  /* S-Function (stiiqmath_iq): '<S20>/Float to IQN' incorporates:
   *  Constant: '<S20>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S20>/Float to IQN' */
  {
    rtb_Sum1_d = _IQ10 (Inverter_001_P.Constant_Value_m);
  }

  /* Sum: '<S20>/Sum3' */
  rtb_Product5_p = rtb_IQN1xIQN2 - rtb_Sum1_d;

  /* S-Function (stiiqmath_iqtrig): '<S20>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/cos IQN1' */
  {
    rtb_u_j0 = _IQ10cos(rtb_Product5_p);
  }

  /* Product: '<S20>/Product4' */
  rtb_Product7 = __IQmpy(rtb_Gain6, rtb_u_j0, 10);

  /* S-Function (scheckfractionlength): '<S20>/ 3' */
  rtb_u_j0 = Inverter_001_B.RateTransition19[2];

  /* Sum: '<S20>/Sum' */
  rtb_Sum_e = rtb_IQN1xIQN2 + rtb_Sum1_d;

  /* S-Function (stiiqmath_iqtrig): '<S20>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/cos IQN2' */
  {
    rtb_Sum1_d = _IQ10cos(rtb_Sum_e);
  }

  /* Product: '<S20>/Product6' */
  rtb_Product6_n = __IQmpy(rtb_u_j0, rtb_Sum1_d, 10);

  /* SignalConversion: '<S20>/TmpSignal ConversionAtGain1Inport1' incorporates:
   *  Sum: '<S20>/Sum1'
   */
  rtb_TmpSignalConversionAtGain1I[0] = (rtb_Sum1 + rtb_Product7) +
    rtb_Product6_n;

  /* S-Function (stiiqmath_iqtrig): '<S20>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/sin IQN' */
  {
    rtb_Sum1 = _IQ10sin(rtb_IQN1xIQN2);
  }

  /* Product: '<S20>/Product3' */
  rtb_IQN1xIQN2 = __IQmpy(rtb_IQN1xIQN1, rtb_Sum1, 10);

  /* S-Function (stiiqmath_iqtrig): '<S20>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/sin IQN1' */
  {
    rtb_Sum1 = _IQ10sin(rtb_Product5_p);
  }

  /* Product: '<S20>/Product5' */
  rtb_Product5_p = __IQmpy(rtb_Gain6, rtb_Sum1, 10);

  /* S-Function (stiiqmath_iqtrig): '<S20>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S20>/sin IQN2' */
  {
    rtb_Sum1 = _IQ10sin(rtb_Sum_e);
  }

  /* Product: '<S20>/Product7' */
  rtb_Product7 = __IQmpy(rtb_u_j0, rtb_Sum1, 10);

  /* Sum: '<S20>/Sum4' */
  rtb_Sum1 = (-rtb_IQN1xIQN2 - rtb_Product5_p) - rtb_Product7;

  /* Sum: '<S20>/Sum5' */
  rtb_IQN1xIQN2 = (rtb_IQN1xIQN1 + rtb_Gain6) + rtb_u_j0;

  /* Gain: '<S20>/Gain' */
  rtb_IQN1xIQN1 = __IQxmpy(Inverter_001_P.Gain_Gain_n, rtb_IQN1xIQN2, 1);

  /* SignalConversion: '<S20>/TmpSignal ConversionAtGain1Inport1' */
  rtb_TmpSignalConversionAtGain1I[1] = rtb_Sum1;
  rtb_TmpSignalConversionAtGain1I[2] = rtb_IQN1xIQN1;

  /* Gain: '<S20>/Gain1' */
  rtb_TmpSignalConversionAtGain1I[0] = __IQxmpy(Inverter_001_P.Gain1_Gain_f,
    rtb_TmpSignalConversionAtGain1I[0], 1);
  rtb_TmpSignalConversionAtGain1I[1] = __IQxmpy(Inverter_001_P.Gain1_Gain_f,
    rtb_TmpSignalConversionAtGain1I[1], 1);
  rtb_TmpSignalConversionAtGain1I[2] = __IQxmpy(Inverter_001_P.Gain1_Gain_f,
    rtb_TmpSignalConversionAtGain1I[2], 1);

  /* Sum: '<S28>/Sum1' */
  rtb_IQN1xIQN1 = (rtb_Sum3_kh + rtb_Sum9) + rtb_Sum_o;

  /* Sum: '<S23>/Sum13' */
  rtb_Sum_o = rtb_IQN1xIQN1 + rtb_TmpSignalConversionAtGain1I[1];

  /* Gain: '<S23>/Gain12' */
  rtb_Sum3_kh = __IQxmpy(Inverter_001_P.Gain12_Gain, rtb_Gain1_idx_0, -10);

  /* Sum: '<S23>/Sum4' */
  rtb_Sum9 = rtb_Sum_o + rtb_Sum3_kh;

  /* Sum: '<S24>/Sum' */
  rtb_Sum_o = rtb_Sum9 - rtb_Gain1_d_idx_1;

  /* Sum: '<S24>/Sum11' incorporates:
   *  UnitDelay: '<S24>/Unit Delay3'
   */
  rtb_Sum3_kh = rtb_Sum_o - Inverter_001_DW.UnitDelay3_DSTATE_o;

  /* Gain: '<S24>/Gain' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum9 = __IQxmpy(rtb_Sum_e, rtb_Sum3_kh, -10);

  /* Sum: '<S24>/Sum5' incorporates:
   *  UnitDelay: '<S24>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE_gq += rtb_Sum9;

  /* Gain: '<S24>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum3_kh = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE_gq, -10);

  /* Sum: '<S24>/Sum4' incorporates:
   *  UnitDelay: '<S24>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_c += rtb_Sum3_kh;

  /* S-Function (stiiqmath_iqmpyiqx): '<S24>/IQN1 x IQN1' incorporates:
   *  Constant: '<S16>/Kr2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S24>/IQN1 x IQN1' */
  {
    rtb_Sum3_kh = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE_gq, 10,
      Inverter_001_P.CC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S24>/IQN1 x IQN2' incorporates:
   *  Constant: '<S16>/Kp2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S24>/IQN1 x IQN2' */
  {
    rtb_Sum9 = _IQ10mpyIQX (rtb_Sum_o, 10, Inverter_001_P.Kcp, 10);
  }

  /* Sum: '<S24>/Sum3' incorporates:
   *  UnitDelay: '<S24>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_a += rtb_Sum_o;

  /* S-Function (stiiqmath_iqmpyiqx): '<S24>/IQN1 x IQN3' incorporates:
   *  Constant: '<S16>/Ki2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S24>/IQN1 x IQN3' */
  {
    rtb_Sum_o = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_a, 10,
      Inverter_001_P.CC_Tci, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S24>/IQN1 x IQN7' incorporates:
   *  Constant: '<S16>/w2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S24>/IQN1 x IQN7' */
  {
    rtb_IQN1xIQN1 = _IQ10mpyIQX (Inverter_001_P.w2_Value, 10,
      Inverter_001_P.w2_Value, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S24>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S24>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_c, 10,
      rtb_IQN1xIQN1, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S29>/IQN1 x IQN1' incorporates:
   *  Constant: '<S23>/Kr3'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S29>/IQN1 x IQN1' */
  {
    rtb_IQN1xIQN1 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE_h, 10,
      Inverter_001_P.VC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S29>/IQN1 x IQN2' incorporates:
   *  Constant: '<S23>/Kp4'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S29>/IQN1 x IQN2' */
  {
    rtb_IQN1xIQN2 = _IQ10mpyIQX (rtb_FloattoIQN_n, 10, Inverter_001_P.Kvp, 10);
  }

  /* Sum: '<S29>/Sum3' incorporates:
   *  UnitDelay: '<S29>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_o += rtb_FloattoIQN_n;

  /* S-Function (stiiqmath_iqmpyiqx): '<S29>/IQN1 x IQN3' incorporates:
   *  Constant: '<S23>/Ki3'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S29>/IQN1 x IQN3' */
  {
    rtb_FloattoIQN_n = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_o, 10,
      Inverter_001_P.VC_Tci, 10);
  }

  /* Sum: '<S29>/Sum1' */
  rtb_Gain6 = (rtb_IQN1xIQN1 + rtb_IQN1xIQN2) + rtb_FloattoIQN_n;

  /* Sum: '<S23>/Sum12' */
  rtb_FloattoIQN_n = rtb_Gain6 + rtb_TmpSignalConversionAtGain1I[0];

  /* Gain: '<S23>/Gain13' */
  rtb_IQN1xIQN1 = __IQxmpy(Inverter_001_P.Gain13_Gain, rtb_Gain1_idx_1, -10);

  /* Sum: '<S23>/Sum15' */
  rtb_IQN1xIQN2 = rtb_FloattoIQN_n - rtb_IQN1xIQN1;

  /* Sum: '<S25>/Sum' */
  rtb_FloattoIQN_n = rtb_IQN1xIQN2 - rtb_u_ad;

  /* Sum: '<S25>/Sum11' incorporates:
   *  UnitDelay: '<S25>/Unit Delay3'
   */
  rtb_IQN1xIQN1 = rtb_FloattoIQN_n - Inverter_001_DW.UnitDelay3_DSTATE_g;

  /* Gain: '<S25>/Gain' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_IQN1xIQN2 = __IQxmpy(rtb_Sum_e, rtb_IQN1xIQN1, -10);

  /* Sum: '<S25>/Sum5' incorporates:
   *  UnitDelay: '<S25>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE_m += rtb_IQN1xIQN2;

  /* Gain: '<S25>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_IQN1xIQN1 = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE_m, -10);

  /* Sum: '<S25>/Sum4' incorporates:
   *  UnitDelay: '<S25>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_m += rtb_IQN1xIQN1;

  /* S-Function (stiiqmath_iqmpyiqx): '<S25>/IQN1 x IQN1' incorporates:
   *  Constant: '<S16>/Kr2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S25>/IQN1 x IQN1' */
  {
    rtb_IQN1xIQN1 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE_m, 10,
      Inverter_001_P.CC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S25>/IQN1 x IQN2' incorporates:
   *  Constant: '<S16>/Kp2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S25>/IQN1 x IQN2' */
  {
    rtb_IQN1xIQN2 = _IQ10mpyIQX (rtb_FloattoIQN_n, 10, Inverter_001_P.Kcp, 10);
  }

  /* Sum: '<S25>/Sum3' incorporates:
   *  UnitDelay: '<S25>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_m += rtb_FloattoIQN_n;

  /* S-Function (stiiqmath_iqmpyiqx): '<S25>/IQN1 x IQN3' incorporates:
   *  Constant: '<S16>/Ki2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S25>/IQN1 x IQN3' */
  {
    rtb_FloattoIQN_n = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_m, 10,
      Inverter_001_P.CC_Tci, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S25>/IQN1 x IQN7' incorporates:
   *  Constant: '<S16>/w2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S25>/IQN1 x IQN7' */
  {
    rtb_Gain6 = _IQ10mpyIQX (Inverter_001_P.w2_Value, 10,
      Inverter_001_P.w2_Value, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S25>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S25>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6_j = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_m, 10,
      rtb_Gain6, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S30>/IQN1 x IQN1' incorporates:
   *  Constant: '<S23>/Kr2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S30>/IQN1 x IQN1' */
  {
    rtb_Gain6 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE, 10,
      Inverter_001_P.VC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S30>/IQN1 x IQN2' incorporates:
   *  Constant: '<S23>/Kp2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S30>/IQN1 x IQN2' */
  {
    rtb_Sum1 = _IQ10mpyIQX (rtb_IQN1xIQN7, 10, Inverter_001_P.Kvp0, 10);
  }

  /* Sum: '<S30>/Sum3' incorporates:
   *  UnitDelay: '<S30>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_i += rtb_IQN1xIQN7;

  /* S-Function (stiiqmath_iqmpyiqx): '<S30>/IQN1 x IQN3' incorporates:
   *  Constant: '<S23>/Ki2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S30>/IQN1 x IQN3' */
  {
    rtb_IQN1xIQN7 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_i, 10,
      Inverter_001_P.VC_Tci0, 10);
  }

  /* Sum: '<S30>/Sum1' */
  rtb_Sum1_d = (rtb_Gain6 + rtb_Sum1) + rtb_IQN1xIQN7;

  /* Sum: '<S23>/Sum14' */
  rtb_IQN1xIQN7 = rtb_Sum1_d + rtb_TmpSignalConversionAtGain1I[2];

  /* Sum: '<S26>/Sum' */
  rtb_Gain6 = rtb_IQN1xIQN7 - rtb_u_p;

  /* Sum: '<S26>/Sum11' incorporates:
   *  UnitDelay: '<S26>/Unit Delay3'
   */
  rtb_IQN1xIQN7 = rtb_Gain6 - Inverter_001_DW.UnitDelay3_DSTATE_h;

  /* Gain: '<S26>/Gain' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      v = floor(u_tmp + 0.5);
    } else {
      v = u_tmp * 0.0;
    }
  } else {
    v = u_tmp;
  }

  if (v < 2.147483648E+9) {
    if (v >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)v;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum1 = __IQxmpy(rtb_Sum_e, rtb_IQN1xIQN7, -10);

  /* Sum: '<S26>/Sum5' incorporates:
   *  UnitDelay: '<S26>/Unit Delay2'
   */
  Inverter_001_DW.UnitDelay2_DSTATE_gh += rtb_Sum1;

  /* S-Function (stiiqmath_iqmpyiqx): '<S26>/IQN1 x IQN1' incorporates:
   *  Constant: '<S16>/Kr1'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S26>/IQN1 x IQN1' */
  {
    rtb_IQN1xIQN7 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay2_DSTATE_gh, 10,
      Inverter_001_P.CC_Tcr, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S26>/IQN1 x IQN2' incorporates:
   *  Constant: '<S16>/Kp1'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S26>/IQN1 x IQN2' */
  {
    rtb_Sum1 = _IQ10mpyIQX (rtb_Gain6, 10, Inverter_001_P.Kcp0, 10);
  }

  /* Sum: '<S26>/Sum3' incorporates:
   *  UnitDelay: '<S26>/Unit Delay'
   */
  Inverter_001_DW.UnitDelay_DSTATE_ci += rtb_Gain6;

  /* S-Function (stiiqmath_iqmpyiqx): '<S26>/IQN1 x IQN3' incorporates:
   *  Constant: '<S16>/Ki1'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S26>/IQN1 x IQN3' */
  {
    rtb_Gain6 = _IQ10mpyIQX (Inverter_001_DW.UnitDelay_DSTATE_ci, 10,
      Inverter_001_P.CC_Tci0, 10);
  }

  /* Gain: '<S16>/Gain6' */
  rtb_Gain6 = __IQmpy(Inverter_001_P.Gain6_Gain, rtb_u_ad, 29);

  /* Sum: '<S24>/Sum1' */
  rtb_Sum1 = (rtb_Sum3_kh + rtb_Sum9) + rtb_Sum_o;

  /* Sum: '<S16>/Sum7' */
  rtb_Sum_o = rtb_Sum1 + rtb_Gain1_idx_1;

  /* Sum: '<S16>/Sum10' */
  rtb_Sum3_kh = rtb_Sum_o + rtb_Gain6;

  /* Gain: '<S26>/Gain1' */
  v = fabs(u_tmp);
  if (v < 4.503599627370496E+15) {
    if (v >= 0.5) {
      u_tmp = floor(u_tmp + 0.5);
    } else {
      u_tmp *= 0.0;
    }
  }

  if (u_tmp < 2.147483648E+9) {
    if (u_tmp >= -2.147483648E+9) {
      rtb_Sum_e = (int32_T)u_tmp;
    } else {
      rtb_Sum_e = MIN_int32_T;
    }
  } else {
    rtb_Sum_e = MAX_int32_T;
  }

  rtb_Sum_o = __IQxmpy(rtb_Sum_e, Inverter_001_DW.UnitDelay2_DSTATE_gh, -10);

  /* Sum: '<S26>/Sum4' incorporates:
   *  UnitDelay: '<S26>/Unit Delay1'
   */
  Inverter_001_DW.UnitDelay1_DSTATE_g += rtb_Sum_o;

  /* S-Function (stiiqmath_iqmpyiqx): '<S26>/IQN1 x IQN7' incorporates:
   *  Constant: '<S16>/w1'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S26>/IQN1 x IQN7' */
  {
    rtb_Sum_o = _IQ10mpyIQX (Inverter_001_P.w1_Value, 10,
      Inverter_001_P.w1_Value, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S26>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S26>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6_n = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_g, 10,
      rtb_Sum_o, 10);
  }

  /* Sum: '<S25>/Sum1' */
  rtb_Sum9 = (rtb_IQN1xIQN1 + rtb_IQN1xIQN2) + rtb_FloattoIQN_n;

  /* Sum: '<S16>/Sum6' */
  rtb_FloattoIQN_n = rtb_Sum9 + rtb_Gain1_idx_0;

  /* S-Function (scheckfractionlength): '<S17>/ 2' */
  rtb_IQN1xIQN7 = Inverter_001_B.RateTransition61;

  /* S-Function (stiiqmath_iq): '<S17>/Float to IQN' incorporates:
   *  Constant: '<S17>/Constant'
   */

  /* C28x IQmath Library (stiiqmath_iq) - '<S17>/Float to IQN' */
  {
    rtb_FloattoIQN_n = _IQ10 (Inverter_001_P.Constant_Value_br);
  }

  /* Sum: '<S17>/Sum' */
  rtb_Sum_o = rtb_IQN1xIQN7 + rtb_FloattoIQN_n;

  /* Sum: '<S17>/Sum3' */
  rtb_Sum3_kh = rtb_IQN1xIQN7 - rtb_FloattoIQN_n;

  /* S-Function (stiiqmath_iqtrig): '<S17>/cos IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/cos IQN' */
  {
    rtb_cosIQN = _IQ10cos(rtb_IQN1xIQN7);
  }

  /* S-Function (stiiqmath_iqtrig): '<S17>/cos IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/cos IQN1' */
  {
    rtb_cosIQN1 = _IQ10cos(rtb_Sum3_kh);
  }

  /* S-Function (stiiqmath_iqtrig): '<S17>/cos IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/cos IQN2' */
  {
    rtb_cosIQN2 = _IQ10cos(rtb_Sum_o);
  }

  /* S-Function (stiiqmath_iqtrig): '<S17>/sin IQN' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/sin IQN' */
  {
    rtb_sinIQN = _IQ10sin(rtb_IQN1xIQN7);
  }

  /* S-Function (stiiqmath_iqtrig): '<S17>/sin IQN1' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/sin IQN1' */
  {
    rtb_sinIQN1 = _IQ10sin(rtb_Sum3_kh);
  }

  /* S-Function (stiiqmath_iqtrig): '<S17>/sin IQN2' */

  /* C28x IQmath Library (stiiqmath_iqtrig) - '<S17>/sin IQN2' */
  {
    rtb_sinIQN2 = _IQ10sin(rtb_Sum_o);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S28>/IQN1 x IQN7' incorporates:
   *  Constant: '<S23>/w5'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S28>/IQN1 x IQN7' */
  {
    rtb_IQN1xIQN7 = _IQ10mpyIQX (Inverter_001_P.w5_Value, 10,
      Inverter_001_P.w5_Value, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S28>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S28>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6_m = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_hyo, 10,
      rtb_IQN1xIQN7, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S29>/IQN1 x IQN7' incorporates:
   *  Constant: '<S23>/w5'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S29>/IQN1 x IQN7' */
  {
    rtb_IQN1xIQN7 = _IQ10mpyIQX (Inverter_001_P.w5_Value, 10,
      Inverter_001_P.w5_Value, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S29>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S29>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6_i = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_d, 10,
      rtb_IQN1xIQN7, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S30>/IQN1 x IQN7' incorporates:
   *  Constant: '<S23>/w2'
   */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S30>/IQN1 x IQN7' */
  {
    rtb_IQN1xIQN7 = _IQ10mpyIQX (Inverter_001_P.w2_Value_n, 10,
      Inverter_001_P.w2_Value_n, 10);
  }

  /* S-Function (stiiqmath_iqmpyiqx): '<S30>/IQN1 x IQN6' */

  /* C28x IQmath Library (stiiqmath_iqmpyiqx) - '<S30>/IQN1 x IQN6' */
  {
    rtb_IQN1xIQN6_c = _IQ10mpyIQX (Inverter_001_DW.UnitDelay1_DSTATE_b, 10,
      rtb_IQN1xIQN7, 10);
  }

  /* S-Function (c2837xdipc_rx): '<Root>/IPC Receive' */
  MW_IPC_Receive(CHANNEL0, (uint32_t *)&Inverter_001_B.IPCReceive_o1,
                 &Inverter_001_B.IPCReceive_o2, 1, 8, 0);

  /* MATLABSystem: '<Root>/DAC' incorporates:
   *  Bias: '<Root>/Bias1'
   */
  tmp = rt_roundf_snf(Inverter_001_B.RateTransition5[1] +
                      Inverter_001_P.Bias1_Bias);
  if (tmp < 65536.0F) {
    if (tmp >= 0.0F) {
      tmp_0 = (uint16_T)tmp;
    } else {
      tmp_0 = 0U;
    }
  } else {
    tmp_0 = MAX_uint16_T;
  }

  MW_C2000DAC(0U, tmp_0);

  /* End of MATLABSystem: '<Root>/DAC' */

  /* MATLABSystem: '<Root>/DAC1' incorporates:
   *  Bias: '<Root>/Bias2'
   *  DataTypeConversion: '<Root>/Data Type Conversion3'
   *  Gain: '<Root>/Gain2'
   */
  tmp = rt_roundf_snf((real32_T)rtb_PhaseB * 2.27373675E-13F *
                      Inverter_001_P.Gain2_Gain_f + Inverter_001_P.Bias2_Bias);
  if (tmp < 65536.0F) {
    if (tmp >= 0.0F) {
      tmp_0 = (uint16_T)tmp;
    } else {
      tmp_0 = 0U;
    }
  } else {
    tmp_0 = MAX_uint16_T;
  }

  MW_C2000DAC(1U, tmp_0);

  /* End of MATLABSystem: '<Root>/DAC1' */

  /* Update for RateTransition: '<Root>/Rate Transition1' incorporates:
   *  Constant: '<Root>/Constant14'
   */
  Inverter_001_DW.RateTransition1_Buffer0 = Inverter_001_P.Constant14_Value_m;

  /* Update for UnitDelay: '<S30>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE = rtb_IQN1xIQN6_c;

  /* Update for UnitDelay: '<S29>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_c = rtb_IQN1xIQN6_i;

  /* Update for UnitDelay: '<S28>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_m = rtb_IQN1xIQN6_m;

  /* Update for UnitDelay: '<S24>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_o = rtb_IQN1xIQN6;

  /* Update for UnitDelay: '<S25>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_g = rtb_IQN1xIQN6_j;

  /* Update for UnitDelay: '<S26>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_h = rtb_IQN1xIQN6_n;
}

/* Model step function for TID2 */
void Inverter_001_step2(void)          /* Sample time: [0.0002s, 0.0s] */
{
  /* (no output/update code required) */
}

/* Model step function for TID3 */
void Inverter_001_step3(void)          /* Sample time: [0.1s, 0.0s] */
{
  /* Update for RateTransition: '<Root>/TmpRTBAtConstant62Outport1' incorporates:
   *  Constant: '<Root>/Constant62'
   */
  Inverter_001_DW.TmpRTBAtConstant62Outport1_Buff =
    Inverter_001_P.Constant62_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd11Inport2' incorporates:
   *  Constant: '<Root>/Constant61'
   */
  Inverter_001_DW.TmpRTBAtAdd11Inport2_Buffer0 = Inverter_001_P.Constant61_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd10Inport2' incorporates:
   *  Constant: '<Root>/Constant63'
   */
  Inverter_001_DW.TmpRTBAtAdd10Inport2_Buffer0 = Inverter_001_P.Constant63_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd9Inport2' incorporates:
   *  Constant: '<Root>/Constant58'
   */
  Inverter_001_DW.TmpRTBAtAdd9Inport2_Buffer0 = Inverter_001_P.Constant58_Value;

  /* Update for RateTransition: '<Root>/TmpRTBAtConstant12Outport1' incorporates:
   *  Constant: '<Root>/Constant12'
   */
  Inverter_001_DW.TmpRTBAtConstant12Outport1_Buff =
    Inverter_001_P.Constant12_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd16Inport2' incorporates:
   *  Constant: '<Root>/Constant55'
   */
  Inverter_001_DW.TmpRTBAtAdd16Inport2_Buffer0 = Inverter_001_P.Constant55_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd5Inport2' incorporates:
   *  Constant: '<Root>/Constant65'
   */
  Inverter_001_DW.TmpRTBAtAdd5Inport2_Buffer0 = Inverter_001_P.Constant65_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd4Inport2' incorporates:
   *  Constant: '<Root>/Constant68'
   */
  Inverter_001_DW.TmpRTBAtAdd4Inport2_Buffer0 = Inverter_001_P.Constant68_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd3Inport2' incorporates:
   *  Constant: '<Root>/Constant57'
   */
  Inverter_001_DW.TmpRTBAtAdd3Inport2_Buffer0 = Inverter_001_P.Constant57_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd7Inport2' incorporates:
   *  Constant: '<Root>/Constant89'
   */
  Inverter_001_DW.TmpRTBAtAdd7Inport2_Buffer0 = Inverter_001_P.Constant89_Value;

  /* Update for RateTransition: '<S2>/TmpRTBAtAdd2Inport2' incorporates:
   *  Constant: '<Root>/Constant72'
   */
  Inverter_001_DW.TmpRTBAtAdd2Inport2_Buffer0 = Inverter_001_P.Constant72_Value;
}

/* Model initialize function */
void Inverter_001_initialize(void)
{
  /* Registration code */

  /* initialize real-time model */
  (void) memset((void *)Inverter_001_M, 0,
                sizeof(RT_MODEL_Inverter_001_T));

  /* block I/O */
  (void) memset(((void *) &Inverter_001_B), 0,
                sizeof(B_Inverter_001_T));

  /* states (dwork) */
  (void) memset((void *)&Inverter_001_DW, 0,
                sizeof(DW_Inverter_001_T));

  /* Start for RateTransition: '<Root>/TmpRTBAtConstant62Outport1' */
  Inverter_001_B.TmpRTBAtConstant62Outport1 =
    Inverter_001_P.TmpRTBAtConstant62Outport1_Init;

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd11Inport2' */
  Inverter_001_B.TmpRTBAtAdd11Inport2 =
    Inverter_001_P.TmpRTBAtAdd11Inport2_InitialCon;

  /* Start for RateTransition: '<Root>/Rate Transition1' */
  Inverter_001_B.RateTransition1 =
    Inverter_001_P.RateTransition1_InitialConditio;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output' */
  EALLOW;
  GpioCtrlRegs.GPBMUX2.all &= 0xF3FFFFFF;
  GpioCtrlRegs.GPBDIR.all |= 0x20000000;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output1' */
  EALLOW;
  GpioCtrlRegs.GPBMUX2.all &= 0x3FFFFFFF;
  GpioCtrlRegs.GPBDIR.all |= 0x80000000;
  EDIS;

  /* Start for S-Function (c280xgpio_do): '<Root>/Digital Output2' */
  EALLOW;
  GpioCtrlRegs.GPCMUX1.all &= 0xFFFFFFCF;
  GpioCtrlRegs.GPCDIR.all |= 0x4;
  EDIS;

  /* Start for S-Function (c2802xpwm): '<S4>/ePWM' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM5 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM5 modules ***/
  {
    /*  // Time Base Control Register
       EPwm5Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm5Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm5Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm5Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm5Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm5Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm5Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm5Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm5Regs.TBCTL.all = (EPwm5Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm5Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm5Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm5Regs.TBPHS.all = (EPwm5Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm5Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm5Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm5Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm5Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm5Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm5Regs.CMPCTL.all = (EPwm5Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm5Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm5Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm5Regs.CMPCTL2.all = (EPwm5Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm5Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm5Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm5Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm5Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm5Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm5Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm5Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm5Regs.AQSFRC.all = (EPwm5Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm5Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm5Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm5Regs.AQCSFRC.all = (EPwm5Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm5Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm5Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm5Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm5Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm5Regs.DBCTL.all = (EPwm5Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm5Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm5Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm5Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm5Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm5Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm5Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM5SOCA Period Select

       EPwm5Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm5Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm5Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm5Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM5SOCB Period Select
       EPwm5Regs.ETSEL.bit.INTEN                = 0;          // EPWM5INTn Enable
       EPwm5Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm5Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm5Regs.ETPS.bit.INTPRD                = 1;          // EPWM5INTn Period Select
     */
    EPwm5Regs.ETSEL.all = (EPwm5Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm5Regs.ETPS.all = (EPwm5Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm5Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm5Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm5Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm5Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm5Regs.PCCTL.all = (EPwm5Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm5Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm5Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM5A
       EPwm5Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM5B
       EPwm5Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM5A action on DCAEVT1
       EPwm5Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM5A action on DCAEVT2
       EPwm5Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM5B action on DCBEVT1
       EPwm5Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM5B action on DCBEVT2
     */
    EPwm5Regs.TZCTL.all = (EPwm5Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm5Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm5Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm5Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm5Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm5Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm5Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm5Regs.TZEINT.all = (EPwm5Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm5Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm5Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm5Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm5Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm5Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm5Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm5Regs.DCACTL.all = (EPwm5Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm5Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm5Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm5Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm5Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm5Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm5Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm5Regs.DCBCTL.all = (EPwm5Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm5Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm5Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm5Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm5Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm5Regs.DCTRIPSEL.all = (EPwm5Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm5Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm5Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm5Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm5Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm5Regs.TZDCSEL.all = (EPwm5Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm5Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm5Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm5Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm5Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm5Regs.DCFCTL.all = (EPwm5Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm5Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm5Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm5Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm5Regs.DCCAPCTL.all = (EPwm5Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm5Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm5Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm5Regs.HRCNFG.all = (EPwm5Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm5Regs.EPWMXLINK.bit.TBPRDLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPALINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPBLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPCLINK = 4;
    EPwm5Regs.EPWMXLINK.bit.CMPDLINK = 4;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S4>/ePWM1' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM3 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM3 modules ***/
  {
    /*  // Time Base Control Register
       EPwm3Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm3Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm3Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm3Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm3Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm3Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm3Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm3Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm3Regs.TBCTL.all = (EPwm3Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm3Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm3Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm3Regs.TBPHS.all = (EPwm3Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm3Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm3Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm3Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm3Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm3Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm3Regs.CMPCTL.all = (EPwm3Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm3Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm3Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm3Regs.CMPCTL2.all = (EPwm3Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm3Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm3Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm3Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm3Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm3Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm3Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm3Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm3Regs.AQSFRC.all = (EPwm3Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm3Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm3Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm3Regs.AQCSFRC.all = (EPwm3Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm3Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm3Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm3Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm3Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm3Regs.DBCTL.all = (EPwm3Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm3Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm3Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm3Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm3Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm3Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm3Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM3SOCA Period Select

       EPwm3Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm3Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm3Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm3Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM3SOCB Period Select
       EPwm3Regs.ETSEL.bit.INTEN                = 0;          // EPWM3INTn Enable
       EPwm3Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm3Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm3Regs.ETPS.bit.INTPRD                = 1;          // EPWM3INTn Period Select
     */
    EPwm3Regs.ETSEL.all = (EPwm3Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm3Regs.ETPS.all = (EPwm3Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm3Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm3Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm3Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm3Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm3Regs.PCCTL.all = (EPwm3Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm3Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm3Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM3A
       EPwm3Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM3B
       EPwm3Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM3A action on DCAEVT1
       EPwm3Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM3A action on DCAEVT2
       EPwm3Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM3B action on DCBEVT1
       EPwm3Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM3B action on DCBEVT2
     */
    EPwm3Regs.TZCTL.all = (EPwm3Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm3Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm3Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm3Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm3Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm3Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm3Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm3Regs.TZEINT.all = (EPwm3Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm3Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm3Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm3Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm3Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm3Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm3Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm3Regs.DCACTL.all = (EPwm3Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm3Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm3Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm3Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm3Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm3Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm3Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm3Regs.DCBCTL.all = (EPwm3Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm3Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm3Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm3Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm3Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm3Regs.DCTRIPSEL.all = (EPwm3Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm3Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm3Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm3Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm3Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm3Regs.TZDCSEL.all = (EPwm3Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm3Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm3Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm3Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm3Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm3Regs.DCFCTL.all = (EPwm3Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm3Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm3Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm3Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm3Regs.DCCAPCTL.all = (EPwm3Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm3Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm3Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm3Regs.HRCNFG.all = (EPwm3Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm3Regs.EPWMXLINK.bit.TBPRDLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPALINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPBLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPCLINK = 2;
    EPwm3Regs.EPWMXLINK.bit.CMPDLINK = 2;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S4>/ePWM2' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM6 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM6 modules ***/
  {
    /*  // Time Base Control Register
       EPwm6Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm6Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm6Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm6Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm6Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm6Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm6Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm6Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm6Regs.TBCTL.all = (EPwm6Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm6Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm6Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm6Regs.TBPHS.all = (EPwm6Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm6Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm6Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm6Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm6Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm6Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm6Regs.CMPCTL.all = (EPwm6Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm6Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm6Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm6Regs.CMPCTL2.all = (EPwm6Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm6Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm6Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm6Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm6Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm6Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm6Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm6Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm6Regs.AQSFRC.all = (EPwm6Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm6Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm6Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm6Regs.AQCSFRC.all = (EPwm6Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm6Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm6Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm6Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm6Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm6Regs.DBCTL.all = (EPwm6Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm6Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm6Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm6Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm6Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm6Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm6Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM6SOCA Period Select

       EPwm6Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm6Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm6Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm6Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM6SOCB Period Select
       EPwm6Regs.ETSEL.bit.INTEN                = 0;          // EPWM6INTn Enable
       EPwm6Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm6Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm6Regs.ETPS.bit.INTPRD                = 1;          // EPWM6INTn Period Select
     */
    EPwm6Regs.ETSEL.all = (EPwm6Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm6Regs.ETPS.all = (EPwm6Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm6Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm6Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm6Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm6Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm6Regs.PCCTL.all = (EPwm6Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm6Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm6Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM6A
       EPwm6Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM6B
       EPwm6Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM6A action on DCAEVT1
       EPwm6Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM6A action on DCAEVT2
       EPwm6Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM6B action on DCBEVT1
       EPwm6Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM6B action on DCBEVT2
     */
    EPwm6Regs.TZCTL.all = (EPwm6Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm6Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm6Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm6Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm6Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm6Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm6Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm6Regs.TZEINT.all = (EPwm6Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm6Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm6Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm6Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm6Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm6Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm6Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm6Regs.DCACTL.all = (EPwm6Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm6Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm6Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm6Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm6Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm6Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm6Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm6Regs.DCBCTL.all = (EPwm6Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm6Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm6Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm6Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm6Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm6Regs.DCTRIPSEL.all = (EPwm6Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm6Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm6Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm6Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm6Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm6Regs.TZDCSEL.all = (EPwm6Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm6Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm6Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm6Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm6Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm6Regs.DCFCTL.all = (EPwm6Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm6Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm6Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm6Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm6Regs.DCCAPCTL.all = (EPwm6Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm6Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm6Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm6Regs.HRCNFG.all = (EPwm6Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm6Regs.EPWMXLINK.bit.TBPRDLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPALINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPBLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPCLINK = 5;
    EPwm6Regs.EPWMXLINK.bit.CMPDLINK = 5;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xpwm): '<S4>/ePWM3' incorporates:
   *  Constant: '<Root>/Constant2'
   */
  EALLOW;
  CpuSysRegs.PCLKCR2.bit.EPWM4 = 1;
  CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
  EDIS;

  /*** Initialize ePWM4 modules ***/
  {
    /*  // Time Base Control Register
       EPwm4Regs.TBCTL.bit.CTRMODE              = 2;          // Counter Mode
       EPwm4Regs.TBCTL.bit.SYNCOSEL             = 3;          // Sync Output Select
       EPwm4Regs.TBCTL.bit.PRDLD                = 0;          // Shadow select
       EPwm4Regs.TBCTL.bit.PHSEN                = 0;          // Phase Load Enable
       EPwm4Regs.TBCTL.bit.PHSDIR               = 0;          // Phase Direction Bit
       EPwm4Regs.TBCTL.bit.HSPCLKDIV            = 0;          // High Speed TBCLK Pre-scaler
       EPwm4Regs.TBCTL.bit.CLKDIV               = 0;          // Time Base Clock Pre-scaler
       EPwm4Regs.TBCTL.bit.SWFSYNC              = 0;          // Software Force Sync Pulse
     */
    EPwm4Regs.TBCTL.all = (EPwm4Regs.TBCTL.all & ~0x3FFF) | 0x32;

    /*-- Setup Time-Base (TB) Submodule --*/
    EPwm4Regs.TBPRD = 12500;           // Time Base Period Register

    /* // Time-Base Phase Register
       EPwm4Regs.TBPHS.bit.TBPHS               = 0;          // Phase offset register
     */
    EPwm4Regs.TBPHS.all = (EPwm4Regs.TBPHS.all & ~0xFFFF0000) | 0x0;

    // Time Base Counter Register
    EPwm4Regs.TBCTR = 0x0000;          /* Clear counter*/

    /*-- Setup Counter_Compare (CC) Submodule --*/
    /*	// Counter Compare Control Register
       EPwm4Regs.CMPCTL.bit.SHDWAMODE           = 0;  // Compare A Register Block Operating Mode
       EPwm4Regs.CMPCTL.bit.SHDWBMODE           = 0;  // Compare B Register Block Operating Mode
       EPwm4Regs.CMPCTL.bit.LOADAMODE           = 0;          // Active Compare A Load
       EPwm4Regs.CMPCTL.bit.LOADBMODE           = 0;          // Active Compare B Load
     */
    EPwm4Regs.CMPCTL.all = (EPwm4Regs.CMPCTL.all & ~0x5F) | 0x0;

    /* EPwm4Regs.CMPCTL2.bit.SHDWCMODE           = 0;  // Compare C Register Block Operating Mode

       EPwm4Regs.CMPCTL2.bit.SHDWDMODE           = 0;  // Compare D Register Block Operating Mode
     */
    EPwm4Regs.CMPCTL2.all = (EPwm4Regs.CMPCTL2.all & ~0x50) | 0x0;
    EPwm4Regs.CMPA.bit.CMPA = 3750;    // Counter Compare A Register
    EPwm4Regs.CMPB.bit.CMPB = 3750;    // Counter Compare B Register
    EPwm4Regs.CMPC = 32000;            // Counter Compare C Register
    EPwm4Regs.CMPD = 32000;            // Counter Compare D Register

    /*-- Setup Action-Qualifier (AQ) Submodule --*/
    EPwm4Regs.AQCTLA.all = 150;        // Action Qualifier Control Register For Output A
    EPwm4Regs.AQCTLB.all = 1545;       // Action Qualifier Control Register For Output B

    /*	// Action Qualifier Software Force Register
       EPwm4Regs.AQSFRC.bit.RLDCSF              = 0;          // Reload from Shadow Options
     */
    EPwm4Regs.AQSFRC.all = (EPwm4Regs.AQSFRC.all & ~0xC0) | 0x0;

    /*	// Action Qualifier Continuous S/W Force Register
       EPwm4Regs.AQCSFRC.bit.CSFA               = 0;          // Continuous Software Force on output A
       EPwm4Regs.AQCSFRC.bit.CSFB               = 0;          // Continuous Software Force on output B
     */
    EPwm4Regs.AQCSFRC.all = (EPwm4Regs.AQCSFRC.all & ~0xF) | 0x0;

    /*-- Setup Dead-Band Generator (DB) Submodule --*/
    /*	// Dead-Band Generator Control Register
       EPwm4Regs.DBCTL.bit.OUT_MODE             = 3;          // Dead Band Output Mode Control
       EPwm4Regs.DBCTL.bit.IN_MODE              = 0;          // Dead Band Input Select Mode Control
       EPwm4Regs.DBCTL.bit.POLSEL               = 2;          // Polarity Select Control
       EPwm4Regs.DBCTL.bit.HALFCYCLE            = 0;          // Half Cycle Clocking Enable
     */
    EPwm4Regs.DBCTL.all = (EPwm4Regs.DBCTL.all & ~0x803F) | 0xB;
    EPwm4Regs.DBRED.bit.DBRED = 0;     // Dead-Band Generator Rising Edge Delay Count Register
    EPwm4Regs.DBFED.bit.DBFED = 0;     // Dead-Band Generator Falling Edge Delay Count Register

    /*-- Setup Event-Trigger (ET) Submodule --*/
    /*	// Event Trigger Selection and Pre-Scale Register
       EPwm4Regs.ETSEL.bit.SOCAEN               = 0;          // Start of Conversion A Enable
       EPwm4Regs.ETSEL.bit.SOCASELCMP = 0;
       EPwm4Regs.ETSEL.bit.SOCASEL              = 0 ;          // Start of Conversion A Select
       EPwm4Regs.ETPS.bit.SOCAPRD               = 1;          // EPWM4SOCA Period Select

       EPwm4Regs.ETSEL.bit.SOCBEN               = 0;          // Start of Conversion B Enable

       EPwm4Regs.ETSEL.bit.SOCBSELCMP = 0;
       EPwm4Regs.ETSEL.bit.SOCBSEL              = 1;          // Start of Conversion A Select
       EPwm4Regs.ETPS.bit.SOCBPRD               = 1;          // EPWM4SOCB Period Select
       EPwm4Regs.ETSEL.bit.INTEN                = 0;          // EPWM4INTn Enable
       EPwm4Regs.ETSEL.bit.INTSELCMP = 0;
       EPwm4Regs.ETSEL.bit.INTSEL              = 1;          // Start of Conversion A Select

       EPwm4Regs.ETPS.bit.INTPRD                = 1;          // EPWM4INTn Period Select
     */
    EPwm4Regs.ETSEL.all = (EPwm4Regs.ETSEL.all & ~0xFF7F) | 0x1001;
    EPwm4Regs.ETPS.all = (EPwm4Regs.ETPS.all & ~0x3303) | 0x1101;

    /*-- Setup PWM-Chopper (PC) Submodule --*/
    /*	// PWM Chopper Control Register
       EPwm4Regs.PCCTL.bit.CHPEN                = 0;          // PWM chopping enable
       EPwm4Regs.PCCTL.bit.CHPFREQ              = 0;          // Chopping clock frequency
       EPwm4Regs.PCCTL.bit.OSHTWTH              = 0;          // One-shot pulse width
       EPwm4Regs.PCCTL.bit.CHPDUTY              = 0;          // Chopping clock Duty cycle
     */
    EPwm4Regs.PCCTL.all = (EPwm4Regs.PCCTL.all & ~0x7FF) | 0x0;

    /*-- Set up Trip-Zone (TZ) Submodule --*/
    EALLOW;
    EPwm4Regs.TZSEL.all = 0;           // Trip Zone Select Register

    /*	// Trip Zone Control Register
       EPwm4Regs.TZCTL.bit.TZA                  = 3;          // TZ1 to TZ6 Trip Action On EPWM4A
       EPwm4Regs.TZCTL.bit.TZB                  = 3;          // TZ1 to TZ6 Trip Action On EPWM4B
       EPwm4Regs.TZCTL.bit.DCAEVT1              = 3;          // EPWM4A action on DCAEVT1
       EPwm4Regs.TZCTL.bit.DCAEVT2              = 3;          // EPWM4A action on DCAEVT2
       EPwm4Regs.TZCTL.bit.DCBEVT1              = 3;          // EPWM4B action on DCBEVT1
       EPwm4Regs.TZCTL.bit.DCBEVT2              = 3;          // EPWM4B action on DCBEVT2
     */
    EPwm4Regs.TZCTL.all = (EPwm4Regs.TZCTL.all & ~0xFFF) | 0xFFF;

    /*	// Trip Zone Enable Interrupt Register
       EPwm4Regs.TZEINT.bit.OST                 = 0;          // Trip Zones One Shot Int Enable
       EPwm4Regs.TZEINT.bit.CBC                 = 0;          // Trip Zones Cycle By Cycle Int Enable
       EPwm4Regs.TZEINT.bit.DCAEVT1             = 0;          // Digital Compare A Event 1 Int Enable
       EPwm4Regs.TZEINT.bit.DCAEVT2             = 0;          // Digital Compare A Event 2 Int Enable
       EPwm4Regs.TZEINT.bit.DCBEVT1             = 0;          // Digital Compare B Event 1 Int Enable
       EPwm4Regs.TZEINT.bit.DCBEVT2             = 0;          // Digital Compare B Event 2 Int Enable
     */
    EPwm4Regs.TZEINT.all = (EPwm4Regs.TZEINT.all & ~0x7E) | 0x0;

    /*	// Digital Compare A Control Register
       EPwm4Regs.DCACTL.bit.EVT1SYNCE           = 0;          // DCAEVT1 SYNC Enable
       EPwm4Regs.DCACTL.bit.EVT1SOCE            = 1;          // DCAEVT1 SOC Enable
       EPwm4Regs.DCACTL.bit.EVT1FRCSYNCSEL      = 0;          // DCAEVT1 Force Sync Signal
       EPwm4Regs.DCACTL.bit.EVT1SRCSEL          = 0;          // DCAEVT1 Source Signal
       EPwm4Regs.DCACTL.bit.EVT2FRCSYNCSEL      = 0;          // DCAEVT2 Force Sync Signal
       EPwm4Regs.DCACTL.bit.EVT2SRCSEL          = 0;          // DCAEVT2 Source Signal
     */
    EPwm4Regs.DCACTL.all = (EPwm4Regs.DCACTL.all & ~0x30F) | 0x4;

    /*	// Digital Compare B Control Register
       EPwm4Regs.DCBCTL.bit.EVT1SYNCE           = 0;          // DCBEVT1 SYNC Enable
       EPwm4Regs.DCBCTL.bit.EVT1SOCE            = 0;          // DCBEVT1 SOC Enable
       EPwm4Regs.DCBCTL.bit.EVT1FRCSYNCSEL      = 0;          // DCBEVT1 Force Sync Signal
       EPwm4Regs.DCBCTL.bit.EVT1SRCSEL          = 0;          // DCBEVT1 Source Signal
       EPwm4Regs.DCBCTL.bit.EVT2FRCSYNCSEL      = 0;          // DCBEVT2 Force Sync Signal
       EPwm4Regs.DCBCTL.bit.EVT2SRCSEL          = 0;          // DCBEVT2 Source Signal
     */
    EPwm4Regs.DCBCTL.all = (EPwm4Regs.DCBCTL.all & ~0x30F) | 0x0;

    /*	// Digital Compare Trip Select Register
       EPwm4Regs.DCTRIPSEL.bit.DCAHCOMPSEL      = 0;          // Digital Compare A High COMP Input Select

       EPwm4Regs.DCTRIPSEL.bit.DCALCOMPSEL      = 1;          // Digital Compare A Low COMP Input Select
       EPwm4Regs.DCTRIPSEL.bit.DCBHCOMPSEL      = 0;          // Digital Compare B High COMP Input Select
       EPwm4Regs.DCTRIPSEL.bit.DCBLCOMPSEL      = 1;          // Digital Compare B Low COMP Input Select





     */
    EPwm4Regs.DCTRIPSEL.all = (EPwm4Regs.DCTRIPSEL.all & ~ 0xFFFF) | 0x1010;

    /*	// Trip Zone Digital Comparator Select Register
       EPwm4Regs.TZDCSEL.bit.DCAEVT1            = 0;          // Digital Compare Output A Event 1
       EPwm4Regs.TZDCSEL.bit.DCAEVT2            = 0;          // Digital Compare Output A Event 2
       EPwm4Regs.TZDCSEL.bit.DCBEVT1            = 0;          // Digital Compare Output B Event 1
       EPwm4Regs.TZDCSEL.bit.DCBEVT2            = 0;          // Digital Compare Output B Event 2
     */
    EPwm4Regs.TZDCSEL.all = (EPwm4Regs.TZDCSEL.all & ~0xFFF) | 0x0;

    /*	// Digital Compare Filter Control Register
       EPwm4Regs.DCFCTL.bit.BLANKE              = 0;          // Blanking Enable/Disable
       EPwm4Regs.DCFCTL.bit.PULSESEL            = 1;          // Pulse Select for Blanking & Capture Alignment
       EPwm4Regs.DCFCTL.bit.BLANKINV            = 0;          // Blanking Window Inversion
       EPwm4Regs.DCFCTL.bit.SRCSEL              = 0;          // Filter Block Signal Source Select
     */
    EPwm4Regs.DCFCTL.all = (EPwm4Regs.DCFCTL.all & ~0x3F) | 0x10;
    EPwm4Regs.DCFOFFSET = 0;           // Digital Compare Filter Offset Register
    EPwm4Regs.DCFWINDOW = 0;           // Digital Compare Filter Window Register

    /*	// Digital Compare Capture Control Register
       EPwm4Regs.DCCAPCTL.bit.CAPE              = 0;          // Counter Capture Enable
     */
    EPwm4Regs.DCCAPCTL.all = (EPwm4Regs.DCCAPCTL.all & ~0x1) | 0x0;

    /*	// HRPWM Configuration Register
       EPwm4Regs.HRCNFG.bit.SWAPAB              = 0;          // Swap EPWMA and EPWMB Outputs Bit
       EPwm4Regs.HRCNFG.bit.SELOUTB             = 0;          // EPWMB Output Selection Bit
     */
    EPwm4Regs.HRCNFG.all = (EPwm4Regs.HRCNFG.all & ~0xA0) | 0x0;

    /* Update the Link Registers with the link value for all the Compare values and TBPRD */
    /* No error is thrown if the ePWM register exists in the model or not */
    EPwm4Regs.EPWMXLINK.bit.TBPRDLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPALINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPBLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPCLINK = 3;
    EPwm4Regs.EPWMXLINK.bit.CMPDLINK = 3;
    EDIS;
    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;
  }

  /* Start for S-Function (c2802xadc): '<S2>/ADC2' */
  if (adcDInitFlag == 0) {
    InitAdcD();
    adcDInitFlag = 1;
  }

  config_ADCD_SOC2 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd10Inport2' */
  Inverter_001_B.TmpRTBAtAdd10Inport2 =
    Inverter_001_P.TmpRTBAtAdd10Inport2_InitialCon;

  /* Start for S-Function (c2802xadc): '<S2>/ADC3' */
  if (adcDInitFlag == 0) {
    InitAdcD();
    adcDInitFlag = 1;
  }

  config_ADCD_SOC5 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd9Inport2' */
  Inverter_001_B.TmpRTBAtAdd9Inport2 =
    Inverter_001_P.TmpRTBAtAdd9Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC4' */
  if (adcDInitFlag == 0) {
    InitAdcD();
    adcDInitFlag = 1;
  }

  config_ADCD_SOC7 ();

  /* Start for RateTransition: '<Root>/TmpRTBAtConstant12Outport1' */
  Inverter_001_B.TmpRTBAtConstant12Outport1 =
    Inverter_001_P.TmpRTBAtConstant12Outport1_Init;

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd16Inport2' */
  Inverter_001_B.TmpRTBAtAdd16Inport2 =
    Inverter_001_P.TmpRTBAtAdd16Inport2_InitialCon;

  /* Start for S-Function (c2802xadc): '<S2>/ADC5' */
  if (adcAInitFlag == 0) {
    InitAdcA();
    adcAInitFlag = 1;
  }

  config_ADCA_SOC4 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd5Inport2' */
  Inverter_001_B.TmpRTBAtAdd5Inport2 =
    Inverter_001_P.TmpRTBAtAdd5Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC6' */
  if (adcAInitFlag == 0) {
    InitAdcA();
    adcAInitFlag = 1;
  }

  config_ADCA_SOC6 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd4Inport2' */
  Inverter_001_B.TmpRTBAtAdd4Inport2 =
    Inverter_001_P.TmpRTBAtAdd4Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC7' */
  if (adcAInitFlag == 0) {
    InitAdcA();
    adcAInitFlag = 1;
  }

  config_ADCA_SOC8 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd3Inport2' */
  Inverter_001_B.TmpRTBAtAdd3Inport2 =
    Inverter_001_P.TmpRTBAtAdd3Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC9' */
  if (adcCInitFlag == 0) {
    InitAdcC();
    adcCInitFlag = 1;
  }

  config_ADCC_SOC10 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd7Inport2' */
  Inverter_001_B.TmpRTBAtAdd7Inport2 =
    Inverter_001_P.TmpRTBAtAdd7Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC10' */
  if (adcCInitFlag == 0) {
    InitAdcC();
    adcCInitFlag = 1;
  }

  config_ADCC_SOC11 ();

  /* Start for RateTransition: '<S2>/TmpRTBAtAdd2Inport2' */
  Inverter_001_B.TmpRTBAtAdd2Inport2 =
    Inverter_001_P.TmpRTBAtAdd2Inport2_InitialCond;

  /* Start for S-Function (c2802xadc): '<S2>/ADC11' */
  if (adcCInitFlag == 0) {
    InitAdcC();
    adcCInitFlag = 1;
  }

  config_ADCC_SOC12 ();

  /* Start for S-Function (c2837xdipc_rx): '<Root>/IPC Receive' */
  IPCInit(CHANNEL0, 1);

  /* Start for MATLABSystem: '<Root>/DAC' */
  MW_ConfigureDACA();

  /* Start for MATLABSystem: '<Root>/DAC1' */
  MW_ConfigureDACB();

  /* Start for MATLABSystem: '<Root>/DAC2' */
  MW_ConfigureDACC();

  /* InitializeConditions for RateTransition: '<Root>/TmpRTBAtConstant62Outport1' */
  Inverter_001_DW.TmpRTBAtConstant62Outport1_Buff =
    Inverter_001_P.TmpRTBAtConstant62Outport1_Init;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd11Inport2' */
  Inverter_001_DW.TmpRTBAtAdd11Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd11Inport2_InitialCon;

  /* InitializeConditions for RateTransition: '<Root>/Rate Transition1' */
  Inverter_001_DW.RateTransition1_Buffer0 =
    Inverter_001_P.RateTransition1_InitialConditio;

  /* InitializeConditions for UnitDelay: '<S34>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_lw =
    Inverter_001_P.UnitDelay_InitialCondition_pq;

  /* InitializeConditions for UnitDelay: '<S7>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE = Inverter_001_P.UnitDelay_InitialCondition;

  /* InitializeConditions for UnitDelay: '<S7>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE = Inverter_001_P.UnitDelay1_InitialCondition;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd10Inport2' */
  Inverter_001_DW.TmpRTBAtAdd10Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd10Inport2_InitialCon;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd9Inport2' */
  Inverter_001_DW.TmpRTBAtAdd9Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd9Inport2_InitialCond;

  /* InitializeConditions for RateTransition: '<Root>/TmpRTBAtConstant12Outport1' */
  Inverter_001_DW.TmpRTBAtConstant12Outport1_Buff =
    Inverter_001_P.TmpRTBAtConstant12Outport1_Init;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd16Inport2' */
  Inverter_001_DW.TmpRTBAtAdd16Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd16Inport2_InitialCon;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd5Inport2' */
  Inverter_001_DW.TmpRTBAtAdd5Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd5Inport2_InitialCond;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd4Inport2' */
  Inverter_001_DW.TmpRTBAtAdd4Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd4Inport2_InitialCond;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd3Inport2' */
  Inverter_001_DW.TmpRTBAtAdd3Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd3Inport2_InitialCond;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd7Inport2' */
  Inverter_001_DW.TmpRTBAtAdd7Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd7Inport2_InitialCond;

  /* InitializeConditions for RateTransition: '<S2>/TmpRTBAtAdd2Inport2' */
  Inverter_001_DW.TmpRTBAtAdd2Inport2_Buffer0 =
    Inverter_001_P.TmpRTBAtAdd2Inport2_InitialCond;

  /* InitializeConditions for UnitDelay: '<S8>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_c =
    Inverter_001_P.UnitDelay_InitialCondition_e;

  /* InitializeConditions for UnitDelay: '<S8>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_k =
    Inverter_001_P.UnitDelay1_InitialCondition_g;

  /* InitializeConditions for UnitDelay: '<S9>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_f =
    Inverter_001_P.UnitDelay_InitialCondition_i;

  /* InitializeConditions for UnitDelay: '<S9>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_j =
    Inverter_001_P.UnitDelay1_InitialCondition_b;

  /* InitializeConditions for UnitDelay: '<S10>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_g =
    Inverter_001_P.UnitDelay_InitialCondition_n;

  /* InitializeConditions for UnitDelay: '<S10>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_l =
    Inverter_001_P.UnitDelay1_InitialCondition_a;

  /* InitializeConditions for UnitDelay: '<S11>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_k =
    Inverter_001_P.UnitDelay_InitialCondition_c;

  /* InitializeConditions for UnitDelay: '<S11>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_h =
    Inverter_001_P.UnitDelay1_InitialCondition_l;

  /* InitializeConditions for UnitDelay: '<S12>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_p =
    Inverter_001_P.UnitDelay_InitialCondition_cr;

  /* InitializeConditions for UnitDelay: '<S12>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_i =
    Inverter_001_P.UnitDelay1_InitialCondition_l1;

  /* InitializeConditions for UnitDelay: '<S13>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_d =
    Inverter_001_P.UnitDelay_InitialCondition_k;

  /* InitializeConditions for UnitDelay: '<S13>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_hy =
    Inverter_001_P.UnitDelay1_InitialCondition_f;

  /* InitializeConditions for UnitDelay: '<S14>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_j =
    Inverter_001_P.UnitDelay_InitialCondition_d;

  /* InitializeConditions for UnitDelay: '<S14>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_jm =
    Inverter_001_P.UnitDelay1_InitialCondition_m;

  /* InitializeConditions for UnitDelay: '<S15>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_l =
    Inverter_001_P.UnitDelay_InitialCondition_p;

  /* InitializeConditions for UnitDelay: '<S15>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_p =
    Inverter_001_P.UnitDelay1_InitialCondition_e;

  /* InitializeConditions for UnitDelay: '<S30>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE = Inverter_001_P.UnitDelay3_InitialCondition;

  /* InitializeConditions for UnitDelay: '<S30>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE = Inverter_001_P.UnitDelay2_InitialCondition;

  /* InitializeConditions for UnitDelay: '<S30>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_b =
    Inverter_001_P.UnitDelay1_InitialCondition_b1;

  /* InitializeConditions for UnitDelay: '<S29>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_c =
    Inverter_001_P.UnitDelay3_InitialCondition_g;

  /* InitializeConditions for UnitDelay: '<S29>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE_h =
    Inverter_001_P.UnitDelay2_InitialCondition_h;

  /* InitializeConditions for UnitDelay: '<S29>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_d =
    Inverter_001_P.UnitDelay1_InitialCondition_gr;

  /* InitializeConditions for UnitDelay: '<S28>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_m =
    Inverter_001_P.UnitDelay3_InitialCondition_o;

  /* InitializeConditions for UnitDelay: '<S28>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE_g =
    Inverter_001_P.UnitDelay2_InitialCondition_m;

  /* InitializeConditions for UnitDelay: '<S28>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_hyo =
    Inverter_001_P.UnitDelay1_InitialCondition_lk;

  /* InitializeConditions for UnitDelay: '<S28>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_lt =
    Inverter_001_P.UnitDelay_InitialCondition_ck;

  /* InitializeConditions for UnitDelay: '<S24>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_o =
    Inverter_001_P.UnitDelay3_InitialCondition_j;

  /* InitializeConditions for UnitDelay: '<S24>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE_gq =
    Inverter_001_P.UnitDelay2_InitialCondition_k;

  /* InitializeConditions for UnitDelay: '<S24>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_c =
    Inverter_001_P.UnitDelay1_InitialCondition_h;

  /* InitializeConditions for UnitDelay: '<S24>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_a =
    Inverter_001_P.UnitDelay_InitialCondition_ph;

  /* InitializeConditions for UnitDelay: '<S29>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_o =
    Inverter_001_P.UnitDelay_InitialCondition_f;

  /* InitializeConditions for UnitDelay: '<S25>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_g =
    Inverter_001_P.UnitDelay3_InitialCondition_p;

  /* InitializeConditions for UnitDelay: '<S25>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE_m =
    Inverter_001_P.UnitDelay2_InitialCondition_b;

  /* InitializeConditions for UnitDelay: '<S25>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_m =
    Inverter_001_P.UnitDelay1_InitialCondition_fy;

  /* InitializeConditions for UnitDelay: '<S25>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_m =
    Inverter_001_P.UnitDelay_InitialCondition_g;

  /* InitializeConditions for UnitDelay: '<S30>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_i =
    Inverter_001_P.UnitDelay_InitialCondition_nv;

  /* InitializeConditions for UnitDelay: '<S26>/Unit Delay3' */
  Inverter_001_DW.UnitDelay3_DSTATE_h =
    Inverter_001_P.UnitDelay3_InitialCondition_d;

  /* InitializeConditions for UnitDelay: '<S26>/Unit Delay2' */
  Inverter_001_DW.UnitDelay2_DSTATE_gh =
    Inverter_001_P.UnitDelay2_InitialCondition_f;

  /* InitializeConditions for UnitDelay: '<S26>/Unit Delay' */
  Inverter_001_DW.UnitDelay_DSTATE_ci =
    Inverter_001_P.UnitDelay_InitialCondition_e3;

  /* InitializeConditions for UnitDelay: '<S26>/Unit Delay1' */
  Inverter_001_DW.UnitDelay1_DSTATE_g =
    Inverter_001_P.UnitDelay1_InitialCondition_n;
}

/* Model terminate function */
void Inverter_001_terminate(void)
{
  /* (no terminate code required) */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
