#include "F2837xD_device.h"
#include "F2837xD_Examples.h"
#include "F2837xD_GlobalPrototypes.h"
#include "rtwtypes.h"
#include "Inverter_001.h"
#include "Inverter_001_private.h"

void config_ADCC_SOC11()
{
  EALLOW;
  AdccRegs.ADCSOC11CTL.bit.CHSEL = 3;  /* Set SOC11 channel select to ADCIN3*/
  AdccRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
  AdccRegs.ADCSOC11CTL.bit.ACQPS = 14; /* Set SOC11 S/H Window to 15 ADC Clock Cycles*/
  AdccRegs.ADCINTSOCSEL2.bit.SOC11 = 1;/* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdccRegs.ADCOFFTRIM.bit.OFFTRIM = AdccRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdccRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCC_SOC12()
{
  EALLOW;
  AdccRegs.ADCSOC12CTL.bit.CHSEL = 4;  /* Set SOC12 channel select to ADCIN4*/
  AdccRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
  AdccRegs.ADCSOC12CTL.bit.ACQPS = 14; /* Set SOC12 S/H Window to 15 ADC Clock Cycles*/
  AdccRegs.ADCINTSOCSEL2.bit.SOC12 = 1;/* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdccRegs.ADCOFFTRIM.bit.OFFTRIM = AdccRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdccRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC2()
{
  EALLOW;
  AdcdRegs.ADCSOC2CTL.bit.CHSEL = 2;   /* Set SOC2 channel select to ADCIN2*/
  AdcdRegs.ADCSOC2CTL.bit.TRIGSEL = 0;
  AdcdRegs.ADCSOC2CTL.bit.ACQPS = 14;  /* Set SOC2 S/H Window to 15 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC2 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC5()
{
  EALLOW;
  AdcdRegs.ADCSOC5CTL.bit.CHSEL = 3;   /* Set SOC5 channel select to ADCIN3*/
  AdcdRegs.ADCSOC5CTL.bit.TRIGSEL = 0;
  AdcdRegs.ADCSOC5CTL.bit.ACQPS = 14;  /* Set SOC5 S/H Window to 15 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC5 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC7()
{
  EALLOW;
  AdcdRegs.ADCSOC7CTL.bit.CHSEL = 4;   /* Set SOC7 channel select to ADCIN4*/
  AdcdRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
  AdcdRegs.ADCSOC7CTL.bit.ACQPS = 14;  /* Set SOC7 S/H Window to 15 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC7 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC4()
{
  EALLOW;
  AdcaRegs.ADCSOC4CTL.bit.CHSEL = 2;   /* Set SOC4 channel select to ADCIN2*/
  AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 0;
  AdcaRegs.ADCSOC4CTL.bit.ACQPS = 14;  /* Set SOC4 S/H Window to 15 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL1.bit.SOC4 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC6()
{
  EALLOW;
  AdcaRegs.ADCSOC6CTL.bit.CHSEL = 3;   /* Set SOC6 channel select to ADCIN3*/
  AdcaRegs.ADCSOC6CTL.bit.TRIGSEL = 0;
  AdcaRegs.ADCSOC6CTL.bit.ACQPS = 14;  /* Set SOC6 S/H Window to 15 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL1.bit.SOC6 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC8()
{
  EALLOW;
  AdcaRegs.ADCSOC8CTL.bit.CHSEL = 4;   /* Set SOC8 channel select to ADCIN4*/
  AdcaRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
  AdcaRegs.ADCSOC8CTL.bit.ACQPS = 14;  /* Set SOC8 S/H Window to 15 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL2.bit.SOC8 = 1; /* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCC_SOC10()
{
  EALLOW;
  AdccRegs.ADCSOC10CTL.bit.CHSEL = 2;  /* Set SOC10 channel select to ADCIN2*/
  AdccRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
  AdccRegs.ADCSOC10CTL.bit.ACQPS = 14; /* Set SOC10 S/H Window to 15 ADC Clock Cycles*/
  AdccRegs.ADCINTSOCSEL2.bit.SOC10 = 1;/* SOCx ADCINT1 Interrupt Trigger Select.*/
  AdccRegs.ADCOFFTRIM.bit.OFFTRIM = AdccRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;/* Late interrupt pulse trips AdcResults latch*/
  AdccRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void InitAdcA()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_A = 1;
  AdcaRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCA, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcC()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_C = 1;
  AdccRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCC, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcD()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_D = 1;
  AdcdRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCD, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcdRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}
