% system parmeters %
% for "Three_phase_4leg_state_space_control_v05.mdl" %

%Tsample = 2e-7;
%Tsample = 2e-6;

% reference voltage %
V1 = 230;
V2 = 230;
V3 = 230;
% reference current %
I1 = 40;
I2 = 40;
I3 = 40;

% DC voltage / input voltage%
Vdc = 670;

% switching frequence %
fsw = 4000;

% LC filtar parameters %
L = 3e-3;
RL = 7.5e-3*1;
C = 33.8e-6*3;
RC = 40e-3*1;
Ln = 3e-3;
RLn = 7.5e-3*1;

% 3 phase load parameters %
% input %
S_out3ph = 35e3;
cos_phi = 0.8;
S_out3ph_min = 2e3;
cos_phi_min = 0.8;
P_out1ph_a = 3.6e3;
P_out1ph_b = 3.6e3;
P_out1ph_c = 3.6e3;

% calculations %
P_out3ph = S_out3ph * cos_phi;
Q_out3ph = sqrt(S_out3ph^2 - P_out3ph^2);
% 3 phase resistance and inductance calculation, voltage = 400 Veff %
R_out3ph = (400 / S_out3ph)^2 * P_out3ph;
L_out3ph = (400 / S_out3ph)^2 * Q_out3ph / (2*3.14*50);
C_out3ph = 1/( (400 / S_out3ph)^2 * Q_out3ph * (2*3.14*50) );
% minimum load - heatsink fan %
P_out3ph_min = S_out3ph_min * cos_phi_min;
Q_out3ph_min = sqrt(S_out3ph_min^2 - P_out3ph_min^2);
% 3 phase resistance and inductance calculation, voltage = 400 Veff %
R_out3ph_min = (400 / S_out3ph_min)^2 * P_out3ph_min;
L_out3ph_min = (400 / S_out3ph_min)^2 * Q_out3ph_min / (2*3.14*50);
% 1 phase resistance, voltage = 230 Veff%
R_out1ph_a = 230^2 / P_out1ph_a;
R_out1ph_b = 230^2 / P_out1ph_b;
R_out1ph_c = 230^2 / P_out1ph_c;

% 3 phase load parameters %
Ra_load = R_out3ph;
La_load = L_out3ph;

% 3 phase minimum load parameters %
Ra_load_min = R_out3ph_min;
La_load_min = L_out3ph_min;

% 1 phase load parameters %
Ra_load1f = R_out1ph_a;
Rb_load1f = R_out1ph_b;
Rc_load1f = R_out1ph_c;

% Current and voltage loop testing %
w = 314.1592;

% Current and voltage loop testing %
w = 314.1592;
tm = 20e-3;
wn = pi*sqrt(2)/tm;

% Current loop parameters %
Kcp_rac = L*sqrt(2)*wn;
Tci_rac = sqrt(2)/wn;
Kci_rac = Kcp_rac/Tci_rac;
Kc0p_rac = (L+3*Ln)*sqrt(2)*wn;
Tc0i_rac = sqrt(2)/wn;
Kc0i_rac = Kc0p_rac/Tc0i_rac;
% Voltage loop parameters %
Kvp_rac = 0.3326;
Kvi_rac = 13.0598;
Kv0p_rac = Kvp_rac;
Kv0i_rac = Kvi_rac;
% ------------------------------ %
Kcp = Kcp_rac*20;
Kci = Kci_rac/2;
Kcp0 = Kc0p_rac*20;
Kci0 = Kc0i_rac/2;

Kvp = Kvp_rac/20    *2*2;
Kvi = Kvi_rac/50    *5*2;
Kvp0 = Kv0p_rac/20  *2*2;
Kvi0 = Kv0i_rac/50  *5*2;

Kcr = 1     *1      *1;
Kvr = 1     *1;

%return