/*
 * DigitalPowerLibVariables.h
 *
 *  Created on: Sep 7, 2018
 *      Author: ASUS Performance Lap
 */

#ifndef DIGITALPOWERLIBVARIABLES_H_
#define DIGITALPOWERLIBVARIABLES_H_

#include "DPlib.h"
#include "IQmathLib.h"

extern void PWM_1ch_CNF(int16 n, Uint16 period, int16 mode, int16 phase);
extern void ADC_CNF(int AdcNum, int ChSel[], int TrigSel[], int ACQPS[]);

extern void PWMDRVfnc();
extern void ADCDRVfnc();
extern void GEN_SIN_COSfnc();
extern void CurrLoopfnc();
extern void NotchFilterfnc();
extern void PLLControllerfnc();

// ---------------------------- DPLIB Net Pointers --------------------
// Declare net pointers that are used to connect the DP Lib Macros here
// and the data variables being used by the macros internally

//PWMDRV_1ch - instance #1
extern volatile float *PWMDRV_1ch_Duty1;
//PWMDRV_1ch - instance #2
extern volatile float *PWMDRV_1ch_Duty2;

//GEN_SIN_COS
extern volatile long *GEN_SIN_COS_Sin_0;
extern volatile long *GEN_SIN_COS_Sin_1;
extern volatile long *GEN_SIN_COS_Cos_0;
extern volatile long *GEN_SIN_COS_Cos_1;
extern volatile long *GEN_SIN_COS_Max;
extern volatile long *GEN_SIN_COS_Min;
extern volatile long *GEN_SIN_COS_Ws;
extern volatile long *GEN_SIN_COS_Ts;

//ADC1DRV_1ch - instance #0
extern volatile float *ADC1DRV_1ch_Rlt0;
//ADC1DRV_1ch - instance #1
extern volatile float *ADC1DRV_1ch_Rlt1;
//ADC1DRV_1ch - instance #2
extern volatile float *ADC1DRV_1ch_Rlt2;
//ADC1DRV_1ch - instance #3
extern volatile float *ADC1DRV_1ch_Rlt3;
//ADC1DRV_1ch - instance #4
extern volatile float *ADC1DRV_1ch_Rlt4;
//ADC1DRV_1ch - instance #5
extern volatile float *ADC1DRV_1ch_Rlt5;
//ADC1DRV_1ch - instance #6
extern volatile float *ADC1DRV_1ch_Rlt6;
//ADC1DRV_1ch - instance #7
extern volatile float *ADC1DRV_1ch_Rlt7;

//CNTL_2P2Z- instance #1 for Current controller
extern volatile float *CNTL_2P2Z_Ref1;
extern volatile float *CNTL_2P2Z_Out1;
extern volatile float *CNTL_2P2Z_Fdbk1;
extern volatile float *CNTL_2P2Z_Coef1;

// CONTROL_2P2Z - instance #2 notch filter
extern volatile float *CNTL_2P2Z_Ref2;
extern volatile float *CNTL_2P2Z_Out2;
extern volatile float *CNTL_2P2Z_Fdbk2;
extern volatile float *CNTL_2P2Z_Coef2;

// CONTROL_2P2Z - instance #3 PLL controller
extern volatile float *CNTL_2P2Z_Ref3;
extern volatile float *CNTL_2P2Z_Out3;
extern volatile float *CNTL_2P2Z_Fdbk3;
extern volatile float *CNTL_2P2Z_Coef3;


// ---------------------------- DPLIB Variables -----------------------
// Declare the net variables being used by the DP Lib Macro here
volatile float Duty1,Duty2;
volatile long Sin_0,Sin_Out,Cos_0,Cos_out,dwPllCon_Out,Sin_Cos_Max,Sin_Cos_Min,Trace_Freq,Sample_Time,Pll_Trace_Freq = 0;
volatile float ADC1_A0,ADC1_A2,ADC1_A3,ADC1_A4,ADC1_A6,ADC1_A7,ADC1_B0,ADC1_B4;
volatile float Ref1 , Fdbk1 , CTLOut1;
volatile float Ref2 , Fdbk2 , CTLOut2;
volatile float Ref3 , Fdbk3 , CTLOut3;
volatile float Phase_Err_Notch_Out;

#pragma DATA_SECTION(CNTL_2P2Z_CoefStruct1, "CNTL_2P2Z_Coef");
struct CNTL_2P2Z_CoefStruct CNTL_2P2Z_CoefStruct1;
struct CNTL_2P2Z_CoefStruct CNTL_2P2Z_CoefStruct2;
struct CNTL_2P2Z_CoefStruct CNTL_2P2Z_CoefStruct3;

// Used to indirectly access all EPWM modules
volatile struct EPWM_REGS *ePWM[] =
{       &EPwm1Regs,           //intentional: (ePWM[0] not used)
        &EPwm1Regs,
        &EPwm2Regs,
        &EPwm3Regs,
        &EPwm4Regs,
        &EPwm5Regs,
        &EPwm6Regs,
        &EPwm7Regs,
        &EPwm8Regs,
        &EPwm9Regs
};

volatile struct ADC_REGS *ADC[] =
{       &Adc1Regs,            //intentional: (ADC[0] not used)
        &Adc1Regs,
        &Adc2Regs
};

// Used for ADC Configuration
int     ChSel1[16] =   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int     TrigSel1[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int     ACQPS1[16] =   {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10};

//These are added by TRD //controlling support varibles
float phase_error_max =1.0;
float phase_error_min = -1.0;
volatile float phase_error = 0.0;

void InitializePowerLibVariables()
{
    // ADC Channel Selection for Configuring the ADC
    //Map channel to ADC Pin
    ChSel1[0] = 0;
    ChSel1[1] = 2;
    ChSel1[2] = 3;
    ChSel1[3] = 4;
    ChSel1[4] = 6;
    ChSel1[5] = 7;
    ChSel1[6] = 8;
    ChSel1[7] = 12;

//    ChSel1[0] = 8;
//    ChSel1[1] = 8;
//    ChSel1[2] = 2;
//    ChSel1[3] = 2;
//    ChSel1[4] = 3;
//    ChSel1[5] = 3;
//    ChSel1[6] = 4;
//    ChSel1[7] = 4;

    // Select Trigger Event
    TrigSel1[0] = 5;
    TrigSel1[1] = 5;
    TrigSel1[2] = 5;
    TrigSel1[3] = 5;
    TrigSel1[4] = 5;
    TrigSel1[5] = 5;
    TrigSel1[6] = 5;
    TrigSel1[7] = 5;

    ADC_CNF(1, ChSel1, TrigSel1, ACQPS1);
    PWM_1ch_CNF(1,7500,1,0);
    PWM_1ch_CNF(2,7500,0,0);
    //----------Connect the macros to build a system-------------------
    // Digital Power (DP) library initialisation
    DPL_Init();

    //ADCDRV block connections
    ADC1DRV_1ch_Rlt0=&ADC1_A0;
    ADC1DRV_1ch_Rlt1=&ADC1_A2;
    ADC1DRV_1ch_Rlt2=&ADC1_A3;
    ADC1DRV_1ch_Rlt3=&ADC1_A4;
    ADC1DRV_1ch_Rlt4=&ADC1_A6;
    ADC1DRV_1ch_Rlt5=&ADC1_A7;
    ADC1DRV_1ch_Rlt6=&ADC1_B0;
    ADC1DRV_1ch_Rlt7=&ADC1_B4;

    // PWMDRV_1ch block connections
    PWMDRV_1ch_Duty1=&Duty1;
    PWMDRV_1ch_Duty2=&Duty2;

    //Sin_Cos generator block connections
    GEN_SIN_COS_Sin_0 = &Sin_0;
    GEN_SIN_COS_Sin_1 = &Sin_Out;
    GEN_SIN_COS_Cos_0 = &Cos_0;
    GEN_SIN_COS_Cos_1 = &Cos_out;
    GEN_SIN_COS_Max = &Sin_Cos_Max;
    GEN_SIN_COS_Min = &Sin_Cos_Min;
    GEN_SIN_COS_Ws = &Trace_Freq;
    GEN_SIN_COS_Ts = &Sample_Time;

    // Connect the CNTL_2P2Z block for current controller to the variables
    CNTL_2P2Z_Fdbk1 = &Fdbk1;
    CNTL_2P2Z_Out1 = &CTLOut1;
    CNTL_2P2Z_Ref1 = &Ref1;
    CNTL_2P2Z_Coef1 = &CNTL_2P2Z_CoefStruct1.b2;

    // Connect the CNTL_2P2Z block for notch filter to the variables
    CNTL_2P2Z_Fdbk2 = &Fdbk2;
    CNTL_2P2Z_Out2 = &CTLOut2;
    CNTL_2P2Z_Ref2 = &Ref2;
    CNTL_2P2Z_Coef2 = &CNTL_2P2Z_CoefStruct2.b2;

    // Connect the CNTL_2P2Z block for pll controller to the variables
    CNTL_2P2Z_Fdbk3 = &Fdbk3;
    CNTL_2P2Z_Out3 = &CTLOut3;
    CNTL_2P2Z_Ref3 = &Ref3;
    CNTL_2P2Z_Coef3 = &CNTL_2P2Z_CoefStruct3.b2;

    // Initialize the current Controller Coefficients
    CNTL_2P2Z_CoefStruct1.b2 = 1.118;
    CNTL_2P2Z_CoefStruct1.b1 = -2.261;
    CNTL_2P2Z_CoefStruct1.b0 = 1.143;
    CNTL_2P2Z_CoefStruct1.a2 = -0.9984;
    CNTL_2P2Z_CoefStruct1.a1 = 1.998;
    CNTL_2P2Z_CoefStruct1.max =0.2;//1.0;
    CNTL_2P2Z_CoefStruct1.i_min =-0.2;//-1.0;
    CNTL_2P2Z_CoefStruct1.min =-0.2;//-1.0;

    // Initialize the Controller Coefficients new Notch Filter sample rate 52 uS
    CNTL_2P2Z_CoefStruct2.b2 = 0.8999;
    CNTL_2P2Z_CoefStruct2.b1 = -1.7989;
    CNTL_2P2Z_CoefStruct2.b0 = 0.9;
    CNTL_2P2Z_CoefStruct2.a2 = -0.9725;
    CNTL_2P2Z_CoefStruct2.a1 = 1.9714;
    CNTL_2P2Z_CoefStruct2.max = 0.99;
    CNTL_2P2Z_CoefStruct2.i_min = -0.99;
    CNTL_2P2Z_CoefStruct2.min =-0.99;

    // Initialize the Controller Coefficients new PLL controller sample rate 52 uS
    CNTL_2P2Z_CoefStruct3.b2 = 0;
    CNTL_2P2Z_CoefStruct3.b1 = -221.505;
    CNTL_2P2Z_CoefStruct3.b0 = 222.8161;
    CNTL_2P2Z_CoefStruct3.a2 = 0;
    CNTL_2P2Z_CoefStruct3.a1 = 1.0;
    CNTL_2P2Z_CoefStruct3.max = 0.99;
    CNTL_2P2Z_CoefStruct3.i_min = -0.99;
    CNTL_2P2Z_CoefStruct3.min = -0.99;


    // Initialize the net variables
    ADC1_A0=(0.0);
    ADC1_A2=(0.0);
    ADC1_A3=(0.0);
    ADC1_A4=(0.0);
    ADC1_A6=(0.0);
    ADC1_A7=(0.0);
    ADC1_B0=(0.0);
    ADC1_B4=(0.0);

    Duty1=(0.0);
    Duty2= (0.0);

    Sin_0 = _IQ22(0.0);
    Sin_Out = _IQ22(0.0);
    Cos_0 = _IQ22(0.99);
    Cos_out = _IQ22(0.99);
    Sin_Cos_Max = _IQ22(0.99);
    Sin_Cos_Min = _IQ22(-0.99);
    Trace_Freq = _IQ20(314.15927);                  //50Hz
    Sample_Time = _IQ24(0.00005000);                //50e-6

    Fdbk1=0.0;
    CTLOut1=0.0;
    Ref1=0.0;

    Fdbk2=0.0;
    CTLOut2=0.0;
    Ref2=0.0;

    Fdbk3=0.0;
    CTLOut3=0.0;
    Ref3=0.0;

}

#endif /* DIGITALPOWERLIBVARIABLES_H_ */
