/*
 * Inverter_Settings.h
 *
 *  Created on: Sep 17, 2018
 *      Author: Chinthaka
 */

#ifndef INVERTER_SETTINGS_H_
#define INVERTER_SETTINGS_H_

void ConfigurePins(void);

#define C28_FREQ    150         //CPU frequency in MHz

#define     ALL_PWM_ON()        {EALLOW; \
        EPwm1Regs.TZSEL.bit.OSHT1 = 0; \
        EPwm2Regs.TZSEL.bit.OSHT1 = 0;  \
        EPwm1Regs.TZCLR.bit.OST = 1; \
        EPwm2Regs.TZCLR.bit.OST = 1;\
        EDIS;}
#define     ALL_PWM_OFF()       {EALLOW; \
        EPwm1Regs.TZSEL.bit.OSHT1 = 1; \
        EPwm2Regs.TZSEL.bit.OSHT1 = 1; \
        EPwm1Regs.TZFRC.bit.OST = 1; \
        EPwm2Regs.TZFRC.bit.OST = 1;\
        EDIS;}

//Pin definitions
#define SW_ON GpioG1DataRegs.GPADAT.bit.GPIO31
#define OPRLY_SW GpioG1DataRegs.GPADAT.bit.GPIO30
//#define FLT_SD GpioG1DataRegs.GPBDAT.bit.GPIO40
#define FLT_SD GpioG1DataRegs.GPADAT.bit.GPIO7
//#define FLT_SY GpioG1DataRegs.GPADAT.bit.GPIO13
#define FLT_SY GpioG1DataRegs.GPADAT.bit.GPIO6
//#define FLT_CLR_SW GpioG1DataRegs.GPADAT.bit.GPIO25
#define FLT_CLR_SW GpioG1DataRegs.GPBDAT.bit.GPIO37

//#define PWM_LED_ON GpioG1DataRegs.GPBSET.bit.GPIO51=1
//#define PWM_LED_OFF GpioG1DataRegs.GPBCLEAR.bit.GPIO51=1
#define PWM_LED_ON GpioG1DataRegs.GPASET.bit.GPIO11=1
#define PWM_LED_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO11=1
//#define FLT_CLR_ON GpioG1DataRegs.GPASET.bit.GPIO14=1
//#define FLT_CLR_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO14=1
#define FLT_CLR_ON GpioG1DataRegs.GPASET.bit.GPIO9=1
#define FLT_CLR_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO9=1
//#define CURR_LMT_LED_ON GpioG1DataRegs.GPASET.bit.GPIO22=1
//#define CURR_LMT_LED_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO22=1
#define CURR_LMT_LED_ON GpioG1DataRegs.GPBSET.bit.GPIO59=1
#define CURR_LMT_LED_OFF GpioG1DataRegs.GPBCLEAR.bit.GPIO59=1
//#define OP_Voltage_Fault_LED_ON GpioG1DataRegs.GPASET.bit.GPIO20=1
//#define OP_Voltage_Fault_LED_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO20=1
#define OP_Voltage_Fault_LED_ON GpioG1DataRegs.GPBSET.bit.GPIO58=1
#define OP_Voltage_Fault_LED_OFF GpioG1DataRegs.GPBCLEAR.bit.GPIO58=1
//#define IP_Voltage_Fault_LED_ON GpioG1DataRegs.GPASET.bit.GPIO18=1
//#define IP_Voltage_Fault_LED_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO18=1
#define IP_Voltage_Fault_LED_ON GpioG1DataRegs.GPBSET.bit.GPIO56=1
#define IP_Voltage_Fault_LED_OFF GpioG1DataRegs.GPBCLEAR.bit.GPIO56=1

//#define LINE_RELAY_ON GpioG1DataRegs.GPASET.bit.GPIO4=1  // OUTPUT (AC) RELAYS
//#define LINE_RELAY_OFF GpioG1DataRegs.GPACLEAR.bit.GPIO4=1
#define LINE_RELAY_ON GpioG1DataRegs.GPBSET.bit.GPIO32=1  // OUTPUT (AC) RELAYS
#define LINE_RELAY_OFF GpioG1DataRegs.GPBCLEAR.bit.GPIO32=1

//staus flag definitions.
#define OP_V_Over 0
#define OP_V_Under 1
#define OP_I_Over 2
#define IP_Voltage_Under 3
#define PWM_Status 4
#define OP_Relay_Status 5

void ConfigurePins()
{
    EALLOW;
        GpioG1CtrlRegs.GPCDIR.bit.GPIO70 = 1; //OnboardLED set PC6_GPIO70 as output
        GpioG1CtrlRegs.GPADIR.bit.GPIO11 = 1; //O/P PWM LED
        GpioG1CtrlRegs.GPBDIR.bit.GPIO59 = 1; //O/P CURR_LMT LED
        GpioG1CtrlRegs.GPBDIR.bit.GPIO58 = 1; //O/P Output voltage fault LED
        GpioG1CtrlRegs.GPBDIR.bit.GPIO56 = 1; //O/P Input voltage fault LED
        GpioG1CtrlRegs.GPADIR.bit.GPIO21 = 1; //O/P  LED not yet assaigned
        GpioG1CtrlRegs.GPADIR.bit.GPIO20 = 1; //O/P  LED not yet assaigned

        GpioG1CtrlRegs.GPBDIR.bit.GPIO32 = 1; //LINE relay output
        GpioG1CtrlRegs.GPADIR.bit.GPIO9 = 1; //FLT_CLR output

        GpioG1CtrlRegs.GPADIR.bit.GPIO31 = 0; // i/p SW_ON
        GpioG1CtrlRegs.GPADIR.bit.GPIO30 = 0; // i/p OPRLY_SW
        GpioG1CtrlRegs.GPADIR.bit.GPIO6 = 0; // i/p FLT_SY
        GpioG1CtrlRegs.GPADIR.bit.GPIO7 = 0; // i/p FLT_SD
        GpioG1CtrlRegs.GPBDIR.bit.GPIO37 = 0; // i/p FLT_CLR_SW

        GpioG1CtrlRegs.GPBDIR.bit.GPIO33 = 1; //set o/p execute time

        GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1;   // Configure GPIO0 as EPWM1A
        GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1;   // Configure GPIO1 as EPWM1B

        GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1;   // Configure GPIO0 as EPWM2A
        GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1;   // Configure GPIO1 as EPWM2B
}
#endif /* INVERTER_SETTINGS_H_ */
