;----------------------------------------------------------------------------------
;	FILE:			GEN_SIN_COS.asm
;
;	Description:	Generate the sine and cos wave for PLL and inverter trace angle
;
;	Version: 		2.0
;
;   Target:  		F2802x / F2803x
;
;--------------------------------------------------------------------------------
;  Copyright Texas Instruments  2010
;--------------------------------------------------------------------------------
;  Revision History:
;--------------------------------------------------------------------------------
;  Date	  	| Description
;--------------------------------------------------------------------------------
;  06/15/10	| Release 2.0  		New release.
;--------------------------------------------------------------------------------
;=============================
GEN_SIN_COS_INT 	.macro	n
;=============================
; allocate memory space for data & terminal pointers
_GEN_SIN_COS_Sin_0			.usect "GEN_Sin_Cos_Section",2,1,1		;Q22
_GEN_SIN_COS_Sin_1			.usect "GEN_Sin_Cos_Section",2,1,1
_GEN_SIN_COS_Cos_0			.usect "GEN_Sin_Cos_Section",2,1,1
_GEN_SIN_COS_Cos_1			.usect "GEN_Sin_Cos_Section",2,1,1
_GEN_SIN_COS_Max  	.usect "GEN_Sin_Cos_Section",2,1,1
_GEN_SIN_COS_Min  	.usect "GEN_Sin_Cos_Section",2,1,1
_GEN_SIN_COS_Ws		.usect "GEN_Sin_Cos_Section",2,1,1		;Q20
_GEN_SIN_COS_Ts	.usect "GEN_Sin_Cos_Section",2,1,1		;Q24
_dwSin_Cos_Temp		.usect "GEN_Sin_Cos_Section",2,1,1		

;Publish Terminal Pointers for access from the C environment
		
		.def 	_GEN_SIN_COS_Sin_0			 
		.def	_GEN_SIN_COS_Sin_1			 
		.def	_GEN_SIN_COS_Cos_0			 
		.def	_GEN_SIN_COS_Cos_1			 
		.def	_GEN_SIN_COS_Max  	 
		.def	_GEN_SIN_COS_Min  	 
		.def	_GEN_SIN_COS_Ws
		.def	_GEN_SIN_COS_Ts		 

						
; set terminal pointer to ZeroNet
		MOVL	XAR2, #ZeroNet
		MOVW	DP, #_GEN_SIN_COS_Sin_0
		MOVL	@_GEN_SIN_COS_Sin_0, XAR2
		MOVL	@_GEN_SIN_COS_Sin_1, XAR2
		MOVL	@_GEN_SIN_COS_Cos_0, XAR2
		MOVL	@_GEN_SIN_COS_Cos_1, XAR2
		MOVL	@_GEN_SIN_COS_Max, XAR2
		MOVL	@_GEN_SIN_COS_Min, XAR2
		MOVL	@_GEN_SIN_COS_Ws, XAR2
		MOVL	@_GEN_SIN_COS_Ts, XAR2
		
		.endm

;-------------------------------------------------------------------------------------------
;=============================
GEN_SIN_COS	.macro	n
;=============================

		MOVW     DP, #_GEN_SIN_COS_Sin_0
		MOVL     XAR0,@_GEN_SIN_COS_Ws			;Q20
		MOVL     XAR1,@_GEN_SIN_COS_Ts			;Q24
		MOVL     XAR2,@_GEN_SIN_COS_Sin_0					;Q22
		MOVL     XAR3,@_GEN_SIN_COS_Cos_0					;Q22
		
		MOVL     XT,*XAR0
		IMPYL    P,XT,*XAR1						;lower 32 bits
		QMPYL    ACC,XT,*XAR1					;upper 32 bits
		LSL64    ACC:P,#8						;ACC = Ws*Ts , ACC->Q20
		MOVL     @_dwSin_Cos_Temp,ACC			;Temp = Ws*Ts
		
		MOVL     @XT,ACC						;XT = Ws*Ts
		IMPYL    P,XT,*XAR2						;P = Ws*Ts*Sin_0[31:0]
		QMPYL    ACC,XT,*XAR2					;ACC = Ws*Ts*Sin_0[63:32]
		LSL64    ACC:P,#12						; ACC->Q22
		NEG      ACC							; ACC = -ACC

		MOVL     XAR0,@_GEN_SIN_COS_Min
		MOVL     XAR1,@_GEN_SIN_COS_Max
		MOVL     XAR2,@_GEN_SIN_COS_Cos_1
		
		ADDL     ACC,*XAR2						; ACC = Cos_1 - Ws*Ts*Sin_0
		MINL     ACC,*XAR1						; Saturation high
		MAXL     ACC,*XAR0						; Saturation low
		MOVL     *XAR2,ACC						; Cos_1 = Cos_1 - Ws*Ts*Sin_0
		
		MOVL     XT,@_dwSin_Cos_Temp			; XT = Ws*Ts
		IMPYL    P,XT,*XAR3						;P = Ws*Ts*Cos_0[31:0]
		QMPYL    ACC,XT,*XAR3					;ACC = Ws*Ts*Cos_0[63:32]
		LSL64    ACC:P,#12						; ACC->Q22

		MOVL     XAR3,@_GEN_SIN_COS_Sin_1
		
		ADDL     ACC,*XAR3						; ACC = Sin_1 + Ws*Ts*Cos_0
		MINL     ACC,*XAR1						; Saturation hig
		MAXL     ACC,*XAR0						; Saturation low
		MOVL     *XAR3,ACC						; Sin_1 = Sin_1 + Ws*Ts*Cos_0
		
		;;Save the Sin_0, Cos_0 for the next step
		MOVL     XAR0,@_GEN_SIN_COS_Sin_0					 
		MOVL     XAR1,@_GEN_SIN_COS_Cos_0					 

		MOVL     *XAR0,ACC
		MOVL     ACC,*XAR2
		MOVL     *XAR1,ACC

	   .endm

; end of file

