#include "F28M35x_Device.h"     // F28M35x Headerfile Include File
#include "F28M35x_Examples.h"   // F28M35x Examples Include File
#include "DigitalPowerLibVariables.h"
#include "Inverter_Settings.h"
#include "IQmathLib.h"
#include "Solar_DC_AC_IPC.h"
#include <string.h>

// These are defined by the linker (see device linker command file)
extern Uint16 RamfuncsRunStart;
extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadSize;



extern void MemCopy(Uint16 *SourceAddr, Uint16* SourceEndAddr, Uint16* DestAddr);

// Prototype statements for functions found within this file.
interrupt void cpu_timer0_isr(void);
interrupt void cpu_timer1_isr(void);

// Variables that need to shared with C28x and M3
struct Message {
    unsigned int beg;// = 0xAA;
    //  unsigned char beg2;// = 0x55;
    unsigned int no_of_bytes;// = 28;

    //  unsigned char temp1;

    float f1;
    float f2;
    float f3;
    float f4;
    float f5;

    int i1;
    int i2;

    unsigned int crc_n_eot;// = 0x00;//for now //
    unsigned int temp1;// = 0x00;
};

volatile char crc_check = 0x00;
volatile long index = 0;
volatile struct Message msg;
volatile char *character_pointer;

struct Message base[256];
#pragma DATA_SECTION(base,"SHARERAMS2");

long Pw = 0;
#pragma DATA_SECTION(Pw,"SHARERAMS3");

long Pr;
#pragma DATA_SECTION(Pr,"SHARERAMS4");

unsigned char Addr = 0;
int size = 0;

volatile int inverter_mode=4;   // 4: close loop current mode
volatile int SW_count=0;
volatile int SW_count_OPRLY=0;
volatile int PWM_stat=0;
volatile int OPRLY_STAT=0;
volatile float OP_I_AVG = 0;
volatile float LINE_V_AVG = 0;
volatile float BUS_V_AVG = 0;
volatile float CurrBuff[5] = {0,0,0,0,0};
volatile float LINE_V[5] = {0,0,0,0,0};
volatile float BUS_V[5] = {0,0,0,0,0};
volatile float LINE_V_max=0;
volatile int LINE_V_max_count=0;
volatile int status_flag_collection=0;

//Safety limits
volatile float OP_I_Limit=37;
volatile float LINE_V_Over_Limit= 360;
volatile float LINE_V_Under_Limit=300;

volatile float ConstantCurrent = 5;
volatile float VoltageLoopOutConstCurr =  0.014284985;
volatile float ref_v_gain=0.4;
volatile float K1 = 2.48;//2.626263; // equal to (325.0/(375/0.33)) = ((GridPeak)/(DC_BUS_V/(Vgrid_Variable_Peak)))
volatile float InvCurrRef_Max = 0.4;//+40Ampheres
volatile float InvCurrRef_Min = -0.4;//-40Ampheres

volatile float x=0;
volatile float OP_Voltage=0;
volatile float OP_Current=0;
volatile float BUS_Voltage=0;
volatile int FLT_CLR_TIME = 0;
volatile int count=0;
volatile int count2=0;
volatile float ControllerCurrentReference =0 ;
volatile float Duty_Cal_Out=0;
volatile float GridVoltComponent=0;

int main(void)
   {
    //CPU
    // Step 1. Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the F28M35x_SysCtrl.c file.
    InitSysCtrl();

    // Copy time critical code and Flash setup code to RAM
    // This includes the following functions:  InitFlash();
    // The  RamfuncsLoadStart, RamfuncsLoadSize, and RamfuncsRunStart
    // symbols are created by the linker. Refer to the device .cmd file.
    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (unsigned long)&RamfuncsLoadSize);

    // Call Flash Initialization to setup flash waitstates
    // This function must reside in RAM
    InitFlash();

    // Step 2. Initialize GPIO:
    // This example function is found in the F28M35x_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    InitGpio(); // Skipped for this example

    ConfigurePins();//Configure GPIOs, included in Inverter_Settings.h

    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
    DINT;

    // Initialize the PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the F28M35x_PieCtrl.c file.
    InitPieCtrl();

    // Disable CPU interrupts and clear all CPU interrupt flags:
    IER = 0x0000;
    IFR = 0x0000;

    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F28M35x_DefaultIsr.c.
    // This function is found in F28M35x_PieVect.c.
    InitPieVectTable();

    msg.beg = 0x55AA;//AA55;//'1';//0xAA;
    msg.no_of_bytes = 0xAB28;//'3';//0;
    msg.temp1 = 0x3412;

    InitializePowerLibVariables();

    // Interrupts that are used in this example are re-mapped to
    // ISR functions found within this file.
    EALLOW; // This is needed to write to EALLOW protected registers
    PieVectTable.TINT0 = &cpu_timer0_isr;
    PieVectTable.TINT1 = &cpu_timer1_isr;
    EDIS;   // This is needed to disable write to EALLOW protected registers

    // Step 4. Initialize the Device Peripheral. This function can be
    //         found in F28M35x_CpuTimers.c
    InitCpuTimers();  // For this example, only initialize the Cpu Timers

    // Configure CPU-Timer 0, 1, and 2 to interrupt every second:
    // C28_FREQ in MHz, 1 second Period (in uSeconds)

    ConfigCpuTimer(&CpuTimer0,C28_FREQ, 1000000);//1000000);
    ConfigCpuTimer(&CpuTimer1,C28_FREQ, 53.0);
    // To ensure precise timing, use write-only instructions to write to the entire
    // register. Therefore, if any
    // of the configuration bits are changed in ConfigCpuTimer and InitCpuTimers (in
    // F28M35x_CpuTimers.h), the
    // below settings must also be updated.

    CpuTimer0Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit
    CpuTimer1Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit
    // = 0

    // Step 5. User specific code, enable interrupts:
    // Enable CPU int1 which is connected to CPU-Timer 0, CPU int13
    // which is connected to CPU-Timer 1, and CPU int 14, which is connected
    // to CPU-Timer 2:
    IER |= M_INT1;
    IER |= M_INT13;

    // Enable TINT0 in the PIE: Group 1 interrupt 7
    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;

    // Enable global Interrupts and higher priority real-time debug events:
    EINT;  // Enable Global interrupt INTM
    ERTM;  // Enable Global realtime interrupt DBGM

    LINE_RELAY_OFF;
    status_flag_collection &= ~(1<< OP_Relay_Status);
    ALL_PWM_OFF();
    PWM_LED_OFF;
    status_flag_collection &= ~(1<< PWM_Status);

    PWM_stat=0;
    int i=0;
   	while(1)
	{
	    i++;
	}

}

interrupt void cpu_timer0_isr(void)
{
    CpuTimer0.InterruptCount++;
    if( (CpuTimer0.InterruptCount - FLT_CLR_TIME >= 2) && FLT_CLR_SW){
        FLT_CLR_TIME = CpuTimer0.InterruptCount;
        FLT_CLR_ON;
        IP_Voltage_Fault_LED_OFF;
        OP_Voltage_Fault_LED_OFF;
        CURR_LMT_LED_OFF;
        status_flag_collection = 0; // reset fault code
    }


    // Acknowledge this interrupt to receive more interrupts from group 1
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

interrupt void cpu_timer1_isr(void)
{
    GpioG1DataRegs.GPBSET.bit.GPIO33 = 1;
    CpuTimer0.InterruptCount++;
    Adc1Regs.ADCSOCFRC1.all = 0xFFFF;       // kick-start ADC

    if(SW_ON == 0){ // PWM on/off switch
        SW_count++;
        if(SW_count >= 10000){
            SW_count = 0;
            if(PWM_stat == 0){
                ALL_PWM_ON();
                PWM_stat = 1;
                PWM_LED_ON; //on pwm led
                status_flag_collection|=1<<PWM_Status;

            }
            else{
                ALL_PWM_OFF();
                status_flag_collection &= ~(1<< PWM_Status);
                PWM_stat = 0;
                PWM_LED_OFF; //off pwm led
            }

        }
    }
    else{
        SW_count=0;
    }

    if(OPRLY_SW == 0){  // Output relay on/off switch
            SW_count_OPRLY++;
            if(SW_count_OPRLY >= 10000){
                SW_count_OPRLY = 0;
                if(OPRLY_STAT == 1){
                    LINE_RELAY_OFF;
                    status_flag_collection &= ~(1<< OP_Relay_Status);
                    OPRLY_STAT = 0;
                }
                else{
                    LINE_RELAY_ON;
                    status_flag_collection|=1<<OP_Relay_Status;   //set status flag
                    OPRLY_STAT = 1;
                }
            }
    }
    else{
        SW_count_OPRLY=0;
    }

    ADCDRVfnc();
    OP_Voltage=(ADC1_A2-0.4981);//Calib by Chinthaka 2018/11/13
    OP_Current=(ADC1_A4-0.5179);// Multiply by -1 to correct sensor phase if needed
    BUS_Voltage=ADC1_A3;

    //Measure Output current and calculate average output current
    CurrBuff[0] = CurrBuff[1];
    CurrBuff[1] = CurrBuff[2];
    CurrBuff[2] = CurrBuff[3];
    CurrBuff[3] = CurrBuff[4];
    if(OP_Current >= 0)
        CurrBuff[4] = 100*OP_Current;
    else
        CurrBuff[4] = -100*OP_Current;
    OP_I_AVG = (CurrBuff[0]+CurrBuff[1]+CurrBuff[2]+CurrBuff[3]+CurrBuff[4])/5;

    //Measure Output voltage and calculate average output voltage
    LINE_V[0] = LINE_V[1];
    LINE_V[1] = LINE_V[2];
    LINE_V[2] = LINE_V[3];
    LINE_V[3] = LINE_V[4];

    if(OP_Voltage >0)
        LINE_V[4] = OP_Voltage*975.2145;//TRD recalibrated 2018/05/08 956.0;
    else
        LINE_V[4] = -OP_Voltage*975.2145;//956.0;
    LINE_V_AVG = (LINE_V[0] + LINE_V[1] + LINE_V[2] + LINE_V[3] + LINE_V[4]) / 5.0;

    //Measure Input DC voltage and calculate average Input DC voltage
//    BUS_V[0] = BUS_V[1];
//    BUS_V[1] = BUS_V[2];
//    BUS_V[2] = BUS_V[3];
//    BUS_V[3] = BUS_V[4];
//    BUS_V[4] = ((BUS_Voltage*380.0)/0.704);
//    BUS_V_AVG = /*458.6**/((BUS_V[0] + BUS_V[1] + BUS_V[2] + BUS_V[3] + BUS_V[4])/5.0);



    //Output over current protection
    if ((CurrBuff[0]>OP_I_Limit)&&(CurrBuff[1]>OP_I_Limit)&&(CurrBuff[2]>OP_I_Limit)&&(CurrBuff[3]>OP_I_Limit)&&(CurrBuff[4]>OP_I_Limit))
    {
        ALL_PWM_OFF();
        status_flag_collection &= ~(1<< PWM_Status);
        LINE_RELAY_OFF;
        status_flag_collection &= ~(1<< OP_Relay_Status);
        PWM_stat = 0;
        CURR_LMT_LED_ON;
        PWM_LED_OFF; //off led
        status_flag_collection|=1<<OP_I_Over;   //set status flag
    }

    //Output over voltage protection
    if ((LINE_V[0]>LINE_V_Over_Limit)&&(LINE_V[1]>LINE_V_Over_Limit)&&(LINE_V[2]>LINE_V_Over_Limit)&&(LINE_V[3]>LINE_V_Over_Limit)&&(LINE_V[4]>LINE_V_Over_Limit))
    {
       ALL_PWM_OFF();
       status_flag_collection &= ~(1<< PWM_Status);
       LINE_RELAY_OFF;
       status_flag_collection &= ~(1<< OP_Relay_Status);
       PWM_stat = 0;
       OP_Voltage_Fault_LED_ON;
       PWM_LED_OFF; //off led
       status_flag_collection|=1<<OP_V_Over;   //set status flag
    }

    //grid under voltage detection code starts here
    if(LINE_V_max < LINE_V_AVG){
        LINE_V_max = LINE_V_AVG;
        LINE_V_max_count = 0;
    }
    else
        LINE_V_max_count++;

    if(LINE_V_max_count >= 144){// 3/4 of half window size from 384
        LINE_V_max = 0;
        LINE_V_max_count = 0;
    }

    if(LINE_V_max_count >= 144 && LINE_V_max < LINE_V_Under_Limit){//have to load from parameter array
        ALL_PWM_OFF();
        status_flag_collection &= ~(1<< PWM_Status);
        LINE_RELAY_OFF;
        status_flag_collection &= ~(1<< OP_Relay_Status);
        PWM_stat = 0;
        OP_Voltage_Fault_LED_ON;
        PWM_LED_OFF; //off led
        status_flag_collection|=1<<OP_V_Under;   //set status flag
    }
    //grid under voltage  detection code ends here // TRD 05/05/2018

    GEN_SIN_COSfnc();

    if (inverter_mode==4)   //close loop current mode
    {
        phase_error = ((float)Cos_out/4194304.0)*(OP_Voltage)*2.0;
        if(phase_error > phase_error_max)
            phase_error = phase_error_max;
        else if(phase_error < phase_error_min)
            phase_error = phase_error_min;

       Ref2 = phase_error;
       Fdbk2 = 0;
       NotchFilterfnc();
       Phase_Err_Notch_Out = CTLOut2;
       Ref3 = Phase_Err_Notch_Out/200.0;
       Fdbk3 = 0;
       PLLControllerfnc();
       CTLOut3 = 200*CTLOut3;
       Pll_Trace_Freq = _IQ20(314.1593 + CTLOut3);
       Trace_Freq = Pll_Trace_Freq;


       ControllerCurrentReference= ConstantCurrent*VoltageLoopOutConstCurr*((((float)Sin_Out)/(4194304.0))*0.9744-(((float)Cos_out)/(4194304.0))*0.2250);

       //SAturation Block for Controller current reference
       if(ControllerCurrentReference > InvCurrRef_Max)
           ControllerCurrentReference = InvCurrRef_Max;
       else if(ControllerCurrentReference < InvCurrRef_Min)
           ControllerCurrentReference = InvCurrRef_Min;

       Ref1= ControllerCurrentReference;
       Fdbk1=OP_Current;
       CurrLoopfnc();

       GridVoltComponent=K1*OP_Voltage;
       Duty_Cal_Out= CTLOut1+GridVoltComponent;
//       Duty_Cal_Out=GridVoltComponent;

       if(Duty_Cal_Out>1.0)
           Duty_Cal_Out = 0.999999;
       else if(Duty_Cal_Out<-1)
           Duty_Cal_Out = -0.999999;

       if(Duty_Cal_Out>0){
           Duty1 = Duty_Cal_Out;//((float)Sin_Out*PWM_gain)/4194304.0;
           Duty2 = 0.0;
       }
       else{
           Duty2 = -Duty_Cal_Out;//-((float)Sin_Out*PWM_gain)/4194304.0;
           Duty1 = 0.0;
       }

    }

    PWMDRVfnc();


    //Toggle pin 70 for visual confirmation of timer operation
    if (count2>10000)
    {
        count2=0;
        if(GpioG1DataRegs.GPCDAT.bit.GPIO70 == 0) {
            GpioG1DataRegs.GPCSET.bit.GPIO70 = 1;
        }
        else{
            GpioG1DataRegs.GPCCLEAR.bit.GPIO70 = 1;
        }

    }
    else
    {
        count2++;
    }


    //Share data with M3
    if(Pw-Pr<=127)
    {

        msg.f1 = ControllerCurrentReference;
        msg.f2 = OP_Voltage;
        msg.f3 = OP_Current;
        msg.f4 = CTLOut1;
        msg.f5 = Duty_Cal_Out;

        msg.i1 = status_flag_collection;
//        msg.i1 = 0;
        msg.i2 = 0;



        character_pointer = (char*)&msg;
        msg.crc_n_eot = 0x00;
        crc_check = 0x00;
        for(index = 0; index<27; index++){
            crc_check = crc_check^(*(char*)(character_pointer+index));
        }
        msg.crc_n_eot = (crc_check<<8|crc_check);
        Addr = Pw % 256;//0x3F;//0xFF;//& 0xFF;
        Addr = Addr<<8;
        Addr = Addr>>8;

        base[Addr] = msg;
        Pw++;
        count++;
    }


    GpioG1DataRegs.GPBCLEAR.bit.GPIO33 = 1;
    // Acknowledge this interrupt to receive more interrupts from group 1
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

}
