#include "device.h"
#include "driverlib.h"
#include "board.h"
#include "Can_Ext_ISR.h"
#include "Can_Ext.h"
// Function Prototypes
//
__interrupt void INT_CAN0_TX_ISR(void);
__interrupt void INT_CAN0_RX_ISR(void);
__interrupt void
INT_CAN0_TX_ISR(void){
    uint32_t status;



        //
        // Read the CAN-B interrupt status to find the cause of the interrupt
        //
        status = CAN_getInterruptCause(myCAN0_BASE);

        //
            // If the cause is a controller status interrupt, then get the status
            //
            if(status == CAN_INT_INT0ID_STATUS)
            {
                //
                // Read the controller status.  This will return a field of status
                // error bits that can indicate various errors.  Error processing
                // is not done in this example for simplicity.  Refer to the
                // API documentation for details about the error status bits.
                // The act of reading this status will clear the interrupt.
                //
                status = CAN_getStatus(myCAN0_BASE);

                //
                // Check to see if an error occurred.

                if(((status  & ~(CAN_STATUS_TXOK)) != CAN_STATUS_LEC_MSK) &&
                   ((status  & ~(CAN_STATUS_TXOK)) != CAN_STATUS_LEC_NONE))

                {
                    //
                    // Set a flag to indicate some errors may have occurred.
                    //
                    errorFlag = 1;
                }
                else if(status == 2)
                    {
                        //
                        // Getting to this point means that the TX interrupt occurred on
                        // message object 1, and the message TX is complete.  Clear the
                        // message object interrupt.
                        //
                        CAN_clearInterruptStatus(myCAN0_BASE, 2);

                        //
                        // Increment a counter to keep track of how many messages have been
                        // transmitted. In a real application this could be used to set flags to
                        // indicate when a message is transmitted.
                        //
                        txMsgCount++;

                        //
                        // Since the message was transmitted, clear any error flags.
                        //
                        errorFlag = 0;

                        //
                        // Clear the message transmitted successful Flag.
                        //
                        txMsgSuccessful  = 0;
                    }
            }
            //
                // If something unexpected caused the interrupt, this would handle it.
                //
                else
                {
                    //
                    // Spurious interrupt handling can go here.
                    //
                }

                //
                // Clear the global interrupt flag for the CAN interrupt line
                //
                CAN_clearGlobalInterruptStatus(myCAN0_BASE, CAN_GLOBAL_INT_CANINT0);

                //
                // Acknowledge this interrupt located in group 9
                //
                Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);

}

__interrupt void
INT_CAN0_RX_ISR(void){
    uint32_t status;



            //
            // Read the CAN-B interrupt status to find the cause of the interrupt
            //
            status = CAN_getInterruptCause(myCAN0_BASE);

            //
                // If the cause is a controller status interrupt, then get the status
                //
                if(status == CAN_INT_INT0ID_STATUS)
                {
                    //
                    // Read the controller status.  This will return a field of status
                    // error bits that can indicate various errors.  Error processing
                    // is not done in this example for simplicity.  Refer to the
                    // API documentation for details about the error status bits.
                    // The act of reading this status will clear the interrupt.
                    //
                    status = CAN_getStatus(myCAN0_BASE);

                    //
                    // Check to see if an error occurred.

                    if(((status  & ~(CAN_STATUS_RXOK)) != CAN_STATUS_LEC_MSK) &&
                               ((status  & ~(CAN_STATUS_RXOK)) != CAN_STATUS_LEC_NONE))

                    {
                        //
                        // Set a flag to indicate some errors may have occurred.
                        //
                        errorFlag = 1;
                    }}
                    else if(status == 1)
                        {
                              ReadMsg();
                }
                //
                    // If something unexpected caused the interrupt, this would handle it.
                    //
                    else
                    {
                        //
                        // Spurious interrupt handling can go here.
                        //
                    }

                    //
                    // Clear the global interrupt flag for the CAN interrupt line
                    //
                    CAN_clearGlobalInterruptStatus(myCAN0_BASE, CAN_GLOBAL_INT_CANINT0);

                    //
                    // Acknowledge this interrupt located in group 9
                    //
                    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);

}
