// The user must define CLA_C in the project linker settings if using the
// CLA C compiler
// Project Properties -> C2000 Linker -> Advanced Options -> Command File
// Preprocessing -> --define


MEMORY
{
PAGE 0 : /* Program memory */
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   //BEGIN           	: origin = 0x000000,   length = 0x000002	/* RAM */
   RAMM0           	: origin = 0x000122,   length = 0x0002DE
   RAMM1            : origin = 0x000400,   length = 0x0003F8     /* on-chip RAM block M1 */
   RAMD0           	: origin = 0x00B000,   length = 0x000800
   RAMD1            : origin = 0x00B800,   length = 0x000800

   /* RAMLS0          	: origin = 0x008000,   length = 0x000800
   RAMLS1          	: origin = 0x008800,   length = 0x000800*/
   RAMLS0_1          : origin = 0x008000, length = 0x001000		/* Reserved for CLA Program memory*/
   RAMGS0_1          : origin = 0x00C000, length = 0x002000

   RAMGS8            : origin = 0x014000, length = 0x001000
   RAMGS9            : origin = 0x015000, length = 0x001000
   RAMGS10           : origin = 0x016000, length = 0x001000
   RAMGS11           : origin = 0x017000, length = 0x001000


   RESET           	: origin = 0x3FFFC0,   length = 0x000002

   //IQTABLES          : origin = 0x3FE000, length = 0x000B50     /* IQ Math Tables in Boot ROM */
   //IQTABLES2         : origin = 0x3FEB50, length = 0x00008C
   //IQTABLES3         : origin = 0x3FEBDC, length = 0x0000AA

   BEGIN             : origin = 0x080000, length = 0x000002		/* FLASH */
   FLASHA            : origin = 0x080002, length = 0x001FFE   /* on-chip Flash */
   FLASHB            : origin = 0x082000, length = 0x002000   /* on-chip Flash */
   FLASHC            : origin = 0x084000, length = 0x002000   /* on-chip Flash */
   FLASHD            : origin = 0x086000, length = 0x002000   /* on-chip Flash */
   FLASHE            : origin = 0x088000, length = 0x008000   /* on-chip Flash */
   FLASHF            : origin = 0x090000, length = 0x008000   /* on-chip Flash */
   FLASHG            : origin = 0x098000, length = 0x008000   /* on-chip Flash */
   FLASHH            : origin = 0x0A0000, length = 0x008000   /* on-chip Flash */
   FLASHI            : origin = 0x0A8000, length = 0x008000   /* on-chip Flash */
   FLASHJ            : origin = 0x0B0000, length = 0x008000   /* on-chip Flash */
   FLASHK            : origin = 0x0B8000, length = 0x002000   /* on-chip Flash */

PAGE 1 :	/* Data memory */

   BOOT_RSVD       : origin = 0x000002, length = 0x000121     /* Part of M0, BOOT rom will use this for stack */

//   RAMM1_RSVD      : origin = 0x0007F8, length = 0x000008     /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */


   RAMLS2_3          : origin = 0x009000, length = 0x001000		/* Reserved for CLA Data memory*/
   RAMLS4_5          : origin = 0x00A000, length = 0x001000		/* Reserved for CLA Data memory*/

   RAMGS2            : origin = 0x00E000, length = 0x001000
   RAMGS3_4          : origin = 0x00F000, length = 0x002000
   RAMGS5_6          : origin = 0x011000, length = 0x002000
   RAMGS7            : origin = 0x013000, length = 0x001000

   RAMGS12          : origin = 0x018000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS13          : origin = 0x019000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS14          : origin = 0x01A000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS15          : origin = 0x01B000, length = 0x000FF8     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */

   FLASHL            : origin = 0x0BA000, length = 0x002000   /* on-chip Flash */
   FLASHM            : origin = 0x0BC000, length = 0x002000   /* on-chip Flash */
   FLASHN            : origin = 0x0BE000, length = 0x002000   /* on-chip Flash */

//   RAMGS15_RSVD : origin = 0x01BFF8, length = 0x000008    /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */
                                                            /* Only on F28379D, F28377D, F28375D devices. Remove line on other devices. */

/*   EMIF1_CS0n       : origin = 0x80000000, length = 0x10000000
   EMIF1_CS2n       : origin = 0x00100000, length = 0x00200000
   EMIF1_CS3n       : origin = 0x00300000, length = 0x00080000
   EMIF1_CS4n       : origin = 0x00380000, length = 0x00060000
   EMIF2_CS0n       : origin = 0x90000000, length = 0x10000000
   EMIF2_CS2n       : origin = 0x00002000, length = 0x00001000*/

   CANA_MSG_RAM     : origin = 0x049000,   length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000,   length = 0x000800

   /* IPC CPU1 */
   CPU2TOCPU1RAM   : origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   : origin = 0x03FC00, length = 0x000400
	/* CLA */
   CLA1_MSGRAMLOW   : origin = 0x001480,   length = 0x000080
   CLA1_MSGRAMHIGH  : origin = 0x001500,   length = 0x000080



}

SECTIONS
{
   codestart        : > BEGIN,      PAGE = 0, ALIGN(8)

   #ifdef __TI_COMPILER_VERSION__
    #if __TI_COMPILER_VERSION__ >= 15009000
        GROUP
        {
            .TI.ramfunc
            { -l F021_API_F2837xD_FPU32.lib}

        } LOAD = FLASHB,
          RUN  = RAMLS0_1,
          LOAD_START(_RamfuncsLoadStart),
          LOAD_SIZE(_RamfuncsLoadSize),
          LOAD_END(_RamfuncsLoadEnd),
          RUN_START(_RamfuncsRunStart),
          RUN_SIZE(_RamfuncsRunSize),
          RUN_END(_RamfuncsRunEnd),
          PAGE = 0, ALIGN(8)
    #else
        GROUP
        {
            ramfuncs
            { -l F021_API_F2837xD_FPU32.lib}

        } LOAD = FLASHB,
          RUN  = RAMLS0_1,
          LOAD_START(_RamfuncsLoadStart),
          LOAD_SIZE(_RamfuncsLoadSize),
          LOAD_END(_RamfuncsLoadEnd),
          RUN_START(_RamfuncsRunStart),
          RUN_SIZE(_RamfuncsRunSize),
          RUN_END(_RamfuncsRunEnd),
          PAGE = 0, ALIGN(8)
    #endif
#endif




   .text             :>> FLASHA | FLASHB,     PAGE = 0, ALIGN(8)
   .cinit            : > FLASHA,              PAGE = 0, ALIGN(8)

   .pinit            : > FLASHA,              PAGE = 0, ALIGN(8)
   .switch           : > FLASHA,              PAGE = 0, ALIGN(8)
   .econst           : > FLASHA,              PAGE = 0, ALIGN(8)

   // CLA C compiler sections
   //
   // Must be allocated to memory the CLA has write access to
   //
   .scratchpad       : > RAMLS4_5,              PAGE = 1
   .bss_cla          : > RAMLS4_5,              PAGE = 1
   .const_cla        : > RAMLS4_5,              PAGE = 1


   IOBuffer          : > RAMLS2_3,              PAGE = 1

   .reset            : > RESET,                 PAGE = 0, TYPE = DSECT /* not used, */

   .cio              : > RAMGS7,                PAGE = 1
   .sysmem           : > RAMGS7,                PAGE = 1

   .stack            : > RAMGS2,                PAGE = 1 /* Needs to be in lower 64K memory */
   .ebss             : > RAMGS5_6,              PAGE = 1
   .esysmem          : > RAMGS7,                PAGE = 1

   /* The following section definitions are required when using the IPC API Drivers */
    GROUP : > CPU1TOCPU2RAM, PAGE = 1
    {
        PUTBUFFER
        PUTWRITEIDX
        GETREADIDX
    }

    GROUP : > CPU2TOCPU1RAM, PAGE = 1
    {
        GETBUFFER :    TYPE = DSECT
        GETWRITEIDX :  TYPE = DSECT
        PUTREADIDX :   TYPE = DSECT
    }

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
