
/*
 *  main.c 
 * 
 *  CLA Complete Demo 
 *  
 *  This example shows how to use CLA and to compare results of the same calculation done on CPU1 and CPU1CLA1.
 *  The GPIO 25 to 27 can be use to compare how much time CPU and CLA needs to complete the task.
 *  CLA1 and memory initialization is placed in   CLA_config().
 *  GPIO pins are configured in    InitGpio().
 *
 *  
 *  x[] - CPU1toCLA1Msg - variable send to CLA
 *  x[] - CLA1toCPU1Msg - variables get back form CLA1
 *  
 *  To compare results observe 1st,2nd and 3rd outputs on J6 (LAUNCHXL_F28379D)
 *  CPU output variables: iD and iQ
 *  CLA output variables: z[0] and z[1]
 * 
 *  Created on: 10 mar 2020
 *      Author: m.stasiak
 */

#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837x_device.h"
#include "F2837x_EPwm_defines.h"
#include "SFO_V8.h" //Do HRPWM

#include <stdint.h>
#include <math.h>
#include <string.h>


/* CAN Bootloader */
#include "flash_programming_c28.h" // Flash API example header file
//#include "c1_bootrom.h"
#include "F021_F2837xD_C28x.h"
//#include "c1_bootrom.h"


//
// Globals
//
#ifdef _FLASH
    extern Uint16 RamfuncsLoadStart;
    extern Uint16 RamfuncsLoadEnd;
    extern Uint16 RamfuncsLoadSize;
    extern Uint16 RamfuncsRunStart;
    extern Uint16 RamfuncsRunEnd;
    extern Uint16 RamfuncsRunSize;
#endif

//Moje
#include "define.h"

// Prototype statements for functions found within this file.
__interrupt void epwm2_isr_cpu01(void);
__interrupt void dcana_1_isr(void);
//__interrupt void scicRxFifoIsr(void);

//Initializations
void InitEPwm(void);
void InitAdc(void);
void InitFlash(void);
void DCAN_Boot_Gpio(Uint16 gpioSelect);
void DCAN_Init();
void DCAN_SendWordData(Uint16 data);
Uint16 DCAN_GetWordData();
void DCAN_Boot_Init();
Uint32 CAN_Boot(void);

void Example_CallFlashAPI_Erase(void);
void Example_CallFlashAPI_Program(void);
void Checksum_Error(void);
void Bootloader_Done(void);
void EntryAPP(void);
Uint16 CsmUnlock(void);

int MEP_ScaleFactor;
volatile struct EPWM_REGS *ePWM[] = {0, &EPwm1Regs, &EPwm2Regs, &EPwm3Regs, &EPwm4Regs, &EPwm5Regs, &EPwm6Regs};

__interrupt void cla1Isr1();

float licz = 0;
Uint16 data1 = 0xAA22;
Uint16 data_recieved;
int acc = 0;
Uint32 bootMode = 0x00000000, bootTest = 0x00000000, entryAdress = 0x00086608, entryPoint = 0x00000000;
Uint32 status = 0x0000;
Uint16 jump =0, fails = 0;



//--------------------------------------------------------------------------------------------------
//
//---------------------------------------------MAIN-------------------------------------------------
//
//--------------------------------------------------------------------------------------------------
void main(void)

{
// Step 1. Initialize System Control:
// Enable Peripheral Clocks
// This example function is found in the F2837xD_SysCtrl.c file.


    InitSysCtrl();




    //
    //  Unlock CSM
    //
    //  If the API functions are going to run in unsecured RAM
    //  then the CSM must be unlocked in order for the flash
    //  API functions to access the flash.
    //  If the flash API functions are executed from secure memory
    //  then this step is not required.
    //
        //DcsmZ1Unlock();
        CsmUnlock();

        InitFlash();


// Step 2. Initialize GPIO:
    InitGpio();
    DCAN_Boot_Gpio(7071);
    // Red LED
    GPIO_SetupPinOptions(34, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(34, GPIO_MUX_CPU2, 0);
    // BLUE LED
    GPIO_SetupPinOptions(31, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(31, GPIO_MUX_CPU2, 0);

    GPIO_SetupPinOptions(49, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(49, GPIO_MUX_CPU1, 0);


// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
    DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
    InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
    IER = 0x0000;
    IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
    InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.
    EALLOW;
    PieVectTable.EPWM2_INT = &epwm2_isr_cpu01;
    PieVectTable.DCANA_1_INT = &dcana_1_isr;
//    PieVectTable.SCIC_RX_INT = &scicRxFifoIsr;
//    PieVectTable.CLA1_1_INT = &cla1Isr1;

    EDIS;

// For this example, only initialize the ePWM

    InitEPwm();

// Step 4. User specific code, enable interrupts:


// Enable CPU INT3 & INT9 which is connected to EPWM1 and CANA:
    IER |= M_INT3; //PWM1
    IER |= M_INT9; //CANA

// Enable EPWM & CAN INTn & TripZone in the PIE
    PieCtrlRegs.PIEIER3.bit.INTx2 = 1; //PWM1
    PieCtrlRegs.PIEIER9.bit.INTx5 = 1; //CANA_1

// Enable global Interrupts and higher priority real-time debug events:
    EINT;  // Enable Global interrupt INTM
    ERTM;  // Enable Global realtime interrupt DBGM


    //CANGlobalIntEnable(CANA_BASE, CAN_GLB_INT_CANINT0);

    //Initialize CAN objects
    //InitCanObjects();

    //Ustawienia
    // okreďż˝lenie kierunku we/wy PWM
        GpioDataRegs.GPCSET.bit.GPIO88 = 1; // kierunek PWM1
        GpioDataRegs.GPCSET.bit.GPIO89 = 1; // kierunek PWM1 do sterowania PWM_RST, FAN, RDC

        // Start/Stop PWM
        GpioDataRegs.GPCSET.bit.GPIO85 = 1; // Start PWM1
        GpioDataRegs.GPCCLEAR.bit.GPIO86 = 1; // Start sterowania PWM_RST, FAN, RDC

//       x[0][0] = 5;

        DCAN_Boot_Init();

        while(jump == 0)
        {
            //CLA_runTest();

            //
            // Software breakpoint
            //


        }

}

//#############################################################################//
//
//------------------------------EPWM INTERRUPT --------------------------------//
//
//#############################################################################//
__interrupt void epwm2_isr_cpu01(void)
{
    if(GpioDataRegs.GPBDAT.bit.GPIO49 == 0){
        GpioDataRegs.GPBSET.bit.GPIO49 = 1;
    }
    else{
        GpioDataRegs.GPBCLEAR.bit.GPIO49 = 1;
    }

     /* Set 3rd GPIO on J6 */
    GpioDataRegs.GPASET.bit.GPIO26 = 1;



    licz += 1;
    if (licz<10000.0){
    }
    if (licz > 20000.0){
        licz = 0.0;
        GpioDataRegs.GPADAT.bit.GPIO4 = 1;
        GpioDataRegs.GPADAT.bit.GPIO4 = 0;

        DCAN_SendWordData(data1);
        if(acc == 1){
        data_recieved = DCAN_GetWordData();}

    }


    GpioDataRegs.GPASET.bit.GPIO25 = 1;


    GpioDataRegs.GPACLEAR.bit.GPIO25 = 1; /* Clear 1st GPIO on J6 */
    GpioDataRegs.GPACLEAR.bit.GPIO26 = 1; /* Clear 3st GPIO on J6 */

    /* Funkcja Bootloadera */
    if(bootMode == 0){
        //DCAN_Boot_Init();
    }
    else if(bootMode == 2){  // erase flash sectors
        DINT;
        SeizeFlashPump();
        Example_CallFlashAPI_Erase(); //Erase sector C-N
        EINT;

        DCAN_SendWordData(0x0101);

        DCAN_Boot_Init();
        bootMode = 0;
    }
    else if(bootMode == 1){     // program data
        //Example_CallFlashAPI_Program();
       /* DINT;
        DRTM;
        IER = 0x0000;
        IFR = 0x0000;*/
        SeizeFlashPump();
        entryAdress=CAN_Boot();
        bootMode = 0;
        //ReleaseFlashPump();
        //jump=1;
    }
    else{
        bootMode = 0;
    }

    if(jump == 1){
        InitFlash();
        ReleaseFlashPump();
        static void(*APPEntry)(void);
        APPEntry = (void(*)(void))(entryAdress);
        ESTOP0;
        (*APPEntry)();

    }


    EPwm2Regs.ETCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP3;

}


//--------------------------------------------------------------------------------------------------------
//------------------------------------------CANB INTERRUPT------------------------------------------------
//--------------------------------------------------------------------------------------------------------
__interrupt void dcana_1_isr(void)
{
    //Odbieranie CAN
    //canMsgRead();

    // Clear the global interrupt flag for the CAN interrupt line
    DcanaRegs.CAN_GLB_INT_CLR.bit.INT0_FLG_CLR = 1;
    //CANGlobalIntClear(CANA_BASE, CAN_GLB_INT_CANINT0);
    // Acknowledge this interrupt located in group 9
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP9;
}






