//###########################################################################
//
//
// FILE:    Fapi_UserDefinedFunctions.c
//
//
// Description: Contains all user defined functions that the Fapi
//              functions use.
//
//###########################################################################
// $TI Release: F2837xD Support Library v3.08.00.00 $
// $Release Date: Mon Dec 23 17:32:30 IST 2019 $
// $Copyright:
// Copyright (C) 2013-2019 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//

//
// Uncomment the appropriate include file for your device
//
//#include "F021_FMC_BE.h"
//#include "F021_FMC_LE.h"
//#include "F021_Concerto_C28x.h"
//#include "F021_Concerto_Cortex.h"
#include "F28x_Project.h"
#include "F021_F2837xD_C28x.h"
#include "flash_programming_c28.h" // Flash API example header file
#include "F2837x_device.h"
#include "F2837x_Examples.h"
#include "c1_bootrom.h"

#ifdef __TI_COMPILER_VERSION__
    #if __TI_COMPILER_VERSION__ >= 15009000 
        #define ramFuncSection ".TI.ramfunc"
    #else
        #define ramFuncSection "ramfuncs"
    #endif
#endif

//#define _FLASH
#define  ENTRYADDR  0x084000         //FLASH C
// Error messeges
#define exampleError    0x0100
#define checksumError   0x0200

#define NO_ERROR                            0x1000
#define BLANK_ERROR                         0x2000
#define VERIFY_ERROR                        0x3000
#define PROGRAM_ERROR                       0x4000
#define COMMAND_ERROR                       0x5000
#define DCAN_DISABLED                       0x6000


#define FLASHA_ENTRY_POINT       0x080000
#define FLASHC_ENTRY_POINT       0x084000

//
// Globals
//
typedef struct
{
   Uint16 status;
   Uint32 address;
}  StatusCode;
StatusCode statusCode;

extern uint16fptr GetWordData;      // GetWordData is a pointer to the function that
                                 // interfaces to the peripheral. Each loader assigns
                                 // this pointer to it's particular GetWordData
                                 // function.


Fapi_StatusType oReturnCheck;
volatile Fapi_FlashStatusType oFlashStatus;
Fapi_FlashStatusWordType oFlashStatusWord;



extern void DCAN_SendWordData(Uint16 data);
extern Uint16 DCAN_GetWordData();
extern void CopyData();
extern Uint32 GetLongData();
extern void ReadReservedFn();
extern Uint16 fails;
//
// Fapi_serviceWatchdogTimer - Set watchdog timer
//
#pragma CODE_SECTION(Fapi_serviceWatchdogTimer,ramFuncSection);
Fapi_StatusType Fapi_serviceWatchdogTimer(void)
{
   //
   // User to add their own watchdog servicing code here
   //
   return(Fapi_Status_Success);
}

//
// Fapi_setupEepromSectorEnable - Enable flash bank sectors
//
#pragma CODE_SECTION(Fapi_setupEepromSectorEnable,ramFuncSection);
Fapi_StatusType Fapi_setupEepromSectorEnable(void)
{
   //
   // Value must be 0xFFFF to enable erase and programming of the
   // EEPROM bank, 0 to disable
   //
   Fapi_GlobalInit.m_poFlashControlRegisters->Fbse.u32Register = 0xFFFF;

   //
   // Enables sectors 32-63 for bank and sector erase
   //
   FAPI_WRITE_LOCKED_FSM_REGISTER(Fapi_GlobalInit.m_poFlashControlRegisters->FsmSector.u32Register, 0x0U);

   //
   // Enables sectors 0-31 for bank and sector erase
   //
   FAPI_WRITE_LOCKED_FSM_REGISTER(Fapi_GlobalInit.m_poFlashControlRegisters->FsmSector1.u32Register, 0x0U);

   //
   // Enables sectors 32-63 for bank and sector erase
   //
   FAPI_WRITE_LOCKED_FSM_REGISTER(Fapi_GlobalInit.m_poFlashControlRegisters->FsmSector2.u32Register, 0x0U);

   return(Fapi_Status_Success);
}

//
// Fapi_setupBankSectorEnable - Enable flash bank sectors
//
#pragma CODE_SECTION(Fapi_setupBankSectorEnable,ramFuncSection);
Fapi_StatusType Fapi_setupBankSectorEnable(void)
{
   //
   // Enable sectors 0-15 for erase and programming
   //
   Fapi_GlobalInit.m_poFlashControlRegisters->Fbse.u32Register = 0xFFFF;
   FAPI_WRITE_LOCKED_FSM_REGISTER(Fapi_GlobalInit.m_poFlashControlRegisters->FsmSector.u32Register, 0x0U);

   return(Fapi_Status_Success);
}

#pragma CODE_SECTION(Example_Error,ramFuncSection);
void Example_Error(Fapi_StatusType status)
{
    DINT;
    while(1)
    {
        DCAN_SendWordData(status);
    }
}

#pragma CODE_SECTION(Checksum_Error,ramFuncSection);
void Checksum_Error(void){
    DINT;
    while(1)
    {
        DCAN_SendWordData(checksumError);
    }
}

#pragma CODE_SECTION(Bootloader_Done,ramFuncSection);
void Bootloader_Done(void)
{
    __asm("    ESTOP0");
}

#pragma CODE_SECTION(EntryAPP, ramFuncSection);
void EntryAPP(void)
{
    static void(*APPEntry)(void);
    APPEntry = (void(*)(void))(ENTRYADDR);
   // __asm("    ESTOP0");
    ESTOP0;
    (*APPEntry)();
}

#pragma CODE_SECTION(Example_CallFlashAPI_Erase,ramFuncSection);
void Example_CallFlashAPI_Erase(void)
{

  //  Fapi_StatusType oReturnCheck;
  //  volatile Fapi_FlashStatusType oFlashStatus;
  //  Fapi_FlashStatusWordType oFlashStatusWord;

    EALLOW;

    //
    // This function is required to initialize the Flash API based on System
    // frequency before any other Flash API operation can be performed
    //
    oReturnCheck = Fapi_initializeAPI(F021_CPU0_BASE_ADDRESS, 200);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        Example_Error(oReturnCheck);
    }

    // Fapi_setActiveFlashBank function sets the Flash bank and FMC for further
    // Flash operations to be performed on the bank
    // Fapi_setActiveFlashBank
    oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank0);

    if(oReturnCheck != Fapi_Status_Success)
    {
        // Check Flash API documentation for possible errors
        Example_Error(oReturnCheck);
    }


    // Erase Sector C
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorC_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorC_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector D
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorD_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorD_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector E
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorE_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorE_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector F
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorF_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorF_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector G
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorG_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorG_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector H
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorH_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorH_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector I
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorI_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorI_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector J
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorJ_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorJ_start,
                                     Bzero_64KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector K
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorK_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorK_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector L
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorL_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorL_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector M
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorM_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorM_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }

    // Erase Sector N
    //
    oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,
                   (uint32 *)Bzero_SectorN_start);

    while(Fapi_checkFsmForReady() != Fapi_Status_FsmReady){}

    oReturnCheck = Fapi_doBlankCheck((uint32 *)Bzero_SectorN_start,
                                     Bzero_16KSector_u32length,
                                     &oFlashStatusWord);

    if(oReturnCheck != Fapi_Status_Success)
    {
        Example_Error(oReturnCheck);
    }


    EDIS;

    // Leave control over flash pump
    // CPU1״̬
    ReleaseFlashPump();
}

#pragma CODE_SECTION(CopyData, ramFuncSection);
Uint16 CopyData1(void){
    struct HEADER
    {
        Uint16 BlockSize;
        Uint32 *DestAddr;
    } BlockHeader;

    //Uint16 Buffer[BUFFER_SIZE];
    //Uint16 miniBuffer[8]; //useful for 8-w
    Uint16 i = 0;
    Uint16 wordData[2];
    uint32 u32Index;
    Uint16 fail=0;

    SeizeFlashPump();
    EALLOW;
    FlashEccRegs.ECC_ENABLE.bit.ENABLE = 0x0;

    oReturnCheck = Fapi_initializeAPI(F021_CPU0_BASE_ADDRESS, 150);

    if(oReturnCheck != Fapi_Status_Success)
    {
            // Check Flash API documentation for possible errors
            Example_Error(oReturnCheck);
    }

    // Fapi_setActiveFlashBank function sets the Flash bank and FMC for further
    // Flash operations to be performed on the bank
    // Fapi_setActiveFlashBank ��������Flash bank��FMC�Խ��н�һ����Flash����������bankִ��
    oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank0);

    if(oReturnCheck != Fapi_Status_Success)
    {
            // Check Flash API documentation for possible errors
            Example_Error(oReturnCheck);
    }
    FlashEccRegs.ECC_ENABLE.bit.ENABLE = 0xA;
    EDIS;

    //
    // Get the size in words of the first block
    //
    BlockHeader.BlockSize = (*GetWordData)();

    EALLOW;
    while(BlockHeader.BlockSize != (Uint16)0x0000)
    {
        BlockHeader.DestAddr = (uint32 *)(GetLongData());
        u32Index = (uint32)BlockHeader.DestAddr;

        for(i = 0; i<BlockHeader.BlockSize; i++)
        {
            wordData[0] = (*GetWordData)();
            oReturnCheck = Fapi_issueProgrammingCommand((uint32 *)u32Index,
                    (wordData),1,0,0,Fapi_DataOnly);

            while(Fapi_checkFsmForReady() == Fapi_Status_FsmBusy);

            if(oReturnCheck != Fapi_Status_Success)
            {
                Example_Error(oReturnCheck);
                fail+=1;
            }
            u32Index+=1;
        }
        //
        //get the size of the next block
        //
        BlockHeader.BlockSize = (*GetWordData)();
    }

    FlashEccRegs.ECC_ENABLE.bit.ENABLE = 0x0;
    EDIS;
    return fail;
    //ReleaseFlashPump();
}


#pragma CODE_SECTION(CAN_Boot, ramFuncSection);
Uint32 CAN_Boot(void)
{
    Uint32 entryAddr = FLASHC_ENTRY_POINT;

    statusCode.status = NO_ERROR;
    statusCode.address = 0x12346578;

    //If DCAN-A is not enabled, bypass the bootloader
    #ifdef CPU1
        if (DevCfgRegs.DC11.bit.CAN_A != 1)
            return DCAN_DISABLED;
    #endif

    //
    // Assign GetWordData to the DCAN version of the
    // function. GetWordData is a pointer to a function.
    //
    GetWordData = DCAN_GetWordData;

    //
    // If the KeyValue was invalid, abort the load
    // and return the flash entry point.
    //
    if ((*GetWordData)() != 0x08AA)
    {
        statusCode.status = VERIFY_ERROR;
        statusCode.address = FLASHA_ENTRY_POINT;
    }

    ReadReservedFn();
    entryAddr = GetLongData();
    fails=CopyData1();

    Uint16 x = 0;
    for(x = 0; x < 32676; x++){}
    for(x = 0; x < 32676; x++){}

    return entryAddr;
}





//
// End of file
//

