
/*
 *  main.c 
 * 
 *  CLA Complete Demo 
 *  
 *  This example shows how to use CLA and to compare results of the same calculation done on CPU1 and CPU1CLA1.
 *  The GPIO 25 to 27 can be use to compare how much time CPU and CLA needs to complete the task.
 *  CLA1 and memory initialization is placed in   CLA_config().
 *  GPIO pins are configured in    InitGpio().
 *
 *  
 *  x[] - CPU1toCLA1Msg - variable send to CLA
 *  x[] - CLA1toCPU1Msg - variables get back form CLA1
 *  
 *  To compare results observe 1st,2nd and 3rd outputs on J6 (LAUNCHXL_F28379D)
 *  CPU output variables: iD and iQ
 *  CLA output variables: z[0] and z[1]
 * 
 *  Created on: 10 mar 2020
 *      Author: m.stasiak
 */

#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837x_device.h"
#include "F2837x_EPwm_defines.h"
#include "SFO_V8.h" //Do HRPWM


#include "F2837xD_Ipc_drivers.h"
#include <stdint.h>
#include <math.h>
#include <string.h>

//Can libraries
#include "inc/hw_memmap.h"
#include "inc/hw_can.h"
#include "inc/hw_types.h"
#include "driverlib/can.h"

/* CLA */
#include "cla_EV_charger_shared.h"
#include "CLAmath.h"
#include "functionTest.h"

/* CAN Bootloader */
//#include "flash_programming_c28.h" // Flash API example header file
//#include "c1_bootrom.h"
//#include "F021_F2837xD_C28x.h"
//#include "c1_bootrom.h"

//#define _FLASH

//
// Globals
//
#ifdef _FLASH
    extern uint32_t Cla1funcsRunStart, Cla1funcsLoadStart, Cla1funcsLoadSize;
    extern uint16_t Cla1ProgRunStart, Cla1ProgLoadStart, Cla1ProgLoadSize;
    extern uint16_t CLA1mathTablesRunStart, CLA1mathTablesLoadStart;
    extern uint16_t CLA1mathTablesLoadSize;
    extern Uint16 RamfuncsLoadStart;
    extern Uint16 RamfuncsLoadEnd;
    extern Uint16 RamfuncsLoadSize;
    extern Uint16 RamfuncsRunStart;
    extern Uint16 RamfuncsRunEnd;
    extern Uint16 RamfuncsRunSize;
#endif

//
//Task 1 (C) Variables
//
#ifdef __cplusplus
#pragma DATA_SECTION("CpuToCla1MsgRAM")
float x[20];
#pragma DATA_SECTION("CpuToCla1MsgRAM")
float x2;
#pragma DATA_SECTION("CpuToCla1MsgRAM")
float x3[20];
#pragma DATA_SECTION("Cla1ToCpuMsgRAM")
float z[20];
#else
#pragma DATA_SECTION(x,"CpuToCla1MsgRAM")
float x[20];
#pragma DATA_SECTION(x2,"CpuToCla1MsgRAM")
float x2;
#pragma DATA_SECTION(x3,"CpuToCla1MsgRAM")
float x3[20];
#pragma DATA_SECTION(z,"Cla1ToCpuMsgRAM")
float z[20];
#endif //__cplusplus

/*
 * GLOBAL VARIABLES IPC
 * Shared data CPU1 and CPU2 - placed on RAMGS14
 * Recieved data from CPU2 placed on RAMGS15
 */
#pragma DATA_SECTION(sD,"SharedData")
volatile float sD[100];
#pragma DATA_SECTION(rD,"RecievedData")
volatile float rD[100];


//CAN objects dla EV
    //Odsyla status i ustawienia
    tCANMsgObject Obj_Sinexcel_out;
    unsigned char Data_Sinexcel_out[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

    tCANMsgObject Obj_Sinexcel_in;
    unsigned char Data_Sinexcel_in[8] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//Moje
#include "define.h"
#include "zmienne.h"
#include "funkcjeCAN.h"
#include "funkcje.h"
//#include "_1_Wire.h"


// Prototype statements for functions found within this file.
__interrupt void epwm1_isr_cpu01(void);
__interrupt void dcana_2_isr(void);
//extern __interrupt void dcana_1_isr(void);
//PINT DCANisr = (PINT)(0x0008150d);
//__interrupt void scicRxFifoIsr(void);

//Initializations
void InitEPwm(void);
void InitAdc(void);
void CLA_config(void);
void IPCmemoryCfg(void); // Give access CPU2 to RAMGS15 where the CPU2 shared memory is located
void SetupInputXBAR5(void);
void InitFlash(void);
void DCAN_Boot_Gpio(Uint16 gpioSelect);
void DCAN_Init();
void DCAN_SendWordData(Uint16 data);
Uint16 DCAN_GetWordData();
void DCAN_Boot_Init();


int MEP_ScaleFactor;
volatile struct EPWM_REGS *ePWM[] = {0, &EPwm1Regs, &EPwm2Regs, &EPwm3Regs, &EPwm4Regs, &EPwm5Regs, &EPwm6Regs};

__interrupt void cla1Isr1();



float32 theta, rad, f = 25000.0;
float32 iA, iB, iC, uBC, uCA;
float32 iAlfa,iBeta,uAlfa,uBeta;
float32 iD,iQ,sinPLL,cosPLL;
Uint16 data1 = 0xABCD;
Uint16 data_recieved;
int acc = 0;
Uint32 bootMode = 0x00000000, bootTest = 0x00000000, entryAdress = 0x00086608, entryPoint = 0x00000000;
//--------------------------------------------------------------------------------------------------
//
//---------------------------------------------MAIN-------------------------------------------------
//
//--------------------------------------------------------------------------------------------------
void main(void)

{
    //0x00008150d // adres przerwania od CAN1A
    sD[0] = 100.0;
    sD[1] = 1000.0;
    /*
     * Step 0, configure CPUSEL DevCfgRegs.CPUSELx.
     */
    EALLOW;
    DevCfgRegs.CPUSEL0.bit.EPWM1 = 0;
    DevCfgRegs.CPUSEL0.bit.EPWM2 = 0;
    DevCfgRegs.CPUSEL0.bit.EPWM3 = 0;
    DevCfgRegs.CPUSEL0.bit.EPWM4 = 1;
    DevCfgRegs.CPUSEL0.bit.EPWM5 = 1;
    DevCfgRegs.CPUSEL0.bit.EPWM6 = 1;
    EDIS;
 //   DevCfgRegs.CPUSEL0.bit.EPWM7 = 0;

// Step 1. Initialize System Control:
// Enable Peripheral Clocks
// This example function is found in the F2837xD_SysCtrl.c file.

    InitSysCtrl();


#ifdef _FLASH
    //
    // Send boot command to allow the CPU2 application to begin execution
    //
    IPCBootCPU2(C1C2_BROM_BOOTMODE_BOOT_FROM_FLASH);

    //
    // Copy over code and tables from FLASH to RAM
    //
    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (uint32_t)&RamfuncsLoadSize);
    memcpy((uint32_t *)&Cla1ProgRunStart, (uint32_t *)&Cla1ProgLoadStart,
            (uint32_t)&Cla1ProgLoadSize);
    //
    // Copy over CLA Math tables from FLASH to RAM
    //
    memcpy((uint32_t *)&CLA1mathTablesRunStart, (uint32_t *)&CLA1mathTablesLoadStart,
            (uint32_t)&CLA1mathTablesLoadSize);

    InitFlash();
#endif //_FLASH


// Step 2. Initialize GPIO:
    InitGpio();
    DCAN_Boot_Gpio(7071);
    // Red LED
    GPIO_SetupPinOptions(34, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(34, GPIO_MUX_CPU2, 0);
    // BLUE LED
    GPIO_SetupPinOptions(31, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(31, GPIO_MUX_CPU2, 0);

    GPIO_SetupPinOptions(49, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(49, GPIO_MUX_CPU1, 0);
    SetupInputXBAR5();

    // Check whether CPU have access to GS memory
    while(!MemCfgRegs.GSxMSEL.bit.MSEL_GS15){
        IPCmemoryCfg();
   }

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
    DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
    InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
    IER = 0x0000;
    IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
    InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.
    EALLOW;
    PieVectTable.EPWM1_INT = &epwm1_isr_cpu01;
    PieVectTable.DCANA_2_INT = &dcana_2_isr;
//    PieVectTable.DCANA_1_INT = DCANisr;
//    PieVectTable.SCIC_RX_INT = &scicRxFifoIsr;
//    PieVectTable.CLA1_1_INT = &cla1Isr1;


    //TrigRegs.SYNCSEL.bit..bit.SYNCOUT = 0x0;
    TrigRegs.SYNCSEL.bit.EPWM4SYNCIN = 0x5;
    //SyncSocRegs.SYNCSELECT.bit.EPWM4SYNCIN = 0x5;
    //TrigRegs.SYNCSEL.bit..bit.EPWM1SYNCIN = 0x5;
    EDIS;

// For this example, only initialize the ePWM
    CLA_config();
    InitEPwm();
    //InitCan(CANA_BASE);



                //CANInit(CANA_BASE);
                //CANClkSourceSelect(CANA_BASE, 0);   // 500kHz CAN-Clock
                //CANBitRateSet(CANA_BASE, 200000000, 125000);
                //CANIntEnable(CANA_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);


// Step 4. User specific code, enable interrupts:
    InitAdc();

// Enable CPU INT3 & INT9 which is connected to EPWM1 and CANA:
    IER |= M_INT3; //PWM1
    IER |= M_INT9; //CANA
//    IER |= M_INT8; //SCIC
//    IER |= (M_INT11); // CLA1

// Enable EPWM & CAN INTn & TripZone in the PIE
    PieCtrlRegs.PIEIER3.bit.INTx1 = 1; //PWM1
//   PieCtrlRegs.PIEIER9.bit.INTx5 = 1; //CANA 1
    PieCtrlRegs.PIEIER9.bit.INTx6 = 1; //CANA 2
//    PieCtrlRegs.PIEIER8.bit.INTx5 = 1; //SCIc 1-wire
//    PieCtrlRegs.PIEIER11.all = 0xFFFF; // CLA1 group

// Enable global Interrupts and higher priority real-time debug events:
    EINT;  // Enable Global interrupt INTM
    ERTM;  // Enable Global realtime interrupt DBGM

                //CANGlobalIntEnable(CANA_BASE, CAN_GLB_INT_CANINT0);

    //Initialize CAN objects
    //InitCanObjects();

//    _1_Wire_sci_init();

    x[10] = 2000.0;
    //Ustawienia
    // okre�lenie kierunku we/wy PWM
        GpioDataRegs.GPCSET.bit.GPIO88 = 1; // kierunek PWM1
        GpioDataRegs.GPCSET.bit.GPIO89 = 1; // kierunek PWM1 do sterowania PWM_RST, FAN, RDC

        // Start/Stop PWM
        GpioDataRegs.GPCSET.bit.GPIO85 = 1; // Start PWM1
        GpioDataRegs.GPCCLEAR.bit.GPIO86 = 1; // Start sterowania PWM_RST, FAN, RDC

//       x[0][0] = 5;

        DCAN_Boot_Init();

        while(1)
        {
            //CLA_runTest();

            //
            // Software breakpoint
            //

        }


}

//#############################################################################//
//
//------------------------------EPWM INTERRUPT --------------------------------//
//
//#############################################################################//
__interrupt void epwm1_isr_cpu01(void)
{
    if(GpioDataRegs.GPBDAT.bit.GPIO49 == 0){
        GpioDataRegs.GPBSET.bit.GPIO49 = 1;
    }
    else{
        GpioDataRegs.GPBCLEAR.bit.GPIO49 = 1;
    }

     /* Set 3rd GPIO on J6 */
    GpioDataRegs.GPASET.bit.GPIO26 = 1;



    licz += 1;
    if (licz<25000.0){

        sD[0] = 10.0;
    }
    else
    {
        sD[0] = 100.0;
    }

    if (licz > 50000.0){
        licz = 0.0;
        GpioDataRegs.GPADAT.bit.GPIO4 = 1;
        GpioDataRegs.GPADAT.bit.GPIO4 = 0;


        DCAN_SendWordData(data1);
        if(acc == 1){
        data_recieved = DCAN_GetWordData();
        }

    }

    EPwm1Regs.CMPA.all = (Uint16)(sD[1]);
    EPwm2Regs.CMPA.all = (Uint16)(sD[1]);
    EPwm3Regs.CMPA.all = (Uint16)(sD[1]);
    EPwm4Regs.CMPA.all = (Uint16)(sD[1]);

   /* Measurments simulation */
    if(theta<M_PI2){
        theta += M_PI2/f;
    }
    else{
        theta-=M_PI2;
    }
    iA = 20.0*sinf(theta)+5.0*sinf(3.0*theta);
    iB = 20.0*sinf(theta-M_PI2/3.0);
    iC = 20.0*sinf(theta+M_PI2/3.0);

    uCA = 400.0*sinf(theta);
    uBC = 400.0*sinf(theta+M_PI2/6.0);
    /* Insert data to shared memory */
    x[0] = theta;
    x[1] = iA;
    x[2] = iB;
    x[3] = iC;
    x[4] = uCA;
    x[5] = uBC;
    /* Initialization of CLA1Task1 */
    Cla1ForceTask1();
    /* Set 1st GPIO on J6 */
    GpioDataRegs.GPASET.bit.GPIO25 = 1;
    /* ClarkPark transformation */
    calculationPLL(&sinPLL,&cosPLL,theta);
    clarkTransformation(&iAlfa,&iBeta,&uAlfa,&uBeta,iA,iB,iC,uCA,uBC);
    parkTransformation(&iD,&iQ,iAlfa,iBeta,sinPLL,cosPLL);

    GpioDataRegs.GPACLEAR.bit.GPIO25 = 1; /* Clear 1st GPIO on J6 */
    GpioDataRegs.GPACLEAR.bit.GPIO26 = 1; /* Clear 3st GPIO on J6 */

    /* Funkcja Bootloadera */
    if(bootMode == 0){
        //DCAN_Boot_Init();
    }
    else{
        //bootTest = DCAN_Boot(DCAN_BOOT_SENDTEST);
        //DCAN_Boot_Init();
        bootMode = 0;
      /*  if(bootTest == FLASH_ENTRY_POINT){
            entryPoint = DCAN_Boot(DCAN_BOOT);
        }*/
    }




    EPwm1Regs.ETCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP3;

}


//--------------------------------------------------------------------------------------------------------
//------------------------------------------CANB INTERRUPT------------------------------------------------
//--------------------------------------------------------------------------------------------------------
__interrupt void dcana_2_isr(void)
{

    //Odbieranie CAN
    //canMsgRead();
    //data_recieved = DCAN_GetWordData();
    //DCAN_SendWordData(0x1111);
    // Clear the global interrupt flag for the CAN interrupt line
    DcanaRegs.CAN_GLB_INT_CLR.bit.INT1_FLG_CLR = 1;
    // Acknowledge this interrupt located in group 9
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP9;
}

//
// cla1Isr1 - CLA1 ISR 1
//
__interrupt void cla1Isr1 ()
{
    GpioDataRegs.GPASET.bit.GPIO26 = 1;



    GpioDataRegs.GPACLEAR.bit.GPIO26 = 1;
    PieCtrlRegs.PIEACK.all = M_INT11;
}



void SetupInputXBAR5(void)
{
    EALLOW;
    //InputXbarRegs.INPUT5SELECT = 4; //GPIO0 will trigger the input XBAR line 5
    TrigRegs.GPTRIP5SEL = 4;
    //
    //GPIO0 as an output
    //
    GPIO_SetupPinOptions(4, GPIO_OUTPUT, GPIO_PUSHPULL);
    GPIO_SetupPinMux(4, GPIO_MUX_CPU1, 0);

    //
    //GPIO0 set as low
    //
    GpioDataRegs.GPADAT.bit.GPIO0 = 0;
    EDIS;
}

