
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN           	: origin = 0x000000, length = 0x000002
   RAMM0           	: origin = 0x000122, length = 0x0002DE
   RAMD0           	: origin = 0x00B000, length = 0x000800
   RAMLS0          	: origin = 0x008000, length = 0x000800
   RAMLS1          	: origin = 0x008800, length = 0x000800
   RAMLS2      		: origin = 0x009000, length = 0x000800
   RAMLS3      		: origin = 0x009800, length = 0x000800
   RAMLS4      		: origin = 0x00A000, length = 0x000800
   RAMGS14          : origin = 0x01A000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS15          : origin = 0x01B000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RESET           	: origin = 0x3FFFC0, length = 0x000002

PAGE 1 :

   BOOT_RSVD       : origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */
   RAMM1           : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */
   RAMD1           : origin = 0x00B800, length = 0x000800

   RAMLS5      : origin = 0x00A800, length = 0x000800

   //....RAMGS0      : origin = 0x00C000, length = 0x001000
   // remap RAMGS0 to small segments that can save the measurements in floating format (32 bits)
   // RAMGS0 is 4096-bit long -> 128 measurements can be saved here

   RAMGS0_0    : origin = 0X00C000, length = 0x000020	// each segment is assigned with 32-bit length
   RAMGS0_1    : origin = 0X00C020, length = 0x000020
   RAMGS0_2    : origin = 0X00C040, length = 0x000020
   RAMGS0_3    : origin = 0X00C060, length = 0x000020
   RAMGS0_4    : origin = 0X00C080, length = 0x000020
   RAMGS0_5    : origin = 0X00C0A0, length = 0x000020
   RAMGS0_6    : origin = 0X00C0C0, length = 0x000020
   RAMGS0_7    : origin = 0X00C0E0, length = 0x000020
   RAMGS0_8    : origin = 0X00C100, length = 0x000020
   RAMGS0_9    : origin = 0X00C120, length = 0x000020
   //------ above is 10 32-bit shared ram segments----//
   //------ (if more needed, follow the pattern and make more)---//
   RAMGS0_REST : origin = 0X00C140, length = 0x000EC0	// assign rest of the RAM to a big section

   RAMGS1      : origin = 0x00D000, length = 0x001000
   RAMGS2      : origin = 0x00E000, length = 0x001000
   RAMGS3      : origin = 0x00F000, length = 0x001000
   RAMGS4      : origin = 0x010000, length = 0x001000
   RAMGS5      : origin = 0x011000, length = 0x001000
   RAMGS6      : origin = 0x012000, length = 0x001000
   RAMGS7      : origin = 0x013000, length = 0x001000
   RAMGS8      : origin = 0x014000, length = 0x001000
   RAMGS9      : origin = 0x015000, length = 0x001000
   RAMGS10     : origin = 0x016000, length = 0x001000
   RAMGS11     : origin = 0x017000, length = 0x001000
   RAMGS12     : origin = 0x018000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   RAMGS13     : origin = 0x019000, length = 0x001000     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */

   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800
}

SECTIONS
{
   codestart        : > BEGIN,     PAGE = 0
   .text            : >>RAMD0 |  RAMLS0 | RAMLS1 | RAMLS2 | RAMLS3 | RAMLS4| RAMGS14,   PAGE = 0 // assign RAMGS14 to this
   .cinit           : > RAMM0 | RAMLS4,     PAGE = 0    // give extra ram (RAMLS4) to .cinit
   .pinit           : > RAMM0,     PAGE = 0
   .switch          : > RAMM0,     PAGE = 0
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM1,     PAGE = 1
   .ebss            : > RAMLS5,     PAGE = 1
   .econst          : > RAMLS5,     PAGE = 1
   .esysmem         : > RAMLS5,     PAGE = 1
   Filter_RegsFile  : > RAMGS0_REST,	   PAGE = 1

   //.... SHARERAMGS0		: > RAMGS0,		PAGE = 1
   // This SHAREMGS0 is also divided into small segments the same as RAMGS0 to save data
   SHARERAMGS0_0	: > RAMGS0_0,		PAGE = 1
   SHARERAMGS0_1	: > RAMGS0_1,		PAGE = 1
   SHARERAMGS0_2	: > RAMGS0_2,		PAGE = 1
   SHARERAMGS0_3	: > RAMGS0_3,		PAGE = 1
   SHARERAMGS0_4	: > RAMGS0_4,		PAGE = 1
   SHARERAMGS0_5	: > RAMGS0_5,		PAGE = 1
   SHARERAMGS0_6	: > RAMGS0_6,		PAGE = 1
   SHARERAMGS0_7	: > RAMGS0_7,		PAGE = 1
   SHARERAMGS0_8	: > RAMGS0_8,		PAGE = 1
   SHARERAMGS0_9	: > RAMGS0_9,		PAGE = 1
   SHARERAMGS0_REST : > RAMGS0_REST,    PAGE = 1

   SHARERAMGS1		: > RAMGS1,		PAGE = 1
   SHARERAMGS2		: > RAMGS2,		PAGE = 1
   SHARERAMGS3		: > RAMGS3,		PAGE = 1
   SHARERAMGS4		: > RAMGS4,		PAGE = 1
   SHARERAMGS5		: > RAMGS5,		PAGE = 1
   SHARERAMGS6		: > RAMGS6,		PAGE = 1
   SHARERAMGS7		: > RAMGS7,		PAGE = 1
   SHARERAMGS8		: > RAMGS8,		PAGE = 1
   SHARERAMGS9		: > RAMGS9,		PAGE = 1
   SHARERAMGS10		: > RAMGS10,	PAGE = 1
   SHARERAMGS11		: > RAMGS11,	PAGE = 1
   SHARERAMGS12		: > RAMGS12,	PAGE = 1     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   SHARERAMGS13		: > RAMGS13,	PAGE = 1     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   SHARERAMGS14		: > RAMGS14,	PAGE = 0     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */
   SHARERAMGS15		: > RAMGS15,	PAGE = 0     /* Only Available on F28379D, F28377D, F28375D devices. Remove line on other devices. */

#ifdef __TI_COMPILER_VERSION__
   #if __TI_COMPILER_VERSION__ >= 15009000
    .TI.ramfunc : {} > RAMM0,      PAGE = 0
   #else
   ramfuncs         : > RAMM0      PAGE = 0   
   #endif
#endif


}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
