/*
 * Function_define_Longmax_28388D.c
 *
 *  Created on: Feb27, 2020
 *      Author: weizhong
 */



#include "F28x_Project.h"
#include "Function_define_Longmax_28379D.h"


//......................... Global variables for debugging ............
Uint16 CMPA_reg_val;
Uint16 CMPAHR_reg_val;
Uint32 temp_CMPA;
Uint16 TBPHS_reg_val;
Uint16 TBPHSHR_reg_val;
Uint32 temp_TBPHS;

// ........ Timer ...........//
Uint32 cpuTime  = 0;                                                          // The time difference between point 1 and 2
float cpuTime_us  = 0;                                                      // The time difference between point 1 and 2 in us
Uint32 cpuTime1 = 0;                                                          // Starting point of the timer
Uint32 cpuTime2 = 0;                                                          // End point of the timer

//.....max temp function....//
int max_temp_value = 0;

//........  IPC .............//
struct readIPC{                                                               // structure for read IPC function
    Uint32 command;
    Uint32 address;
    Uint32 data;
};
/////////////TEST FUNCTIONS//////////////


///////////////////////////////////////////////////////////////////////////////////
//////////////////////// General purpose functions////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//............................... IPC related ..................................//

/* define read IPC command. TI didn't provide the read command in Ipc.c */
//struct readIPC ReadIpcCommand(void)
//{
//    struct readIPC ret;
//
//    ret.command = IpcRegs.IPCRECVCOM;
//    ret.address = IpcRegs.IPCRECVADDR;
//    ret.data    = IpcRegs.IPCRECVDATA;
//
//    return ret;
//
//
//}
//............................... Timer setup ..................................//
void StartTimer(void)
{


    EALLOW;
    CpuTimer2Regs.TCR.bit.TRB = 1;        // Reset CPU timer to period value
    CpuTimer2Regs.TCR.bit.TSS = 0;        // Start or reset CPU timer 2
    cpuTime1 = CpuTimer2Regs.TIM.all;     // Get value of CPU Timer 2 before code
    EDIS;
}

float StopTimer(void)
{

    EALLOW;
    cpuTime2 = CpuTimer2Regs.TIM.all;    // Get value of CPU Timer 2 after code
    cpuTime = cpuTime1 - cpuTime2;     // Calculate time using cpuTimer2
    cpuTime_us = cpuTime * 5.0 / 1000.0;   // Calculate the time from StartTimer to StopTimer in us (5ns is the period of the timer)
    CpuTimer2Regs.TCR.bit.TSS = 1;        // Start or reset CPU timer 2
    EDIS;
    return cpuTime_us;
}



//............................... SPI...........................................//
void Initspi(unsigned int SPI_use, int master_slave, int loop_back, int cpol,int cpha, int word_bit)
{
    // Initialize SPI-B

    // Set reset low before configuration changes
    // Clock polarity (0 == rising, 1 == falling)
    // 16-bit character
    // Enable loop-back (*SPIs[SPI_use])
    (*SPIs[SPI_use]).SPICCR.bit.SPISWRESET = 0;
    (*SPIs[SPI_use]).SPICCR.bit.CLKPOLARITY = cpol;
    (*SPIs[SPI_use]).SPICCR.bit.SPICHAR = (word_bit-1);
    (*SPIs[SPI_use]).SPICCR.bit.SPILBK = loop_back;

    // Enable master (0 == slave, 1 == master)
    // Enable transmission (Talk)
    // Clock phase (0 == normal, 1 == delayed)
    // SPI interrupts are disabled
    (*SPIs[SPI_use]).SPICTL.bit.MASTER_SLAVE = master_slave;
    (*SPIs[SPI_use]).SPICTL.bit.TALK = 1;
    (*SPIs[SPI_use]).SPICTL.bit.CLK_PHASE = cpha;
    (*SPIs[SPI_use]).SPICTL.bit.SPIINTENA = 0;

    // Set the baud rate
    (*SPIs[SPI_use]).SPIBRR.bit.SPI_BIT_RATE = SPI_BRR;

    // Set FREE bit
    // Halting on a breakpoint will not halt the SPI
    (*SPIs[SPI_use]).SPIPRI.bit.FREE = 1;

    // Release the SPI from reset
    (*SPIs[SPI_use]).SPICCR.bit.SPISWRESET = 1;
    // Clear INT
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFINTCLR=1;                                  // Clear Interrupt flag for TX
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFINTCLR=1;                                  // Clear Interrupt flag

    /*
    // Overwrite the default settings in InitSpi()
    (*SPIs[SPI_use]).SPICCR.bit.SPICHAR         = (wrd_bit-1);              // word length
    (*SPIs[SPI_use]).SPICCR.bit.SPILBK          = 0;                        // Disable loopback
    (*SPIs[SPI_use]).SPICTL.bit.MASTER_SLAVE    = 0;                        // Choose SPIA as slave (1-master, 0-slave)

    (*SPIs[SPI_use]).SPIPRI.bit.SOFT            = 0;                        // Stop the transmittion whenever hits breakpoint
    (*SPIs[SPI_use]).SPIPRI.bit.FREE            = 1;                        // 1-free run even with breakpoint, 0-stop with SOFT mode
    */
}


/// ************ 28379D SPIA GPIO configuration ***********
#ifdef CPU1                 // GPIO can only be set by CPU 1 in TI code, CPU 2 won't get access to GPIOCTRLREGS (low level)
void InitspiaGpio(void)
{
    EALLOW;
       //
       // Enable internal pull-up for the selected pins
       //
       // Pull-ups can be enabled or disabled by the user.
       // This will enable the pullups for the specified pins.
       // Comment out other unwanted lines.
       //
       /*
        * The interface card V2 connected GPIO58-61 to SPIB
        * Note that there are other GPIOs that can be configured as SPIB, e.g. 22-24
        * Make sure correct GPIOs are configured
        */
       GpioCtrlRegs.GPAPUD.bit.GPIO16 = 0;  // Enable pull-up on GPIO16 (SPISIMO)
       GpioCtrlRegs.GPAPUD.bit.GPIO17 = 0;  // Enable pull-up on GPIO17 (SPISOMI)
       GpioCtrlRegs.GPAPUD.bit.GPIO18 = 0;  // Enable pull-up on GPIO18 (SPICLK)
       GpioCtrlRegs.GPAPUD.bit.GPIO19 = 0;  // Enable pull-up on GPIO19 (SPISTEn)


       //
       // Set qualification for selected pins to asynch only
       //
       // This will select asynch (no qualification) for the selected pins.
       // Comment out other unwanted lines.
       //
       GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = 3; // Asynch input GPIO16 (SPISIMO)
       GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = 3; // Asynch input GPIO17 (SPISOMI)
       GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = 3; // Asynch input GPIO18 (SPICLK)
       GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = 3; // Asynch input GPIO19 (SPISTEn)

       //
       //Configure SPI-A pins using GPIO regs
       //
       // This specifies which of the possible GPIO pins will be SPI functional
       // pins.
       // Comment out other unwanted lines.
       //
//       GpioCtrlRegs.GPAGMUX2.bit.GPIO16 = 3; // Configure GPIO58 as SPISIMOA
//       GpioCtrlRegs.GPAGMUX2.bit.GPIO17 = 3; // Configure GPIO59 as SPISOMIB
//       GpioCtrlRegs.GPAGMUX2.bit.GPIO18 = 3; // Configure GPIO60 as SPICLKB
//       GpioCtrlRegs.GPAGMUX2.bit.GPIO19 = 3; // Configure GPIO61 as SPISTEB

       GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 1; // Configure GPIO16 as SPISIMOB
       GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 1; // Configure GPIO17 as SPISOMIB
       GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 1; // Configure GPIO18 as SPICLKB
       GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 1; // Configure GPIO19 as SPISTEB


   EDIS;
}

#endif


//......................................................DAC.........................//
//
// ConfigureDAC - Configure specified DAC output
//
void ConfigureDAC(Uint16 dac_num)
{
    EALLOW;
    DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;
    DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;
    DAC_PTR[dac_num]->DACVALS.all = 0;
    DELAY_US(10); // Delay for buffered DAC to power up
    EDIS;
}

//
// spia_fifo_init - Initialize SPI FIFO
//
void spi_fifo_init(unsigned int SPI_use,int FIFO_RXLVL, int FIFO_TXLVL,int delay)                                    // Initialize SPI FIFO registers
{

    (*SPIs[SPI_use]).SPIFFTX.all                  = 0xC020;                      // Enable FIFOs
    (*SPIs[SPI_use]).SPIFFRX.all                  = 0x0020;                      // Set RX FIFO level to 6 (0x002 ->6<-)



    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFIL           = FIFO_RXLVL;           // Set RX FIFO level��it means whenever all the data are transmitted, the interrupt will trigger and update the transmitting data
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFIL           = FIFO_TXLVL;           // Set TX FIFO level
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFIENA         = 1;                     // RX FIFO interrupt base on RXFFIL will be enabled.
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFIENA         = 1;                     // TX FIFO interrupt base on RXFFIL will be enabled.
    (*SPIs[SPI_use]).SPIFFCT.bit.TXDLY            = delay;                        // SPI delay configuration (15-8 bits reserved, 7-0 bits are used to configure the transmit delay. 0 -> no delay)

    (*SPIs[SPI_use]).SPIFFTX.bit.TXFIFO           = 1;                      // Release transmit FIFO from reset run above
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFIFORESET      = 1;                 // Re-enable receive FIFO operation.

}
//...........................................DMA..........................................//
//
// dma_init - DMA setup for both TX and RX channels.
//
void dma_init(uint16_t *sData, uint16_t *rData,int BURST_TX, int BURST_RX, int TRANSFER)
{
    volatile Uint16     *DMADest;                                           // DMA destination
    volatile Uint16     *DMASource;                                         // DMA source

    //
    // Initialize DMA
    //
    DMAInitialize();

    DMASource   = (volatile Uint16 *)sData;
    DMADest     = (volatile Uint16 *)rData;

    //
    // configure DMACH5 for TX
    //
    DMACH5AddrConfig(&SpiaRegs.SPITXBUF,DMASource);
    DMACH5BurstConfig(BURST_TX,1,0);         // Burst size, src step, dest step
    DMACH5TransferConfig(TRANSFER,1,0);   // transfer size, src step, dest step
    DMACH5ModeConfig(DMA_SPIATX,PERINT_ENABLE,ONESHOT_DISABLE,CONT_DISABLE,
                     SYNC_DISABLE,SYNC_SRC,OVRFLOW_DISABLE,SIXTEEN_BIT,
                     CHINT_END,CHINT_ENABLE);

    //
    // configure DMA CH6 for RX
    //
    DMACH6AddrConfig(DMADest,&SpiaRegs.SPIRXBUF);
    DMACH6BurstConfig(BURST_RX,0,1);
    DMACH6TransferConfig(TRANSFER,0,1);
    DMACH6ModeConfig(DMA_SPIARX,PERINT_ENABLE,ONESHOT_DISABLE,CONT_DISABLE,
                     SYNC_DISABLE,SYNC_SRC,OVRFLOW_DISABLE,SIXTEEN_BIT,
                     CHINT_END,CHINT_ENABLE);
}

#ifdef CPU1
//...........................................GPIOs...............................................//
//
// LONGMAX relays control
//
// DC/DC side relay
//   1. precharge grid      ->      GPIO83
//   2. main grid           ->      GPIO81
//   1. precharge batt      ->      GPIO87
//   2. main batt           ->      GPIO89
void GPIO_relay_longmax() //These GPIOs are meant to be used for the relays. We set them to start as OFF and then, after meeting conditions, they go ON to drive the relays.
{
    EALLOW;

        GpioCtrlRegs.GPCPUD.bit.GPIO81 = 1;           //Enable pull-up on GPIO81
        GpioCtrlRegs.GPCGMUX2.bit.GPIO81 = 0;         // grid-side main relays
        GpioCtrlRegs.GPCMUX2.bit.GPIO81 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO81 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO81 = 1;         //  Start in off state

        GpioCtrlRegs.GPCPUD.bit.GPIO83 = 1;           //Enable pull-up on GPIO83
        GpioCtrlRegs.GPCGMUX2.bit.GPIO83 = 0;         // grid-side precharge relays
        GpioCtrlRegs.GPCMUX2.bit.GPIO83 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO83 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO83 = 1;         //  Start in off state

        GpioCtrlRegs.GPCPUD.bit.GPIO85 = 1;           //Enable pull-up on GPIO85
        GpioCtrlRegs.GPCGMUX2.bit.GPIO85 = 0;         // batt-side main relays
        GpioCtrlRegs.GPCMUX2.bit.GPIO85 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO85 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO85 = 1;         //  Start in off state

        GpioCtrlRegs.GPCPUD.bit.GPIO87 = 1;           //  Enable pull-up on GPIO87
        GpioCtrlRegs.GPCGMUX2.bit.GPIO87 = 0;         // batt-side precharge relays
        GpioCtrlRegs.GPCMUX2.bit.GPIO87 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO87 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO87 = 1;         //  Start in off state

   EDIS;
}

void GPIO_temp_meas_select_init()
{
    EALLOW;

        GpioCtrlRegs.GPCPUD.bit.GPIO91 = 1;           //Enable pull-up on GPIO91
        GpioCtrlRegs.GPCGMUX2.bit.GPIO91 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO91 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO91 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO91 = 1;         //  Start in off state

        GpioCtrlRegs.GPCPUD.bit.GPIO93 = 1;           //Enable pull-up on GPIO93
        GpioCtrlRegs.GPCGMUX2.bit.GPIO93 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO93 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO93 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCCLEAR.bit.GPIO93 = 1;         //  Start in off state

        GpioCtrlRegs.GPEPUD.bit.GPIO133 = 1;           //  Enable pull-up on GPIO133
        GpioCtrlRegs.GPEGMUX1.bit.GPIO133 = 0;
        GpioCtrlRegs.GPEMUX1.bit.GPIO133 = 0;
        GpioCtrlRegs.GPEDIR.bit.GPIO133 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPECLEAR.bit.GPIO133 = 1;         //  Start in off state

   EDIS;
}

void close_main_grid_relay() //call to close grid main relays
{
    EALLOW;
        GpioDataRegs.GPCSET.bit.GPIO81 = 1; // set the bit, close the relay
    EDIS;
}
void close_precharge_grid_relay() //call to close grid precharge relays
{
    EALLOW;
        GpioDataRegs.GPCSET.bit.GPIO83 = 1; // set the bit, close the relay
    EDIS;
}
void close_main_batt_relay() //call to close batt main relays
{
    EALLOW;
        GpioDataRegs.GPCSET.bit.GPIO85 = 1; // set the bit, close the relay
    EDIS;
}
void close_precharge_batt_relay() //call to close batt precharge relays
{
    EALLOW;
        GpioDataRegs.GPCSET.bit.GPIO87 = 1; // set the bit, close the relay
    EDIS;
}
void open_main_grid_relay() //call to open grid main relays
{
    EALLOW;
        GpioDataRegs.GPCCLEAR.bit.GPIO81 = 1; // clear the bit, open the relay
    EDIS;
}
void open_precharge_grid_relay() //call to open grid precharge relays
{
    EALLOW;
        GpioDataRegs.GPCCLEAR.bit.GPIO83 = 1; // clear the bit, open the relay
    EDIS;
}
void open_main_batt_relay() //call to open batt main relays
{
    EALLOW;
        GpioDataRegs.GPCCLEAR.bit.GPIO85 = 1; // clear the bit, open the relay
    EDIS;
}
void open_precharge_batt_relay() //call to open batt precharge relays
{
    EALLOW;
        GpioDataRegs.GPCCLEAR.bit.GPIO87 = 1; // clear the bit, open the relay
    EDIS;
}

void gate_driver_DESAT_init()
{
    EALLOW;
        //A_upper
        GpioCtrlRegs.GPAPUD.bit.GPIO24 = 1;           //Enable pull-up on GPIO26
        GpioCtrlRegs.GPAGMUX2.bit.GPIO24 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO24 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO24 = 0;           //  digital input (0=input, 1=output)

        //A_lower
        GpioCtrlRegs.GPAPUD.bit.GPIO25 = 1;           //Enable pull-up on GPIO27
        GpioCtrlRegs.GPAGMUX2.bit.GPIO25 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO25 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO25 = 0;           //  digital input (0=input, 1=output)

        //B_upper
        GpioCtrlRegs.GPAPUD.bit.GPIO26 = 1;           //Enable pull-up on GPIO32
        GpioCtrlRegs.GPAGMUX2.bit.GPIO26 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO26 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO26 = 0;           //  digital input (0=input, 1=output)

        //B_lower
        GpioCtrlRegs.GPAPUD.bit.GPIO27 = 1;           //Enable pull-up on GPIO33
        GpioCtrlRegs.GPAGMUX2.bit.GPIO27 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO27 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO27 = 0;           //  digital input (0=input, 1=output)

        //C_upper
        GpioCtrlRegs.GPBPUD.bit.GPIO32 = 1;           //Enable pull-up on GPIO40
        GpioCtrlRegs.GPBGMUX1.bit.GPIO32 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO32 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO32 = 0;           //  digital input (0=input, 1=output)

        //C_lower
        GpioCtrlRegs.GPBPUD.bit.GPIO33 = 1;           //Enable pull-up on GPIO41
        GpioCtrlRegs.GPBGMUX1.bit.GPIO33 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO33 = 0;           //  digital input (0=input, 1=output)

        //D_upper
        GpioCtrlRegs.GPBPUD.bit.GPIO40 = 1;           //Enable pull-up on GPIO96
        GpioCtrlRegs.GPBGMUX1.bit.GPIO40 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO40 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO40 = 0;           //  digital input (0=input, 1=output)

        //D_lower
        GpioCtrlRegs.GPBPUD.bit.GPIO41 = 1;           //Enable pull-up on GPIO98
        GpioCtrlRegs.GPBGMUX1.bit.GPIO41 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO41 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO41 = 0;           //  digital input (0=input, 1=output)

        //E_upper
        GpioCtrlRegs.GPDPUD.bit.GPIO96 = 1;           //Enable pull-up on GPIO48
        GpioCtrlRegs.GPDGMUX1.bit.GPIO96 = 0;
        GpioCtrlRegs.GPDMUX1.bit.GPIO96 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO96 = 0;           //  digital input (0=input, 1=output)

        //E_lower
        GpioCtrlRegs.GPBPUD.bit.GPIO49 = 1;           //Enable pull-up on GPIO49
        GpioCtrlRegs.GPBGMUX2.bit.GPIO49 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO49 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO49 = 0;           //  digital input (0=input, 1=output)

        //F_upper
        GpioCtrlRegs.GPBPUD.bit.GPIO50 = 1;           //Enable pull-up on GPIO50
        GpioCtrlRegs.GPBGMUX2.bit.GPIO50 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO50 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO50 = 0;           //  digital input (0=input, 1=output)

        //F_lower
        GpioCtrlRegs.GPBPUD.bit.GPIO51 = 1;           //Enable pull-up on GPIO51
        GpioCtrlRegs.GPBGMUX2.bit.GPIO51 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO51 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO51 = 0;           //  digital input (0=input, 1=output)

    EDIS;
}

void gate_driver_EN_init(void)
{
    EALLOW;
        //A_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO70 = 1;           //Enable pull-up on GPIO70
        GpioCtrlRegs.GPCGMUX1.bit.GPIO70 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO70 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO70 = 1;           //  digital input (0=input, 1=output)

        //A_lower
        GpioCtrlRegs.GPCPUD.bit.GPIO74 = 1;           //Enable pull-up on GPIO72
        GpioCtrlRegs.GPCGMUX1.bit.GPIO74 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO74 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO74 = 1;           //  digital input (0=input, 1=output)

        //B_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO76 = 1;           //Enable pull-up on GPIO74
        GpioCtrlRegs.GPCGMUX1.bit.GPIO76 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO76 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO76 = 1;           //  digital input (0=input, 1=output)

        //B_lower
        GpioCtrlRegs.GPCPUD.bit.GPIO78 = 1;           //Enable pull-up on GPIO76
        GpioCtrlRegs.GPCGMUX1.bit.GPIO78 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO78 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO78 = 1;           //  digital input (0=input, 1=output)

        //C_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO80 = 1;           //Enable pull-up on GPIO78
        GpioCtrlRegs.GPCGMUX2.bit.GPIO80 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO80 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO80 = 1;           //  digital input (0=input, 1=output)

        //C_lower
        GpioCtrlRegs.GPCPUD.bit.GPIO82 = 1;           //Enable pull-up on GPIO80
        GpioCtrlRegs.GPCGMUX2.bit.GPIO82 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO82 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO82 = 1;           //  digital input (0=input, 1=output)

        //D_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO86 = 1;           //Enable pull-up on GPIO82
        GpioCtrlRegs.GPCGMUX2.bit.GPIO86 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO86 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO86 = 1;           //  digital input (0=input, 1=output)

        //D_lower
        GpioCtrlRegs.GPCPUD.bit.GPIO88 = 1;           //Enable pull-up on GPIO84
        GpioCtrlRegs.GPCGMUX2.bit.GPIO88 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO88 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO88 = 1;           //  digital input (0=input, 1=output)

        //E_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO90 = 1;           //Enable pull-up on GPIO86
        GpioCtrlRegs.GPCGMUX2.bit.GPIO90 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO90 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO90 = 1;           //  digital input (0=input, 1=output)

        //E_lower
        GpioCtrlRegs.GPCPUD.bit.GPIO92 = 1;           //Enable pull-up on GPIO86
        GpioCtrlRegs.GPCGMUX2.bit.GPIO92 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO92 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO92 = 1;           //  digital input (0=input, 1=output)

        //F_upper
        GpioCtrlRegs.GPCPUD.bit.GPIO94 = 1;           //Enable pull-up on GPIO90
        GpioCtrlRegs.GPCGMUX2.bit.GPIO94 = 0;
        GpioCtrlRegs.GPCMUX2.bit.GPIO94 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO94 = 1;           //  digital input (0=input, 1=output)

        //F_lower
        GpioCtrlRegs.GPDPUD.bit.GPIO120 = 1;           //Enable pull-up on GPIO92
        GpioCtrlRegs.GPDGMUX2.bit.GPIO120 = 0;
        GpioCtrlRegs.GPDMUX2.bit.GPIO120 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO120 = 1;           //  digital input (0=input, 1=output)
    EDIS;
}

void gate_driver_enable(void)
{
    EALLOW;
        //A upper
        GpioDataRegs.GPCCLEAR.bit.GPIO70 = 1; // set pin low

        //A lower
        GpioDataRegs.GPCCLEAR.bit.GPIO74 = 1; // set pin low

        //B upper
        GpioDataRegs.GPCCLEAR.bit.GPIO76 = 1; // set pin low

        //B lower
        GpioDataRegs.GPCCLEAR.bit.GPIO78 = 1; // set pin low

        //C upper
        GpioDataRegs.GPCCLEAR.bit.GPIO80 = 1; // set pin low

        //C lower
        GpioDataRegs.GPCCLEAR.bit.GPIO82 = 1; // set pin low

        //D upper
        GpioDataRegs.GPCCLEAR.bit.GPIO86 = 1; // set pin low

        //D lower
        GpioDataRegs.GPCCLEAR.bit.GPIO88 = 1; // set pin low

        //E upper
        GpioDataRegs.GPCCLEAR.bit.GPIO90 = 1; // set pin low

        //E lower
        GpioDataRegs.GPCCLEAR.bit.GPIO92 = 1; // set pin low

        //F upper
        GpioDataRegs.GPCCLEAR.bit.GPIO94 = 1; // set pin low

        //F lower
        GpioDataRegs.GPDCLEAR.bit.GPIO120 = 1; // set pin low
    EDIS;
}

void gate_driver_disable(void)
{
    EALLOW;
        //A upper
        GpioDataRegs.GPCSET.bit.GPIO70 = 1; // set pin high

        //A lower
        GpioDataRegs.GPCSET.bit.GPIO74 = 1; // set pin high

        //B upper
        GpioDataRegs.GPCSET.bit.GPIO76 = 1; // set pin high

        //B lower
        GpioDataRegs.GPCSET.bit.GPIO78 = 1; // set pin high

        //C upper
        GpioDataRegs.GPCSET.bit.GPIO80 = 1; // set pin high

        //C lower
        GpioDataRegs.GPCSET.bit.GPIO82 = 1; // set pin high

        //D upper
        GpioDataRegs.GPCSET.bit.GPIO86 = 1; // set pin high

        //D lower
        GpioDataRegs.GPCSET.bit.GPIO88 = 1; // set pin high

        //E upper
        GpioDataRegs.GPCSET.bit.GPIO90 = 1; // set pin high

        //E lower
        GpioDataRegs.GPCSET.bit.GPIO92 = 1; // set pin high

        //F upper
        GpioDataRegs.GPCSET.bit.GPIO94 = 1; // set pin high

        //F lower
        GpioDataRegs.GPDSET.bit.GPIO120 = 1; // set pin high
    EDIS;
}

void gate_driver_RST_init(void) //initialize RST pin high, RST is active low
{
    EALLOW;
        //A upper
        GpioCtrlRegs.GPBPUD.bit.GPIO36 = 1;           //Enable pull-up on GPIO36
        GpioCtrlRegs.GPBGMUX1.bit.GPIO36 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO36 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO36 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPBSET.bit.GPIO36 = 1;         //  Start in high state

        //A lower
        GpioCtrlRegs.GPBPUD.bit.GPIO38 = 1;           //Enable pull-up on GPIO38
        GpioCtrlRegs.GPBGMUX1.bit.GPIO38 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO38 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO38 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPBSET.bit.GPIO38 = 1;         //  Start in high state

        //B upper
        GpioCtrlRegs.GPBPUD.bit.GPIO61 = 1;           //Enable pull-up on GPIO61
        GpioCtrlRegs.GPBGMUX2.bit.GPIO61 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO61 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO61 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPBSET.bit.GPIO61 = 1;         //  Start in high state

        //B lower
        GpioCtrlRegs.GPBPUD.bit.GPIO63 = 1;           //Enable pull-up on GPIO63
        GpioCtrlRegs.GPBGMUX2.bit.GPIO63 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO63 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO63 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPBSET.bit.GPIO63 = 1;         //  Start in high state

        //C upper
        GpioCtrlRegs.GPCPUD.bit.GPIO65 = 1;           //Enable pull-up on GPIO65
        GpioCtrlRegs.GPCGMUX1.bit.GPIO65 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO65 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO65 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO65 = 1;         //  Start in high state

        //C lower
        GpioCtrlRegs.GPCPUD.bit.GPIO67 = 1;           //Enable pull-up on GPIO67
        GpioCtrlRegs.GPCGMUX1.bit.GPIO67 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO67 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO67 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO67 = 1;         //  Start in high state

        //D upper
        GpioCtrlRegs.GPCPUD.bit.GPIO69 = 1;           //Enable pull-up on GPIO69
        GpioCtrlRegs.GPCGMUX1.bit.GPIO69 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO69 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO69 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO69 = 1;         //  Start in high state

        //D lower
        GpioCtrlRegs.GPCPUD.bit.GPIO71 = 1;           //Enable pull-up on GPIO71
        GpioCtrlRegs.GPCGMUX1.bit.GPIO71 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO71 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO71 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO71 = 1;         //  Start in high state

        //E upper
        GpioCtrlRegs.GPCPUD.bit.GPIO73 = 1;           //Enable pull-up on GPIO73
        GpioCtrlRegs.GPCGMUX1.bit.GPIO73 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO73 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO73 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO73 = 1;         //  Start in high state

        //E lower
        GpioCtrlRegs.GPDPUD.bit.GPIO126 = 1;           //Enable pull-up on GPIO126
        GpioCtrlRegs.GPDGMUX2.bit.GPIO126 = 0;
        GpioCtrlRegs.GPDMUX2.bit.GPIO126 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO126 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPDSET.bit.GPIO126 = 1;         //  Start in high state

        //F upper
        GpioCtrlRegs.GPCPUD.bit.GPIO77 = 1;           //Enable pull-up on GPIO77
        GpioCtrlRegs.GPCGMUX1.bit.GPIO77 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO77 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO77 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO77 = 1;         //  Start in high state

        //F lower
        GpioCtrlRegs.GPCPUD.bit.GPIO79 = 1;           //Enable pull-up on GPIO79
        GpioCtrlRegs.GPCGMUX1.bit.GPIO79 = 0;
        GpioCtrlRegs.GPCMUX1.bit.GPIO79 = 0;
        GpioCtrlRegs.GPCDIR.bit.GPIO79 = 1;           //  digital output (0=input, 1=output)
        GpioDataRegs.GPCSET.bit.GPIO79 = 1;         //  Start in high state
    EDIS;
}

void gate_driver_RST_low(void)
{
    EALLOW;
        GpioDataRegs.GPBCLEAR.bit.GPIO36 = 1;
        GpioDataRegs.GPBCLEAR.bit.GPIO38 = 1;
        GpioDataRegs.GPBCLEAR.bit.GPIO61 = 1;
        GpioDataRegs.GPBCLEAR.bit.GPIO63 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO65 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO67 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO69 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO71 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO73 = 1;
        GpioDataRegs.GPDCLEAR.bit.GPIO126 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO77 = 1;
        GpioDataRegs.GPCCLEAR.bit.GPIO79 = 1;
    EDIS;
}

void gate_driver_RST_high(void)
{
    EALLOW;
        GpioDataRegs.GPBSET.bit.GPIO36 = 1;
        GpioDataRegs.GPBSET.bit.GPIO38 = 1;
        GpioDataRegs.GPBSET.bit.GPIO61 = 1;
        GpioDataRegs.GPBSET.bit.GPIO63 = 1;
        GpioDataRegs.GPCSET.bit.GPIO65 = 1;
        GpioDataRegs.GPCSET.bit.GPIO67 = 1;
        GpioDataRegs.GPCSET.bit.GPIO69 = 1;
        GpioDataRegs.GPCSET.bit.GPIO71 = 1;
        GpioDataRegs.GPCSET.bit.GPIO73 = 1;
        GpioDataRegs.GPDSET.bit.GPIO126 = 1;
        GpioDataRegs.GPCSET.bit.GPIO77 = 1;
        GpioDataRegs.GPCSET.bit.GPIO79 = 1;
    EDIS;
}

void gate_driver_RDY_init(void)
{
    EALLOW;
        //A upper
        GpioCtrlRegs.GPAPUD.bit.GPIO22 = 1;           //Enable pull-up on GPIO34
        GpioCtrlRegs.GPAGMUX2.bit.GPIO22 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO22 = 0;           //  digital input (0=input, 1=output)

        //A lower
        GpioCtrlRegs.GPAPUD.bit.GPIO23 = 1;           //Enable pull-up on GPIO39
        GpioCtrlRegs.GPAGMUX2.bit.GPIO23 = 0;
        GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 0;
        GpioCtrlRegs.GPADIR.bit.GPIO23 = 0;           //  digital input (0=input, 1=output)

        //B upper
        GpioCtrlRegs.GPBPUD.bit.GPIO34 = 1;           //Enable pull-up on GPIO125
        GpioCtrlRegs.GPBGMUX1.bit.GPIO34 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO34 = 0;           //  digital input (0=input, 1=output)

        //B lower
        GpioCtrlRegs.GPBPUD.bit.GPIO39 = 1;           //Enable pull-up on GPIO45
        GpioCtrlRegs.GPBGMUX1.bit.GPIO39 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO39 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO39 = 0;           //  digital input (0=input, 1=output)

        //C upper
        GpioCtrlRegs.GPDPUD.bit.GPIO125 = 1;           //Enable pull-up on GPIO97
        GpioCtrlRegs.GPDGMUX2.bit.GPIO125 = 0;
        GpioCtrlRegs.GPDMUX2.bit.GPIO125 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO125 = 0;           //  digital input (0=input, 1=output)

        //C lower
        GpioCtrlRegs.GPBPUD.bit.GPIO45 = 1;           //Enable pull-up on GPIO99
        GpioCtrlRegs.GPBGMUX1.bit.GPIO45 = 0;
        GpioCtrlRegs.GPBMUX1.bit.GPIO45 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO45 = 0;           //  digital input (0=input, 1=output)

        //D upper
        GpioCtrlRegs.GPDPUD.bit.GPIO97 = 1;           //Enable pull-up on GPIO54
        GpioCtrlRegs.GPDGMUX1.bit.GPIO97 = 0;
        GpioCtrlRegs.GPDMUX1.bit.GPIO97 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO97 = 0;           //  digital input (0=input, 1=output)

        //D lower
        GpioCtrlRegs.GPDPUD.bit.GPIO99 = 1;           //Enable pull-up on GPIO55
        GpioCtrlRegs.GPDGMUX1.bit.GPIO99 = 0;
        GpioCtrlRegs.GPDMUX1.bit.GPIO99 = 0;
        GpioCtrlRegs.GPDDIR.bit.GPIO99 = 0;           //  digital input (0=input, 1=output)

        //E upper
        GpioCtrlRegs.GPBPUD.bit.GPIO58 = 1;           //Enable pull-up on GPIO56
        GpioCtrlRegs.GPBGMUX2.bit.GPIO58 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO58 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO58 = 0;           //  digital input (0=input, 1=output)

        //E lower
        GpioCtrlRegs.GPBPUD.bit.GPIO59 = 1;           //Enable pull-up on GPIO57
        GpioCtrlRegs.GPBGMUX2.bit.GPIO59 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO59 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO59 = 0;           //  digital input (0=input, 1=output)

        //F upper
        GpioCtrlRegs.GPBPUD.bit.GPIO52 = 1;           //Enable pull-up on GPIO58
        GpioCtrlRegs.GPBGMUX2.bit.GPIO52 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO52 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO52 = 0;           //  digital input (0=input, 1=output)

        //F lower
        GpioCtrlRegs.GPBPUD.bit.GPIO53 = 1;           //Enable pull-up on GPIO59
        GpioCtrlRegs.GPBGMUX2.bit.GPIO53 = 0;
        GpioCtrlRegs.GPBMUX2.bit.GPIO53 = 0;
        GpioCtrlRegs.GPBDIR.bit.GPIO53 = 0;           //  digital input (0=input, 1=output)
    EDIS;
}

int max_temp(int value1, int value2, int value3)
{
    if (value1 > value2 && value1 > value3)
    {
        max_temp_value = value1;
    }
    else if (value2 > value1 && value2 > value3)
    {
        max_temp_value = value2;
    }
    else if (value3 > value1 && value3 > value2)
    {
        max_temp_value = value3;
    }
    return max_temp_value;
}

void error (void)
{
    ESTOP0;         // Stop here and handle error
}
#endif
