/*
 * Function_define_Longmax_28379D.c
 *
 *  Created on: Dec 2, 2019
 *      Author: weizhong
 */



#include "F28x_Project.h"
#include "Function_define_Longmax_28379D.h"
//#include "IPC_struct.h"
//#include "math.h"
//#include "F2837xS_device.h"
//#include "F2837xS_Examples.h"
//#include "Variable_define_WW_HFB.h"
//
// Calculate BRR: 7-bit baud rate register value
// SPI CLK freq = 500 kHz
// LSPCLK freq  = CPU freq / 4  (by default)
// BRR          = (LSPCLK freq / SPI CLK freq) - 1
//





//......................... Global variables for debugging ............
Uint16 CMPA_reg_val;
Uint16 CMPAHR_reg_val;
Uint32 temp_CMPA;
Uint16 TBPHS_reg_val;
Uint16 TBPHSHR_reg_val;
Uint32 temp_TBPHS;

// ........ Timer ...........//
Uint32 cpuTime  = 0;                                                          // The time difference between point 1 and 2
float cpuTime_us  = 0;                                                      // The time difference between point 1 and 2 in us
Uint32 cpuTime1 = 0;                                                          // Starting point of the timer
Uint32 cpuTime2 = 0;                                                          // End point of the timer

//........  IPC .............//
struct readIPC{                                                               // structure for read IPC function
    Uint32 command;
    Uint32 address;
    Uint32 data;
};
/////////////TEST FUNCTIONS//////////////


///////////////////////////////////////////////////////////////////////////////////
//////////////////////// General purpose functions////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//............................... IPC related ..................................//

/* define read IPC command. TI didn't provide the read command in Ipc.c */
struct readIPC ReadIpcCommand(void)
{
    struct readIPC ret;

    ret.command = IpcRegs.IPCRECVCOM;
    ret.address = IpcRegs.IPCRECVADDR;
    ret.data    = IpcRegs.IPCRECVDATA;

    return ret;


}
//............................... Timer setup ..................................//
void StartTimer(void)
{


    EALLOW;
    CpuTimer2Regs.TCR.bit.TRB = 1;        // Reset CPU timer to period value
    CpuTimer2Regs.TCR.bit.TSS = 0;        // Start or reset CPU timer 2
    cpuTime1 = CpuTimer2Regs.TIM.all;     // Get value of CPU Timer 2 before code
    EDIS;
}

float StopTimer(void)
{

    EALLOW;
    cpuTime2 = CpuTimer2Regs.TIM.all;    // Get value of CPU Timer 2 after code
    cpuTime = cpuTime1 - cpuTime2;     // Calculate time using cpuTimer2
    cpuTime_us = cpuTime * 5.0 / 1000.0;   // Calculate the time from StartTimer to StopTimer in us (5ns is the period of the timer)
    CpuTimer2Regs.TCR.bit.TSS = 1;        // Start or reset CPU timer 2
    EDIS;
    return cpuTime_us;
}



//............................... SPI...........................................//
void Initspi(unsigned int SPI_use, int master_slave, int loop_back, int cpol,int cpha, int word_bit)
{
    // Initialize SPI-B

    // Set reset low before configuration changes
    // Clock polarity (0 == rising, 1 == falling)
    // 16-bit character
    // Enable loop-back (*SPIs[SPI_use])
    (*SPIs[SPI_use]).SPICCR.bit.SPISWRESET = 0;
    (*SPIs[SPI_use]).SPICCR.bit.CLKPOLARITY = cpol;
    (*SPIs[SPI_use]).SPICCR.bit.SPICHAR = (word_bit-1);
    (*SPIs[SPI_use]).SPICCR.bit.SPILBK = loop_back;

    // Enable master (0 == slave, 1 == master)
    // Enable transmission (Talk)
    // Clock phase (0 == normal, 1 == delayed)
    // SPI interrupts are disabled
    (*SPIs[SPI_use]).SPICTL.bit.MASTER_SLAVE = master_slave;
    (*SPIs[SPI_use]).SPICTL.bit.TALK = 1;
    (*SPIs[SPI_use]).SPICTL.bit.CLK_PHASE = cpha;
    (*SPIs[SPI_use]).SPICTL.bit.SPIINTENA = 0;

    // Set the baud rate
    (*SPIs[SPI_use]).SPIBRR.bit.SPI_BIT_RATE = SPI_BRR;

    // Set FREE bit
    // Halting on a breakpoint will not halt the SPI
    (*SPIs[SPI_use]).SPIPRI.bit.FREE = 1;

    // Release the SPI from reset
    (*SPIs[SPI_use]).SPICCR.bit.SPISWRESET = 1;
    // Clear INT
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFINTCLR=1;                                  // Clear Interrupt flag for TX
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFINTCLR=1;                                  // Clear Interrupt flag

    /*
    // Overwrite the default settings in InitSpi()
    (*SPIs[SPI_use]).SPICCR.bit.SPICHAR         = (wrd_bit-1);              // word length
    (*SPIs[SPI_use]).SPICCR.bit.SPILBK          = 0;                        // Disable loopback
    (*SPIs[SPI_use]).SPICTL.bit.MASTER_SLAVE    = 0;                        // Choose SPIA as slave (1-master, 0-slave)

    (*SPIs[SPI_use]).SPIPRI.bit.SOFT            = 0;                        // Stop the transmittion whenever hits breakpoint
    (*SPIs[SPI_use]).SPIPRI.bit.FREE            = 1;                        // 1-free run even with breakpoint, 0-stop with SOFT mode
    */
}

//void Initspib(int master_slave, int loop_back, int cpol,int cpha, int word_bit)
//{
//    // Initialize SPI-B
//
//    // Set reset low before configuration changes
//    // Clock polarity (0 == rising, 1 == falling)
//    // 16-bit character
//    // Enable loop-back
//    SpibRegs.SPICCR.bit.SPISWRESET = 0;
//    SpibRegs.SPICCR.bit.CLKPOLARITY = cpol;
//    SpibRegs.SPICCR.bit.SPICHAR = (word_bit-1);
//    SpibRegs.SPICCR.bit.SPILBK = loop_back;
//
//    // Enable master (0 == slave, 1 == master)
//    // Enable transmission (Talk)
//    // Clock phase (0 == normal, 1 == delayed)
//    // SPI interrupts are disabled
//    SpibRegs.SPICTL.bit.MASTER_SLAVE = master_slave;
//    SpibRegs.SPICTL.bit.TALK = 1;
//    SpibRegs.SPICTL.bit.CLK_PHASE = cpha;
//    SpibRegs.SPICTL.bit.SPIINTENA = 0;
//
//    // Set the baud rate
//    SpibRegs.SPIBRR.bit.SPI_BIT_RATE = SPI_BRR;
//
//    // Set FREE bit
//    // Halting on a breakpoint will not halt the SPI
//    SpibRegs.SPIPRI.bit.FREE = 1;
//
//    // Release the SPI from reset
//    SpibRegs.SPICCR.bit.SPISWRESET = 1;
//    // Clear INT
//    SpibRegs.SPIFFTX.bit.TXFFINTCLR=1;                                  // Clear Interrupt flag for TX
//    SpibRegs.SPIFFRX.bit.RXFFINTCLR=1;                                  // Clear Interrupt flag
//
//    /*
//    // Overwrite the default settings in InitSpi()
//    SpibRegs.SPICCR.bit.SPICHAR         = (wrd_bit-1);              // word length
//    SpibRegs.SPICCR.bit.SPILBK          = 0;                        // Disable loopback
//    SpibRegs.SPICTL.bit.MASTER_SLAVE    = 0;                        // Choose SPIA as slave (1-master, 0-slave)
//
//    SpibRegs.SPIPRI.bit.SOFT            = 0;                        // Stop the transmittion whenever hits breakpoint
//    SpibRegs.SPIPRI.bit.FREE            = 1;                        // 1-free run even with breakpoint, 0-stop with SOFT mode
//    */
//}

/// ************ 28379D SPIA GPIO configuration ***********
#ifdef CPU1                 // GPIO can only be set by CPU 1 in TI code, CPU 2 won't get access to GPIOCTRLREGS (low level)
void InitspiaGpio(void)
{
    EALLOW;
       //
       // Enable internal pull-up for the selected pins
       //
       // Pull-ups can be enabled or disabled by the user.
       // This will enable the pullups for the specified pins.
       // Comment out other unwanted lines.
       //
       /*
        * The interface card V2 connected GPIO58-61 to SPIB
        * Note that there are other GPIOs that can be configured as SPIB, e.g. 22-24
        * Make sure correct GPIOs are configured
        */
       GpioCtrlRegs.GPBPUD.bit.GPIO58 = 0;  // Enable pull-up on GPIO58 (SPICLKB)
       GpioCtrlRegs.GPBPUD.bit.GPIO59 = 0;  // Enable pull-up on GPIO59 (SPISTEB)
       GpioCtrlRegs.GPBPUD.bit.GPIO60 = 0;  // Enable pull-up on GPIO60 (SPISIMOB)
       GpioCtrlRegs.GPBPUD.bit.GPIO61 = 0;  // Enable pull-up on GPIO61 (SPISOMIB)

//       GpioCtrlRegs.GPBPUD.bit.GPIO58 = 1;  // Enable pull-up on GPIO58 (SPICLKB)
//       GpioCtrlRegs.GPBPUD.bit.GPIO59 = 1;  // Enable pull-up on GPIO59 (SPISTEB)
//       GpioCtrlRegs.GPBPUD.bit.GPIO60 = 1;  // Enable pull-up on GPIO60 (SPISIMOB)
//       GpioCtrlRegs.GPBPUD.bit.GPIO61 = 1;  // Enable pull-up on GPIO61 (SPISOMIB)

       //
       // Set qualification for selected pins to asynch only
       //
       // This will select asynch (no qualification) for the selected pins.
       // Comment out other unwanted lines.
       //
       GpioCtrlRegs.GPBQSEL2.bit.GPIO58 = 3; // Asynch input GPIO58 (SPICLKB)
       GpioCtrlRegs.GPBQSEL2.bit.GPIO59 = 3; // Asynch input GPIO59 (SPISTEB)
       GpioCtrlRegs.GPBQSEL2.bit.GPIO60 = 3; // Asynch input GPIO60 (SPISIMOB)
       GpioCtrlRegs.GPBQSEL2.bit.GPIO61 = 3; // Asynch input GPIO61 (SPISOMIB)

       //
       //Configure SPI-B pins using GPIO regs
       //
       // This specifies which of the possible GPIO pins will be SPI functional
       // pins.
       // Comment out other unwanted lines.
       //
       /*
       * !!!To use SPI-B pins in GPIO 58-61
       * GPBGMUX is also needed to be configured. Please refer to Table 7-7 in TMS320F2837xS Delfino Microcontrollers Technical Reference Manual (Rev. F)
       */
       GpioCtrlRegs.GPBGMUX2.bit.GPIO58 = 3; // Configure GPIO58 as SPISIMOA
       GpioCtrlRegs.GPBGMUX2.bit.GPIO59 = 3; // Configure GPIO59 as SPISOMIB
       GpioCtrlRegs.GPBGMUX2.bit.GPIO60 = 3; // Configure GPIO60 as SPICLKB
       GpioCtrlRegs.GPBGMUX2.bit.GPIO61 = 3; // Configure GPIO61 as SPISTEB

       GpioCtrlRegs.GPBMUX2.bit.GPIO58 = 3; // Configure GPIO58 as SPISIMOB
       GpioCtrlRegs.GPBMUX2.bit.GPIO59 = 3; // Configure GPIO59 as SPISOMIB
       GpioCtrlRegs.GPBMUX2.bit.GPIO60 = 3; // Configure GPIO60 as SPICLKB
       GpioCtrlRegs.GPBMUX2.bit.GPIO61 = 3; // Configure GPIO61 as SPISTEB


   EDIS;
}

void InitspibGpio(void)
{
    EALLOW;

       //
       // Enable internal pull-up for the selected pins
       //
       // Pull-ups can be enabled or disabled by the user.
       // This will enable the pullups for the specified pins.
       // Comment out other unwanted lines.
       //
       /*
        * The interface card V2 connected GPIO58-61 to SPIB
        * Note that there are other GPIOs that can be configured as SPIB, e.g. 22-24
        * Make sure correct GPIOs are configured
        */
       GpioCtrlRegs.GPBPUD.bit.GPIO63 = 0;  // Enable pull-up on GPIO58 (SPICLKB)
       GpioCtrlRegs.GPCPUD.bit.GPIO64 = 0;  // Enable pull-up on GPIO59 (SPISTEB)
       GpioCtrlRegs.GPCPUD.bit.GPIO65 = 0;  // Enable pull-up on GPIO60 (SPISIMOB)
       GpioCtrlRegs.GPCPUD.bit.GPIO66 = 0;  // Enable pull-up on GPIO61 (SPISOMIB)

       //
       // Set qualification for selected pins to asynch only
       //
       // This will select asynch (no qualification) for the selected pins.
       // Comment out other unwanted lines.
       //
       GpioCtrlRegs.GPBQSEL2.bit.GPIO63 = 3; // Asynch input GPIO58 (SPICLKB)
       GpioCtrlRegs.GPCQSEL1.bit.GPIO64 = 3; // Asynch input GPIO59 (SPISTEB)
       GpioCtrlRegs.GPCQSEL1.bit.GPIO65 = 3; // Asynch input GPIO60 (SPISIMOB)
       GpioCtrlRegs.GPCQSEL1.bit.GPIO66 = 3; // Asynch input GPIO61 (SPISOMIB)

       //
       //Configure SPI-B pins using GPIO regs
       //
       // This specifies which of the possible GPIO pins will be SPI functional
       // pins.
       // Comment out other unwanted lines.
       //
       /*
       * !!!To use SPI-B pins in GPIO 58-61
       * GPBGMUX is also needed to be configured. Please refer to Table 7-7 in TMS320F2837xS Delfino Microcontrollers Technical Reference Manual (Rev. F)
       */
       GpioCtrlRegs.GPBGMUX2.bit.GPIO63 = 3; // Configure GPIO58 as SPISIMOB
       GpioCtrlRegs.GPCGMUX1.bit.GPIO64 = 3; // Configure GPIO59 as SPISOMIB
       GpioCtrlRegs.GPCGMUX1.bit.GPIO65 = 3; // Configure GPIO60 as SPICLKB
       GpioCtrlRegs.GPCGMUX1.bit.GPIO66 = 3; // Configure GPIO61 as SPISTEB

       GpioCtrlRegs.GPBMUX2.bit.GPIO63 = 3; // Configure GPIO58 as SPISIMOB
       GpioCtrlRegs.GPCMUX1.bit.GPIO64 = 3; // Configure GPIO59 as SPISOMIB
       GpioCtrlRegs.GPCMUX1.bit.GPIO65 = 3; // Configure GPIO60 as SPICLKB
       GpioCtrlRegs.GPCMUX1.bit.GPIO66 = 3; // Configure GPIO61 as SPISTEB


   EDIS;
}
#endif


//......................................................DAC.........................//
//
// ConfigureDAC - Configure specified DAC output
//
void ConfigureDAC(Uint16 dac_num)
{
    EALLOW;
    DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;
    DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;
    DAC_PTR[dac_num]->DACVALS.all = 0;
    DELAY_US(10); // Delay for buffered DAC to power up
    EDIS;
}

//
// spia_fifo_init - Initialize SPI FIFO
//
void spi_fifo_init(unsigned int SPI_use,int FIFO_RXLVL, int FIFO_TXLVL,int delay)                                    // Initialize SPI FIFO registers
{

//    (*SPIs[SPI_use]).SPIFFTX.all = 0xC020;                      // Enable FIFOs
//    (*SPIs[SPI_use]).SPIFFRX.all = 0x0020;                      // Set RX FIFO level to 6 (0x002 ->6<-)
//
//    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFIL = FIFO_RXLVL;           // Set RX FIFO level��it means whenever all the data are transmitted, the interrupt will trigger and update the transmitting data
//    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFIL = FIFO_TXLVL;           // Set TX FIFO level
//    (*SPIs[SPI_use]).SPIFFCT.bit.TXDLY = delay;                        // SPI delay configuration (15-8 bits reserved, 7-0 bits are used to configure the transmit delay. 0 -> no delay)
//
//    (*SPIs[SPI_use]).SPIFFTX.bit.TXFIFO=1;                      // Release transmit FIFO from reset run above
//    (*SPIs[SPI_use]).SPIFFRX.bit.RXFIFORESET=1;                 // Re-enable receive FIFO operation.
//
//    InitSpi();
//    /* Overwrite the default settings in InitSpi() */
//    (*SPIs[SPI_use]).SPICCR.bit.SPICHAR         = (wrd_bit-1);              // word length
//    (*SPIs[SPI_use]).SPICCR.bit.SPILBK          = 0;                        // Disable loopback
//    (*SPIs[SPI_use]).SPICTL.bit.MASTER_SLAVE    = 0;                        // Choose SPIA as slave (1-master, 0-slave)
//
//    (*SPIs[SPI_use]).SPIPRI.bit.SOFT            = 0;                        // Stop the transmittion whenever hits breakpoint
//    (*SPIs[SPI_use]).SPIPRI.bit.FREE            = 0;                        // 1-free run even with breakpoint, 0-stop with SOFT mode


    (*SPIs[SPI_use]).SPIFFTX.all                  = 0xC020;                      // Enable FIFOs
    (*SPIs[SPI_use]).SPIFFRX.all                  = 0x0020;                      // Set RX FIFO level to 6 (0x002 ->6<-)



    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFIL           = FIFO_RXLVL;           // Set RX FIFO level��it means whenever all the data are transmitted, the interrupt will trigger and update the transmitting data
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFIL           = FIFO_TXLVL;           // Set TX FIFO level
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFFIENA         = 1;                     // RX FIFO interrupt base on RXFFIL will be enabled.
    (*SPIs[SPI_use]).SPIFFTX.bit.TXFFIENA         = 1;                     // TX FIFO interrupt base on RXFFIL will be enabled.
    (*SPIs[SPI_use]).SPIFFCT.bit.TXDLY            = delay;                        // SPI delay configuration (15-8 bits reserved, 7-0 bits are used to configure the transmit delay. 0 -> no delay)

    (*SPIs[SPI_use]).SPIFFTX.bit.TXFIFO           = 1;                      // Release transmit FIFO from reset run above
    (*SPIs[SPI_use]).SPIFFRX.bit.RXFIFORESET      = 1;                 // Re-enable receive FIFO operation.

}

//
// spib_fifo_init - Initialize SPI FIFO
//
//void spib_fifo_init(int FIFO_RXLVL, int FIFO_TXLVL, int wrd_bit,int delay)                                    // Initialize SPI FIFO registers
//{
//
//    SpibRegs.SPIFFTX.all = 0xC020;                      // Enable FIFOs
//    SpibRegs.SPIFFRX.all = 0x0020;                      // Set RX FIFO level to 6 (0x002 ->6<-)
//
//    SpibRegs.SPIFFRX.bit.RXFFIL = FIFO_RXLVL;           // Set RX FIFO level��it means whenever all the data are transmitted, the interrupt will trigger and update the transmitting data
//    SpibRegs.SPIFFTX.bit.TXFFIL = FIFO_TXLVL;           // Set TX FIFO level
//    SpibRegs.SPIFFCT.bit.TXDLY = delay;                        // SPI delay configuration (15-8 bits reserved, 7-0 bits are used to configure the transmit delay. 0 -> no delay)
//
//    SpibRegs.SPIFFTX.bit.TXFIFO=1;                      // Release transmit FIFO from reset run above
//    SpibRegs.SPIFFRX.bit.RXFIFORESET=1;                 // Re-enable receive FIFO operation.
//
//}


//...........................................DMA..........................................//
//
// dma_init - DMA setup for both TX and RX channels.
//
void dma_init(uint16_t *sData, uint16_t *rData,int BURST_TX, int BURST_RX, int TRANSFER)
{
    volatile Uint16     *DMADest;                                           // DMA destination
    volatile Uint16     *DMASource;                                         // DMA source

    //
    // Initialize DMA
    //
    DMAInitialize();

    DMASource   = (volatile Uint16 *)sData;
    DMADest     = (volatile Uint16 *)rData;

    //
    // configure DMACH5 for TX
    //
    DMACH5AddrConfig(&SpiaRegs.SPITXBUF,DMASource);
    DMACH5BurstConfig(BURST_TX,1,0);         // Burst size, src step, dest step
    DMACH5TransferConfig(TRANSFER,1,0);   // transfer size, src step, dest step
    DMACH5ModeConfig(DMA_SPIATX,PERINT_ENABLE,ONESHOT_DISABLE,CONT_DISABLE,
                     SYNC_DISABLE,SYNC_SRC,OVRFLOW_DISABLE,SIXTEEN_BIT,
                     CHINT_END,CHINT_ENABLE);

    //
    // configure DMA CH6 for RX
    //
    DMACH6AddrConfig(DMADest,&SpiaRegs.SPIRXBUF);
    DMACH6BurstConfig(BURST_RX,0,1);
    DMACH6TransferConfig(TRANSFER,0,1);
    DMACH6ModeConfig(DMA_SPIARX,PERINT_ENABLE,ONESHOT_DISABLE,CONT_DISABLE,
                     SYNC_DISABLE,SYNC_SRC,OVRFLOW_DISABLE,SIXTEEN_BIT,
                     CHINT_END,CHINT_ENABLE);
}

#ifdef CPU1
//...........................................GPIOs...............................................//
//
// LONGMAX relays control
//
void GPIO_relay_longmax()
{
    EALLOW;
    //These GPIOs are meant to be used for the relays. We set them to start as OFF and then, after meeting conditions, they go ON to drive the relays.
          GpioCtrlRegs.GPAPUD.bit.GPIO22 = 1; //Enable pull-up on GPIO59
          //GPIO59 is a digital I/O pin
          GpioCtrlRegs.GPAGMUX2.bit.GPIO22 = 0;                                             // Phase A relay
          GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 0;
          GpioCtrlRegs.GPADIR.bit.GPIO22 = 1; //GPIO59 is a digital output (0=input, 1=output)
          GpioDataRegs.GPACLEAR.bit.GPIO22 = 1; //Start in off state

          GpioCtrlRegs.GPAPUD.bit.GPIO11 = 1; //Enable pull-up on GPIO60                    // Phase C relay
          //GPIO60 is a digital I/O pin
          GpioCtrlRegs.GPAGMUX1.bit.GPIO11 = 0;
          GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 0;
          GpioCtrlRegs.GPADIR.bit.GPIO11 = 1; //GPIO60 is a digital output (0=input, 1=output)
          GpioDataRegs.GPACLEAR.bit.GPIO11 = 1; //Start in off state

          GpioCtrlRegs.GPAPUD.bit.GPIO10 = 1; //Enable pull-up on GPIO61                    // Phase B relay
          //GPIO61 is a digital I/O pin
          GpioCtrlRegs.GPAGMUX1.bit.GPIO10 = 0;
          GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 0;
          GpioCtrlRegs.GPADIR.bit.GPIO10 = 1; //GPIO61 is a digital output (0=input, 1=output)
          GpioDataRegs.GPACLEAR.bit.GPIO10 = 1; //Start in off state
   EDIS;
}

void close_relay()
{
    EALLOW;
        GpioDataRegs.GPASET.bit.GPIO22 = 1; // set the bit, close the relay
        GpioDataRegs.GPASET.bit.GPIO11 = 1; // set the bit, close the relay
        GpioDataRegs.GPASET.bit.GPIO10 = 1; // set the bit, close the relay

    EDIS;
}

void open_relay()
{
    EALLOW;
        GpioDataRegs.GPACLEAR.bit.GPIO22 = 1; // clear the bit, open the relay
        GpioDataRegs.GPACLEAR.bit.GPIO11 = 1; // clear the bit, open the relay
        GpioDataRegs.GPACLEAR.bit.GPIO10 = 1; // clear the bit, open the relay

    EDIS;
}
//
// Longmax signal communication between AC/DC and DC/DC, the relay control
void GPIO_signalcomm_longmax()
{

    EALLOW;
       //These GPIOs are used for inputs and outputs to the AC/DC system to signal conditions: car attached/detached, DC/DC ready, AC/DC ready
       GpioCtrlRegs.GPAPUD.bit.GPIO17 = 0; //Enable pull-up on GPIO17
       //GPIO17 is a digital I/O pin
       GpioCtrlRegs.GPAGMUX2.bit.GPIO17 = 0;
       GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 0;
       GpioCtrlRegs.GPADIR.bit.GPIO17 = 1; //GPIO17 is a digital input (0=input, 1=output)
       GpioDataRegs.GPACLEAR.bit.GPIO17 = 1; //Start in off state

       GpioCtrlRegs.GPAPUD.bit.GPIO16 = 0; //Enable pull-up on GPIO16
       //GPIO16 is a digital I/O pin
       GpioCtrlRegs.GPAGMUX2.bit.GPIO16 = 0;
       GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 0;
       GpioCtrlRegs.GPADIR.bit.GPIO16 = 0; //GPIO16 is a digital input (0=input, 1=output)
       GpioDataRegs.GPACLEAR.bit.GPIO16 = 1; //Start in off state

       GpioCtrlRegs.GPAPUD.bit.GPIO18 = 1; //Enable pull-up on GPIO18
       //GPIO18 is a digital I/O pin
       GpioCtrlRegs.GPAGMUX2.bit.GPIO18 = 0;
       GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 0;
       GpioCtrlRegs.GPADIR.bit.GPIO18 = 1; //GPIO18 is a digital output (0=input, 1=output)
       GpioDataRegs.GPACLEAR.bit.GPIO18 = 1; //Start in off state

    //GPIO17 is the car DEtached input (0 = attached, 1 = detached)
    //GPIO16 is the DC/DC ready input (0 = not ready, 1 = ready)
    //GPIO18 is the AC/DC ready output (0 = not ready, 1 = ready)
    EDIS;
}
//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}
#endif
