#include "F28x_Project.h"

//%%%%%%% ADC maping for 28379D %%%%%%%%%%%%%%%%%%%%
/*  Grid-side inductor currents  */
//I_ind_A           ->          ADCA2
//I_ind_B           ->          ADCB2
//I_ind_C           ->          ADCC2
/*  Batt-side inductor currents  */
//I_ind_D           ->          ADCC5
//I_ind_E           ->          ADCA5
//I_ind_F           ->          ADCB5
/*  Grid-side output voltage  */
//Vo_A              ->          ADCA1
//Vo_B              ->          ADCB1
//Vo_C              ->          ADCC1
/*  Batt-side output voltages */
//Vo_D              ->          ADCC4
//Vo_E              ->          ADCA4
//Vo_F              ->          ADCB4
/*  Grid-side output current  */
//Io_A              ->          ADCA0
//Io_B              ->          ADCB0
//Io_C              ->          ADCC0
/*  Batt-side output current  */
//Io_D              ->          ADCC3
//Io_E              ->          ADCA3
//Io_F              ->          ADCB3
/*  DC Bus voltage  */
//V_DC              ->          ADCD0
/*  Temperature sensors  */
//TMP_in_1          ->          ADCD2
//TMP_in_2          ->          ADCD3
//TMP_in_3          ->          ADCD1
/*  Plug communication */
//CPread            ->          ADCD4
//PPread            ->          ADCD5

//%%%%%%%% END %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/* sample order:
SOC0:
    A2 I_ind_A
    B2 I_ind_B
    C2 I_ind_C
    D0 V_DC

SOC1:
    A5 I_ind_E
    B5 I_ind_F
    C5 I_ind_D
    D1 TMP_in_3

SOC2:
    A1 Vo_A
    B1 Vo_B
    C1 Vo_C
    D2 TMP_in_1

SOC3:
    A4 Vo_E
    B4 Vo_F
    C4 Vo_D
    D3 TMP_in_2

SOC4:
    A0 Io_A
    B0 Io_B
    C0 Io_C
    D4 CPread

SOC5
    A3 Io_E
    B3 Io_F
    C3 Io_D
    D5 PPread

*/

#ifdef CPU1
//..........................................ADC.......................................//
void ConfigureADC(int prescale, int SignalMode, int acq_window, int ADC_RESOLUTION,int ADC_trigger_src)
{
    EALLOW;
    //........................... ADC A .............................................//

    AdcaRegs.ADCCTL2.bit.PRESCALE = prescale;                   //set ADCCLK divider to /4 -> Maximal ADC clock is 50MHz
    AdcSetMode(ADC_ADCA, ADC_RESOLUTION, SignalMode);
    if (SignalMode == ADC_SIGNALMODE_SINGLE)
    {   //..............SOC 0 A2 (Phase A inductor current).................................................................
        AdcaRegs.ADCSOC0CTL.bit.CHSEL = 2;                      //SOC0 (converion sequence, 0->15) will convert pin ADCA5
        AdcaRegs.ADCSOC0CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        //  AdcaRegs.ADCINTSOCSEL1.bit.SOC0=01;                     // ADCINT1 will trigger SOC0
        AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
        //..............SOC 1 A5 (Phase E inductor current).................................................................
        AdcaRegs.ADCSOC1CTL.bit.CHSEL = 5;                      //SOC1 (converion sequence, 0->15) will convert pin ADCA4
        AdcaRegs.ADCSOC1CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
//      AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
        //..............SOC 2 A1 (Phase A output voltage)...................................................................
        AdcaRegs.ADCSOC2CTL.bit.CHSEL = 1;                      //SOC1 (converion sequence, 0->15) will convert pin ADCA4
        AdcaRegs.ADCSOC2CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
//      AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
        //..............SOC 3 A4 (Phase E output voltage)...................................................................
        AdcaRegs.ADCSOC3CTL.bit.CHSEL = 4;                      //SOC1 (converion sequence, 0->15) will convert pin ADCA4
        AdcaRegs.ADCSOC3CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
//      AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
/*
        //..............SOC 4 A0 (Phase A output current)...................................................................
        AdcaRegs.ADCSOC4CTL.bit.CHSEL = 0;                      //SOC1 (converion sequence, 0->15) will convert pin ADCA4
        AdcaRegs.ADCSOC4CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
//      AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
        //..............SOC 5 A3 (Phase E output current)...................................................................
        AdcaRegs.ADCSOC5CTL.bit.CHSEL = 3;                      //SOC2 (converion sequence, 0->15) will convert pin ADCA3
        AdcaRegs.ADCSOC5CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
//      AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0x04;                 // SOC2 trigger on XINT5
*/
        AdcaRegs.ADCINTSEL3N4.bit.INT4SEL = 3;                  //EOC5 will set INT4 flag

    }
    else
    {
        // we dont do differential mode so this code is never used and is most likely wrong
        AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;                      //SOC0 will convert pin A0 Pin 27
        AdcaRegs.ADCSOC0CTL.bit.ACQPS = 63;                     //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
        //  AdcaRegs.ADCINTSOCSEL1.bit.SOC0=01;                     // ADCINT1 will trigger SOC0
        AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // SOC0 trigger on ePWM7
        AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;                  //EOC0 will set INT2 flag
    }

    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 3; //EOC5 is trigger for interrupt
    AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0; // continuous mode off (flag has to be cleared before next interrupt is triggered)
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //make sure INT4 flag is cleared
    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1; //enable INT1 flag for ADCA

    AdcaRegs.ADCINTSEL3N4.bit.INT4E = 1;                        //enable INT4 flag for ADC A
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT4 = 1;                      //make sure INT4 flag is cleared
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;

    ///................................... ADC B.......................................//

    AdcbRegs.ADCCTL2.bit.PRESCALE = prescale; //set ADCCLK divider to /4 -> Maximal ADC clock is 50MHz
    AdcSetMode(ADC_ADCB, ADC_RESOLUTION, SignalMode);
    if (SignalMode == ADC_SIGNALMODE_SINGLE)
        {   //..............SOC 0 B2 (Phase B inductor current).................................................................
            AdcbRegs.ADCSOC0CTL.bit.CHSEL = 2;                      //SOC0 (converion sequence, 0->15) will convert pin ADCB5
            AdcbRegs.ADCSOC0CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdcbRegs.ADCINTSOCSEL1.bit.SOC0=01;                     // ADCINT1 will trigger SOC0
            AdcbRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
            //..............SOC 1 B5 (Phase F inductor current).................................................................
            AdcbRegs.ADCSOC1CTL.bit.CHSEL = 5;                      //SOC1 (converion sequence, 0->15) will convert pin ADCB4
            AdcbRegs.ADCSOC1CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcbRegs.ADCSOC1CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdcbRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 2 B1 (Phase B output voltage)...................................................................
            AdcbRegs.ADCSOC2CTL.bit.CHSEL = 1;                      //SOC1 (converion sequence, 0->15) will convert pin ADCB4
            AdcbRegs.ADCSOC2CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcbRegs.ADCSOC2CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
            //..............SOC 3 B4 (Phase F output voltage)...................................................................
            AdcbRegs.ADCSOC3CTL.bit.CHSEL = 4;                      //SOC1 (converion sequence, 0->15) will convert pin ADCB4
            AdcbRegs.ADCSOC3CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcbRegs.ADCSOC3CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
/*
            //..............SOC 4 B0 (Phase B output current)...................................................................
            AdcbRegs.ADCSOC4CTL.bit.CHSEL = 0;                      //SOC1 (converion sequence, 0->15) will convert pin ADCB4
            AdcbRegs.ADCSOC4CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcbRegs.ADCSOC4CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
            //..............SOC 5 B3 (Phase F output current)...................................................................
            AdcbRegs.ADCSOC5CTL.bit.CHSEL = 3;                      //SOC2 (converion sequence, 0->15) will convert pin ADCB3
            AdcbRegs.ADCSOC5CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcbRegs.ADCSOC5CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdcbRegs.ADCSOC2CTL.bit.TRIGSEL = 0x04;                 // SOC2 trigger on XINT5
*/
            AdcbRegs.ADCINTSEL3N4.bit.INT4SEL = 3;                  //EOC2 will set INT4 flag
        }
        else
        {
            // we dont do differential mode so this code is never used and is most likely wrong
            AdcbRegs.ADCSOC0CTL.bit.CHSEL = 0;                      //SOC0 will convert pin A0 Pin 27
            AdcbRegs.ADCSOC0CTL.bit.ACQPS = 63;                     //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdcaRegs.ADCINTSOCSEL1.bit.SOC0=01;                 // ADCINT1 will trigger SOC0
            AdcbRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // SOC0 trigger on ePWM7
            AdcbRegs.ADCINTSEL1N2.bit.INT1SEL = 0;                  //EOC0 will set INT2 flag
        }

//        AdcbRegs.ADCINTSEL1N2.bit.INT1SEL = 5; //EOC5 is trigger for interrupt
//        AdcbRegs.ADCINTSEL1N2.bit.INT1CONT = 0; // continuous mode off (flag has to be cleared before next interrupt is triggered)
//        AdcbRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //make sure INT4 flag is cleared
//        AdcbRegs.ADCINTSEL1N2.bit.INT1E = 1; //enable INT1 flag for ADCA

        AdcbRegs.ADCINTSEL3N4.bit.INT4E = 1;                        //enable INT4 flag for ADC B
        AdcbRegs.ADCINTFLGCLR.bit.ADCINT4 = 1;                      //make sure INT4 flag is cleared
        AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;
    ///................................... ADC C.......................................//
    
    AdccRegs.ADCCTL2.bit.PRESCALE = prescale; //set ADCCLK divider to /4 -> Maximal ADC clock is 50MHz
    AdcSetMode(ADC_ADCC, ADC_RESOLUTION, SignalMode);
    if (SignalMode == ADC_SIGNALMODE_SINGLE)
        {   //..............SOC 0 C2 (Phase C inductor current).................................................................
            AdccRegs.ADCSOC0CTL.bit.CHSEL = 2;                      //SOC0 (converion sequence, 0->15) will convert pin ADCC5
            AdccRegs.ADCSOC0CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdccRegs.ADCINTSOCSEL1.bit.SOC0=01;                     // ADCINT1 will trigger SOC0
            AdccRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
            //..............SOC 1 C5 (Phase D inductor current).................................................................
            AdccRegs.ADCSOC1CTL.bit.CHSEL = 5;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdccRegs.ADCSOC1CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdccRegs.ADCSOC1CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 2 C1 (Phase C output voltage)...................................................................
            AdccRegs.ADCSOC2CTL.bit.CHSEL = 15;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdccRegs.ADCSOC2CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdccRegs.ADCSOC2CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 3 C4 (Phase D output voltage)...................................................................
            AdccRegs.ADCSOC3CTL.bit.CHSEL = 4;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdccRegs.ADCSOC3CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdccRegs.ADCSOC3CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
/*
            //..............SOC 4 C0 (Phase C output current)...................................................................
            AdccRegs.ADCSOC4CTL.bit.CHSEL = 14;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdccRegs.ADCSOC4CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdccRegs.ADCSOC4CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 5 C3 (Phase D output current)...................................................................
            AdccRegs.ADCSOC5CTL.bit.CHSEL = 3;                      //SOC2 (converion sequence, 0->15) will convert pin ADCC3
            AdccRegs.ADCSOC5CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdccRegs.ADCSOC5CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC2CTL.bit.TRIGSEL = 0x04;                 // SOC2 trigger on XINT5
*/
            AdccRegs.ADCINTSEL3N4.bit.INT4SEL = 3;                  //EOC2 will set INT4 flag
        }
        else
        {
            // we dont do differential mode so this code is never used and is most likely wrong
            AdccRegs.ADCSOC0CTL.bit.CHSEL = 0;                      //SOC0 will convert pin A0 Pin 27
            AdccRegs.ADCSOC0CTL.bit.ACQPS = 63;                     //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdccRegs.ADCINTSOCSEL1.bit.SOC0=01;                 // ADCINT1 will trigger SOC0
            AdccRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // SOC0 trigger on ePWM7
            AdccRegs.ADCINTSEL1N2.bit.INT1SEL = 0;                  //EOC0 will set INT2 flag
        }

    AdccRegs.ADCINTSEL3N4.bit.INT4E = 1;   //enable INT2 flag
    AdccRegs.ADCINTFLGCLR.bit.ADCINT4 = 1; //make sure INT3 flag is cleared
    AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;


    ///................................... ADC D.......................................//

    AdcdRegs.ADCCTL2.bit.PRESCALE = prescale; //set ADCCLK divider to /4 -> Maximal ADC clock is 50MHz
    AdcSetMode(ADC_ADCD, ADC_RESOLUTION, SignalMode);
    if (SignalMode == ADC_SIGNALMODE_SINGLE)
        {   //..............SOC 0 D0 (DC bus voltage)...........................................................................
            AdcdRegs.ADCSOC0CTL.bit.CHSEL = 0;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdcdRegs.ADCSOC0CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcdRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 1 D1 (Temperature sensor 3).....................................................................
            AdcdRegs.ADCSOC1CTL.bit.CHSEL = 1;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdcdRegs.ADCSOC1CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcdRegs.ADCSOC1CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 2 D2 (Temperature sensor 1).....................................................................
            AdcdRegs.ADCSOC2CTL.bit.CHSEL = 2;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdcdRegs.ADCSOC2CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcdRegs.ADCSOC2CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 3 D3 (Temperature sensor 2).....................................................................
            AdcdRegs.ADCSOC3CTL.bit.CHSEL = 3;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdcdRegs.ADCSOC3CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcdRegs.ADCSOC3CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
/*
            //..............SOC 4 D4 (CP read)..................................................................................
            AdcdRegs.ADCSOC4CTL.bit.CHSEL = 4;                      //SOC1 (converion sequence, 0->15) will convert pin ADCC4
            AdcdRegs.ADCSOC4CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            AdcdRegs.ADCSOC4CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
    //      AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0x04;                 // SOC1 trigger on XINT5
            //..............SOC 5 D5 (PP read)...................................................................................
            AdcdRegs.ADCSOC5CTL.bit.CHSEL = 5;                      //SOC0 (converion sequence, 0->15) will convert pin ADCC5
            AdcdRegs.ADCSOC5CTL.bit.ACQPS = acq_window;             //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdcdRegs.ADCINTSOCSEL1.bit.SOC0=01;                     // ADCINT1 will trigger SOC0
            AdcdRegs.ADCSOC5CTL.bit.TRIGSEL = ADC_trigger_src;      // 00: SOC0 trigger on software, 11: ePWM7,ADCSOCA
*/
            AdcdRegs.ADCINTSEL3N4.bit.INT4SEL = 3;                  //EOC0 will set INT4 flag
        }
        else
        {
            AdcdRegs.ADCSOC0CTL.bit.CHSEL = 0;                      //SOC0 will convert pin A0 Pin 27
            AdcdRegs.ADCSOC0CTL.bit.ACQPS = 63;                     //sample window is 14*4 SYSCLK cycles for 12-bit = 0.28us
            //  AdcdRegs.ADCINTSOCSEL1.bit.SOC0=01;                 // ADCINT1 will trigger SOC0
            AdcdRegs.ADCSOC0CTL.bit.TRIGSEL = ADC_trigger_src;      // SOC0 trigger on ePWM7
            AdcdRegs.ADCINTSEL1N2.bit.INT1SEL = 0;                  //EOC0 will set INT2 flag
        }

//    AdcdRegs.ADCINTSEL1N2.bit.INT1SEL = 5; //EOC5 is trigger for interrupt
//    AdcdRegs.ADCINTSEL1N2.bit.INT1CONT = 0; // continuous mode off (flag has to be cleared before next interrupt is triggered)
//    AdcdRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;                      //make sure INT4 flag is cleared
//    AdcdRegs.ADCINTSEL1N2.bit.INT1E = 1; //enable INT1 flag for ADCA

    AdcdRegs.ADCINTSEL3N4.bit.INT4E = 1;   //enable INT2 flag
    AdcdRegs.ADCINTFLGCLR.bit.ADCINT4 = 1; //make sure INT3 flag is cleared
    AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;

    

    //
    // ADC Interrupt Pulse Position.
    // 0 Interrrupt pulse generation occurs at the end of the acquistion
    // window
    // 1 Interrupt pulse generation occurs at the end of the conversion, 1
    // cycle prior to the ADC result latching into its result register
    //

    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;  //power up the ADC
    AdcbRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    AdcdRegs.ADCCTL1.bit.ADCPWDNZ = 1;

    DELAY_US(2000); //delay for 2ms to allow ADC time to power up

    EDIS;
}
#endif
