#include <device.h>

/**
 * main.c
 */
int main(void)
{
    // Initialize clock and peripherals
    Device_init();

    // Initialize GPIO
    Device_initGPIO();

    GPIO_setMasterCore(40, GPIO_CORE_CPU1);
    GPIO_setPinConfig(GPIO_40_GPIO40);
    GPIO_setDirectionMode(40, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(40, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(40, GPIO_QUAL_ASYNC);

    while (1)
    {
        GPIO_togglePin(40);

        DEVICE_DELAY_US(3000U);
    }
}
