//	GpioInputCheck.c
//
//	Example program to debug apparent error in breakpoint execution in a DSS script.
//	Author:		Thomas Cox

#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

#include "F2837xD_device.h"
#include "F2837xD_GlobalPrototypes.h"
#include "gpio.h"
#include "pin_map.h"


bool GpioValues[2];

void GpioInit( void )
{

}
void SysInit( void )
{
    //	Initialize System Control:
    //	PLL, WatchDog, enable Peripheral Clocks
    //	This example function is found in the F2806x_SysCtrl.c file.
    InitSysCtrl();

    //	For this example, only initialize the GPIO pins to be used.
    GpioInit();

    // Disable CPU interrupts
    DINT;

    // Initialize PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the F2837xD_PieCtrl.c file.
    InitPieCtrl();

    // Disable CPU interrupts and clear all CPU interrupt flags
    IER = 0x0000;
    IFR = 0x0000;

    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2837xD_DefaultIsr.c.
    // This function is found in F2837xD_PieVect.c.
    InitPieVectTable();

    // Enable global Interrupts and higher priority real-time debug events:
    EINT;   // Enable Global interrupt INTM
    ERTM;   // Enable Global real-time interrupt DBGM
}

void ConfigureGpioPins( void )
{
	GPIO_setMasterCore( 52, GPIO_CORE_CPU1 );		//	Chose a RXB pin from pin mux in TRM
	GPIO_setPinConfig( GPIO_52_GPIO52 );
	GPIO_setDirectionMode( 52, GPIO_DIR_MODE_IN );
	GPIO_setPadConfig( 52, GPIO_PIN_TYPE_PULLUP );
	GPIO_setQualificationMode( 52, GPIO_QUAL_3SAMPLE );

	GPIO_setMasterCore( 67, GPIO_CORE_CPU1 );		//	Chose a RXB pin from pin mux in TRM
	GPIO_setPinConfig( GPIO_67_GPIO67 );
	GPIO_setDirectionMode( 67, GPIO_DIR_MODE_IN );
	GPIO_setPadConfig( 67, GPIO_PIN_TYPE_PULLUP );
	GPIO_setQualificationMode( 67, GPIO_QUAL_3SAMPLE );

}
void GetIdInputs( void )
{
	GpioValues[0] = GPIO_readPin( 52 );
	GpioValues[1] = GPIO_readPin( 67 );
}

bool CheckIdInputs( void )
{
	bool bGpioInputsAreValid = false;

	if( GpioValues[0] && !GpioValues[1] )
	{
	//	printf( "GPIO valid case 0." );
	    bGpioInputsAreValid = true;
		asm( "VALID_CASE_0:" );
	}
	else if( !GpioValues[0] && GpioValues[1] )
	{
	//	printf( "GPIO valid case 1." );
	    bGpioInputsAreValid = true;
		asm( "VALID_CASE_1:" );
	}
	else
	{
	//	printf( "Invalid GPIO input combination." )
		bGpioInputsAreValid = false;
		asm( "INVALID_GPIO_INPUTS:" );
	}

	return( bGpioInputsAreValid );
}
/**
 * main.c
 */
int main( void )
{
	SysInit();
	ConfigureGpioPins();
	GetIdInputs();
	CheckIdInputs();
	asm( "TEST_IS_DONE:" );
}
