//	TestScript4_20_1
//	SEU Self-Identification Check - SEU-9163

//	STATUS:
//	This test case consists only of logging breakpoints encountered during system initialization.
//	This script works, and breakpoint sequence and timing are documented in the script console log.
//	NOTE: On a LaunchXL-F28379D board, this script hits both the Exhaust and Inlet ID. DEBUG!


importPackage( Packages.com.ti.debug.engine.scripting );
importPackage( Packages.com.ti.ccstudio.scripting.environment );
importPackage( Packages.java.lang );
importPackage( Packages.java.io );
importPackage( Packages.java.math );

load( "./timeStamp.js" );
//load( "./targetReset.js" );
load( "./scriptSessionApp.js");
load( "./defineBreakpoint.js" );


var sBp1Label = "VALID_CASE_0";
var sBp2Label = "VALID_CASE_1";
var sBp3Label = "INVALID_GPIO_INPUTS";
var sBpEndLabel = "TEST_IS_DONE";

var breakPoint_1;
var breakPoint_2;
var breakPoint_3;
var breakPointEnd;

runTestScript();

function defineBreakpoints()
{
	//	Remove all breakpoints.
	removeAllBreakpoints();

	//	Set new breakpoints and get addresses of global variables of interested.
	breakPoint_1 = setNewBreakpoint( sBp1Label );	//	Self-ID reads Exhaust.
	breakPoint_2 = setNewBreakpoint( sBp2Label );	//	Self-ID reads Inlet.
	breakPoint_3 = setNewBreakpoint( sBp3Label );	//	Invalid Self-ID acquired.
	breakPointEnd = setNewBreakpoint( sBpEndLabel );	//	Terminate script execution.
}

function executeTestSequence()
{
	var bTestDone = false;

	while( !bTestDone )
	{
		if( targetIsHalted() === true )
		{
			if( atBreakpoint( sBp1Label )) {
				print( "Break Point #1 reached! " + sBp1Label );
			//	bTestDone = true;
			//	break;
			}
			else if( atBreakpoint( sBp2Label ))
			{
				print( "Break Point #2 reached! " + sBp2Label );
			//	bTestDone = true;
			//	break;
			}
			else if( atBreakpoint( sBp3Label  ))
			{
				print( "Break Point #3 reached! " + sBp3Label );
			//	bTestDone = true;
			//	break;
			}
			
			else if( atBreakpoint( sBpEndLabel  ))
			{
				print( "Break Point #5 reached! " + sBpEndLabel );
				bTestDone = true;
				break;
			}

			dspResume();
		}
	}

}

//	Top level management for running a DSS script.
//	Configure session, connect to target, start session, 
//	perform actions at breakpoints, shut down session.
function runTestScript()
{
	//	To run the script in conjunction with CCS set bRunCCS to TRUE.
	var bRunCCS = false;
	var cNewLine = defineNewline();
	
	defineSessionParams( bRunCCS );
	print( cNewLine );

	resetTarget();
	sessionStart();
	waitForTargetConnect();
	defineBreakpoints();

	executeTestSequence();

	removeAllBreakpoints();
	print( "Test Session Completed!" );

	//	Enable the following to esume normal target operation.
//	print( "Press Ctrl-C to exit the script." );
//	dspRun();

	//	Enable this line to halt target execution.
	CloseDebugSession();	
}