//------------------------------------------------------------------------------
//	defineBreakpoint.js - Wrapper around session breakpoint creation and removal.
//------------------------------------------------------------------------------

var nBpNew_ID;		//	Temporary storage for the second returned value from function defineBreakpoint.

function defineBreakpoint( sBpLabel )
{
	var pBPAddr;
	var nBpID = undefined;

	if( sBpLabel !== "undefined" ) {
		pBPAddr = getBreakpointAddress( sBpLabel );
		if( pBPAddr !== undefined ) 
		{
			nBpNew_ID = addNewBreakpoint( sBpLabel );
		}
	}
	return pBPAddr;
}

function getLastBpId()
{
	return nBpNew_ID;
}


function setNewBreakpoint( sBpLabel )
{
	var pBpAddr;
	var nBpId;
	
	pBpAddr = defineBreakpoint( sBpLabel );
	if( pBpAddr !== undefined )
	{
		nBpId = getLastBpId();
	}
	return( nBpId );
}
