//------------------------------------------------------------------------------
//	timeStamp.js
//	Add a time stamp prefix to output from the print() function.
//	The time stamp appears in the format [13:23:05.380].
//	The print with timestamps is used by all test scripts.
//	Time calculations use DSS JavaScript date and time library functions.
//------------------------------------------------------------------------------

var printLog = print;
var tsDate;

function timeStampInit()
{
	//	Create date object, and get current date and time.
	//	NOTE: Main script must declare tsDate a global.
	tsDate = new Date();
	var dateString = formatDateTime( tsDate, "_", true );	// date.getTime();
	return dateString;
}

//	Format date as mmddyyyy.
//	Separator, commonly shown as "/", defaults to "", but can be replaced by character cSep.
//	Optionally, use the format yyyymmdd if bYearFirst is non-zero.
function formatDateString( date, cSep, bYearFirst )
{
	var year	= date.getFullYear();
	var month	= date.getMonth() + 1;	//	JavaScript Date.getMonth returns a zero based index.
	var day		= date.getDate();
	var dateStr = ( ( bYearFirst ? year : "" ) +
			( cSep ? cSep : "" ) +
			(( month < 10) ? '0' + month: month ) +
			( cSep ? cSep : "" ) +
			(( day   < 10) ? '0' + day: day ) +
			( bYearFirst ? "" : year )
		);
	return dateStr;
}

//	Format time string. Default format is as hhmmss.
//	Separator (commonly shown as ":") defaults to "", but can be replaced by character cSep.
//	Append milliseconds in the format ".mmm" if Boolean bMsec != 0.
function formatTimeString( date, cSep, bMsec )
{
	var hour = date.getHours();
	var minutes = date.getMinutes();
	var seconds = date.getSeconds();
	var milliseconds = date.getMilliseconds();
	var timeStr = (
			(( hour < 10 ) ? '0' + hour: hour ) +
			( cSep ? cSep : "" ) +
			(( minutes < 10 ) ? '0' + minutes: minutes ) +
			( cSep ? cSep : "" ) +
			(( seconds < 10 ) ? '0' + seconds: seconds )
		);
	if( bMsec ) {
		timeStr += ( '.' + ('00' + milliseconds ).slice(-3) );
	}
	return timeStr;
}

function formatDateTime( date, cSep, bYearFirst )
{
	dateTimeStr = formatDateString( date, '', bYearFirst ) + '_' +
		formatTimeString( date, "", false );
	return dateTimeStr;
}


//	Redefine print function to prepend time of day to every line printed.
//	Called when building the console log for STD scripts.
print = function()
{
	var first_parameter = arguments[0];
	var other_parameters = Array.prototype.slice.call( arguments, 1 );

	//	Create time string with msec, and enclose it in [].
	function formatTimeTag( date )
	{
		var timeTag = '[' + formatTimeString( date, ':', true ) + '] ';
		return timeTag;
	}

//	printLog.apply( print, [formatTimeTag( new Date()) + first_parameter].concat( other_parameters ));
	printLog.apply( printLog, [formatTimeTag( new Date() ) + first_parameter].concat( other_parameters ) );
//	scriptEnv.apply( traceWrite, [formatTimeTag(new Date()) + first_parameter].concat( other_parameters ));

};

