//====================================================================
// The following declarations are required in order to use the SFO
// library functions:
//
int MEP_ScaleFactor; // Global variable used by teh SFO library
                     // Result can be used for all HRPWM channels
                     // This variable is also copied to HRMSTEP
                     // register by SFO() function.
volatile struct EPWM_REGS *ePWM[] = {0, &EPwm1Regs, &EPwm2Regs, &EPwm3Regs,&EPwm4Regs};

/* Filter Symbolic Constants                        */
#define FIR_ORDER   120  
#define HPFIR_ORDER   96                                        
                                        
/* Create an Instance of FIRFILT_GEN module and place the object in "firfiltx" section       */ 
#pragma DATA_SECTION(fir, "firfilt");
FIR16  fir= FIR16_DEFAULTS;

#pragma DATA_SECTION(fir2, "firfilt2");
FIR16  fir2= FIR16_DEFAULTS;

#pragma DATA_SECTION(HPfir1, "firfilt3");
FIR16  HPfir1= FIR16_DEFAULTS;

#pragma DATA_SECTION(HPfir1, "firfilt3");
FIR16  HPfir2= FIR16_DEFAULTS;
                                            
/* Define the Delay buffer for the xxth order filter and place it in "firldbx" section */  
#pragma DATA_SECTION(dbuffer,"firldb");					// Delay buffer alignment
long dbuffer[(FIR_ORDER+3)/2];    

#pragma DATA_SECTION(dbuffer2,"firldb2");					// Delay buffer alignment
long dbuffer2[(FIR_ORDER+3)/2];   

#pragma DATA_SECTION(dbuffer3,"firldb3");					// Delay buffer alignment
long dbuffer3[(HPFIR_ORDER+3)/2];  

#pragma DATA_SECTION(dbuffer4,"firldb4");					// Delay buffer alignment
long dbuffer4[(HPFIR_ORDER+3)/2];   

         
/* Define Constant Co-efficient Array  and place the
.constant section in ROM memory				*/ 
#pragma DATA_SECTION(coeff, "coefffilt");				// Coefficients buffer alignment
long const coeff[(FIR_ORDER+3)/2];

#pragma DATA_SECTION(coeff2, "coefffilt2");				// Coefficients buffer alignment
long const coeff2[(HPFIR_ORDER+3)/2];

//int FIR16_LPF_TEST[FIR_ORDER+1];						// Temporary buffer for adjust odd order FIR
														// coefficients   
        
//***************************************************************************************************//
//***************************************************************************************************//
main()
{

  MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);


	//Setup Filter initialization
	unsigned long k;
	int *p;
	int *p2;
		   
	int FIR_ORDER_REV;
	int HPFIR_ORDER_REV;
		   
	p=(int *)coeff;
	p2=(int *)coeff2;

	FIR_ORDER_REV = FIR_ORDER;
	HPFIR_ORDER_REV = HPFIR_ORDER;
	

	/* FIR Generic Filter Initialisation    */ 
       fir.order=FIR_ORDER_REV;        
       fir.dbuffer_ptr=dbuffer;
       fir.coeff_ptr=(long *)coeff; 
       fir.init(&fir);
       
       fir2.order=FIR_ORDER_REV;        
       fir2.dbuffer_ptr=dbuffer2;
       fir2.coeff_ptr=(long *)coeff; 
       fir2.init(&fir2);
       
       HPfir1.order=HPFIR_ORDER_REV;        
       HPfir1.dbuffer_ptr=dbuffer3;
       HPfir1.coeff_ptr=(long *)coeff2; 
       HPfir1.init(&HPfir1);
       
       HPfir2.order=HPFIR_ORDER_REV;        
       HPfir2.dbuffer_ptr=dbuffer4;
       HPfir2.coeff_ptr=(long *)coeff2; 
       HPfir2.init(&HPfir2);
       
	   //Clean up coeff buffer
       for(k=0;k<FIR_ORDER_REV*2;k=k+2)	
       {	
			*(p+k)=0;
			*(p+k+1)=0;  		
       }
          //Clean up coeff buffer
       for(k=0;k<HPFIR_ORDER_REV*2;k=k+2)	
       {			
			*(p2+k)=0;
			*(p2+k+1)=0;  
       }
       
       //Clean up delay buffer
       for(k=0;k<FIR_ORDER_REV*2;k=k+1)	
       {	
			dbuffer[k]=0;
			dbuffer2[k]=0;
	
       }
       
       //Clean up delay buffer
       for(k=0;k<HPFIR_ORDER_REV*2;k=k+1)	
       {	
		
			dbuffer3[k]=0;
			dbuffer4[k]=0;
       }
       
       
       //Reorganize coefficient table
       //If user would like to reorgainze the order of the coefficients outside this
	   //project, for example, in matlab and store the reorganized coefficients in 
	   //header file beforehand, this part is not necessary.
       //More details, please refer to Fixed Point DSP library manual
       //Gary> also the coefficients for these filters are symetric, so possibly not needed
       for(k=0;k<FIR_ORDER_REV;k=k+2)		
       {
       		*(p+FIR_ORDER_REV-k-2)=FIR16_LPF120_TEST[k/2];
       		*(p+FIR_ORDER_REV-k-1)=FIR16_LPF120_TEST[k/2+FIR_ORDER_REV/2];       		
     
       }
       
	   for(k=0;k<HPFIR_ORDER_REV;k=k+2)		
       {      
       		
       		*(p2+HPFIR_ORDER_REV-k-2)=FIR16_HPF96_TEST[k/2];
       		*(p2+HPFIR_ORDER_REV-k-1)=FIR16_HPF96_TEST[k/2+HPFIR_ORDER_REV/2];	
       			
       }
	
	


// Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2803x_SysCtrl.c file.
   InitSysCtrl();
   InitEPwm1Gpio();