/*
//###########################################################################
// FILE:    flash_programming_cpu1_FLASH.cmd
// TITLE:   Linker Command File For all F28X7x devices
//###########################################################################
// $TI Release: F2837xS Support Library v190 $
// $Release Date: Mon Feb  1 16:59:09 CST 2016 $
// $Copyright: Copyright (C) 2014-2016 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################
*/

/* ======================================================
// For Code Composer Studio V2.2 and later
// ---------------------------------------
// In addition to this memory linker command file,
// add the header linker command file directly to the project.
// The header linker command file is required to link the
// peripheral structures to the proper locations within
// the memory map.
// The header linker files are found in <base>\F2837xS_headers\cmd
// For BIOS applications add:      F28X7x_Headers_BIOS.cmd
// For nonBIOS applications add:   F28X7x_Headers_nonBIOS.cmd
========================================================= */

/* Define the memory block start/length for the F28X7x
   PAGE 0 will be used to organize program sections
   PAGE 1 will be used to organize data sections

   Notes:
         Memory blocks on F28M3Xx are uniform (ie same
         physical memory) in both PAGE 0 and PAGE 1.
         That is the same memory region should not be
         defined for both PAGE 0 and PAGE 1.
         Doing so will result in corruption of program
         and/or data.

         Contiguous SARAM memory blocks or flash sectors can be
         be combined if required to create a larger memory block.
*/

MEMORY
{
PAGE 0:    /* Program Memory */
          /* Memory (RAM/FLASH) blocks can be moved to PAGE1 for data allocation */
          /* BEGIN is used for the "boot to Flash" bootloader mode   */

	BEGIN			: origin = 0x080000, length = 0x000002

	//RAMM0_M1		: origin = 0x000122, length = 0x0006DE
	RAMM0_M1		: origin = 0x000122, length = 0x0002DE
	RAMLS0_LS2		: origin = 0x008000, length = 0x001800
	RAMLS3			: origin = 0x009800, length = 0x000800	// LS3 Error
	RAMLS4_GS7		: origin = 0x00A000, length = 0x00A000	// LS4, LS5, D0, D1, GS0~GS8

	RESET			: origin = 0x3FFFC0, length = 0x000002

	// Flash sectors
	FLASHA_N		: origin = 0x080002, length = 0x03FFFE	// on-chip Flash

//	FPUTABLES		: origin = 0x3F8000, length = 0x007FBF	  /* FPU Tables in Boot ROM */


PAGE 1 :   /* Data Memory */
         /* Memory (RAM/FLASH) blocks can be moved to PAGE0 for program allocation */

	BOOT_RSVD		: origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */

	RAMGS8_GS11		: origin = 0x014000, length = 0x004000

	// Flash sectors
//	FLASHO_AB		: origin = 0x0C0000, length = 0x040000	// on-chip Flash
}


SECTIONS
{

	/* Allocate program areas: */
	.cinit			: > FLASHA_N,      PAGE = 0
	.pinit			: > FLASHA_N,      PAGE = 0
	.text			: > FLASHA_N,      PAGE = 0
	codestart		: > BEGIN,	PAGE = 0

	ramfuncs		:	LOAD = FLASHA_N,
						RUN = RAMLS4_GS7,
						LOAD_START(_RamfuncsLoadStart),
						LOAD_SIZE(_RamfuncsLoadSize),
						LOAD_END(_RamfuncsLoadEnd),
						RUN_START(_RamfuncsRunStart),
						RUN_SIZE(_RamfuncsRunSize),
						RUN_END(_RamfuncsRunEnd),
						PAGE = 0

	/* Allocate uninitalized data sections: */
	.stack			: > RAMLS4_GS7,		PAGE = 0
	.ebss			: > RAMGS8_GS11,	PAGE = 1
	.esysmem		: > RAMGS8_GS11,	PAGE = 1

	/* Initalized sections go in Flash */
	.econst			: > FLASHA_N,		PAGE = 0
	.switch			: > FLASHA_N,		PAGE = 0

	.reset			: > RESET,		PAGE = 0, TYPE = DSECT /* not used, */

//	FPUmathTables	: > FPUTABLES,	PAGE = 0, TYPE = NOLOAD

	Filter_RegsFile	: > RAMGS8_GS11,	PAGE = 1

	SHARERAMGS0		: > RAMGS8_GS11,		PAGE = 1
	SHARERAMGS1		: > RAMGS8_GS11,		PAGE = 1

	/* Flash Programming Buffer */
	BufferDataSection : > RAMLS0_LS2 ,	PAGE = 0, ALIGN(4)
   
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/




