/**********************************************************************
* File: F28377S_nonBIOS_ram.cmd -- Linker command file for
* non-DSP/BIOS code with DSP in jump-to-M0SARAM boot mode.
*
* History:
*   09/18/14 - original (D. Alter)
**********************************************************************/
MEMORY
{
PAGE 0:    /* Program Memory */
   BEGIN_M0                       : origin = 0x000000, length = 0x000002     /* Part of M0 RAM */
   RAMLS012345                    : origin = 0x008000, length = 0x003000     /* LS0-5 RAM */
   BEGIN_FLASH               (RX) : origin = 0x080000, length = 0x000002     /* Part of Flash Bank 0, Sector A.  Used for "Jump to flash" bootloader mode. */
   FLASH_B0_A                (RX) : origin = 0x080002, length = 0x001FFE     /* Flash Bank 0, Sector A */
   FLASH_B0_BCDEFGHIJKLMN    (RX) : origin = 0x082000, length = 0x03E000     /* Flash Bank 0, Sectors B-N */
   RESET                     (RX) : origin = 0x3FFFC0, length = 0x000002     /* Part of Boot ROM */

PAGE 1 : /* Data Memory */
   BOOT_RSVD                      : origin = 0x000002, length = 0x00004E     /* Part of M0 RAM, BOOT rom will use this for stack */
   RAMM0                          : origin = 0x000050, length = 0x0003B0     /* M0 RAM */
   RAMM1                          : origin = 0x000400, length = 0x000400     /* M1 RAM */
   RAMD0                          : origin = 0x00B000, length = 0x000800     /* D0 RAM, ECC */
   RAMD1                          : origin = 0x00B800, length = 0x000800     /* D1 RAM, ECC */
   RAMGS0123456789ABCDEF          : origin = 0x00C000, length = 0x010000     /* GS1-15 RAM, Parity */
}

SECTIONS
{
/*** Compiler Required Sections ***/
   .text             : > RAMLS012345,                       PAGE = 0
   .cinit            : > RAMLS012345,                       PAGE = 0
   .const            : > RAMLS012345,                       PAGE = 0
   .econst           : > RAMLS012345,                       PAGE = 0
   .pinit            : > RAMLS012345,                       PAGE = 0
   .reset            : > RESET,                             PAGE = 0, TYPE = DSECT  /* We are not using the .reset section */
   .switch           : > RAMLS012345,                       PAGE = 0

   .bss              : > RAMGS0123456789ABCDEF,             PAGE = 1
   .ebss             : > RAMGS0123456789ABCDEF,             PAGE = 1
   .cio              : > RAMGS0123456789ABCDEF,             PAGE = 1
   .stack            : > RAMM1,                             PAGE = 1
   .sysmem           : > RAMGS0123456789ABCDEF,             PAGE = 1
   .esysmem          : > RAMGS0123456789ABCDEF,             PAGE = 1

/*** User Defined Sections ***/
   codestart         : > BEGIN_M0,                          PAGE = 0         /* Used by file CodeStartBranch.asm */

}

/******************* end of file ************************/
