/**********************************************************************
* File: F28377S_example.h
* Device: TMS320F28377S
* Author: David M. Alter, Texas Instruments Inc.
* Description: Include file for example project.  Include this file in
*   all C-source files.
* Notes:
*   1) The following constants may be defined in the CCS project build
*      options:
*        EXAMPLE_FLASH
*        EXAMPLE_RAM
* History:
*   02/03/17 - original (D. Alter)
**********************************************************************/

#ifndef F28377S_EXAMPLE_H
#define F28377S_EXAMPLE_H

//---------------------------------------------------------------------------
// Constant Definitions
//
#define PWM_HALF_PERIOD		25000			// period/2 for 2 kHz symmetric PWM w/ 100 MHz ePWM clock
#define PWM_DUTY_CYCLE		18750			// 25% duty cycle

//---------------------------------------------------------------------------
// Include Standard C Language Header Files
//
#include <string.h>


//---------------------------------------------------------------------------
// Include any other Header Files
//
#include "F2837xS_Device.h"				// Peripheral address definitions
#include "F2837xS_Adc_defines.h"		// ADC definitions
#include "F2837xS_DefaultIsr.h"			// ISR definitions
#include "F2837xS_Pie_defines.h"		// PIE definitions

//---------------------------------------------------------------------------
// Function Prototypes
//
extern void DelayUs(Uint16);
extern void InitEPwm(void);

extern void InitGpio(void);
extern void InitPieCtrl(void);
extern void InitSysCtrl(void);
extern void InitWatchdog(void);
extern void SetDBGIER(Uint16);


//---------------------------------------------------------------------------
// Global Variable References
//
extern const struct PIE_VECT_TABLE PieVectTableInit;	// Pie vector table (non-BIOS only)


//---------------------------------------------------------------------------
// Macros
//

// The following pointer to a function call calibrates the ADC reference,
// DAC offset, and internal oscillators
#define Device_cal (void   (*)(void))0x070282

// Millisecond delay macro using DelayUs() function.  Typically used only for debug.
#define DelayMs(a)							\
	{										\
		Uint16 i;							\
		for(i=0; i<a; i++) DelayUs(1000);	\
	}


//---------------------------------------------------------------------------
#endif  // end of F28377S_EXAMPLE_H definition


//--- end of file -----------------------------------------------------
