/**********************************************************************
* File: EPwm.c
* Devices: TMS320F2837x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   02/04/14 - original (D. Alter)
**********************************************************************/
#include "F28377S_example.h"				// Main include file


/**********************************************************************
* Function: InitEPwm()
*
* Description: Initializes the Enhanced PWM modules on the F2837x.
**********************************************************************/
void InitEPwm(void)
{

	asm(" EALLOW");						// Enable EALLOW protected register access

	// Configure the prescaler to the ePWM modules.  Max ePWM input clock is 100 MHz.
	ClkCfgRegs.PERCLKDIVSEL.bit.EPWMCLKDIV = 1;		// EPWMCLK divider from PLLSYSCLK.  0=/1, 1=/2

	// Must disable the clock to the ePWM modules if you want all ePWM modules synchronized.
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;

	asm(" EDIS");						// Disable EALLOW protected register access

//---------------------------------------------------------------------
//--- Configure ePWM2 for 2 kHz symmetric PWM on EPWM2A pin
//---------------------------------------------------------------------
	asm(" EALLOW");							// Enable EALLOW protected register access
	DevCfgRegs.SOFTPRES2.bit.EPWM2 = 1;		// ePWM2 is reset
	DevCfgRegs.SOFTPRES2.bit.EPWM2 = 0;		// ePWM2 is released from reset
	asm(" EDIS");							// Disable EALLOW protected register access

	EPwm2Regs.TBCTL.bit.CTRMODE = 0x3;		// Disable the timer

	EPwm2Regs.TBCTL.all = 0xC033;			// Configure timer control register
// bit 15-14     11:     FREE/SOFT, 11 = ignore emulation suspend
// bit 13        0:      PHSDIR, 0 = count down after sync event
// bit 12-10     000:    CLKDIV, 000 => TBCLK = HSPCLK/1
// bit 9-7       000:    HSPCLKDIV, 000 => HSPCLK = EPWMCLK/1
// bit 6         0:      SWFSYNC, 0 = no software sync produced
// bit 5-4       11:     SYNCOSEL, 11 = sync-out disabled
// bit 3         0:      PRDLD, 0 = reload PRD on counter=0
// bit 2         0:      PHSEN, 0 = phase control disabled
// bit 1-0       11:     CTRMODE, 11 = timer stopped (disabled)

	EPwm2Regs.TBCTR = 0x0000;				// Clear timer counter
	EPwm2Regs.TBPRD = PWM_HALF_PERIOD;		// Set timer period
	EPwm2Regs.TBPHS.bit.TBPHS = 0x0000;		// Set timer phase

	EPwm2Regs.CMPA.bit.CMPA = PWM_DUTY_CYCLE;	// Set PWM duty cycle

	EPwm2Regs.CMPCTL.all = 0x0002;			// Compare control register
// bit 15-10     0's:    reserved
// bit 9         0:      SHDWBFULL, read-only
// bit 8         0:      SHDWAFULL, read-only
// bit 7         0:      reserved
// bit 6         0:      SHDWBMODE, don't care
// bit 5         0:      reserved
// bit 4         0:      SHDWAMODE, 0 = shadow mode
// bit 3-2       00:     LOADBMODE, don't care
// bit 1-0       10:     LOADAMODE, 10 = load on zero or PRD match

	EPwm2Regs.AQCTLA.all = 0x0060;		// Action-qualifier control register A
// bit 15-12     0000:   reserved
// bit 11-10     00:     CBD, 00 = do nothing
// bit 9-8       00:     CBU, 00 = do nothing
// bit 7-6       01:     CAD, 01 = clear
// bit 5-4       10:     CAU, 10 = set
// bit 3-2       00:     PRD, 00 = do nothing
// bit 1-0       00:     ZRO, 00 = do nothing

	EPwm2Regs.AQSFRC.all = 0x0000;		// Action-qualifier s/w force register
// bit 15-8      0's:    reserved
// bit 7-6       00:     RLDCSF, 00 = reload AQCSFRC on zero
// bit 5         0:      OTSFB, 0 = do not initiate a s/w forced event on output B
// bit 4-3       00:     ACTSFB, don't care
// bit 2         0:      OTSFA, 0 = do not initiate a s/w forced event on output A
// bit 1-0       00:     ACTSFA, don't care

	EPwm2Regs.AQCSFRC.all = 0x0000;		// Action-qualifier continuous s/w force register
// bit 15-4      0's:    reserved
// bit 3-2       00:     CSFB, 00 = forcing disabled
// bit 1-0       00:     CSFA, 00 = forcing disabled

	EPwm2Regs.DBCTL.bit.OUT_MODE = 0;	// Deadband disabled
	EPwm2Regs.PCCTL.bit.CHPEN = 0;		// PWM chopper unit disabled
	EPwm2Regs.TZDCSEL.all = 0x0000;		// All trip zone and DC compare actions disabled

	EPwm2Regs.TBCTL.bit.CTRMODE = 0x2;	// Enable the timer in count up/down mode

//---------------------------------------------------------------------
//--- Enable the clocks to the ePWM module.                   
//--- Note: this should be done after all ePWM modules are configured
//--- to ensure synchronization between the ePWM modules.
//---------------------------------------------------------------------
	asm(" EALLOW");							// Enable EALLOW protected register access
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;	// TBCLK to ePWM modules enabled
	asm(" EDIS");							// Disable EALLOW protected register access

} // end InitEPwm()


//--- end of file -----------------------------------------------------
