/**********************************************************************
* File: Main_nonBIOS.c
* Devices: TMS320F2837x CPU #1
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   02/22/18 - original (D. Alter)
**********************************************************************/
#include "F28377S_example.h"			// Main include file

/**********************************************************************
* Function: main()
*
* Description: Main function for F2837x example.
**********************************************************************/
void main(void)
{
//--- CPU Initialization
	InitSysCtrl();						// Initialize the CPU
	InitPieCtrl();						// Initialize and enable the PIE
	InitWatchdog();						// Initialize the Watchdog Timer
	InitGpio();							// Initialize the shared GPIO pins

//--- Peripheral Initialization
	InitEPwm();							// Initialize the PWM

//--- Enable interrupts
    SetDBGIER(IER);						// Configure the DBGIER for real time debug
	asm(" CLRC INTM, DBGM");			// Enable global interrupts and real time debug

//--- Main Loop
	while(1)							// Dummy loop.  Wait for an interrupt.
	{

	}

} // end of main()


//--- end of file -----------------------------------------------------
