/**********************************************************************
* File: Watchdog.c
* Devices: TMS320F2837x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   06/24/13 - original (D. Alter)
**********************************************************************/
#include "F28377S_example.h"			// Main include file


/**********************************************************************
* Function: InitWatchdog()
* Description: Initializes the F2837x Watchdog Timer.
* Notes:
*  1) As written, this function disables the WD timer.  This is really
*     just a placeholder though since the WD is already disabled in the
*     function CodeStartBranch.asm.
*  2) Edit this function as desired to re-enable the WD, and to
*     choose between a WD interrupt or system reset.
**********************************************************************/
void InitWatchdog(void)
{
	asm(" EALLOW");						// Enable EALLOW protected register access

	WdRegs.WDCR.all = 0x0068;
// bit 15-7      0's:    reserved
// bit 6         1:      WDDIS, 1=disable WD
// bit 5-3       101:    WDCHK, WD check bits, always write as 101b
// bit 2-0       000:    WDPS, WD prescale bits, 000: WDCLK=OSCCLK/512/1

	WdRegs.SCSR.all = 0x0000;
// bit 15-3      0's:    reserved
// bit 2         0:      WDINTS, WD interrupt status bit (read-only)
// bit 1         0:      WDENINT, 0=WD causes reset, 1=WD causes WDINT
// bit 0         0:      WDOVERRIDE, write 1 to disable disabling of the WD (clear-only)

	WdRegs.WDWCR.all = 0x0000;
// bit 15-9      0's:    reserved
// bit 8         0:      FIRSTKEY (read-only)
// bit 7-0       0x00:   MIN, minimum service interval.  0x00 is no minimum.

	asm(" EDIS");						// Disable EALLOW protected register access

} // end of InitWatchdog()

//--- end of file -----------------------------------------------------
