//#############################################################################
//! \file main.c
//!
//! \brief  16-bit CRC routine
//! \author Vishal Coelho
//!
//! \date   Sep 04, 2014
//!
//! 16-bit assembly CRC routine for the C28x. It uses a lookup table
//! implementation
//!
//
//  Group:            C2000
//  Target Family:    C28x
//
// (C)Copyright $YEAR$, Texas Instruments, Inc.
//#############################################################################
//$TI Release: PACKAGE NAME $
//$Release Date: PACKAGE RELEASE DATE $
//#############################################################################

//*****************************************************************************
// includes
//*****************************************************************************
#include "F28x_Project.h"
#include "CrcTable0x8005Reversed.h"
#include "CrcTable0x8005Mirrored.h"
#include <stdint.h>

//*****************************************************************************
// defines
//*****************************************************************************
// Filter Symbolic Constants
#define NUM_BYTES       100

//*****************************************************************************
// globals
//*****************************************************************************
static const uint16_t msg[NUM_BYTES] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
	0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e,
	0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
	0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32,
	0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c,
	0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
	0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a,
	0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63, 0x64
};

//*****************************************************************************
// protoypes
//*****************************************************************************
uint16_t CRC16_calc(uint16_t accumulator, uint16_t nBytes, uint16_t parity,
                     uint16_t *tablePtr, uint16_t *msgPtr);
uint16_t CRC16_calc_alt(uint16_t accumulator, uint16_t nBytes, uint16_t parity,
                     uint16_t *tablePtr, uint16_t *msgPtr);
// Start of main()
void main()
{
    uint16_t accum = 0xFFFF, nBytes = NUM_BYTES, parity = 0;
    volatile uint16_t result_1 = 0, result_2 = 0;

    // Initialize System Clocks
    InitSysCtrl();

    // Initialize PIE block
    DINT;
    InitPieCtrl();
    IER = 0x0000;
    IFR = 0x0000;
    InitPieVectTable();
    EINT;   // Enable Global interrupt INTM
    ERTM;   // Enable Global real time interrupt DBGM

    // call the routine
    result_1 = CRC16_calc(accum, nBytes, parity, (uint16_t *)&crcTable[0],
    		(uint16_t *)&msg[0]);
    result_2 = CRC16_calc_alt(accum, nBytes, parity, (uint16_t *)&crcTable[0],
    		(uint16_t *)&msg[0]);

    // call the routine with the mirrored polynomial now
    result_1 = CRC16_calc(accum, nBytes, parity, (uint16_t *)&crcTable1[0],
    		(uint16_t *)&msg[0]);
    result_2 = CRC16_calc_alt(accum, nBytes, parity, (uint16_t *)&crcTable1[0],
    		(uint16_t *)&msg[0]);
    // forever loop
    while(1){}

} /* End: main() */


//###########################################################################
// End of File
//###########################################################################
