
MEMORY
{
PAGE 0 :  /* Program Memory */
          /* Memory (RAM/FLASH) blocks can be moved to PAGE1 for data allocation */
          /* BEGIN is used for the "boot to Flash" bootloader mode   */

/*
 * Entry Points
 * This section gives details about the entry point addresses for various boot modes. These entry points tell
 * the boot ROM where to branch to at the end of booting as per the selected boot mode.
 * Entry Point		Address
 * RAM				0x0000 0000
 * Flash			0x0008 0000
 */
   BEGIN :		origin = 0x00080000,	length = 0x00000002
/* NOTE: The BOOTROM uses locations 0x02-0x122 on CPU1s M0 RAM. To prevent losing any data
 * 		 during HIB wake-up, avoid saving any critical data to these locations. (Page 502
 *       TMS320F2837xS Delfino Microcontrollers Technical Reference Manual.)
 */
   RAMLS0 :		origin = 0x00008000,	length = 0x00000800		/* Local Shared 0,  2k x 16, CLA Access */
   RAMLS1 :		origin = 0x00008800,	length = 0x00000800		/* Local Shared 1,  2k x 16, CLA Access */
   RAMGS0 : 	origin = 0x0000C000,	length = 0x00001000		/* Global Shared 0, 4k x 16, DMA Access */
   /* Reset is always fetched from location 0x003F_FFC0 in Boot ROM */
   RESET : 		origin = 0x003FFFC0,	length = 0x00000002

   /* Bank 0 Flash sectors 512k Bytes*/
   FLASHA : 	origin = 0x00080002,	length = 0x00001FFE	/* on-chip Flash */
   FLASHB :		origin = 0x00082000,	length = 0x00002000	/* Sector B on-chip Flash  8k x 16 */
   FLASHC :		origin = 0x00084000,	length = 0x00002000	/* Sector C on-chip Flash  8k x 16 */
   FLASHD :		origin = 0x00086000,	length = 0x00002000	/* Sector D on-chip Flash  8k x 16 */
   FLASHE :		origin = 0x00088000,	length = 0x00008000	/* Sector E on-chip Flash 32k x 16 */
   FLASHF :		origin = 0x00090000,	length = 0x00008000	/* Sector F on-chip Flash 32k x 16 */
   FLASHG :		origin = 0x00098000,	length = 0x00008000	/* Sector G on-chip Flash 32k x 16 */
   FLASHH :		origin = 0x000A0000,	length = 0x00008000	/* Sector H on-chip Flash 32k x 16 */
   FLASHI :		origin = 0x000A8000,	length = 0x00008000	/* Sector I on-chip Flash 32k x 16 */
   FLASHJ :		origin = 0x000B0000,	length = 0x00008000	/* Sector J on-chip Flash 32k x 16 */
   FLASHK :		origin = 0x000B8000,	length = 0x00002000	/* Sector K on-chip Flash  8k x 16 */
   FLASHL :		origin = 0x000BA000,	length = 0x00002000	/* Sector L on-chip Flash  8k x 16 */
   FLASHM :		origin = 0x000BC000,	length = 0x00002000	/* Sector M on-chip Flash  8k x 16 */
   FLASHN :		origin = 0x000BE000,	length = 0x00002000	/* Sector N on-chip Flash  8k x 16 */

   /* Bank 1 Flash sectors 512k Bytes*/
   FLASHO : 	origin = 0x000C0000,	length = 0x00002000	/* Sector O on-chip Flash  8k x 16 */
   FLASHP :		origin = 0x000C2000,	length = 0x00002000	/* Sector P on-chip Flash  8k x 16 */
   FLASHQ :		origin = 0x000C4000,	length = 0x00002000	/* Sector Q on-chip Flash  8k x 16 */
   FLASHR :		origin = 0x000C6000,	length = 0x00002000	/* Sector R on-chip Flash  8k x 16 */
   FLASHS :		origin = 0x000C8000,	length = 0x00008000	/* Sector S on-chip Flash 32k x 16 */
   FLASHT :		origin = 0x000D0000,	length = 0x00008000	/* Sector T on-chip Flash 32k x 16 */
   FLASHU :		origin = 0x000D8000,	length = 0x00008000	/* Sector U on-chip Flash 32k x 16 */
   FLASHV :		origin = 0x000E0000,	length = 0x00008000	/* Sector V on-chip Flash 32k x 16 */
   FLASHW :		origin = 0x000E8000,	length = 0x00008000	/* Sector W on-chip Flash 32k x 16 */
   FLASHX :		origin = 0x000F0000,	length = 0x00008000	/* Sector X on-chip Flash 32k x 16 */
   FLASHY :		origin = 0x000F8000,	length = 0x00002000	/* Sector Y on-chip Flash  8k x 16 */
   FLASHZ :		origin = 0x000FA000,	length = 0x00002000	/* Sector Z on-chip Flash  8k x 16 */
   FLASHAA :	origin = 0x000FC000,	length = 0x00002000	/* Sector AA on-chip Flash 8k x 16 */
   FLASHAB :	origin = 0x000FE000,	length = 0x00002000	/* Sector AB on-chip Flash 8k x 16 */

PAGE 1 : /* Data Memory */
         /* Memory (RAM/FLASH) blocks can be moved to PAGE0 for program allocation */

/* NOTE: The bootROM uses locations 0x02-0x122 on CPU1s M0 RAM. To prevent losing any data
 * 		 during HIB wake-up, avoid saving any critical data to these locations. (Page 116
 *       TMS320F2837xS Delfino Microcontrollers Reference Manual.)
 */
   BOOT_RSVD :		origin = 0x00000002,	length = 0x000120		/* Part of M0, BOOT rom will use this for stack (501 TRM) */
   RAMM01 :			origin = 0x00000122,	length = 0x0006DE		/* on-chip 1k x 16 M0 RAM block M1 */
   																	/* on-chip 1k x 16 M1 RAM block M1 */
   CLAtoCPUMSGRAM :	origin = 0x00001480,	length = 0x000080		/* CLA to CPU MSGRAM, 128 x 16, CLA Access */
   CPUtoCLAMSGRAM :	origin = 0x00001500,	length = 0x000080		/* CPU to CLA MSGRAM, 128 x 16, CLA Access */

   RAMLS2 :			origin = 0x00009000,	length = 0x000800		/* Local Shared 2,  2k x 16, CLA Access */
   RAMLS3 : 		origin = 0x00009800,	length = 0x000800		/* Local Shared 3,  2k x 16, CLA Access */
   RAMLS4 :			origin = 0x0000A000,	length = 0x000800		/* Local Shared 4,  2k x 16, CLA Access */
   RAMLS5 :			origin = 0x0000A800,	length = 0x000800		/* Local Shared 5,  2k x 16, CLA Access */
   RAMD0 :			origin = 0x0000B000,	length = 0x000800		/* D0 RAM,  2k x 16, CLA Access			*/
   RAMD1 :			origin = 0x0000B800,	length = 0x000800		/* D1 RAM,  2k x 16, CLA Access			*/

   RAMGS1 :			origin = 0x0000D000,	length = 0x00001000		/* Global Shared 1, 4k x 16, DMA Access */
   RAMGS2 :			origin = 0x0000E000,	length = 0x00001000		/* Global Shared 2, 4k x 16, DMA Access */
   RAMGS3 :			origin = 0x0000F000,	length = 0x00001000		/* Global Shared 3, 4k x 16, DMA Access */
   RAMGS4 :			origin = 0x00010000,	length = 0x00001000		/* Global Shared 4, 4k x 16, DMA Access */
   RAMGS5 :			origin = 0x00011000,	length = 0x00001000		/* Global Shared 5, 4k x 16, DMA Access */
   RAMGS6 :			origin = 0x00012000,	length = 0x00001000		/* Global Shared 6, 4k x 16, DMA Access */
   RAMGS7 :			origin = 0x00013000,	length = 0x00001000		/* Global Shared 7, 4k x 16, DMA Access */
   RAMGS8 :			origin = 0x00014000,	length = 0x00001000		/* Global Shared 8, 4k x 16, DMA Access */
   RAMGS9 :			origin = 0x00015000,	length = 0x00001000		/* Global Shared 9, 4k x 16, DMA Access */
   RAMGS10 :		origin = 0x00016000,	length = 0x00001000		/* Global Shared 10, 4k x 16, DMA Access */
   RAMGS11 : 		origin = 0x00017000,	length = 0x00001000		/* Global Shared 11, 4k x 16, DMA Access */
   RAMGS12 : 		origin = 0x00018000,	length = 0x00001000		/* Global Shared 12, 4k x 16, DMA Access */
   RAMGS13 : 		origin = 0x00019000,	length = 0x00001000		/* Global Shared 13, 4k x 16, DMA Access */
   RAMGS14 : 		origin = 0x0001A000,	length = 0x00001000		/* Global Shared 14, 4k x 16, DMA Access */
   RAMGS15 : 		origin = 0x0001B000,	length = 0x00001000		/* Global Shared 15, 4k x 16, DMA Access */
}

SECTIONS
{
   /* Allocate program areas: */
   .cinit : 	>  FLASHA,														PAGE = 0, ALIGN(4)
   .pinit : 	>> FLASHA | FLASHB,												PAGE = 0, ALIGN(4)

   .text : 		>> FLASHE | FLASHF |
   				   FLASHG | FLASHH | FLASHI | FLASHJ | FLASHK | FLASHL |
   				   FLASHM | FLASHN | FLASHO | FLASHP | FLASHQ | FLASHR |
   				   FLASHS | FLASHT | FLASHU | FLASHV | FLASHW | FLASHX |
   				   FLASHY | FLASHZ | FLASHAA | FLASHAB,							PAGE = 0, ALIGN(4)
   codestart :	> BEGIN															PAGE = 0, ALIGN(4)

   /* Initalized sections go in Flash */
   .econst :	>> FLASHA | FLASHB,												PAGE = 0, ALIGN(4)
   .switch :	>> FLASHA | FLASHB,												PAGE = 0, ALIGN(4)

   .reset :		> RESET,     													PAGE = 0, TYPE = DSECT /* not used, */

   	.TI.ramfunc :	LOAD > FLASHA,
					RUN > RAMGS0,
					LOAD_START(_RamfuncsLoadStart),
					LOAD_SIZE(_RamfuncsLoadSize),
					LOAD_END(_RamfuncsLoadEnd),
					RUN_START(_RamfuncsRunStart),
					RUN_SIZE(_RamfuncsRunSize),
					RUN_END(_RamfuncsRunEnd),
																				PAGE = 0, ALIGN(4)

	/* CLA Program Memory */
	Cla1Prog	: 	LOAD = FLASHC | FLASHD,														// Cla1 Code
			 		RUN = RAMLS0 | RAMLS1,
			  		LOAD_START(_Cla1ProgLoadStart),
			  		LOAD_END(_Cla1ProgLoadEnd),
			  		RUN_START(_Cla1ProgRunStart),
			  		LOAD_SIZE(_Cla1ProgLoadSize),								PAGE = 0, ALIGN(4)


	/* CLA DATA */
	Cla1Data		: >> RAMLS2 | RAMLS3,										PAGE = 1, ALIGN (4)
	Cla1ToCpuMsgRAM	: > CLAtoCPUMSGRAM,											PAGE = 1
	CpuToCla1MsgRAM	: > CPUtoCLAMSGRAM,											PAGE = 1


   	/* CLA C compiler sections */

	.scratchpad		: >> RAMLS2 | RAMLS3,       								PAGE = 1		// Local variables and Compiler temporary variables
	.bss_cla		: >> RAMLS2 | RAMLS3,       								PAGE = 1		// Uninitialize global data
	.const_cla	    :  	LOAD = FLASHC | FLASHD,													// Initialized constant data
	                    RUN = RAMLS2 | RAMLS3,
	                    RUN_START(_Cla1ConstRunStart),
	                    LOAD_START(_Cla1ConstLoadStart),
	                    LOAD_SIZE(_Cla1ConstLoadSize),
	                    														PAGE = 1


   /* Allocate uninitalized data sections: */
   .stack : 	> RAMM01,														PAGE = 1
   .ebss : 		>> RAMD0 | RAMD1 | RAMGS3,										PAGE = 1
   .esysmem : 	> RAMD1,      													PAGE = 1
   .cio : 		> RAMD1,														PAGE = 1

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
