/*
 * app1.c
 */
#include "../../bsp/inc/bsp.h"
#include "../inc/app.h"

#if ( CFG_APP1 )

systime_struct systime = { 0, 0 ,0 };

void cuptmr0isrcallback( void )
{
    systime.microseconds += CPUTMR0_PERI0D_US;
    if( systime.microseconds >= 1000 )
    {
        systime.microseconds -= 1000;
        systime.milliseconds += 1;
        if(systime.milliseconds >= 1000)
        {
            systime.milliseconds -= 1000;
            systime.seconds += 1;
        }
    }
}


void appinit( void )
{
    bspinit();

    CPUTMR00isr = cuptmr0isrcallback;
}


void appstart( void )
{
    EALLOW;
    Cla1Regs.MICLR.all      = 0x00FF;               // Clear all interrupt flags
    Cla1Regs.MICLROVF.all   = 0x00FF;               // Clear all overflow flags
    Cla1Regs.MIER.all       = CLA1_MIER_REG_VALUE;
    EINT;   // Enable Global interrupt INTM
    EDIS;

    CpuTimer0Regs.TCR.bit.TSS = 0;
}

#endif
