/*
 * cla1cfg.h
 */

#ifndef _CLA1CFG_H_
#define _CLA1CFG_H_


#ifdef __cplusplus
extern "C" {
#endif

typedef void ( *cla1isr )( void );

#define CFG_CLA1_TASK1          ( 0 )
#if( CFG_CLA1_TASK1 )
__interrupt void Cla1Task1( void );

/*******************************************************************************
 * MVECT1 Register, Page 784 TRM (Highest priority.)
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK1_MVECT        ( ( uint16_t )( &Cla1Task1 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL1 Register, Page 247 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK4 | TASK3 | TASK2 | TASK1 |
 * -----------------------------------------------------------------------------
 * TASK1: Selects the Trigger Source for TASK1 of CLA1
 */
#define CFG_CAL1_TASK1_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK2          ( 0 )
#if( CFG_CLA1_TASK2 )
__interrupt void Cla1Task2( void );

/*******************************************************************************
 * MVECT2 Register, Page 785 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK2_MVECT        ( ( uint16_t )( &Cla1Task2 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL1 Register, Page 247 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK4 | TASK3 | TASK2 | TASK1 |
 * -----------------------------------------------------------------------------
 * TASK2: Selects the Trigger Source for TASK2 of CLA1
 */
#define CFG_CAL1_TASK2_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK3          ( 0 )
#if( CFG_CLA1_TASK3 )
__interrupt void Cla1Task6( void );

/*******************************************************************************
 * MVECT3 Register, Page 786 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK3_MVECT        ( ( uint16_t )( &Cla1Task3 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL1 Register, Page 247 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK4 | TASK3 | TASK2 | TASK1 |
 * -----------------------------------------------------------------------------
 * TASK3: Selects the Trigger Source for TASK3 of CLA1
 */
#define CFG_CAL1_TASK3_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK4          ( 0 )
#if( CFG_CLA1_TASK4 )
__interrupt void Cla1Task4( void );

/*******************************************************************************
 * MVECT4 Register, Page 787 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK4_MVECT        ( ( uint16_t )( &Cla1Task4 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL1 Register, Page 247 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK4 | TASK3 | TASK2 | TASK1 |
 * -----------------------------------------------------------------------------
 * TASK4: Selects the Trigger Source for TASK4 of CLA1
 */
#define CFG_CAL1_TASK4_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK5          ( 0 )
#if( CFG_CLA1_TASK5 )
__interrupt void Cla1Task5( void );

/*******************************************************************************
 * MVECT5 Register, Page 788 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK5_MVECT        ( ( uint16_t )( &Cla1Task5 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL2 Register, Page 248 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK8 | TASK7 | TASK6 | TASK5 |
 * -----------------------------------------------------------------------------
 * TASK5: Selects the Trigger Source for TASK5 of CLA1
 */
#define CFG_CAL1_TASK5_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK6          ( 0 )
#if( CFG_CLA1_TASK6 )
__interrupt void Cla1Task6( void );

/*******************************************************************************
 * MVECT6 Register, Page 789 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK6_MVECT        ( ( uint16_t )( &Cla1Task6 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL2 Register, Page 248 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK8 | TASK7 | TASK6 | TASK5 |
 * -----------------------------------------------------------------------------
 * TASK6: Selects the Trigger Source for TASK6 of CLA1
 */
#define CFG_CAL1_TASK6_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK7          ( 0 )
#if( CFG_CLA1_TASK7 )
__interrupt void Cla1Task7( void );

/*******************************************************************************
 * MVECT7 Register, Page 790 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK7_MVECT        ( ( uint16_t )( &Cla1Task7 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL2 Register, Page 248 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK8 | TASK7 | TASK6 | TASK5 |
 * -----------------------------------------------------------------------------
 * TASK7: Selects the Trigger Source for TASK7 of CLA1
 */
#define CFG_CAL1_TASK7_TRIGGER_SRC      ( 0 )               // See F2837xS_cla.h
#endif

#define CFG_CLA1_TASK8          ( 1 )

#if( CFG_CLA1_TASK8 )
void Cal1Task8Init( void );
__interrupt void Cla1Task8( void );

/*******************************************************************************
 * MVECT8 Register, Page 791 TRM
 * -----------------------------------------------------------------------------
 * | 16     00 |
 * |   MVECT   |
 * -----------------------------------------------------------------------------
 * MVECT : These bits specify the start address for the
 *         given interrupt (task). The address range of the CLA with a 16-bit
 *         MVECT is 64Kx16 words or 32K CLA instructions.
 */
#define CLA1_TASK8_MVECT        ( ( uint16_t )( &Cla1Task8 ) )

/*******************************************************************************
 * CLA1TASKSRCSEL2 Register, Page 248 TRM
 * -----------------------------------------------------------------------------
 * | 31 24 | 23 16 | 15 08 | 07 00 |
 * | TASK8 | TASK7 | TASK6 | TASK5 |
 * -----------------------------------------------------------------------------
 * TASK8: Selects the Trigger Source for TASK8 of CLA1
 */
#define CFG_CAL1_TASK8_TRIGGER_SRC      ( CLA_TRIG_TINT0 )      // See F2837xS_cla.h
#endif


#define CFG_CLA1                ( ( CFG_CLA1_TASK1 ) | \
                                  ( CFG_CLA1_TASK2 ) | \
                                  ( CFG_CLA1_TASK3 ) | \
                                  ( CFG_CLA1_TASK4 ) | \
                                  ( CFG_CLA1_TASK5 ) | \
                                  ( CFG_CLA1_TASK6 ) | \
                                  ( CFG_CLA1_TASK7 ) | \
                                  ( CFG_CLA1_TASK8 )   \
                                )

/*******************************************************************************
 * LSxMSEL Register, Page 433 TRM
 * -----------------------------------------------------------------------------
 * | 31    12 | 11    10 | 09    08 | 07    06 | 05    04 | 03    02 | 01    00 |
 * | RESERVED | MSEL_LS5 | MSEL_LS4 | MSEL_LS3 | MSEL_LS2 | MSEL_LS1 | MSEL_LS0 |
 * ------------------------------------------------------------------------------
 * MSEL_LSx : Master Select for LSx RAM:
 *            00: Memory is dedicated to CPU.
 *            01: Memory is shared between CPU and CLA1.
 *            10: Reserved.
 *            11: Reserved.
 */
#define CFG_LS0_MEMORY_SHARE            ( 1 )
#define CFG_LS1_MEMORY_SHARE            ( 1 )
#define CFG_LS2_MEMORY_SHARE            ( 2 )
#define CFG_LS3_MEMORY_SHARE            ( 3 )
#define CFG_LS4_MEMORY_SHARE            ( 0 )
#define CFG_LS5_MEMORY_SHARE            ( 0 )

/*******************************************************************************
 * LSxCLAPGM Register, Page 435 TRM
 * -----------------------------------------------------------------------------------------
 * | 31    06 |     05     |     04     |     03     |     02     |     01     |     00     |
 * | RESERVED | CLAPGM_LS5 | CLAPGM_LS4 | CLAPGM_LS3 | CLAPGM_LS2 | CLAPGM_LS1 | CLAPGM_LS0 |
 * ------------------------------------------------------------------------------------------
 * CLAPGM_LSx : Selects LSx RAM as program vs data memory for CLA:
 *              0: CLA Data memory.
 *              1: CLA Program memory.
 */
#define CFG_LSx_AS_DATA_MEMORY              ( 0 )
#define CFG_LSx_AS_PROGRAM_MEMORY           ( 1 )

#if(CFG_LS0_MEMORY_SHARE)
#define CFG_LS0_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_PROGRAM_MEMORY )
#endif

#if(CFG_LS1_MEMORY_SHARE)
#define CFG_LS1_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_PROGRAM_MEMORY )
#endif

#if(CFG_LS2_MEMORY_SHARE)
#define CFG_LS2_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_DATA_MEMORY )
#endif

#if(CFG_LS3_MEMORY_SHARE)
#define CFG_LS3_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_DATA_MEMORY )
#endif

#if(CFG_LS4_MEMORY_SHARE)
#define CFG_LS4_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_DATA_MEMORY )
#endif

#if(CFG_LS5_MEMORY_SHARE)
#define CFG_LS5_MEMORY_SHARE_TYPE           ( CFG_LSx_AS_DATA_MEMORY )
#endif


/*******************************************************************************
 * MIER Register, Page 807 TRM
 * Setting the bits in the interrupt enable register (MIER) allow an incoming
 * interrupt or main CPU software to start the corresponding CLA task.
 * Writing a 0 will block the task, but the interrupt request will still be
 * latched in the flag register (MIFLG). Setting the MIER register bit to 0
 * while the corresponding task is executing will have no effect on the task.
 * The task will continue to run until it hits the MSTOP instruction.
 * When a soft reset is issued, the MIER bits are cleared. There should always
 * be at least a 1 SYSCLKOUT delay between issuing the soft reset and
 * reconfiguring the MIER bits.
 * -----------------------------------------------------------------------------
 * | 15    08 |  07  |  06  |  05  |  04  |  03  |  02  |  01  |  00  |
 * | RESERVED | INT8 | INT7 | INT6 | INT5 | INT4 | INT3 | INT2 | INT1 |
 * -----------------------------------------------------------------------------
 */
#define CLA1_MIER_REG_VALUE                 (                   \
                                              ( 0 << 0 ) |       \
                                              ( 0 << 1 ) |      \
                                              ( 0 << 2 ) |      \
                                              ( 0 << 3 ) |      \
                                              ( 0 << 4 ) |      \
                                              ( 0 << 5 ) |      \
                                              ( 0 << 6 ) |      \
                                              ( 1 << 7 )        \
                                            )

#define CFG_CLA1_TASK1_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK1_CPU_INIT_EN )
extern cla1isr CAL1_Task1_ISR;
#endif

#define CFG_CLA1_TASK2_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK1_CPU_INIT_EN )
extern cla1isr CAL1_Task2_ISR;
#endif

#define CFG_CLA1_TASK3_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK3_CPU_INIT_EN )
extern cla1isr CAL1_Task3_ISR;
#endif

#define CFG_CLA1_TASK4_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK4_CPU_INIT_EN )
extern cla1isr CAL1_Task4_ISR;
#endif

#define CFG_CLA1_TASK5_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK5_CPU_INIT_EN )
extern cla1isr CAL1_Task5_ISR;
#endif

#define CFG_CLA1_TASK6_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK6_CPU_INIT_EN )
extern cla1isr CAL1_Task6_ISR;
#endif

#define CFG_CLA1_TASK7_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK7_CPU_INIT_EN )
extern cla1isr CAL1_Task7_ISR;
#endif

#define CFG_CLA1_TASK8_CPU_INIT_EN          ( 0 )
#if( CFG_CLA1_TASK8_CPU_INIT_EN )
extern cla1isr CAL1_Task8_ISR;
#endif

#define CFG_CLA1_TO_CPU_INIT                \
    (                                       \
        CFG_CLA1_TASK1_CPU_INIT_EN |        \
        CFG_CLA1_TASK2_CPU_INIT_EN |        \
        CFG_CLA1_TASK3_CPU_INIT_EN |        \
        CFG_CLA1_TASK4_CPU_INIT_EN |        \
        CFG_CLA1_TASK5_CPU_INIT_EN |        \
        CFG_CLA1_TASK6_CPU_INIT_EN |        \
        CFG_CLA1_TASK7_CPU_INIT_EN |        \
        CFG_CLA1_TASK8_CPU_INIT_EN          \
    )

#if( CFG_CLA1 )
void cla1cfg( void );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _CLA1CFG_H_ */
