/*
 * cputmrcfg.h
 */

#ifndef _CPUTMRCFG_H_
#define _CPUTMRCFG_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef void ( *cuptmrisr )( void );

#define CFG_CPUTMR0                 ( 1 )
#define CFG_CPUTMR1                 ( 0 )
#define CFG_CPUTMR1                 ( 0 )

#define CFG_CPUTMRs       ( ( CFG_CPUTMR0 ) | ( CFG_CPUTMR1 ) | ( CFG_CPUTMR2 ) )

#if(CFG_CPUTMR0)

#define CPUTMR0_PERI0D_US           ( 10L )

/*
 * The general operation of the CPU-Timer is as follows:
 *   The 32-bit counter register, TIMH:TIM, is loaded with the value in the
 *   period register PRDH:PRD
 *   The counter decrements once every ([TDDRH:TDDR] + 1) SYSCLKOUT cycles,
 *   where TDDRH:TDDR is the timer divider.
 *   When the counter reaches 0, a timer interrupt output signal generates
 *   an interrupt pulse.
 * SYSCLK = 200MHz
 * TIMER0 FREQUECNY = 100KHz
 *                   = 200,000,000  ( ( [TDDRH:TDDR] + 1 ) x [PRDH:PRD] )
 * ( ( [TDDRH:TDDR] + 1 ) x [PRDH:PRD] ) = 200,000,000  100,000
 *                                       = 2,000
 * ( ( [0:0] + 1 ) x ([0:2000])          = 2,000
 */
#define CPUTMR0_PRD_REG_VALUE           ( ( uint32_t )( 2000 ) )
#define CPUTMR0_TPR_REG_VALUE           ( ( uint32_t )( 0    ) )
#define CPUTMR0_TPRH_REG_VALUE          ( ( uint32_t )( 0    ) )

/*
 * TCR Register, Page 162
 * ========================================================================
 * |  16 |  15 | 13    12 |  11  |  10  | 09    06 |  05 |  04 | 03    00 |
 * | TIF | TIE | RESERVED | FREE | SOFT | RESERVED | TRB | TSS | RESERVED |
 * ------------------------------------------------------------------------
 * TIF : CPU-Timer Overflow Flag.
 *       TIF indicates whether a timer overflow has happened since TIF was
 *       last cleared. TIF is not cleared automatically and does not need to
 *       be cleared to enable the next timer interrupt.
 *       Writes of 0 are ignored.
 *       Writing a 1 to this bit clears the flag.
 *
 * TIE:  CPU-Timer Interrupt Enable.
 *       0h (R/W) = The CPU-Timer interrupt is disabled.
 *       1h (R/W) = The CPU-Timer interrupt is enabled. If the timer
 *                  decrements to zero, and TIE is set, the timer asserts its
 *                  interrupt request.
 *
 * FREE: If the FREE bit is set to 1, then, upon a software breakpoint, the
 *       timer continues to run. If FREE is 0, then the SOFT bit controls the
 *       emulation behavior.
 *       0h (R/W) = Stop after the next decrement of the TIMH:TIM (hard stop)
 *       (SOFT bit controls the emulation behavior)
 *       1h (R/W) = Free Run
 *       (SOFT bit is don't care, counter is free running)
 *
 * SOFT: If the FREE bit is set to 1, then, upon a software breakpoint, the
 *       timer continues to run (that is, free runs). In this case, SOFT is a
 *       don't care. But if FREE is 0, then SOFT takes effect.
 *       0h (R/W) = Stop after the next decrement of the TIMH:TIM (hard stop)
 *       (ONLY if FREE=0, if FREE=1 this bit is don't care)
 *       1h (R/W) = Stop after the TIMH:TIM decrements to 0 (soft stop)
 *       In the SOFT STOP mode, the timer generates an interrupt before
 *       shutting down (since reaching 0 is the interrupt causing condition).
 *       (ONLY if FREE=0, if FREE=1 this bit is don't care)
 *
 * TRB:  Timer reload
 *       Writes of 0 are ignored
 *       When you write a 1 to TRB, the TIMH:TIM is loaded with the value in the
 *       PRDH:PED, and the prescaler counter (PSCH:PSC) is loaded with the value
 *       in the timer divide down register (TDDRH:TDDR)
 *
 * TSS:  CPU-Timer stop status bit.
 *       0h (R/W) = Reads of 0 indicate the CPU-timer is running.
 *       To start or restart the CPU-timer, set TSS to 0. At reset, TSS is
 *       cleared to 0 and the CPU timer immediately starts.
 *       1h (R/W) = Reads of 1 indicate that the CPU-timer is stopped.
 *       To stop the CPU-timer, set TSS to 1.
 */
#define CPUTMR0_TCR_REG_VALUE     ( 1 << 14 )

extern cuptmrisr CPUTMR00isr;
uint32_t cputmr0value( void );

#endif

#if(CFG_CPUTMR1)

#endif

#if(CFG_CPUTMR2)

#endif

#if( CFG_CPUTMRs )
void cputmrcfg( void );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _CPUTMRCFG_H_ */
